/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sagemaker;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.sagemaker.CfnImageVersionProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnImageVersion")
public class CfnImageVersion
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnImageVersion.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnImageVersion(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnImageVersion(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnImageVersion(@NotNull Construct scope, @NotNull String id, @NotNull CfnImageVersionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrContainerImage() {
        return (String)Kernel.get((Object)this, (String)"attrContainerImage", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrImageArn() {
        return (String)Kernel.get((Object)this, (String)"attrImageArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrImageVersionArn() {
        return (String)Kernel.get((Object)this, (String)"attrImageVersionArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public Number getAttrVersion() {
        return (Number)Kernel.get((Object)this, (String)"attrVersion", (NativeType)NativeType.forClass(Number.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getBaseImage() {
        return (String)Kernel.get((Object)this, (String)"baseImage", (NativeType)NativeType.forClass(String.class));
    }

    public void setBaseImage(@NotNull String value) {
        Kernel.set((Object)this, (String)"baseImage", (Object)Objects.requireNonNull(value, "baseImage is required"));
    }

    @NotNull
    public String getImageName() {
        return (String)Kernel.get((Object)this, (String)"imageName", (NativeType)NativeType.forClass(String.class));
    }

    public void setImageName(@NotNull String value) {
        Kernel.set((Object)this, (String)"imageName", (Object)Objects.requireNonNull(value, "imageName is required"));
    }

    @Nullable
    public String getAlias() {
        return (String)Kernel.get((Object)this, (String)"alias", (NativeType)NativeType.forClass(String.class));
    }

    public void setAlias(@Nullable String value) {
        Kernel.set((Object)this, (String)"alias", (Object)value);
    }

    @Nullable
    public List<String> getAliases() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"aliases", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setAliases(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"aliases", value);
    }

    @Nullable
    public Object getHorovod() {
        return Kernel.get((Object)this, (String)"horovod", (NativeType)NativeType.forClass(Object.class));
    }

    public void setHorovod(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"horovod", (Object)value);
    }

    public void setHorovod(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"horovod", (Object)value);
    }

    @Nullable
    public String getJobType() {
        return (String)Kernel.get((Object)this, (String)"jobType", (NativeType)NativeType.forClass(String.class));
    }

    public void setJobType(@Nullable String value) {
        Kernel.set((Object)this, (String)"jobType", (Object)value);
    }

    @Nullable
    public String getMlFramework() {
        return (String)Kernel.get((Object)this, (String)"mlFramework", (NativeType)NativeType.forClass(String.class));
    }

    public void setMlFramework(@Nullable String value) {
        Kernel.set((Object)this, (String)"mlFramework", (Object)value);
    }

    @Nullable
    public String getProcessor() {
        return (String)Kernel.get((Object)this, (String)"processor", (NativeType)NativeType.forClass(String.class));
    }

    public void setProcessor(@Nullable String value) {
        Kernel.set((Object)this, (String)"processor", (Object)value);
    }

    @Nullable
    public String getProgrammingLang() {
        return (String)Kernel.get((Object)this, (String)"programmingLang", (NativeType)NativeType.forClass(String.class));
    }

    public void setProgrammingLang(@Nullable String value) {
        Kernel.set((Object)this, (String)"programmingLang", (Object)value);
    }

    @Nullable
    public String getReleaseNotes() {
        return (String)Kernel.get((Object)this, (String)"releaseNotes", (NativeType)NativeType.forClass(String.class));
    }

    public void setReleaseNotes(@Nullable String value) {
        Kernel.set((Object)this, (String)"releaseNotes", (Object)value);
    }

    @Nullable
    public String getVendorGuidance() {
        return (String)Kernel.get((Object)this, (String)"vendorGuidance", (NativeType)NativeType.forClass(String.class));
    }

    public void setVendorGuidance(@Nullable String value) {
        Kernel.set((Object)this, (String)"vendorGuidance", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnImageVersion> {
        private final Construct scope;
        private final String id;
        private final CfnImageVersionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnImageVersionProps.Builder();
        }

        public Builder baseImage(String baseImage) {
            this.props.baseImage(baseImage);
            return this;
        }

        public Builder imageName(String imageName) {
            this.props.imageName(imageName);
            return this;
        }

        public Builder alias(String alias) {
            this.props.alias(alias);
            return this;
        }

        public Builder aliases(List<String> aliases) {
            this.props.aliases(aliases);
            return this;
        }

        public Builder horovod(Boolean horovod) {
            this.props.horovod(horovod);
            return this;
        }

        public Builder horovod(IResolvable horovod) {
            this.props.horovod(horovod);
            return this;
        }

        public Builder jobType(String jobType) {
            this.props.jobType(jobType);
            return this;
        }

        public Builder mlFramework(String mlFramework) {
            this.props.mlFramework(mlFramework);
            return this;
        }

        public Builder processor(String processor) {
            this.props.processor(processor);
            return this;
        }

        public Builder programmingLang(String programmingLang) {
            this.props.programmingLang(programmingLang);
            return this;
        }

        public Builder releaseNotes(String releaseNotes) {
            this.props.releaseNotes(releaseNotes);
            return this;
        }

        public Builder vendorGuidance(String vendorGuidance) {
            this.props.vendorGuidance(vendorGuidance);
            return this;
        }

        public CfnImageVersion build() {
            return new CfnImageVersion(this.scope, this.id, this.props.build());
        }
    }
}

