/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.Size;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.stepfunctions.Credentials;
import software.amazon.awscdk.services.stepfunctions.IntegrationPattern;
import software.amazon.awscdk.services.stepfunctions.TaskMetricsConfig;
import software.amazon.awscdk.services.stepfunctions.TaskStateBase;
import software.amazon.awscdk.services.stepfunctions.Timeout;
import software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster;
import software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateClusterProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster")
public class EmrCreateCluster
extends TaskStateBase {
    protected EmrCreateCluster(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EmrCreateCluster(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public EmrCreateCluster(@NotNull Construct scope, @NotNull String id, @NotNull EmrCreateClusterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public IRole getAutoScalingRole() {
        return (IRole)Kernel.get((Object)this, (String)"autoScalingRole", (NativeType)NativeType.forClass(IRole.class));
    }

    @NotNull
    public IRole getClusterRole() {
        return (IRole)Kernel.get((Object)this, (String)"clusterRole", (NativeType)NativeType.forClass(IRole.class));
    }

    @NotNull
    public IRole getServiceRole() {
        return (IRole)Kernel.get((Object)this, (String)"serviceRole", (NativeType)NativeType.forClass(IRole.class));
    }

    @Override
    @Nullable
    protected TaskMetricsConfig getTaskMetrics() {
        return (TaskMetricsConfig)Kernel.get((Object)this, (String)"taskMetrics", (NativeType)NativeType.forClass(TaskMetricsConfig.class));
    }

    @Override
    @Nullable
    protected List<PolicyStatement> getTaskPolicies() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"taskPolicies", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(PolicyStatement.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<EmrCreateCluster> {
        private final Construct scope;
        private final String id;
        private final EmrCreateClusterProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new EmrCreateClusterProps.Builder();
        }

        public Builder comment(String comment) {
            this.props.comment(comment);
            return this;
        }

        public Builder credentials(Credentials credentials) {
            this.props.credentials(credentials);
            return this;
        }

        @Deprecated
        public Builder heartbeat(Duration heartbeat) {
            this.props.heartbeat(heartbeat);
            return this;
        }

        public Builder heartbeatTimeout(Timeout heartbeatTimeout) {
            this.props.heartbeatTimeout(heartbeatTimeout);
            return this;
        }

        public Builder inputPath(String inputPath) {
            this.props.inputPath(inputPath);
            return this;
        }

        public Builder integrationPattern(IntegrationPattern integrationPattern) {
            this.props.integrationPattern(integrationPattern);
            return this;
        }

        public Builder outputPath(String outputPath) {
            this.props.outputPath(outputPath);
            return this;
        }

        public Builder resultPath(String resultPath) {
            this.props.resultPath(resultPath);
            return this;
        }

        public Builder resultSelector(Map<String, ? extends Object> resultSelector) {
            this.props.resultSelector(resultSelector);
            return this;
        }

        public Builder stateName(String stateName) {
            this.props.stateName(stateName);
            return this;
        }

        public Builder taskTimeout(Timeout taskTimeout) {
            this.props.taskTimeout(taskTimeout);
            return this;
        }

        @Deprecated
        public Builder timeout(Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        public Builder instances(InstancesConfigProperty instances) {
            this.props.instances(instances);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder additionalInfo(String additionalInfo) {
            this.props.additionalInfo(additionalInfo);
            return this;
        }

        public Builder applications(List<? extends ApplicationConfigProperty> applications) {
            this.props.applications(applications);
            return this;
        }

        public Builder autoScalingRole(IRole autoScalingRole) {
            this.props.autoScalingRole(autoScalingRole);
            return this;
        }

        public Builder bootstrapActions(List<? extends BootstrapActionConfigProperty> bootstrapActions) {
            this.props.bootstrapActions(bootstrapActions);
            return this;
        }

        public Builder clusterRole(IRole clusterRole) {
            this.props.clusterRole(clusterRole);
            return this;
        }

        public Builder configurations(List<? extends ConfigurationProperty> configurations) {
            this.props.configurations(configurations);
            return this;
        }

        public Builder customAmiId(String customAmiId) {
            this.props.customAmiId(customAmiId);
            return this;
        }

        public Builder ebsRootVolumeSize(Size ebsRootVolumeSize) {
            this.props.ebsRootVolumeSize(ebsRootVolumeSize);
            return this;
        }

        public Builder kerberosAttributes(KerberosAttributesProperty kerberosAttributes) {
            this.props.kerberosAttributes(kerberosAttributes);
            return this;
        }

        public Builder logUri(String logUri) {
            this.props.logUri(logUri);
            return this;
        }

        public Builder releaseLabel(String releaseLabel) {
            this.props.releaseLabel(releaseLabel);
            return this;
        }

        public Builder scaleDownBehavior(EmrClusterScaleDownBehavior scaleDownBehavior) {
            this.props.scaleDownBehavior(scaleDownBehavior);
            return this;
        }

        public Builder securityConfiguration(String securityConfiguration) {
            this.props.securityConfiguration(securityConfiguration);
            return this;
        }

        public Builder serviceRole(IRole serviceRole) {
            this.props.serviceRole(serviceRole);
            return this;
        }

        public Builder stepConcurrencyLevel(Number stepConcurrencyLevel) {
            this.props.stepConcurrencyLevel(stepConcurrencyLevel);
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder visibleToAllUsers(Boolean visibleToAllUsers) {
            this.props.visibleToAllUsers(visibleToAllUsers);
            return this;
        }

        public EmrCreateCluster build() {
            return new EmrCreateCluster(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster.VolumeSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VolumeSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public Size getVolumeSize();

        @NotNull
        public EbsBlockDeviceVolumeType getVolumeType();

        @Nullable
        default public Number getIops() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VolumeSpecificationProperty> {
            Size volumeSize;
            EbsBlockDeviceVolumeType volumeType;
            Number iops;

            public Builder volumeSize(Size volumeSize) {
                this.volumeSize = volumeSize;
                return this;
            }

            public Builder volumeType(EbsBlockDeviceVolumeType volumeType) {
                this.volumeType = volumeType;
                return this;
            }

            public Builder iops(Number iops) {
                this.iops = iops;
                return this;
            }

            public VolumeSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster.SpotTimeoutAction")
    public static enum SpotTimeoutAction {
        SWITCH_TO_ON_DEMAND,
        TERMINATE_CLUSTER;

    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster.SpotProvisioningSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SpotProvisioningSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public SpotTimeoutAction getTimeoutAction();

        @NotNull
        public Number getTimeoutDurationMinutes();

        @Nullable
        default public SpotAllocationStrategy getAllocationStrategy() {
            return null;
        }

        @Nullable
        default public Number getBlockDurationMinutes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SpotProvisioningSpecificationProperty> {
            SpotTimeoutAction timeoutAction;
            Number timeoutDurationMinutes;
            SpotAllocationStrategy allocationStrategy;
            Number blockDurationMinutes;

            public Builder timeoutAction(SpotTimeoutAction timeoutAction) {
                this.timeoutAction = timeoutAction;
                return this;
            }

            public Builder timeoutDurationMinutes(Number timeoutDurationMinutes) {
                this.timeoutDurationMinutes = timeoutDurationMinutes;
                return this;
            }

            public Builder allocationStrategy(SpotAllocationStrategy allocationStrategy) {
                this.allocationStrategy = allocationStrategy;
                return this;
            }

            public Builder blockDurationMinutes(Number blockDurationMinutes) {
                this.blockDurationMinutes = blockDurationMinutes;
                return this;
            }

            public SpotProvisioningSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster.SpotAllocationStrategy")
    public static enum SpotAllocationStrategy {
        CAPACITY_OPTIMIZED;

    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster.SimpleScalingPolicyConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SimpleScalingPolicyConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Number getScalingAdjustment();

        @Nullable
        default public ScalingAdjustmentType getAdjustmentType() {
            return null;
        }

        @Nullable
        default public Number getCoolDown() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SimpleScalingPolicyConfigurationProperty> {
            Number scalingAdjustment;
            ScalingAdjustmentType adjustmentType;
            Number coolDown;

            public Builder scalingAdjustment(Number scalingAdjustment) {
                this.scalingAdjustment = scalingAdjustment;
                return this;
            }

            public Builder adjustmentType(ScalingAdjustmentType adjustmentType) {
                this.adjustmentType = adjustmentType;
                return this;
            }

            public Builder coolDown(Number coolDown) {
                this.coolDown = coolDown;
                return this;
            }

            public SimpleScalingPolicyConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster.ScriptBootstrapActionConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScriptBootstrapActionConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getPath();

        @Nullable
        default public List<String> getArgs() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScriptBootstrapActionConfigProperty> {
            String path;
            List<String> args;

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public Builder args(List<String> args) {
                this.args = args;
                return this;
            }

            public ScriptBootstrapActionConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster.ScalingTriggerProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScalingTriggerProperty
    extends JsiiSerializable {
        @NotNull
        public CloudWatchAlarmDefinitionProperty getCloudWatchAlarmDefinition();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScalingTriggerProperty> {
            CloudWatchAlarmDefinitionProperty cloudWatchAlarmDefinition;

            public Builder cloudWatchAlarmDefinition(CloudWatchAlarmDefinitionProperty cloudWatchAlarmDefinition) {
                this.cloudWatchAlarmDefinition = cloudWatchAlarmDefinition;
                return this;
            }

            public ScalingTriggerProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster.ScalingRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScalingRuleProperty
    extends JsiiSerializable {
        @NotNull
        public ScalingActionProperty getAction();

        @NotNull
        public String getName();

        @NotNull
        public ScalingTriggerProperty getTrigger();

        @Nullable
        default public String getDescription() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScalingRuleProperty> {
            ScalingActionProperty action;
            String name;
            ScalingTriggerProperty trigger;
            String description;

            public Builder action(ScalingActionProperty action) {
                this.action = action;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder trigger(ScalingTriggerProperty trigger) {
                this.trigger = trigger;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public ScalingRuleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster.ScalingConstraintsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScalingConstraintsProperty
    extends JsiiSerializable {
        @NotNull
        public Number getMaxCapacity();

        @NotNull
        public Number getMinCapacity();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScalingConstraintsProperty> {
            Number maxCapacity;
            Number minCapacity;

            public Builder maxCapacity(Number maxCapacity) {
                this.maxCapacity = maxCapacity;
                return this;
            }

            public Builder minCapacity(Number minCapacity) {
                this.minCapacity = minCapacity;
                return this;
            }

            public ScalingConstraintsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster.ScalingAdjustmentType")
    public static enum ScalingAdjustmentType {
        CHANGE_IN_CAPACITY,
        PERCENT_CHANGE_IN_CAPACITY,
        EXACT_CAPACITY;

    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster.ScalingActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScalingActionProperty
    extends JsiiSerializable {
        @NotNull
        public SimpleScalingPolicyConfigurationProperty getSimpleScalingPolicyConfiguration();

        @Nullable
        default public InstanceMarket getMarket() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScalingActionProperty> {
            SimpleScalingPolicyConfigurationProperty simpleScalingPolicyConfiguration;
            InstanceMarket market;

            public Builder simpleScalingPolicyConfiguration(SimpleScalingPolicyConfigurationProperty simpleScalingPolicyConfiguration) {
                this.simpleScalingPolicyConfiguration = simpleScalingPolicyConfiguration;
                return this;
            }

            public Builder market(InstanceMarket market) {
                this.market = market;
                return this;
            }

            public ScalingActionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster.PlacementTypeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PlacementTypeProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAvailabilityZone() {
            return null;
        }

        @Nullable
        default public List<String> getAvailabilityZones() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PlacementTypeProperty> {
            String availabilityZone;
            List<String> availabilityZones;

            public Builder availabilityZone(String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            public Builder availabilityZones(List<String> availabilityZones) {
                this.availabilityZones = availabilityZones;
                return this;
            }

            public PlacementTypeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster.MetricDimensionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MetricDimensionProperty
    extends JsiiSerializable {
        @NotNull
        public String getKey();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MetricDimensionProperty> {
            String key;
            String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public MetricDimensionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster.KerberosAttributesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KerberosAttributesProperty
    extends JsiiSerializable {
        @NotNull
        public String getRealm();

        @Nullable
        default public String getAdDomainJoinPassword() {
            return null;
        }

        @Nullable
        default public String getAdDomainJoinUser() {
            return null;
        }

        @Nullable
        default public String getCrossRealmTrustPrincipalPassword() {
            return null;
        }

        @Nullable
        default public String getKdcAdminPassword() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KerberosAttributesProperty> {
            String realm;
            String adDomainJoinPassword;
            String adDomainJoinUser;
            String crossRealmTrustPrincipalPassword;
            String kdcAdminPassword;

            public Builder realm(String realm) {
                this.realm = realm;
                return this;
            }

            public Builder adDomainJoinPassword(String adDomainJoinPassword) {
                this.adDomainJoinPassword = adDomainJoinPassword;
                return this;
            }

            public Builder adDomainJoinUser(String adDomainJoinUser) {
                this.adDomainJoinUser = adDomainJoinUser;
                return this;
            }

            public Builder crossRealmTrustPrincipalPassword(String crossRealmTrustPrincipalPassword) {
                this.crossRealmTrustPrincipalPassword = crossRealmTrustPrincipalPassword;
                return this;
            }

            public Builder kdcAdminPassword(String kdcAdminPassword) {
                this.kdcAdminPassword = kdcAdminPassword;
                return this;
            }

            public KerberosAttributesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster.InstancesConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InstancesConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getAdditionalMasterSecurityGroups() {
            return null;
        }

        @Nullable
        default public List<String> getAdditionalSlaveSecurityGroups() {
            return null;
        }

        @Nullable
        default public String getEc2KeyName() {
            return null;
        }

        @Nullable
        default public String getEc2SubnetId() {
            return null;
        }

        @Nullable
        default public List<String> getEc2SubnetIds() {
            return null;
        }

        @Nullable
        default public String getEmrManagedMasterSecurityGroup() {
            return null;
        }

        @Nullable
        default public String getEmrManagedSlaveSecurityGroup() {
            return null;
        }

        @Nullable
        default public String getHadoopVersion() {
            return null;
        }

        @Nullable
        default public Number getInstanceCount() {
            return null;
        }

        @Nullable
        default public List<InstanceFleetConfigProperty> getInstanceFleets() {
            return null;
        }

        @Nullable
        default public List<InstanceGroupConfigProperty> getInstanceGroups() {
            return null;
        }

        @Nullable
        default public String getMasterInstanceType() {
            return null;
        }

        @Nullable
        default public PlacementTypeProperty getPlacement() {
            return null;
        }

        @Nullable
        default public String getServiceAccessSecurityGroup() {
            return null;
        }

        @Nullable
        default public String getSlaveInstanceType() {
            return null;
        }

        @Nullable
        default public Boolean getTerminationProtected() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InstancesConfigProperty> {
            List<String> additionalMasterSecurityGroups;
            List<String> additionalSlaveSecurityGroups;
            String ec2KeyName;
            String ec2SubnetId;
            List<String> ec2SubnetIds;
            String emrManagedMasterSecurityGroup;
            String emrManagedSlaveSecurityGroup;
            String hadoopVersion;
            Number instanceCount;
            List<InstanceFleetConfigProperty> instanceFleets;
            List<InstanceGroupConfigProperty> instanceGroups;
            String masterInstanceType;
            PlacementTypeProperty placement;
            String serviceAccessSecurityGroup;
            String slaveInstanceType;
            Boolean terminationProtected;

            public Builder additionalMasterSecurityGroups(List<String> additionalMasterSecurityGroups) {
                this.additionalMasterSecurityGroups = additionalMasterSecurityGroups;
                return this;
            }

            public Builder additionalSlaveSecurityGroups(List<String> additionalSlaveSecurityGroups) {
                this.additionalSlaveSecurityGroups = additionalSlaveSecurityGroups;
                return this;
            }

            public Builder ec2KeyName(String ec2KeyName) {
                this.ec2KeyName = ec2KeyName;
                return this;
            }

            public Builder ec2SubnetId(String ec2SubnetId) {
                this.ec2SubnetId = ec2SubnetId;
                return this;
            }

            public Builder ec2SubnetIds(List<String> ec2SubnetIds) {
                this.ec2SubnetIds = ec2SubnetIds;
                return this;
            }

            public Builder emrManagedMasterSecurityGroup(String emrManagedMasterSecurityGroup) {
                this.emrManagedMasterSecurityGroup = emrManagedMasterSecurityGroup;
                return this;
            }

            public Builder emrManagedSlaveSecurityGroup(String emrManagedSlaveSecurityGroup) {
                this.emrManagedSlaveSecurityGroup = emrManagedSlaveSecurityGroup;
                return this;
            }

            public Builder hadoopVersion(String hadoopVersion) {
                this.hadoopVersion = hadoopVersion;
                return this;
            }

            public Builder instanceCount(Number instanceCount) {
                this.instanceCount = instanceCount;
                return this;
            }

            public Builder instanceFleets(List<? extends InstanceFleetConfigProperty> instanceFleets) {
                this.instanceFleets = instanceFleets;
                return this;
            }

            public Builder instanceGroups(List<? extends InstanceGroupConfigProperty> instanceGroups) {
                this.instanceGroups = instanceGroups;
                return this;
            }

            public Builder masterInstanceType(String masterInstanceType) {
                this.masterInstanceType = masterInstanceType;
                return this;
            }

            public Builder placement(PlacementTypeProperty placement) {
                this.placement = placement;
                return this;
            }

            public Builder serviceAccessSecurityGroup(String serviceAccessSecurityGroup) {
                this.serviceAccessSecurityGroup = serviceAccessSecurityGroup;
                return this;
            }

            public Builder slaveInstanceType(String slaveInstanceType) {
                this.slaveInstanceType = slaveInstanceType;
                return this;
            }

            public Builder terminationProtected(Boolean terminationProtected) {
                this.terminationProtected = terminationProtected;
                return this;
            }

            public InstancesConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster.InstanceTypeConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InstanceTypeConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getInstanceType();

        @Nullable
        default public String getBidPrice() {
            return null;
        }

        @Nullable
        default public Number getBidPriceAsPercentageOfOnDemandPrice() {
            return null;
        }

        @Nullable
        default public List<ConfigurationProperty> getConfigurations() {
            return null;
        }

        @Nullable
        default public EbsConfigurationProperty getEbsConfiguration() {
            return null;
        }

        @Nullable
        default public Number getWeightedCapacity() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InstanceTypeConfigProperty> {
            String instanceType;
            String bidPrice;
            Number bidPriceAsPercentageOfOnDemandPrice;
            List<ConfigurationProperty> configurations;
            EbsConfigurationProperty ebsConfiguration;
            Number weightedCapacity;

            public Builder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            public Builder bidPrice(String bidPrice) {
                this.bidPrice = bidPrice;
                return this;
            }

            public Builder bidPriceAsPercentageOfOnDemandPrice(Number bidPriceAsPercentageOfOnDemandPrice) {
                this.bidPriceAsPercentageOfOnDemandPrice = bidPriceAsPercentageOfOnDemandPrice;
                return this;
            }

            public Builder configurations(List<? extends ConfigurationProperty> configurations) {
                this.configurations = configurations;
                return this;
            }

            public Builder ebsConfiguration(EbsConfigurationProperty ebsConfiguration) {
                this.ebsConfiguration = ebsConfiguration;
                return this;
            }

            public Builder weightedCapacity(Number weightedCapacity) {
                this.weightedCapacity = weightedCapacity;
                return this;
            }

            public InstanceTypeConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster.InstanceRoleType")
    public static enum InstanceRoleType {
        MASTER,
        CORE,
        TASK;

    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster.InstanceMarket")
    public static enum InstanceMarket {
        ON_DEMAND,
        SPOT;

    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster.InstanceGroupConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InstanceGroupConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Number getInstanceCount();

        @NotNull
        public InstanceRoleType getInstanceRole();

        @NotNull
        public String getInstanceType();

        @Nullable
        default public AutoScalingPolicyProperty getAutoScalingPolicy() {
            return null;
        }

        @Nullable
        default public String getBidPrice() {
            return null;
        }

        @Nullable
        default public List<ConfigurationProperty> getConfigurations() {
            return null;
        }

        @Nullable
        default public EbsConfigurationProperty getEbsConfiguration() {
            return null;
        }

        @Nullable
        default public InstanceMarket getMarket() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InstanceGroupConfigProperty> {
            Number instanceCount;
            InstanceRoleType instanceRole;
            String instanceType;
            AutoScalingPolicyProperty autoScalingPolicy;
            String bidPrice;
            List<ConfigurationProperty> configurations;
            EbsConfigurationProperty ebsConfiguration;
            InstanceMarket market;
            String name;

            public Builder instanceCount(Number instanceCount) {
                this.instanceCount = instanceCount;
                return this;
            }

            public Builder instanceRole(InstanceRoleType instanceRole) {
                this.instanceRole = instanceRole;
                return this;
            }

            public Builder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            public Builder autoScalingPolicy(AutoScalingPolicyProperty autoScalingPolicy) {
                this.autoScalingPolicy = autoScalingPolicy;
                return this;
            }

            public Builder bidPrice(String bidPrice) {
                this.bidPrice = bidPrice;
                return this;
            }

            public Builder configurations(List<? extends ConfigurationProperty> configurations) {
                this.configurations = configurations;
                return this;
            }

            public Builder ebsConfiguration(EbsConfigurationProperty ebsConfiguration) {
                this.ebsConfiguration = ebsConfiguration;
                return this;
            }

            public Builder market(InstanceMarket market) {
                this.market = market;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public InstanceGroupConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster.InstanceFleetProvisioningSpecificationsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InstanceFleetProvisioningSpecificationsProperty
    extends JsiiSerializable {
        @NotNull
        public SpotProvisioningSpecificationProperty getSpotSpecification();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InstanceFleetProvisioningSpecificationsProperty> {
            SpotProvisioningSpecificationProperty spotSpecification;

            public Builder spotSpecification(SpotProvisioningSpecificationProperty spotSpecification) {
                this.spotSpecification = spotSpecification;
                return this;
            }

            public InstanceFleetProvisioningSpecificationsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster.InstanceFleetConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InstanceFleetConfigProperty
    extends JsiiSerializable {
        @NotNull
        public InstanceRoleType getInstanceFleetType();

        @Nullable
        default public List<InstanceTypeConfigProperty> getInstanceTypeConfigs() {
            return null;
        }

        @Nullable
        default public InstanceFleetProvisioningSpecificationsProperty getLaunchSpecifications() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public Number getTargetOnDemandCapacity() {
            return null;
        }

        @Nullable
        default public Number getTargetSpotCapacity() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InstanceFleetConfigProperty> {
            InstanceRoleType instanceFleetType;
            List<InstanceTypeConfigProperty> instanceTypeConfigs;
            InstanceFleetProvisioningSpecificationsProperty launchSpecifications;
            String name;
            Number targetOnDemandCapacity;
            Number targetSpotCapacity;

            public Builder instanceFleetType(InstanceRoleType instanceFleetType) {
                this.instanceFleetType = instanceFleetType;
                return this;
            }

            public Builder instanceTypeConfigs(List<? extends InstanceTypeConfigProperty> instanceTypeConfigs) {
                this.instanceTypeConfigs = instanceTypeConfigs;
                return this;
            }

            public Builder launchSpecifications(InstanceFleetProvisioningSpecificationsProperty launchSpecifications) {
                this.launchSpecifications = launchSpecifications;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder targetOnDemandCapacity(Number targetOnDemandCapacity) {
                this.targetOnDemandCapacity = targetOnDemandCapacity;
                return this;
            }

            public Builder targetSpotCapacity(Number targetSpotCapacity) {
                this.targetSpotCapacity = targetSpotCapacity;
                return this;
            }

            public InstanceFleetConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster.EmrClusterScaleDownBehavior")
    public static enum EmrClusterScaleDownBehavior {
        TERMINATE_AT_INSTANCE_HOUR,
        TERMINATE_AT_TASK_COMPLETION;

    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster.EbsConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EbsConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public List<EbsBlockDeviceConfigProperty> getEbsBlockDeviceConfigs() {
            return null;
        }

        @Nullable
        default public Boolean getEbsOptimized() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EbsConfigurationProperty> {
            List<EbsBlockDeviceConfigProperty> ebsBlockDeviceConfigs;
            Boolean ebsOptimized;

            public Builder ebsBlockDeviceConfigs(List<? extends EbsBlockDeviceConfigProperty> ebsBlockDeviceConfigs) {
                this.ebsBlockDeviceConfigs = ebsBlockDeviceConfigs;
                return this;
            }

            public Builder ebsOptimized(Boolean ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            public EbsConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster.EbsBlockDeviceVolumeType")
    public static enum EbsBlockDeviceVolumeType {
        GP2,
        IO1,
        STANDARD;

    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster.EbsBlockDeviceConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EbsBlockDeviceConfigProperty
    extends JsiiSerializable {
        @NotNull
        public VolumeSpecificationProperty getVolumeSpecification();

        @Nullable
        default public Number getVolumesPerInstance() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EbsBlockDeviceConfigProperty> {
            VolumeSpecificationProperty volumeSpecification;
            Number volumesPerInstance;

            public Builder volumeSpecification(VolumeSpecificationProperty volumeSpecification) {
                this.volumeSpecification = volumeSpecification;
                return this;
            }

            public Builder volumesPerInstance(Number volumesPerInstance) {
                this.volumesPerInstance = volumesPerInstance;
                return this;
            }

            public EbsBlockDeviceConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster.ConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getClassification() {
            return null;
        }

        @Nullable
        default public List<ConfigurationProperty> getConfigurations() {
            return null;
        }

        @Nullable
        default public Map<String, String> getProperties() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConfigurationProperty> {
            String classification;
            List<ConfigurationProperty> configurations;
            Map<String, String> properties;

            public Builder classification(String classification) {
                this.classification = classification;
                return this;
            }

            public Builder configurations(List<? extends ConfigurationProperty> configurations) {
                this.configurations = configurations;
                return this;
            }

            public Builder properties(Map<String, String> properties) {
                this.properties = properties;
                return this;
            }

            public ConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster.CloudWatchAlarmUnit")
    public static enum CloudWatchAlarmUnit {
        NONE,
        SECONDS,
        MICRO_SECONDS,
        MILLI_SECONDS,
        BYTES,
        KILO_BYTES,
        MEGA_BYTES,
        GIGA_BYTES,
        TERA_BYTES,
        BITS,
        KILO_BITS,
        MEGA_BITS,
        GIGA_BITS,
        TERA_BITS,
        PERCENT,
        COUNT,
        BYTES_PER_SECOND,
        KILO_BYTES_PER_SECOND,
        MEGA_BYTES_PER_SECOND,
        GIGA_BYTES_PER_SECOND,
        TERA_BYTES_PER_SECOND,
        BITS_PER_SECOND,
        KILO_BITS_PER_SECOND,
        MEGA_BITS_PER_SECOND,
        GIGA_BITS_PER_SECOND,
        TERA_BITS_PER_SECOND,
        COUNT_PER_SECOND;

    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster.CloudWatchAlarmStatistic")
    public static enum CloudWatchAlarmStatistic {
        SAMPLE_COUNT,
        AVERAGE,
        SUM,
        MINIMUM,
        MAXIMUM;

    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster.CloudWatchAlarmDefinitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CloudWatchAlarmDefinitionProperty
    extends JsiiSerializable {
        @NotNull
        public CloudWatchAlarmComparisonOperator getComparisonOperator();

        @NotNull
        public String getMetricName();

        @NotNull
        public Duration getPeriod();

        @Nullable
        default public List<MetricDimensionProperty> getDimensions() {
            return null;
        }

        @Nullable
        default public Number getEvaluationPeriods() {
            return null;
        }

        @Nullable
        default public String getNamespace() {
            return null;
        }

        @Nullable
        default public CloudWatchAlarmStatistic getStatistic() {
            return null;
        }

        @Nullable
        default public Number getThreshold() {
            return null;
        }

        @Nullable
        default public CloudWatchAlarmUnit getUnit() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CloudWatchAlarmDefinitionProperty> {
            CloudWatchAlarmComparisonOperator comparisonOperator;
            String metricName;
            Duration period;
            List<MetricDimensionProperty> dimensions;
            Number evaluationPeriods;
            String namespace;
            CloudWatchAlarmStatistic statistic;
            Number threshold;
            CloudWatchAlarmUnit unit;

            public Builder comparisonOperator(CloudWatchAlarmComparisonOperator comparisonOperator) {
                this.comparisonOperator = comparisonOperator;
                return this;
            }

            public Builder metricName(String metricName) {
                this.metricName = metricName;
                return this;
            }

            public Builder period(Duration period) {
                this.period = period;
                return this;
            }

            public Builder dimensions(List<? extends MetricDimensionProperty> dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            public Builder evaluationPeriods(Number evaluationPeriods) {
                this.evaluationPeriods = evaluationPeriods;
                return this;
            }

            public Builder namespace(String namespace) {
                this.namespace = namespace;
                return this;
            }

            public Builder statistic(CloudWatchAlarmStatistic statistic) {
                this.statistic = statistic;
                return this;
            }

            public Builder threshold(Number threshold) {
                this.threshold = threshold;
                return this;
            }

            public Builder unit(CloudWatchAlarmUnit unit) {
                this.unit = unit;
                return this;
            }

            public CloudWatchAlarmDefinitionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster.CloudWatchAlarmComparisonOperator")
    public static enum CloudWatchAlarmComparisonOperator {
        GREATER_THAN_OR_EQUAL,
        GREATER_THAN,
        LESS_THAN,
        LESS_THAN_OR_EQUAL;

    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster.BootstrapActionConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BootstrapActionConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public ScriptBootstrapActionConfigProperty getScriptBootstrapAction();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BootstrapActionConfigProperty> {
            String name;
            ScriptBootstrapActionConfigProperty scriptBootstrapAction;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder scriptBootstrapAction(ScriptBootstrapActionConfigProperty scriptBootstrapAction) {
                this.scriptBootstrapAction = scriptBootstrapAction;
                return this;
            }

            public BootstrapActionConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster.AutoScalingPolicyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AutoScalingPolicyProperty
    extends JsiiSerializable {
        @NotNull
        public ScalingConstraintsProperty getConstraints();

        @NotNull
        public List<ScalingRuleProperty> getRules();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AutoScalingPolicyProperty> {
            ScalingConstraintsProperty constraints;
            List<ScalingRuleProperty> rules;

            public Builder constraints(ScalingConstraintsProperty constraints) {
                this.constraints = constraints;
                return this;
            }

            public Builder rules(List<? extends ScalingRuleProperty> rules) {
                this.rules = rules;
                return this;
            }

            public AutoScalingPolicyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateCluster.ApplicationConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ApplicationConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @Nullable
        default public Map<String, String> getAdditionalInfo() {
            return null;
        }

        @Nullable
        default public List<String> getArgs() {
            return null;
        }

        @Nullable
        default public String getVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ApplicationConfigProperty> {
            String name;
            Map<String, String> additionalInfo;
            List<String> args;
            String version;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder additionalInfo(Map<String, String> additionalInfo) {
                this.additionalInfo = additionalInfo;
                return this;
            }

            public Builder args(List<String> args) {
                this.args = args;
                return this;
            }

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public ApplicationConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

