/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.transfer;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.transfer.CfnWorkflow;
import software.amazon.awscdk.services.transfer.CfnWorkflowProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_transfer.CfnWorkflow")
public class CfnWorkflow
extends CfnResource
implements IInspectable,
ITaggable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnWorkflow.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnWorkflow(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnWorkflow(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnWorkflow(@NotNull Construct scope, @NotNull String id, @NotNull CfnWorkflowProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrWorkflowId() {
        return (String)Kernel.get((Object)this, (String)"attrWorkflowId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public Object getSteps() {
        return Kernel.get((Object)this, (String)"steps", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSteps(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"steps", (Object)Objects.requireNonNull(value, "steps is required"));
    }

    public void setSteps(@NotNull List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof WorkflowStepProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.transfer.CfnWorkflow.WorkflowStepProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"steps", Objects.requireNonNull(value, "steps is required"));
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public Object getOnExceptionSteps() {
        return Kernel.get((Object)this, (String)"onExceptionSteps", (NativeType)NativeType.forClass(Object.class));
    }

    public void setOnExceptionSteps(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"onExceptionSteps", (Object)value);
    }

    public void setOnExceptionSteps(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof WorkflowStepProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.transfer.CfnWorkflow.WorkflowStepProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"onExceptionSteps", value);
    }

    @Nullable
    public List<CfnTag> getTagsRaw() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tagsRaw", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTagsRaw(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tagsRaw", value);
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_transfer.CfnWorkflow.WorkflowStepProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WorkflowStepProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCopyStepDetails() {
            return null;
        }

        @Nullable
        default public Object getCustomStepDetails() {
            return null;
        }

        @Nullable
        default public Object getDecryptStepDetails() {
            return null;
        }

        @Nullable
        default public Object getDeleteStepDetails() {
            return null;
        }

        @Nullable
        default public Object getTagStepDetails() {
            return null;
        }

        @Nullable
        default public String getType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WorkflowStepProperty> {
            Object copyStepDetails;
            Object customStepDetails;
            Object decryptStepDetails;
            Object deleteStepDetails;
            Object tagStepDetails;
            String type;

            public Builder copyStepDetails(Object copyStepDetails) {
                this.copyStepDetails = copyStepDetails;
                return this;
            }

            public Builder customStepDetails(Object customStepDetails) {
                this.customStepDetails = customStepDetails;
                return this;
            }

            public Builder decryptStepDetails(IResolvable decryptStepDetails) {
                this.decryptStepDetails = decryptStepDetails;
                return this;
            }

            public Builder decryptStepDetails(DecryptStepDetailsProperty decryptStepDetails) {
                this.decryptStepDetails = decryptStepDetails;
                return this;
            }

            public Builder deleteStepDetails(Object deleteStepDetails) {
                this.deleteStepDetails = deleteStepDetails;
                return this;
            }

            public Builder tagStepDetails(Object tagStepDetails) {
                this.tagStepDetails = tagStepDetails;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public WorkflowStepProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnWorkflow> {
        private final Construct scope;
        private final String id;
        private final CfnWorkflowProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnWorkflowProps.Builder();
        }

        public Builder steps(IResolvable steps) {
            this.props.steps(steps);
            return this;
        }

        public Builder steps(List<? extends Object> steps) {
            this.props.steps(steps);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder onExceptionSteps(IResolvable onExceptionSteps) {
            this.props.onExceptionSteps(onExceptionSteps);
            return this;
        }

        public Builder onExceptionSteps(List<? extends Object> onExceptionSteps) {
            this.props.onExceptionSteps(onExceptionSteps);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnWorkflow build() {
            return new CfnWorkflow(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_transfer.CfnWorkflow.TagStepDetailsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TagStepDetailsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public String getSourceFileLocation() {
            return null;
        }

        @Nullable
        default public List<S3TagProperty> getTags() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TagStepDetailsProperty> {
            String name;
            String sourceFileLocation;
            List<S3TagProperty> tags;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder sourceFileLocation(String sourceFileLocation) {
                this.sourceFileLocation = sourceFileLocation;
                return this;
            }

            public Builder tags(List<? extends S3TagProperty> tags) {
                this.tags = tags;
                return this;
            }

            public TagStepDetailsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_transfer.CfnWorkflow.S3TagProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3TagProperty
    extends JsiiSerializable {
        @NotNull
        public String getKey();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3TagProperty> {
            String key;
            String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public S3TagProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_transfer.CfnWorkflow.S3InputFileLocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3InputFileLocationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getBucket() {
            return null;
        }

        @Nullable
        default public String getKey() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3InputFileLocationProperty> {
            String bucket;
            String key;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public S3InputFileLocationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_transfer.CfnWorkflow.S3FileLocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3FileLocationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getS3FileLocation() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3FileLocationProperty> {
            Object s3FileLocation;

            public Builder s3FileLocation(IResolvable s3FileLocation) {
                this.s3FileLocation = s3FileLocation;
                return this;
            }

            public Builder s3FileLocation(S3InputFileLocationProperty s3FileLocation) {
                this.s3FileLocation = s3FileLocation;
                return this;
            }

            public S3FileLocationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_transfer.CfnWorkflow.InputFileLocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InputFileLocationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEfsFileLocation() {
            return null;
        }

        @Nullable
        default public Object getS3FileLocation() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InputFileLocationProperty> {
            Object efsFileLocation;
            Object s3FileLocation;

            public Builder efsFileLocation(IResolvable efsFileLocation) {
                this.efsFileLocation = efsFileLocation;
                return this;
            }

            public Builder efsFileLocation(EfsInputFileLocationProperty efsFileLocation) {
                this.efsFileLocation = efsFileLocation;
                return this;
            }

            public Builder s3FileLocation(IResolvable s3FileLocation) {
                this.s3FileLocation = s3FileLocation;
                return this;
            }

            public Builder s3FileLocation(S3InputFileLocationProperty s3FileLocation) {
                this.s3FileLocation = s3FileLocation;
                return this;
            }

            public InputFileLocationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_transfer.CfnWorkflow.EfsInputFileLocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EfsInputFileLocationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getFileSystemId() {
            return null;
        }

        @Nullable
        default public String getPath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EfsInputFileLocationProperty> {
            String fileSystemId;
            String path;

            public Builder fileSystemId(String fileSystemId) {
                this.fileSystemId = fileSystemId;
                return this;
            }

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public EfsInputFileLocationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_transfer.CfnWorkflow.DeleteStepDetailsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeleteStepDetailsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public String getSourceFileLocation() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DeleteStepDetailsProperty> {
            String name;
            String sourceFileLocation;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder sourceFileLocation(String sourceFileLocation) {
                this.sourceFileLocation = sourceFileLocation;
                return this;
            }

            public DeleteStepDetailsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_transfer.CfnWorkflow.DecryptStepDetailsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DecryptStepDetailsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDestinationFileLocation() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public String getOverwriteExisting() {
            return null;
        }

        @Nullable
        default public String getSourceFileLocation() {
            return null;
        }

        @Nullable
        default public String getType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DecryptStepDetailsProperty> {
            Object destinationFileLocation;
            String name;
            String overwriteExisting;
            String sourceFileLocation;
            String type;

            public Builder destinationFileLocation(IResolvable destinationFileLocation) {
                this.destinationFileLocation = destinationFileLocation;
                return this;
            }

            public Builder destinationFileLocation(InputFileLocationProperty destinationFileLocation) {
                this.destinationFileLocation = destinationFileLocation;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder overwriteExisting(String overwriteExisting) {
                this.overwriteExisting = overwriteExisting;
                return this;
            }

            public Builder sourceFileLocation(String sourceFileLocation) {
                this.sourceFileLocation = sourceFileLocation;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public DecryptStepDetailsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_transfer.CfnWorkflow.CustomStepDetailsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomStepDetailsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public String getSourceFileLocation() {
            return null;
        }

        @Nullable
        default public String getTarget() {
            return null;
        }

        @Nullable
        default public Number getTimeoutSeconds() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomStepDetailsProperty> {
            String name;
            String sourceFileLocation;
            String target;
            Number timeoutSeconds;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder sourceFileLocation(String sourceFileLocation) {
                this.sourceFileLocation = sourceFileLocation;
                return this;
            }

            public Builder target(String target) {
                this.target = target;
                return this;
            }

            public Builder timeoutSeconds(Number timeoutSeconds) {
                this.timeoutSeconds = timeoutSeconds;
                return this;
            }

            public CustomStepDetailsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_transfer.CfnWorkflow.CopyStepDetailsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CopyStepDetailsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDestinationFileLocation() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public String getOverwriteExisting() {
            return null;
        }

        @Nullable
        default public String getSourceFileLocation() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CopyStepDetailsProperty> {
            Object destinationFileLocation;
            String name;
            String overwriteExisting;
            String sourceFileLocation;

            public Builder destinationFileLocation(IResolvable destinationFileLocation) {
                this.destinationFileLocation = destinationFileLocation;
                return this;
            }

            public Builder destinationFileLocation(S3FileLocationProperty destinationFileLocation) {
                this.destinationFileLocation = destinationFileLocation;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder overwriteExisting(String overwriteExisting) {
                this.overwriteExisting = overwriteExisting;
                return this;
            }

            public Builder sourceFileLocation(String sourceFileLocation) {
                this.sourceFileLocation = sourceFileLocation;
                return this;
            }

            public CopyStepDetailsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

