package software.amazon.awscdk;

/**
 * A CloudFormation parameter.
 * <p>
 * Use the optional Parameters section to customize your templates.
 * Parameters enable you to input custom values to your template each time you create or
 * update a stack.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Topic myTopic = new Topic(this, "MyTopic");
 * CfnParameter url = new CfnParameter(this, "url-param");
 * myTopic.addSubscription(new UrlSubscription(url.getValueAsString()));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:02.096Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CfnParameter")
public class CfnParameter extends software.amazon.awscdk.CfnElement {

    protected CfnParameter(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnParameter(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates a parameter construct.
     * <p>
     * Note that the name (logical ID) of the parameter will derive from it's <code>coname</code> and location
     * within the stack. Therefore, it is recommended that parameters are defined at the stack level.
     * <p>
     * @param scope The parent construct. This parameter is required.
     * @param id This parameter is required.
     * @param props The parameter properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnParameter(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.CfnParameterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Creates a parameter construct.
     * <p>
     * Note that the name (logical ID) of the parameter will derive from it's <code>coname</code> and location
     * within the stack. Therefore, it is recommended that parameters are defined at the stack level.
     * <p>
     * @param scope The parent construct. This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnParameter(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * @param _context This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object resolve(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolveContext _context) {
        return software.amazon.jsii.Kernel.call(this, "resolve", software.amazon.jsii.NativeType.forClass(java.lang.Object.class), new Object[] { java.util.Objects.requireNonNull(_context, "_context is required") });
    }

    /**
     * The parameter value as a Token.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getValue() {
        return software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The parameter value, if it represents a string list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getValueAsList() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "valueAsList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The parameter value, if it represents a number.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getValueAsNumber() {
        return software.amazon.jsii.Kernel.get(this, "valueAsNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The parameter value, if it represents a string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getValueAsString() {
        return software.amazon.jsii.Kernel.get(this, "valueAsString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A value of the appropriate type for the template to use if no value is specified when a stack is created.
     * <p>
     * If you define constraints for the parameter, you must specify
     * a value that adheres to those constraints.
     * <p>
     * Default: - No default value for parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDefaultValue() {
        return software.amazon.jsii.Kernel.get(this, "default", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A value of the appropriate type for the template to use if no value is specified when a stack is created.
     * <p>
     * If you define constraints for the parameter, you must specify
     * a value that adheres to those constraints.
     * <p>
     * Default: - No default value for parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultValue(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "default", java.util.Objects.requireNonNull(value, "default is required"));
    }

    /**
     * Indicates if this parameter is configured with "NoEcho" enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getNoEcho() {
        return software.amazon.jsii.Kernel.get(this, "noEcho", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Indicates if this parameter is configured with "NoEcho" enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNoEcho(final @org.jetbrains.annotations.NotNull java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "noEcho", java.util.Objects.requireNonNull(value, "noEcho is required"));
    }

    /**
     * The data type for the parameter (DataType).
     * <p>
     * Default: String
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The data type for the parameter (DataType).
     * <p>
     * Default: String
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * A regular expression that represents the patterns to allow for String types.
     * <p>
     * Default: - No constraints on patterns allowed for parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAllowedPattern() {
        return software.amazon.jsii.Kernel.get(this, "allowedPattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A regular expression that represents the patterns to allow for String types.
     * <p>
     * Default: - No constraints on patterns allowed for parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowedPattern(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "allowedPattern", value);
    }

    /**
     * An array containing the list of values allowed for the parameter.
     * <p>
     * Default: - No constraints on values allowed for parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedValues() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "allowedValues", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array containing the list of values allowed for the parameter.
     * <p>
     * Default: - No constraints on values allowed for parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowedValues(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "allowedValues", value);
    }

    /**
     * A string that explains a constraint when the constraint is violated.
     * <p>
     * For example, without a constraint description, a parameter that has an allowed
     * pattern of [A-Za-z0-9]+ displays the following error message when the user specifies
     * an invalid value:
     * <p>
     * Default: - No description with customized error message when user specifies invalid values.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getConstraintDescription() {
        return software.amazon.jsii.Kernel.get(this, "constraintDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A string that explains a constraint when the constraint is violated.
     * <p>
     * For example, without a constraint description, a parameter that has an allowed
     * pattern of [A-Za-z0-9]+ displays the following error message when the user specifies
     * an invalid value:
     * <p>
     * Default: - No description with customized error message when user specifies invalid values.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConstraintDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "constraintDescription", value);
    }

    /**
     * A string of up to 4000 characters that describes the parameter.
     * <p>
     * Default: - No description for the parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A string of up to 4000 characters that describes the parameter.
     * <p>
     * Default: - No description for the parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * An integer value that determines the largest number of characters you want to allow for String types.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMaxLength() {
        return software.amazon.jsii.Kernel.get(this, "maxLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * An integer value that determines the largest number of characters you want to allow for String types.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxLength(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maxLength", value);
    }

    /**
     * A numeric value that determines the largest numeric value you want to allow for Number types.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMaxValue() {
        return software.amazon.jsii.Kernel.get(this, "maxValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * A numeric value that determines the largest numeric value you want to allow for Number types.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxValue(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maxValue", value);
    }

    /**
     * An integer value that determines the smallest number of characters you want to allow for String types.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMinLength() {
        return software.amazon.jsii.Kernel.get(this, "minLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * An integer value that determines the smallest number of characters you want to allow for String types.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMinLength(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "minLength", value);
    }

    /**
     * A numeric value that determines the smallest numeric value you want to allow for Number types.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMinValue() {
        return software.amazon.jsii.Kernel.get(this, "minValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * A numeric value that determines the smallest numeric value you want to allow for Number types.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMinValue(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "minValue", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.CfnParameter}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.CfnParameter> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope The parent construct. This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.CfnParameterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * A regular expression that represents the patterns to allow for String types.
         * <p>
         * Default: - No constraints on patterns allowed for parameter.
         * <p>
         * @return {@code this}
         * @param allowedPattern A regular expression that represents the patterns to allow for String types. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedPattern(final java.lang.String allowedPattern) {
            this.props().allowedPattern(allowedPattern);
            return this;
        }

        /**
         * An array containing the list of values allowed for the parameter.
         * <p>
         * Default: - No constraints on values allowed for parameter.
         * <p>
         * @return {@code this}
         * @param allowedValues An array containing the list of values allowed for the parameter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedValues(final java.util.List<java.lang.String> allowedValues) {
            this.props().allowedValues(allowedValues);
            return this;
        }

        /**
         * A string that explains a constraint when the constraint is violated.
         * <p>
         * For example, without a constraint description, a parameter that has an allowed
         * pattern of [A-Za-z0-9]+ displays the following error message when the user specifies
         * an invalid value:
         * <p>
         * Default: - No description with customized error message when user specifies invalid values.
         * <p>
         * @return {@code this}
         * @param constraintDescription A string that explains a constraint when the constraint is violated. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder constraintDescription(final java.lang.String constraintDescription) {
            this.props().constraintDescription(constraintDescription);
            return this;
        }

        /**
         * A value of the appropriate type for the template to use if no value is specified when a stack is created.
         * <p>
         * If you define constraints for the parameter, you must specify
         * a value that adheres to those constraints.
         * <p>
         * Default: - No default value for parameter.
         * <p>
         * @return {@code this}
         * @param defaultValue A value of the appropriate type for the template to use if no value is specified when a stack is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultValue(final java.lang.Object defaultValue) {
            this.props().defaultValue(defaultValue);
            return this;
        }

        /**
         * A string of up to 4000 characters that describes the parameter.
         * <p>
         * Default: - No description for the parameter.
         * <p>
         * @return {@code this}
         * @param description A string of up to 4000 characters that describes the parameter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * An integer value that determines the largest number of characters you want to allow for String types.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param maxLength An integer value that determines the largest number of characters you want to allow for String types. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxLength(final java.lang.Number maxLength) {
            this.props().maxLength(maxLength);
            return this;
        }

        /**
         * A numeric value that determines the largest numeric value you want to allow for Number types.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param maxValue A numeric value that determines the largest numeric value you want to allow for Number types. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxValue(final java.lang.Number maxValue) {
            this.props().maxValue(maxValue);
            return this;
        }

        /**
         * An integer value that determines the smallest number of characters you want to allow for String types.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param minLength An integer value that determines the smallest number of characters you want to allow for String types. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minLength(final java.lang.Number minLength) {
            this.props().minLength(minLength);
            return this;
        }

        /**
         * A numeric value that determines the smallest numeric value you want to allow for Number types.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param minValue A numeric value that determines the smallest numeric value you want to allow for Number types. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minValue(final java.lang.Number minValue) {
            this.props().minValue(minValue);
            return this;
        }

        /**
         * Whether to mask the parameter value when anyone makes a call that describes the stack.
         * <p>
         * If you set the value to <code>true</code>, the parameter value is masked with asterisks (<code>*****</code>).
         * <p>
         * Default: - Parameter values are not masked.
         * <p>
         * @return {@code this}
         * @param noEcho Whether to mask the parameter value when anyone makes a call that describes the stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder noEcho(final java.lang.Boolean noEcho) {
            this.props().noEcho(noEcho);
            return this;
        }

        /**
         * The data type for the parameter (DataType).
         * <p>
         * Default: String
         * <p>
         * @return {@code this}
         * @param type The data type for the parameter (DataType). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props().type(type);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.CfnParameter}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.CfnParameter build() {
            return new software.amazon.awscdk.CfnParameter(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.CfnParameterProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.CfnParameterProps.Builder();
            }
            return this.props;
        }
    }
}
