package software.amazon.awscdk.cloud_assembly_schema;

/**
 * Commands to run at predefined points during the integration test workflow.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.cloud_assembly_schema.*;
 * Hooks hooks = Hooks.builder()
 *         .postDeploy(List.of("postDeploy"))
 *         .postDestroy(List.of("postDestroy"))
 *         .preDeploy(List.of("preDeploy"))
 *         .preDestroy(List.of("preDestroy"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:17.569Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.cloud_assembly_schema.Hooks")
@software.amazon.jsii.Jsii.Proxy(Hooks.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface Hooks extends software.amazon.jsii.JsiiSerializable {

    /**
     * Commands to run prior after deploying the cdk stacks in the integration test.
     * <p>
     * Default: - no commands
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPostDeploy() {
        return null;
    }

    /**
     * Commands to run after destroying the cdk stacks in the integration test.
     * <p>
     * Default: - no commands
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPostDestroy() {
        return null;
    }

    /**
     * Commands to run prior to deploying the cdk stacks in the integration test.
     * <p>
     * Default: - no commands
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPreDeploy() {
        return null;
    }

    /**
     * Commands to run prior to destroying the cdk stacks in the integration test.
     * <p>
     * Default: - no commands
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPreDestroy() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link Hooks}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Hooks}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<Hooks> {
        java.util.List<java.lang.String> postDeploy;
        java.util.List<java.lang.String> postDestroy;
        java.util.List<java.lang.String> preDeploy;
        java.util.List<java.lang.String> preDestroy;

        /**
         * Sets the value of {@link Hooks#getPostDeploy}
         * @param postDeploy Commands to run prior after deploying the cdk stacks in the integration test.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder postDeploy(java.util.List<java.lang.String> postDeploy) {
            this.postDeploy = postDeploy;
            return this;
        }

        /**
         * Sets the value of {@link Hooks#getPostDestroy}
         * @param postDestroy Commands to run after destroying the cdk stacks in the integration test.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder postDestroy(java.util.List<java.lang.String> postDestroy) {
            this.postDestroy = postDestroy;
            return this;
        }

        /**
         * Sets the value of {@link Hooks#getPreDeploy}
         * @param preDeploy Commands to run prior to deploying the cdk stacks in the integration test.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preDeploy(java.util.List<java.lang.String> preDeploy) {
            this.preDeploy = preDeploy;
            return this;
        }

        /**
         * Sets the value of {@link Hooks#getPreDestroy}
         * @param preDestroy Commands to run prior to destroying the cdk stacks in the integration test.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preDestroy(java.util.List<java.lang.String> preDestroy) {
            this.preDestroy = preDestroy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Hooks}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public Hooks build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link Hooks}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Hooks {
        private final java.util.List<java.lang.String> postDeploy;
        private final java.util.List<java.lang.String> postDestroy;
        private final java.util.List<java.lang.String> preDeploy;
        private final java.util.List<java.lang.String> preDestroy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.postDeploy = software.amazon.jsii.Kernel.get(this, "postDeploy", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.postDestroy = software.amazon.jsii.Kernel.get(this, "postDestroy", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.preDeploy = software.amazon.jsii.Kernel.get(this, "preDeploy", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.preDestroy = software.amazon.jsii.Kernel.get(this, "preDestroy", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.postDeploy = builder.postDeploy;
            this.postDestroy = builder.postDestroy;
            this.preDeploy = builder.preDeploy;
            this.preDestroy = builder.preDestroy;
        }

        @Override
        public final java.util.List<java.lang.String> getPostDeploy() {
            return this.postDeploy;
        }

        @Override
        public final java.util.List<java.lang.String> getPostDestroy() {
            return this.postDestroy;
        }

        @Override
        public final java.util.List<java.lang.String> getPreDeploy() {
            return this.preDeploy;
        }

        @Override
        public final java.util.List<java.lang.String> getPreDestroy() {
            return this.preDestroy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getPostDeploy() != null) {
                data.set("postDeploy", om.valueToTree(this.getPostDeploy()));
            }
            if (this.getPostDestroy() != null) {
                data.set("postDestroy", om.valueToTree(this.getPostDestroy()));
            }
            if (this.getPreDeploy() != null) {
                data.set("preDeploy", om.valueToTree(this.getPreDeploy()));
            }
            if (this.getPreDestroy() != null) {
                data.set("preDestroy", om.valueToTree(this.getPreDestroy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.cloud_assembly_schema.Hooks"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Hooks.Jsii$Proxy that = (Hooks.Jsii$Proxy) o;

            if (this.postDeploy != null ? !this.postDeploy.equals(that.postDeploy) : that.postDeploy != null) return false;
            if (this.postDestroy != null ? !this.postDestroy.equals(that.postDestroy) : that.postDestroy != null) return false;
            if (this.preDeploy != null ? !this.preDeploy.equals(that.preDeploy) : that.preDeploy != null) return false;
            return this.preDestroy != null ? this.preDestroy.equals(that.preDestroy) : that.preDestroy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.postDeploy != null ? this.postDeploy.hashCode() : 0;
            result = 31 * result + (this.postDestroy != null ? this.postDestroy.hashCode() : 0);
            result = 31 * result + (this.preDeploy != null ? this.preDeploy.hashCode() : 0);
            result = 31 * result + (this.preDestroy != null ? this.preDestroy.hashCode() : 0);
            return result;
        }
    }
}
