package software.amazon.awscdk.services.apigateway;

/**
 * Properties for defining a <code>CfnDomainName</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * CfnDomainNameProps cfnDomainNameProps = CfnDomainNameProps.builder()
 *         .certificateArn("certificateArn")
 *         .domainName("domainName")
 *         .endpointConfiguration(EndpointConfigurationProperty.builder()
 *                 .types(List.of("types"))
 *                 .build())
 *         .mutualTlsAuthentication(MutualTlsAuthenticationProperty.builder()
 *                 .truststoreUri("truststoreUri")
 *                 .truststoreVersion("truststoreVersion")
 *                 .build())
 *         .ownershipVerificationCertificateArn("ownershipVerificationCertificateArn")
 *         .regionalCertificateArn("regionalCertificateArn")
 *         .securityPolicy("securityPolicy")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:02.528Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.CfnDomainNameProps")
@software.amazon.jsii.Jsii.Proxy(CfnDomainNameProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDomainNameProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The reference to an AWS -managed certificate that will be used by edge-optimized endpoint for this domain name.
     * <p>
     * AWS Certificate Manager is the only supported source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-certificatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-certificatearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCertificateArn() {
        return null;
    }

    /**
     * The custom domain name as an API host name, for example, <code>my-api.example.com</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-domainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-domainname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomainName() {
        return null;
    }

    /**
     * The endpoint configuration of this DomainName showing the endpoint types of the domain name.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-endpointconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-endpointconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEndpointConfiguration() {
        return null;
    }

    /**
     * The mutual TLS authentication configuration for a custom domain name.
     * <p>
     * If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-mutualtlsauthentication">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-mutualtlsauthentication</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMutualTlsAuthentication() {
        return null;
    }

    /**
     * The ARN of the public certificate issued by ACM to validate ownership of your custom domain.
     * <p>
     * Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the RegionalCertificateArn.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-ownershipverificationcertificatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-ownershipverificationcertificatearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOwnershipVerificationCertificateArn() {
        return null;
    }

    /**
     * The reference to an AWS -managed certificate that will be used for validating the regional domain name.
     * <p>
     * AWS Certificate Manager is the only supported source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-regionalcertificatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-regionalcertificatearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegionalCertificateArn() {
        return null;
    }

    /**
     * The Transport Layer Security (TLS) version + cipher suite for this DomainName.
     * <p>
     * The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-securitypolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-securitypolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSecurityPolicy() {
        return null;
    }

    /**
     * The collection of tags.
     * <p>
     * Each tag element is associated with a given resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDomainNameProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDomainNameProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDomainNameProps> {
        java.lang.String certificateArn;
        java.lang.String domainName;
        java.lang.Object endpointConfiguration;
        java.lang.Object mutualTlsAuthentication;
        java.lang.String ownershipVerificationCertificateArn;
        java.lang.String regionalCertificateArn;
        java.lang.String securityPolicy;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDomainNameProps#getCertificateArn}
         * @param certificateArn The reference to an AWS -managed certificate that will be used by edge-optimized endpoint for this domain name.
         *                       AWS Certificate Manager is the only supported source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateArn(java.lang.String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainNameProps#getDomainName}
         * @param domainName The custom domain name as an API host name, for example, <code>my-api.example.com</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainNameProps#getEndpointConfiguration}
         * @param endpointConfiguration The endpoint configuration of this DomainName showing the endpoint types of the domain name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointConfiguration(software.amazon.awscdk.IResolvable endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainNameProps#getEndpointConfiguration}
         * @param endpointConfiguration The endpoint configuration of this DomainName showing the endpoint types of the domain name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointConfiguration(software.amazon.awscdk.services.apigateway.CfnDomainName.EndpointConfigurationProperty endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainNameProps#getMutualTlsAuthentication}
         * @param mutualTlsAuthentication The mutual TLS authentication configuration for a custom domain name.
         *                                If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mutualTlsAuthentication(software.amazon.awscdk.IResolvable mutualTlsAuthentication) {
            this.mutualTlsAuthentication = mutualTlsAuthentication;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainNameProps#getMutualTlsAuthentication}
         * @param mutualTlsAuthentication The mutual TLS authentication configuration for a custom domain name.
         *                                If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mutualTlsAuthentication(software.amazon.awscdk.services.apigateway.CfnDomainName.MutualTlsAuthenticationProperty mutualTlsAuthentication) {
            this.mutualTlsAuthentication = mutualTlsAuthentication;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainNameProps#getOwnershipVerificationCertificateArn}
         * @param ownershipVerificationCertificateArn The ARN of the public certificate issued by ACM to validate ownership of your custom domain.
         *                                            Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the RegionalCertificateArn.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ownershipVerificationCertificateArn(java.lang.String ownershipVerificationCertificateArn) {
            this.ownershipVerificationCertificateArn = ownershipVerificationCertificateArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainNameProps#getRegionalCertificateArn}
         * @param regionalCertificateArn The reference to an AWS -managed certificate that will be used for validating the regional domain name.
         *                               AWS Certificate Manager is the only supported source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regionalCertificateArn(java.lang.String regionalCertificateArn) {
            this.regionalCertificateArn = regionalCertificateArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainNameProps#getSecurityPolicy}
         * @param securityPolicy The Transport Layer Security (TLS) version + cipher suite for this DomainName.
         *                       The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityPolicy(java.lang.String securityPolicy) {
            this.securityPolicy = securityPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainNameProps#getTags}
         * @param tags The collection of tags.
         *             Each tag element is associated with a given resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDomainNameProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDomainNameProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDomainNameProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDomainNameProps {
        private final java.lang.String certificateArn;
        private final java.lang.String domainName;
        private final java.lang.Object endpointConfiguration;
        private final java.lang.Object mutualTlsAuthentication;
        private final java.lang.String ownershipVerificationCertificateArn;
        private final java.lang.String regionalCertificateArn;
        private final java.lang.String securityPolicy;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.certificateArn = software.amazon.jsii.Kernel.get(this, "certificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.endpointConfiguration = software.amazon.jsii.Kernel.get(this, "endpointConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.mutualTlsAuthentication = software.amazon.jsii.Kernel.get(this, "mutualTlsAuthentication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ownershipVerificationCertificateArn = software.amazon.jsii.Kernel.get(this, "ownershipVerificationCertificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.regionalCertificateArn = software.amazon.jsii.Kernel.get(this, "regionalCertificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityPolicy = software.amazon.jsii.Kernel.get(this, "securityPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.certificateArn = builder.certificateArn;
            this.domainName = builder.domainName;
            this.endpointConfiguration = builder.endpointConfiguration;
            this.mutualTlsAuthentication = builder.mutualTlsAuthentication;
            this.ownershipVerificationCertificateArn = builder.ownershipVerificationCertificateArn;
            this.regionalCertificateArn = builder.regionalCertificateArn;
            this.securityPolicy = builder.securityPolicy;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final java.lang.Object getEndpointConfiguration() {
            return this.endpointConfiguration;
        }

        @Override
        public final java.lang.Object getMutualTlsAuthentication() {
            return this.mutualTlsAuthentication;
        }

        @Override
        public final java.lang.String getOwnershipVerificationCertificateArn() {
            return this.ownershipVerificationCertificateArn;
        }

        @Override
        public final java.lang.String getRegionalCertificateArn() {
            return this.regionalCertificateArn;
        }

        @Override
        public final java.lang.String getSecurityPolicy() {
            return this.securityPolicy;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCertificateArn() != null) {
                data.set("certificateArn", om.valueToTree(this.getCertificateArn()));
            }
            if (this.getDomainName() != null) {
                data.set("domainName", om.valueToTree(this.getDomainName()));
            }
            if (this.getEndpointConfiguration() != null) {
                data.set("endpointConfiguration", om.valueToTree(this.getEndpointConfiguration()));
            }
            if (this.getMutualTlsAuthentication() != null) {
                data.set("mutualTlsAuthentication", om.valueToTree(this.getMutualTlsAuthentication()));
            }
            if (this.getOwnershipVerificationCertificateArn() != null) {
                data.set("ownershipVerificationCertificateArn", om.valueToTree(this.getOwnershipVerificationCertificateArn()));
            }
            if (this.getRegionalCertificateArn() != null) {
                data.set("regionalCertificateArn", om.valueToTree(this.getRegionalCertificateArn()));
            }
            if (this.getSecurityPolicy() != null) {
                data.set("securityPolicy", om.valueToTree(this.getSecurityPolicy()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigateway.CfnDomainNameProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDomainNameProps.Jsii$Proxy that = (CfnDomainNameProps.Jsii$Proxy) o;

            if (this.certificateArn != null ? !this.certificateArn.equals(that.certificateArn) : that.certificateArn != null) return false;
            if (this.domainName != null ? !this.domainName.equals(that.domainName) : that.domainName != null) return false;
            if (this.endpointConfiguration != null ? !this.endpointConfiguration.equals(that.endpointConfiguration) : that.endpointConfiguration != null) return false;
            if (this.mutualTlsAuthentication != null ? !this.mutualTlsAuthentication.equals(that.mutualTlsAuthentication) : that.mutualTlsAuthentication != null) return false;
            if (this.ownershipVerificationCertificateArn != null ? !this.ownershipVerificationCertificateArn.equals(that.ownershipVerificationCertificateArn) : that.ownershipVerificationCertificateArn != null) return false;
            if (this.regionalCertificateArn != null ? !this.regionalCertificateArn.equals(that.regionalCertificateArn) : that.regionalCertificateArn != null) return false;
            if (this.securityPolicy != null ? !this.securityPolicy.equals(that.securityPolicy) : that.securityPolicy != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.certificateArn != null ? this.certificateArn.hashCode() : 0;
            result = 31 * result + (this.domainName != null ? this.domainName.hashCode() : 0);
            result = 31 * result + (this.endpointConfiguration != null ? this.endpointConfiguration.hashCode() : 0);
            result = 31 * result + (this.mutualTlsAuthentication != null ? this.mutualTlsAuthentication.hashCode() : 0);
            result = 31 * result + (this.ownershipVerificationCertificateArn != null ? this.ownershipVerificationCertificateArn.hashCode() : 0);
            result = 31 * result + (this.regionalCertificateArn != null ? this.regionalCertificateArn.hashCode() : 0);
            result = 31 * result + (this.securityPolicy != null ? this.securityPolicy.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
