package software.amazon.awscdk.services.apigateway;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * Model model;
 * MethodResponse methodResponse = MethodResponse.builder()
 *         .statusCode("statusCode")
 *         // the properties below are optional
 *         .responseModels(Map.of(
 *                 "responseModelsKey", model))
 *         .responseParameters(Map.of(
 *                 "responseParametersKey", false))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:02.634Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.MethodResponse")
@software.amazon.jsii.Jsii.Proxy(MethodResponse.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MethodResponse extends software.amazon.jsii.JsiiSerializable {

    /**
     * The method response's status code, which you map to an IntegrationResponse.
     * <p>
     * Required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStatusCode();

    /**
     * The resources used for the response's content type.
     * <p>
     * Specify response models as
     * key-value pairs (string-to-string maps), with a content type as the key and a Model
     * resource name as the value.
     * <p>
     * Default: None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> getResponseModels() {
        return null;
    }

    /**
     * Response parameters that API Gateway sends to the client that called a method.
     * <p>
     * Specify response parameters as key-value pairs (string-to-Boolean maps), with
     * a destination as the key and a Boolean as the value. Specify the destination
     * using the following pattern: method.response.header.name, where the name is a
     * valid, unique header name. The Boolean specifies whether a parameter is required.
     * <p>
     * Default: None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Boolean> getResponseParameters() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link MethodResponse}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MethodResponse}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MethodResponse> {
        java.lang.String statusCode;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> responseModels;
        java.util.Map<java.lang.String, java.lang.Boolean> responseParameters;

        /**
         * Sets the value of {@link MethodResponse#getStatusCode}
         * @param statusCode The method response's status code, which you map to an IntegrationResponse. This parameter is required.
         *                   Required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statusCode(java.lang.String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        /**
         * Sets the value of {@link MethodResponse#getResponseModels}
         * @param responseModels The resources used for the response's content type.
         *                       Specify response models as
         *                       key-value pairs (string-to-string maps), with a content type as the key and a Model
         *                       resource name as the value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder responseModels(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.apigateway.IModel> responseModels) {
            this.responseModels = (java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel>)responseModels;
            return this;
        }

        /**
         * Sets the value of {@link MethodResponse#getResponseParameters}
         * @param responseParameters Response parameters that API Gateway sends to the client that called a method.
         *                           Specify response parameters as key-value pairs (string-to-Boolean maps), with
         *                           a destination as the key and a Boolean as the value. Specify the destination
         *                           using the following pattern: method.response.header.name, where the name is a
         *                           valid, unique header name. The Boolean specifies whether a parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder responseParameters(java.util.Map<java.lang.String, ? extends java.lang.Boolean> responseParameters) {
            this.responseParameters = (java.util.Map<java.lang.String, java.lang.Boolean>)responseParameters;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MethodResponse}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MethodResponse build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MethodResponse}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MethodResponse {
        private final java.lang.String statusCode;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> responseModels;
        private final java.util.Map<java.lang.String, java.lang.Boolean> responseParameters;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.statusCode = software.amazon.jsii.Kernel.get(this, "statusCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.responseModels = software.amazon.jsii.Kernel.get(this, "responseModels", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IModel.class)));
            this.responseParameters = software.amazon.jsii.Kernel.get(this, "responseParameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.statusCode = java.util.Objects.requireNonNull(builder.statusCode, "statusCode is required");
            this.responseModels = (java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel>)builder.responseModels;
            this.responseParameters = (java.util.Map<java.lang.String, java.lang.Boolean>)builder.responseParameters;
        }

        @Override
        public final java.lang.String getStatusCode() {
            return this.statusCode;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> getResponseModels() {
            return this.responseModels;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Boolean> getResponseParameters() {
            return this.responseParameters;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("statusCode", om.valueToTree(this.getStatusCode()));
            if (this.getResponseModels() != null) {
                data.set("responseModels", om.valueToTree(this.getResponseModels()));
            }
            if (this.getResponseParameters() != null) {
                data.set("responseParameters", om.valueToTree(this.getResponseParameters()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigateway.MethodResponse"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MethodResponse.Jsii$Proxy that = (MethodResponse.Jsii$Proxy) o;

            if (!statusCode.equals(that.statusCode)) return false;
            if (this.responseModels != null ? !this.responseModels.equals(that.responseModels) : that.responseModels != null) return false;
            return this.responseParameters != null ? this.responseParameters.equals(that.responseParameters) : that.responseParameters == null;
        }

        @Override
        public final int hashCode() {
            int result = this.statusCode.hashCode();
            result = 31 * result + (this.responseModels != null ? this.responseModels.hashCode() : 0);
            result = 31 * result + (this.responseParameters != null ? this.responseParameters.hashCode() : 0);
            return result;
        }
    }
}
