package software.amazon.awscdk.services.apigatewayv2;

/**
 * The integration for an API route.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * import software.amazon.awscdk.services.iam.*;
 * Role role;
 * WebSocketApi webSocketApi;
 * WebSocketIntegration webSocketIntegration = WebSocketIntegration.Builder.create(this, "MyWebSocketIntegration")
 *         .integrationType(WebSocketIntegrationType.AWS_PROXY)
 *         .integrationUri("integrationUri")
 *         .webSocketApi(webSocketApi)
 *         // the properties below are optional
 *         .contentHandling(ContentHandling.CONVERT_TO_BINARY)
 *         .credentialsRole(role)
 *         .integrationMethod("integrationMethod")
 *         .passthroughBehavior(PassthroughBehavior.WHEN_NO_MATCH)
 *         .requestParameters(Map.of(
 *                 "requestParametersKey", "requestParameters"))
 *         .requestTemplates(Map.of(
 *                 "requestTemplatesKey", "requestTemplates"))
 *         .templateSelectionExpression("templateSelectionExpression")
 *         .timeout(Duration.minutes(30))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:02.841Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.WebSocketIntegration")
public class WebSocketIntegration extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.apigatewayv2.IWebSocketIntegration {

    protected WebSocketIntegration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected WebSocketIntegration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public WebSocketIntegration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.WebSocketIntegrationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Id of the integration.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getIntegrationId() {
        return software.amazon.jsii.Kernel.get(this, "integrationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The WebSocket API associated with this integration.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.IWebSocketApi getWebSocketApi() {
        return software.amazon.jsii.Kernel.get(this, "webSocketApi", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IWebSocketApi.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigatewayv2.WebSocketIntegration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigatewayv2.WebSocketIntegration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigatewayv2.WebSocketIntegrationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigatewayv2.WebSocketIntegrationProps.Builder();
        }

        /**
         * Integration type.
         * <p>
         * @return {@code this}
         * @param integrationType Integration type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationType(final software.amazon.awscdk.services.apigatewayv2.WebSocketIntegrationType integrationType) {
            this.props.integrationType(integrationType);
            return this;
        }

        /**
         * Integration URI.
         * <p>
         * @return {@code this}
         * @param integrationUri Integration URI. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationUri(final java.lang.String integrationUri) {
            this.props.integrationUri(integrationUri);
            return this;
        }

        /**
         * The WebSocket API to which this integration should be bound.
         * <p>
         * @return {@code this}
         * @param webSocketApi The WebSocket API to which this integration should be bound. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webSocketApi(final software.amazon.awscdk.services.apigatewayv2.IWebSocketApi webSocketApi) {
            this.props.webSocketApi(webSocketApi);
            return this;
        }

        /**
         * Specifies how to handle response payload content type conversions.
         * <p>
         * Default: - The response payload will be passed through from the integration response to
         * the route response or method response without modification.
         * <p>
         * @return {@code this}
         * @param contentHandling Specifies how to handle response payload content type conversions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentHandling(final software.amazon.awscdk.services.apigatewayv2.ContentHandling contentHandling) {
            this.props.contentHandling(contentHandling);
            return this;
        }

        /**
         * Specifies the IAM role required for the integration.
         * <p>
         * Default: - No IAM role required.
         * <p>
         * @return {@code this}
         * @param credentialsRole Specifies the IAM role required for the integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentialsRole(final software.amazon.awscdk.services.iam.IRole credentialsRole) {
            this.props.credentialsRole(credentialsRole);
            return this;
        }

        /**
         * Specifies the integration's HTTP method type.
         * <p>
         * Default: - No HTTP method required.
         * <p>
         * @return {@code this}
         * @param integrationMethod Specifies the integration's HTTP method type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationMethod(final java.lang.String integrationMethod) {
            this.props.integrationMethod(integrationMethod);
            return this;
        }

        /**
         * Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource.
         * <p>
         * There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and
         * NEVER.
         * <p>
         * Default: - No passthrough behavior required.
         * <p>
         * @return {@code this}
         * @param passthroughBehavior Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder passthroughBehavior(final software.amazon.awscdk.services.apigatewayv2.PassthroughBehavior passthroughBehavior) {
            this.props.passthroughBehavior(passthroughBehavior);
            return this;
        }

        /**
         * The request parameters that API Gateway sends with the backend request.
         * <p>
         * Specify request parameters as key-value pairs (string-to-string
         * mappings), with a destination as the key and a source as the value.
         * <p>
         * Default: - No request parameters required.
         * <p>
         * @return {@code this}
         * @param requestParameters The request parameters that API Gateway sends with the backend request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestParameters(final java.util.Map<java.lang.String, java.lang.String> requestParameters) {
            this.props.requestParameters(requestParameters);
            return this;
        }

        /**
         * A map of Apache Velocity templates that are applied on the request payload.
         * <p>
         * <blockquote><pre>
         *   { "application/json": "{ \"statusCode\": 200 }" }
         * </pre></blockquote>
         * <p>
         * Default: - No request templates required.
         * <p>
         * @return {@code this}
         * @param requestTemplates A map of Apache Velocity templates that are applied on the request payload. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestTemplates(final java.util.Map<java.lang.String, java.lang.String> requestTemplates) {
            this.props.requestTemplates(requestTemplates);
            return this;
        }

        /**
         * The template selection expression for the integration.
         * <p>
         * Default: - No template selection expression required.
         * <p>
         * @return {@code this}
         * @param templateSelectionExpression The template selection expression for the integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateSelectionExpression(final java.lang.String templateSelectionExpression) {
            this.props.templateSelectionExpression(templateSelectionExpression);
            return this;
        }

        /**
         * The maximum amount of time an integration will run before it returns without a response.
         * <p>
         * Must be between 50 milliseconds and 29 seconds.
         * <p>
         * Default: Duration.seconds(29)
         * <p>
         * @return {@code this}
         * @param timeout The maximum amount of time an integration will run before it returns without a response. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final software.amazon.awscdk.Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.apigatewayv2.WebSocketIntegration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigatewayv2.WebSocketIntegration build() {
            return new software.amazon.awscdk.services.apigatewayv2.WebSocketIntegration(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
