package software.amazon.awscdk.services.appmesh;

/**
 * Represents the properties needed to define a Virtual Service backend.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appmesh.*;
 * MutualTlsCertificate mutualTlsCertificate;
 * SubjectAlternativeNames subjectAlternativeNames;
 * TlsValidationTrust tlsValidationTrust;
 * VirtualServiceBackendOptions virtualServiceBackendOptions = VirtualServiceBackendOptions.builder()
 *         .tlsClientPolicy(TlsClientPolicy.builder()
 *                 .validation(TlsValidation.builder()
 *                         .trust(tlsValidationTrust)
 *                         // the properties below are optional
 *                         .subjectAlternativeNames(subjectAlternativeNames)
 *                         .build())
 *                 // the properties below are optional
 *                 .enforce(false)
 *                 .mutualTlsCertificate(mutualTlsCertificate)
 *                 .ports(List.of(123))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:03.396Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.VirtualServiceBackendOptions")
@software.amazon.jsii.Jsii.Proxy(VirtualServiceBackendOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VirtualServiceBackendOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * TLS properties for  Client policy for the backend.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.TlsClientPolicy getTlsClientPolicy() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link VirtualServiceBackendOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VirtualServiceBackendOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VirtualServiceBackendOptions> {
        software.amazon.awscdk.services.appmesh.TlsClientPolicy tlsClientPolicy;

        /**
         * Sets the value of {@link VirtualServiceBackendOptions#getTlsClientPolicy}
         * @param tlsClientPolicy TLS properties for  Client policy for the backend.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tlsClientPolicy(software.amazon.awscdk.services.appmesh.TlsClientPolicy tlsClientPolicy) {
            this.tlsClientPolicy = tlsClientPolicy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VirtualServiceBackendOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VirtualServiceBackendOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VirtualServiceBackendOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualServiceBackendOptions {
        private final software.amazon.awscdk.services.appmesh.TlsClientPolicy tlsClientPolicy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.tlsClientPolicy = software.amazon.jsii.Kernel.get(this, "tlsClientPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.TlsClientPolicy.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.tlsClientPolicy = builder.tlsClientPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.TlsClientPolicy getTlsClientPolicy() {
            return this.tlsClientPolicy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getTlsClientPolicy() != null) {
                data.set("tlsClientPolicy", om.valueToTree(this.getTlsClientPolicy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.VirtualServiceBackendOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VirtualServiceBackendOptions.Jsii$Proxy that = (VirtualServiceBackendOptions.Jsii$Proxy) o;

            return this.tlsClientPolicy != null ? this.tlsClientPolicy.equals(that.tlsClientPolicy) : that.tlsClientPolicy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.tlsClientPolicy != null ? this.tlsClientPolicy.hashCode() : 0;
            return result;
        }
    }
}
