package software.amazon.awscdk.services.appsync;

/**
 * Properties for defining a <code>CfnFunctionConfiguration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appsync.*;
 * CfnFunctionConfigurationProps cfnFunctionConfigurationProps = CfnFunctionConfigurationProps.builder()
 *         .apiId("apiId")
 *         .dataSourceName("dataSourceName")
 *         .name("name")
 *         // the properties below are optional
 *         .code("code")
 *         .codeS3Location("codeS3Location")
 *         .description("description")
 *         .functionVersion("functionVersion")
 *         .maxBatchSize(123)
 *         .requestMappingTemplate("requestMappingTemplate")
 *         .requestMappingTemplateS3Location("requestMappingTemplateS3Location")
 *         .responseMappingTemplate("responseMappingTemplate")
 *         .responseMappingTemplateS3Location("responseMappingTemplateS3Location")
 *         .runtime(AppSyncRuntimeProperty.builder()
 *                 .name("name")
 *                 .runtimeVersion("runtimeVersion")
 *                 .build())
 *         .syncConfig(SyncConfigProperty.builder()
 *                 .conflictDetection("conflictDetection")
 *                 // the properties below are optional
 *                 .conflictHandler("conflictHandler")
 *                 .lambdaConflictHandlerConfig(LambdaConflictHandlerConfigProperty.builder()
 *                         .lambdaConflictHandlerArn("lambdaConflictHandlerArn")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:03.548Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnFunctionConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnFunctionConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFunctionConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AWS AppSync GraphQL API that you want to attach using this function.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-apiid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-apiid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApiId();

    /**
     * The name of data source this function will attach.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-datasourcename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-datasourcename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDataSourceName();

    /**
     * The name of the function.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The <code>resolver</code> code that contains the request and response functions.
     * <p>
     * When code is used, the <code>runtime</code> is required. The runtime value must be <code>APPSYNC_JS</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-code">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-code</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCode() {
        return null;
    }

    /**
     * The Amazon S3 endpoint.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-codes3location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-codes3location</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCodeS3Location() {
        return null;
    }

    /**
     * The <code>Function</code> description.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The version of the request mapping template.
     * <p>
     * Currently, only the 2018-05-29 version of the template is supported.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-functionversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-functionversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFunctionVersion() {
        return null;
    }

    /**
     * The maximum number of resolver request inputs that will be sent to a single AWS Lambda function in a <code>BatchInvoke</code> operation.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-maxbatchsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-maxbatchsize</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxBatchSize() {
        return null;
    }

    /**
     * The <code>Function</code> request mapping template.
     * <p>
     * Functions support only the 2018-05-29 version of the request mapping template.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-requestmappingtemplate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-requestmappingtemplate</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRequestMappingTemplate() {
        return null;
    }

    /**
     * Describes a Sync configuration for a resolver.
     * <p>
     * Contains information on which Conflict Detection, as well as Resolution strategy, should be performed when the resolver is invoked.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-requestmappingtemplates3location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-requestmappingtemplates3location</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRequestMappingTemplateS3Location() {
        return null;
    }

    /**
     * The <code>Function</code> response mapping template.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-responsemappingtemplate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-responsemappingtemplate</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResponseMappingTemplate() {
        return null;
    }

    /**
     * The location of a response mapping template in an Amazon S3 bucket.
     * <p>
     * Use this if you want to provision with a template file in Amazon S3 rather than embedding it in your CloudFormation template.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-responsemappingtemplates3location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-responsemappingtemplates3location</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResponseMappingTemplateS3Location() {
        return null;
    }

    /**
     * Describes a runtime used by an AWS AppSync resolver or AWS AppSync function.
     * <p>
     * Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-runtime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-runtime</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRuntime() {
        return null;
    }

    /**
     * Describes a Sync configuration for a resolver.
     * <p>
     * Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-syncconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-syncconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSyncConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFunctionConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFunctionConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFunctionConfigurationProps> {
        java.lang.String apiId;
        java.lang.String dataSourceName;
        java.lang.String name;
        java.lang.String code;
        java.lang.String codeS3Location;
        java.lang.String description;
        java.lang.String functionVersion;
        java.lang.Number maxBatchSize;
        java.lang.String requestMappingTemplate;
        java.lang.String requestMappingTemplateS3Location;
        java.lang.String responseMappingTemplate;
        java.lang.String responseMappingTemplateS3Location;
        java.lang.Object runtime;
        java.lang.Object syncConfig;

        /**
         * Sets the value of {@link CfnFunctionConfigurationProps#getApiId}
         * @param apiId The AWS AppSync GraphQL API that you want to attach using this function. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiId(java.lang.String apiId) {
            this.apiId = apiId;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionConfigurationProps#getDataSourceName}
         * @param dataSourceName The name of data source this function will attach. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSourceName(java.lang.String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionConfigurationProps#getName}
         * @param name The name of the function. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionConfigurationProps#getCode}
         * @param code The <code>resolver</code> code that contains the request and response functions.
         *             When code is used, the <code>runtime</code> is required. The runtime value must be <code>APPSYNC_JS</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder code(java.lang.String code) {
            this.code = code;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionConfigurationProps#getCodeS3Location}
         * @param codeS3Location The Amazon S3 endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeS3Location(java.lang.String codeS3Location) {
            this.codeS3Location = codeS3Location;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionConfigurationProps#getDescription}
         * @param description The <code>Function</code> description.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionConfigurationProps#getFunctionVersion}
         * @param functionVersion The version of the request mapping template.
         *                        Currently, only the 2018-05-29 version of the template is supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionVersion(java.lang.String functionVersion) {
            this.functionVersion = functionVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionConfigurationProps#getMaxBatchSize}
         * @param maxBatchSize The maximum number of resolver request inputs that will be sent to a single AWS Lambda function in a <code>BatchInvoke</code> operation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxBatchSize(java.lang.Number maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionConfigurationProps#getRequestMappingTemplate}
         * @param requestMappingTemplate The <code>Function</code> request mapping template.
         *                               Functions support only the 2018-05-29 version of the request mapping template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestMappingTemplate(java.lang.String requestMappingTemplate) {
            this.requestMappingTemplate = requestMappingTemplate;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionConfigurationProps#getRequestMappingTemplateS3Location}
         * @param requestMappingTemplateS3Location Describes a Sync configuration for a resolver.
         *                                         Contains information on which Conflict Detection, as well as Resolution strategy, should be performed when the resolver is invoked.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestMappingTemplateS3Location(java.lang.String requestMappingTemplateS3Location) {
            this.requestMappingTemplateS3Location = requestMappingTemplateS3Location;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionConfigurationProps#getResponseMappingTemplate}
         * @param responseMappingTemplate The <code>Function</code> response mapping template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseMappingTemplate(java.lang.String responseMappingTemplate) {
            this.responseMappingTemplate = responseMappingTemplate;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionConfigurationProps#getResponseMappingTemplateS3Location}
         * @param responseMappingTemplateS3Location The location of a response mapping template in an Amazon S3 bucket.
         *                                          Use this if you want to provision with a template file in Amazon S3 rather than embedding it in your CloudFormation template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseMappingTemplateS3Location(java.lang.String responseMappingTemplateS3Location) {
            this.responseMappingTemplateS3Location = responseMappingTemplateS3Location;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionConfigurationProps#getRuntime}
         * @param runtime Describes a runtime used by an AWS AppSync resolver or AWS AppSync function.
         *                Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtime(software.amazon.awscdk.IResolvable runtime) {
            this.runtime = runtime;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionConfigurationProps#getRuntime}
         * @param runtime Describes a runtime used by an AWS AppSync resolver or AWS AppSync function.
         *                Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtime(software.amazon.awscdk.services.appsync.CfnFunctionConfiguration.AppSyncRuntimeProperty runtime) {
            this.runtime = runtime;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionConfigurationProps#getSyncConfig}
         * @param syncConfig Describes a Sync configuration for a resolver.
         *                   Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder syncConfig(software.amazon.awscdk.IResolvable syncConfig) {
            this.syncConfig = syncConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionConfigurationProps#getSyncConfig}
         * @param syncConfig Describes a Sync configuration for a resolver.
         *                   Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder syncConfig(software.amazon.awscdk.services.appsync.CfnFunctionConfiguration.SyncConfigProperty syncConfig) {
            this.syncConfig = syncConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFunctionConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFunctionConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnFunctionConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFunctionConfigurationProps {
        private final java.lang.String apiId;
        private final java.lang.String dataSourceName;
        private final java.lang.String name;
        private final java.lang.String code;
        private final java.lang.String codeS3Location;
        private final java.lang.String description;
        private final java.lang.String functionVersion;
        private final java.lang.Number maxBatchSize;
        private final java.lang.String requestMappingTemplate;
        private final java.lang.String requestMappingTemplateS3Location;
        private final java.lang.String responseMappingTemplate;
        private final java.lang.String responseMappingTemplateS3Location;
        private final java.lang.Object runtime;
        private final java.lang.Object syncConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiId = software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataSourceName = software.amazon.jsii.Kernel.get(this, "dataSourceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.code = software.amazon.jsii.Kernel.get(this, "code", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.codeS3Location = software.amazon.jsii.Kernel.get(this, "codeS3Location", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.functionVersion = software.amazon.jsii.Kernel.get(this, "functionVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxBatchSize = software.amazon.jsii.Kernel.get(this, "maxBatchSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.requestMappingTemplate = software.amazon.jsii.Kernel.get(this, "requestMappingTemplate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.requestMappingTemplateS3Location = software.amazon.jsii.Kernel.get(this, "requestMappingTemplateS3Location", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.responseMappingTemplate = software.amazon.jsii.Kernel.get(this, "responseMappingTemplate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.responseMappingTemplateS3Location = software.amazon.jsii.Kernel.get(this, "responseMappingTemplateS3Location", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.runtime = software.amazon.jsii.Kernel.get(this, "runtime", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.syncConfig = software.amazon.jsii.Kernel.get(this, "syncConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiId = java.util.Objects.requireNonNull(builder.apiId, "apiId is required");
            this.dataSourceName = java.util.Objects.requireNonNull(builder.dataSourceName, "dataSourceName is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.code = builder.code;
            this.codeS3Location = builder.codeS3Location;
            this.description = builder.description;
            this.functionVersion = builder.functionVersion;
            this.maxBatchSize = builder.maxBatchSize;
            this.requestMappingTemplate = builder.requestMappingTemplate;
            this.requestMappingTemplateS3Location = builder.requestMappingTemplateS3Location;
            this.responseMappingTemplate = builder.responseMappingTemplate;
            this.responseMappingTemplateS3Location = builder.responseMappingTemplateS3Location;
            this.runtime = builder.runtime;
            this.syncConfig = builder.syncConfig;
        }

        @Override
        public final java.lang.String getApiId() {
            return this.apiId;
        }

        @Override
        public final java.lang.String getDataSourceName() {
            return this.dataSourceName;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getCode() {
            return this.code;
        }

        @Override
        public final java.lang.String getCodeS3Location() {
            return this.codeS3Location;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getFunctionVersion() {
            return this.functionVersion;
        }

        @Override
        public final java.lang.Number getMaxBatchSize() {
            return this.maxBatchSize;
        }

        @Override
        public final java.lang.String getRequestMappingTemplate() {
            return this.requestMappingTemplate;
        }

        @Override
        public final java.lang.String getRequestMappingTemplateS3Location() {
            return this.requestMappingTemplateS3Location;
        }

        @Override
        public final java.lang.String getResponseMappingTemplate() {
            return this.responseMappingTemplate;
        }

        @Override
        public final java.lang.String getResponseMappingTemplateS3Location() {
            return this.responseMappingTemplateS3Location;
        }

        @Override
        public final java.lang.Object getRuntime() {
            return this.runtime;
        }

        @Override
        public final java.lang.Object getSyncConfig() {
            return this.syncConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("apiId", om.valueToTree(this.getApiId()));
            data.set("dataSourceName", om.valueToTree(this.getDataSourceName()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getCode() != null) {
                data.set("code", om.valueToTree(this.getCode()));
            }
            if (this.getCodeS3Location() != null) {
                data.set("codeS3Location", om.valueToTree(this.getCodeS3Location()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getFunctionVersion() != null) {
                data.set("functionVersion", om.valueToTree(this.getFunctionVersion()));
            }
            if (this.getMaxBatchSize() != null) {
                data.set("maxBatchSize", om.valueToTree(this.getMaxBatchSize()));
            }
            if (this.getRequestMappingTemplate() != null) {
                data.set("requestMappingTemplate", om.valueToTree(this.getRequestMappingTemplate()));
            }
            if (this.getRequestMappingTemplateS3Location() != null) {
                data.set("requestMappingTemplateS3Location", om.valueToTree(this.getRequestMappingTemplateS3Location()));
            }
            if (this.getResponseMappingTemplate() != null) {
                data.set("responseMappingTemplate", om.valueToTree(this.getResponseMappingTemplate()));
            }
            if (this.getResponseMappingTemplateS3Location() != null) {
                data.set("responseMappingTemplateS3Location", om.valueToTree(this.getResponseMappingTemplateS3Location()));
            }
            if (this.getRuntime() != null) {
                data.set("runtime", om.valueToTree(this.getRuntime()));
            }
            if (this.getSyncConfig() != null) {
                data.set("syncConfig", om.valueToTree(this.getSyncConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnFunctionConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFunctionConfigurationProps.Jsii$Proxy that = (CfnFunctionConfigurationProps.Jsii$Proxy) o;

            if (!apiId.equals(that.apiId)) return false;
            if (!dataSourceName.equals(that.dataSourceName)) return false;
            if (!name.equals(that.name)) return false;
            if (this.code != null ? !this.code.equals(that.code) : that.code != null) return false;
            if (this.codeS3Location != null ? !this.codeS3Location.equals(that.codeS3Location) : that.codeS3Location != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.functionVersion != null ? !this.functionVersion.equals(that.functionVersion) : that.functionVersion != null) return false;
            if (this.maxBatchSize != null ? !this.maxBatchSize.equals(that.maxBatchSize) : that.maxBatchSize != null) return false;
            if (this.requestMappingTemplate != null ? !this.requestMappingTemplate.equals(that.requestMappingTemplate) : that.requestMappingTemplate != null) return false;
            if (this.requestMappingTemplateS3Location != null ? !this.requestMappingTemplateS3Location.equals(that.requestMappingTemplateS3Location) : that.requestMappingTemplateS3Location != null) return false;
            if (this.responseMappingTemplate != null ? !this.responseMappingTemplate.equals(that.responseMappingTemplate) : that.responseMappingTemplate != null) return false;
            if (this.responseMappingTemplateS3Location != null ? !this.responseMappingTemplateS3Location.equals(that.responseMappingTemplateS3Location) : that.responseMappingTemplateS3Location != null) return false;
            if (this.runtime != null ? !this.runtime.equals(that.runtime) : that.runtime != null) return false;
            return this.syncConfig != null ? this.syncConfig.equals(that.syncConfig) : that.syncConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.apiId.hashCode();
            result = 31 * result + (this.dataSourceName.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.code != null ? this.code.hashCode() : 0);
            result = 31 * result + (this.codeS3Location != null ? this.codeS3Location.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.functionVersion != null ? this.functionVersion.hashCode() : 0);
            result = 31 * result + (this.maxBatchSize != null ? this.maxBatchSize.hashCode() : 0);
            result = 31 * result + (this.requestMappingTemplate != null ? this.requestMappingTemplate.hashCode() : 0);
            result = 31 * result + (this.requestMappingTemplateS3Location != null ? this.requestMappingTemplateS3Location.hashCode() : 0);
            result = 31 * result + (this.responseMappingTemplate != null ? this.responseMappingTemplate.hashCode() : 0);
            result = 31 * result + (this.responseMappingTemplateS3Location != null ? this.responseMappingTemplateS3Location.hashCode() : 0);
            result = 31 * result + (this.runtime != null ? this.runtime.hashCode() : 0);
            result = 31 * result + (this.syncConfig != null ? this.syncConfig.hashCode() : 0);
            return result;
        }
    }
}
