package software.amazon.awscdk.services.autoscalingplans;

/**
 * Properties for defining a <code>CfnScalingPlan</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.autoscalingplans.*;
 * CfnScalingPlanProps cfnScalingPlanProps = CfnScalingPlanProps.builder()
 *         .applicationSource(ApplicationSourceProperty.builder()
 *                 .cloudFormationStackArn("cloudFormationStackArn")
 *                 .tagFilters(List.of(TagFilterProperty.builder()
 *                         .key("key")
 *                         // the properties below are optional
 *                         .values(List.of("values"))
 *                         .build()))
 *                 .build())
 *         .scalingInstructions(List.of(ScalingInstructionProperty.builder()
 *                 .maxCapacity(123)
 *                 .minCapacity(123)
 *                 .resourceId("resourceId")
 *                 .scalableDimension("scalableDimension")
 *                 .serviceNamespace("serviceNamespace")
 *                 .targetTrackingConfigurations(List.of(TargetTrackingConfigurationProperty.builder()
 *                         .targetValue(123)
 *                         // the properties below are optional
 *                         .customizedScalingMetricSpecification(CustomizedScalingMetricSpecificationProperty.builder()
 *                                 .metricName("metricName")
 *                                 .namespace("namespace")
 *                                 .statistic("statistic")
 *                                 // the properties below are optional
 *                                 .dimensions(List.of(MetricDimensionProperty.builder()
 *                                         .name("name")
 *                                         .value("value")
 *                                         .build()))
 *                                 .unit("unit")
 *                                 .build())
 *                         .disableScaleIn(false)
 *                         .estimatedInstanceWarmup(123)
 *                         .predefinedScalingMetricSpecification(PredefinedScalingMetricSpecificationProperty.builder()
 *                                 .predefinedScalingMetricType("predefinedScalingMetricType")
 *                                 // the properties below are optional
 *                                 .resourceLabel("resourceLabel")
 *                                 .build())
 *                         .scaleInCooldown(123)
 *                         .scaleOutCooldown(123)
 *                         .build()))
 *                 // the properties below are optional
 *                 .customizedLoadMetricSpecification(CustomizedLoadMetricSpecificationProperty.builder()
 *                         .metricName("metricName")
 *                         .namespace("namespace")
 *                         .statistic("statistic")
 *                         // the properties below are optional
 *                         .dimensions(List.of(MetricDimensionProperty.builder()
 *                                 .name("name")
 *                                 .value("value")
 *                                 .build()))
 *                         .unit("unit")
 *                         .build())
 *                 .disableDynamicScaling(false)
 *                 .predefinedLoadMetricSpecification(PredefinedLoadMetricSpecificationProperty.builder()
 *                         .predefinedLoadMetricType("predefinedLoadMetricType")
 *                         // the properties below are optional
 *                         .resourceLabel("resourceLabel")
 *                         .build())
 *                 .predictiveScalingMaxCapacityBehavior("predictiveScalingMaxCapacityBehavior")
 *                 .predictiveScalingMaxCapacityBuffer(123)
 *                 .predictiveScalingMode("predictiveScalingMode")
 *                 .scalingPolicyUpdateBehavior("scalingPolicyUpdateBehavior")
 *                 .scheduledActionBufferTime(123)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:03.895Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscalingplans.CfnScalingPlanProps")
@software.amazon.jsii.Jsii.Proxy(CfnScalingPlanProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnScalingPlanProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A CloudFormation stack or a set of tags.
     * <p>
     * You can create one scaling plan per application source. The <code>ApplicationSource</code> property must be present to ensure interoperability with the AWS Auto Scaling console.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html#cfn-autoscalingplans-scalingplan-applicationsource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html#cfn-autoscalingplans-scalingplan-applicationsource</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getApplicationSource();

    /**
     * The scaling instructions.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html#cfn-autoscalingplans-scalingplan-scalinginstructions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html#cfn-autoscalingplans-scalingplan-scalinginstructions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getScalingInstructions();

    /**
     * @return a {@link Builder} of {@link CfnScalingPlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnScalingPlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnScalingPlanProps> {
        java.lang.Object applicationSource;
        java.lang.Object scalingInstructions;

        /**
         * Sets the value of {@link CfnScalingPlanProps#getApplicationSource}
         * @param applicationSource A CloudFormation stack or a set of tags. This parameter is required.
         *                          You can create one scaling plan per application source. The <code>ApplicationSource</code> property must be present to ensure interoperability with the AWS Auto Scaling console.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationSource(software.amazon.awscdk.IResolvable applicationSource) {
            this.applicationSource = applicationSource;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalingPlanProps#getApplicationSource}
         * @param applicationSource A CloudFormation stack or a set of tags. This parameter is required.
         *                          You can create one scaling plan per application source. The <code>ApplicationSource</code> property must be present to ensure interoperability with the AWS Auto Scaling console.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationSource(software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan.ApplicationSourceProperty applicationSource) {
            this.applicationSource = applicationSource;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalingPlanProps#getScalingInstructions}
         * @param scalingInstructions The scaling instructions. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingInstructions(software.amazon.awscdk.IResolvable scalingInstructions) {
            this.scalingInstructions = scalingInstructions;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalingPlanProps#getScalingInstructions}
         * @param scalingInstructions The scaling instructions. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingInstructions(java.util.List<? extends java.lang.Object> scalingInstructions) {
            this.scalingInstructions = scalingInstructions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnScalingPlanProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnScalingPlanProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnScalingPlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnScalingPlanProps {
        private final java.lang.Object applicationSource;
        private final java.lang.Object scalingInstructions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicationSource = software.amazon.jsii.Kernel.get(this, "applicationSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.scalingInstructions = software.amazon.jsii.Kernel.get(this, "scalingInstructions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationSource = java.util.Objects.requireNonNull(builder.applicationSource, "applicationSource is required");
            this.scalingInstructions = java.util.Objects.requireNonNull(builder.scalingInstructions, "scalingInstructions is required");
        }

        @Override
        public final java.lang.Object getApplicationSource() {
            return this.applicationSource;
        }

        @Override
        public final java.lang.Object getScalingInstructions() {
            return this.scalingInstructions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applicationSource", om.valueToTree(this.getApplicationSource()));
            data.set("scalingInstructions", om.valueToTree(this.getScalingInstructions()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscalingplans.CfnScalingPlanProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnScalingPlanProps.Jsii$Proxy that = (CfnScalingPlanProps.Jsii$Proxy) o;

            if (!applicationSource.equals(that.applicationSource)) return false;
            return this.scalingInstructions.equals(that.scalingInstructions);
        }

        @Override
        public final int hashCode() {
            int result = this.applicationSource.hashCode();
            result = 31 * result + (this.scalingInstructions.hashCode());
            return result;
        }
    }
}
