package software.amazon.awscdk.services.bcmdataexports;

/**
 * Creates a data export and specifies the data query, the delivery preference, and any optional resource tags.
 * <p>
 * A <code>DataQuery</code> consists of both a <code>QueryStatement</code> and <code>TableConfigurations</code> .
 * <p>
 * The <code>QueryStatement</code> is an SQL statement. Data Exports only supports a limited subset of the SQL syntax. For more information on the SQL syntax that is supported, see <a href="https://docs.aws.amazon.com/cur/latest/userguide/de-data-query.html">Data query</a> . To view the available tables and columns, see the <a href="https://docs.aws.amazon.com/cur/latest/userguide/de-table-dictionary.html">Data Exports table dictionary</a> .
 * <p>
 * The <code>TableConfigurations</code> is a collection of specified <code>TableProperties</code> for the table being queried in the <code>QueryStatement</code> . TableProperties are additional configurations you can provide to change the data and schema of a table. Each table can have different TableProperties. However, tables are not required to have any TableProperties. Each table property has a default value that it assumes if not specified. For more information on table configurations, see <a href="https://docs.aws.amazon.com/cur/latest/userguide/de-data-query.html">Data query</a> . To view the table properties available for each table, see the <a href="https://docs.aws.amazon.com/cur/latest/userguide/de-table-dictionary.html">Data Exports table dictionary</a> or use the <code>ListTables</code> API to get a response of all tables and their available properties.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.bcmdataexports.*;
 * CfnExport cfnExport = CfnExport.Builder.create(this, "MyCfnExport")
 *         .export(ExportProperty.builder()
 *                 .dataQuery(DataQueryProperty.builder()
 *                         .queryStatement("queryStatement")
 *                         // the properties below are optional
 *                         .tableConfigurations(Map.of(
 *                                 "tableConfigurationsKey", Map.of(
 *                                         "tableConfigurationsKey", "tableConfigurations")))
 *                         .build())
 *                 .destinationConfigurations(DestinationConfigurationsProperty.builder()
 *                         .s3Destination(S3DestinationProperty.builder()
 *                                 .s3Bucket("s3Bucket")
 *                                 .s3OutputConfigurations(S3OutputConfigurationsProperty.builder()
 *                                         .compression("compression")
 *                                         .format("format")
 *                                         .outputType("outputType")
 *                                         .overwrite("overwrite")
 *                                         .build())
 *                                 .s3Prefix("s3Prefix")
 *                                 .s3Region("s3Region")
 *                                 .build())
 *                         .build())
 *                 .name("name")
 *                 .refreshCadence(RefreshCadenceProperty.builder()
 *                         .frequency("frequency")
 *                         .build())
 *                 // the properties below are optional
 *                 .description("description")
 *                 .exportArn("exportArn")
 *                 .build())
 *         // the properties below are optional
 *         .tags(List.of(ResourceTagProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bcmdataexports-export.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bcmdataexports-export.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:04.186Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bcmdataexports.CfnExport")
public class CfnExport extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnExport(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnExport(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bcmdataexports.CfnExport.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnExport(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.bcmdataexports.CfnExportProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) for this export.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrExportArn() {
        return software.amazon.jsii.Kernel.get(this, "attrExportArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The details that are available for an export.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getExport() {
        return software.amazon.jsii.Kernel.get(this, "export", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The details that are available for an export.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExport(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "export", java.util.Objects.requireNonNull(value, "export is required"));
    }

    /**
     * The details that are available for an export.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExport(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.bcmdataexports.CfnExport.ExportProperty value) {
        software.amazon.jsii.Kernel.set(this, "export", java.util.Objects.requireNonNull(value, "export is required"));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.bcmdataexports.CfnExport.ResourceTagProperty> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.bcmdataexports.CfnExport.ResourceTagProperty>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bcmdataexports.CfnExport.ResourceTagProperty.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.bcmdataexports.CfnExport.ResourceTagProperty> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * The SQL query of column selections and row filters from the data table you want.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bcmdataexports.*;
     * DataQueryProperty dataQueryProperty = DataQueryProperty.builder()
     *         .queryStatement("queryStatement")
     *         // the properties below are optional
     *         .tableConfigurations(Map.of(
     *                 "tableConfigurationsKey", Map.of(
     *                         "tableConfigurationsKey", "tableConfigurations")))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-dataquery.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-dataquery.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bcmdataexports.CfnExport.DataQueryProperty")
    @software.amazon.jsii.Jsii.Proxy(DataQueryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataQueryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The query statement.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-dataquery.html#cfn-bcmdataexports-export-dataquery-querystatement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-dataquery.html#cfn-bcmdataexports-export-dataquery-querystatement</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getQueryStatement();

        /**
         * The table configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-dataquery.html#cfn-bcmdataexports-export-dataquery-tableconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-dataquery.html#cfn-bcmdataexports-export-dataquery-tableconfigurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTableConfigurations() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataQueryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataQueryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataQueryProperty> {
            java.lang.String queryStatement;
            java.lang.Object tableConfigurations;

            /**
             * Sets the value of {@link DataQueryProperty#getQueryStatement}
             * @param queryStatement The query statement. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryStatement(java.lang.String queryStatement) {
                this.queryStatement = queryStatement;
                return this;
            }

            /**
             * Sets the value of {@link DataQueryProperty#getTableConfigurations}
             * @param tableConfigurations The table configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableConfigurations(software.amazon.awscdk.IResolvable tableConfigurations) {
                this.tableConfigurations = tableConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link DataQueryProperty#getTableConfigurations}
             * @param tableConfigurations The table configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableConfigurations(java.util.Map<java.lang.String, ? extends java.lang.Object> tableConfigurations) {
                this.tableConfigurations = tableConfigurations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataQueryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataQueryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataQueryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataQueryProperty {
            private final java.lang.String queryStatement;
            private final java.lang.Object tableConfigurations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.queryStatement = software.amazon.jsii.Kernel.get(this, "queryStatement", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tableConfigurations = software.amazon.jsii.Kernel.get(this, "tableConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.queryStatement = java.util.Objects.requireNonNull(builder.queryStatement, "queryStatement is required");
                this.tableConfigurations = builder.tableConfigurations;
            }

            @Override
            public final java.lang.String getQueryStatement() {
                return this.queryStatement;
            }

            @Override
            public final java.lang.Object getTableConfigurations() {
                return this.tableConfigurations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("queryStatement", om.valueToTree(this.getQueryStatement()));
                if (this.getTableConfigurations() != null) {
                    data.set("tableConfigurations", om.valueToTree(this.getTableConfigurations()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bcmdataexports.CfnExport.DataQueryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataQueryProperty.Jsii$Proxy that = (DataQueryProperty.Jsii$Proxy) o;

                if (!queryStatement.equals(that.queryStatement)) return false;
                return this.tableConfigurations != null ? this.tableConfigurations.equals(that.tableConfigurations) : that.tableConfigurations == null;
            }

            @Override
            public final int hashCode() {
                int result = this.queryStatement.hashCode();
                result = 31 * result + (this.tableConfigurations != null ? this.tableConfigurations.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The destinations used for data exports.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bcmdataexports.*;
     * DestinationConfigurationsProperty destinationConfigurationsProperty = DestinationConfigurationsProperty.builder()
     *         .s3Destination(S3DestinationProperty.builder()
     *                 .s3Bucket("s3Bucket")
     *                 .s3OutputConfigurations(S3OutputConfigurationsProperty.builder()
     *                         .compression("compression")
     *                         .format("format")
     *                         .outputType("outputType")
     *                         .overwrite("overwrite")
     *                         .build())
     *                 .s3Prefix("s3Prefix")
     *                 .s3Region("s3Region")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-destinationconfigurations.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-destinationconfigurations.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bcmdataexports.CfnExport.DestinationConfigurationsProperty")
    @software.amazon.jsii.Jsii.Proxy(DestinationConfigurationsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DestinationConfigurationsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that describes the destination of the data exports file.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-destinationconfigurations.html#cfn-bcmdataexports-export-destinationconfigurations-s3destination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-destinationconfigurations.html#cfn-bcmdataexports-export-destinationconfigurations-s3destination</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3Destination();

        /**
         * @return a {@link Builder} of {@link DestinationConfigurationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DestinationConfigurationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DestinationConfigurationsProperty> {
            java.lang.Object s3Destination;

            /**
             * Sets the value of {@link DestinationConfigurationsProperty#getS3Destination}
             * @param s3Destination An object that describes the destination of the data exports file. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Destination(software.amazon.awscdk.IResolvable s3Destination) {
                this.s3Destination = s3Destination;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConfigurationsProperty#getS3Destination}
             * @param s3Destination An object that describes the destination of the data exports file. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Destination(software.amazon.awscdk.services.bcmdataexports.CfnExport.S3DestinationProperty s3Destination) {
                this.s3Destination = s3Destination;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DestinationConfigurationsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DestinationConfigurationsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DestinationConfigurationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DestinationConfigurationsProperty {
            private final java.lang.Object s3Destination;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Destination = software.amazon.jsii.Kernel.get(this, "s3Destination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Destination = java.util.Objects.requireNonNull(builder.s3Destination, "s3Destination is required");
            }

            @Override
            public final java.lang.Object getS3Destination() {
                return this.s3Destination;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3Destination", om.valueToTree(this.getS3Destination()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bcmdataexports.CfnExport.DestinationConfigurationsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DestinationConfigurationsProperty.Jsii$Proxy that = (DestinationConfigurationsProperty.Jsii$Proxy) o;

                return this.s3Destination.equals(that.s3Destination);
            }

            @Override
            public final int hashCode() {
                int result = this.s3Destination.hashCode();
                return result;
            }
        }
    }
    /**
     * The details that are available for an export.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bcmdataexports.*;
     * ExportProperty exportProperty = ExportProperty.builder()
     *         .dataQuery(DataQueryProperty.builder()
     *                 .queryStatement("queryStatement")
     *                 // the properties below are optional
     *                 .tableConfigurations(Map.of(
     *                         "tableConfigurationsKey", Map.of(
     *                                 "tableConfigurationsKey", "tableConfigurations")))
     *                 .build())
     *         .destinationConfigurations(DestinationConfigurationsProperty.builder()
     *                 .s3Destination(S3DestinationProperty.builder()
     *                         .s3Bucket("s3Bucket")
     *                         .s3OutputConfigurations(S3OutputConfigurationsProperty.builder()
     *                                 .compression("compression")
     *                                 .format("format")
     *                                 .outputType("outputType")
     *                                 .overwrite("overwrite")
     *                                 .build())
     *                         .s3Prefix("s3Prefix")
     *                         .s3Region("s3Region")
     *                         .build())
     *                 .build())
     *         .name("name")
     *         .refreshCadence(RefreshCadenceProperty.builder()
     *                 .frequency("frequency")
     *                 .build())
     *         // the properties below are optional
     *         .description("description")
     *         .exportArn("exportArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-export.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-export.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bcmdataexports.CfnExport.ExportProperty")
    @software.amazon.jsii.Jsii.Proxy(ExportProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExportProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The data query for this specific data export.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-export.html#cfn-bcmdataexports-export-export-dataquery">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-export.html#cfn-bcmdataexports-export-export-dataquery</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDataQuery();

        /**
         * The destination configuration for this specific data export.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-export.html#cfn-bcmdataexports-export-export-destinationconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-export.html#cfn-bcmdataexports-export-export-destinationconfigurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDestinationConfigurations();

        /**
         * The name of this specific data export.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-export.html#cfn-bcmdataexports-export-export-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-export.html#cfn-bcmdataexports-export-export-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The cadence for AWS to update the export in your S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-export.html#cfn-bcmdataexports-export-export-refreshcadence">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-export.html#cfn-bcmdataexports-export-export-refreshcadence</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRefreshCadence();

        /**
         * The description for this specific data export.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-export.html#cfn-bcmdataexports-export-export-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-export.html#cfn-bcmdataexports-export-export-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) for this export.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-export.html#cfn-bcmdataexports-export-export-exportarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-export.html#cfn-bcmdataexports-export-export-exportarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExportArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExportProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExportProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExportProperty> {
            java.lang.Object dataQuery;
            java.lang.Object destinationConfigurations;
            java.lang.String name;
            java.lang.Object refreshCadence;
            java.lang.String description;
            java.lang.String exportArn;

            /**
             * Sets the value of {@link ExportProperty#getDataQuery}
             * @param dataQuery The data query for this specific data export. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataQuery(software.amazon.awscdk.IResolvable dataQuery) {
                this.dataQuery = dataQuery;
                return this;
            }

            /**
             * Sets the value of {@link ExportProperty#getDataQuery}
             * @param dataQuery The data query for this specific data export. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataQuery(software.amazon.awscdk.services.bcmdataexports.CfnExport.DataQueryProperty dataQuery) {
                this.dataQuery = dataQuery;
                return this;
            }

            /**
             * Sets the value of {@link ExportProperty#getDestinationConfigurations}
             * @param destinationConfigurations The destination configuration for this specific data export. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationConfigurations(software.amazon.awscdk.IResolvable destinationConfigurations) {
                this.destinationConfigurations = destinationConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link ExportProperty#getDestinationConfigurations}
             * @param destinationConfigurations The destination configuration for this specific data export. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationConfigurations(software.amazon.awscdk.services.bcmdataexports.CfnExport.DestinationConfigurationsProperty destinationConfigurations) {
                this.destinationConfigurations = destinationConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link ExportProperty#getName}
             * @param name The name of this specific data export. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ExportProperty#getRefreshCadence}
             * @param refreshCadence The cadence for AWS to update the export in your S3 bucket. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder refreshCadence(software.amazon.awscdk.IResolvable refreshCadence) {
                this.refreshCadence = refreshCadence;
                return this;
            }

            /**
             * Sets the value of {@link ExportProperty#getRefreshCadence}
             * @param refreshCadence The cadence for AWS to update the export in your S3 bucket. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder refreshCadence(software.amazon.awscdk.services.bcmdataexports.CfnExport.RefreshCadenceProperty refreshCadence) {
                this.refreshCadence = refreshCadence;
                return this;
            }

            /**
             * Sets the value of {@link ExportProperty#getDescription}
             * @param description The description for this specific data export.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link ExportProperty#getExportArn}
             * @param exportArn The Amazon Resource Name (ARN) for this export.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exportArn(java.lang.String exportArn) {
                this.exportArn = exportArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExportProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExportProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExportProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExportProperty {
            private final java.lang.Object dataQuery;
            private final java.lang.Object destinationConfigurations;
            private final java.lang.String name;
            private final java.lang.Object refreshCadence;
            private final java.lang.String description;
            private final java.lang.String exportArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataQuery = software.amazon.jsii.Kernel.get(this, "dataQuery", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.destinationConfigurations = software.amazon.jsii.Kernel.get(this, "destinationConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.refreshCadence = software.amazon.jsii.Kernel.get(this, "refreshCadence", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.exportArn = software.amazon.jsii.Kernel.get(this, "exportArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataQuery = java.util.Objects.requireNonNull(builder.dataQuery, "dataQuery is required");
                this.destinationConfigurations = java.util.Objects.requireNonNull(builder.destinationConfigurations, "destinationConfigurations is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.refreshCadence = java.util.Objects.requireNonNull(builder.refreshCadence, "refreshCadence is required");
                this.description = builder.description;
                this.exportArn = builder.exportArn;
            }

            @Override
            public final java.lang.Object getDataQuery() {
                return this.dataQuery;
            }

            @Override
            public final java.lang.Object getDestinationConfigurations() {
                return this.destinationConfigurations;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getRefreshCadence() {
                return this.refreshCadence;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.String getExportArn() {
                return this.exportArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dataQuery", om.valueToTree(this.getDataQuery()));
                data.set("destinationConfigurations", om.valueToTree(this.getDestinationConfigurations()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("refreshCadence", om.valueToTree(this.getRefreshCadence()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getExportArn() != null) {
                    data.set("exportArn", om.valueToTree(this.getExportArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bcmdataexports.CfnExport.ExportProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExportProperty.Jsii$Proxy that = (ExportProperty.Jsii$Proxy) o;

                if (!dataQuery.equals(that.dataQuery)) return false;
                if (!destinationConfigurations.equals(that.destinationConfigurations)) return false;
                if (!name.equals(that.name)) return false;
                if (!refreshCadence.equals(that.refreshCadence)) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                return this.exportArn != null ? this.exportArn.equals(that.exportArn) : that.exportArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataQuery.hashCode();
                result = 31 * result + (this.destinationConfigurations.hashCode());
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.refreshCadence.hashCode());
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.exportArn != null ? this.exportArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The cadence for AWS to update the data export in your S3 bucket.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bcmdataexports.*;
     * RefreshCadenceProperty refreshCadenceProperty = RefreshCadenceProperty.builder()
     *         .frequency("frequency")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-refreshcadence.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-refreshcadence.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bcmdataexports.CfnExport.RefreshCadenceProperty")
    @software.amazon.jsii.Jsii.Proxy(RefreshCadenceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RefreshCadenceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The frequency that data exports are updated.
         * <p>
         * The export refreshes each time the source data updates, up to three times daily.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-refreshcadence.html#cfn-bcmdataexports-export-refreshcadence-frequency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-refreshcadence.html#cfn-bcmdataexports-export-refreshcadence-frequency</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFrequency();

        /**
         * @return a {@link Builder} of {@link RefreshCadenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RefreshCadenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RefreshCadenceProperty> {
            java.lang.String frequency;

            /**
             * Sets the value of {@link RefreshCadenceProperty#getFrequency}
             * @param frequency The frequency that data exports are updated. This parameter is required.
             *                  The export refreshes each time the source data updates, up to three times daily.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder frequency(java.lang.String frequency) {
                this.frequency = frequency;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RefreshCadenceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RefreshCadenceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RefreshCadenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RefreshCadenceProperty {
            private final java.lang.String frequency;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.frequency = software.amazon.jsii.Kernel.get(this, "frequency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.frequency = java.util.Objects.requireNonNull(builder.frequency, "frequency is required");
            }

            @Override
            public final java.lang.String getFrequency() {
                return this.frequency;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("frequency", om.valueToTree(this.getFrequency()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bcmdataexports.CfnExport.RefreshCadenceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RefreshCadenceProperty.Jsii$Proxy that = (RefreshCadenceProperty.Jsii$Proxy) o;

                return this.frequency.equals(that.frequency);
            }

            @Override
            public final int hashCode() {
                int result = this.frequency.hashCode();
                return result;
            }
        }
    }
    /**
     * The tag structure that contains a tag key and value.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bcmdataexports.*;
     * ResourceTagProperty resourceTagProperty = ResourceTagProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-resourcetag.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-resourcetag.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bcmdataexports.CfnExport.ResourceTagProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceTagProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceTagProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The key that's associated with the tag.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-resourcetag.html#cfn-bcmdataexports-export-resourcetag-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-resourcetag.html#cfn-bcmdataexports-export-resourcetag-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The value that's associated with the tag.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-resourcetag.html#cfn-bcmdataexports-export-resourcetag-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-resourcetag.html#cfn-bcmdataexports-export-resourcetag-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link ResourceTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceTagProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link ResourceTagProperty#getKey}
             * @param key The key that's associated with the tag. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link ResourceTagProperty#getValue}
             * @param value The value that's associated with the tag. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceTagProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceTagProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourceTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceTagProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bcmdataexports.CfnExport.ResourceTagProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceTagProperty.Jsii$Proxy that = (ResourceTagProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * Describes the destination Amazon Simple Storage Service (Amazon S3) bucket name and object keys of a data exports file.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bcmdataexports.*;
     * S3DestinationProperty s3DestinationProperty = S3DestinationProperty.builder()
     *         .s3Bucket("s3Bucket")
     *         .s3OutputConfigurations(S3OutputConfigurationsProperty.builder()
     *                 .compression("compression")
     *                 .format("format")
     *                 .outputType("outputType")
     *                 .overwrite("overwrite")
     *                 .build())
     *         .s3Prefix("s3Prefix")
     *         .s3Region("s3Region")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-s3destination.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-s3destination.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bcmdataexports.CfnExport.S3DestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3DestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3DestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the Amazon S3 bucket used as the destination of a data export file.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-s3destination.html#cfn-bcmdataexports-export-s3destination-s3bucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-s3destination.html#cfn-bcmdataexports-export-s3destination-s3bucket</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3Bucket();

        /**
         * The output configuration for the data export.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-s3destination.html#cfn-bcmdataexports-export-s3destination-s3outputconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-s3destination.html#cfn-bcmdataexports-export-s3destination-s3outputconfigurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3OutputConfigurations();

        /**
         * The S3 path prefix you want prepended to the name of your data export.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-s3destination.html#cfn-bcmdataexports-export-s3destination-s3prefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-s3destination.html#cfn-bcmdataexports-export-s3destination-s3prefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3Prefix();

        /**
         * The S3 bucket Region.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-s3destination.html#cfn-bcmdataexports-export-s3destination-s3region">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-s3destination.html#cfn-bcmdataexports-export-s3destination-s3region</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3Region();

        /**
         * @return a {@link Builder} of {@link S3DestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3DestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3DestinationProperty> {
            java.lang.String s3Bucket;
            java.lang.Object s3OutputConfigurations;
            java.lang.String s3Prefix;
            java.lang.String s3Region;

            /**
             * Sets the value of {@link S3DestinationProperty#getS3Bucket}
             * @param s3Bucket The name of the Amazon S3 bucket used as the destination of a data export file. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Bucket(java.lang.String s3Bucket) {
                this.s3Bucket = s3Bucket;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationProperty#getS3OutputConfigurations}
             * @param s3OutputConfigurations The output configuration for the data export. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3OutputConfigurations(software.amazon.awscdk.IResolvable s3OutputConfigurations) {
                this.s3OutputConfigurations = s3OutputConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationProperty#getS3OutputConfigurations}
             * @param s3OutputConfigurations The output configuration for the data export. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3OutputConfigurations(software.amazon.awscdk.services.bcmdataexports.CfnExport.S3OutputConfigurationsProperty s3OutputConfigurations) {
                this.s3OutputConfigurations = s3OutputConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationProperty#getS3Prefix}
             * @param s3Prefix The S3 path prefix you want prepended to the name of your data export. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Prefix(java.lang.String s3Prefix) {
                this.s3Prefix = s3Prefix;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationProperty#getS3Region}
             * @param s3Region The S3 bucket Region. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Region(java.lang.String s3Region) {
                this.s3Region = s3Region;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3DestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3DestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3DestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3DestinationProperty {
            private final java.lang.String s3Bucket;
            private final java.lang.Object s3OutputConfigurations;
            private final java.lang.String s3Prefix;
            private final java.lang.String s3Region;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Bucket = software.amazon.jsii.Kernel.get(this, "s3Bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3OutputConfigurations = software.amazon.jsii.Kernel.get(this, "s3OutputConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3Prefix = software.amazon.jsii.Kernel.get(this, "s3Prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Region = software.amazon.jsii.Kernel.get(this, "s3Region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Bucket = java.util.Objects.requireNonNull(builder.s3Bucket, "s3Bucket is required");
                this.s3OutputConfigurations = java.util.Objects.requireNonNull(builder.s3OutputConfigurations, "s3OutputConfigurations is required");
                this.s3Prefix = java.util.Objects.requireNonNull(builder.s3Prefix, "s3Prefix is required");
                this.s3Region = java.util.Objects.requireNonNull(builder.s3Region, "s3Region is required");
            }

            @Override
            public final java.lang.String getS3Bucket() {
                return this.s3Bucket;
            }

            @Override
            public final java.lang.Object getS3OutputConfigurations() {
                return this.s3OutputConfigurations;
            }

            @Override
            public final java.lang.String getS3Prefix() {
                return this.s3Prefix;
            }

            @Override
            public final java.lang.String getS3Region() {
                return this.s3Region;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3Bucket", om.valueToTree(this.getS3Bucket()));
                data.set("s3OutputConfigurations", om.valueToTree(this.getS3OutputConfigurations()));
                data.set("s3Prefix", om.valueToTree(this.getS3Prefix()));
                data.set("s3Region", om.valueToTree(this.getS3Region()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bcmdataexports.CfnExport.S3DestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3DestinationProperty.Jsii$Proxy that = (S3DestinationProperty.Jsii$Proxy) o;

                if (!s3Bucket.equals(that.s3Bucket)) return false;
                if (!s3OutputConfigurations.equals(that.s3OutputConfigurations)) return false;
                if (!s3Prefix.equals(that.s3Prefix)) return false;
                return this.s3Region.equals(that.s3Region);
            }

            @Override
            public final int hashCode() {
                int result = this.s3Bucket.hashCode();
                result = 31 * result + (this.s3OutputConfigurations.hashCode());
                result = 31 * result + (this.s3Prefix.hashCode());
                result = 31 * result + (this.s3Region.hashCode());
                return result;
            }
        }
    }
    /**
     * The compression type, file format, and overwrite preference for the data export.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bcmdataexports.*;
     * S3OutputConfigurationsProperty s3OutputConfigurationsProperty = S3OutputConfigurationsProperty.builder()
     *         .compression("compression")
     *         .format("format")
     *         .outputType("outputType")
     *         .overwrite("overwrite")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-s3outputconfigurations.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-s3outputconfigurations.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bcmdataexports.CfnExport.S3OutputConfigurationsProperty")
    @software.amazon.jsii.Jsii.Proxy(S3OutputConfigurationsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3OutputConfigurationsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The compression type for the data export.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-s3outputconfigurations.html#cfn-bcmdataexports-export-s3outputconfigurations-compression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-s3outputconfigurations.html#cfn-bcmdataexports-export-s3outputconfigurations-compression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCompression();

        /**
         * The file format for the data export.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-s3outputconfigurations.html#cfn-bcmdataexports-export-s3outputconfigurations-format">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-s3outputconfigurations.html#cfn-bcmdataexports-export-s3outputconfigurations-format</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFormat();

        /**
         * The output type for the data export.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-s3outputconfigurations.html#cfn-bcmdataexports-export-s3outputconfigurations-outputtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-s3outputconfigurations.html#cfn-bcmdataexports-export-s3outputconfigurations-outputtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOutputType();

        /**
         * The rule to follow when generating a version of the data export file.
         * <p>
         * You have the choice to overwrite the previous version or to be delivered in addition to the previous versions. Overwriting exports can save on Amazon S3 storage costs. Creating new export versions allows you to track the changes in cost and usage data over time.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-s3outputconfigurations.html#cfn-bcmdataexports-export-s3outputconfigurations-overwrite">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bcmdataexports-export-s3outputconfigurations.html#cfn-bcmdataexports-export-s3outputconfigurations-overwrite</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOverwrite();

        /**
         * @return a {@link Builder} of {@link S3OutputConfigurationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3OutputConfigurationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3OutputConfigurationsProperty> {
            java.lang.String compression;
            java.lang.String format;
            java.lang.String outputType;
            java.lang.String overwrite;

            /**
             * Sets the value of {@link S3OutputConfigurationsProperty#getCompression}
             * @param compression The compression type for the data export. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compression(java.lang.String compression) {
                this.compression = compression;
                return this;
            }

            /**
             * Sets the value of {@link S3OutputConfigurationsProperty#getFormat}
             * @param format The file format for the data export. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder format(java.lang.String format) {
                this.format = format;
                return this;
            }

            /**
             * Sets the value of {@link S3OutputConfigurationsProperty#getOutputType}
             * @param outputType The output type for the data export. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputType(java.lang.String outputType) {
                this.outputType = outputType;
                return this;
            }

            /**
             * Sets the value of {@link S3OutputConfigurationsProperty#getOverwrite}
             * @param overwrite The rule to follow when generating a version of the data export file. This parameter is required.
             *                  You have the choice to overwrite the previous version or to be delivered in addition to the previous versions. Overwriting exports can save on Amazon S3 storage costs. Creating new export versions allows you to track the changes in cost and usage data over time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overwrite(java.lang.String overwrite) {
                this.overwrite = overwrite;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3OutputConfigurationsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3OutputConfigurationsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3OutputConfigurationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3OutputConfigurationsProperty {
            private final java.lang.String compression;
            private final java.lang.String format;
            private final java.lang.String outputType;
            private final java.lang.String overwrite;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.compression = software.amazon.jsii.Kernel.get(this, "compression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.format = software.amazon.jsii.Kernel.get(this, "format", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outputType = software.amazon.jsii.Kernel.get(this, "outputType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.overwrite = software.amazon.jsii.Kernel.get(this, "overwrite", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.compression = java.util.Objects.requireNonNull(builder.compression, "compression is required");
                this.format = java.util.Objects.requireNonNull(builder.format, "format is required");
                this.outputType = java.util.Objects.requireNonNull(builder.outputType, "outputType is required");
                this.overwrite = java.util.Objects.requireNonNull(builder.overwrite, "overwrite is required");
            }

            @Override
            public final java.lang.String getCompression() {
                return this.compression;
            }

            @Override
            public final java.lang.String getFormat() {
                return this.format;
            }

            @Override
            public final java.lang.String getOutputType() {
                return this.outputType;
            }

            @Override
            public final java.lang.String getOverwrite() {
                return this.overwrite;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("compression", om.valueToTree(this.getCompression()));
                data.set("format", om.valueToTree(this.getFormat()));
                data.set("outputType", om.valueToTree(this.getOutputType()));
                data.set("overwrite", om.valueToTree(this.getOverwrite()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bcmdataexports.CfnExport.S3OutputConfigurationsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3OutputConfigurationsProperty.Jsii$Proxy that = (S3OutputConfigurationsProperty.Jsii$Proxy) o;

                if (!compression.equals(that.compression)) return false;
                if (!format.equals(that.format)) return false;
                if (!outputType.equals(that.outputType)) return false;
                return this.overwrite.equals(that.overwrite);
            }

            @Override
            public final int hashCode() {
                int result = this.compression.hashCode();
                result = 31 * result + (this.format.hashCode());
                result = 31 * result + (this.outputType.hashCode());
                result = 31 * result + (this.overwrite.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.bcmdataexports.CfnExport}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.bcmdataexports.CfnExport> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.bcmdataexports.CfnExportProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.bcmdataexports.CfnExportProps.Builder();
        }

        /**
         * The details that are available for an export.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bcmdataexports-export.html#cfn-bcmdataexports-export-export">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bcmdataexports-export.html#cfn-bcmdataexports-export-export</a>
         * @param export The details that are available for an export. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder export(final software.amazon.awscdk.IResolvable export) {
            this.props.export(export);
            return this;
        }
        /**
         * The details that are available for an export.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bcmdataexports-export.html#cfn-bcmdataexports-export-export">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bcmdataexports-export.html#cfn-bcmdataexports-export-export</a>
         * @param export The details that are available for an export. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder export(final software.amazon.awscdk.services.bcmdataexports.CfnExport.ExportProperty export) {
            this.props.export(export);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bcmdataexports-export.html#cfn-bcmdataexports-export-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bcmdataexports-export.html#cfn-bcmdataexports-export-tags</a>
         * @param tags This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.services.bcmdataexports.CfnExport.ResourceTagProperty> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.bcmdataexports.CfnExport}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.bcmdataexports.CfnExport build() {
            return new software.amazon.awscdk.services.bcmdataexports.CfnExport(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
