package software.amazon.awscdk.services.cognito;

/**
 * The <code>AWS::Cognito::UserPoolClient</code> resource specifies an Amazon Cognito user pool client.
 * <p>
 * <blockquote>
 * <p>
 * If you don't specify a value for a parameter, Amazon Cognito sets it to a default value.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.certificatemanager.*;
 * Vpc vpc;
 * Certificate certificate;
 * ApplicationLoadBalancer lb = ApplicationLoadBalancer.Builder.create(this, "LB")
 *         .vpc(vpc)
 *         .internetFacing(true)
 *         .build();
 * UserPool userPool = new UserPool(this, "UserPool");
 * UserPoolClient userPoolClient = UserPoolClient.Builder.create(this, "Client")
 *         .userPool(userPool)
 *         // Required minimal configuration for use with an ELB
 *         .generateSecret(true)
 *         .authFlows(AuthFlow.builder()
 *                 .userPassword(true)
 *                 .build())
 *         .oAuth(OAuthSettings.builder()
 *                 .flows(OAuthFlows.builder()
 *                         .authorizationCodeGrant(true)
 *                         .build())
 *                 .scopes(List.of(OAuthScope.EMAIL))
 *                 .callbackUrls(List.of(String.format("https://%s/oauth2/idpresponse", lb.getLoadBalancerDnsName())))
 *                 .build())
 *         .build();
 * CfnUserPoolClient cfnClient = (CfnUserPoolClient)userPoolClient.getNode().getDefaultChild();
 * cfnClient.addPropertyOverride("RefreshTokenValidity", 1);
 * cfnClient.addPropertyOverride("SupportedIdentityProviders", List.of("COGNITO"));
 * UserPoolDomain userPoolDomain = UserPoolDomain.Builder.create(this, "Domain")
 *         .userPool(userPool)
 *         .cognitoDomain(CognitoDomainOptions.builder()
 *                 .domainPrefix("test-cdk-prefix")
 *                 .build())
 *         .build();
 * lb.addListener("Listener", BaseApplicationListenerProps.builder()
 *         .port(443)
 *         .certificates(List.of(certificate))
 *         .defaultAction(AuthenticateCognitoAction.Builder.create()
 *                 .userPool(userPool)
 *                 .userPoolClient(userPoolClient)
 *                 .userPoolDomain(userPoolDomain)
 *                 .next(ListenerAction.fixedResponse(200, FixedResponseOptions.builder()
 *                         .contentType("text/plain")
 *                         .messageBody("Authenticated")
 *                         .build()))
 *                 .build())
 *         .build());
 * CfnOutput.Builder.create(this, "DNS")
 *         .value(lb.getLoadBalancerDnsName())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:05.539Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnUserPoolClient")
public class CfnUserPoolClient extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnUserPoolClient(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnUserPoolClient(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.CfnUserPoolClient.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnUserPoolClient(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.CfnUserPoolClientProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ID of the app client, for example <code>1example23456789</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrClientId() {
        return software.amazon.jsii.Kernel.get(this, "attrClientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrClientSecret() {
        return software.amazon.jsii.Kernel.get(this, "attrClientSecret", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrName() {
        return software.amazon.jsii.Kernel.get(this, "attrName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The user pool ID for the user pool where you want to create a user pool client.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getUserPoolId() {
        return software.amazon.jsii.Kernel.get(this, "userPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The user pool ID for the user pool where you want to create a user pool client.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserPoolId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "userPoolId", java.util.Objects.requireNonNull(value, "userPoolId is required"));
    }

    /**
     * The access token time limit.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getAccessTokenValidity() {
        return software.amazon.jsii.Kernel.get(this, "accessTokenValidity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The access token time limit.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessTokenValidity(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "accessTokenValidity", value);
    }

    /**
     * The OAuth grant types that you want your app client to generate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedOAuthFlows() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "allowedOAuthFlows", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The OAuth grant types that you want your app client to generate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowedOAuthFlows(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "allowedOAuthFlows", value);
    }

    /**
     * Set to <code>true</code> to use OAuth 2.0 features in your user pool app client.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAllowedOAuthFlowsUserPoolClient() {
        return software.amazon.jsii.Kernel.get(this, "allowedOAuthFlowsUserPoolClient", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Set to <code>true</code> to use OAuth 2.0 features in your user pool app client.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowedOAuthFlowsUserPoolClient(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "allowedOAuthFlowsUserPoolClient", value);
    }

    /**
     * Set to <code>true</code> to use OAuth 2.0 features in your user pool app client.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowedOAuthFlowsUserPoolClient(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "allowedOAuthFlowsUserPoolClient", value);
    }

    /**
     * The allowed OAuth scopes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedOAuthScopes() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "allowedOAuthScopes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The allowed OAuth scopes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowedOAuthScopes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "allowedOAuthScopes", value);
    }

    /**
     * The user pool analytics configuration for collecting metrics and sending them to your Amazon Pinpoint campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAnalyticsConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "analyticsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The user pool analytics configuration for collecting metrics and sending them to your Amazon Pinpoint campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAnalyticsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "analyticsConfiguration", value);
    }

    /**
     * The user pool analytics configuration for collecting metrics and sending them to your Amazon Pinpoint campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAnalyticsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.CfnUserPoolClient.AnalyticsConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "analyticsConfiguration", value);
    }

    /**
     * Amazon Cognito creates a session token for each API request in an authentication flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getAuthSessionValidity() {
        return software.amazon.jsii.Kernel.get(this, "authSessionValidity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Amazon Cognito creates a session token for each API request in an authentication flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthSessionValidity(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "authSessionValidity", value);
    }

    /**
     * A list of allowed redirect (callback) URLs for the IdPs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCallbackUrLs() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "callbackUrLs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of allowed redirect (callback) URLs for the IdPs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCallbackUrLs(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "callbackUrLs", value);
    }

    /**
     * The client name for the user pool client you would like to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getClientName() {
        return software.amazon.jsii.Kernel.get(this, "clientName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The client name for the user pool client you would like to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClientName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "clientName", value);
    }

    /**
     * The default redirect URI.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDefaultRedirectUri() {
        return software.amazon.jsii.Kernel.get(this, "defaultRedirectUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The default redirect URI.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultRedirectUri(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "defaultRedirectUri", value);
    }

    /**
     * Activates the propagation of additional user context data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnablePropagateAdditionalUserContextData() {
        return software.amazon.jsii.Kernel.get(this, "enablePropagateAdditionalUserContextData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Activates the propagation of additional user context data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnablePropagateAdditionalUserContextData(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enablePropagateAdditionalUserContextData", value);
    }

    /**
     * Activates the propagation of additional user context data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnablePropagateAdditionalUserContextData(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enablePropagateAdditionalUserContextData", value);
    }

    /**
     * Activates or deactivates token revocation.
     * <p>
     * For more information about revoking tokens, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html">RevokeToken</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnableTokenRevocation() {
        return software.amazon.jsii.Kernel.get(this, "enableTokenRevocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Activates or deactivates token revocation.
     * <p>
     * For more information about revoking tokens, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html">RevokeToken</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableTokenRevocation(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enableTokenRevocation", value);
    }

    /**
     * Activates or deactivates token revocation.
     * <p>
     * For more information about revoking tokens, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html">RevokeToken</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableTokenRevocation(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enableTokenRevocation", value);
    }

    /**
     * The authentication flows that you want your user pool client to support.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExplicitAuthFlows() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "explicitAuthFlows", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The authentication flows that you want your user pool client to support.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExplicitAuthFlows(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "explicitAuthFlows", value);
    }

    /**
     * Boolean to specify whether you want to generate a secret for the user pool client being created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getGenerateSecret() {
        return software.amazon.jsii.Kernel.get(this, "generateSecret", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Boolean to specify whether you want to generate a secret for the user pool client being created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGenerateSecret(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "generateSecret", value);
    }

    /**
     * Boolean to specify whether you want to generate a secret for the user pool client being created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGenerateSecret(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "generateSecret", value);
    }

    /**
     * The ID token time limit.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getIdTokenValidity() {
        return software.amazon.jsii.Kernel.get(this, "idTokenValidity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The ID token time limit.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdTokenValidity(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "idTokenValidity", value);
    }

    /**
     * A list of allowed logout URLs for the IdPs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLogoutUrLs() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "logoutUrLs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of allowed logout URLs for the IdPs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogoutUrLs(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "logoutUrLs", value);
    }

    /**
     * Errors and responses that you want Amazon Cognito APIs to return during authentication, account confirmation, and password recovery when the user doesn't exist in the user pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPreventUserExistenceErrors() {
        return software.amazon.jsii.Kernel.get(this, "preventUserExistenceErrors", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Errors and responses that you want Amazon Cognito APIs to return during authentication, account confirmation, and password recovery when the user doesn't exist in the user pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreventUserExistenceErrors(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "preventUserExistenceErrors", value);
    }

    /**
     * The list of user attributes that you want your app client to have read access to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getReadAttributes() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "readAttributes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The list of user attributes that you want your app client to have read access to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReadAttributes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "readAttributes", value);
    }

    /**
     * The refresh token time limit.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getRefreshTokenValidity() {
        return software.amazon.jsii.Kernel.get(this, "refreshTokenValidity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The refresh token time limit.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRefreshTokenValidity(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "refreshTokenValidity", value);
    }

    /**
     * A list of provider names for the identity providers (IdPs) that are supported on this client.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSupportedIdentityProviders() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "supportedIdentityProviders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of provider names for the identity providers (IdPs) that are supported on this client.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSupportedIdentityProviders(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "supportedIdentityProviders", value);
    }

    /**
     * The units in which the validity times are represented.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTokenValidityUnits() {
        return software.amazon.jsii.Kernel.get(this, "tokenValidityUnits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The units in which the validity times are represented.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTokenValidityUnits(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "tokenValidityUnits", value);
    }

    /**
     * The units in which the validity times are represented.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTokenValidityUnits(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.CfnUserPoolClient.TokenValidityUnitsProperty value) {
        software.amazon.jsii.Kernel.set(this, "tokenValidityUnits", value);
    }

    /**
     * The list of user attributes that you want your app client to have write access to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getWriteAttributes() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "writeAttributes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The list of user attributes that you want your app client to have write access to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWriteAttributes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "writeAttributes", value);
    }
    /**
     * The settings for Amazon Pinpoint analytics configuration.
     * <p>
     * With an analytics configuration, your application can collect user-activity metrics for user notifications with a Amazon Pinpoint campaign.
     * <p>
     * Amazon Pinpoint isn't available in all AWS Regions. For a list of available Regions, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-pinpoint-integration.html#cognito-user-pools-find-region-mappings">Amazon Cognito and Amazon Pinpoint Region availability</a> .
     * <p>
     * This data type is a request parameter of <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateUserPoolClient.html">CreateUserPoolClient</a> and <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateUserPoolClient.html">UpdateUserPoolClient</a> , and a response parameter of <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPoolClient.html">DescribeUserPoolClient</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * AnalyticsConfigurationProperty analyticsConfigurationProperty = AnalyticsConfigurationProperty.builder()
     *         .applicationArn("applicationArn")
     *         .applicationId("applicationId")
     *         .externalId("externalId")
     *         .roleArn("roleArn")
     *         .userDataShared(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-analyticsconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-analyticsconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnUserPoolClient.AnalyticsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AnalyticsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnalyticsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of an Amazon Pinpoint project that you want to connect to your user pool app client.
         * <p>
         * Amazon Cognito publishes events to the Amazon Pinpoint project that <code>ApplicationArn</code> declares. You can also configure your application to pass an endpoint ID in the <code>AnalyticsMetadata</code> parameter of sign-in operations. The endpoint ID is information about the destination for push notifications
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-analyticsconfiguration.html#cfn-cognito-userpoolclient-analyticsconfiguration-applicationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-analyticsconfiguration.html#cfn-cognito-userpoolclient-analyticsconfiguration-applicationarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getApplicationArn() {
            return null;
        }

        /**
         * Your Amazon Pinpoint project ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-analyticsconfiguration.html#cfn-cognito-userpoolclient-analyticsconfiguration-applicationid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-analyticsconfiguration.html#cfn-cognito-userpoolclient-analyticsconfiguration-applicationid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getApplicationId() {
            return null;
        }

        /**
         * The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html">external ID</a> of the role that Amazon Cognito assumes to send analytics data to Amazon Pinpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-analyticsconfiguration.html#cfn-cognito-userpoolclient-analyticsconfiguration-externalid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-analyticsconfiguration.html#cfn-cognito-userpoolclient-analyticsconfiguration-externalid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExternalId() {
            return null;
        }

        /**
         * The ARN of an AWS Identity and Access Management role that has the permissions required for Amazon Cognito to publish events to Amazon Pinpoint analytics.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-analyticsconfiguration.html#cfn-cognito-userpoolclient-analyticsconfiguration-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-analyticsconfiguration.html#cfn-cognito-userpoolclient-analyticsconfiguration-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
            return null;
        }

        /**
         * If <code>UserDataShared</code> is <code>true</code> , Amazon Cognito includes user data in the events that it publishes to Amazon Pinpoint analytics.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-analyticsconfiguration.html#cfn-cognito-userpoolclient-analyticsconfiguration-userdatashared">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-analyticsconfiguration.html#cfn-cognito-userpoolclient-analyticsconfiguration-userdatashared</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUserDataShared() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AnalyticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnalyticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnalyticsConfigurationProperty> {
            java.lang.String applicationArn;
            java.lang.String applicationId;
            java.lang.String externalId;
            java.lang.String roleArn;
            java.lang.Object userDataShared;

            /**
             * Sets the value of {@link AnalyticsConfigurationProperty#getApplicationArn}
             * @param applicationArn The Amazon Resource Name (ARN) of an Amazon Pinpoint project that you want to connect to your user pool app client.
             *                       Amazon Cognito publishes events to the Amazon Pinpoint project that <code>ApplicationArn</code> declares. You can also configure your application to pass an endpoint ID in the <code>AnalyticsMetadata</code> parameter of sign-in operations. The endpoint ID is information about the destination for push notifications
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationArn(java.lang.String applicationArn) {
                this.applicationArn = applicationArn;
                return this;
            }

            /**
             * Sets the value of {@link AnalyticsConfigurationProperty#getApplicationId}
             * @param applicationId Your Amazon Pinpoint project ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationId(java.lang.String applicationId) {
                this.applicationId = applicationId;
                return this;
            }

            /**
             * Sets the value of {@link AnalyticsConfigurationProperty#getExternalId}
             * @param externalId The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html">external ID</a> of the role that Amazon Cognito assumes to send analytics data to Amazon Pinpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder externalId(java.lang.String externalId) {
                this.externalId = externalId;
                return this;
            }

            /**
             * Sets the value of {@link AnalyticsConfigurationProperty#getRoleArn}
             * @param roleArn The ARN of an AWS Identity and Access Management role that has the permissions required for Amazon Cognito to publish events to Amazon Pinpoint analytics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link AnalyticsConfigurationProperty#getUserDataShared}
             * @param userDataShared If <code>UserDataShared</code> is <code>true</code> , Amazon Cognito includes user data in the events that it publishes to Amazon Pinpoint analytics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userDataShared(java.lang.Boolean userDataShared) {
                this.userDataShared = userDataShared;
                return this;
            }

            /**
             * Sets the value of {@link AnalyticsConfigurationProperty#getUserDataShared}
             * @param userDataShared If <code>UserDataShared</code> is <code>true</code> , Amazon Cognito includes user data in the events that it publishes to Amazon Pinpoint analytics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userDataShared(software.amazon.awscdk.IResolvable userDataShared) {
                this.userDataShared = userDataShared;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnalyticsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnalyticsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AnalyticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnalyticsConfigurationProperty {
            private final java.lang.String applicationArn;
            private final java.lang.String applicationId;
            private final java.lang.String externalId;
            private final java.lang.String roleArn;
            private final java.lang.Object userDataShared;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.applicationArn = software.amazon.jsii.Kernel.get(this, "applicationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.applicationId = software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.externalId = software.amazon.jsii.Kernel.get(this, "externalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userDataShared = software.amazon.jsii.Kernel.get(this, "userDataShared", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.applicationArn = builder.applicationArn;
                this.applicationId = builder.applicationId;
                this.externalId = builder.externalId;
                this.roleArn = builder.roleArn;
                this.userDataShared = builder.userDataShared;
            }

            @Override
            public final java.lang.String getApplicationArn() {
                return this.applicationArn;
            }

            @Override
            public final java.lang.String getApplicationId() {
                return this.applicationId;
            }

            @Override
            public final java.lang.String getExternalId() {
                return this.externalId;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.Object getUserDataShared() {
                return this.userDataShared;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getApplicationArn() != null) {
                    data.set("applicationArn", om.valueToTree(this.getApplicationArn()));
                }
                if (this.getApplicationId() != null) {
                    data.set("applicationId", om.valueToTree(this.getApplicationId()));
                }
                if (this.getExternalId() != null) {
                    data.set("externalId", om.valueToTree(this.getExternalId()));
                }
                if (this.getRoleArn() != null) {
                    data.set("roleArn", om.valueToTree(this.getRoleArn()));
                }
                if (this.getUserDataShared() != null) {
                    data.set("userDataShared", om.valueToTree(this.getUserDataShared()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CfnUserPoolClient.AnalyticsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnalyticsConfigurationProperty.Jsii$Proxy that = (AnalyticsConfigurationProperty.Jsii$Proxy) o;

                if (this.applicationArn != null ? !this.applicationArn.equals(that.applicationArn) : that.applicationArn != null) return false;
                if (this.applicationId != null ? !this.applicationId.equals(that.applicationId) : that.applicationId != null) return false;
                if (this.externalId != null ? !this.externalId.equals(that.externalId) : that.externalId != null) return false;
                if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
                return this.userDataShared != null ? this.userDataShared.equals(that.userDataShared) : that.userDataShared == null;
            }

            @Override
            public final int hashCode() {
                int result = this.applicationArn != null ? this.applicationArn.hashCode() : 0;
                result = 31 * result + (this.applicationId != null ? this.applicationId.hashCode() : 0);
                result = 31 * result + (this.externalId != null ? this.externalId.hashCode() : 0);
                result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
                result = 31 * result + (this.userDataShared != null ? this.userDataShared.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The time units you use when you set the duration of ID, access, and refresh tokens.
     * <p>
     * The default unit for RefreshToken is days, and the default for ID and access tokens is hours.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * TokenValidityUnitsProperty tokenValidityUnitsProperty = TokenValidityUnitsProperty.builder()
     *         .accessToken("accessToken")
     *         .idToken("idToken")
     *         .refreshToken("refreshToken")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-tokenvalidityunits.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-tokenvalidityunits.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnUserPoolClient.TokenValidityUnitsProperty")
    @software.amazon.jsii.Jsii.Proxy(TokenValidityUnitsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TokenValidityUnitsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A time unit for the value that you set in the <code>AccessTokenValidity</code> parameter.
         * <p>
         * The default <code>AccessTokenValidity</code> time unit is <code>hours</code> . <code>AccessTokenValidity</code> duration can range from five minutes to one day.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-tokenvalidityunits.html#cfn-cognito-userpoolclient-tokenvalidityunits-accesstoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-tokenvalidityunits.html#cfn-cognito-userpoolclient-tokenvalidityunits-accesstoken</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessToken() {
            return null;
        }

        /**
         * A time unit for the value that you set in the <code>IdTokenValidity</code> parameter.
         * <p>
         * The default <code>IdTokenValidity</code> time unit is <code>hours</code> . <code>IdTokenValidity</code> duration can range from five minutes to one day.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-tokenvalidityunits.html#cfn-cognito-userpoolclient-tokenvalidityunits-idtoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-tokenvalidityunits.html#cfn-cognito-userpoolclient-tokenvalidityunits-idtoken</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIdToken() {
            return null;
        }

        /**
         * A time unit for the value that you set in the <code>RefreshTokenValidity</code> parameter.
         * <p>
         * The default <code>RefreshTokenValidity</code> time unit is <code>days</code> . <code>RefreshTokenValidity</code> duration can range from 60 minutes to 10 years.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-tokenvalidityunits.html#cfn-cognito-userpoolclient-tokenvalidityunits-refreshtoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-tokenvalidityunits.html#cfn-cognito-userpoolclient-tokenvalidityunits-refreshtoken</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRefreshToken() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TokenValidityUnitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TokenValidityUnitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TokenValidityUnitsProperty> {
            java.lang.String accessToken;
            java.lang.String idToken;
            java.lang.String refreshToken;

            /**
             * Sets the value of {@link TokenValidityUnitsProperty#getAccessToken}
             * @param accessToken A time unit for the value that you set in the <code>AccessTokenValidity</code> parameter.
             *                    The default <code>AccessTokenValidity</code> time unit is <code>hours</code> . <code>AccessTokenValidity</code> duration can range from five minutes to one day.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessToken(java.lang.String accessToken) {
                this.accessToken = accessToken;
                return this;
            }

            /**
             * Sets the value of {@link TokenValidityUnitsProperty#getIdToken}
             * @param idToken A time unit for the value that you set in the <code>IdTokenValidity</code> parameter.
             *                The default <code>IdTokenValidity</code> time unit is <code>hours</code> . <code>IdTokenValidity</code> duration can range from five minutes to one day.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idToken(java.lang.String idToken) {
                this.idToken = idToken;
                return this;
            }

            /**
             * Sets the value of {@link TokenValidityUnitsProperty#getRefreshToken}
             * @param refreshToken A time unit for the value that you set in the <code>RefreshTokenValidity</code> parameter.
             *                     The default <code>RefreshTokenValidity</code> time unit is <code>days</code> . <code>RefreshTokenValidity</code> duration can range from 60 minutes to 10 years.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder refreshToken(java.lang.String refreshToken) {
                this.refreshToken = refreshToken;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TokenValidityUnitsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TokenValidityUnitsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TokenValidityUnitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TokenValidityUnitsProperty {
            private final java.lang.String accessToken;
            private final java.lang.String idToken;
            private final java.lang.String refreshToken;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessToken = software.amazon.jsii.Kernel.get(this, "accessToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.idToken = software.amazon.jsii.Kernel.get(this, "idToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.refreshToken = software.amazon.jsii.Kernel.get(this, "refreshToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessToken = builder.accessToken;
                this.idToken = builder.idToken;
                this.refreshToken = builder.refreshToken;
            }

            @Override
            public final java.lang.String getAccessToken() {
                return this.accessToken;
            }

            @Override
            public final java.lang.String getIdToken() {
                return this.idToken;
            }

            @Override
            public final java.lang.String getRefreshToken() {
                return this.refreshToken;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccessToken() != null) {
                    data.set("accessToken", om.valueToTree(this.getAccessToken()));
                }
                if (this.getIdToken() != null) {
                    data.set("idToken", om.valueToTree(this.getIdToken()));
                }
                if (this.getRefreshToken() != null) {
                    data.set("refreshToken", om.valueToTree(this.getRefreshToken()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CfnUserPoolClient.TokenValidityUnitsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TokenValidityUnitsProperty.Jsii$Proxy that = (TokenValidityUnitsProperty.Jsii$Proxy) o;

                if (this.accessToken != null ? !this.accessToken.equals(that.accessToken) : that.accessToken != null) return false;
                if (this.idToken != null ? !this.idToken.equals(that.idToken) : that.idToken != null) return false;
                return this.refreshToken != null ? this.refreshToken.equals(that.refreshToken) : that.refreshToken == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accessToken != null ? this.accessToken.hashCode() : 0;
                result = 31 * result + (this.idToken != null ? this.idToken.hashCode() : 0);
                result = 31 * result + (this.refreshToken != null ? this.refreshToken.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cognito.CfnUserPoolClient}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cognito.CfnUserPoolClient> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cognito.CfnUserPoolClientProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cognito.CfnUserPoolClientProps.Builder();
        }

        /**
         * The user pool ID for the user pool where you want to create a user pool client.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-userpoolid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-userpoolid</a>
         * @param userPoolId The user pool ID for the user pool where you want to create a user pool client. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolId(final java.lang.String userPoolId) {
            this.props.userPoolId(userPoolId);
            return this;
        }

        /**
         * The access token time limit.
         * <p>
         * After this limit expires, your user can't use their access token. To specify the time unit for <code>AccessTokenValidity</code> as <code>seconds</code> , <code>minutes</code> , <code>hours</code> , or <code>days</code> , set a <code>TokenValidityUnits</code> value in your API request.
         * <p>
         * For example, when you set <code>AccessTokenValidity</code> to <code>10</code> and <code>TokenValidityUnits</code> to <code>hours</code> , your user can authorize access with
         * their access token for 10 hours.
         * <p>
         * The default time unit for <code>AccessTokenValidity</code> in an API request is hours. <em>Valid range</em> is displayed below in seconds.
         * <p>
         * If you don't specify otherwise in the configuration of your app client, your access
         * tokens are valid for one hour.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-accesstokenvalidity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-accesstokenvalidity</a>
         * @param accessTokenValidity The access token time limit. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessTokenValidity(final java.lang.Number accessTokenValidity) {
            this.props.accessTokenValidity(accessTokenValidity);
            return this;
        }

        /**
         * The OAuth grant types that you want your app client to generate.
         * <p>
         * To create an app client that generates client credentials grants, you must add <code>client_credentials</code> as the only allowed OAuth flow.
         * <p>
         * <ul>
         * <li><strong>code</strong> - Use a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the <code>/oauth2/token</code> endpoint.</li>
         * <li><strong>implicit</strong> - Issue the access token (and, optionally, ID token, based on scopes) directly to your user.</li>
         * <li><strong>client_credentials</strong> - Issue the access token from the <code>/oauth2/token</code> endpoint directly to a non-person user using a combination of the client ID and client secret.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-allowedoauthflows">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-allowedoauthflows</a>
         * @param allowedOAuthFlows The OAuth grant types that you want your app client to generate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedOAuthFlows(final java.util.List<java.lang.String> allowedOAuthFlows) {
            this.props.allowedOAuthFlows(allowedOAuthFlows);
            return this;
        }

        /**
         * Set to <code>true</code> to use OAuth 2.0 features in your user pool app client.
         * <p>
         * <code>AllowedOAuthFlowsUserPoolClient</code> must be <code>true</code> before you can configure the following features in your app client.
         * <p>
         * <ul>
         * <li><code>CallBackURLs</code> : Callback URLs.</li>
         * <li><code>LogoutURLs</code> : Sign-out redirect URLs.</li>
         * <li><code>AllowedOAuthScopes</code> : OAuth 2.0 scopes.</li>
         * <li><code>AllowedOAuthFlows</code> : Support for authorization code, implicit, and client credentials OAuth 2.0 grants.</li>
         * </ul>
         * <p>
         * To use OAuth 2.0 features, configure one of these features in the Amazon Cognito console or set <code>AllowedOAuthFlowsUserPoolClient</code> to <code>true</code> in a <code>CreateUserPoolClient</code> or <code>UpdateUserPoolClient</code> API request. If you don't set a value for <code>AllowedOAuthFlowsUserPoolClient</code> in a request with the AWS CLI or SDKs, it defaults to <code>false</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-allowedoauthflowsuserpoolclient">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-allowedoauthflowsuserpoolclient</a>
         * @param allowedOAuthFlowsUserPoolClient Set to <code>true</code> to use OAuth 2.0 features in your user pool app client. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedOAuthFlowsUserPoolClient(final java.lang.Boolean allowedOAuthFlowsUserPoolClient) {
            this.props.allowedOAuthFlowsUserPoolClient(allowedOAuthFlowsUserPoolClient);
            return this;
        }
        /**
         * Set to <code>true</code> to use OAuth 2.0 features in your user pool app client.
         * <p>
         * <code>AllowedOAuthFlowsUserPoolClient</code> must be <code>true</code> before you can configure the following features in your app client.
         * <p>
         * <ul>
         * <li><code>CallBackURLs</code> : Callback URLs.</li>
         * <li><code>LogoutURLs</code> : Sign-out redirect URLs.</li>
         * <li><code>AllowedOAuthScopes</code> : OAuth 2.0 scopes.</li>
         * <li><code>AllowedOAuthFlows</code> : Support for authorization code, implicit, and client credentials OAuth 2.0 grants.</li>
         * </ul>
         * <p>
         * To use OAuth 2.0 features, configure one of these features in the Amazon Cognito console or set <code>AllowedOAuthFlowsUserPoolClient</code> to <code>true</code> in a <code>CreateUserPoolClient</code> or <code>UpdateUserPoolClient</code> API request. If you don't set a value for <code>AllowedOAuthFlowsUserPoolClient</code> in a request with the AWS CLI or SDKs, it defaults to <code>false</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-allowedoauthflowsuserpoolclient">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-allowedoauthflowsuserpoolclient</a>
         * @param allowedOAuthFlowsUserPoolClient Set to <code>true</code> to use OAuth 2.0 features in your user pool app client. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedOAuthFlowsUserPoolClient(final software.amazon.awscdk.IResolvable allowedOAuthFlowsUserPoolClient) {
            this.props.allowedOAuthFlowsUserPoolClient(allowedOAuthFlowsUserPoolClient);
            return this;
        }

        /**
         * The allowed OAuth scopes.
         * <p>
         * Possible values provided by OAuth are <code>phone</code> , <code>email</code> , <code>openid</code> , and <code>profile</code> . Possible values provided by AWS are <code>aws.cognito.signin.user.admin</code> . Custom scopes created in Resource Servers are also supported.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-allowedoauthscopes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-allowedoauthscopes</a>
         * @param allowedOAuthScopes The allowed OAuth scopes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedOAuthScopes(final java.util.List<java.lang.String> allowedOAuthScopes) {
            this.props.allowedOAuthScopes(allowedOAuthScopes);
            return this;
        }

        /**
         * The user pool analytics configuration for collecting metrics and sending them to your Amazon Pinpoint campaign.
         * <p>
         * <blockquote>
         * <p>
         * In AWS Regions where Amazon Pinpoint isn't available, user pools only support sending events to Amazon Pinpoint projects in AWS Region us-east-1. In Regions where Amazon Pinpoint is available, user pools support sending events to Amazon Pinpoint projects within that same Region.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-analyticsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-analyticsconfiguration</a>
         * @param analyticsConfiguration The user pool analytics configuration for collecting metrics and sending them to your Amazon Pinpoint campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analyticsConfiguration(final software.amazon.awscdk.IResolvable analyticsConfiguration) {
            this.props.analyticsConfiguration(analyticsConfiguration);
            return this;
        }
        /**
         * The user pool analytics configuration for collecting metrics and sending them to your Amazon Pinpoint campaign.
         * <p>
         * <blockquote>
         * <p>
         * In AWS Regions where Amazon Pinpoint isn't available, user pools only support sending events to Amazon Pinpoint projects in AWS Region us-east-1. In Regions where Amazon Pinpoint is available, user pools support sending events to Amazon Pinpoint projects within that same Region.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-analyticsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-analyticsconfiguration</a>
         * @param analyticsConfiguration The user pool analytics configuration for collecting metrics and sending them to your Amazon Pinpoint campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analyticsConfiguration(final software.amazon.awscdk.services.cognito.CfnUserPoolClient.AnalyticsConfigurationProperty analyticsConfiguration) {
            this.props.analyticsConfiguration(analyticsConfiguration);
            return this;
        }

        /**
         * Amazon Cognito creates a session token for each API request in an authentication flow.
         * <p>
         * <code>AuthSessionValidity</code> is the duration, in minutes, of that session token. Your user pool native user must respond to each authentication challenge before the session expires.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-authsessionvalidity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-authsessionvalidity</a>
         * @param authSessionValidity Amazon Cognito creates a session token for each API request in an authentication flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authSessionValidity(final java.lang.Number authSessionValidity) {
            this.props.authSessionValidity(authSessionValidity);
            return this;
        }

        /**
         * A list of allowed redirect (callback) URLs for the IdPs.
         * <p>
         * A redirect URI must:
         * <p>
         * <ul>
         * <li>Be an absolute URI.</li>
         * <li>Be registered with the authorization server.</li>
         * <li>Not include a fragment component.</li>
         * </ul>
         * <p>
         * See <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a> .
         * <p>
         * Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
         * <p>
         * App callback URLs such as myapp://example are also supported.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-callbackurls">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-callbackurls</a>
         * @param callbackUrLs A list of allowed redirect (callback) URLs for the IdPs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder callbackUrLs(final java.util.List<java.lang.String> callbackUrLs) {
            this.props.callbackUrLs(callbackUrLs);
            return this;
        }

        /**
         * The client name for the user pool client you would like to create.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-clientname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-clientname</a>
         * @param clientName The client name for the user pool client you would like to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientName(final java.lang.String clientName) {
            this.props.clientName(clientName);
            return this;
        }

        /**
         * The default redirect URI.
         * <p>
         * In app clients with one assigned IdP, replaces <code>redirect_uri</code> in authentication requests. Must be in the <code>CallbackURLs</code> list.
         * <p>
         * A redirect URI must:
         * <p>
         * <ul>
         * <li>Be an absolute URI.</li>
         * <li>Be registered with the authorization server.</li>
         * <li>Not include a fragment component.</li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-client-apps.html#cognito-user-pools-app-idp-settings-about">Default redirect URI</a> .
         * <p>
         * Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
         * <p>
         * App callback URLs such as myapp://example are also supported.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-defaultredirecturi">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-defaultredirecturi</a>
         * @param defaultRedirectUri The default redirect URI. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultRedirectUri(final java.lang.String defaultRedirectUri) {
            this.props.defaultRedirectUri(defaultRedirectUri);
            return this;
        }

        /**
         * Activates the propagation of additional user context data.
         * <p>
         * For more information about propagation of user context data, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html">Adding advanced security to a user pool</a> . If you don’t include this parameter, you can't send device fingerprint information, including source IP address, to Amazon Cognito advanced security. You can only activate <code>EnablePropagateAdditionalUserContextData</code> in an app client that has a client secret.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-enablepropagateadditionalusercontextdata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-enablepropagateadditionalusercontextdata</a>
         * @param enablePropagateAdditionalUserContextData Activates the propagation of additional user context data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enablePropagateAdditionalUserContextData(final java.lang.Boolean enablePropagateAdditionalUserContextData) {
            this.props.enablePropagateAdditionalUserContextData(enablePropagateAdditionalUserContextData);
            return this;
        }
        /**
         * Activates the propagation of additional user context data.
         * <p>
         * For more information about propagation of user context data, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html">Adding advanced security to a user pool</a> . If you don’t include this parameter, you can't send device fingerprint information, including source IP address, to Amazon Cognito advanced security. You can only activate <code>EnablePropagateAdditionalUserContextData</code> in an app client that has a client secret.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-enablepropagateadditionalusercontextdata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-enablepropagateadditionalusercontextdata</a>
         * @param enablePropagateAdditionalUserContextData Activates the propagation of additional user context data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enablePropagateAdditionalUserContextData(final software.amazon.awscdk.IResolvable enablePropagateAdditionalUserContextData) {
            this.props.enablePropagateAdditionalUserContextData(enablePropagateAdditionalUserContextData);
            return this;
        }

        /**
         * Activates or deactivates token revocation. For more information about revoking tokens, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html">RevokeToken</a> .
         * <p>
         * If you don't include this parameter, token revocation is automatically activated for the new user pool client.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-enabletokenrevocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-enabletokenrevocation</a>
         * @param enableTokenRevocation Activates or deactivates token revocation. For more information about revoking tokens, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html">RevokeToken</a> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableTokenRevocation(final java.lang.Boolean enableTokenRevocation) {
            this.props.enableTokenRevocation(enableTokenRevocation);
            return this;
        }
        /**
         * Activates or deactivates token revocation. For more information about revoking tokens, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html">RevokeToken</a> .
         * <p>
         * If you don't include this parameter, token revocation is automatically activated for the new user pool client.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-enabletokenrevocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-enabletokenrevocation</a>
         * @param enableTokenRevocation Activates or deactivates token revocation. For more information about revoking tokens, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html">RevokeToken</a> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableTokenRevocation(final software.amazon.awscdk.IResolvable enableTokenRevocation) {
            this.props.enableTokenRevocation(enableTokenRevocation);
            return this;
        }

        /**
         * The authentication flows that you want your user pool client to support.
         * <p>
         * For each app client in your user pool, you can sign in your users with any combination of one or more flows, including with a user name and Secure Remote Password (SRP), a user name and password, or a custom authentication process that you define with Lambda functions.
         * <p>
         * <blockquote>
         * <p>
         * If you don't specify a value for <code>ExplicitAuthFlows</code> , your user client supports <code>ALLOW_REFRESH_TOKEN_AUTH</code> , <code>ALLOW_USER_SRP_AUTH</code> , and <code>ALLOW_CUSTOM_AUTH</code> .
         * <p>
         * </blockquote>
         * <p>
         * Valid values include:
         * <p>
         * <ul>
         * <li><code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code> : Enable admin based user password authentication flow <code>ADMIN_USER_PASSWORD_AUTH</code> . This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With this authentication flow, your app passes a user name and password to Amazon Cognito in the request, instead of using the Secure Remote Password (SRP) protocol to securely transmit the password.</li>
         * <li><code>ALLOW_CUSTOM_AUTH</code> : Enable Lambda trigger based authentication.</li>
         * <li><code>ALLOW_USER_PASSWORD_AUTH</code> : Enable user password-based authentication. In this flow, Amazon Cognito receives the password in the request instead of using the SRP protocol to verify passwords.</li>
         * <li><code>ALLOW_USER_SRP_AUTH</code> : Enable SRP-based authentication.</li>
         * <li><code>ALLOW_REFRESH_TOKEN_AUTH</code> : Enable authflow to refresh tokens.</li>
         * </ul>
         * <p>
         * In some environments, you will see the values <code>ADMIN_NO_SRP_AUTH</code> , <code>CUSTOM_AUTH_FLOW_ONLY</code> , or <code>USER_PASSWORD_AUTH</code> . You can't assign these legacy <code>ExplicitAuthFlows</code> values to user pool clients at the same time as values that begin with <code>ALLOW_</code> ,
         * like <code>ALLOW_USER_SRP_AUTH</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-explicitauthflows">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-explicitauthflows</a>
         * @param explicitAuthFlows The authentication flows that you want your user pool client to support. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder explicitAuthFlows(final java.util.List<java.lang.String> explicitAuthFlows) {
            this.props.explicitAuthFlows(explicitAuthFlows);
            return this;
        }

        /**
         * Boolean to specify whether you want to generate a secret for the user pool client being created.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-generatesecret">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-generatesecret</a>
         * @param generateSecret Boolean to specify whether you want to generate a secret for the user pool client being created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder generateSecret(final java.lang.Boolean generateSecret) {
            this.props.generateSecret(generateSecret);
            return this;
        }
        /**
         * Boolean to specify whether you want to generate a secret for the user pool client being created.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-generatesecret">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-generatesecret</a>
         * @param generateSecret Boolean to specify whether you want to generate a secret for the user pool client being created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder generateSecret(final software.amazon.awscdk.IResolvable generateSecret) {
            this.props.generateSecret(generateSecret);
            return this;
        }

        /**
         * The ID token time limit.
         * <p>
         * After this limit expires, your user can't use their ID token. To specify the time unit for <code>IdTokenValidity</code> as <code>seconds</code> , <code>minutes</code> , <code>hours</code> , or <code>days</code> , set a <code>TokenValidityUnits</code> value in your API request.
         * <p>
         * For example, when you set <code>IdTokenValidity</code> as <code>10</code> and <code>TokenValidityUnits</code> as <code>hours</code> , your user can authenticate their session with their ID token for 10 hours.
         * <p>
         * The default time unit for <code>IdTokenValidity</code> in an API request is hours. <em>Valid range</em> is displayed below in seconds.
         * <p>
         * If you don't specify otherwise in the configuration of your app client, your ID
         * tokens are valid for one hour.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-idtokenvalidity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-idtokenvalidity</a>
         * @param idTokenValidity The ID token time limit. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idTokenValidity(final java.lang.Number idTokenValidity) {
            this.props.idTokenValidity(idTokenValidity);
            return this;
        }

        /**
         * A list of allowed logout URLs for the IdPs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-logouturls">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-logouturls</a>
         * @param logoutUrLs A list of allowed logout URLs for the IdPs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logoutUrLs(final java.util.List<java.lang.String> logoutUrLs) {
            this.props.logoutUrLs(logoutUrLs);
            return this;
        }

        /**
         * Errors and responses that you want Amazon Cognito APIs to return during authentication, account confirmation, and password recovery when the user doesn't exist in the user pool.
         * <p>
         * When set to <code>ENABLED</code> and the user doesn't exist, authentication returns an error indicating either the username or password was incorrect. Account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to <code>LEGACY</code> , those APIs return a <code>UserNotFoundException</code> exception if the user doesn't exist in the user pool.
         * <p>
         * Valid values include:
         * <p>
         * <ul>
         * <li><code>ENABLED</code> - This prevents user existence-related errors.</li>
         * <li><code>LEGACY</code> - This represents the early behavior of Amazon Cognito where user existence related errors aren't prevented.</li>
         * </ul>
         * <p>
         * Defaults to <code>LEGACY</code> when you don't provide a value.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-preventuserexistenceerrors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-preventuserexistenceerrors</a>
         * @param preventUserExistenceErrors Errors and responses that you want Amazon Cognito APIs to return during authentication, account confirmation, and password recovery when the user doesn't exist in the user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preventUserExistenceErrors(final java.lang.String preventUserExistenceErrors) {
            this.props.preventUserExistenceErrors(preventUserExistenceErrors);
            return this;
        }

        /**
         * The list of user attributes that you want your app client to have read access to.
         * <p>
         * After your user authenticates in your app, their access token authorizes them to read their own attribute value for any attribute in this list. An example of this kind of activity is when your user selects a link to view their profile information. Your app makes a <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetUser.html">GetUser</a> API request to retrieve and display your user's profile data.
         * <p>
         * When you don't specify the <code>ReadAttributes</code> for your app client, your app can read the values of <code>email_verified</code> , <code>phone_number_verified</code> , and the Standard attributes of your user pool. When your user pool app client has read access to these default attributes, <code>ReadAttributes</code> doesn't return any information. Amazon Cognito only populates <code>ReadAttributes</code> in the API response if you have specified your own custom set of read attributes.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-readattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-readattributes</a>
         * @param readAttributes The list of user attributes that you want your app client to have read access to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readAttributes(final java.util.List<java.lang.String> readAttributes) {
            this.props.readAttributes(readAttributes);
            return this;
        }

        /**
         * The refresh token time limit.
         * <p>
         * After this limit expires, your user can't use their refresh token. To specify the time unit for <code>RefreshTokenValidity</code> as <code>seconds</code> , <code>minutes</code> , <code>hours</code> , or <code>days</code> , set a <code>TokenValidityUnits</code> value in your API request.
         * <p>
         * For example, when you set <code>RefreshTokenValidity</code> as <code>10</code> and <code>TokenValidityUnits</code> as <code>days</code> , your user can refresh their session
         * and retrieve new access and ID tokens for 10 days.
         * <p>
         * The default time unit for <code>RefreshTokenValidity</code> in an API request is days. You can't set <code>RefreshTokenValidity</code> to 0. If you do, Amazon Cognito overrides the value with the default value of 30 days. <em>Valid range</em> is displayed below in seconds.
         * <p>
         * If you don't specify otherwise in the configuration of your app client, your refresh
         * tokens are valid for 30 days.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-refreshtokenvalidity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-refreshtokenvalidity</a>
         * @param refreshTokenValidity The refresh token time limit. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder refreshTokenValidity(final java.lang.Number refreshTokenValidity) {
            this.props.refreshTokenValidity(refreshTokenValidity);
            return this;
        }

        /**
         * A list of provider names for the identity providers (IdPs) that are supported on this client.
         * <p>
         * The following are supported: <code>COGNITO</code> , <code>Facebook</code> , <code>Google</code> , <code>SignInWithApple</code> , and <code>LoginWithAmazon</code> . You can also specify the names that you configured for the SAML and OIDC IdPs in your user pool, for example <code>MySAMLIdP</code> or <code>MyOIDCIdP</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-supportedidentityproviders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-supportedidentityproviders</a>
         * @param supportedIdentityProviders A list of provider names for the identity providers (IdPs) that are supported on this client. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder supportedIdentityProviders(final java.util.List<java.lang.String> supportedIdentityProviders) {
            this.props.supportedIdentityProviders(supportedIdentityProviders);
            return this;
        }

        /**
         * The units in which the validity times are represented.
         * <p>
         * The default unit for RefreshToken is days, and default for ID and access tokens are hours.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-tokenvalidityunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-tokenvalidityunits</a>
         * @param tokenValidityUnits The units in which the validity times are represented. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tokenValidityUnits(final software.amazon.awscdk.IResolvable tokenValidityUnits) {
            this.props.tokenValidityUnits(tokenValidityUnits);
            return this;
        }
        /**
         * The units in which the validity times are represented.
         * <p>
         * The default unit for RefreshToken is days, and default for ID and access tokens are hours.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-tokenvalidityunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-tokenvalidityunits</a>
         * @param tokenValidityUnits The units in which the validity times are represented. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tokenValidityUnits(final software.amazon.awscdk.services.cognito.CfnUserPoolClient.TokenValidityUnitsProperty tokenValidityUnits) {
            this.props.tokenValidityUnits(tokenValidityUnits);
            return this;
        }

        /**
         * The list of user attributes that you want your app client to have write access to.
         * <p>
         * After your user authenticates in your app, their access token authorizes them to set or modify their own attribute value for any attribute in this list. An example of this kind of activity is when you present your user with a form to update their profile information and they change their last name. Your app then makes an <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateUserAttributes.html">UpdateUserAttributes</a> API request and sets <code>family_name</code> to the new value.
         * <p>
         * When you don't specify the <code>WriteAttributes</code> for your app client, your app can write the values of the Standard attributes of your user pool. When your user pool has write access to these default attributes, <code>WriteAttributes</code> doesn't return any information. Amazon Cognito only populates <code>WriteAttributes</code> in the API response if you have specified your own custom set of write attributes.
         * <p>
         * If your app client allows users to sign in through an IdP, this array must include all attributes that you have mapped to IdP attributes. Amazon Cognito updates mapped attributes when users sign in to your application through an IdP. If your app client does not have write access to a mapped attribute, Amazon Cognito throws an error when it tries to update the attribute. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html">Specifying IdP Attribute Mappings for Your user pool</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-writeattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-writeattributes</a>
         * @param writeAttributes The list of user attributes that you want your app client to have write access to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder writeAttributes(final java.util.List<java.lang.String> writeAttributes) {
            this.props.writeAttributes(writeAttributes);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cognito.CfnUserPoolClient}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cognito.CfnUserPoolClient build() {
            return new software.amazon.awscdk.services.cognito.CfnUserPoolClient(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
