package software.amazon.awscdk.services.cognito;

/**
 * Represents an identity provider that integrates with SAML.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool userpool = new UserPool(this, "Pool");
 * // specify the metadata as a file content
 * // specify the metadata as a file content
 * UserPoolIdentityProviderSaml.Builder.create(this, "userpoolIdpFile")
 *         .userPool(userpool)
 *         .metadata(UserPoolIdentityProviderSamlMetadata.file("my-file-contents"))
 *         // Whether to require encrypted SAML assertions from IdP
 *         .encryptedResponses(true)
 *         // The signing algorithm for the SAML requests
 *         .requestSigningAlgorithm(SigningAlgorithm.RSA_SHA256)
 *         // Enable IdP initiated SAML auth flow
 *         .idpInitiated(true)
 *         .build();
 * // specify the metadata as a URL
 * // specify the metadata as a URL
 * UserPoolIdentityProviderSaml.Builder.create(this, "userpoolidpUrl")
 *         .userPool(userpool)
 *         .metadata(UserPoolIdentityProviderSamlMetadata.url("https://my-metadata-url.com"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:05.647Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.UserPoolIdentityProviderSaml")
public class UserPoolIdentityProviderSaml extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.cognito.IUserPoolIdentityProvider {

    protected UserPoolIdentityProviderSaml(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected UserPoolIdentityProviderSaml(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public UserPoolIdentityProviderSaml(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolIdentityProviderSamlProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Object configureAttributeMapping() {
        return software.amazon.jsii.Kernel.call(this, "configureAttributeMapping", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The primary identifier of this identity provider.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getProviderName() {
        return software.amazon.jsii.Kernel.get(this, "providerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cognito.UserPoolIdentityProviderSaml}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cognito.UserPoolIdentityProviderSaml> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cognito.UserPoolIdentityProviderSamlProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cognito.UserPoolIdentityProviderSamlProps.Builder();
        }

        /**
         * The user pool to which this construct provides identities.
         * <p>
         * @return {@code this}
         * @param userPool The user pool to which this construct provides identities. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPool(final software.amazon.awscdk.services.cognito.IUserPool userPool) {
            this.props.userPool(userPool);
            return this;
        }

        /**
         * Mapping attributes from the identity provider to standard and custom attributes of the user pool.
         * <p>
         * Default: - no attribute mapping
         * <p>
         * @return {@code this}
         * @param attributeMapping Mapping attributes from the identity provider to standard and custom attributes of the user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributeMapping(final software.amazon.awscdk.services.cognito.AttributeMapping attributeMapping) {
            this.props.attributeMapping(attributeMapping);
            return this;
        }

        /**
         * The SAML metadata.
         * <p>
         * @return {@code this}
         * @param metadata The SAML metadata. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(final software.amazon.awscdk.services.cognito.UserPoolIdentityProviderSamlMetadata metadata) {
            this.props.metadata(metadata);
            return this;
        }

        /**
         * Whether to require encrypted SAML assertions from IdP.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-SAML-signing-encryption.html#cognito-user-pools-SAML-encryption">https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-SAML-signing-encryption.html#cognito-user-pools-SAML-encryption</a>
         * @param encryptedResponses Whether to require encrypted SAML assertions from IdP. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptedResponses(final java.lang.Boolean encryptedResponses) {
            this.props.encryptedResponses(encryptedResponses);
            return this;
        }

        /**
         * Identifiers.
         * <p>
         * Identifiers can be used to redirect users to the correct IdP in multitenant apps.
         * <p>
         * Default: - no identifiers used
         * <p>
         * @return {@code this}
         * @param identifiers Identifiers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identifiers(final java.util.List<java.lang.String> identifiers) {
            this.props.identifiers(identifiers);
            return this;
        }

        /**
         * Whether to enable IdP-initiated SAML auth flows.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param idpInitiated Whether to enable IdP-initiated SAML auth flows. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idpInitiated(final java.lang.Boolean idpInitiated) {
            this.props.idpInitiated(idpInitiated);
            return this;
        }

        /**
         * Whether to enable the "Sign-out flow" feature.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param idpSignout Whether to enable the "Sign-out flow" feature. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idpSignout(final java.lang.Boolean idpSignout) {
            this.props.idpSignout(idpSignout);
            return this;
        }

        /**
         * The name of the provider.
         * <p>
         * Must be between 3 and 32 characters.
         * <p>
         * Default: - the unique ID of the construct
         * <p>
         * @return {@code this}
         * @param name The name of the provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The signing algorithm for SAML requests.
         * <p>
         * Default: - don't sign requests
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-SAML-signing-encryption.html#cognito-user-pools-SAML-signing">https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-SAML-signing-encryption.html#cognito-user-pools-SAML-signing</a>
         * @param requestSigningAlgorithm The signing algorithm for SAML requests. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestSigningAlgorithm(final software.amazon.awscdk.services.cognito.SigningAlgorithm requestSigningAlgorithm) {
            this.props.requestSigningAlgorithm(requestSigningAlgorithm);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cognito.UserPoolIdentityProviderSaml}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cognito.UserPoolIdentityProviderSaml build() {
            return new software.amazon.awscdk.services.cognito.UserPoolIdentityProviderSaml(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
