package software.amazon.awscdk.services.config;

/**
 * The <code>AWS::Config::ConfigurationRecorder</code> resource type describes the AWS resource types that AWS Config records for configuration changes.
 * <p>
 * The configuration recorder stores the configuration changes of the specified resources in your account as configuration items.
 * <p>
 * <blockquote>
 * <p>
 * To enable AWS Config , you must create a configuration recorder and a delivery channel.
 * <p>
 * AWS Config uses the delivery channel to deliver the configuration changes to your Amazon S3 bucket or Amazon SNS topic. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-deliverychannel.html">AWS::Config::DeliveryChannel</a> .
 * <p>
 * </blockquote>
 * <p>
 * AWS CloudFormation starts the recorder as soon as the delivery channel is available.
 * <p>
 * To stop the recorder and delete it, delete the configuration recorder from your stack. To stop the recorder without deleting it, call the <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_StopConfigurationRecorder.html">StopConfigurationRecorder</a> action of the AWS Config API directly.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/config-concepts.html#config-recorder">Configuration Recorder</a> in the AWS Config Developer Guide.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.config.*;
 * CfnConfigurationRecorder cfnConfigurationRecorder = CfnConfigurationRecorder.Builder.create(this, "MyCfnConfigurationRecorder")
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .name("name")
 *         .recordingGroup(RecordingGroupProperty.builder()
 *                 .allSupported(false)
 *                 .exclusionByResourceTypes(ExclusionByResourceTypesProperty.builder()
 *                         .resourceTypes(List.of("resourceTypes"))
 *                         .build())
 *                 .includeGlobalResourceTypes(false)
 *                 .recordingStrategy(RecordingStrategyProperty.builder()
 *                         .useOnly("useOnly")
 *                         .build())
 *                 .resourceTypes(List.of("resourceTypes"))
 *                 .build())
 *         .recordingMode(RecordingModeProperty.builder()
 *                 .recordingFrequency("recordingFrequency")
 *                 // the properties below are optional
 *                 .recordingModeOverrides(List.of(RecordingModeOverrideProperty.builder()
 *                         .recordingFrequency("recordingFrequency")
 *                         .resourceTypes(List.of("resourceTypes"))
 *                         // the properties below are optional
 *                         .description("description")
 *                         .build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:05.695Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CfnConfigurationRecorder")
public class CfnConfigurationRecorder extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnConfigurationRecorder(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConfigurationRecorder(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.CfnConfigurationRecorder.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConfigurationRecorder(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.config.CfnConfigurationRecorderProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Amazon Resource Name (ARN) of the IAM role assumed by AWS Config and used by the configuration recorder.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Amazon Resource Name (ARN) of the IAM role assumed by AWS Config and used by the configuration recorder.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * The name of the configuration recorder.
     * <p>
     * AWS Config automatically assigns the name of "default" when creating the configuration recorder.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the configuration recorder.
     * <p>
     * AWS Config automatically assigns the name of "default" when creating the configuration recorder.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * Specifies which resource types AWS Config records for configuration changes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRecordingGroup() {
        return software.amazon.jsii.Kernel.get(this, "recordingGroup", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies which resource types AWS Config records for configuration changes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecordingGroup(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "recordingGroup", value);
    }

    /**
     * Specifies which resource types AWS Config records for configuration changes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecordingGroup(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.config.CfnConfigurationRecorder.RecordingGroupProperty value) {
        software.amazon.jsii.Kernel.set(this, "recordingGroup", value);
    }

    /**
     * Specifies the default recording frequency that AWS Config uses to record configuration changes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRecordingMode() {
        return software.amazon.jsii.Kernel.get(this, "recordingMode", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the default recording frequency that AWS Config uses to record configuration changes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecordingMode(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "recordingMode", value);
    }

    /**
     * Specifies the default recording frequency that AWS Config uses to record configuration changes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecordingMode(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.config.CfnConfigurationRecorder.RecordingModeProperty value) {
        software.amazon.jsii.Kernel.set(this, "recordingMode", value);
    }
    /**
     * Specifies whether the configuration recorder excludes certain resource types from being recorded.
     * <p>
     * Use the <code>ResourceTypes</code> field to enter a comma-separated list of resource types you want to exclude from recording.
     * <p>
     * By default, when AWS Config adds support for a new resource type in the Region where you set up the configuration recorder, including global resource types, AWS Config starts recording resources of that type automatically.
     * <p>
     * <blockquote>
     * <p>
     * <em>How to use the exclusion recording strategy</em>
     * <p>
     * To use this option, you must set the <code>useOnly</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingStrategy.html">RecordingStrategy</a> to <code>EXCLUSION_BY_RESOURCE_TYPES</code> .
     * <p>
     * AWS Config will then record configuration changes for all supported resource types, except the resource types that you specify to exclude from being recorded.
     * <p>
     * <em>Global resource types and the exclusion recording strategy</em>
     * <p>
     * Unless specifically listed as exclusions, <code>AWS::RDS::GlobalCluster</code> will be recorded automatically in all supported AWS Config Regions were the configuration recorder is enabled.
     * <p>
     * IAM users, groups, roles, and customer managed policies will be recorded in the Region where you set up the configuration recorder if that is a Region where AWS Config was available before February 2022. You cannot be record the global IAM resouce types in Regions supported by AWS Config after February 2022. This list where you cannot record the global IAM resource types includes the following Regions:
     * <p>
     * <ul>
     * <li>Asia Pacific (Hyderabad)</li>
     * <li>Asia Pacific (Melbourne)</li>
     * <li>Canada West (Calgary)</li>
     * <li>Europe (Spain)</li>
     * <li>Europe (Zurich)</li>
     * <li>Israel (Tel Aviv)</li>
     * <li>Middle East (UAE)</li>
     * </ul>
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.config.*;
     * ExclusionByResourceTypesProperty exclusionByResourceTypesProperty = ExclusionByResourceTypesProperty.builder()
     *         .resourceTypes(List.of("resourceTypes"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-exclusionbyresourcetypes.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-exclusionbyresourcetypes.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CfnConfigurationRecorder.ExclusionByResourceTypesProperty")
    @software.amazon.jsii.Jsii.Proxy(ExclusionByResourceTypesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExclusionByResourceTypesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A comma-separated list of resource types to exclude from recording by the configuration recorder.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-exclusionbyresourcetypes.html#cfn-config-configurationrecorder-exclusionbyresourcetypes-resourcetypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-exclusionbyresourcetypes.html#cfn-config-configurationrecorder-exclusionbyresourcetypes-resourcetypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getResourceTypes();

        /**
         * @return a {@link Builder} of {@link ExclusionByResourceTypesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExclusionByResourceTypesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExclusionByResourceTypesProperty> {
            java.util.List<java.lang.String> resourceTypes;

            /**
             * Sets the value of {@link ExclusionByResourceTypesProperty#getResourceTypes}
             * @param resourceTypes A comma-separated list of resource types to exclude from recording by the configuration recorder. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceTypes(java.util.List<java.lang.String> resourceTypes) {
                this.resourceTypes = resourceTypes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExclusionByResourceTypesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExclusionByResourceTypesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExclusionByResourceTypesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExclusionByResourceTypesProperty {
            private final java.util.List<java.lang.String> resourceTypes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceTypes = software.amazon.jsii.Kernel.get(this, "resourceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceTypes = java.util.Objects.requireNonNull(builder.resourceTypes, "resourceTypes is required");
            }

            @Override
            public final java.util.List<java.lang.String> getResourceTypes() {
                return this.resourceTypes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("resourceTypes", om.valueToTree(this.getResourceTypes()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_config.CfnConfigurationRecorder.ExclusionByResourceTypesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExclusionByResourceTypesProperty.Jsii$Proxy that = (ExclusionByResourceTypesProperty.Jsii$Proxy) o;

                return this.resourceTypes.equals(that.resourceTypes);
            }

            @Override
            public final int hashCode() {
                int result = this.resourceTypes.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies which resource types AWS Config records for configuration changes.
     * <p>
     * By default, AWS Config records configuration changes for all current and future supported resource types in the AWS Region where you have enabled AWS Config , excluding the global IAM resource types: IAM users, groups, roles, and customer managed policies.
     * <p>
     * In the recording group, you specify whether you want to record all supported current and future supported resource types or to include or exclude specific resources types. For a list of supported resource types, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources">Supported Resource Types</a> in the <em>AWS Config developer guide</em> .
     * <p>
     * If you don't want AWS Config to record all current and future supported resource types (excluding the global IAM resource types), use one of the following recording strategies:
     * <p>
     * <ul>
     * <li><em>Record all current and future resource types with exclusions</em> ( <code>EXCLUSION_BY_RESOURCE_TYPES</code> ), or</li>
     * <li><em>Record specific resource types</em> ( <code>INCLUSION_BY_RESOURCE_TYPES</code> ).</li>
     * </ul>
     * <p>
     * If you use the recording strategy to <em>Record all current and future resource types</em> ( <code>ALL_SUPPORTED_RESOURCE_TYPES</code> ), you can use the flag <code>IncludeGlobalResourceTypes</code> to include the global IAM resource types in your recording.
     * <p>
     * <blockquote>
     * <p>
     * <em>Aurora global clusters are recorded in all enabled Regions</em>
     * <p>
     * The <code>AWS::RDS::GlobalCluster</code> resource type will be recorded in all supported AWS Config Regions where the configuration recorder is enabled.
     * <p>
     * If you do not want to record <code>AWS::RDS::GlobalCluster</code> in all enabled Regions, use the <code>EXCLUSION_BY_RESOURCE_TYPES</code> or <code>INCLUSION_BY_RESOURCE_TYPES</code> recording strategy.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.config.*;
     * RecordingGroupProperty recordingGroupProperty = RecordingGroupProperty.builder()
     *         .allSupported(false)
     *         .exclusionByResourceTypes(ExclusionByResourceTypesProperty.builder()
     *                 .resourceTypes(List.of("resourceTypes"))
     *                 .build())
     *         .includeGlobalResourceTypes(false)
     *         .recordingStrategy(RecordingStrategyProperty.builder()
     *                 .useOnly("useOnly")
     *                 .build())
     *         .resourceTypes(List.of("resourceTypes"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordinggroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordinggroup.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CfnConfigurationRecorder.RecordingGroupProperty")
    @software.amazon.jsii.Jsii.Proxy(RecordingGroupProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RecordingGroupProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether AWS Config records configuration changes for all supported resource types, excluding the global IAM resource types.
         * <p>
         * If you set this field to <code>true</code> , when AWS Config adds support for a new resource type, AWS Config starts recording resources of that type automatically.
         * <p>
         * If you set this field to <code>true</code> , you cannot enumerate specific resource types to record in the <code>resourceTypes</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> , or to exclude in the <code>resourceTypes</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html">ExclusionByResourceTypes</a> .
         * <p>
         * <blockquote>
         * <p>
         * <em>Region availability</em>
         * <p>
         * Check <a href="https://docs.aws.amazon.com/config/latest/developerguide/what-is-resource-config-coverage.html">Resource Coverage by Region Availability</a> to see if a resource type is supported in the AWS Region where you set up AWS Config .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordinggroup.html#cfn-config-configurationrecorder-recordinggroup-allsupported">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordinggroup.html#cfn-config-configurationrecorder-recordinggroup-allsupported</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllSupported() {
            return null;
        }

        /**
         * An object that specifies how AWS Config excludes resource types from being recorded by the configuration recorder.
         * <p>
         * To use this option, you must set the <code>useOnly</code> field of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordingstrategy.html">AWS::Config::ConfigurationRecorder RecordingStrategy</a> to <code>EXCLUSION_BY_RESOURCE_TYPES</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordinggroup.html#cfn-config-configurationrecorder-recordinggroup-exclusionbyresourcetypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordinggroup.html#cfn-config-configurationrecorder-recordinggroup-exclusionbyresourcetypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExclusionByResourceTypes() {
            return null;
        }

        /**
         * This option is a bundle which only applies to the global IAM resource types: IAM users, groups, roles, and customer managed policies.
         * <p>
         * These global IAM resource types can only be recorded by AWS Config in Regions where AWS Config was available before February 2022. You cannot be record the global IAM resouce types in Regions supported by AWS Config after February 2022. This list where you cannot record the global IAM resource types includes the following Regions:
         * <p>
         * <ul>
         * <li>Asia Pacific (Hyderabad)</li>
         * <li>Asia Pacific (Melbourne)</li>
         * <li>Canada West (Calgary)</li>
         * <li>Europe (Spain)</li>
         * <li>Europe (Zurich)</li>
         * <li>Israel (Tel Aviv)</li>
         * <li>Middle East (UAE)</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * <em>Aurora global clusters are recorded in all enabled Regions</em>
         * <p>
         * The <code>AWS::RDS::GlobalCluster</code> resource type will be recorded in all supported AWS Config Regions where the configuration recorder is enabled, even if <code>IncludeGlobalResourceTypes</code> is set to <code>false</code> . The <code>IncludeGlobalResourceTypes</code> option is a bundle which only applies to IAM users, groups, roles, and customer managed policies.
         * <p>
         * If you do not want to record <code>AWS::RDS::GlobalCluster</code> in all enabled Regions, use one of the following recording strategies:
         * <p>
         * <ul>
         * <li><em>Record all current and future resource types with exclusions</em> ( <code>EXCLUSION_BY_RESOURCE_TYPES</code> ), or</li>
         * <li><em>Record specific resource types</em> ( <code>INCLUSION_BY_RESOURCE_TYPES</code> ).</li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/select-resources.html#select-resources-all">Selecting Which Resources are Recorded</a> in the <em>AWS Config developer guide</em> . &gt; <em>IncludeGlobalResourceTypes and the exclusion recording strategy</em>
         * <p>
         * The <code>IncludeGlobalResourceTypes</code> field has no impact on the <code>EXCLUSION_BY_RESOURCE_TYPES</code> recording strategy. This means that the global IAM resource types ( IAM users, groups, roles, and customer managed policies) will not be automatically added as exclusions for <code>ExclusionByResourceTypes</code> when <code>IncludeGlobalResourceTypes</code> is set to <code>false</code> .
         * <p>
         * The <code>IncludeGlobalResourceTypes</code> field should only be used to modify the <code>AllSupported</code> field, as the default for the <code>AllSupported</code> field is to record configuration changes for all supported resource types excluding the global IAM resource types. To include the global IAM resource types when <code>AllSupported</code> is set to <code>true</code> , make sure to set <code>IncludeGlobalResourceTypes</code> to <code>true</code> .
         * <p>
         * To exclude the global IAM resource types for the <code>EXCLUSION_BY_RESOURCE_TYPES</code> recording strategy, you need to manually add them to the <code>ResourceTypes</code> field of <code>ExclusionByResourceTypes</code> . &gt; <em>Required and optional fields</em>
         * <p>
         * Before you set this field to <code>true</code> , set the <code>AllSupported</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> to <code>true</code> . Optionally, you can set the <code>useOnly</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingStrategy.html">RecordingStrategy</a> to <code>ALL_SUPPORTED_RESOURCE_TYPES</code> . &gt; <em>Overriding fields</em>
         * <p>
         * If you set this field to <code>false</code> but list global IAM resource types in the <code>ResourceTypes</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> , AWS Config will still record configuration changes for those specified resource types <em>regardless</em> of if you set the <code>IncludeGlobalResourceTypes</code> field to false.
         * <p>
         * If you do not want to record configuration changes to the global IAM resource types (IAM users, groups, roles, and customer managed policies), make sure to not list them in the <code>ResourceTypes</code> field in addition to setting the <code>IncludeGlobalResourceTypes</code> field to false.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordinggroup.html#cfn-config-configurationrecorder-recordinggroup-includeglobalresourcetypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordinggroup.html#cfn-config-configurationrecorder-recordinggroup-includeglobalresourcetypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeGlobalResourceTypes() {
            return null;
        }

        /**
         * An object that specifies the recording strategy for the configuration recorder.
         * <p>
         * <ul>
         * <li>If you set the <code>useOnly</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingStrategy.html">RecordingStrategy</a> to <code>ALL_SUPPORTED_RESOURCE_TYPES</code> , AWS Config records configuration changes for all supported resource types, excluding the global IAM resource types. You also must set the <code>AllSupported</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> to <code>true</code> . When AWS Config adds support for a new resource type, AWS Config automatically starts recording resources of that type.</li>
         * <li>If you set the <code>useOnly</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingStrategy.html">RecordingStrategy</a> to <code>INCLUSION_BY_RESOURCE_TYPES</code> , AWS Config records configuration changes for only the resource types you specify in the <code>ResourceTypes</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> .</li>
         * <li>If you set the <code>useOnly</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingStrategy.html">RecordingStrategy</a> to <code>EXCLUSION_BY_RESOURCE_TYPES</code> , AWS Config records configuration changes for all supported resource types except the resource types that you specify to exclude from being recorded in the <code>ResourceTypes</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html">ExclusionByResourceTypes</a> .</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * <em>Required and optional fields</em>
         * <p>
         * The <code>recordingStrategy</code> field is optional when you set the <code>AllSupported</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> to <code>true</code> .
         * <p>
         * The <code>recordingStrategy</code> field is optional when you list resource types in the <code>ResourceTypes</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> .
         * <p>
         * The <code>recordingStrategy</code> field is required if you list resource types to exclude from recording in the <code>ResourceTypes</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html">ExclusionByResourceTypes</a> . &gt; <em>Overriding fields</em>
         * <p>
         * If you choose <code>EXCLUSION_BY_RESOURCE_TYPES</code> for the recording strategy, the <code>ExclusionByResourceTypes</code> field will override other properties in the request.
         * <p>
         * For example, even if you set <code>IncludeGlobalResourceTypes</code> to false, global IAM resource types will still be automatically recorded in this option unless those resource types are specifically listed as exclusions in the <code>ResourceTypes</code> field of <code>ExclusionByResourceTypes</code> . &gt; <em>Global resources types and the resource exclusion recording strategy</em>
         * <p>
         * By default, if you choose the <code>EXCLUSION_BY_RESOURCE_TYPES</code> recording strategy, when AWS Config adds support for a new resource type in the Region where you set up the configuration recorder, including global resource types, AWS Config starts recording resources of that type automatically.
         * <p>
         * Unless specifically listed as exclusions, <code>AWS::RDS::GlobalCluster</code> will be recorded automatically in all supported AWS Config Regions were the configuration recorder is enabled.
         * <p>
         * IAM users, groups, roles, and customer managed policies will be recorded in the Region where you set up the configuration recorder if that is a Region where AWS Config was available before February 2022. You cannot be record the global IAM resouce types in Regions supported by AWS Config after February 2022. This list where you cannot record the global IAM resource types includes the following Regions:
         * <p>
         * <ul>
         * <li>Asia Pacific (Hyderabad)</li>
         * <li>Asia Pacific (Melbourne)</li>
         * <li>Canada West (Calgary)</li>
         * <li>Europe (Spain)</li>
         * <li>Europe (Zurich)</li>
         * <li>Israel (Tel Aviv)</li>
         * <li>Middle East (UAE)</li>
         * </ul>
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordinggroup.html#cfn-config-configurationrecorder-recordinggroup-recordingstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordinggroup.html#cfn-config-configurationrecorder-recordinggroup-recordingstrategy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRecordingStrategy() {
            return null;
        }

        /**
         * A comma-separated list that specifies which resource types AWS Config records.
         * <p>
         * For a list of valid <code>ResourceTypes</code> values, see the <em>Resource Type Value</em> column in <a href="https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources">Supported AWS resource Types</a> in the <em>AWS Config developer guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * <em>Required and optional fields</em>
         * <p>
         * Optionally, you can set the <code>useOnly</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingStrategy.html">RecordingStrategy</a> to <code>INCLUSION_BY_RESOURCE_TYPES</code> .
         * <p>
         * To record all configuration changes, set the <code>AllSupported</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> to <code>true</code> , and either omit this field or don't specify any resource types in this field. If you set the <code>AllSupported</code> field to <code>false</code> and specify values for <code>ResourceTypes</code> , when AWS Config adds support for a new type of resource, it will not record resources of that type unless you manually add that type to your recording group. &gt; <em>Region availability</em>
         * <p>
         * Before specifying a resource type for AWS Config to track, check <a href="https://docs.aws.amazon.com/config/latest/developerguide/what-is-resource-config-coverage.html">Resource Coverage by Region Availability</a> to see if the resource type is supported in the AWS Region where you set up AWS Config . If a resource type is supported by AWS Config in at least one Region, you can enable the recording of that resource type in all Regions supported by AWS Config , even if the specified resource type is not supported in the AWS Region where you set up AWS Config .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordinggroup.html#cfn-config-configurationrecorder-recordinggroup-resourcetypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordinggroup.html#cfn-config-configurationrecorder-recordinggroup-resourcetypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResourceTypes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RecordingGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RecordingGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RecordingGroupProperty> {
            java.lang.Object allSupported;
            java.lang.Object exclusionByResourceTypes;
            java.lang.Object includeGlobalResourceTypes;
            java.lang.Object recordingStrategy;
            java.util.List<java.lang.String> resourceTypes;

            /**
             * Sets the value of {@link RecordingGroupProperty#getAllSupported}
             * @param allSupported Specifies whether AWS Config records configuration changes for all supported resource types, excluding the global IAM resource types.
             *                     If you set this field to <code>true</code> , when AWS Config adds support for a new resource type, AWS Config starts recording resources of that type automatically.
             *                     <p>
             *                     If you set this field to <code>true</code> , you cannot enumerate specific resource types to record in the <code>resourceTypes</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> , or to exclude in the <code>resourceTypes</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html">ExclusionByResourceTypes</a> .
             *                     <p>
             *                     <blockquote>
             *                     <p>
             *                     <em>Region availability</em>
             *                     <p>
             *                     Check <a href="https://docs.aws.amazon.com/config/latest/developerguide/what-is-resource-config-coverage.html">Resource Coverage by Region Availability</a> to see if a resource type is supported in the AWS Region where you set up AWS Config .
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allSupported(java.lang.Boolean allSupported) {
                this.allSupported = allSupported;
                return this;
            }

            /**
             * Sets the value of {@link RecordingGroupProperty#getAllSupported}
             * @param allSupported Specifies whether AWS Config records configuration changes for all supported resource types, excluding the global IAM resource types.
             *                     If you set this field to <code>true</code> , when AWS Config adds support for a new resource type, AWS Config starts recording resources of that type automatically.
             *                     <p>
             *                     If you set this field to <code>true</code> , you cannot enumerate specific resource types to record in the <code>resourceTypes</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> , or to exclude in the <code>resourceTypes</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html">ExclusionByResourceTypes</a> .
             *                     <p>
             *                     <blockquote>
             *                     <p>
             *                     <em>Region availability</em>
             *                     <p>
             *                     Check <a href="https://docs.aws.amazon.com/config/latest/developerguide/what-is-resource-config-coverage.html">Resource Coverage by Region Availability</a> to see if a resource type is supported in the AWS Region where you set up AWS Config .
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allSupported(software.amazon.awscdk.IResolvable allSupported) {
                this.allSupported = allSupported;
                return this;
            }

            /**
             * Sets the value of {@link RecordingGroupProperty#getExclusionByResourceTypes}
             * @param exclusionByResourceTypes An object that specifies how AWS Config excludes resource types from being recorded by the configuration recorder.
             *                                 To use this option, you must set the <code>useOnly</code> field of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordingstrategy.html">AWS::Config::ConfigurationRecorder RecordingStrategy</a> to <code>EXCLUSION_BY_RESOURCE_TYPES</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exclusionByResourceTypes(software.amazon.awscdk.IResolvable exclusionByResourceTypes) {
                this.exclusionByResourceTypes = exclusionByResourceTypes;
                return this;
            }

            /**
             * Sets the value of {@link RecordingGroupProperty#getExclusionByResourceTypes}
             * @param exclusionByResourceTypes An object that specifies how AWS Config excludes resource types from being recorded by the configuration recorder.
             *                                 To use this option, you must set the <code>useOnly</code> field of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordingstrategy.html">AWS::Config::ConfigurationRecorder RecordingStrategy</a> to <code>EXCLUSION_BY_RESOURCE_TYPES</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exclusionByResourceTypes(software.amazon.awscdk.services.config.CfnConfigurationRecorder.ExclusionByResourceTypesProperty exclusionByResourceTypes) {
                this.exclusionByResourceTypes = exclusionByResourceTypes;
                return this;
            }

            /**
             * Sets the value of {@link RecordingGroupProperty#getIncludeGlobalResourceTypes}
             * @param includeGlobalResourceTypes This option is a bundle which only applies to the global IAM resource types: IAM users, groups, roles, and customer managed policies.
             *                                   These global IAM resource types can only be recorded by AWS Config in Regions where AWS Config was available before February 2022. You cannot be record the global IAM resouce types in Regions supported by AWS Config after February 2022. This list where you cannot record the global IAM resource types includes the following Regions:
             *                                   <p>
             *                                   <ul>
             *                                   <li>Asia Pacific (Hyderabad)</li>
             *                                   <li>Asia Pacific (Melbourne)</li>
             *                                   <li>Canada West (Calgary)</li>
             *                                   <li>Europe (Spain)</li>
             *                                   <li>Europe (Zurich)</li>
             *                                   <li>Israel (Tel Aviv)</li>
             *                                   <li>Middle East (UAE)</li>
             *                                   </ul>
             *                                   <p>
             *                                   <blockquote>
             *                                   <p>
             *                                   <em>Aurora global clusters are recorded in all enabled Regions</em>
             *                                   <p>
             *                                   The <code>AWS::RDS::GlobalCluster</code> resource type will be recorded in all supported AWS Config Regions where the configuration recorder is enabled, even if <code>IncludeGlobalResourceTypes</code> is set to <code>false</code> . The <code>IncludeGlobalResourceTypes</code> option is a bundle which only applies to IAM users, groups, roles, and customer managed policies.
             *                                   <p>
             *                                   If you do not want to record <code>AWS::RDS::GlobalCluster</code> in all enabled Regions, use one of the following recording strategies:
             *                                   <p>
             *                                   <ul>
             *                                   <li><em>Record all current and future resource types with exclusions</em> ( <code>EXCLUSION_BY_RESOURCE_TYPES</code> ), or</li>
             *                                   <li><em>Record specific resource types</em> ( <code>INCLUSION_BY_RESOURCE_TYPES</code> ).</li>
             *                                   </ul>
             *                                   <p>
             *                                   For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/select-resources.html#select-resources-all">Selecting Which Resources are Recorded</a> in the <em>AWS Config developer guide</em> . &gt; <em>IncludeGlobalResourceTypes and the exclusion recording strategy</em>
             *                                   <p>
             *                                   The <code>IncludeGlobalResourceTypes</code> field has no impact on the <code>EXCLUSION_BY_RESOURCE_TYPES</code> recording strategy. This means that the global IAM resource types ( IAM users, groups, roles, and customer managed policies) will not be automatically added as exclusions for <code>ExclusionByResourceTypes</code> when <code>IncludeGlobalResourceTypes</code> is set to <code>false</code> .
             *                                   <p>
             *                                   The <code>IncludeGlobalResourceTypes</code> field should only be used to modify the <code>AllSupported</code> field, as the default for the <code>AllSupported</code> field is to record configuration changes for all supported resource types excluding the global IAM resource types. To include the global IAM resource types when <code>AllSupported</code> is set to <code>true</code> , make sure to set <code>IncludeGlobalResourceTypes</code> to <code>true</code> .
             *                                   <p>
             *                                   To exclude the global IAM resource types for the <code>EXCLUSION_BY_RESOURCE_TYPES</code> recording strategy, you need to manually add them to the <code>ResourceTypes</code> field of <code>ExclusionByResourceTypes</code> . &gt; <em>Required and optional fields</em>
             *                                   <p>
             *                                   Before you set this field to <code>true</code> , set the <code>AllSupported</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> to <code>true</code> . Optionally, you can set the <code>useOnly</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingStrategy.html">RecordingStrategy</a> to <code>ALL_SUPPORTED_RESOURCE_TYPES</code> . &gt; <em>Overriding fields</em>
             *                                   <p>
             *                                   If you set this field to <code>false</code> but list global IAM resource types in the <code>ResourceTypes</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> , AWS Config will still record configuration changes for those specified resource types <em>regardless</em> of if you set the <code>IncludeGlobalResourceTypes</code> field to false.
             *                                   <p>
             *                                   If you do not want to record configuration changes to the global IAM resource types (IAM users, groups, roles, and customer managed policies), make sure to not list them in the <code>ResourceTypes</code> field in addition to setting the <code>IncludeGlobalResourceTypes</code> field to false.
             *                                   <p>
             *                                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeGlobalResourceTypes(java.lang.Boolean includeGlobalResourceTypes) {
                this.includeGlobalResourceTypes = includeGlobalResourceTypes;
                return this;
            }

            /**
             * Sets the value of {@link RecordingGroupProperty#getIncludeGlobalResourceTypes}
             * @param includeGlobalResourceTypes This option is a bundle which only applies to the global IAM resource types: IAM users, groups, roles, and customer managed policies.
             *                                   These global IAM resource types can only be recorded by AWS Config in Regions where AWS Config was available before February 2022. You cannot be record the global IAM resouce types in Regions supported by AWS Config after February 2022. This list where you cannot record the global IAM resource types includes the following Regions:
             *                                   <p>
             *                                   <ul>
             *                                   <li>Asia Pacific (Hyderabad)</li>
             *                                   <li>Asia Pacific (Melbourne)</li>
             *                                   <li>Canada West (Calgary)</li>
             *                                   <li>Europe (Spain)</li>
             *                                   <li>Europe (Zurich)</li>
             *                                   <li>Israel (Tel Aviv)</li>
             *                                   <li>Middle East (UAE)</li>
             *                                   </ul>
             *                                   <p>
             *                                   <blockquote>
             *                                   <p>
             *                                   <em>Aurora global clusters are recorded in all enabled Regions</em>
             *                                   <p>
             *                                   The <code>AWS::RDS::GlobalCluster</code> resource type will be recorded in all supported AWS Config Regions where the configuration recorder is enabled, even if <code>IncludeGlobalResourceTypes</code> is set to <code>false</code> . The <code>IncludeGlobalResourceTypes</code> option is a bundle which only applies to IAM users, groups, roles, and customer managed policies.
             *                                   <p>
             *                                   If you do not want to record <code>AWS::RDS::GlobalCluster</code> in all enabled Regions, use one of the following recording strategies:
             *                                   <p>
             *                                   <ul>
             *                                   <li><em>Record all current and future resource types with exclusions</em> ( <code>EXCLUSION_BY_RESOURCE_TYPES</code> ), or</li>
             *                                   <li><em>Record specific resource types</em> ( <code>INCLUSION_BY_RESOURCE_TYPES</code> ).</li>
             *                                   </ul>
             *                                   <p>
             *                                   For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/select-resources.html#select-resources-all">Selecting Which Resources are Recorded</a> in the <em>AWS Config developer guide</em> . &gt; <em>IncludeGlobalResourceTypes and the exclusion recording strategy</em>
             *                                   <p>
             *                                   The <code>IncludeGlobalResourceTypes</code> field has no impact on the <code>EXCLUSION_BY_RESOURCE_TYPES</code> recording strategy. This means that the global IAM resource types ( IAM users, groups, roles, and customer managed policies) will not be automatically added as exclusions for <code>ExclusionByResourceTypes</code> when <code>IncludeGlobalResourceTypes</code> is set to <code>false</code> .
             *                                   <p>
             *                                   The <code>IncludeGlobalResourceTypes</code> field should only be used to modify the <code>AllSupported</code> field, as the default for the <code>AllSupported</code> field is to record configuration changes for all supported resource types excluding the global IAM resource types. To include the global IAM resource types when <code>AllSupported</code> is set to <code>true</code> , make sure to set <code>IncludeGlobalResourceTypes</code> to <code>true</code> .
             *                                   <p>
             *                                   To exclude the global IAM resource types for the <code>EXCLUSION_BY_RESOURCE_TYPES</code> recording strategy, you need to manually add them to the <code>ResourceTypes</code> field of <code>ExclusionByResourceTypes</code> . &gt; <em>Required and optional fields</em>
             *                                   <p>
             *                                   Before you set this field to <code>true</code> , set the <code>AllSupported</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> to <code>true</code> . Optionally, you can set the <code>useOnly</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingStrategy.html">RecordingStrategy</a> to <code>ALL_SUPPORTED_RESOURCE_TYPES</code> . &gt; <em>Overriding fields</em>
             *                                   <p>
             *                                   If you set this field to <code>false</code> but list global IAM resource types in the <code>ResourceTypes</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> , AWS Config will still record configuration changes for those specified resource types <em>regardless</em> of if you set the <code>IncludeGlobalResourceTypes</code> field to false.
             *                                   <p>
             *                                   If you do not want to record configuration changes to the global IAM resource types (IAM users, groups, roles, and customer managed policies), make sure to not list them in the <code>ResourceTypes</code> field in addition to setting the <code>IncludeGlobalResourceTypes</code> field to false.
             *                                   <p>
             *                                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeGlobalResourceTypes(software.amazon.awscdk.IResolvable includeGlobalResourceTypes) {
                this.includeGlobalResourceTypes = includeGlobalResourceTypes;
                return this;
            }

            /**
             * Sets the value of {@link RecordingGroupProperty#getRecordingStrategy}
             * @param recordingStrategy An object that specifies the recording strategy for the configuration recorder.
             *                          <ul>
             *                          <li>If you set the <code>useOnly</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingStrategy.html">RecordingStrategy</a> to <code>ALL_SUPPORTED_RESOURCE_TYPES</code> , AWS Config records configuration changes for all supported resource types, excluding the global IAM resource types. You also must set the <code>AllSupported</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> to <code>true</code> . When AWS Config adds support for a new resource type, AWS Config automatically starts recording resources of that type.</li>
             *                          <li>If you set the <code>useOnly</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingStrategy.html">RecordingStrategy</a> to <code>INCLUSION_BY_RESOURCE_TYPES</code> , AWS Config records configuration changes for only the resource types you specify in the <code>ResourceTypes</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> .</li>
             *                          <li>If you set the <code>useOnly</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingStrategy.html">RecordingStrategy</a> to <code>EXCLUSION_BY_RESOURCE_TYPES</code> , AWS Config records configuration changes for all supported resource types except the resource types that you specify to exclude from being recorded in the <code>ResourceTypes</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html">ExclusionByResourceTypes</a> .</li>
             *                          </ul>
             *                          <p>
             *                          <blockquote>
             *                          <p>
             *                          <em>Required and optional fields</em>
             *                          <p>
             *                          The <code>recordingStrategy</code> field is optional when you set the <code>AllSupported</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> to <code>true</code> .
             *                          <p>
             *                          The <code>recordingStrategy</code> field is optional when you list resource types in the <code>ResourceTypes</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> .
             *                          <p>
             *                          The <code>recordingStrategy</code> field is required if you list resource types to exclude from recording in the <code>ResourceTypes</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html">ExclusionByResourceTypes</a> . &gt; <em>Overriding fields</em>
             *                          <p>
             *                          If you choose <code>EXCLUSION_BY_RESOURCE_TYPES</code> for the recording strategy, the <code>ExclusionByResourceTypes</code> field will override other properties in the request.
             *                          <p>
             *                          For example, even if you set <code>IncludeGlobalResourceTypes</code> to false, global IAM resource types will still be automatically recorded in this option unless those resource types are specifically listed as exclusions in the <code>ResourceTypes</code> field of <code>ExclusionByResourceTypes</code> . &gt; <em>Global resources types and the resource exclusion recording strategy</em>
             *                          <p>
             *                          By default, if you choose the <code>EXCLUSION_BY_RESOURCE_TYPES</code> recording strategy, when AWS Config adds support for a new resource type in the Region where you set up the configuration recorder, including global resource types, AWS Config starts recording resources of that type automatically.
             *                          <p>
             *                          Unless specifically listed as exclusions, <code>AWS::RDS::GlobalCluster</code> will be recorded automatically in all supported AWS Config Regions were the configuration recorder is enabled.
             *                          <p>
             *                          IAM users, groups, roles, and customer managed policies will be recorded in the Region where you set up the configuration recorder if that is a Region where AWS Config was available before February 2022. You cannot be record the global IAM resouce types in Regions supported by AWS Config after February 2022. This list where you cannot record the global IAM resource types includes the following Regions:
             *                          <p>
             *                          <ul>
             *                          <li>Asia Pacific (Hyderabad)</li>
             *                          <li>Asia Pacific (Melbourne)</li>
             *                          <li>Canada West (Calgary)</li>
             *                          <li>Europe (Spain)</li>
             *                          <li>Europe (Zurich)</li>
             *                          <li>Israel (Tel Aviv)</li>
             *                          <li>Middle East (UAE)</li>
             *                          </ul>
             *                          <p>
             *                          </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordingStrategy(software.amazon.awscdk.IResolvable recordingStrategy) {
                this.recordingStrategy = recordingStrategy;
                return this;
            }

            /**
             * Sets the value of {@link RecordingGroupProperty#getRecordingStrategy}
             * @param recordingStrategy An object that specifies the recording strategy for the configuration recorder.
             *                          <ul>
             *                          <li>If you set the <code>useOnly</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingStrategy.html">RecordingStrategy</a> to <code>ALL_SUPPORTED_RESOURCE_TYPES</code> , AWS Config records configuration changes for all supported resource types, excluding the global IAM resource types. You also must set the <code>AllSupported</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> to <code>true</code> . When AWS Config adds support for a new resource type, AWS Config automatically starts recording resources of that type.</li>
             *                          <li>If you set the <code>useOnly</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingStrategy.html">RecordingStrategy</a> to <code>INCLUSION_BY_RESOURCE_TYPES</code> , AWS Config records configuration changes for only the resource types you specify in the <code>ResourceTypes</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> .</li>
             *                          <li>If you set the <code>useOnly</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingStrategy.html">RecordingStrategy</a> to <code>EXCLUSION_BY_RESOURCE_TYPES</code> , AWS Config records configuration changes for all supported resource types except the resource types that you specify to exclude from being recorded in the <code>ResourceTypes</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html">ExclusionByResourceTypes</a> .</li>
             *                          </ul>
             *                          <p>
             *                          <blockquote>
             *                          <p>
             *                          <em>Required and optional fields</em>
             *                          <p>
             *                          The <code>recordingStrategy</code> field is optional when you set the <code>AllSupported</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> to <code>true</code> .
             *                          <p>
             *                          The <code>recordingStrategy</code> field is optional when you list resource types in the <code>ResourceTypes</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> .
             *                          <p>
             *                          The <code>recordingStrategy</code> field is required if you list resource types to exclude from recording in the <code>ResourceTypes</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html">ExclusionByResourceTypes</a> . &gt; <em>Overriding fields</em>
             *                          <p>
             *                          If you choose <code>EXCLUSION_BY_RESOURCE_TYPES</code> for the recording strategy, the <code>ExclusionByResourceTypes</code> field will override other properties in the request.
             *                          <p>
             *                          For example, even if you set <code>IncludeGlobalResourceTypes</code> to false, global IAM resource types will still be automatically recorded in this option unless those resource types are specifically listed as exclusions in the <code>ResourceTypes</code> field of <code>ExclusionByResourceTypes</code> . &gt; <em>Global resources types and the resource exclusion recording strategy</em>
             *                          <p>
             *                          By default, if you choose the <code>EXCLUSION_BY_RESOURCE_TYPES</code> recording strategy, when AWS Config adds support for a new resource type in the Region where you set up the configuration recorder, including global resource types, AWS Config starts recording resources of that type automatically.
             *                          <p>
             *                          Unless specifically listed as exclusions, <code>AWS::RDS::GlobalCluster</code> will be recorded automatically in all supported AWS Config Regions were the configuration recorder is enabled.
             *                          <p>
             *                          IAM users, groups, roles, and customer managed policies will be recorded in the Region where you set up the configuration recorder if that is a Region where AWS Config was available before February 2022. You cannot be record the global IAM resouce types in Regions supported by AWS Config after February 2022. This list where you cannot record the global IAM resource types includes the following Regions:
             *                          <p>
             *                          <ul>
             *                          <li>Asia Pacific (Hyderabad)</li>
             *                          <li>Asia Pacific (Melbourne)</li>
             *                          <li>Canada West (Calgary)</li>
             *                          <li>Europe (Spain)</li>
             *                          <li>Europe (Zurich)</li>
             *                          <li>Israel (Tel Aviv)</li>
             *                          <li>Middle East (UAE)</li>
             *                          </ul>
             *                          <p>
             *                          </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordingStrategy(software.amazon.awscdk.services.config.CfnConfigurationRecorder.RecordingStrategyProperty recordingStrategy) {
                this.recordingStrategy = recordingStrategy;
                return this;
            }

            /**
             * Sets the value of {@link RecordingGroupProperty#getResourceTypes}
             * @param resourceTypes A comma-separated list that specifies which resource types AWS Config records.
             *                      For a list of valid <code>ResourceTypes</code> values, see the <em>Resource Type Value</em> column in <a href="https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources">Supported AWS resource Types</a> in the <em>AWS Config developer guide</em> .
             *                      <p>
             *                      <blockquote>
             *                      <p>
             *                      <em>Required and optional fields</em>
             *                      <p>
             *                      Optionally, you can set the <code>useOnly</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingStrategy.html">RecordingStrategy</a> to <code>INCLUSION_BY_RESOURCE_TYPES</code> .
             *                      <p>
             *                      To record all configuration changes, set the <code>AllSupported</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> to <code>true</code> , and either omit this field or don't specify any resource types in this field. If you set the <code>AllSupported</code> field to <code>false</code> and specify values for <code>ResourceTypes</code> , when AWS Config adds support for a new type of resource, it will not record resources of that type unless you manually add that type to your recording group. &gt; <em>Region availability</em>
             *                      <p>
             *                      Before specifying a resource type for AWS Config to track, check <a href="https://docs.aws.amazon.com/config/latest/developerguide/what-is-resource-config-coverage.html">Resource Coverage by Region Availability</a> to see if the resource type is supported in the AWS Region where you set up AWS Config . If a resource type is supported by AWS Config in at least one Region, you can enable the recording of that resource type in all Regions supported by AWS Config , even if the specified resource type is not supported in the AWS Region where you set up AWS Config .
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceTypes(java.util.List<java.lang.String> resourceTypes) {
                this.resourceTypes = resourceTypes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecordingGroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RecordingGroupProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RecordingGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RecordingGroupProperty {
            private final java.lang.Object allSupported;
            private final java.lang.Object exclusionByResourceTypes;
            private final java.lang.Object includeGlobalResourceTypes;
            private final java.lang.Object recordingStrategy;
            private final java.util.List<java.lang.String> resourceTypes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allSupported = software.amazon.jsii.Kernel.get(this, "allSupported", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.exclusionByResourceTypes = software.amazon.jsii.Kernel.get(this, "exclusionByResourceTypes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeGlobalResourceTypes = software.amazon.jsii.Kernel.get(this, "includeGlobalResourceTypes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.recordingStrategy = software.amazon.jsii.Kernel.get(this, "recordingStrategy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceTypes = software.amazon.jsii.Kernel.get(this, "resourceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allSupported = builder.allSupported;
                this.exclusionByResourceTypes = builder.exclusionByResourceTypes;
                this.includeGlobalResourceTypes = builder.includeGlobalResourceTypes;
                this.recordingStrategy = builder.recordingStrategy;
                this.resourceTypes = builder.resourceTypes;
            }

            @Override
            public final java.lang.Object getAllSupported() {
                return this.allSupported;
            }

            @Override
            public final java.lang.Object getExclusionByResourceTypes() {
                return this.exclusionByResourceTypes;
            }

            @Override
            public final java.lang.Object getIncludeGlobalResourceTypes() {
                return this.includeGlobalResourceTypes;
            }

            @Override
            public final java.lang.Object getRecordingStrategy() {
                return this.recordingStrategy;
            }

            @Override
            public final java.util.List<java.lang.String> getResourceTypes() {
                return this.resourceTypes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllSupported() != null) {
                    data.set("allSupported", om.valueToTree(this.getAllSupported()));
                }
                if (this.getExclusionByResourceTypes() != null) {
                    data.set("exclusionByResourceTypes", om.valueToTree(this.getExclusionByResourceTypes()));
                }
                if (this.getIncludeGlobalResourceTypes() != null) {
                    data.set("includeGlobalResourceTypes", om.valueToTree(this.getIncludeGlobalResourceTypes()));
                }
                if (this.getRecordingStrategy() != null) {
                    data.set("recordingStrategy", om.valueToTree(this.getRecordingStrategy()));
                }
                if (this.getResourceTypes() != null) {
                    data.set("resourceTypes", om.valueToTree(this.getResourceTypes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_config.CfnConfigurationRecorder.RecordingGroupProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RecordingGroupProperty.Jsii$Proxy that = (RecordingGroupProperty.Jsii$Proxy) o;

                if (this.allSupported != null ? !this.allSupported.equals(that.allSupported) : that.allSupported != null) return false;
                if (this.exclusionByResourceTypes != null ? !this.exclusionByResourceTypes.equals(that.exclusionByResourceTypes) : that.exclusionByResourceTypes != null) return false;
                if (this.includeGlobalResourceTypes != null ? !this.includeGlobalResourceTypes.equals(that.includeGlobalResourceTypes) : that.includeGlobalResourceTypes != null) return false;
                if (this.recordingStrategy != null ? !this.recordingStrategy.equals(that.recordingStrategy) : that.recordingStrategy != null) return false;
                return this.resourceTypes != null ? this.resourceTypes.equals(that.resourceTypes) : that.resourceTypes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allSupported != null ? this.allSupported.hashCode() : 0;
                result = 31 * result + (this.exclusionByResourceTypes != null ? this.exclusionByResourceTypes.hashCode() : 0);
                result = 31 * result + (this.includeGlobalResourceTypes != null ? this.includeGlobalResourceTypes.hashCode() : 0);
                result = 31 * result + (this.recordingStrategy != null ? this.recordingStrategy.hashCode() : 0);
                result = 31 * result + (this.resourceTypes != null ? this.resourceTypes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object for you to specify your overrides for the recording mode.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.config.*;
     * RecordingModeOverrideProperty recordingModeOverrideProperty = RecordingModeOverrideProperty.builder()
     *         .recordingFrequency("recordingFrequency")
     *         .resourceTypes(List.of("resourceTypes"))
     *         // the properties below are optional
     *         .description("description")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordingmodeoverride.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordingmodeoverride.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CfnConfigurationRecorder.RecordingModeOverrideProperty")
    @software.amazon.jsii.Jsii.Proxy(RecordingModeOverrideProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RecordingModeOverrideProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The recording frequency that will be applied to all the resource types specified in the override.
         * <p>
         * <ul>
         * <li>Continuous recording allows you to record configuration changes continuously whenever a change occurs.</li>
         * <li>Daily recording allows you to receive a configuration item (CI) representing the most recent state of your resources over the last 24-hour period, only if it’s different from the previous CI recorded.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * AWS Firewall Manager depends on continuous recording to monitor your resources. If you are using Firewall Manager, it is recommended that you set the recording frequency to Continuous.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordingmodeoverride.html#cfn-config-configurationrecorder-recordingmodeoverride-recordingfrequency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordingmodeoverride.html#cfn-config-configurationrecorder-recordingmodeoverride-recordingfrequency</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRecordingFrequency();

        /**
         * A comma-separated list that specifies which resource types AWS Config includes in the override.
         * <p>
         * <blockquote>
         * <p>
         * Daily recording is not supported for the following resource types:
         * <p>
         * <ul>
         * <li><code>AWS::Config::ResourceCompliance</code></li>
         * <li><code>AWS::Config::ConformancePackCompliance</code></li>
         * <li><code>AWS::Config::ConfigurationRecorder</code></li>
         * </ul>
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordingmodeoverride.html#cfn-config-configurationrecorder-recordingmodeoverride-resourcetypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordingmodeoverride.html#cfn-config-configurationrecorder-recordingmodeoverride-resourcetypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getResourceTypes();

        /**
         * A description that you provide for the override.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordingmodeoverride.html#cfn-config-configurationrecorder-recordingmodeoverride-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordingmodeoverride.html#cfn-config-configurationrecorder-recordingmodeoverride-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RecordingModeOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RecordingModeOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RecordingModeOverrideProperty> {
            java.lang.String recordingFrequency;
            java.util.List<java.lang.String> resourceTypes;
            java.lang.String description;

            /**
             * Sets the value of {@link RecordingModeOverrideProperty#getRecordingFrequency}
             * @param recordingFrequency The recording frequency that will be applied to all the resource types specified in the override. This parameter is required.
             *                           <ul>
             *                           <li>Continuous recording allows you to record configuration changes continuously whenever a change occurs.</li>
             *                           <li>Daily recording allows you to receive a configuration item (CI) representing the most recent state of your resources over the last 24-hour period, only if it’s different from the previous CI recorded.</li>
             *                           </ul>
             *                           <p>
             *                           <blockquote>
             *                           <p>
             *                           AWS Firewall Manager depends on continuous recording to monitor your resources. If you are using Firewall Manager, it is recommended that you set the recording frequency to Continuous.
             *                           <p>
             *                           </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordingFrequency(java.lang.String recordingFrequency) {
                this.recordingFrequency = recordingFrequency;
                return this;
            }

            /**
             * Sets the value of {@link RecordingModeOverrideProperty#getResourceTypes}
             * @param resourceTypes A comma-separated list that specifies which resource types AWS Config includes in the override. This parameter is required.
             *                      <blockquote>
             *                      <p>
             *                      Daily recording is not supported for the following resource types:
             *                      <p>
             *                      <ul>
             *                      <li><code>AWS::Config::ResourceCompliance</code></li>
             *                      <li><code>AWS::Config::ConformancePackCompliance</code></li>
             *                      <li><code>AWS::Config::ConfigurationRecorder</code></li>
             *                      </ul>
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceTypes(java.util.List<java.lang.String> resourceTypes) {
                this.resourceTypes = resourceTypes;
                return this;
            }

            /**
             * Sets the value of {@link RecordingModeOverrideProperty#getDescription}
             * @param description A description that you provide for the override.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecordingModeOverrideProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RecordingModeOverrideProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RecordingModeOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RecordingModeOverrideProperty {
            private final java.lang.String recordingFrequency;
            private final java.util.List<java.lang.String> resourceTypes;
            private final java.lang.String description;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.recordingFrequency = software.amazon.jsii.Kernel.get(this, "recordingFrequency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceTypes = software.amazon.jsii.Kernel.get(this, "resourceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.recordingFrequency = java.util.Objects.requireNonNull(builder.recordingFrequency, "recordingFrequency is required");
                this.resourceTypes = java.util.Objects.requireNonNull(builder.resourceTypes, "resourceTypes is required");
                this.description = builder.description;
            }

            @Override
            public final java.lang.String getRecordingFrequency() {
                return this.recordingFrequency;
            }

            @Override
            public final java.util.List<java.lang.String> getResourceTypes() {
                return this.resourceTypes;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("recordingFrequency", om.valueToTree(this.getRecordingFrequency()));
                data.set("resourceTypes", om.valueToTree(this.getResourceTypes()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_config.CfnConfigurationRecorder.RecordingModeOverrideProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RecordingModeOverrideProperty.Jsii$Proxy that = (RecordingModeOverrideProperty.Jsii$Proxy) o;

                if (!recordingFrequency.equals(that.recordingFrequency)) return false;
                if (!resourceTypes.equals(that.resourceTypes)) return false;
                return this.description != null ? this.description.equals(that.description) : that.description == null;
            }

            @Override
            public final int hashCode() {
                int result = this.recordingFrequency.hashCode();
                result = 31 * result + (this.resourceTypes.hashCode());
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the default recording frequency that AWS Config uses to record configuration changes.
     * <p>
     * AWS Config supports <em>Continuous recording</em> and <em>Daily recording</em> .
     * <p>
     * <ul>
     * <li>Continuous recording allows you to record configuration changes continuously whenever a change occurs.</li>
     * <li>Daily recording allows you to receive a configuration item (CI) representing the most recent state of your resources over the last 24-hour period, only if it’s different from the previous CI recorded.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * AWS Firewall Manager depends on continuous recording to monitor your resources. If you are using Firewall Manager, it is recommended that you set the recording frequency to Continuous.
     * <p>
     * </blockquote>
     * <p>
     * You can also override the recording frequency for specific resource types.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.config.*;
     * RecordingModeProperty recordingModeProperty = RecordingModeProperty.builder()
     *         .recordingFrequency("recordingFrequency")
     *         // the properties below are optional
     *         .recordingModeOverrides(List.of(RecordingModeOverrideProperty.builder()
     *                 .recordingFrequency("recordingFrequency")
     *                 .resourceTypes(List.of("resourceTypes"))
     *                 // the properties below are optional
     *                 .description("description")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordingmode.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordingmode.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CfnConfigurationRecorder.RecordingModeProperty")
    @software.amazon.jsii.Jsii.Proxy(RecordingModeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RecordingModeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The default recording frequency that AWS Config uses to record configuration changes.
         * <p>
         * <blockquote>
         * <p>
         * Daily recording is not supported for the following resource types:
         * <p>
         * <ul>
         * <li><code>AWS::Config::ResourceCompliance</code></li>
         * <li><code>AWS::Config::ConformancePackCompliance</code></li>
         * <li><code>AWS::Config::ConfigurationRecorder</code></li>
         * </ul>
         * <p>
         * For the <em>allSupported</em> ( <code>ALL_SUPPORTED_RESOURCE_TYPES</code> ) recording strategy, these resource types will be set to Continuous recording.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordingmode.html#cfn-config-configurationrecorder-recordingmode-recordingfrequency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordingmode.html#cfn-config-configurationrecorder-recordingmode-recordingfrequency</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRecordingFrequency();

        /**
         * An array of <code>recordingModeOverride</code> objects for you to specify your overrides for the recording mode.
         * <p>
         * The <code>recordingModeOverride</code> object in the <code>recordingModeOverrides</code> array consists of three fields: a <code>description</code> , the new <code>recordingFrequency</code> , and an array of <code>resourceTypes</code> to override.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordingmode.html#cfn-config-configurationrecorder-recordingmode-recordingmodeoverrides">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordingmode.html#cfn-config-configurationrecorder-recordingmode-recordingmodeoverrides</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRecordingModeOverrides() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RecordingModeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RecordingModeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RecordingModeProperty> {
            java.lang.String recordingFrequency;
            java.lang.Object recordingModeOverrides;

            /**
             * Sets the value of {@link RecordingModeProperty#getRecordingFrequency}
             * @param recordingFrequency The default recording frequency that AWS Config uses to record configuration changes. This parameter is required.
             *                           <blockquote>
             *                           <p>
             *                           Daily recording is not supported for the following resource types:
             *                           <p>
             *                           <ul>
             *                           <li><code>AWS::Config::ResourceCompliance</code></li>
             *                           <li><code>AWS::Config::ConformancePackCompliance</code></li>
             *                           <li><code>AWS::Config::ConfigurationRecorder</code></li>
             *                           </ul>
             *                           <p>
             *                           For the <em>allSupported</em> ( <code>ALL_SUPPORTED_RESOURCE_TYPES</code> ) recording strategy, these resource types will be set to Continuous recording.
             *                           <p>
             *                           </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordingFrequency(java.lang.String recordingFrequency) {
                this.recordingFrequency = recordingFrequency;
                return this;
            }

            /**
             * Sets the value of {@link RecordingModeProperty#getRecordingModeOverrides}
             * @param recordingModeOverrides An array of <code>recordingModeOverride</code> objects for you to specify your overrides for the recording mode.
             *                               The <code>recordingModeOverride</code> object in the <code>recordingModeOverrides</code> array consists of three fields: a <code>description</code> , the new <code>recordingFrequency</code> , and an array of <code>resourceTypes</code> to override.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordingModeOverrides(software.amazon.awscdk.IResolvable recordingModeOverrides) {
                this.recordingModeOverrides = recordingModeOverrides;
                return this;
            }

            /**
             * Sets the value of {@link RecordingModeProperty#getRecordingModeOverrides}
             * @param recordingModeOverrides An array of <code>recordingModeOverride</code> objects for you to specify your overrides for the recording mode.
             *                               The <code>recordingModeOverride</code> object in the <code>recordingModeOverrides</code> array consists of three fields: a <code>description</code> , the new <code>recordingFrequency</code> , and an array of <code>resourceTypes</code> to override.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordingModeOverrides(java.util.List<? extends java.lang.Object> recordingModeOverrides) {
                this.recordingModeOverrides = recordingModeOverrides;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecordingModeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RecordingModeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RecordingModeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RecordingModeProperty {
            private final java.lang.String recordingFrequency;
            private final java.lang.Object recordingModeOverrides;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.recordingFrequency = software.amazon.jsii.Kernel.get(this, "recordingFrequency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.recordingModeOverrides = software.amazon.jsii.Kernel.get(this, "recordingModeOverrides", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.recordingFrequency = java.util.Objects.requireNonNull(builder.recordingFrequency, "recordingFrequency is required");
                this.recordingModeOverrides = builder.recordingModeOverrides;
            }

            @Override
            public final java.lang.String getRecordingFrequency() {
                return this.recordingFrequency;
            }

            @Override
            public final java.lang.Object getRecordingModeOverrides() {
                return this.recordingModeOverrides;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("recordingFrequency", om.valueToTree(this.getRecordingFrequency()));
                if (this.getRecordingModeOverrides() != null) {
                    data.set("recordingModeOverrides", om.valueToTree(this.getRecordingModeOverrides()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_config.CfnConfigurationRecorder.RecordingModeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RecordingModeProperty.Jsii$Proxy that = (RecordingModeProperty.Jsii$Proxy) o;

                if (!recordingFrequency.equals(that.recordingFrequency)) return false;
                return this.recordingModeOverrides != null ? this.recordingModeOverrides.equals(that.recordingModeOverrides) : that.recordingModeOverrides == null;
            }

            @Override
            public final int hashCode() {
                int result = this.recordingFrequency.hashCode();
                result = 31 * result + (this.recordingModeOverrides != null ? this.recordingModeOverrides.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the recording strategy of the configuration recorder.
     * <p>
     * Valid values include: <code>ALL_SUPPORTED_RESOURCE_TYPES</code> , <code>INCLUSION_BY_RESOURCE_TYPES</code> , and <code>EXCLUSION_BY_RESOURCE_TYPES</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.config.*;
     * RecordingStrategyProperty recordingStrategyProperty = RecordingStrategyProperty.builder()
     *         .useOnly("useOnly")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordingstrategy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordingstrategy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CfnConfigurationRecorder.RecordingStrategyProperty")
    @software.amazon.jsii.Jsii.Proxy(RecordingStrategyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RecordingStrategyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The recording strategy for the configuration recorder.
         * <p>
         * <ul>
         * <li>If you set this option to <code>ALL_SUPPORTED_RESOURCE_TYPES</code> , AWS Config records configuration changes for all supported resource types, excluding the global IAM resource types. You also must set the <code>AllSupported</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> to <code>true</code> . When AWS Config adds support for a new resource type, AWS Config automatically starts recording resources of that type. For a list of supported resource types, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources">Supported Resource Types</a> in the <em>AWS Config developer guide</em> .</li>
         * <li>If you set this option to <code>INCLUSION_BY_RESOURCE_TYPES</code> , AWS Config records configuration changes for only the resource types that you specify in the <code>ResourceTypes</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> .</li>
         * <li>If you set this option to <code>EXCLUSION_BY_RESOURCE_TYPES</code> , AWS Config records configuration changes for all supported resource types, except the resource types that you specify to exclude from being recorded in the <code>ResourceTypes</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html">ExclusionByResourceTypes</a> .</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * <em>Required and optional fields</em>
         * <p>
         * The <code>recordingStrategy</code> field is optional when you set the <code>AllSupported</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> to <code>true</code> .
         * <p>
         * The <code>recordingStrategy</code> field is optional when you list resource types in the <code>ResourceTypes</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> .
         * <p>
         * The <code>recordingStrategy</code> field is required if you list resource types to exclude from recording in the <code>ResourceTypes</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html">ExclusionByResourceTypes</a> . &gt; <em>Overriding fields</em>
         * <p>
         * If you choose <code>EXCLUSION_BY_RESOURCE_TYPES</code> for the recording strategy, the <code>ExclusionByResourceTypes</code> field will override other properties in the request.
         * <p>
         * For example, even if you set <code>IncludeGlobalResourceTypes</code> to false, global IAM resource types will still be automatically recorded in this option unless those resource types are specifically listed as exclusions in the <code>ResourceTypes</code> field of <code>ExclusionByResourceTypes</code> . &gt; <em>Global resource types and the exclusion recording strategy</em>
         * <p>
         * By default, if you choose the <code>EXCLUSION_BY_RESOURCE_TYPES</code> recording strategy, when AWS Config adds support for a new resource type in the Region where you set up the configuration recorder, including global resource types, AWS Config starts recording resources of that type automatically.
         * <p>
         * Unless specifically listed as exclusions, <code>AWS::RDS::GlobalCluster</code> will be recorded automatically in all supported AWS Config Regions were the configuration recorder is enabled.
         * <p>
         * IAM users, groups, roles, and customer managed policies will be recorded in the Region where you set up the configuration recorder if that is a Region where AWS Config was available before February 2022. You cannot be record the global IAM resouce types in Regions supported by AWS Config after February 2022. This list where you cannot record the global IAM resource types includes the following Regions:
         * <p>
         * <ul>
         * <li>Asia Pacific (Hyderabad)</li>
         * <li>Asia Pacific (Melbourne)</li>
         * <li>Canada West (Calgary)</li>
         * <li>Europe (Spain)</li>
         * <li>Europe (Zurich)</li>
         * <li>Israel (Tel Aviv)</li>
         * <li>Middle East (UAE)</li>
         * </ul>
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordingstrategy.html#cfn-config-configurationrecorder-recordingstrategy-useonly">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordingstrategy.html#cfn-config-configurationrecorder-recordingstrategy-useonly</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUseOnly();

        /**
         * @return a {@link Builder} of {@link RecordingStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RecordingStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RecordingStrategyProperty> {
            java.lang.String useOnly;

            /**
             * Sets the value of {@link RecordingStrategyProperty#getUseOnly}
             * @param useOnly The recording strategy for the configuration recorder. This parameter is required.
             *                <ul>
             *                <li>If you set this option to <code>ALL_SUPPORTED_RESOURCE_TYPES</code> , AWS Config records configuration changes for all supported resource types, excluding the global IAM resource types. You also must set the <code>AllSupported</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> to <code>true</code> . When AWS Config adds support for a new resource type, AWS Config automatically starts recording resources of that type. For a list of supported resource types, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources">Supported Resource Types</a> in the <em>AWS Config developer guide</em> .</li>
             *                <li>If you set this option to <code>INCLUSION_BY_RESOURCE_TYPES</code> , AWS Config records configuration changes for only the resource types that you specify in the <code>ResourceTypes</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> .</li>
             *                <li>If you set this option to <code>EXCLUSION_BY_RESOURCE_TYPES</code> , AWS Config records configuration changes for all supported resource types, except the resource types that you specify to exclude from being recorded in the <code>ResourceTypes</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html">ExclusionByResourceTypes</a> .</li>
             *                </ul>
             *                <p>
             *                <blockquote>
             *                <p>
             *                <em>Required and optional fields</em>
             *                <p>
             *                The <code>recordingStrategy</code> field is optional when you set the <code>AllSupported</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> to <code>true</code> .
             *                <p>
             *                The <code>recordingStrategy</code> field is optional when you list resource types in the <code>ResourceTypes</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> .
             *                <p>
             *                The <code>recordingStrategy</code> field is required if you list resource types to exclude from recording in the <code>ResourceTypes</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html">ExclusionByResourceTypes</a> . &gt; <em>Overriding fields</em>
             *                <p>
             *                If you choose <code>EXCLUSION_BY_RESOURCE_TYPES</code> for the recording strategy, the <code>ExclusionByResourceTypes</code> field will override other properties in the request.
             *                <p>
             *                For example, even if you set <code>IncludeGlobalResourceTypes</code> to false, global IAM resource types will still be automatically recorded in this option unless those resource types are specifically listed as exclusions in the <code>ResourceTypes</code> field of <code>ExclusionByResourceTypes</code> . &gt; <em>Global resource types and the exclusion recording strategy</em>
             *                <p>
             *                By default, if you choose the <code>EXCLUSION_BY_RESOURCE_TYPES</code> recording strategy, when AWS Config adds support for a new resource type in the Region where you set up the configuration recorder, including global resource types, AWS Config starts recording resources of that type automatically.
             *                <p>
             *                Unless specifically listed as exclusions, <code>AWS::RDS::GlobalCluster</code> will be recorded automatically in all supported AWS Config Regions were the configuration recorder is enabled.
             *                <p>
             *                IAM users, groups, roles, and customer managed policies will be recorded in the Region where you set up the configuration recorder if that is a Region where AWS Config was available before February 2022. You cannot be record the global IAM resouce types in Regions supported by AWS Config after February 2022. This list where you cannot record the global IAM resource types includes the following Regions:
             *                <p>
             *                <ul>
             *                <li>Asia Pacific (Hyderabad)</li>
             *                <li>Asia Pacific (Melbourne)</li>
             *                <li>Canada West (Calgary)</li>
             *                <li>Europe (Spain)</li>
             *                <li>Europe (Zurich)</li>
             *                <li>Israel (Tel Aviv)</li>
             *                <li>Middle East (UAE)</li>
             *                </ul>
             *                <p>
             *                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useOnly(java.lang.String useOnly) {
                this.useOnly = useOnly;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecordingStrategyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RecordingStrategyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RecordingStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RecordingStrategyProperty {
            private final java.lang.String useOnly;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.useOnly = software.amazon.jsii.Kernel.get(this, "useOnly", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.useOnly = java.util.Objects.requireNonNull(builder.useOnly, "useOnly is required");
            }

            @Override
            public final java.lang.String getUseOnly() {
                return this.useOnly;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("useOnly", om.valueToTree(this.getUseOnly()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_config.CfnConfigurationRecorder.RecordingStrategyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RecordingStrategyProperty.Jsii$Proxy that = (RecordingStrategyProperty.Jsii$Proxy) o;

                return this.useOnly.equals(that.useOnly);
            }

            @Override
            public final int hashCode() {
                int result = this.useOnly.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.config.CfnConfigurationRecorder}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.config.CfnConfigurationRecorder> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.config.CfnConfigurationRecorderProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.config.CfnConfigurationRecorderProps.Builder();
        }

        /**
         * Amazon Resource Name (ARN) of the IAM role assumed by AWS Config and used by the configuration recorder.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iamrole-permissions.html">Permissions for the IAM Role Assigned</a> to AWS Config in the AWS Config Developer Guide.
         * <p>
         * <blockquote>
         * <p>
         * <em>Pre-existing AWS Config role</em>
         * <p>
         * If you have used an AWS service that uses AWS Config , such as AWS Security Hub or AWS Control Tower , and an AWS Config role has already been created, make sure that the IAM role that you use when setting up AWS Config keeps the same minimum permissions as the already created AWS Config role. You must do this so that the other AWS service continues to run as expected.
         * <p>
         * For example, if AWS Control Tower has an IAM role that allows AWS Config to read Amazon Simple Storage Service ( Amazon S3 ) objects, make sure that the same permissions are granted within the IAM role you use when setting up AWS Config . Otherwise, it may interfere with how AWS Control Tower operates. For more information about IAM roles for AWS Config , see <a href="https://docs.aws.amazon.com/config/latest/developerguide/security-iam.html"><em>Identity and Access Management for AWS Config</em></a> in the <em>AWS Config Developer Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html#cfn-config-configurationrecorder-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html#cfn-config-configurationrecorder-rolearn</a>
         * @param roleArn Amazon Resource Name (ARN) of the IAM role assumed by AWS Config and used by the configuration recorder. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * The name of the configuration recorder. AWS Config automatically assigns the name of "default" when creating the configuration recorder.
         * <p>
         * You cannot change the name of the configuration recorder after it has been created. To change the configuration recorder name, you must delete it and create a new configuration recorder with a new name.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html#cfn-config-configurationrecorder-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html#cfn-config-configurationrecorder-name</a>
         * @param name The name of the configuration recorder. AWS Config automatically assigns the name of "default" when creating the configuration recorder. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Specifies which resource types AWS Config records for configuration changes.
         * <p>
         * <blockquote>
         * <p>
         * <em>High Number of AWS Config Evaluations</em>
         * <p>
         * You may notice increased activity in your account during your initial month recording with AWS Config when compared to subsequent months. During the initial bootstrapping process, AWS Config runs evaluations on all the resources in your account that you have selected for AWS Config to record.
         * <p>
         * If you are running ephemeral workloads, you may see increased activity from AWS Config as it records configuration changes associated with creating and deleting these temporary resources. An <em>ephemeral workload</em> is a temporary use of computing resources that are loaded and run when needed. Examples include Amazon Elastic Compute Cloud ( Amazon EC2 ) Spot Instances, Amazon EMR jobs, and AWS Auto Scaling . If you want to avoid the increased activity from running ephemeral workloads, you can run these types of workloads in a separate account with AWS Config turned off to avoid increased configuration recording and rule evaluations.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html#cfn-config-configurationrecorder-recordinggroup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html#cfn-config-configurationrecorder-recordinggroup</a>
         * @param recordingGroup Specifies which resource types AWS Config records for configuration changes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordingGroup(final software.amazon.awscdk.IResolvable recordingGroup) {
            this.props.recordingGroup(recordingGroup);
            return this;
        }
        /**
         * Specifies which resource types AWS Config records for configuration changes.
         * <p>
         * <blockquote>
         * <p>
         * <em>High Number of AWS Config Evaluations</em>
         * <p>
         * You may notice increased activity in your account during your initial month recording with AWS Config when compared to subsequent months. During the initial bootstrapping process, AWS Config runs evaluations on all the resources in your account that you have selected for AWS Config to record.
         * <p>
         * If you are running ephemeral workloads, you may see increased activity from AWS Config as it records configuration changes associated with creating and deleting these temporary resources. An <em>ephemeral workload</em> is a temporary use of computing resources that are loaded and run when needed. Examples include Amazon Elastic Compute Cloud ( Amazon EC2 ) Spot Instances, Amazon EMR jobs, and AWS Auto Scaling . If you want to avoid the increased activity from running ephemeral workloads, you can run these types of workloads in a separate account with AWS Config turned off to avoid increased configuration recording and rule evaluations.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html#cfn-config-configurationrecorder-recordinggroup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html#cfn-config-configurationrecorder-recordinggroup</a>
         * @param recordingGroup Specifies which resource types AWS Config records for configuration changes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordingGroup(final software.amazon.awscdk.services.config.CfnConfigurationRecorder.RecordingGroupProperty recordingGroup) {
            this.props.recordingGroup(recordingGroup);
            return this;
        }

        /**
         * Specifies the default recording frequency that AWS Config uses to record configuration changes.
         * <p>
         * AWS Config supports <em>Continuous recording</em> and <em>Daily recording</em> .
         * <p>
         * <ul>
         * <li>Continuous recording allows you to record configuration changes continuously whenever a change occurs.</li>
         * <li>Daily recording allows you to receive a configuration item (CI) representing the most recent state of your resources over the last 24-hour period, only if it’s different from the previous CI recorded.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * AWS Firewall Manager depends on continuous recording to monitor your resources. If you are using Firewall Manager, it is recommended that you set the recording frequency to Continuous.
         * <p>
         * </blockquote>
         * <p>
         * You can also override the recording frequency for specific resource types.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html#cfn-config-configurationrecorder-recordingmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html#cfn-config-configurationrecorder-recordingmode</a>
         * @param recordingMode Specifies the default recording frequency that AWS Config uses to record configuration changes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordingMode(final software.amazon.awscdk.IResolvable recordingMode) {
            this.props.recordingMode(recordingMode);
            return this;
        }
        /**
         * Specifies the default recording frequency that AWS Config uses to record configuration changes.
         * <p>
         * AWS Config supports <em>Continuous recording</em> and <em>Daily recording</em> .
         * <p>
         * <ul>
         * <li>Continuous recording allows you to record configuration changes continuously whenever a change occurs.</li>
         * <li>Daily recording allows you to receive a configuration item (CI) representing the most recent state of your resources over the last 24-hour period, only if it’s different from the previous CI recorded.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * AWS Firewall Manager depends on continuous recording to monitor your resources. If you are using Firewall Manager, it is recommended that you set the recording frequency to Continuous.
         * <p>
         * </blockquote>
         * <p>
         * You can also override the recording frequency for specific resource types.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html#cfn-config-configurationrecorder-recordingmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html#cfn-config-configurationrecorder-recordingmode</a>
         * @param recordingMode Specifies the default recording frequency that AWS Config uses to record configuration changes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordingMode(final software.amazon.awscdk.services.config.CfnConfigurationRecorder.RecordingModeProperty recordingMode) {
            this.props.recordingMode(recordingMode);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.config.CfnConfigurationRecorder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.config.CfnConfigurationRecorder build() {
            return new software.amazon.awscdk.services.config.CfnConfigurationRecorder(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
