package software.amazon.awscdk.services.connectcampaigns;

/**
 * Properties for defining a <code>CfnCampaign</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.connectcampaigns.*;
 * CfnCampaignProps cfnCampaignProps = CfnCampaignProps.builder()
 *         .connectInstanceArn("connectInstanceArn")
 *         .dialerConfig(DialerConfigProperty.builder()
 *                 .agentlessDialerConfig(AgentlessDialerConfigProperty.builder()
 *                         .dialingCapacity(123)
 *                         .build())
 *                 .predictiveDialerConfig(PredictiveDialerConfigProperty.builder()
 *                         .bandwidthAllocation(123)
 *                         // the properties below are optional
 *                         .dialingCapacity(123)
 *                         .build())
 *                 .progressiveDialerConfig(ProgressiveDialerConfigProperty.builder()
 *                         .bandwidthAllocation(123)
 *                         // the properties below are optional
 *                         .dialingCapacity(123)
 *                         .build())
 *                 .build())
 *         .name("name")
 *         .outboundCallConfig(OutboundCallConfigProperty.builder()
 *                 .connectContactFlowArn("connectContactFlowArn")
 *                 // the properties below are optional
 *                 .answerMachineDetectionConfig(AnswerMachineDetectionConfigProperty.builder()
 *                         .enableAnswerMachineDetection(false)
 *                         // the properties below are optional
 *                         .awaitAnswerMachinePrompt(false)
 *                         .build())
 *                 .connectQueueArn("connectQueueArn")
 *                 .connectSourcePhoneNumber("connectSourcePhoneNumber")
 *                 .build())
 *         // the properties below are optional
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaigns-campaign.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaigns-campaign.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:05.887Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaigns.CfnCampaignProps")
@software.amazon.jsii.Jsii.Proxy(CfnCampaignProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCampaignProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the Amazon Connect instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaigns-campaign.html#cfn-connectcampaigns-campaign-connectinstancearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaigns-campaign.html#cfn-connectcampaigns-campaign-connectinstancearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConnectInstanceArn();

    /**
     * Contains information about the dialer configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaigns-campaign.html#cfn-connectcampaigns-campaign-dialerconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaigns-campaign.html#cfn-connectcampaigns-campaign-dialerconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDialerConfig();

    /**
     * The name of the campaign.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaigns-campaign.html#cfn-connectcampaigns-campaign-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaigns-campaign.html#cfn-connectcampaigns-campaign-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Contains information about the outbound call configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaigns-campaign.html#cfn-connectcampaigns-campaign-outboundcallconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaigns-campaign.html#cfn-connectcampaigns-campaign-outboundcallconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getOutboundCallConfig();

    /**
     * The tags used to organize, track, or control access for this resource.
     * <p>
     * For example, { "tags": {"key1":"value1", "key2":"value2"} }.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaigns-campaign.html#cfn-connectcampaigns-campaign-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaigns-campaign.html#cfn-connectcampaigns-campaign-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCampaignProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCampaignProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCampaignProps> {
        java.lang.String connectInstanceArn;
        java.lang.Object dialerConfig;
        java.lang.String name;
        java.lang.Object outboundCallConfig;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnCampaignProps#getConnectInstanceArn}
         * @param connectInstanceArn The Amazon Resource Name (ARN) of the Amazon Connect instance. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectInstanceArn(java.lang.String connectInstanceArn) {
            this.connectInstanceArn = connectInstanceArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getDialerConfig}
         * @param dialerConfig Contains information about the dialer configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dialerConfig(software.amazon.awscdk.IResolvable dialerConfig) {
            this.dialerConfig = dialerConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getDialerConfig}
         * @param dialerConfig Contains information about the dialer configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dialerConfig(software.amazon.awscdk.services.connectcampaigns.CfnCampaign.DialerConfigProperty dialerConfig) {
            this.dialerConfig = dialerConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getName}
         * @param name The name of the campaign. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getOutboundCallConfig}
         * @param outboundCallConfig Contains information about the outbound call configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outboundCallConfig(software.amazon.awscdk.IResolvable outboundCallConfig) {
            this.outboundCallConfig = outboundCallConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getOutboundCallConfig}
         * @param outboundCallConfig Contains information about the outbound call configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outboundCallConfig(software.amazon.awscdk.services.connectcampaigns.CfnCampaign.OutboundCallConfigProperty outboundCallConfig) {
            this.outboundCallConfig = outboundCallConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getTags}
         * @param tags The tags used to organize, track, or control access for this resource.
         *             For example, { "tags": {"key1":"value1", "key2":"value2"} }.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCampaignProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCampaignProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCampaignProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCampaignProps {
        private final java.lang.String connectInstanceArn;
        private final java.lang.Object dialerConfig;
        private final java.lang.String name;
        private final java.lang.Object outboundCallConfig;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.connectInstanceArn = software.amazon.jsii.Kernel.get(this, "connectInstanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dialerConfig = software.amazon.jsii.Kernel.get(this, "dialerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outboundCallConfig = software.amazon.jsii.Kernel.get(this, "outboundCallConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.connectInstanceArn = java.util.Objects.requireNonNull(builder.connectInstanceArn, "connectInstanceArn is required");
            this.dialerConfig = java.util.Objects.requireNonNull(builder.dialerConfig, "dialerConfig is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.outboundCallConfig = java.util.Objects.requireNonNull(builder.outboundCallConfig, "outboundCallConfig is required");
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getConnectInstanceArn() {
            return this.connectInstanceArn;
        }

        @Override
        public final java.lang.Object getDialerConfig() {
            return this.dialerConfig;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getOutboundCallConfig() {
            return this.outboundCallConfig;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("connectInstanceArn", om.valueToTree(this.getConnectInstanceArn()));
            data.set("dialerConfig", om.valueToTree(this.getDialerConfig()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("outboundCallConfig", om.valueToTree(this.getOutboundCallConfig()));
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaigns.CfnCampaignProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCampaignProps.Jsii$Proxy that = (CfnCampaignProps.Jsii$Proxy) o;

            if (!connectInstanceArn.equals(that.connectInstanceArn)) return false;
            if (!dialerConfig.equals(that.dialerConfig)) return false;
            if (!name.equals(that.name)) return false;
            if (!outboundCallConfig.equals(that.outboundCallConfig)) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.connectInstanceArn.hashCode();
            result = 31 * result + (this.dialerConfig.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.outboundCallConfig.hashCode());
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
