package software.amazon.awscdk.services.docdb;

/**
 * Construction properties for a DatabaseSecret.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * DatabaseCluster cluster;
 * DatabaseSecret myUserSecret = DatabaseSecret.Builder.create(this, "MyUserSecret")
 *         .username("myuser")
 *         .masterSecret(cluster.getSecret())
 *         .build();
 * ISecret myUserSecretAttached = myUserSecret.attach(cluster); // Adds DB connections information in the secret
 * cluster.addRotationMultiUser("MyUser", RotationMultiUserOptions.builder() // Add rotation using the multi user scheme
 *         .secret(myUserSecretAttached).build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:06.405Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_docdb.DatabaseSecretProps")
@software.amazon.jsii.Jsii.Proxy(DatabaseSecretProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DatabaseSecretProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The username.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUsername();

    /**
     * The KMS key to use to encrypt the secret.
     * <p>
     * Default: default master key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * Characters to not include in the generated password.
     * <p>
     * Default: "\"@/"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExcludeCharacters() {
        return null;
    }

    /**
     * The master secret which will be used to rotate this secret.
     * <p>
     * Default: - no master secret information will be included
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.ISecret getMasterSecret() {
        return null;
    }

    /**
     * The physical name of the secret.
     * <p>
     * Default: Secretsmanager will generate a physical name for the secret
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSecretName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DatabaseSecretProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DatabaseSecretProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DatabaseSecretProps> {
        java.lang.String username;
        software.amazon.awscdk.services.kms.IKey encryptionKey;
        java.lang.String excludeCharacters;
        software.amazon.awscdk.services.secretsmanager.ISecret masterSecret;
        java.lang.String secretName;

        /**
         * Sets the value of {@link DatabaseSecretProps#getUsername}
         * @param username The username. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder username(java.lang.String username) {
            this.username = username;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseSecretProps#getEncryptionKey}
         * @param encryptionKey The KMS key to use to encrypt the secret.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseSecretProps#getExcludeCharacters}
         * @param excludeCharacters Characters to not include in the generated password.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeCharacters(java.lang.String excludeCharacters) {
            this.excludeCharacters = excludeCharacters;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseSecretProps#getMasterSecret}
         * @param masterSecret The master secret which will be used to rotate this secret.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterSecret(software.amazon.awscdk.services.secretsmanager.ISecret masterSecret) {
            this.masterSecret = masterSecret;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseSecretProps#getSecretName}
         * @param secretName The physical name of the secret.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secretName(java.lang.String secretName) {
            this.secretName = secretName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DatabaseSecretProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DatabaseSecretProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DatabaseSecretProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseSecretProps {
        private final java.lang.String username;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final java.lang.String excludeCharacters;
        private final software.amazon.awscdk.services.secretsmanager.ISecret masterSecret;
        private final java.lang.String secretName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.excludeCharacters = software.amazon.jsii.Kernel.get(this, "excludeCharacters", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.masterSecret = software.amazon.jsii.Kernel.get(this, "masterSecret", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
            this.secretName = software.amazon.jsii.Kernel.get(this, "secretName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.username = java.util.Objects.requireNonNull(builder.username, "username is required");
            this.encryptionKey = builder.encryptionKey;
            this.excludeCharacters = builder.excludeCharacters;
            this.masterSecret = builder.masterSecret;
            this.secretName = builder.secretName;
        }

        @Override
        public final java.lang.String getUsername() {
            return this.username;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final java.lang.String getExcludeCharacters() {
            return this.excludeCharacters;
        }

        @Override
        public final software.amazon.awscdk.services.secretsmanager.ISecret getMasterSecret() {
            return this.masterSecret;
        }

        @Override
        public final java.lang.String getSecretName() {
            return this.secretName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("username", om.valueToTree(this.getUsername()));
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getExcludeCharacters() != null) {
                data.set("excludeCharacters", om.valueToTree(this.getExcludeCharacters()));
            }
            if (this.getMasterSecret() != null) {
                data.set("masterSecret", om.valueToTree(this.getMasterSecret()));
            }
            if (this.getSecretName() != null) {
                data.set("secretName", om.valueToTree(this.getSecretName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_docdb.DatabaseSecretProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DatabaseSecretProps.Jsii$Proxy that = (DatabaseSecretProps.Jsii$Proxy) o;

            if (!username.equals(that.username)) return false;
            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            if (this.excludeCharacters != null ? !this.excludeCharacters.equals(that.excludeCharacters) : that.excludeCharacters != null) return false;
            if (this.masterSecret != null ? !this.masterSecret.equals(that.masterSecret) : that.masterSecret != null) return false;
            return this.secretName != null ? this.secretName.equals(that.secretName) : that.secretName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.username.hashCode();
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            result = 31 * result + (this.excludeCharacters != null ? this.excludeCharacters.hashCode() : 0);
            result = 31 * result + (this.masterSecret != null ? this.masterSecret.hashCode() : 0);
            result = 31 * result + (this.secretName != null ? this.secretName.hashCode() : 0);
            return result;
        }
    }
}
