package software.amazon.awscdk.services.ec2;

/**
 * Options for creating a SystemD configuration file.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * InstanceType instanceType;
 * Instance.Builder.create(this, "Instance")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(MachineImage.latestAmazonLinux2023())
 *         .init(CloudFormationInit.fromElements(InitService.systemdConfigFile("simpleserver", SystemdConfigFileOptions.builder()
 *                 .command("/usr/bin/python3 -m http.server 8080")
 *                 .cwd("/var/www/html")
 *                 .build()), InitService.enable("simpleserver", InitServiceOptions.builder()
 *                 .serviceManager(ServiceManager.SYSTEMD)
 *                 .build()), InitFile.fromString("/var/www/html/index.html", "Hello! It's working!")))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:07.230Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.SystemdConfigFileOptions")
@software.amazon.jsii.Jsii.Proxy(SystemdConfigFileOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SystemdConfigFileOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The command to run to start this service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCommand();

    /**
     * Start the service after the networking part of the OS comes up.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAfterNetwork() {
        return null;
    }

    /**
     * The working directory for the command.
     * <p>
     * Default: Root directory or home directory of specified user
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCwd() {
        return null;
    }

    /**
     * A description of this service.
     * <p>
     * Default: - No description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Loads environment variables from files when the process is running.
     * <p>
     * Must use absolute paths.
     * <p>
     * Default: - No environment files
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEnvironmentFiles() {
        return null;
    }

    /**
     * Environment variables to load when the process is running.
     * <p>
     * Default: - No environment variables set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnvironmentVariables() {
        return null;
    }

    /**
     * The group to execute the process under.
     * <p>
     * Default: root
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGroup() {
        return null;
    }

    /**
     * Keep the process running all the time.
     * <p>
     * Restarts the process when it exits for any reason other
     * than the machine shutting down.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getKeepRunning() {
        return null;
    }

    /**
     * The user to execute the process under.
     * <p>
     * Default: root
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUser() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SystemdConfigFileOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SystemdConfigFileOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SystemdConfigFileOptions> {
        java.lang.String command;
        java.lang.Boolean afterNetwork;
        java.lang.String cwd;
        java.lang.String description;
        java.util.List<java.lang.String> environmentFiles;
        java.util.Map<java.lang.String, java.lang.String> environmentVariables;
        java.lang.String group;
        java.lang.Boolean keepRunning;
        java.lang.String user;

        /**
         * Sets the value of {@link SystemdConfigFileOptions#getCommand}
         * @param command The command to run to start this service. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder command(java.lang.String command) {
            this.command = command;
            return this;
        }

        /**
         * Sets the value of {@link SystemdConfigFileOptions#getAfterNetwork}
         * @param afterNetwork Start the service after the networking part of the OS comes up.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder afterNetwork(java.lang.Boolean afterNetwork) {
            this.afterNetwork = afterNetwork;
            return this;
        }

        /**
         * Sets the value of {@link SystemdConfigFileOptions#getCwd}
         * @param cwd The working directory for the command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cwd(java.lang.String cwd) {
            this.cwd = cwd;
            return this;
        }

        /**
         * Sets the value of {@link SystemdConfigFileOptions#getDescription}
         * @param description A description of this service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link SystemdConfigFileOptions#getEnvironmentFiles}
         * @param environmentFiles Loads environment variables from files when the process is running.
         *                         Must use absolute paths.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentFiles(java.util.List<java.lang.String> environmentFiles) {
            this.environmentFiles = environmentFiles;
            return this;
        }

        /**
         * Sets the value of {@link SystemdConfigFileOptions#getEnvironmentVariables}
         * @param environmentVariables Environment variables to load when the process is running.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentVariables(java.util.Map<java.lang.String, java.lang.String> environmentVariables) {
            this.environmentVariables = environmentVariables;
            return this;
        }

        /**
         * Sets the value of {@link SystemdConfigFileOptions#getGroup}
         * @param group The group to execute the process under.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder group(java.lang.String group) {
            this.group = group;
            return this;
        }

        /**
         * Sets the value of {@link SystemdConfigFileOptions#getKeepRunning}
         * @param keepRunning Keep the process running all the time.
         *                    Restarts the process when it exits for any reason other
         *                    than the machine shutting down.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keepRunning(java.lang.Boolean keepRunning) {
            this.keepRunning = keepRunning;
            return this;
        }

        /**
         * Sets the value of {@link SystemdConfigFileOptions#getUser}
         * @param user The user to execute the process under.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder user(java.lang.String user) {
            this.user = user;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SystemdConfigFileOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SystemdConfigFileOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SystemdConfigFileOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SystemdConfigFileOptions {
        private final java.lang.String command;
        private final java.lang.Boolean afterNetwork;
        private final java.lang.String cwd;
        private final java.lang.String description;
        private final java.util.List<java.lang.String> environmentFiles;
        private final java.util.Map<java.lang.String, java.lang.String> environmentVariables;
        private final java.lang.String group;
        private final java.lang.Boolean keepRunning;
        private final java.lang.String user;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.afterNetwork = software.amazon.jsii.Kernel.get(this, "afterNetwork", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.cwd = software.amazon.jsii.Kernel.get(this, "cwd", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environmentFiles = software.amazon.jsii.Kernel.get(this, "environmentFiles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.environmentVariables = software.amazon.jsii.Kernel.get(this, "environmentVariables", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.group = software.amazon.jsii.Kernel.get(this, "group", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.keepRunning = software.amazon.jsii.Kernel.get(this, "keepRunning", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.user = software.amazon.jsii.Kernel.get(this, "user", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.command = java.util.Objects.requireNonNull(builder.command, "command is required");
            this.afterNetwork = builder.afterNetwork;
            this.cwd = builder.cwd;
            this.description = builder.description;
            this.environmentFiles = builder.environmentFiles;
            this.environmentVariables = builder.environmentVariables;
            this.group = builder.group;
            this.keepRunning = builder.keepRunning;
            this.user = builder.user;
        }

        @Override
        public final java.lang.String getCommand() {
            return this.command;
        }

        @Override
        public final java.lang.Boolean getAfterNetwork() {
            return this.afterNetwork;
        }

        @Override
        public final java.lang.String getCwd() {
            return this.cwd;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<java.lang.String> getEnvironmentFiles() {
            return this.environmentFiles;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnvironmentVariables() {
            return this.environmentVariables;
        }

        @Override
        public final java.lang.String getGroup() {
            return this.group;
        }

        @Override
        public final java.lang.Boolean getKeepRunning() {
            return this.keepRunning;
        }

        @Override
        public final java.lang.String getUser() {
            return this.user;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("command", om.valueToTree(this.getCommand()));
            if (this.getAfterNetwork() != null) {
                data.set("afterNetwork", om.valueToTree(this.getAfterNetwork()));
            }
            if (this.getCwd() != null) {
                data.set("cwd", om.valueToTree(this.getCwd()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnvironmentFiles() != null) {
                data.set("environmentFiles", om.valueToTree(this.getEnvironmentFiles()));
            }
            if (this.getEnvironmentVariables() != null) {
                data.set("environmentVariables", om.valueToTree(this.getEnvironmentVariables()));
            }
            if (this.getGroup() != null) {
                data.set("group", om.valueToTree(this.getGroup()));
            }
            if (this.getKeepRunning() != null) {
                data.set("keepRunning", om.valueToTree(this.getKeepRunning()));
            }
            if (this.getUser() != null) {
                data.set("user", om.valueToTree(this.getUser()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.SystemdConfigFileOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SystemdConfigFileOptions.Jsii$Proxy that = (SystemdConfigFileOptions.Jsii$Proxy) o;

            if (!command.equals(that.command)) return false;
            if (this.afterNetwork != null ? !this.afterNetwork.equals(that.afterNetwork) : that.afterNetwork != null) return false;
            if (this.cwd != null ? !this.cwd.equals(that.cwd) : that.cwd != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.environmentFiles != null ? !this.environmentFiles.equals(that.environmentFiles) : that.environmentFiles != null) return false;
            if (this.environmentVariables != null ? !this.environmentVariables.equals(that.environmentVariables) : that.environmentVariables != null) return false;
            if (this.group != null ? !this.group.equals(that.group) : that.group != null) return false;
            if (this.keepRunning != null ? !this.keepRunning.equals(that.keepRunning) : that.keepRunning != null) return false;
            return this.user != null ? this.user.equals(that.user) : that.user == null;
        }

        @Override
        public final int hashCode() {
            int result = this.command.hashCode();
            result = 31 * result + (this.afterNetwork != null ? this.afterNetwork.hashCode() : 0);
            result = 31 * result + (this.cwd != null ? this.cwd.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.environmentFiles != null ? this.environmentFiles.hashCode() : 0);
            result = 31 * result + (this.environmentVariables != null ? this.environmentVariables.hashCode() : 0);
            result = 31 * result + (this.group != null ? this.group.hashCode() : 0);
            result = 31 * result + (this.keepRunning != null ? this.keepRunning.hashCode() : 0);
            result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
            return result;
        }
    }
}
