package software.amazon.awscdk.services.ecs;

/**
 * The common properties for all task definitions.
 * <p>
 * For more information, see
 * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html">Task Definition Parameters</a>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * import software.amazon.awscdk.services.iam.*;
 * ProxyConfiguration proxyConfiguration;
 * Role role;
 * CommonTaskDefinitionProps commonTaskDefinitionProps = CommonTaskDefinitionProps.builder()
 *         .executionRole(role)
 *         .family("family")
 *         .proxyConfiguration(proxyConfiguration)
 *         .taskRole(role)
 *         .volumes(List.of(Volume.builder()
 *                 .name("name")
 *                 // the properties below are optional
 *                 .configuredAtLaunch(false)
 *                 .dockerVolumeConfiguration(DockerVolumeConfiguration.builder()
 *                         .driver("driver")
 *                         .scope(Scope.TASK)
 *                         // the properties below are optional
 *                         .autoprovision(false)
 *                         .driverOpts(Map.of(
 *                                 "driverOptsKey", "driverOpts"))
 *                         .labels(Map.of(
 *                                 "labelsKey", "labels"))
 *                         .build())
 *                 .efsVolumeConfiguration(EfsVolumeConfiguration.builder()
 *                         .fileSystemId("fileSystemId")
 *                         // the properties below are optional
 *                         .authorizationConfig(AuthorizationConfig.builder()
 *                                 .accessPointId("accessPointId")
 *                                 .iam("iam")
 *                                 .build())
 *                         .rootDirectory("rootDirectory")
 *                         .transitEncryption("transitEncryption")
 *                         .transitEncryptionPort(123)
 *                         .build())
 *                 .host(Host.builder()
 *                         .sourcePath("sourcePath")
 *                         .build())
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:07.501Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CommonTaskDefinitionProps")
@software.amazon.jsii.Jsii.Proxy(CommonTaskDefinitionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CommonTaskDefinitionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the IAM task execution role that grants the ECS agent permission to call AWS APIs on your behalf.
     * <p>
     * The role will be used to retrieve container images from ECR and create CloudWatch log groups.
     * <p>
     * Default: - An execution role will be automatically created if you use ECR images in your task definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getExecutionRole() {
        return null;
    }

    /**
     * The name of a family that this task definition is registered to.
     * <p>
     * A family groups multiple versions of a task definition.
     * <p>
     * Default: - Automatically generated name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFamily() {
        return null;
    }

    /**
     * The configuration details for the App Mesh proxy.
     * <p>
     * Default: - No proxy configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.ProxyConfiguration getProxyConfiguration() {
        return null;
    }

    /**
     * The name of the IAM role that grants containers in the task permission to call AWS APIs on your behalf.
     * <p>
     * Default: - A task role is automatically created for you.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getTaskRole() {
        return null;
    }

    /**
     * The list of volume definitions for the task.
     * <p>
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide//task_definition_parameters.html#volumes">Task Definition Parameter Volumes</a>.
     * <p>
     * Default: - No volumes are passed to the Docker daemon on a container instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ecs.Volume> getVolumes() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CommonTaskDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CommonTaskDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CommonTaskDefinitionProps> {
        software.amazon.awscdk.services.iam.IRole executionRole;
        java.lang.String family;
        software.amazon.awscdk.services.ecs.ProxyConfiguration proxyConfiguration;
        software.amazon.awscdk.services.iam.IRole taskRole;
        java.util.List<software.amazon.awscdk.services.ecs.Volume> volumes;

        /**
         * Sets the value of {@link CommonTaskDefinitionProps#getExecutionRole}
         * @param executionRole The name of the IAM task execution role that grants the ECS agent permission to call AWS APIs on your behalf.
         *                      The role will be used to retrieve container images from ECR and create CloudWatch log groups.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRole(software.amazon.awscdk.services.iam.IRole executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        /**
         * Sets the value of {@link CommonTaskDefinitionProps#getFamily}
         * @param family The name of a family that this task definition is registered to.
         *               A family groups multiple versions of a task definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder family(java.lang.String family) {
            this.family = family;
            return this;
        }

        /**
         * Sets the value of {@link CommonTaskDefinitionProps#getProxyConfiguration}
         * @param proxyConfiguration The configuration details for the App Mesh proxy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxyConfiguration(software.amazon.awscdk.services.ecs.ProxyConfiguration proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CommonTaskDefinitionProps#getTaskRole}
         * @param taskRole The name of the IAM role that grants containers in the task permission to call AWS APIs on your behalf.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskRole(software.amazon.awscdk.services.iam.IRole taskRole) {
            this.taskRole = taskRole;
            return this;
        }

        /**
         * Sets the value of {@link CommonTaskDefinitionProps#getVolumes}
         * @param volumes The list of volume definitions for the task.
         *                For more information, see
         *                <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide//task_definition_parameters.html#volumes">Task Definition Parameter Volumes</a>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder volumes(java.util.List<? extends software.amazon.awscdk.services.ecs.Volume> volumes) {
            this.volumes = (java.util.List<software.amazon.awscdk.services.ecs.Volume>)volumes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CommonTaskDefinitionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CommonTaskDefinitionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CommonTaskDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CommonTaskDefinitionProps {
        private final software.amazon.awscdk.services.iam.IRole executionRole;
        private final java.lang.String family;
        private final software.amazon.awscdk.services.ecs.ProxyConfiguration proxyConfiguration;
        private final software.amazon.awscdk.services.iam.IRole taskRole;
        private final java.util.List<software.amazon.awscdk.services.ecs.Volume> volumes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.executionRole = software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.family = software.amazon.jsii.Kernel.get(this, "family", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.proxyConfiguration = software.amazon.jsii.Kernel.get(this, "proxyConfiguration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ProxyConfiguration.class));
            this.taskRole = software.amazon.jsii.Kernel.get(this, "taskRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.volumes = software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Volume.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.executionRole = builder.executionRole;
            this.family = builder.family;
            this.proxyConfiguration = builder.proxyConfiguration;
            this.taskRole = builder.taskRole;
            this.volumes = (java.util.List<software.amazon.awscdk.services.ecs.Volume>)builder.volumes;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getExecutionRole() {
            return this.executionRole;
        }

        @Override
        public final java.lang.String getFamily() {
            return this.family;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ProxyConfiguration getProxyConfiguration() {
            return this.proxyConfiguration;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getTaskRole() {
            return this.taskRole;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ecs.Volume> getVolumes() {
            return this.volumes;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getExecutionRole() != null) {
                data.set("executionRole", om.valueToTree(this.getExecutionRole()));
            }
            if (this.getFamily() != null) {
                data.set("family", om.valueToTree(this.getFamily()));
            }
            if (this.getProxyConfiguration() != null) {
                data.set("proxyConfiguration", om.valueToTree(this.getProxyConfiguration()));
            }
            if (this.getTaskRole() != null) {
                data.set("taskRole", om.valueToTree(this.getTaskRole()));
            }
            if (this.getVolumes() != null) {
                data.set("volumes", om.valueToTree(this.getVolumes()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CommonTaskDefinitionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CommonTaskDefinitionProps.Jsii$Proxy that = (CommonTaskDefinitionProps.Jsii$Proxy) o;

            if (this.executionRole != null ? !this.executionRole.equals(that.executionRole) : that.executionRole != null) return false;
            if (this.family != null ? !this.family.equals(that.family) : that.family != null) return false;
            if (this.proxyConfiguration != null ? !this.proxyConfiguration.equals(that.proxyConfiguration) : that.proxyConfiguration != null) return false;
            if (this.taskRole != null ? !this.taskRole.equals(that.taskRole) : that.taskRole != null) return false;
            return this.volumes != null ? this.volumes.equals(that.volumes) : that.volumes == null;
        }

        @Override
        public final int hashCode() {
            int result = this.executionRole != null ? this.executionRole.hashCode() : 0;
            result = 31 * result + (this.family != null ? this.family.hashCode() : 0);
            result = 31 * result + (this.proxyConfiguration != null ? this.proxyConfiguration.hashCode() : 0);
            result = 31 * result + (this.taskRole != null ? this.taskRole.hashCode() : 0);
            result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
            return result;
        }
    }
}
