package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * What to do when a client makes a request to a listener.
 * <p>
 * Some actions can be combined with other ones (specifically,
 * you can perform authentication before serving the request).
 * <p>
 * Multiple actions form a linked chain; the chain must always terminate in a
 * <em>(weighted)forward</em>, <em>fixedResponse</em> or <em>redirect</em> action.
 * <p>
 * If an action supports chaining, the next action can be indicated
 * by passing it in the <code>next</code> property.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * NetworkLoadBalancer lb;
 * NetworkTargetGroup group;
 * NetworkListener listener = lb.addListener("Listener", BaseNetworkListenerProps.builder()
 *         .port(80)
 *         .defaultAction(NetworkListenerAction.forward(List.of(group)))
 *         // The tcp idle timeout value. The valid range is 60-6000 seconds. The default is 350 seconds.
 *         .tcpIdleTimeout(Duration.seconds(100))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:08.214Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.NetworkListenerAction")
public class NetworkListenerAction extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.IListenerAction {

    protected NetworkListenerAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NetworkListenerAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Create an instance of NetworkListenerAction.
     * <p>
     * The default class should be good enough for most cases and
     * should be created by using one of the static factory functions,
     * but allow overriding to make sure we allow flexibility for the future.
     * <p>
     * @param defaultActionJson This parameter is required.
     * @param next
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected NetworkListenerAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.ActionProperty defaultActionJson, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction next) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(defaultActionJson, "defaultActionJson is required"), next });
    }

    /**
     * Create an instance of NetworkListenerAction.
     * <p>
     * The default class should be good enough for most cases and
     * should be created by using one of the static factory functions,
     * but allow overriding to make sure we allow flexibility for the future.
     * <p>
     * @param defaultActionJson This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected NetworkListenerAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.ActionProperty defaultActionJson) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(defaultActionJson, "defaultActionJson is required") });
    }

    /**
     * Forward to one or more Target Groups.
     * <p>
     * @param targetGroups This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction forward(final @org.jetbrains.annotations.NotNull java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> targetGroups, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.NetworkForwardOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction.class, "forward", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction.class), new Object[] { java.util.Objects.requireNonNull(targetGroups, "targetGroups is required"), options });
    }

    /**
     * Forward to one or more Target Groups.
     * <p>
     * @param targetGroups This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction forward(final @org.jetbrains.annotations.NotNull java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> targetGroups) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction.class, "forward", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction.class), new Object[] { java.util.Objects.requireNonNull(targetGroups, "targetGroups is required") });
    }

    /**
     * Forward to one or more Target Groups which are weighted differently.
     * <p>
     * @param targetGroups This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction weightedForward(final @org.jetbrains.annotations.NotNull java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.NetworkWeightedTargetGroup> targetGroups, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.NetworkForwardOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction.class, "weightedForward", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction.class), new Object[] { java.util.Objects.requireNonNull(targetGroups, "targetGroups is required"), options });
    }

    /**
     * Forward to one or more Target Groups which are weighted differently.
     * <p>
     * @param targetGroups This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction weightedForward(final @org.jetbrains.annotations.NotNull java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.NetworkWeightedTargetGroup> targetGroups) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction.class, "weightedForward", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction.class), new Object[] { java.util.Objects.requireNonNull(targetGroups, "targetGroups is required") });
    }

    /**
     * Called when the action is being used in a listener.
     * <p>
     * @param scope This parameter is required.
     * @param listener This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListener listener) {
        software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(listener, "listener is required") });
    }

    /**
     * Render the listener default actions in this chain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.ActionProperty> renderActions() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "renderActions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.ActionProperty.class))));
    }

    /**
     * Render the listener rule actions in this chain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.ActionProperty> renderRuleActions() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "renderRuleActions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.ActionProperty.class))));
    }

    /**
     * Renumber the "order" fields in the actions array.
     * <p>
     * We don't number for 0 or 1 elements, but otherwise number them 1...#actions
     * so ELB knows about the right order.
     * <p>
     * Do this in <code>NetworkListenerAction</code> instead of in <code>Listener</code> so that we give
     * users the opportunity to override by subclassing and overriding <code>renderActions</code>.
     * <p>
     * @param actions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.ActionProperty> renumber(final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.ActionProperty> actions) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "renumber", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.ActionProperty.class)), new Object[] { java.util.Objects.requireNonNull(actions, "actions is required") }));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction getNext() {
        return software.amazon.jsii.Kernel.get(this, "next", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction.class));
    }
}
