package software.amazon.awscdk.services.events.targets;

/**
 * Use an AWS CloudWatch LogGroup as an event rule target.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.logs.*;
 * LogGroup logGroup;
 * Rule rule;
 * rule.addTarget(CloudWatchLogGroup.Builder.create(logGroup)
 *         .logEvent(LogGroupTargetInput.fromObject(LogGroupTargetInputOptions.builder()
 *                 .message(JSON.stringify(Map.of(
 *                         "CustomField", "CustomValue")))
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:08.542Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events_targets.CloudWatchLogGroup")
public class CloudWatchLogGroup extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.IRuleTarget {

    protected CloudWatchLogGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CloudWatchLogGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param logGroup This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CloudWatchLogGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.ILogGroup logGroup, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.targets.LogGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(logGroup, "logGroup is required"), props });
    }

    /**
     * @param logGroup This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CloudWatchLogGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.ILogGroup logGroup) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(logGroup, "logGroup is required") });
    }

    /**
     * Returns a RuleTarget that can be used to log an event into a CloudWatch LogGroup.
     * <p>
     * @param _rule This parameter is required.
     * @param _id
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule _rule, final @org.jetbrains.annotations.Nullable java.lang.String _id) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(_rule, "_rule is required"), _id });
    }

    /**
     * Returns a RuleTarget that can be used to log an event into a CloudWatch LogGroup.
     * <p>
     * @param _rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule _rule) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(_rule, "_rule is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.events.targets.CloudWatchLogGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.events.targets.CloudWatchLogGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param logGroup This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.logs.ILogGroup logGroup) {
            return new Builder(logGroup);
        }

        private final software.amazon.awscdk.services.logs.ILogGroup logGroup;
        private software.amazon.awscdk.services.events.targets.LogGroupProps.Builder props;

        private Builder(final software.amazon.awscdk.services.logs.ILogGroup logGroup) {
            this.logGroup = logGroup;
        }

        /**
         * The SQS queue to be used as deadLetterQueue. Check out the <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/rule-dlq.html#dlq-considerations">considerations for using a dead-letter queue</a>.
         * <p>
         * The events not successfully delivered are automatically retried for a specified period of time,
         * depending on the retry policy of the target.
         * If an event is not delivered before all retry attempts are exhausted, it will be sent to the dead letter queue.
         * <p>
         * Default: - no dead-letter queue
         * <p>
         * @return {@code this}
         * @param deadLetterQueue The SQS queue to be used as deadLetterQueue. Check out the <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/rule-dlq.html#dlq-considerations">considerations for using a dead-letter queue</a>. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.props().deadLetterQueue(deadLetterQueue);
            return this;
        }

        /**
         * The maximum age of a request that Lambda sends to a function for processing.
         * <p>
         * Minimum value of 60.
         * Maximum value of 86400.
         * <p>
         * Default: Duration.hours(24)
         * <p>
         * @return {@code this}
         * @param maxEventAge The maximum age of a request that Lambda sends to a function for processing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEventAge(final software.amazon.awscdk.Duration maxEventAge) {
            this.props().maxEventAge(maxEventAge);
            return this;
        }

        /**
         * The maximum number of times to retry when the function returns an error.
         * <p>
         * Minimum value of 0.
         * Maximum value of 185.
         * <p>
         * Default: 185
         * <p>
         * @return {@code this}
         * @param retryAttempts The maximum number of times to retry when the function returns an error. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(final java.lang.Number retryAttempts) {
            this.props().retryAttempts(retryAttempts);
            return this;
        }

        /**
         * (deprecated) The event to send to the CloudWatch LogGroup.
         * <p>
         * This will be the event logged into the CloudWatch LogGroup
         * <p>
         * Default: - the entire EventBridge event
         * <p>
         * @return {@code this}
         * @deprecated use logEvent instead
         * @param event The event to send to the CloudWatch LogGroup. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder event(final software.amazon.awscdk.services.events.RuleTargetInput event) {
            this.props().event(event);
            return this;
        }

        /**
         * Whether the custom resource created wll default to install latest AWS SDK.
         * <p>
         * Default: - install latest AWS SDK
         * <p>
         * @return {@code this}
         * @param installLatestAwsSdk Whether the custom resource created wll default to install latest AWS SDK. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder installLatestAwsSdk(final java.lang.Boolean installLatestAwsSdk) {
            this.props().installLatestAwsSdk(installLatestAwsSdk);
            return this;
        }

        /**
         * The event to send to the CloudWatch LogGroup.
         * <p>
         * This will be the event logged into the CloudWatch LogGroup
         * <p>
         * Default: - the entire EventBridge event
         * <p>
         * @return {@code this}
         * @param logEvent The event to send to the CloudWatch LogGroup. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logEvent(final software.amazon.awscdk.services.events.targets.LogGroupTargetInput logEvent) {
            this.props().logEvent(logEvent);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.events.targets.CloudWatchLogGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.events.targets.CloudWatchLogGroup build() {
            return new software.amazon.awscdk.services.events.targets.CloudWatchLogGroup(
                this.logGroup,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.events.targets.LogGroupProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.events.targets.LogGroupProps.Builder();
            }
            return this.props;
        }
    }
}
