package software.amazon.awscdk.services.lambda;

/**
 * Represents the filesystem for the Lambda function.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.efs.*;
 * // create a new VPC
 * Vpc vpc = new Vpc(this, "VPC");
 * // create a new Amazon EFS filesystem
 * FileSystem fileSystem = FileSystem.Builder.create(this, "Efs").vpc(vpc).build();
 * // create a new access point from the filesystem
 * AccessPoint accessPoint = fileSystem.addAccessPoint("AccessPoint", AccessPointOptions.builder()
 *         // set /export/lambda as the root of the access point
 *         .path("/export/lambda")
 *         // as /export/lambda does not exist in a new efs filesystem, the efs will create the directory with the following createAcl
 *         .createAcl(Acl.builder()
 *                 .ownerUid("1001")
 *                 .ownerGid("1001")
 *                 .permissions("750")
 *                 .build())
 *         // enforce the POSIX identity so lambda function will access with this identity
 *         .posixUser(PosixUser.builder()
 *                 .uid("1001")
 *                 .gid("1001")
 *                 .build())
 *         .build());
 * Function fn = Function.Builder.create(this, "MyLambda")
 *         // mount the access point to /mnt/msg in the lambda runtime environment
 *         .filesystem(FileSystem.fromEfsAccessPoint(accessPoint, "/mnt/msg"))
 *         .runtime(Runtime.NODEJS_18_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset(join(__dirname, "lambda-handler")))
 *         .vpc(vpc)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:10.419Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.FileSystem")
public class FileSystem extends software.amazon.jsii.JsiiObject {

    protected FileSystem(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FileSystem(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param config the FileSystem configurations for the Lambda function. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected FileSystem(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.FileSystemConfig config) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(config, "config is required") });
    }

    /**
     * mount the filesystem from Amazon EFS.
     * <p>
     * @param ap the Amazon EFS access point. This parameter is required.
     * @param mountPath the target path in the lambda runtime environment. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.FileSystem fromEfsAccessPoint(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.IAccessPoint ap, final @org.jetbrains.annotations.NotNull java.lang.String mountPath) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.FileSystem.class, "fromEfsAccessPoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.FileSystem.class), new Object[] { java.util.Objects.requireNonNull(ap, "ap is required"), java.util.Objects.requireNonNull(mountPath, "mountPath is required") });
    }

    /**
     * the FileSystem configurations for the Lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.FileSystemConfig getConfig() {
        return software.amazon.jsii.Kernel.get(this, "config", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.FileSystemConfig.class));
    }
}
