package software.amazon.awscdk.services.lambda.eventsources;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * import software.amazon.awscdk.services.lambda.eventsources.*;
 * Authorizer authorizer;
 * Model model;
 * RequestValidator requestValidator;
 * ApiEventSource apiEventSource = ApiEventSource.Builder.create("method", "path")
 *         .apiKeyRequired(false)
 *         .authorizationScopes(List.of("authorizationScopes"))
 *         .authorizationType(AuthorizationType.NONE)
 *         .authorizer(authorizer)
 *         .methodResponses(List.of(MethodResponse.builder()
 *                 .statusCode("statusCode")
 *                 // the properties below are optional
 *                 .responseModels(Map.of(
 *                         "responseModelsKey", model))
 *                 .responseParameters(Map.of(
 *                         "responseParametersKey", false))
 *                 .build()))
 *         .operationName("operationName")
 *         .requestModels(Map.of(
 *                 "requestModelsKey", model))
 *         .requestParameters(Map.of(
 *                 "requestParametersKey", false))
 *         .requestValidator(requestValidator)
 *         .requestValidatorOptions(RequestValidatorOptions.builder()
 *                 .requestValidatorName("requestValidatorName")
 *                 .validateRequestBody(false)
 *                 .validateRequestParameters(false)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:10.520Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda_event_sources.ApiEventSource")
public class ApiEventSource extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.IEventSource {

    protected ApiEventSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ApiEventSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param method This parameter is required.
     * @param path This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ApiEventSource(final @org.jetbrains.annotations.NotNull java.lang.String method, final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.MethodOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(method, "method is required"), java.util.Objects.requireNonNull(path, "path is required"), options });
    }

    /**
     * @param method This parameter is required.
     * @param path This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ApiEventSource(final @org.jetbrains.annotations.NotNull java.lang.String method, final @org.jetbrains.annotations.NotNull java.lang.String path) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(method, "method is required"), java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Called by <code>lambda.addEventSource</code> to allow the event source to bind to this function.
     * <p>
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction target) {
        software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.eventsources.ApiEventSource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lambda.eventsources.ApiEventSource> {
        /**
         * @return a new instance of {@link Builder}.
         * @param method This parameter is required.
         * @param path This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String method, final java.lang.String path) {
            return new Builder(method, path);
        }

        private final java.lang.String method;
        private final java.lang.String path;
        private software.amazon.awscdk.services.apigateway.MethodOptions.Builder options;

        private Builder(final java.lang.String method, final java.lang.String path) {
            this.method = method;
            this.path = path;
        }

        /**
         * Indicates whether the method requires clients to submit a valid API key.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param apiKeyRequired Indicates whether the method requires clients to submit a valid API key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeyRequired(final java.lang.Boolean apiKeyRequired) {
            this.options().apiKeyRequired(apiKeyRequired);
            return this;
        }

        /**
         * A list of authorization scopes configured on the method.
         * <p>
         * The scopes are used with
         * a COGNITO_USER_POOLS authorizer to authorize the method invocation.
         * <p>
         * Default: - no authorization scopes
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes</a>
         * @param authorizationScopes A list of authorization scopes configured on the method. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationScopes(final java.util.List<java.lang.String> authorizationScopes) {
            this.options().authorizationScopes(authorizationScopes);
            return this;
        }

        /**
         * Method authorization. If the value is set of <code>Custom</code>, an <code>authorizer</code> must also be specified.
         * <p>
         * If you're using one of the authorizers that are available via the <code>Authorizer</code> class, such as <code>Authorizer#token()</code>,
         * it is recommended that this option not be specified. The authorizer will take care of setting the correct authorization type.
         * However, specifying an authorization type using this property that conflicts with what is expected by the <code>Authorizer</code>
         * will result in an error.
         * <p>
         * Default: - open access unless `authorizer` is specified
         * <p>
         * @return {@code this}
         * @param authorizationType Method authorization. If the value is set of <code>Custom</code>, an <code>authorizer</code> must also be specified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationType(final software.amazon.awscdk.services.apigateway.AuthorizationType authorizationType) {
            this.options().authorizationType(authorizationType);
            return this;
        }

        /**
         * If <code>authorizationType</code> is <code>Custom</code>, this specifies the ID of the method authorizer resource.
         * <p>
         * If specified, the value of <code>authorizationType</code> must be set to <code>Custom</code>
         * <p>
         * @return {@code this}
         * @param authorizer If <code>authorizationType</code> is <code>Custom</code>, this specifies the ID of the method authorizer resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizer(final software.amazon.awscdk.services.apigateway.IAuthorizer authorizer) {
            this.options().authorizer(authorizer);
            return this;
        }

        /**
         * The responses that can be sent to the client who calls the method.
         * <p>
         * Default: None
         * This property is not required, but if these are not supplied for a Lambda
         * proxy integration, the Lambda function must return a value of the correct format,
         * for the integration response to be correctly mapped to a response to the client.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-method-settings-method-response.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-method-settings-method-response.html</a>
         * @param methodResponses The responses that can be sent to the client who calls the method. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder methodResponses(final java.util.List<? extends software.amazon.awscdk.services.apigateway.MethodResponse> methodResponses) {
            this.options().methodResponses(methodResponses);
            return this;
        }

        /**
         * A friendly operation name for the method.
         * <p>
         * For example, you can assign the
         * OperationName of ListPets for the GET /pets method.
         * <p>
         * @return {@code this}
         * @param operationName A friendly operation name for the method. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder operationName(final java.lang.String operationName) {
            this.options().operationName(operationName);
            return this;
        }

        /**
         * The models which describe data structure of request payload.
         * <p>
         * When
         * combined with <code>requestValidator</code> or <code>requestValidatorOptions</code>, the service
         * will validate the API request payload before it reaches the API's Integration (including proxies).
         * Specify <code>requestModels</code> as key-value pairs, with a content type
         * (e.g. <code>'application/json'</code>) as the key and an API Gateway Model as the value.
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * RestApi api;
         * Function userLambda;
         * Model userModel = api.addModel("UserModel", ModelOptions.builder()
         *         .schema(JsonSchema.builder()
         *                 .type(JsonSchemaType.OBJECT)
         *                 .properties(Map.of(
         *                         "userId", JsonSchema.builder()
         *                                 .type(JsonSchemaType.STRING)
         *                                 .build(),
         *                         "name", JsonSchema.builder()
         *                                 .type(JsonSchemaType.STRING)
         *                                 .build()))
         *                 .required(List.of("userId"))
         *                 .build())
         *         .build());
         * api.root.addResource("user").addMethod("POST",
         * new LambdaIntegration(userLambda), MethodOptions.builder()
         *         .requestModels(Map.of(
         *                 "application/json", userModel))
         *         .build());
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-method-settings-method-request.html#setup-method-request-model">https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-method-settings-method-request.html#setup-method-request-model</a>
         * @param requestModels The models which describe data structure of request payload. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestModels(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.apigateway.IModel> requestModels) {
            this.options().requestModels(requestModels);
            return this;
        }

        /**
         * The request parameters that API Gateway accepts.
         * <p>
         * Specify request parameters
         * as key-value pairs (string-to-Boolean mapping), with a source as the key and
         * a Boolean as the value. The Boolean specifies whether a parameter is required.
         * A source must match the format method.request.location.name, where the location
         * is querystring, path, or header, and name is a valid, unique parameter name.
         * <p>
         * Default: None
         * <p>
         * @return {@code this}
         * @param requestParameters The request parameters that API Gateway accepts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestParameters(final java.util.Map<java.lang.String, ? extends java.lang.Boolean> requestParameters) {
            this.options().requestParameters(requestParameters);
            return this;
        }

        /**
         * The ID of the associated request validator.
         * <p>
         * Only one of <code>requestValidator</code> or <code>requestValidatorOptions</code> must be specified.
         * Works together with <code>requestModels</code> or <code>requestParameters</code> to validate
         * the request before it reaches integration like Lambda Proxy Integration.
         * <p>
         * Default: - No default validator
         * <p>
         * @return {@code this}
         * @param requestValidator The ID of the associated request validator. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestValidator(final software.amazon.awscdk.services.apigateway.IRequestValidator requestValidator) {
            this.options().requestValidator(requestValidator);
            return this;
        }

        /**
         * Request validator options to create new validator Only one of <code>requestValidator</code> or <code>requestValidatorOptions</code> must be specified.
         * <p>
         * Works together with <code>requestModels</code> or <code>requestParameters</code> to validate
         * the request before it reaches integration like Lambda Proxy Integration.
         * <p>
         * Default: - No default validator
         * <p>
         * @return {@code this}
         * @param requestValidatorOptions Request validator options to create new validator Only one of <code>requestValidator</code> or <code>requestValidatorOptions</code> must be specified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestValidatorOptions(final software.amazon.awscdk.services.apigateway.RequestValidatorOptions requestValidatorOptions) {
            this.options().requestValidatorOptions(requestValidatorOptions);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.lambda.eventsources.ApiEventSource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lambda.eventsources.ApiEventSource build() {
            return new software.amazon.awscdk.services.lambda.eventsources.ApiEventSource(
                this.method,
                this.path,
                this.options != null ? this.options.build() : null
            );
        }

        private software.amazon.awscdk.services.apigateway.MethodOptions.Builder options() {
            if (this.options == null) {
                this.options = new software.amazon.awscdk.services.apigateway.MethodOptions.Builder();
            }
            return this.options;
        }
    }
}
