package software.amazon.awscdk.services.lightsail;

/**
 * Properties for defining a <code>CfnDatabase</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lightsail.*;
 * CfnDatabaseProps cfnDatabaseProps = CfnDatabaseProps.builder()
 *         .masterDatabaseName("masterDatabaseName")
 *         .masterUsername("masterUsername")
 *         .relationalDatabaseBlueprintId("relationalDatabaseBlueprintId")
 *         .relationalDatabaseBundleId("relationalDatabaseBundleId")
 *         .relationalDatabaseName("relationalDatabaseName")
 *         // the properties below are optional
 *         .availabilityZone("availabilityZone")
 *         .backupRetention(false)
 *         .caCertificateIdentifier("caCertificateIdentifier")
 *         .masterUserPassword("masterUserPassword")
 *         .preferredBackupWindow("preferredBackupWindow")
 *         .preferredMaintenanceWindow("preferredMaintenanceWindow")
 *         .publiclyAccessible(false)
 *         .relationalDatabaseParameters(List.of(RelationalDatabaseParameterProperty.builder()
 *                 .allowedValues("allowedValues")
 *                 .applyMethod("applyMethod")
 *                 .applyType("applyType")
 *                 .dataType("dataType")
 *                 .description("description")
 *                 .isModifiable(false)
 *                 .parameterName("parameterName")
 *                 .parameterValue("parameterValue")
 *                 .build()))
 *         .rotateMasterUserPassword(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:10.684Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lightsail.CfnDatabaseProps")
@software.amazon.jsii.Jsii.Proxy(CfnDatabaseProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDatabaseProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The meaning of this parameter differs according to the database engine you use.
     * <p>
     * <em>MySQL</em>
     * <p>
     * The name of the database to create when the Lightsail database resource is created. If this parameter isn't specified, no database is created in the database resource.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must contain 1-64 letters or numbers.</li>
     * <li>Must begin with a letter. Subsequent characters can be letters, underscores, or numbers (0-9).</li>
     * <li>Can't be a word reserved by the specified database engine.</li>
     * </ul>
     * <p>
     * For more information about reserved words in MySQL, see the Keywords and Reserved Words articles for <a href="https://docs.aws.amazon.com/https://dev.mysql.com/doc/refman/5.6/en/keywords.html">MySQL 5.6</a> , <a href="https://docs.aws.amazon.com/https://dev.mysql.com/doc/refman/5.7/en/keywords.html">MySQL 5.7</a> , and <a href="https://docs.aws.amazon.com/https://dev.mysql.com/doc/refman/8.0/en/keywords.html">MySQL 8.0</a> .
     * <p>
     * <em>PostgreSQL</em>
     * <p>
     * The name of the database to create when the Lightsail database resource is created. If this parameter isn't specified, a database named <code>postgres</code> is created in the database resource.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must contain 1-63 letters or numbers.</li>
     * <li>Must begin with a letter. Subsequent characters can be letters, underscores, or numbers (0-9).</li>
     * <li>Can't be a word reserved by the specified database engine.</li>
     * </ul>
     * <p>
     * For more information about reserved words in PostgreSQL, see the SQL Key Words articles for <a href="https://docs.aws.amazon.com/https://www.postgresql.org/docs/9.6/sql-keywords-appendix.html">PostgreSQL 9.6</a> , <a href="https://docs.aws.amazon.com/https://www.postgresql.org/docs/10/sql-keywords-appendix.html">PostgreSQL 10</a> , <a href="https://docs.aws.amazon.com/https://www.postgresql.org/docs/11/sql-keywords-appendix.html">PostgreSQL 11</a> , and <a href="https://docs.aws.amazon.com/https://www.postgresql.org/docs/12/sql-keywords-appendix.html">PostgreSQL 12</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-masterdatabasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-masterdatabasename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMasterDatabaseName();

    /**
     * The name for the primary user.
     * <p>
     * <em>MySQL</em>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Required for MySQL.</li>
     * <li>Must be 1-16 letters or numbers. Can contain underscores.</li>
     * <li>First character must be a letter.</li>
     * <li>Can't be a reserved word for the chosen database engine.</li>
     * </ul>
     * <p>
     * For more information about reserved words in MySQL 5.6 or 5.7, see the Keywords and Reserved Words articles for <a href="https://docs.aws.amazon.com/https://dev.mysql.com/doc/refman/5.6/en/keywords.html">MySQL 5.6</a> , <a href="https://docs.aws.amazon.com/https://dev.mysql.com/doc/refman/5.7/en/keywords.html">MySQL 5.7</a> , or <a href="https://docs.aws.amazon.com/https://dev.mysql.com/doc/refman/8.0/en/keywords.html">MySQL 8.0</a> .
     * <p>
     * <em>PostgreSQL</em>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Required for PostgreSQL.</li>
     * <li>Must be 1-63 letters or numbers. Can contain underscores.</li>
     * <li>First character must be a letter.</li>
     * <li>Can't be a reserved word for the chosen database engine.</li>
     * </ul>
     * <p>
     * For more information about reserved words in MySQL 5.6 or 5.7, see the Keywords and Reserved Words articles for <a href="https://docs.aws.amazon.com/https://www.postgresql.org/docs/9.6/sql-keywords-appendix.html">PostgreSQL 9.6</a> , <a href="https://docs.aws.amazon.com/https://www.postgresql.org/docs/10/sql-keywords-appendix.html">PostgreSQL 10</a> , <a href="https://docs.aws.amazon.com/https://www.postgresql.org/docs/11/sql-keywords-appendix.html">PostgreSQL 11</a> , and <a href="https://docs.aws.amazon.com/https://www.postgresql.org/docs/12/sql-keywords-appendix.html">PostgreSQL 12</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-masterusername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-masterusername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMasterUsername();

    /**
     * The blueprint ID for the database (for example, <code>mysql_8_0</code> ).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-relationaldatabaseblueprintid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-relationaldatabaseblueprintid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRelationalDatabaseBlueprintId();

    /**
     * The bundle ID for the database (for example, <code>medium_1_0</code> ).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-relationaldatabasebundleid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-relationaldatabasebundleid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRelationalDatabaseBundleId();

    /**
     * The name of the instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-relationaldatabasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-relationaldatabasename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRelationalDatabaseName();

    /**
     * The Availability Zone for the database.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-availabilityzone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-availabilityzone</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return null;
    }

    /**
     * A Boolean value indicating whether automated backup retention is enabled for the database.
     * <p>
     * Data Import Mode is enabled when <code>BackupRetention</code> is set to <code>false</code> , and is disabled when <code>BackupRetention</code> is set to <code>true</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-backupretention">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-backupretention</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBackupRetention() {
        return null;
    }

    /**
     * The certificate associated with the database.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-cacertificateidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-cacertificateidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCaCertificateIdentifier() {
        return null;
    }

    /**
     * The password for the primary user of the database.
     * <p>
     * The password can include any printable ASCII character except the following: /, ", or
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-masteruserpassword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-masteruserpassword</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMasterUserPassword() {
        return null;
    }

    /**
     * The daily time range during which automated backups are created for the database (for example, <code>16:00-16:30</code> ).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-preferredbackupwindow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-preferredbackupwindow</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreferredBackupWindow() {
        return null;
    }

    /**
     * The weekly time range during which system maintenance can occur for the database, formatted as follows: <code>ddd:hh24:mi-ddd:hh24:mi</code> .
     * <p>
     * For example, <code>Tue:17:00-Tue:17:30</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-preferredmaintenancewindow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-preferredmaintenancewindow</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreferredMaintenanceWindow() {
        return null;
    }

    /**
     * A Boolean value indicating whether the database is accessible to anyone on the internet.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-publiclyaccessible">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-publiclyaccessible</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPubliclyAccessible() {
        return null;
    }

    /**
     * An array of parameters for the database.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-relationaldatabaseparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-relationaldatabaseparameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRelationalDatabaseParameters() {
        return null;
    }

    /**
     * A Boolean value indicating whether to change the primary user password to a new, strong password generated by Lightsail .
     * <p>
     * <blockquote>
     * <p>
     * The <code>RotateMasterUserPassword</code> and <code>MasterUserPassword</code> parameters cannot be used together in the same template.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-rotatemasteruserpassword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-rotatemasteruserpassword</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRotateMasterUserPassword() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> in the <em>AWS CloudFormation User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * The <code>Value</code> of <code>Tags</code> is optional for Lightsail resources.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDatabaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDatabaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDatabaseProps> {
        java.lang.String masterDatabaseName;
        java.lang.String masterUsername;
        java.lang.String relationalDatabaseBlueprintId;
        java.lang.String relationalDatabaseBundleId;
        java.lang.String relationalDatabaseName;
        java.lang.String availabilityZone;
        java.lang.Object backupRetention;
        java.lang.String caCertificateIdentifier;
        java.lang.String masterUserPassword;
        java.lang.String preferredBackupWindow;
        java.lang.String preferredMaintenanceWindow;
        java.lang.Object publiclyAccessible;
        java.lang.Object relationalDatabaseParameters;
        java.lang.Object rotateMasterUserPassword;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDatabaseProps#getMasterDatabaseName}
         * @param masterDatabaseName The meaning of this parameter differs according to the database engine you use. This parameter is required.
         *                           <em>MySQL</em>
         *                           <p>
         *                           The name of the database to create when the Lightsail database resource is created. If this parameter isn't specified, no database is created in the database resource.
         *                           <p>
         *                           Constraints:
         *                           <p>
         *                           <ul>
         *                           <li>Must contain 1-64 letters or numbers.</li>
         *                           <li>Must begin with a letter. Subsequent characters can be letters, underscores, or numbers (0-9).</li>
         *                           <li>Can't be a word reserved by the specified database engine.</li>
         *                           </ul>
         *                           <p>
         *                           For more information about reserved words in MySQL, see the Keywords and Reserved Words articles for <a href="https://docs.aws.amazon.com/https://dev.mysql.com/doc/refman/5.6/en/keywords.html">MySQL 5.6</a> , <a href="https://docs.aws.amazon.com/https://dev.mysql.com/doc/refman/5.7/en/keywords.html">MySQL 5.7</a> , and <a href="https://docs.aws.amazon.com/https://dev.mysql.com/doc/refman/8.0/en/keywords.html">MySQL 8.0</a> .
         *                           <p>
         *                           <em>PostgreSQL</em>
         *                           <p>
         *                           The name of the database to create when the Lightsail database resource is created. If this parameter isn't specified, a database named <code>postgres</code> is created in the database resource.
         *                           <p>
         *                           Constraints:
         *                           <p>
         *                           <ul>
         *                           <li>Must contain 1-63 letters or numbers.</li>
         *                           <li>Must begin with a letter. Subsequent characters can be letters, underscores, or numbers (0-9).</li>
         *                           <li>Can't be a word reserved by the specified database engine.</li>
         *                           </ul>
         *                           <p>
         *                           For more information about reserved words in PostgreSQL, see the SQL Key Words articles for <a href="https://docs.aws.amazon.com/https://www.postgresql.org/docs/9.6/sql-keywords-appendix.html">PostgreSQL 9.6</a> , <a href="https://docs.aws.amazon.com/https://www.postgresql.org/docs/10/sql-keywords-appendix.html">PostgreSQL 10</a> , <a href="https://docs.aws.amazon.com/https://www.postgresql.org/docs/11/sql-keywords-appendix.html">PostgreSQL 11</a> , and <a href="https://docs.aws.amazon.com/https://www.postgresql.org/docs/12/sql-keywords-appendix.html">PostgreSQL 12</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterDatabaseName(java.lang.String masterDatabaseName) {
            this.masterDatabaseName = masterDatabaseName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatabaseProps#getMasterUsername}
         * @param masterUsername The name for the primary user. This parameter is required.
         *                       <em>MySQL</em>
         *                       <p>
         *                       Constraints:
         *                       <p>
         *                       <ul>
         *                       <li>Required for MySQL.</li>
         *                       <li>Must be 1-16 letters or numbers. Can contain underscores.</li>
         *                       <li>First character must be a letter.</li>
         *                       <li>Can't be a reserved word for the chosen database engine.</li>
         *                       </ul>
         *                       <p>
         *                       For more information about reserved words in MySQL 5.6 or 5.7, see the Keywords and Reserved Words articles for <a href="https://docs.aws.amazon.com/https://dev.mysql.com/doc/refman/5.6/en/keywords.html">MySQL 5.6</a> , <a href="https://docs.aws.amazon.com/https://dev.mysql.com/doc/refman/5.7/en/keywords.html">MySQL 5.7</a> , or <a href="https://docs.aws.amazon.com/https://dev.mysql.com/doc/refman/8.0/en/keywords.html">MySQL 8.0</a> .
         *                       <p>
         *                       <em>PostgreSQL</em>
         *                       <p>
         *                       Constraints:
         *                       <p>
         *                       <ul>
         *                       <li>Required for PostgreSQL.</li>
         *                       <li>Must be 1-63 letters or numbers. Can contain underscores.</li>
         *                       <li>First character must be a letter.</li>
         *                       <li>Can't be a reserved word for the chosen database engine.</li>
         *                       </ul>
         *                       <p>
         *                       For more information about reserved words in MySQL 5.6 or 5.7, see the Keywords and Reserved Words articles for <a href="https://docs.aws.amazon.com/https://www.postgresql.org/docs/9.6/sql-keywords-appendix.html">PostgreSQL 9.6</a> , <a href="https://docs.aws.amazon.com/https://www.postgresql.org/docs/10/sql-keywords-appendix.html">PostgreSQL 10</a> , <a href="https://docs.aws.amazon.com/https://www.postgresql.org/docs/11/sql-keywords-appendix.html">PostgreSQL 11</a> , and <a href="https://docs.aws.amazon.com/https://www.postgresql.org/docs/12/sql-keywords-appendix.html">PostgreSQL 12</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUsername(java.lang.String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatabaseProps#getRelationalDatabaseBlueprintId}
         * @param relationalDatabaseBlueprintId The blueprint ID for the database (for example, <code>mysql_8_0</code> ). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder relationalDatabaseBlueprintId(java.lang.String relationalDatabaseBlueprintId) {
            this.relationalDatabaseBlueprintId = relationalDatabaseBlueprintId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatabaseProps#getRelationalDatabaseBundleId}
         * @param relationalDatabaseBundleId The bundle ID for the database (for example, <code>medium_1_0</code> ). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder relationalDatabaseBundleId(java.lang.String relationalDatabaseBundleId) {
            this.relationalDatabaseBundleId = relationalDatabaseBundleId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatabaseProps#getRelationalDatabaseName}
         * @param relationalDatabaseName The name of the instance. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder relationalDatabaseName(java.lang.String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatabaseProps#getAvailabilityZone}
         * @param availabilityZone The Availability Zone for the database.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatabaseProps#getBackupRetention}
         * @param backupRetention A Boolean value indicating whether automated backup retention is enabled for the database.
         *                        Data Import Mode is enabled when <code>BackupRetention</code> is set to <code>false</code> , and is disabled when <code>BackupRetention</code> is set to <code>true</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupRetention(java.lang.Boolean backupRetention) {
            this.backupRetention = backupRetention;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatabaseProps#getBackupRetention}
         * @param backupRetention A Boolean value indicating whether automated backup retention is enabled for the database.
         *                        Data Import Mode is enabled when <code>BackupRetention</code> is set to <code>false</code> , and is disabled when <code>BackupRetention</code> is set to <code>true</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupRetention(software.amazon.awscdk.IResolvable backupRetention) {
            this.backupRetention = backupRetention;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatabaseProps#getCaCertificateIdentifier}
         * @param caCertificateIdentifier The certificate associated with the database.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder caCertificateIdentifier(java.lang.String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatabaseProps#getMasterUserPassword}
         * @param masterUserPassword The password for the primary user of the database.
         *                           The password can include any printable ASCII character except the following: /, ", or
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUserPassword(java.lang.String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatabaseProps#getPreferredBackupWindow}
         * @param preferredBackupWindow The daily time range during which automated backups are created for the database (for example, <code>16:00-16:30</code> ).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredBackupWindow(java.lang.String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatabaseProps#getPreferredMaintenanceWindow}
         * @param preferredMaintenanceWindow The weekly time range during which system maintenance can occur for the database, formatted as follows: <code>ddd:hh24:mi-ddd:hh24:mi</code> .
         *                                   For example, <code>Tue:17:00-Tue:17:30</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredMaintenanceWindow(java.lang.String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatabaseProps#getPubliclyAccessible}
         * @param publiclyAccessible A Boolean value indicating whether the database is accessible to anyone on the internet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(java.lang.Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatabaseProps#getPubliclyAccessible}
         * @param publiclyAccessible A Boolean value indicating whether the database is accessible to anyone on the internet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(software.amazon.awscdk.IResolvable publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatabaseProps#getRelationalDatabaseParameters}
         * @param relationalDatabaseParameters An array of parameters for the database.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder relationalDatabaseParameters(software.amazon.awscdk.IResolvable relationalDatabaseParameters) {
            this.relationalDatabaseParameters = relationalDatabaseParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatabaseProps#getRelationalDatabaseParameters}
         * @param relationalDatabaseParameters An array of parameters for the database.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder relationalDatabaseParameters(java.util.List<? extends java.lang.Object> relationalDatabaseParameters) {
            this.relationalDatabaseParameters = relationalDatabaseParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatabaseProps#getRotateMasterUserPassword}
         * @param rotateMasterUserPassword A Boolean value indicating whether to change the primary user password to a new, strong password generated by Lightsail .
         *                                 <blockquote>
         *                                 <p>
         *                                 The <code>RotateMasterUserPassword</code> and <code>MasterUserPassword</code> parameters cannot be used together in the same template.
         *                                 <p>
         *                                 </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotateMasterUserPassword(java.lang.Boolean rotateMasterUserPassword) {
            this.rotateMasterUserPassword = rotateMasterUserPassword;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatabaseProps#getRotateMasterUserPassword}
         * @param rotateMasterUserPassword A Boolean value indicating whether to change the primary user password to a new, strong password generated by Lightsail .
         *                                 <blockquote>
         *                                 <p>
         *                                 The <code>RotateMasterUserPassword</code> and <code>MasterUserPassword</code> parameters cannot be used together in the same template.
         *                                 <p>
         *                                 </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotateMasterUserPassword(software.amazon.awscdk.IResolvable rotateMasterUserPassword) {
            this.rotateMasterUserPassword = rotateMasterUserPassword;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatabaseProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> in the <em>AWS CloudFormation User Guide</em> .
         *             <p>
         *             <blockquote>
         *             <p>
         *             The <code>Value</code> of <code>Tags</code> is optional for Lightsail resources.
         *             <p>
         *             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDatabaseProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDatabaseProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDatabaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDatabaseProps {
        private final java.lang.String masterDatabaseName;
        private final java.lang.String masterUsername;
        private final java.lang.String relationalDatabaseBlueprintId;
        private final java.lang.String relationalDatabaseBundleId;
        private final java.lang.String relationalDatabaseName;
        private final java.lang.String availabilityZone;
        private final java.lang.Object backupRetention;
        private final java.lang.String caCertificateIdentifier;
        private final java.lang.String masterUserPassword;
        private final java.lang.String preferredBackupWindow;
        private final java.lang.String preferredMaintenanceWindow;
        private final java.lang.Object publiclyAccessible;
        private final java.lang.Object relationalDatabaseParameters;
        private final java.lang.Object rotateMasterUserPassword;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.masterDatabaseName = software.amazon.jsii.Kernel.get(this, "masterDatabaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.masterUsername = software.amazon.jsii.Kernel.get(this, "masterUsername", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.relationalDatabaseBlueprintId = software.amazon.jsii.Kernel.get(this, "relationalDatabaseBlueprintId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.relationalDatabaseBundleId = software.amazon.jsii.Kernel.get(this, "relationalDatabaseBundleId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.relationalDatabaseName = software.amazon.jsii.Kernel.get(this, "relationalDatabaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.backupRetention = software.amazon.jsii.Kernel.get(this, "backupRetention", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.caCertificateIdentifier = software.amazon.jsii.Kernel.get(this, "caCertificateIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.masterUserPassword = software.amazon.jsii.Kernel.get(this, "masterUserPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.preferredBackupWindow = software.amazon.jsii.Kernel.get(this, "preferredBackupWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.preferredMaintenanceWindow = software.amazon.jsii.Kernel.get(this, "preferredMaintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.publiclyAccessible = software.amazon.jsii.Kernel.get(this, "publiclyAccessible", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.relationalDatabaseParameters = software.amazon.jsii.Kernel.get(this, "relationalDatabaseParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.rotateMasterUserPassword = software.amazon.jsii.Kernel.get(this, "rotateMasterUserPassword", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.masterDatabaseName = java.util.Objects.requireNonNull(builder.masterDatabaseName, "masterDatabaseName is required");
            this.masterUsername = java.util.Objects.requireNonNull(builder.masterUsername, "masterUsername is required");
            this.relationalDatabaseBlueprintId = java.util.Objects.requireNonNull(builder.relationalDatabaseBlueprintId, "relationalDatabaseBlueprintId is required");
            this.relationalDatabaseBundleId = java.util.Objects.requireNonNull(builder.relationalDatabaseBundleId, "relationalDatabaseBundleId is required");
            this.relationalDatabaseName = java.util.Objects.requireNonNull(builder.relationalDatabaseName, "relationalDatabaseName is required");
            this.availabilityZone = builder.availabilityZone;
            this.backupRetention = builder.backupRetention;
            this.caCertificateIdentifier = builder.caCertificateIdentifier;
            this.masterUserPassword = builder.masterUserPassword;
            this.preferredBackupWindow = builder.preferredBackupWindow;
            this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
            this.publiclyAccessible = builder.publiclyAccessible;
            this.relationalDatabaseParameters = builder.relationalDatabaseParameters;
            this.rotateMasterUserPassword = builder.rotateMasterUserPassword;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getMasterDatabaseName() {
            return this.masterDatabaseName;
        }

        @Override
        public final java.lang.String getMasterUsername() {
            return this.masterUsername;
        }

        @Override
        public final java.lang.String getRelationalDatabaseBlueprintId() {
            return this.relationalDatabaseBlueprintId;
        }

        @Override
        public final java.lang.String getRelationalDatabaseBundleId() {
            return this.relationalDatabaseBundleId;
        }

        @Override
        public final java.lang.String getRelationalDatabaseName() {
            return this.relationalDatabaseName;
        }

        @Override
        public final java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final java.lang.Object getBackupRetention() {
            return this.backupRetention;
        }

        @Override
        public final java.lang.String getCaCertificateIdentifier() {
            return this.caCertificateIdentifier;
        }

        @Override
        public final java.lang.String getMasterUserPassword() {
            return this.masterUserPassword;
        }

        @Override
        public final java.lang.String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        @Override
        public final java.lang.String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final java.lang.Object getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final java.lang.Object getRelationalDatabaseParameters() {
            return this.relationalDatabaseParameters;
        }

        @Override
        public final java.lang.Object getRotateMasterUserPassword() {
            return this.rotateMasterUserPassword;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("masterDatabaseName", om.valueToTree(this.getMasterDatabaseName()));
            data.set("masterUsername", om.valueToTree(this.getMasterUsername()));
            data.set("relationalDatabaseBlueprintId", om.valueToTree(this.getRelationalDatabaseBlueprintId()));
            data.set("relationalDatabaseBundleId", om.valueToTree(this.getRelationalDatabaseBundleId()));
            data.set("relationalDatabaseName", om.valueToTree(this.getRelationalDatabaseName()));
            if (this.getAvailabilityZone() != null) {
                data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            }
            if (this.getBackupRetention() != null) {
                data.set("backupRetention", om.valueToTree(this.getBackupRetention()));
            }
            if (this.getCaCertificateIdentifier() != null) {
                data.set("caCertificateIdentifier", om.valueToTree(this.getCaCertificateIdentifier()));
            }
            if (this.getMasterUserPassword() != null) {
                data.set("masterUserPassword", om.valueToTree(this.getMasterUserPassword()));
            }
            if (this.getPreferredBackupWindow() != null) {
                data.set("preferredBackupWindow", om.valueToTree(this.getPreferredBackupWindow()));
            }
            if (this.getPreferredMaintenanceWindow() != null) {
                data.set("preferredMaintenanceWindow", om.valueToTree(this.getPreferredMaintenanceWindow()));
            }
            if (this.getPubliclyAccessible() != null) {
                data.set("publiclyAccessible", om.valueToTree(this.getPubliclyAccessible()));
            }
            if (this.getRelationalDatabaseParameters() != null) {
                data.set("relationalDatabaseParameters", om.valueToTree(this.getRelationalDatabaseParameters()));
            }
            if (this.getRotateMasterUserPassword() != null) {
                data.set("rotateMasterUserPassword", om.valueToTree(this.getRotateMasterUserPassword()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lightsail.CfnDatabaseProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDatabaseProps.Jsii$Proxy that = (CfnDatabaseProps.Jsii$Proxy) o;

            if (!masterDatabaseName.equals(that.masterDatabaseName)) return false;
            if (!masterUsername.equals(that.masterUsername)) return false;
            if (!relationalDatabaseBlueprintId.equals(that.relationalDatabaseBlueprintId)) return false;
            if (!relationalDatabaseBundleId.equals(that.relationalDatabaseBundleId)) return false;
            if (!relationalDatabaseName.equals(that.relationalDatabaseName)) return false;
            if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
            if (this.backupRetention != null ? !this.backupRetention.equals(that.backupRetention) : that.backupRetention != null) return false;
            if (this.caCertificateIdentifier != null ? !this.caCertificateIdentifier.equals(that.caCertificateIdentifier) : that.caCertificateIdentifier != null) return false;
            if (this.masterUserPassword != null ? !this.masterUserPassword.equals(that.masterUserPassword) : that.masterUserPassword != null) return false;
            if (this.preferredBackupWindow != null ? !this.preferredBackupWindow.equals(that.preferredBackupWindow) : that.preferredBackupWindow != null) return false;
            if (this.preferredMaintenanceWindow != null ? !this.preferredMaintenanceWindow.equals(that.preferredMaintenanceWindow) : that.preferredMaintenanceWindow != null) return false;
            if (this.publiclyAccessible != null ? !this.publiclyAccessible.equals(that.publiclyAccessible) : that.publiclyAccessible != null) return false;
            if (this.relationalDatabaseParameters != null ? !this.relationalDatabaseParameters.equals(that.relationalDatabaseParameters) : that.relationalDatabaseParameters != null) return false;
            if (this.rotateMasterUserPassword != null ? !this.rotateMasterUserPassword.equals(that.rotateMasterUserPassword) : that.rotateMasterUserPassword != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.masterDatabaseName.hashCode();
            result = 31 * result + (this.masterUsername.hashCode());
            result = 31 * result + (this.relationalDatabaseBlueprintId.hashCode());
            result = 31 * result + (this.relationalDatabaseBundleId.hashCode());
            result = 31 * result + (this.relationalDatabaseName.hashCode());
            result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
            result = 31 * result + (this.backupRetention != null ? this.backupRetention.hashCode() : 0);
            result = 31 * result + (this.caCertificateIdentifier != null ? this.caCertificateIdentifier.hashCode() : 0);
            result = 31 * result + (this.masterUserPassword != null ? this.masterUserPassword.hashCode() : 0);
            result = 31 * result + (this.preferredBackupWindow != null ? this.preferredBackupWindow.hashCode() : 0);
            result = 31 * result + (this.preferredMaintenanceWindow != null ? this.preferredMaintenanceWindow.hashCode() : 0);
            result = 31 * result + (this.publiclyAccessible != null ? this.publiclyAccessible.hashCode() : 0);
            result = 31 * result + (this.relationalDatabaseParameters != null ? this.relationalDatabaseParameters.hashCode() : 0);
            result = 31 * result + (this.rotateMasterUserPassword != null ? this.rotateMasterUserPassword.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
