package software.amazon.awscdk.services.opensearchservice;

/**
 * Provides an Amazon OpenSearch Service domain.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Domain domain = Domain.Builder.create(this, "Domain")
 *         .version(EngineVersion.OPENSEARCH_1_0)
 *         .ebs(EbsOptions.builder()
 *                 .volumeSize(100)
 *                 .volumeType(EbsDeviceVolumeType.GENERAL_PURPOSE_SSD)
 *                 .build())
 *         .nodeToNodeEncryption(true)
 *         .encryptionAtRest(EncryptionAtRestOptions.builder()
 *                 .enabled(true)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:11.568Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.Domain")
public class Domain extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.opensearchservice.IDomain, software.amazon.awscdk.services.ec2.IConnectable {

    protected Domain(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Domain(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Domain(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.opensearchservice.DomainProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a domain construct that represents an external domain.
     * <p>
     * @param scope The parent creating construct (usually <code>this</code>). This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param attrs A <code>DomainAttributes</code> object. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.opensearchservice.IDomain fromDomainAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.opensearchservice.DomainAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.opensearchservice.Domain.class, "fromDomainAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.IDomain.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Creates a domain construct that represents an external domain via domain endpoint.
     * <p>
     * @param scope The parent creating construct (usually <code>this</code>). This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param domainEndpoint The domain's endpoint. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.opensearchservice.IDomain fromDomainEndpoint(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String domainEndpoint) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.opensearchservice.Domain.class, "fromDomainEndpoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.IDomain.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(domainEndpoint, "domainEndpoint is required") });
    }

    /**
     * Add policy statements to the domain access policy.
     * <p>
     * @param accessPolicyStatements This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addAccessPolicies(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement... accessPolicyStatements) {
        software.amazon.jsii.Kernel.call(this, "addAccessPolicies", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(accessPolicyStatements).toArray(Object[]::new));
    }

    /**
     * Grant read permissions for an index in this domain to an IAM principal (Role/Group/User).
     * <p>
     * @param index The index to grant permissions for. This parameter is required.
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantIndexRead(final @org.jetbrains.annotations.NotNull java.lang.String index, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
        return software.amazon.jsii.Kernel.call(this, "grantIndexRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(index, "index is required"), java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Grant read/write permissions for an index in this domain to an IAM principal (Role/Group/User).
     * <p>
     * @param index The index to grant permissions for. This parameter is required.
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantIndexReadWrite(final @org.jetbrains.annotations.NotNull java.lang.String index, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
        return software.amazon.jsii.Kernel.call(this, "grantIndexReadWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(index, "index is required"), java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Grant write permissions for an index in this domain to an IAM principal (Role/Group/User).
     * <p>
     * @param index The index to grant permissions for. This parameter is required.
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantIndexWrite(final @org.jetbrains.annotations.NotNull java.lang.String index, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
        return software.amazon.jsii.Kernel.call(this, "grantIndexWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(index, "index is required"), java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Grant read permissions for a specific path in this domain to an IAM principal (Role/Group/User).
     * <p>
     * @param path The path to grant permissions for. This parameter is required.
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPathRead(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
        return software.amazon.jsii.Kernel.call(this, "grantPathRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required"), java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Grant read/write permissions for a specific path in this domain to an IAM principal (Role/Group/User).
     * <p>
     * @param path The path to grant permissions for. This parameter is required.
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPathReadWrite(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
        return software.amazon.jsii.Kernel.call(this, "grantPathReadWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required"), java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Grant write permissions for a specific path in this domain to an IAM principal (Role/Group/User).
     * <p>
     * @param path The path to grant permissions for. This parameter is required.
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPathWrite(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
        return software.amazon.jsii.Kernel.call(this, "grantPathWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required"), java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Grant read permissions for this domain and its contents to an IAM principal (Role/Group/User).
     * <p>
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
        return software.amazon.jsii.Kernel.call(this, "grantRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Grant read/write permissions for this domain and its contents to an IAM principal (Role/Group/User).
     * <p>
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
        return software.amazon.jsii.Kernel.call(this, "grantReadWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Grant write permissions for this domain and its contents to an IAM principal (Role/Group/User).
     * <p>
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
        return software.amazon.jsii.Kernel.call(this, "grantWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Return the given named metric for this domain.
     * <p>
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * Return the given named metric for this domain.
     * <p>
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * Metric for automated snapshot failures.
     * <p>
     * Default: maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricAutomatedSnapshotFailure(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricAutomatedSnapshotFailure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for automated snapshot failures.
     * <p>
     * Default: maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricAutomatedSnapshotFailure() {
        return software.amazon.jsii.Kernel.call(this, "metricAutomatedSnapshotFailure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the cluster blocking index writes.
     * <p>
     * Default: maximum over 1 minute
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricClusterIndexWritesBlocked(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricClusterIndexWritesBlocked", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the cluster blocking index writes.
     * <p>
     * Default: maximum over 1 minute
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricClusterIndexWritesBlocked() {
        return software.amazon.jsii.Kernel.call(this, "metricClusterIndexWritesBlocked", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the time the cluster status is red.
     * <p>
     * Default: maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricClusterStatusRed(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricClusterStatusRed", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the time the cluster status is red.
     * <p>
     * Default: maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricClusterStatusRed() {
        return software.amazon.jsii.Kernel.call(this, "metricClusterStatusRed", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the time the cluster status is yellow.
     * <p>
     * Default: maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricClusterStatusYellow(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricClusterStatusYellow", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the time the cluster status is yellow.
     * <p>
     * Default: maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricClusterStatusYellow() {
        return software.amazon.jsii.Kernel.call(this, "metricClusterStatusYellow", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for CPU utilization.
     * <p>
     * Default: maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCPUUtilization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricCPUUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for CPU utilization.
     * <p>
     * Default: maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCPUUtilization() {
        return software.amazon.jsii.Kernel.call(this, "metricCPUUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the storage space of nodes in the cluster.
     * <p>
     * Default: minimum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFreeStorageSpace(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricFreeStorageSpace", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the storage space of nodes in the cluster.
     * <p>
     * Default: minimum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFreeStorageSpace() {
        return software.amazon.jsii.Kernel.call(this, "metricFreeStorageSpace", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for indexing latency.
     * <p>
     * Default: p99 over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIndexingLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricIndexingLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for indexing latency.
     * <p>
     * Default: p99 over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIndexingLatency() {
        return software.amazon.jsii.Kernel.call(this, "metricIndexingLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for JVM memory pressure.
     * <p>
     * Default: maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricJVMMemoryPressure(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricJVMMemoryPressure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for JVM memory pressure.
     * <p>
     * Default: maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricJVMMemoryPressure() {
        return software.amazon.jsii.Kernel.call(this, "metricJVMMemoryPressure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for KMS key errors.
     * <p>
     * Default: maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricKMSKeyError(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricKMSKeyError", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for KMS key errors.
     * <p>
     * Default: maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricKMSKeyError() {
        return software.amazon.jsii.Kernel.call(this, "metricKMSKeyError", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for KMS key being inaccessible.
     * <p>
     * Default: maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricKMSKeyInaccessible(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricKMSKeyInaccessible", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for KMS key being inaccessible.
     * <p>
     * Default: maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricKMSKeyInaccessible() {
        return software.amazon.jsii.Kernel.call(this, "metricKMSKeyInaccessible", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for master CPU utilization.
     * <p>
     * Default: maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricMasterCPUUtilization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricMasterCPUUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for master CPU utilization.
     * <p>
     * Default: maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricMasterCPUUtilization() {
        return software.amazon.jsii.Kernel.call(this, "metricMasterCPUUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for master JVM memory pressure.
     * <p>
     * Default: maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricMasterJVMMemoryPressure(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricMasterJVMMemoryPressure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for master JVM memory pressure.
     * <p>
     * Default: maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricMasterJVMMemoryPressure() {
        return software.amazon.jsii.Kernel.call(this, "metricMasterJVMMemoryPressure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the number of nodes.
     * <p>
     * Default: minimum over 1 hour
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNodes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricNodes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the number of nodes.
     * <p>
     * Default: minimum over 1 hour
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNodes() {
        return software.amazon.jsii.Kernel.call(this, "metricNodes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for number of searchable documents.
     * <p>
     * Default: maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSearchableDocuments(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricSearchableDocuments", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for number of searchable documents.
     * <p>
     * Default: maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSearchableDocuments() {
        return software.amazon.jsii.Kernel.call(this, "metricSearchableDocuments", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for search latency.
     * <p>
     * Default: p99 over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSearchLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricSearchLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for search latency.
     * <p>
     * Default: p99 over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSearchLatency() {
        return software.amazon.jsii.Kernel.call(this, "metricSearchLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Manages network connections to the domain.
     * <p>
     * This will throw an error in case the domain
     * is not placed inside a VPC.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * Arn of the Amazon OpenSearch Service domain.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDomainArn() {
        return software.amazon.jsii.Kernel.get(this, "domainArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Endpoint of the Amazon OpenSearch Service domain.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDomainEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "domainEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Identifier of the Amazon OpenSearch Service domain.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDomainId() {
        return software.amazon.jsii.Kernel.get(this, "domainId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Domain name of the Amazon OpenSearch Service domain.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDomainName() {
        return software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Log group that application logs are logged to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup getAppLogGroup() {
        return software.amazon.jsii.Kernel.get(this, "appLogGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
    }

    /**
     * Log group that audit logs are logged to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup getAuditLogGroup() {
        return software.amazon.jsii.Kernel.get(this, "auditLogGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
    }

    /**
     * Master user password if fine grained access control is configured.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.SecretValue getMasterUserPassword() {
        return software.amazon.jsii.Kernel.get(this, "masterUserPassword", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class));
    }

    /**
     * Log group that slow indices are logged to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup getSlowIndexLogGroup() {
        return software.amazon.jsii.Kernel.get(this, "slowIndexLogGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
    }

    /**
     * Log group that slow searches are logged to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup getSlowSearchLogGroup() {
        return software.amazon.jsii.Kernel.get(this, "slowSearchLogGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.opensearchservice.Domain}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.opensearchservice.Domain> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.opensearchservice.DomainProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.opensearchservice.DomainProps.Builder();
        }

        /**
         * The Elasticsearch/OpenSearch version that your domain will leverage.
         * <p>
         * @return {@code this}
         * @param version The Elasticsearch/OpenSearch version that your domain will leverage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(final software.amazon.awscdk.services.opensearchservice.EngineVersion version) {
            this.props.version(version);
            return this;
        }

        /**
         * Domain access policies.
         * <p>
         * Default: - No access policies.
         * <p>
         * @return {@code this}
         * @param accessPolicies Domain access policies. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessPolicies(final java.util.List<? extends software.amazon.awscdk.services.iam.PolicyStatement> accessPolicies) {
            this.props.accessPolicies(accessPolicies);
            return this;
        }

        /**
         * Additional options to specify for the Amazon OpenSearch Service domain.
         * <p>
         * Default: - no advanced options are specified
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options">https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options</a>
         * @param advancedOptions Additional options to specify for the Amazon OpenSearch Service domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedOptions(final java.util.Map<java.lang.String, java.lang.String> advancedOptions) {
            this.props.advancedOptions(advancedOptions);
            return this;
        }

        /**
         * The hour in UTC during which the service takes an automated daily snapshot of the indices in the Amazon OpenSearch Service domain.
         * <p>
         * Only applies for Elasticsearch versions
         * below 5.3.
         * <p>
         * Default: - Hourly automated snapshots not used
         * <p>
         * @return {@code this}
         * @param automatedSnapshotStartHour The hour in UTC during which the service takes an automated daily snapshot of the indices in the Amazon OpenSearch Service domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automatedSnapshotStartHour(final java.lang.Number automatedSnapshotStartHour) {
            this.props.automatedSnapshotStartHour(automatedSnapshotStartHour);
            return this;
        }

        /**
         * The cluster capacity configuration for the Amazon OpenSearch Service domain.
         * <p>
         * Default: - 1 r5.large.search data node; no dedicated master nodes.
         * <p>
         * @return {@code this}
         * @param capacity The cluster capacity configuration for the Amazon OpenSearch Service domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacity(final software.amazon.awscdk.services.opensearchservice.CapacityConfig capacity) {
            this.props.capacity(capacity);
            return this;
        }

        /**
         * Configures Amazon OpenSearch Service to use Amazon Cognito authentication for OpenSearch Dashboards.
         * <p>
         * Default: - Cognito not used for authentication to OpenSearch Dashboards.
         * <p>
         * @return {@code this}
         * @param cognitoDashboardsAuth Configures Amazon OpenSearch Service to use Amazon Cognito authentication for OpenSearch Dashboards. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoDashboardsAuth(final software.amazon.awscdk.services.opensearchservice.CognitoOptions cognitoDashboardsAuth) {
            this.props.cognitoDashboardsAuth(cognitoDashboardsAuth);
            return this;
        }

        /**
         * Whether to enable or disable cold storage on the domain.
         * <p>
         * You must enable UltraWarm storage to enable cold storage.
         * <p>
         * Default: - undefined
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cold-storage.html">https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cold-storage.html</a>
         * @param coldStorageEnabled Whether to enable or disable cold storage on the domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder coldStorageEnabled(final java.lang.Boolean coldStorageEnabled) {
            this.props.coldStorageEnabled(coldStorageEnabled);
            return this;
        }

        /**
         * To configure a custom domain configure these options.
         * <p>
         * If you specify a Route53 hosted zone it will create a CNAME record and use DNS validation for the certificate
         * <p>
         * Default: - no custom domain endpoint will be configured
         * <p>
         * @return {@code this}
         * @param customEndpoint To configure a custom domain configure these options. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customEndpoint(final software.amazon.awscdk.services.opensearchservice.CustomEndpointOptions customEndpoint) {
            this.props.customEndpoint(customEndpoint);
            return this;
        }

        /**
         * Enforces a particular physical domain name.
         * <p>
         * Default: - A name will be auto-generated.
         * <p>
         * @return {@code this}
         * @param domainName Enforces a particular physical domain name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final java.lang.String domainName) {
            this.props.domainName(domainName);
            return this;
        }

        /**
         * The configurations of Amazon Elastic Block Store (Amazon EBS) volumes that are attached to data nodes in the Amazon OpenSearch Service domain.
         * <p>
         * Default: - 10 GiB General Purpose (SSD) volumes per node.
         * <p>
         * @return {@code this}
         * @param ebs The configurations of Amazon Elastic Block Store (Amazon EBS) volumes that are attached to data nodes in the Amazon OpenSearch Service domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebs(final software.amazon.awscdk.services.opensearchservice.EbsOptions ebs) {
            this.props.ebs(ebs);
            return this;
        }

        /**
         * Specifies whether automatic service software updates are enabled for the domain.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/it_it/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-softwareupdateoptions.html">https://docs.aws.amazon.com/it_it/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-softwareupdateoptions.html</a>
         * @param enableAutoSoftwareUpdate Specifies whether automatic service software updates are enabled for the domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableAutoSoftwareUpdate(final java.lang.Boolean enableAutoSoftwareUpdate) {
            this.props.enableAutoSoftwareUpdate(enableAutoSoftwareUpdate);
            return this;
        }

        /**
         * To upgrade an Amazon OpenSearch Service domain to a new version, rather than replacing the entire domain resource, use the EnableVersionUpgrade update policy.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html#cfn-attributes-updatepolicy-upgradeopensearchdomain">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html#cfn-attributes-updatepolicy-upgradeopensearchdomain</a>
         * @param enableVersionUpgrade To upgrade an Amazon OpenSearch Service domain to a new version, rather than replacing the entire domain resource, use the EnableVersionUpgrade update policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableVersionUpgrade(final java.lang.Boolean enableVersionUpgrade) {
            this.props.enableVersionUpgrade(enableVersionUpgrade);
            return this;
        }

        /**
         * Encryption at rest options for the cluster.
         * <p>
         * Default: - No encryption at rest
         * <p>
         * @return {@code this}
         * @param encryptionAtRest Encryption at rest options for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionAtRest(final software.amazon.awscdk.services.opensearchservice.EncryptionAtRestOptions encryptionAtRest) {
            this.props.encryptionAtRest(encryptionAtRest);
            return this;
        }

        /**
         * True to require that all traffic to the domain arrive over HTTPS.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param enforceHttps True to require that all traffic to the domain arrive over HTTPS. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enforceHttps(final java.lang.Boolean enforceHttps) {
            this.props.enforceHttps(enforceHttps);
            return this;
        }

        /**
         * Specifies options for fine-grained access control.
         * <p>
         * Requires Elasticsearch version 6.7 or later or OpenSearch version 1.0 or later. Enabling fine-grained access control
         * also requires encryption of data at rest and node-to-node encryption, along with
         * enforced HTTPS.
         * <p>
         * Default: - fine-grained access control is disabled
         * <p>
         * @return {@code this}
         * @param fineGrainedAccessControl Specifies options for fine-grained access control. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fineGrainedAccessControl(final software.amazon.awscdk.services.opensearchservice.AdvancedSecurityOptions fineGrainedAccessControl) {
            this.props.fineGrainedAccessControl(fineGrainedAccessControl);
            return this;
        }

        /**
         * Specify either dual stack or IPv4 as your IP address type.
         * <p>
         * Dual stack allows you to share domain resources across IPv4 and IPv6 address types, and is the recommended option.
         * <p>
         * If you set your IP address type to dual stack, you can't change your address type later.
         * <p>
         * Default: - IpAddressType.IPV4
         * <p>
         * @return {@code this}
         * @param ipAddressType Specify either dual stack or IPv4 as your IP address type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddressType(final software.amazon.awscdk.services.opensearchservice.IpAddressType ipAddressType) {
            this.props.ipAddressType(ipAddressType);
            return this;
        }

        /**
         * Configuration log publishing configuration options.
         * <p>
         * Default: - No logs are published
         * <p>
         * @return {@code this}
         * @param logging Configuration log publishing configuration options. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logging(final software.amazon.awscdk.services.opensearchservice.LoggingOptions logging) {
            this.props.logging(logging);
            return this;
        }

        /**
         * Specify true to enable node to node encryption.
         * <p>
         * Requires Elasticsearch version 6.0 or later or OpenSearch version 1.0 or later.
         * <p>
         * Default: - Node to node encryption is not enabled.
         * <p>
         * @return {@code this}
         * @param nodeToNodeEncryption Specify true to enable node to node encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeToNodeEncryption(final java.lang.Boolean nodeToNodeEncryption) {
            this.props.nodeToNodeEncryption(nodeToNodeEncryption);
            return this;
        }

        /**
         * Options for enabling a domain's off-peak window, during which OpenSearch Service can perform mandatory configuration changes on the domain.
         * <p>
         * Off-peak windows were introduced on February 16, 2023.
         * All domains created before this date have the off-peak window disabled by default.
         * You must manually enable and configure the off-peak window for these domains.
         * All domains created after this date will have the off-peak window enabled by default.
         * You can't disable the off-peak window for a domain after it's enabled.
         * <p>
         * Default: - Disabled for domains created before February 16, 2023. Enabled for domains created after. Enabled if `offPeakWindowStart` is set.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/it_it/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-offpeakwindow.html">https://docs.aws.amazon.com/it_it/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-offpeakwindow.html</a>
         * @param offPeakWindowEnabled Options for enabling a domain's off-peak window, during which OpenSearch Service can perform mandatory configuration changes on the domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder offPeakWindowEnabled(final java.lang.Boolean offPeakWindowEnabled) {
            this.props.offPeakWindowEnabled(offPeakWindowEnabled);
            return this;
        }

        /**
         * Start time for the off-peak window, in Coordinated Universal Time (UTC).
         * <p>
         * The window length will always be 10 hours, so you can't specify an end time.
         * For example, if you specify 11:00 P.M. UTC as a start time, the end time will automatically be set to 9:00 A.M.
         * <p>
         * Default: - 10:00 P.M. local time
         * <p>
         * @return {@code this}
         * @param offPeakWindowStart Start time for the off-peak window, in Coordinated Universal Time (UTC). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder offPeakWindowStart(final software.amazon.awscdk.services.opensearchservice.WindowStartTime offPeakWindowStart) {
            this.props.offPeakWindowStart(offPeakWindowStart);
            return this;
        }

        /**
         * Policy to apply when the domain is removed from the stack.
         * <p>
         * Default: RemovalPolicy.RETAIN
         * <p>
         * @return {@code this}
         * @param removalPolicy Policy to apply when the domain is removed from the stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * The list of security groups that are associated with the VPC endpoints for the domain.
         * <p>
         * Only used if <code>vpc</code> is specified.
         * <p>
         * Default: - One new security group is created.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html">https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html</a>
         * @param securityGroups The list of security groups that are associated with the VPC endpoints for the domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * Specify whether to create a CloudWatch Logs resource policy or not.
         * <p>
         * When logging is enabled for the domain, a CloudWatch Logs resource policy is created by default.
         * However, CloudWatch Logs supports only 10 resource policies per region.
         * If you enable logging for several domains, it may hit the quota and cause an error.
         * By setting this property to true, creating a resource policy is suppressed, allowing you to avoid this problem.
         * <p>
         * If you set this option to true, you must create a resource policy before deployment.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createdomain-configure-slow-logs.html">https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createdomain-configure-slow-logs.html</a>
         * @param suppressLogsResourcePolicy Specify whether to create a CloudWatch Logs resource policy or not. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder suppressLogsResourcePolicy(final java.lang.Boolean suppressLogsResourcePolicy) {
            this.props.suppressLogsResourcePolicy(suppressLogsResourcePolicy);
            return this;
        }

        /**
         * The minimum TLS version required for traffic to the domain.
         * <p>
         * Default: - TLSSecurityPolicy.TLS_1_0
         * <p>
         * @return {@code this}
         * @param tlsSecurityPolicy The minimum TLS version required for traffic to the domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tlsSecurityPolicy(final software.amazon.awscdk.services.opensearchservice.TLSSecurityPolicy tlsSecurityPolicy) {
            this.props.tlsSecurityPolicy(tlsSecurityPolicy);
            return this;
        }

        /**
         * Configures the domain so that unsigned basic auth is enabled.
         * <p>
         * If no master user is provided a default master user
         * with username <code>admin</code> and a dynamically generated password stored in KMS is created. The password can be retrieved
         * by getting <code>masterUserPassword</code> from the domain instance.
         * <p>
         * Setting this to true will also add an access policy that allows unsigned
         * access, enable node to node encryption, encryption at rest. If conflicting
         * settings are encountered (like disabling encryption at rest) enabling this
         * setting will cause a failure.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param useUnsignedBasicAuth Configures the domain so that unsigned basic auth is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useUnsignedBasicAuth(final java.lang.Boolean useUnsignedBasicAuth) {
            this.props.useUnsignedBasicAuth(useUnsignedBasicAuth);
            return this;
        }

        /**
         * Place the domain inside this VPC.
         * <p>
         * Default: - Domain is not placed in a VPC.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html">https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html</a>
         * @param vpc Place the domain inside this VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * The specific vpc subnets the domain will be placed in.
         * <p>
         * You must provide one subnet for each Availability Zone
         * that your domain uses. For example, you must specify three subnet IDs for a three Availability Zone
         * domain.
         * <p>
         * Only used if <code>vpc</code> is specified.
         * <p>
         * Default: - All private subnets.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html</a>
         * @param vpcSubnets The specific vpc subnets the domain will be placed in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final java.util.List<? extends software.amazon.awscdk.services.ec2.SubnetSelection> vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * The cluster zone awareness configuration for the Amazon OpenSearch Service domain.
         * <p>
         * Default: - no zone awareness (1 AZ)
         * <p>
         * @return {@code this}
         * @param zoneAwareness The cluster zone awareness configuration for the Amazon OpenSearch Service domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zoneAwareness(final software.amazon.awscdk.services.opensearchservice.ZoneAwarenessConfig zoneAwareness) {
            this.props.zoneAwareness(zoneAwareness);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.opensearchservice.Domain}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.opensearchservice.Domain build() {
            return new software.amazon.awscdk.services.opensearchservice.Domain(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
