package software.amazon.awscdk.services.pcaconnectorad;

/**
 * Creates an Active Directory compatible certificate template.
 * <p>
 * The connectors issues certificates using these templates based on the requester’s Active Directory group membership.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.pcaconnectorad.*;
 * CfnTemplate cfnTemplate = CfnTemplate.Builder.create(this, "MyCfnTemplate")
 *         .connectorArn("connectorArn")
 *         .definition(TemplateDefinitionProperty.builder()
 *                 .templateV2(TemplateV2Property.builder()
 *                         .certificateValidity(CertificateValidityProperty.builder()
 *                                 .renewalPeriod(ValidityPeriodProperty.builder()
 *                                         .period(123)
 *                                         .periodType("periodType")
 *                                         .build())
 *                                 .validityPeriod(ValidityPeriodProperty.builder()
 *                                         .period(123)
 *                                         .periodType("periodType")
 *                                         .build())
 *                                 .build())
 *                         .enrollmentFlags(EnrollmentFlagsV2Property.builder()
 *                                 .enableKeyReuseOnNtTokenKeysetStorageFull(false)
 *                                 .includeSymmetricAlgorithms(false)
 *                                 .noSecurityExtension(false)
 *                                 .removeInvalidCertificateFromPersonalStore(false)
 *                                 .userInteractionRequired(false)
 *                                 .build())
 *                         .extensions(ExtensionsV2Property.builder()
 *                                 .keyUsage(KeyUsageProperty.builder()
 *                                         .usageFlags(KeyUsageFlagsProperty.builder()
 *                                                 .dataEncipherment(false)
 *                                                 .digitalSignature(false)
 *                                                 .keyAgreement(false)
 *                                                 .keyEncipherment(false)
 *                                                 .nonRepudiation(false)
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .critical(false)
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .applicationPolicies(ApplicationPoliciesProperty.builder()
 *                                         .policies(List.of(ApplicationPolicyProperty.builder()
 *                                                 .policyObjectIdentifier("policyObjectIdentifier")
 *                                                 .policyType("policyType")
 *                                                 .build()))
 *                                         // the properties below are optional
 *                                         .critical(false)
 *                                         .build())
 *                                 .build())
 *                         .generalFlags(GeneralFlagsV2Property.builder()
 *                                 .autoEnrollment(false)
 *                                 .machineType(false)
 *                                 .build())
 *                         .privateKeyAttributes(PrivateKeyAttributesV2Property.builder()
 *                                 .keySpec("keySpec")
 *                                 .minimalKeyLength(123)
 *                                 // the properties below are optional
 *                                 .cryptoProviders(List.of("cryptoProviders"))
 *                                 .build())
 *                         .privateKeyFlags(PrivateKeyFlagsV2Property.builder()
 *                                 .clientVersion("clientVersion")
 *                                 // the properties below are optional
 *                                 .exportableKey(false)
 *                                 .strongKeyProtectionRequired(false)
 *                                 .build())
 *                         .subjectNameFlags(SubjectNameFlagsV2Property.builder()
 *                                 .requireCommonName(false)
 *                                 .requireDirectoryPath(false)
 *                                 .requireDnsAsCn(false)
 *                                 .requireEmail(false)
 *                                 .sanRequireDirectoryGuid(false)
 *                                 .sanRequireDns(false)
 *                                 .sanRequireDomainDns(false)
 *                                 .sanRequireEmail(false)
 *                                 .sanRequireSpn(false)
 *                                 .sanRequireUpn(false)
 *                                 .build())
 *                         // the properties below are optional
 *                         .supersededTemplates(List.of("supersededTemplates"))
 *                         .build())
 *                 .templateV3(TemplateV3Property.builder()
 *                         .certificateValidity(CertificateValidityProperty.builder()
 *                                 .renewalPeriod(ValidityPeriodProperty.builder()
 *                                         .period(123)
 *                                         .periodType("periodType")
 *                                         .build())
 *                                 .validityPeriod(ValidityPeriodProperty.builder()
 *                                         .period(123)
 *                                         .periodType("periodType")
 *                                         .build())
 *                                 .build())
 *                         .enrollmentFlags(EnrollmentFlagsV3Property.builder()
 *                                 .enableKeyReuseOnNtTokenKeysetStorageFull(false)
 *                                 .includeSymmetricAlgorithms(false)
 *                                 .noSecurityExtension(false)
 *                                 .removeInvalidCertificateFromPersonalStore(false)
 *                                 .userInteractionRequired(false)
 *                                 .build())
 *                         .extensions(ExtensionsV3Property.builder()
 *                                 .keyUsage(KeyUsageProperty.builder()
 *                                         .usageFlags(KeyUsageFlagsProperty.builder()
 *                                                 .dataEncipherment(false)
 *                                                 .digitalSignature(false)
 *                                                 .keyAgreement(false)
 *                                                 .keyEncipherment(false)
 *                                                 .nonRepudiation(false)
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .critical(false)
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .applicationPolicies(ApplicationPoliciesProperty.builder()
 *                                         .policies(List.of(ApplicationPolicyProperty.builder()
 *                                                 .policyObjectIdentifier("policyObjectIdentifier")
 *                                                 .policyType("policyType")
 *                                                 .build()))
 *                                         // the properties below are optional
 *                                         .critical(false)
 *                                         .build())
 *                                 .build())
 *                         .generalFlags(GeneralFlagsV3Property.builder()
 *                                 .autoEnrollment(false)
 *                                 .machineType(false)
 *                                 .build())
 *                         .hashAlgorithm("hashAlgorithm")
 *                         .privateKeyAttributes(PrivateKeyAttributesV3Property.builder()
 *                                 .algorithm("algorithm")
 *                                 .keySpec("keySpec")
 *                                 .keyUsageProperty(KeyUsagePropertyProperty.builder()
 *                                         .propertyFlags(KeyUsagePropertyFlagsProperty.builder()
 *                                                 .decrypt(false)
 *                                                 .keyAgreement(false)
 *                                                 .sign(false)
 *                                                 .build())
 *                                         .propertyType("propertyType")
 *                                         .build())
 *                                 .minimalKeyLength(123)
 *                                 // the properties below are optional
 *                                 .cryptoProviders(List.of("cryptoProviders"))
 *                                 .build())
 *                         .privateKeyFlags(PrivateKeyFlagsV3Property.builder()
 *                                 .clientVersion("clientVersion")
 *                                 // the properties below are optional
 *                                 .exportableKey(false)
 *                                 .requireAlternateSignatureAlgorithm(false)
 *                                 .strongKeyProtectionRequired(false)
 *                                 .build())
 *                         .subjectNameFlags(SubjectNameFlagsV3Property.builder()
 *                                 .requireCommonName(false)
 *                                 .requireDirectoryPath(false)
 *                                 .requireDnsAsCn(false)
 *                                 .requireEmail(false)
 *                                 .sanRequireDirectoryGuid(false)
 *                                 .sanRequireDns(false)
 *                                 .sanRequireDomainDns(false)
 *                                 .sanRequireEmail(false)
 *                                 .sanRequireSpn(false)
 *                                 .sanRequireUpn(false)
 *                                 .build())
 *                         // the properties below are optional
 *                         .supersededTemplates(List.of("supersededTemplates"))
 *                         .build())
 *                 .templateV4(TemplateV4Property.builder()
 *                         .certificateValidity(CertificateValidityProperty.builder()
 *                                 .renewalPeriod(ValidityPeriodProperty.builder()
 *                                         .period(123)
 *                                         .periodType("periodType")
 *                                         .build())
 *                                 .validityPeriod(ValidityPeriodProperty.builder()
 *                                         .period(123)
 *                                         .periodType("periodType")
 *                                         .build())
 *                                 .build())
 *                         .enrollmentFlags(EnrollmentFlagsV4Property.builder()
 *                                 .enableKeyReuseOnNtTokenKeysetStorageFull(false)
 *                                 .includeSymmetricAlgorithms(false)
 *                                 .noSecurityExtension(false)
 *                                 .removeInvalidCertificateFromPersonalStore(false)
 *                                 .userInteractionRequired(false)
 *                                 .build())
 *                         .extensions(ExtensionsV4Property.builder()
 *                                 .keyUsage(KeyUsageProperty.builder()
 *                                         .usageFlags(KeyUsageFlagsProperty.builder()
 *                                                 .dataEncipherment(false)
 *                                                 .digitalSignature(false)
 *                                                 .keyAgreement(false)
 *                                                 .keyEncipherment(false)
 *                                                 .nonRepudiation(false)
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .critical(false)
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .applicationPolicies(ApplicationPoliciesProperty.builder()
 *                                         .policies(List.of(ApplicationPolicyProperty.builder()
 *                                                 .policyObjectIdentifier("policyObjectIdentifier")
 *                                                 .policyType("policyType")
 *                                                 .build()))
 *                                         // the properties below are optional
 *                                         .critical(false)
 *                                         .build())
 *                                 .build())
 *                         .generalFlags(GeneralFlagsV4Property.builder()
 *                                 .autoEnrollment(false)
 *                                 .machineType(false)
 *                                 .build())
 *                         .privateKeyAttributes(PrivateKeyAttributesV4Property.builder()
 *                                 .keySpec("keySpec")
 *                                 .minimalKeyLength(123)
 *                                 // the properties below are optional
 *                                 .algorithm("algorithm")
 *                                 .cryptoProviders(List.of("cryptoProviders"))
 *                                 .keyUsageProperty(KeyUsagePropertyProperty.builder()
 *                                         .propertyFlags(KeyUsagePropertyFlagsProperty.builder()
 *                                                 .decrypt(false)
 *                                                 .keyAgreement(false)
 *                                                 .sign(false)
 *                                                 .build())
 *                                         .propertyType("propertyType")
 *                                         .build())
 *                                 .build())
 *                         .privateKeyFlags(PrivateKeyFlagsV4Property.builder()
 *                                 .clientVersion("clientVersion")
 *                                 // the properties below are optional
 *                                 .exportableKey(false)
 *                                 .requireAlternateSignatureAlgorithm(false)
 *                                 .requireSameKeyRenewal(false)
 *                                 .strongKeyProtectionRequired(false)
 *                                 .useLegacyProvider(false)
 *                                 .build())
 *                         .subjectNameFlags(SubjectNameFlagsV4Property.builder()
 *                                 .requireCommonName(false)
 *                                 .requireDirectoryPath(false)
 *                                 .requireDnsAsCn(false)
 *                                 .requireEmail(false)
 *                                 .sanRequireDirectoryGuid(false)
 *                                 .sanRequireDns(false)
 *                                 .sanRequireDomainDns(false)
 *                                 .sanRequireEmail(false)
 *                                 .sanRequireSpn(false)
 *                                 .sanRequireUpn(false)
 *                                 .build())
 *                         // the properties below are optional
 *                         .hashAlgorithm("hashAlgorithm")
 *                         .supersededTemplates(List.of("supersededTemplates"))
 *                         .build())
 *                 .build())
 *         .name("name")
 *         // the properties below are optional
 *         .reenrollAllCertificateHolders(false)
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-template.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-template.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:11.687Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplate")
public class CfnTemplate extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnTemplate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTemplate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTemplate(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.pcaconnectorad.CfnTemplateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrTemplateArn() {
        return software.amazon.jsii.Kernel.get(this, "attrTemplateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html">CreateConnector</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getConnectorArn() {
        return software.amazon.jsii.Kernel.get(this, "connectorArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html">CreateConnector</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectorArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "connectorArn", java.util.Objects.requireNonNull(value, "connectorArn is required"));
    }

    /**
     * Template configuration to define the information included in certificates.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDefinition() {
        return software.amazon.jsii.Kernel.get(this, "definition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Template configuration to define the information included in certificates.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinition(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "definition", java.util.Objects.requireNonNull(value, "definition is required"));
    }

    /**
     * Template configuration to define the information included in certificates.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinition(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.TemplateDefinitionProperty value) {
        software.amazon.jsii.Kernel.set(this, "definition", java.util.Objects.requireNonNull(value, "definition is required"));
    }

    /**
     * Name of the templates.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Name of the templates.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * This setting allows the major version of a template to be increased automatically.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getReenrollAllCertificateHolders() {
        return software.amazon.jsii.Kernel.get(this, "reenrollAllCertificateHolders", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * This setting allows the major version of a template to be increased automatically.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReenrollAllCertificateHolders(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "reenrollAllCertificateHolders", value);
    }

    /**
     * This setting allows the major version of a template to be increased automatically.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReenrollAllCertificateHolders(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "reenrollAllCertificateHolders", value);
    }

    /**
     * Metadata assigned to a template consisting of a key-value pair.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * Metadata assigned to a template consisting of a key-value pair.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Application policies describe what the certificate can be used for.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pcaconnectorad.*;
     * ApplicationPoliciesProperty applicationPoliciesProperty = ApplicationPoliciesProperty.builder()
     *         .policies(List.of(ApplicationPolicyProperty.builder()
     *                 .policyObjectIdentifier("policyObjectIdentifier")
     *                 .policyType("policyType")
     *                 .build()))
     *         // the properties below are optional
     *         .critical(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-applicationpolicies.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-applicationpolicies.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.ApplicationPoliciesProperty")
    @software.amazon.jsii.Jsii.Proxy(ApplicationPoliciesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ApplicationPoliciesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Application policies describe what the certificate can be used for.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-applicationpolicies.html#cfn-pcaconnectorad-template-applicationpolicies-policies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-applicationpolicies.html#cfn-pcaconnectorad-template-applicationpolicies-policies</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPolicies();

        /**
         * Marks the application policy extension as critical.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-applicationpolicies.html#cfn-pcaconnectorad-template-applicationpolicies-critical">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-applicationpolicies.html#cfn-pcaconnectorad-template-applicationpolicies-critical</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCritical() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ApplicationPoliciesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApplicationPoliciesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ApplicationPoliciesProperty> {
            java.lang.Object policies;
            java.lang.Object critical;

            /**
             * Sets the value of {@link ApplicationPoliciesProperty#getPolicies}
             * @param policies Application policies describe what the certificate can be used for. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policies(software.amazon.awscdk.IResolvable policies) {
                this.policies = policies;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationPoliciesProperty#getPolicies}
             * @param policies Application policies describe what the certificate can be used for. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policies(java.util.List<? extends java.lang.Object> policies) {
                this.policies = policies;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationPoliciesProperty#getCritical}
             * @param critical Marks the application policy extension as critical.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder critical(java.lang.Boolean critical) {
                this.critical = critical;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationPoliciesProperty#getCritical}
             * @param critical Marks the application policy extension as critical.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder critical(software.amazon.awscdk.IResolvable critical) {
                this.critical = critical;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApplicationPoliciesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ApplicationPoliciesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ApplicationPoliciesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationPoliciesProperty {
            private final java.lang.Object policies;
            private final java.lang.Object critical;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.policies = software.amazon.jsii.Kernel.get(this, "policies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.critical = software.amazon.jsii.Kernel.get(this, "critical", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.policies = java.util.Objects.requireNonNull(builder.policies, "policies is required");
                this.critical = builder.critical;
            }

            @Override
            public final java.lang.Object getPolicies() {
                return this.policies;
            }

            @Override
            public final java.lang.Object getCritical() {
                return this.critical;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("policies", om.valueToTree(this.getPolicies()));
                if (this.getCritical() != null) {
                    data.set("critical", om.valueToTree(this.getCritical()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.ApplicationPoliciesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApplicationPoliciesProperty.Jsii$Proxy that = (ApplicationPoliciesProperty.Jsii$Proxy) o;

                if (!policies.equals(that.policies)) return false;
                return this.critical != null ? this.critical.equals(that.critical) : that.critical == null;
            }

            @Override
            public final int hashCode() {
                int result = this.policies.hashCode();
                result = 31 * result + (this.critical != null ? this.critical.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Application policies describe what the certificate can be used for.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pcaconnectorad.*;
     * ApplicationPolicyProperty applicationPolicyProperty = ApplicationPolicyProperty.builder()
     *         .policyObjectIdentifier("policyObjectIdentifier")
     *         .policyType("policyType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-applicationpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-applicationpolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.ApplicationPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(ApplicationPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ApplicationPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object identifier (OID) of an application policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-applicationpolicy.html#cfn-pcaconnectorad-template-applicationpolicy-policyobjectidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-applicationpolicy.html#cfn-pcaconnectorad-template-applicationpolicy-policyobjectidentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPolicyObjectIdentifier() {
            return null;
        }

        /**
         * The type of application policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-applicationpolicy.html#cfn-pcaconnectorad-template-applicationpolicy-policytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-applicationpolicy.html#cfn-pcaconnectorad-template-applicationpolicy-policytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPolicyType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ApplicationPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApplicationPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ApplicationPolicyProperty> {
            java.lang.String policyObjectIdentifier;
            java.lang.String policyType;

            /**
             * Sets the value of {@link ApplicationPolicyProperty#getPolicyObjectIdentifier}
             * @param policyObjectIdentifier The object identifier (OID) of an application policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policyObjectIdentifier(java.lang.String policyObjectIdentifier) {
                this.policyObjectIdentifier = policyObjectIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationPolicyProperty#getPolicyType}
             * @param policyType The type of application policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policyType(java.lang.String policyType) {
                this.policyType = policyType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApplicationPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ApplicationPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ApplicationPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationPolicyProperty {
            private final java.lang.String policyObjectIdentifier;
            private final java.lang.String policyType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.policyObjectIdentifier = software.amazon.jsii.Kernel.get(this, "policyObjectIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.policyType = software.amazon.jsii.Kernel.get(this, "policyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.policyObjectIdentifier = builder.policyObjectIdentifier;
                this.policyType = builder.policyType;
            }

            @Override
            public final java.lang.String getPolicyObjectIdentifier() {
                return this.policyObjectIdentifier;
            }

            @Override
            public final java.lang.String getPolicyType() {
                return this.policyType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPolicyObjectIdentifier() != null) {
                    data.set("policyObjectIdentifier", om.valueToTree(this.getPolicyObjectIdentifier()));
                }
                if (this.getPolicyType() != null) {
                    data.set("policyType", om.valueToTree(this.getPolicyType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.ApplicationPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApplicationPolicyProperty.Jsii$Proxy that = (ApplicationPolicyProperty.Jsii$Proxy) o;

                if (this.policyObjectIdentifier != null ? !this.policyObjectIdentifier.equals(that.policyObjectIdentifier) : that.policyObjectIdentifier != null) return false;
                return this.policyType != null ? this.policyType.equals(that.policyType) : that.policyType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.policyObjectIdentifier != null ? this.policyObjectIdentifier.hashCode() : 0;
                result = 31 * result + (this.policyType != null ? this.policyType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information describing the end of the validity period of the certificate.
     * <p>
     * This parameter sets the “Not After” date for the certificate. Certificate validity is the period of time during which a certificate is valid. Validity can be expressed as an explicit date and time when the certificate expires, or as a span of time after issuance, stated in days, months, or years. For more information, see Validity in RFC 5280. This value is unaffected when ValidityNotBefore is also specified. For example, if Validity is set to 20 days in the future, the certificate will expire 20 days from issuance time regardless of the ValidityNotBefore value.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pcaconnectorad.*;
     * CertificateValidityProperty certificateValidityProperty = CertificateValidityProperty.builder()
     *         .renewalPeriod(ValidityPeriodProperty.builder()
     *                 .period(123)
     *                 .periodType("periodType")
     *                 .build())
     *         .validityPeriod(ValidityPeriodProperty.builder()
     *                 .period(123)
     *                 .periodType("periodType")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-certificatevalidity.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-certificatevalidity.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.CertificateValidityProperty")
    @software.amazon.jsii.Jsii.Proxy(CertificateValidityProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CertificateValidityProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Renewal period is the period of time before certificate expiration when a new certificate will be requested.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-certificatevalidity.html#cfn-pcaconnectorad-template-certificatevalidity-renewalperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-certificatevalidity.html#cfn-pcaconnectorad-template-certificatevalidity-renewalperiod</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRenewalPeriod();

        /**
         * Information describing the end of the validity period of the certificate.
         * <p>
         * This parameter sets the “Not After” date for the certificate. Certificate validity is the period of time during which a certificate is valid. Validity can be expressed as an explicit date and time when the certificate expires, or as a span of time after issuance, stated in days, months, or years. For more information, see Validity in RFC 5280. This value is unaffected when ValidityNotBefore is also specified. For example, if Validity is set to 20 days in the future, the certificate will expire 20 days from issuance time regardless of the ValidityNotBefore value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-certificatevalidity.html#cfn-pcaconnectorad-template-certificatevalidity-validityperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-certificatevalidity.html#cfn-pcaconnectorad-template-certificatevalidity-validityperiod</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getValidityPeriod();

        /**
         * @return a {@link Builder} of {@link CertificateValidityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CertificateValidityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CertificateValidityProperty> {
            java.lang.Object renewalPeriod;
            java.lang.Object validityPeriod;

            /**
             * Sets the value of {@link CertificateValidityProperty#getRenewalPeriod}
             * @param renewalPeriod Renewal period is the period of time before certificate expiration when a new certificate will be requested. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder renewalPeriod(software.amazon.awscdk.IResolvable renewalPeriod) {
                this.renewalPeriod = renewalPeriod;
                return this;
            }

            /**
             * Sets the value of {@link CertificateValidityProperty#getRenewalPeriod}
             * @param renewalPeriod Renewal period is the period of time before certificate expiration when a new certificate will be requested. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder renewalPeriod(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.ValidityPeriodProperty renewalPeriod) {
                this.renewalPeriod = renewalPeriod;
                return this;
            }

            /**
             * Sets the value of {@link CertificateValidityProperty#getValidityPeriod}
             * @param validityPeriod Information describing the end of the validity period of the certificate. This parameter is required.
             *                       This parameter sets the “Not After” date for the certificate. Certificate validity is the period of time during which a certificate is valid. Validity can be expressed as an explicit date and time when the certificate expires, or as a span of time after issuance, stated in days, months, or years. For more information, see Validity in RFC 5280. This value is unaffected when ValidityNotBefore is also specified. For example, if Validity is set to 20 days in the future, the certificate will expire 20 days from issuance time regardless of the ValidityNotBefore value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validityPeriod(software.amazon.awscdk.IResolvable validityPeriod) {
                this.validityPeriod = validityPeriod;
                return this;
            }

            /**
             * Sets the value of {@link CertificateValidityProperty#getValidityPeriod}
             * @param validityPeriod Information describing the end of the validity period of the certificate. This parameter is required.
             *                       This parameter sets the “Not After” date for the certificate. Certificate validity is the period of time during which a certificate is valid. Validity can be expressed as an explicit date and time when the certificate expires, or as a span of time after issuance, stated in days, months, or years. For more information, see Validity in RFC 5280. This value is unaffected when ValidityNotBefore is also specified. For example, if Validity is set to 20 days in the future, the certificate will expire 20 days from issuance time regardless of the ValidityNotBefore value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validityPeriod(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.ValidityPeriodProperty validityPeriod) {
                this.validityPeriod = validityPeriod;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CertificateValidityProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CertificateValidityProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CertificateValidityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CertificateValidityProperty {
            private final java.lang.Object renewalPeriod;
            private final java.lang.Object validityPeriod;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.renewalPeriod = software.amazon.jsii.Kernel.get(this, "renewalPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.validityPeriod = software.amazon.jsii.Kernel.get(this, "validityPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.renewalPeriod = java.util.Objects.requireNonNull(builder.renewalPeriod, "renewalPeriod is required");
                this.validityPeriod = java.util.Objects.requireNonNull(builder.validityPeriod, "validityPeriod is required");
            }

            @Override
            public final java.lang.Object getRenewalPeriod() {
                return this.renewalPeriod;
            }

            @Override
            public final java.lang.Object getValidityPeriod() {
                return this.validityPeriod;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("renewalPeriod", om.valueToTree(this.getRenewalPeriod()));
                data.set("validityPeriod", om.valueToTree(this.getValidityPeriod()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.CertificateValidityProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CertificateValidityProperty.Jsii$Proxy that = (CertificateValidityProperty.Jsii$Proxy) o;

                if (!renewalPeriod.equals(that.renewalPeriod)) return false;
                return this.validityPeriod.equals(that.validityPeriod);
            }

            @Override
            public final int hashCode() {
                int result = this.renewalPeriod.hashCode();
                result = 31 * result + (this.validityPeriod.hashCode());
                return result;
            }
        }
    }
    /**
     * Template configurations for v2 template schema.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pcaconnectorad.*;
     * EnrollmentFlagsV2Property enrollmentFlagsV2Property = EnrollmentFlagsV2Property.builder()
     *         .enableKeyReuseOnNtTokenKeysetStorageFull(false)
     *         .includeSymmetricAlgorithms(false)
     *         .noSecurityExtension(false)
     *         .removeInvalidCertificateFromPersonalStore(false)
     *         .userInteractionRequired(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv2.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv2.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.EnrollmentFlagsV2Property")
    @software.amazon.jsii.Jsii.Proxy(EnrollmentFlagsV2Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EnrollmentFlagsV2Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * Allow renewal using the same key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv2.html#cfn-pcaconnectorad-template-enrollmentflagsv2-enablekeyreuseonnttokenkeysetstoragefull">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv2.html#cfn-pcaconnectorad-template-enrollmentflagsv2-enablekeyreuseonnttokenkeysetstoragefull</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableKeyReuseOnNtTokenKeysetStorageFull() {
            return null;
        }

        /**
         * Include symmetric algorithms allowed by the subject.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv2.html#cfn-pcaconnectorad-template-enrollmentflagsv2-includesymmetricalgorithms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv2.html#cfn-pcaconnectorad-template-enrollmentflagsv2-includesymmetricalgorithms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeSymmetricAlgorithms() {
            return null;
        }

        /**
         * This flag instructs the CA to not include the security extension szOID_NTDS_CA_SECURITY_EXT (OID:1.3.6.1.4.1.311.25.2), as specified in [MS-WCCE] sections 2.2.2.7.7.4 and 3.2.2.6.2.1.4.5.9, in the issued certificate. This addresses a Windows Kerberos elevation-of-privilege vulnerability.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv2.html#cfn-pcaconnectorad-template-enrollmentflagsv2-nosecurityextension">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv2.html#cfn-pcaconnectorad-template-enrollmentflagsv2-nosecurityextension</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNoSecurityExtension() {
            return null;
        }

        /**
         * Delete expired or revoked certificates instead of archiving them.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv2.html#cfn-pcaconnectorad-template-enrollmentflagsv2-removeinvalidcertificatefrompersonalstore">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv2.html#cfn-pcaconnectorad-template-enrollmentflagsv2-removeinvalidcertificatefrompersonalstore</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRemoveInvalidCertificateFromPersonalStore() {
            return null;
        }

        /**
         * Require user interaction when the subject is enrolled and the private key associated with the certificate is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv2.html#cfn-pcaconnectorad-template-enrollmentflagsv2-userinteractionrequired">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv2.html#cfn-pcaconnectorad-template-enrollmentflagsv2-userinteractionrequired</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUserInteractionRequired() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EnrollmentFlagsV2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EnrollmentFlagsV2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EnrollmentFlagsV2Property> {
            java.lang.Object enableKeyReuseOnNtTokenKeysetStorageFull;
            java.lang.Object includeSymmetricAlgorithms;
            java.lang.Object noSecurityExtension;
            java.lang.Object removeInvalidCertificateFromPersonalStore;
            java.lang.Object userInteractionRequired;

            /**
             * Sets the value of {@link EnrollmentFlagsV2Property#getEnableKeyReuseOnNtTokenKeysetStorageFull}
             * @param enableKeyReuseOnNtTokenKeysetStorageFull Allow renewal using the same key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableKeyReuseOnNtTokenKeysetStorageFull(java.lang.Boolean enableKeyReuseOnNtTokenKeysetStorageFull) {
                this.enableKeyReuseOnNtTokenKeysetStorageFull = enableKeyReuseOnNtTokenKeysetStorageFull;
                return this;
            }

            /**
             * Sets the value of {@link EnrollmentFlagsV2Property#getEnableKeyReuseOnNtTokenKeysetStorageFull}
             * @param enableKeyReuseOnNtTokenKeysetStorageFull Allow renewal using the same key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableKeyReuseOnNtTokenKeysetStorageFull(software.amazon.awscdk.IResolvable enableKeyReuseOnNtTokenKeysetStorageFull) {
                this.enableKeyReuseOnNtTokenKeysetStorageFull = enableKeyReuseOnNtTokenKeysetStorageFull;
                return this;
            }

            /**
             * Sets the value of {@link EnrollmentFlagsV2Property#getIncludeSymmetricAlgorithms}
             * @param includeSymmetricAlgorithms Include symmetric algorithms allowed by the subject.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeSymmetricAlgorithms(java.lang.Boolean includeSymmetricAlgorithms) {
                this.includeSymmetricAlgorithms = includeSymmetricAlgorithms;
                return this;
            }

            /**
             * Sets the value of {@link EnrollmentFlagsV2Property#getIncludeSymmetricAlgorithms}
             * @param includeSymmetricAlgorithms Include symmetric algorithms allowed by the subject.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeSymmetricAlgorithms(software.amazon.awscdk.IResolvable includeSymmetricAlgorithms) {
                this.includeSymmetricAlgorithms = includeSymmetricAlgorithms;
                return this;
            }

            /**
             * Sets the value of {@link EnrollmentFlagsV2Property#getNoSecurityExtension}
             * @param noSecurityExtension This flag instructs the CA to not include the security extension szOID_NTDS_CA_SECURITY_EXT (OID:1.3.6.1.4.1.311.25.2), as specified in [MS-WCCE] sections 2.2.2.7.7.4 and 3.2.2.6.2.1.4.5.9, in the issued certificate. This addresses a Windows Kerberos elevation-of-privilege vulnerability.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noSecurityExtension(java.lang.Boolean noSecurityExtension) {
                this.noSecurityExtension = noSecurityExtension;
                return this;
            }

            /**
             * Sets the value of {@link EnrollmentFlagsV2Property#getNoSecurityExtension}
             * @param noSecurityExtension This flag instructs the CA to not include the security extension szOID_NTDS_CA_SECURITY_EXT (OID:1.3.6.1.4.1.311.25.2), as specified in [MS-WCCE] sections 2.2.2.7.7.4 and 3.2.2.6.2.1.4.5.9, in the issued certificate. This addresses a Windows Kerberos elevation-of-privilege vulnerability.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noSecurityExtension(software.amazon.awscdk.IResolvable noSecurityExtension) {
                this.noSecurityExtension = noSecurityExtension;
                return this;
            }

            /**
             * Sets the value of {@link EnrollmentFlagsV2Property#getRemoveInvalidCertificateFromPersonalStore}
             * @param removeInvalidCertificateFromPersonalStore Delete expired or revoked certificates instead of archiving them.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeInvalidCertificateFromPersonalStore(java.lang.Boolean removeInvalidCertificateFromPersonalStore) {
                this.removeInvalidCertificateFromPersonalStore = removeInvalidCertificateFromPersonalStore;
                return this;
            }

            /**
             * Sets the value of {@link EnrollmentFlagsV2Property#getRemoveInvalidCertificateFromPersonalStore}
             * @param removeInvalidCertificateFromPersonalStore Delete expired or revoked certificates instead of archiving them.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeInvalidCertificateFromPersonalStore(software.amazon.awscdk.IResolvable removeInvalidCertificateFromPersonalStore) {
                this.removeInvalidCertificateFromPersonalStore = removeInvalidCertificateFromPersonalStore;
                return this;
            }

            /**
             * Sets the value of {@link EnrollmentFlagsV2Property#getUserInteractionRequired}
             * @param userInteractionRequired Require user interaction when the subject is enrolled and the private key associated with the certificate is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userInteractionRequired(java.lang.Boolean userInteractionRequired) {
                this.userInteractionRequired = userInteractionRequired;
                return this;
            }

            /**
             * Sets the value of {@link EnrollmentFlagsV2Property#getUserInteractionRequired}
             * @param userInteractionRequired Require user interaction when the subject is enrolled and the private key associated with the certificate is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userInteractionRequired(software.amazon.awscdk.IResolvable userInteractionRequired) {
                this.userInteractionRequired = userInteractionRequired;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EnrollmentFlagsV2Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EnrollmentFlagsV2Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EnrollmentFlagsV2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EnrollmentFlagsV2Property {
            private final java.lang.Object enableKeyReuseOnNtTokenKeysetStorageFull;
            private final java.lang.Object includeSymmetricAlgorithms;
            private final java.lang.Object noSecurityExtension;
            private final java.lang.Object removeInvalidCertificateFromPersonalStore;
            private final java.lang.Object userInteractionRequired;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enableKeyReuseOnNtTokenKeysetStorageFull = software.amazon.jsii.Kernel.get(this, "enableKeyReuseOnNtTokenKeysetStorageFull", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeSymmetricAlgorithms = software.amazon.jsii.Kernel.get(this, "includeSymmetricAlgorithms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.noSecurityExtension = software.amazon.jsii.Kernel.get(this, "noSecurityExtension", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.removeInvalidCertificateFromPersonalStore = software.amazon.jsii.Kernel.get(this, "removeInvalidCertificateFromPersonalStore", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.userInteractionRequired = software.amazon.jsii.Kernel.get(this, "userInteractionRequired", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enableKeyReuseOnNtTokenKeysetStorageFull = builder.enableKeyReuseOnNtTokenKeysetStorageFull;
                this.includeSymmetricAlgorithms = builder.includeSymmetricAlgorithms;
                this.noSecurityExtension = builder.noSecurityExtension;
                this.removeInvalidCertificateFromPersonalStore = builder.removeInvalidCertificateFromPersonalStore;
                this.userInteractionRequired = builder.userInteractionRequired;
            }

            @Override
            public final java.lang.Object getEnableKeyReuseOnNtTokenKeysetStorageFull() {
                return this.enableKeyReuseOnNtTokenKeysetStorageFull;
            }

            @Override
            public final java.lang.Object getIncludeSymmetricAlgorithms() {
                return this.includeSymmetricAlgorithms;
            }

            @Override
            public final java.lang.Object getNoSecurityExtension() {
                return this.noSecurityExtension;
            }

            @Override
            public final java.lang.Object getRemoveInvalidCertificateFromPersonalStore() {
                return this.removeInvalidCertificateFromPersonalStore;
            }

            @Override
            public final java.lang.Object getUserInteractionRequired() {
                return this.userInteractionRequired;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnableKeyReuseOnNtTokenKeysetStorageFull() != null) {
                    data.set("enableKeyReuseOnNtTokenKeysetStorageFull", om.valueToTree(this.getEnableKeyReuseOnNtTokenKeysetStorageFull()));
                }
                if (this.getIncludeSymmetricAlgorithms() != null) {
                    data.set("includeSymmetricAlgorithms", om.valueToTree(this.getIncludeSymmetricAlgorithms()));
                }
                if (this.getNoSecurityExtension() != null) {
                    data.set("noSecurityExtension", om.valueToTree(this.getNoSecurityExtension()));
                }
                if (this.getRemoveInvalidCertificateFromPersonalStore() != null) {
                    data.set("removeInvalidCertificateFromPersonalStore", om.valueToTree(this.getRemoveInvalidCertificateFromPersonalStore()));
                }
                if (this.getUserInteractionRequired() != null) {
                    data.set("userInteractionRequired", om.valueToTree(this.getUserInteractionRequired()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.EnrollmentFlagsV2Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EnrollmentFlagsV2Property.Jsii$Proxy that = (EnrollmentFlagsV2Property.Jsii$Proxy) o;

                if (this.enableKeyReuseOnNtTokenKeysetStorageFull != null ? !this.enableKeyReuseOnNtTokenKeysetStorageFull.equals(that.enableKeyReuseOnNtTokenKeysetStorageFull) : that.enableKeyReuseOnNtTokenKeysetStorageFull != null) return false;
                if (this.includeSymmetricAlgorithms != null ? !this.includeSymmetricAlgorithms.equals(that.includeSymmetricAlgorithms) : that.includeSymmetricAlgorithms != null) return false;
                if (this.noSecurityExtension != null ? !this.noSecurityExtension.equals(that.noSecurityExtension) : that.noSecurityExtension != null) return false;
                if (this.removeInvalidCertificateFromPersonalStore != null ? !this.removeInvalidCertificateFromPersonalStore.equals(that.removeInvalidCertificateFromPersonalStore) : that.removeInvalidCertificateFromPersonalStore != null) return false;
                return this.userInteractionRequired != null ? this.userInteractionRequired.equals(that.userInteractionRequired) : that.userInteractionRequired == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enableKeyReuseOnNtTokenKeysetStorageFull != null ? this.enableKeyReuseOnNtTokenKeysetStorageFull.hashCode() : 0;
                result = 31 * result + (this.includeSymmetricAlgorithms != null ? this.includeSymmetricAlgorithms.hashCode() : 0);
                result = 31 * result + (this.noSecurityExtension != null ? this.noSecurityExtension.hashCode() : 0);
                result = 31 * result + (this.removeInvalidCertificateFromPersonalStore != null ? this.removeInvalidCertificateFromPersonalStore.hashCode() : 0);
                result = 31 * result + (this.userInteractionRequired != null ? this.userInteractionRequired.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Template configurations for v3 template schema.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pcaconnectorad.*;
     * EnrollmentFlagsV3Property enrollmentFlagsV3Property = EnrollmentFlagsV3Property.builder()
     *         .enableKeyReuseOnNtTokenKeysetStorageFull(false)
     *         .includeSymmetricAlgorithms(false)
     *         .noSecurityExtension(false)
     *         .removeInvalidCertificateFromPersonalStore(false)
     *         .userInteractionRequired(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv3.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv3.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.EnrollmentFlagsV3Property")
    @software.amazon.jsii.Jsii.Proxy(EnrollmentFlagsV3Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EnrollmentFlagsV3Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * Allow renewal using the same key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv3.html#cfn-pcaconnectorad-template-enrollmentflagsv3-enablekeyreuseonnttokenkeysetstoragefull">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv3.html#cfn-pcaconnectorad-template-enrollmentflagsv3-enablekeyreuseonnttokenkeysetstoragefull</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableKeyReuseOnNtTokenKeysetStorageFull() {
            return null;
        }

        /**
         * Include symmetric algorithms allowed by the subject.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv3.html#cfn-pcaconnectorad-template-enrollmentflagsv3-includesymmetricalgorithms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv3.html#cfn-pcaconnectorad-template-enrollmentflagsv3-includesymmetricalgorithms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeSymmetricAlgorithms() {
            return null;
        }

        /**
         * This flag instructs the CA to not include the security extension szOID_NTDS_CA_SECURITY_EXT (OID:1.3.6.1.4.1.311.25.2), as specified in [MS-WCCE] sections 2.2.2.7.7.4 and 3.2.2.6.2.1.4.5.9, in the issued certificate. This addresses a Windows Kerberos elevation-of-privilege vulnerability.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv3.html#cfn-pcaconnectorad-template-enrollmentflagsv3-nosecurityextension">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv3.html#cfn-pcaconnectorad-template-enrollmentflagsv3-nosecurityextension</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNoSecurityExtension() {
            return null;
        }

        /**
         * Delete expired or revoked certificates instead of archiving them.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv3.html#cfn-pcaconnectorad-template-enrollmentflagsv3-removeinvalidcertificatefrompersonalstore">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv3.html#cfn-pcaconnectorad-template-enrollmentflagsv3-removeinvalidcertificatefrompersonalstore</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRemoveInvalidCertificateFromPersonalStore() {
            return null;
        }

        /**
         * Require user interaction when the subject is enrolled and the private key associated with the certificate is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv3.html#cfn-pcaconnectorad-template-enrollmentflagsv3-userinteractionrequired">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv3.html#cfn-pcaconnectorad-template-enrollmentflagsv3-userinteractionrequired</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUserInteractionRequired() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EnrollmentFlagsV3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EnrollmentFlagsV3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EnrollmentFlagsV3Property> {
            java.lang.Object enableKeyReuseOnNtTokenKeysetStorageFull;
            java.lang.Object includeSymmetricAlgorithms;
            java.lang.Object noSecurityExtension;
            java.lang.Object removeInvalidCertificateFromPersonalStore;
            java.lang.Object userInteractionRequired;

            /**
             * Sets the value of {@link EnrollmentFlagsV3Property#getEnableKeyReuseOnNtTokenKeysetStorageFull}
             * @param enableKeyReuseOnNtTokenKeysetStorageFull Allow renewal using the same key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableKeyReuseOnNtTokenKeysetStorageFull(java.lang.Boolean enableKeyReuseOnNtTokenKeysetStorageFull) {
                this.enableKeyReuseOnNtTokenKeysetStorageFull = enableKeyReuseOnNtTokenKeysetStorageFull;
                return this;
            }

            /**
             * Sets the value of {@link EnrollmentFlagsV3Property#getEnableKeyReuseOnNtTokenKeysetStorageFull}
             * @param enableKeyReuseOnNtTokenKeysetStorageFull Allow renewal using the same key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableKeyReuseOnNtTokenKeysetStorageFull(software.amazon.awscdk.IResolvable enableKeyReuseOnNtTokenKeysetStorageFull) {
                this.enableKeyReuseOnNtTokenKeysetStorageFull = enableKeyReuseOnNtTokenKeysetStorageFull;
                return this;
            }

            /**
             * Sets the value of {@link EnrollmentFlagsV3Property#getIncludeSymmetricAlgorithms}
             * @param includeSymmetricAlgorithms Include symmetric algorithms allowed by the subject.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeSymmetricAlgorithms(java.lang.Boolean includeSymmetricAlgorithms) {
                this.includeSymmetricAlgorithms = includeSymmetricAlgorithms;
                return this;
            }

            /**
             * Sets the value of {@link EnrollmentFlagsV3Property#getIncludeSymmetricAlgorithms}
             * @param includeSymmetricAlgorithms Include symmetric algorithms allowed by the subject.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeSymmetricAlgorithms(software.amazon.awscdk.IResolvable includeSymmetricAlgorithms) {
                this.includeSymmetricAlgorithms = includeSymmetricAlgorithms;
                return this;
            }

            /**
             * Sets the value of {@link EnrollmentFlagsV3Property#getNoSecurityExtension}
             * @param noSecurityExtension This flag instructs the CA to not include the security extension szOID_NTDS_CA_SECURITY_EXT (OID:1.3.6.1.4.1.311.25.2), as specified in [MS-WCCE] sections 2.2.2.7.7.4 and 3.2.2.6.2.1.4.5.9, in the issued certificate. This addresses a Windows Kerberos elevation-of-privilege vulnerability.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noSecurityExtension(java.lang.Boolean noSecurityExtension) {
                this.noSecurityExtension = noSecurityExtension;
                return this;
            }

            /**
             * Sets the value of {@link EnrollmentFlagsV3Property#getNoSecurityExtension}
             * @param noSecurityExtension This flag instructs the CA to not include the security extension szOID_NTDS_CA_SECURITY_EXT (OID:1.3.6.1.4.1.311.25.2), as specified in [MS-WCCE] sections 2.2.2.7.7.4 and 3.2.2.6.2.1.4.5.9, in the issued certificate. This addresses a Windows Kerberos elevation-of-privilege vulnerability.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noSecurityExtension(software.amazon.awscdk.IResolvable noSecurityExtension) {
                this.noSecurityExtension = noSecurityExtension;
                return this;
            }

            /**
             * Sets the value of {@link EnrollmentFlagsV3Property#getRemoveInvalidCertificateFromPersonalStore}
             * @param removeInvalidCertificateFromPersonalStore Delete expired or revoked certificates instead of archiving them.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeInvalidCertificateFromPersonalStore(java.lang.Boolean removeInvalidCertificateFromPersonalStore) {
                this.removeInvalidCertificateFromPersonalStore = removeInvalidCertificateFromPersonalStore;
                return this;
            }

            /**
             * Sets the value of {@link EnrollmentFlagsV3Property#getRemoveInvalidCertificateFromPersonalStore}
             * @param removeInvalidCertificateFromPersonalStore Delete expired or revoked certificates instead of archiving them.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeInvalidCertificateFromPersonalStore(software.amazon.awscdk.IResolvable removeInvalidCertificateFromPersonalStore) {
                this.removeInvalidCertificateFromPersonalStore = removeInvalidCertificateFromPersonalStore;
                return this;
            }

            /**
             * Sets the value of {@link EnrollmentFlagsV3Property#getUserInteractionRequired}
             * @param userInteractionRequired Require user interaction when the subject is enrolled and the private key associated with the certificate is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userInteractionRequired(java.lang.Boolean userInteractionRequired) {
                this.userInteractionRequired = userInteractionRequired;
                return this;
            }

            /**
             * Sets the value of {@link EnrollmentFlagsV3Property#getUserInteractionRequired}
             * @param userInteractionRequired Require user interaction when the subject is enrolled and the private key associated with the certificate is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userInteractionRequired(software.amazon.awscdk.IResolvable userInteractionRequired) {
                this.userInteractionRequired = userInteractionRequired;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EnrollmentFlagsV3Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EnrollmentFlagsV3Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EnrollmentFlagsV3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EnrollmentFlagsV3Property {
            private final java.lang.Object enableKeyReuseOnNtTokenKeysetStorageFull;
            private final java.lang.Object includeSymmetricAlgorithms;
            private final java.lang.Object noSecurityExtension;
            private final java.lang.Object removeInvalidCertificateFromPersonalStore;
            private final java.lang.Object userInteractionRequired;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enableKeyReuseOnNtTokenKeysetStorageFull = software.amazon.jsii.Kernel.get(this, "enableKeyReuseOnNtTokenKeysetStorageFull", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeSymmetricAlgorithms = software.amazon.jsii.Kernel.get(this, "includeSymmetricAlgorithms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.noSecurityExtension = software.amazon.jsii.Kernel.get(this, "noSecurityExtension", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.removeInvalidCertificateFromPersonalStore = software.amazon.jsii.Kernel.get(this, "removeInvalidCertificateFromPersonalStore", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.userInteractionRequired = software.amazon.jsii.Kernel.get(this, "userInteractionRequired", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enableKeyReuseOnNtTokenKeysetStorageFull = builder.enableKeyReuseOnNtTokenKeysetStorageFull;
                this.includeSymmetricAlgorithms = builder.includeSymmetricAlgorithms;
                this.noSecurityExtension = builder.noSecurityExtension;
                this.removeInvalidCertificateFromPersonalStore = builder.removeInvalidCertificateFromPersonalStore;
                this.userInteractionRequired = builder.userInteractionRequired;
            }

            @Override
            public final java.lang.Object getEnableKeyReuseOnNtTokenKeysetStorageFull() {
                return this.enableKeyReuseOnNtTokenKeysetStorageFull;
            }

            @Override
            public final java.lang.Object getIncludeSymmetricAlgorithms() {
                return this.includeSymmetricAlgorithms;
            }

            @Override
            public final java.lang.Object getNoSecurityExtension() {
                return this.noSecurityExtension;
            }

            @Override
            public final java.lang.Object getRemoveInvalidCertificateFromPersonalStore() {
                return this.removeInvalidCertificateFromPersonalStore;
            }

            @Override
            public final java.lang.Object getUserInteractionRequired() {
                return this.userInteractionRequired;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnableKeyReuseOnNtTokenKeysetStorageFull() != null) {
                    data.set("enableKeyReuseOnNtTokenKeysetStorageFull", om.valueToTree(this.getEnableKeyReuseOnNtTokenKeysetStorageFull()));
                }
                if (this.getIncludeSymmetricAlgorithms() != null) {
                    data.set("includeSymmetricAlgorithms", om.valueToTree(this.getIncludeSymmetricAlgorithms()));
                }
                if (this.getNoSecurityExtension() != null) {
                    data.set("noSecurityExtension", om.valueToTree(this.getNoSecurityExtension()));
                }
                if (this.getRemoveInvalidCertificateFromPersonalStore() != null) {
                    data.set("removeInvalidCertificateFromPersonalStore", om.valueToTree(this.getRemoveInvalidCertificateFromPersonalStore()));
                }
                if (this.getUserInteractionRequired() != null) {
                    data.set("userInteractionRequired", om.valueToTree(this.getUserInteractionRequired()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.EnrollmentFlagsV3Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EnrollmentFlagsV3Property.Jsii$Proxy that = (EnrollmentFlagsV3Property.Jsii$Proxy) o;

                if (this.enableKeyReuseOnNtTokenKeysetStorageFull != null ? !this.enableKeyReuseOnNtTokenKeysetStorageFull.equals(that.enableKeyReuseOnNtTokenKeysetStorageFull) : that.enableKeyReuseOnNtTokenKeysetStorageFull != null) return false;
                if (this.includeSymmetricAlgorithms != null ? !this.includeSymmetricAlgorithms.equals(that.includeSymmetricAlgorithms) : that.includeSymmetricAlgorithms != null) return false;
                if (this.noSecurityExtension != null ? !this.noSecurityExtension.equals(that.noSecurityExtension) : that.noSecurityExtension != null) return false;
                if (this.removeInvalidCertificateFromPersonalStore != null ? !this.removeInvalidCertificateFromPersonalStore.equals(that.removeInvalidCertificateFromPersonalStore) : that.removeInvalidCertificateFromPersonalStore != null) return false;
                return this.userInteractionRequired != null ? this.userInteractionRequired.equals(that.userInteractionRequired) : that.userInteractionRequired == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enableKeyReuseOnNtTokenKeysetStorageFull != null ? this.enableKeyReuseOnNtTokenKeysetStorageFull.hashCode() : 0;
                result = 31 * result + (this.includeSymmetricAlgorithms != null ? this.includeSymmetricAlgorithms.hashCode() : 0);
                result = 31 * result + (this.noSecurityExtension != null ? this.noSecurityExtension.hashCode() : 0);
                result = 31 * result + (this.removeInvalidCertificateFromPersonalStore != null ? this.removeInvalidCertificateFromPersonalStore.hashCode() : 0);
                result = 31 * result + (this.userInteractionRequired != null ? this.userInteractionRequired.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Template configurations for v4 template schema.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pcaconnectorad.*;
     * EnrollmentFlagsV4Property enrollmentFlagsV4Property = EnrollmentFlagsV4Property.builder()
     *         .enableKeyReuseOnNtTokenKeysetStorageFull(false)
     *         .includeSymmetricAlgorithms(false)
     *         .noSecurityExtension(false)
     *         .removeInvalidCertificateFromPersonalStore(false)
     *         .userInteractionRequired(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv4.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv4.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.EnrollmentFlagsV4Property")
    @software.amazon.jsii.Jsii.Proxy(EnrollmentFlagsV4Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EnrollmentFlagsV4Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * Allow renewal using the same key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv4.html#cfn-pcaconnectorad-template-enrollmentflagsv4-enablekeyreuseonnttokenkeysetstoragefull">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv4.html#cfn-pcaconnectorad-template-enrollmentflagsv4-enablekeyreuseonnttokenkeysetstoragefull</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableKeyReuseOnNtTokenKeysetStorageFull() {
            return null;
        }

        /**
         * Include symmetric algorithms allowed by the subject.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv4.html#cfn-pcaconnectorad-template-enrollmentflagsv4-includesymmetricalgorithms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv4.html#cfn-pcaconnectorad-template-enrollmentflagsv4-includesymmetricalgorithms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeSymmetricAlgorithms() {
            return null;
        }

        /**
         * This flag instructs the CA to not include the security extension szOID_NTDS_CA_SECURITY_EXT (OID:1.3.6.1.4.1.311.25.2), as specified in [MS-WCCE] sections 2.2.2.7.7.4 and 3.2.2.6.2.1.4.5.9, in the issued certificate. This addresses a Windows Kerberos elevation-of-privilege vulnerability.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv4.html#cfn-pcaconnectorad-template-enrollmentflagsv4-nosecurityextension">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv4.html#cfn-pcaconnectorad-template-enrollmentflagsv4-nosecurityextension</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNoSecurityExtension() {
            return null;
        }

        /**
         * Delete expired or revoked certificates instead of archiving them.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv4.html#cfn-pcaconnectorad-template-enrollmentflagsv4-removeinvalidcertificatefrompersonalstore">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv4.html#cfn-pcaconnectorad-template-enrollmentflagsv4-removeinvalidcertificatefrompersonalstore</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRemoveInvalidCertificateFromPersonalStore() {
            return null;
        }

        /**
         * Require user interaction when the subject is enrolled and the private key associated with the certificate is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv4.html#cfn-pcaconnectorad-template-enrollmentflagsv4-userinteractionrequired">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-enrollmentflagsv4.html#cfn-pcaconnectorad-template-enrollmentflagsv4-userinteractionrequired</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUserInteractionRequired() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EnrollmentFlagsV4Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EnrollmentFlagsV4Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EnrollmentFlagsV4Property> {
            java.lang.Object enableKeyReuseOnNtTokenKeysetStorageFull;
            java.lang.Object includeSymmetricAlgorithms;
            java.lang.Object noSecurityExtension;
            java.lang.Object removeInvalidCertificateFromPersonalStore;
            java.lang.Object userInteractionRequired;

            /**
             * Sets the value of {@link EnrollmentFlagsV4Property#getEnableKeyReuseOnNtTokenKeysetStorageFull}
             * @param enableKeyReuseOnNtTokenKeysetStorageFull Allow renewal using the same key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableKeyReuseOnNtTokenKeysetStorageFull(java.lang.Boolean enableKeyReuseOnNtTokenKeysetStorageFull) {
                this.enableKeyReuseOnNtTokenKeysetStorageFull = enableKeyReuseOnNtTokenKeysetStorageFull;
                return this;
            }

            /**
             * Sets the value of {@link EnrollmentFlagsV4Property#getEnableKeyReuseOnNtTokenKeysetStorageFull}
             * @param enableKeyReuseOnNtTokenKeysetStorageFull Allow renewal using the same key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableKeyReuseOnNtTokenKeysetStorageFull(software.amazon.awscdk.IResolvable enableKeyReuseOnNtTokenKeysetStorageFull) {
                this.enableKeyReuseOnNtTokenKeysetStorageFull = enableKeyReuseOnNtTokenKeysetStorageFull;
                return this;
            }

            /**
             * Sets the value of {@link EnrollmentFlagsV4Property#getIncludeSymmetricAlgorithms}
             * @param includeSymmetricAlgorithms Include symmetric algorithms allowed by the subject.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeSymmetricAlgorithms(java.lang.Boolean includeSymmetricAlgorithms) {
                this.includeSymmetricAlgorithms = includeSymmetricAlgorithms;
                return this;
            }

            /**
             * Sets the value of {@link EnrollmentFlagsV4Property#getIncludeSymmetricAlgorithms}
             * @param includeSymmetricAlgorithms Include symmetric algorithms allowed by the subject.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeSymmetricAlgorithms(software.amazon.awscdk.IResolvable includeSymmetricAlgorithms) {
                this.includeSymmetricAlgorithms = includeSymmetricAlgorithms;
                return this;
            }

            /**
             * Sets the value of {@link EnrollmentFlagsV4Property#getNoSecurityExtension}
             * @param noSecurityExtension This flag instructs the CA to not include the security extension szOID_NTDS_CA_SECURITY_EXT (OID:1.3.6.1.4.1.311.25.2), as specified in [MS-WCCE] sections 2.2.2.7.7.4 and 3.2.2.6.2.1.4.5.9, in the issued certificate. This addresses a Windows Kerberos elevation-of-privilege vulnerability.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noSecurityExtension(java.lang.Boolean noSecurityExtension) {
                this.noSecurityExtension = noSecurityExtension;
                return this;
            }

            /**
             * Sets the value of {@link EnrollmentFlagsV4Property#getNoSecurityExtension}
             * @param noSecurityExtension This flag instructs the CA to not include the security extension szOID_NTDS_CA_SECURITY_EXT (OID:1.3.6.1.4.1.311.25.2), as specified in [MS-WCCE] sections 2.2.2.7.7.4 and 3.2.2.6.2.1.4.5.9, in the issued certificate. This addresses a Windows Kerberos elevation-of-privilege vulnerability.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noSecurityExtension(software.amazon.awscdk.IResolvable noSecurityExtension) {
                this.noSecurityExtension = noSecurityExtension;
                return this;
            }

            /**
             * Sets the value of {@link EnrollmentFlagsV4Property#getRemoveInvalidCertificateFromPersonalStore}
             * @param removeInvalidCertificateFromPersonalStore Delete expired or revoked certificates instead of archiving them.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeInvalidCertificateFromPersonalStore(java.lang.Boolean removeInvalidCertificateFromPersonalStore) {
                this.removeInvalidCertificateFromPersonalStore = removeInvalidCertificateFromPersonalStore;
                return this;
            }

            /**
             * Sets the value of {@link EnrollmentFlagsV4Property#getRemoveInvalidCertificateFromPersonalStore}
             * @param removeInvalidCertificateFromPersonalStore Delete expired or revoked certificates instead of archiving them.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeInvalidCertificateFromPersonalStore(software.amazon.awscdk.IResolvable removeInvalidCertificateFromPersonalStore) {
                this.removeInvalidCertificateFromPersonalStore = removeInvalidCertificateFromPersonalStore;
                return this;
            }

            /**
             * Sets the value of {@link EnrollmentFlagsV4Property#getUserInteractionRequired}
             * @param userInteractionRequired Require user interaction when the subject is enrolled and the private key associated with the certificate is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userInteractionRequired(java.lang.Boolean userInteractionRequired) {
                this.userInteractionRequired = userInteractionRequired;
                return this;
            }

            /**
             * Sets the value of {@link EnrollmentFlagsV4Property#getUserInteractionRequired}
             * @param userInteractionRequired Require user interaction when the subject is enrolled and the private key associated with the certificate is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userInteractionRequired(software.amazon.awscdk.IResolvable userInteractionRequired) {
                this.userInteractionRequired = userInteractionRequired;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EnrollmentFlagsV4Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EnrollmentFlagsV4Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EnrollmentFlagsV4Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EnrollmentFlagsV4Property {
            private final java.lang.Object enableKeyReuseOnNtTokenKeysetStorageFull;
            private final java.lang.Object includeSymmetricAlgorithms;
            private final java.lang.Object noSecurityExtension;
            private final java.lang.Object removeInvalidCertificateFromPersonalStore;
            private final java.lang.Object userInteractionRequired;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enableKeyReuseOnNtTokenKeysetStorageFull = software.amazon.jsii.Kernel.get(this, "enableKeyReuseOnNtTokenKeysetStorageFull", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeSymmetricAlgorithms = software.amazon.jsii.Kernel.get(this, "includeSymmetricAlgorithms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.noSecurityExtension = software.amazon.jsii.Kernel.get(this, "noSecurityExtension", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.removeInvalidCertificateFromPersonalStore = software.amazon.jsii.Kernel.get(this, "removeInvalidCertificateFromPersonalStore", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.userInteractionRequired = software.amazon.jsii.Kernel.get(this, "userInteractionRequired", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enableKeyReuseOnNtTokenKeysetStorageFull = builder.enableKeyReuseOnNtTokenKeysetStorageFull;
                this.includeSymmetricAlgorithms = builder.includeSymmetricAlgorithms;
                this.noSecurityExtension = builder.noSecurityExtension;
                this.removeInvalidCertificateFromPersonalStore = builder.removeInvalidCertificateFromPersonalStore;
                this.userInteractionRequired = builder.userInteractionRequired;
            }

            @Override
            public final java.lang.Object getEnableKeyReuseOnNtTokenKeysetStorageFull() {
                return this.enableKeyReuseOnNtTokenKeysetStorageFull;
            }

            @Override
            public final java.lang.Object getIncludeSymmetricAlgorithms() {
                return this.includeSymmetricAlgorithms;
            }

            @Override
            public final java.lang.Object getNoSecurityExtension() {
                return this.noSecurityExtension;
            }

            @Override
            public final java.lang.Object getRemoveInvalidCertificateFromPersonalStore() {
                return this.removeInvalidCertificateFromPersonalStore;
            }

            @Override
            public final java.lang.Object getUserInteractionRequired() {
                return this.userInteractionRequired;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnableKeyReuseOnNtTokenKeysetStorageFull() != null) {
                    data.set("enableKeyReuseOnNtTokenKeysetStorageFull", om.valueToTree(this.getEnableKeyReuseOnNtTokenKeysetStorageFull()));
                }
                if (this.getIncludeSymmetricAlgorithms() != null) {
                    data.set("includeSymmetricAlgorithms", om.valueToTree(this.getIncludeSymmetricAlgorithms()));
                }
                if (this.getNoSecurityExtension() != null) {
                    data.set("noSecurityExtension", om.valueToTree(this.getNoSecurityExtension()));
                }
                if (this.getRemoveInvalidCertificateFromPersonalStore() != null) {
                    data.set("removeInvalidCertificateFromPersonalStore", om.valueToTree(this.getRemoveInvalidCertificateFromPersonalStore()));
                }
                if (this.getUserInteractionRequired() != null) {
                    data.set("userInteractionRequired", om.valueToTree(this.getUserInteractionRequired()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.EnrollmentFlagsV4Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EnrollmentFlagsV4Property.Jsii$Proxy that = (EnrollmentFlagsV4Property.Jsii$Proxy) o;

                if (this.enableKeyReuseOnNtTokenKeysetStorageFull != null ? !this.enableKeyReuseOnNtTokenKeysetStorageFull.equals(that.enableKeyReuseOnNtTokenKeysetStorageFull) : that.enableKeyReuseOnNtTokenKeysetStorageFull != null) return false;
                if (this.includeSymmetricAlgorithms != null ? !this.includeSymmetricAlgorithms.equals(that.includeSymmetricAlgorithms) : that.includeSymmetricAlgorithms != null) return false;
                if (this.noSecurityExtension != null ? !this.noSecurityExtension.equals(that.noSecurityExtension) : that.noSecurityExtension != null) return false;
                if (this.removeInvalidCertificateFromPersonalStore != null ? !this.removeInvalidCertificateFromPersonalStore.equals(that.removeInvalidCertificateFromPersonalStore) : that.removeInvalidCertificateFromPersonalStore != null) return false;
                return this.userInteractionRequired != null ? this.userInteractionRequired.equals(that.userInteractionRequired) : that.userInteractionRequired == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enableKeyReuseOnNtTokenKeysetStorageFull != null ? this.enableKeyReuseOnNtTokenKeysetStorageFull.hashCode() : 0;
                result = 31 * result + (this.includeSymmetricAlgorithms != null ? this.includeSymmetricAlgorithms.hashCode() : 0);
                result = 31 * result + (this.noSecurityExtension != null ? this.noSecurityExtension.hashCode() : 0);
                result = 31 * result + (this.removeInvalidCertificateFromPersonalStore != null ? this.removeInvalidCertificateFromPersonalStore.hashCode() : 0);
                result = 31 * result + (this.userInteractionRequired != null ? this.userInteractionRequired.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Certificate extensions for v2 template schema.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pcaconnectorad.*;
     * ExtensionsV2Property extensionsV2Property = ExtensionsV2Property.builder()
     *         .keyUsage(KeyUsageProperty.builder()
     *                 .usageFlags(KeyUsageFlagsProperty.builder()
     *                         .dataEncipherment(false)
     *                         .digitalSignature(false)
     *                         .keyAgreement(false)
     *                         .keyEncipherment(false)
     *                         .nonRepudiation(false)
     *                         .build())
     *                 // the properties below are optional
     *                 .critical(false)
     *                 .build())
     *         // the properties below are optional
     *         .applicationPolicies(ApplicationPoliciesProperty.builder()
     *                 .policies(List.of(ApplicationPolicyProperty.builder()
     *                         .policyObjectIdentifier("policyObjectIdentifier")
     *                         .policyType("policyType")
     *                         .build()))
     *                 // the properties below are optional
     *                 .critical(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-extensionsv2.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-extensionsv2.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.ExtensionsV2Property")
    @software.amazon.jsii.Jsii.Proxy(ExtensionsV2Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExtensionsV2Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * The key usage extension defines the purpose (e.g., encipherment, signature, certificate signing) of the key contained in the certificate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-extensionsv2.html#cfn-pcaconnectorad-template-extensionsv2-keyusage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-extensionsv2.html#cfn-pcaconnectorad-template-extensionsv2-keyusage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getKeyUsage();

        /**
         * Application policies specify what the certificate is used for and its purpose.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-extensionsv2.html#cfn-pcaconnectorad-template-extensionsv2-applicationpolicies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-extensionsv2.html#cfn-pcaconnectorad-template-extensionsv2-applicationpolicies</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getApplicationPolicies() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExtensionsV2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExtensionsV2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExtensionsV2Property> {
            java.lang.Object keyUsage;
            java.lang.Object applicationPolicies;

            /**
             * Sets the value of {@link ExtensionsV2Property#getKeyUsage}
             * @param keyUsage The key usage extension defines the purpose (e.g., encipherment, signature, certificate signing) of the key contained in the certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyUsage(software.amazon.awscdk.IResolvable keyUsage) {
                this.keyUsage = keyUsage;
                return this;
            }

            /**
             * Sets the value of {@link ExtensionsV2Property#getKeyUsage}
             * @param keyUsage The key usage extension defines the purpose (e.g., encipherment, signature, certificate signing) of the key contained in the certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyUsage(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.KeyUsageProperty keyUsage) {
                this.keyUsage = keyUsage;
                return this;
            }

            /**
             * Sets the value of {@link ExtensionsV2Property#getApplicationPolicies}
             * @param applicationPolicies Application policies specify what the certificate is used for and its purpose.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationPolicies(software.amazon.awscdk.IResolvable applicationPolicies) {
                this.applicationPolicies = applicationPolicies;
                return this;
            }

            /**
             * Sets the value of {@link ExtensionsV2Property#getApplicationPolicies}
             * @param applicationPolicies Application policies specify what the certificate is used for and its purpose.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationPolicies(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.ApplicationPoliciesProperty applicationPolicies) {
                this.applicationPolicies = applicationPolicies;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExtensionsV2Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExtensionsV2Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExtensionsV2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExtensionsV2Property {
            private final java.lang.Object keyUsage;
            private final java.lang.Object applicationPolicies;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.keyUsage = software.amazon.jsii.Kernel.get(this, "keyUsage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.applicationPolicies = software.amazon.jsii.Kernel.get(this, "applicationPolicies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.keyUsage = java.util.Objects.requireNonNull(builder.keyUsage, "keyUsage is required");
                this.applicationPolicies = builder.applicationPolicies;
            }

            @Override
            public final java.lang.Object getKeyUsage() {
                return this.keyUsage;
            }

            @Override
            public final java.lang.Object getApplicationPolicies() {
                return this.applicationPolicies;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("keyUsage", om.valueToTree(this.getKeyUsage()));
                if (this.getApplicationPolicies() != null) {
                    data.set("applicationPolicies", om.valueToTree(this.getApplicationPolicies()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.ExtensionsV2Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExtensionsV2Property.Jsii$Proxy that = (ExtensionsV2Property.Jsii$Proxy) o;

                if (!keyUsage.equals(that.keyUsage)) return false;
                return this.applicationPolicies != null ? this.applicationPolicies.equals(that.applicationPolicies) : that.applicationPolicies == null;
            }

            @Override
            public final int hashCode() {
                int result = this.keyUsage.hashCode();
                result = 31 * result + (this.applicationPolicies != null ? this.applicationPolicies.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Certificate extensions for v3 template schema.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pcaconnectorad.*;
     * ExtensionsV3Property extensionsV3Property = ExtensionsV3Property.builder()
     *         .keyUsage(KeyUsageProperty.builder()
     *                 .usageFlags(KeyUsageFlagsProperty.builder()
     *                         .dataEncipherment(false)
     *                         .digitalSignature(false)
     *                         .keyAgreement(false)
     *                         .keyEncipherment(false)
     *                         .nonRepudiation(false)
     *                         .build())
     *                 // the properties below are optional
     *                 .critical(false)
     *                 .build())
     *         // the properties below are optional
     *         .applicationPolicies(ApplicationPoliciesProperty.builder()
     *                 .policies(List.of(ApplicationPolicyProperty.builder()
     *                         .policyObjectIdentifier("policyObjectIdentifier")
     *                         .policyType("policyType")
     *                         .build()))
     *                 // the properties below are optional
     *                 .critical(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-extensionsv3.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-extensionsv3.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.ExtensionsV3Property")
    @software.amazon.jsii.Jsii.Proxy(ExtensionsV3Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExtensionsV3Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * The key usage extension defines the purpose (e.g., encipherment, signature, certificate signing) of the key contained in the certificate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-extensionsv3.html#cfn-pcaconnectorad-template-extensionsv3-keyusage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-extensionsv3.html#cfn-pcaconnectorad-template-extensionsv3-keyusage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getKeyUsage();

        /**
         * Application policies specify what the certificate is used for and its purpose.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-extensionsv3.html#cfn-pcaconnectorad-template-extensionsv3-applicationpolicies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-extensionsv3.html#cfn-pcaconnectorad-template-extensionsv3-applicationpolicies</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getApplicationPolicies() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExtensionsV3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExtensionsV3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExtensionsV3Property> {
            java.lang.Object keyUsage;
            java.lang.Object applicationPolicies;

            /**
             * Sets the value of {@link ExtensionsV3Property#getKeyUsage}
             * @param keyUsage The key usage extension defines the purpose (e.g., encipherment, signature, certificate signing) of the key contained in the certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyUsage(software.amazon.awscdk.IResolvable keyUsage) {
                this.keyUsage = keyUsage;
                return this;
            }

            /**
             * Sets the value of {@link ExtensionsV3Property#getKeyUsage}
             * @param keyUsage The key usage extension defines the purpose (e.g., encipherment, signature, certificate signing) of the key contained in the certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyUsage(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.KeyUsageProperty keyUsage) {
                this.keyUsage = keyUsage;
                return this;
            }

            /**
             * Sets the value of {@link ExtensionsV3Property#getApplicationPolicies}
             * @param applicationPolicies Application policies specify what the certificate is used for and its purpose.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationPolicies(software.amazon.awscdk.IResolvable applicationPolicies) {
                this.applicationPolicies = applicationPolicies;
                return this;
            }

            /**
             * Sets the value of {@link ExtensionsV3Property#getApplicationPolicies}
             * @param applicationPolicies Application policies specify what the certificate is used for and its purpose.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationPolicies(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.ApplicationPoliciesProperty applicationPolicies) {
                this.applicationPolicies = applicationPolicies;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExtensionsV3Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExtensionsV3Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExtensionsV3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExtensionsV3Property {
            private final java.lang.Object keyUsage;
            private final java.lang.Object applicationPolicies;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.keyUsage = software.amazon.jsii.Kernel.get(this, "keyUsage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.applicationPolicies = software.amazon.jsii.Kernel.get(this, "applicationPolicies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.keyUsage = java.util.Objects.requireNonNull(builder.keyUsage, "keyUsage is required");
                this.applicationPolicies = builder.applicationPolicies;
            }

            @Override
            public final java.lang.Object getKeyUsage() {
                return this.keyUsage;
            }

            @Override
            public final java.lang.Object getApplicationPolicies() {
                return this.applicationPolicies;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("keyUsage", om.valueToTree(this.getKeyUsage()));
                if (this.getApplicationPolicies() != null) {
                    data.set("applicationPolicies", om.valueToTree(this.getApplicationPolicies()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.ExtensionsV3Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExtensionsV3Property.Jsii$Proxy that = (ExtensionsV3Property.Jsii$Proxy) o;

                if (!keyUsage.equals(that.keyUsage)) return false;
                return this.applicationPolicies != null ? this.applicationPolicies.equals(that.applicationPolicies) : that.applicationPolicies == null;
            }

            @Override
            public final int hashCode() {
                int result = this.keyUsage.hashCode();
                result = 31 * result + (this.applicationPolicies != null ? this.applicationPolicies.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Certificate extensions for v4 template schema.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pcaconnectorad.*;
     * ExtensionsV4Property extensionsV4Property = ExtensionsV4Property.builder()
     *         .keyUsage(KeyUsageProperty.builder()
     *                 .usageFlags(KeyUsageFlagsProperty.builder()
     *                         .dataEncipherment(false)
     *                         .digitalSignature(false)
     *                         .keyAgreement(false)
     *                         .keyEncipherment(false)
     *                         .nonRepudiation(false)
     *                         .build())
     *                 // the properties below are optional
     *                 .critical(false)
     *                 .build())
     *         // the properties below are optional
     *         .applicationPolicies(ApplicationPoliciesProperty.builder()
     *                 .policies(List.of(ApplicationPolicyProperty.builder()
     *                         .policyObjectIdentifier("policyObjectIdentifier")
     *                         .policyType("policyType")
     *                         .build()))
     *                 // the properties below are optional
     *                 .critical(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-extensionsv4.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-extensionsv4.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.ExtensionsV4Property")
    @software.amazon.jsii.Jsii.Proxy(ExtensionsV4Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExtensionsV4Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * The key usage extension defines the purpose (e.g., encipherment, signature) of the key contained in the certificate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-extensionsv4.html#cfn-pcaconnectorad-template-extensionsv4-keyusage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-extensionsv4.html#cfn-pcaconnectorad-template-extensionsv4-keyusage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getKeyUsage();

        /**
         * Application policies specify what the certificate is used for and its purpose.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-extensionsv4.html#cfn-pcaconnectorad-template-extensionsv4-applicationpolicies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-extensionsv4.html#cfn-pcaconnectorad-template-extensionsv4-applicationpolicies</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getApplicationPolicies() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExtensionsV4Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExtensionsV4Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExtensionsV4Property> {
            java.lang.Object keyUsage;
            java.lang.Object applicationPolicies;

            /**
             * Sets the value of {@link ExtensionsV4Property#getKeyUsage}
             * @param keyUsage The key usage extension defines the purpose (e.g., encipherment, signature) of the key contained in the certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyUsage(software.amazon.awscdk.IResolvable keyUsage) {
                this.keyUsage = keyUsage;
                return this;
            }

            /**
             * Sets the value of {@link ExtensionsV4Property#getKeyUsage}
             * @param keyUsage The key usage extension defines the purpose (e.g., encipherment, signature) of the key contained in the certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyUsage(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.KeyUsageProperty keyUsage) {
                this.keyUsage = keyUsage;
                return this;
            }

            /**
             * Sets the value of {@link ExtensionsV4Property#getApplicationPolicies}
             * @param applicationPolicies Application policies specify what the certificate is used for and its purpose.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationPolicies(software.amazon.awscdk.IResolvable applicationPolicies) {
                this.applicationPolicies = applicationPolicies;
                return this;
            }

            /**
             * Sets the value of {@link ExtensionsV4Property#getApplicationPolicies}
             * @param applicationPolicies Application policies specify what the certificate is used for and its purpose.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationPolicies(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.ApplicationPoliciesProperty applicationPolicies) {
                this.applicationPolicies = applicationPolicies;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExtensionsV4Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExtensionsV4Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExtensionsV4Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExtensionsV4Property {
            private final java.lang.Object keyUsage;
            private final java.lang.Object applicationPolicies;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.keyUsage = software.amazon.jsii.Kernel.get(this, "keyUsage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.applicationPolicies = software.amazon.jsii.Kernel.get(this, "applicationPolicies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.keyUsage = java.util.Objects.requireNonNull(builder.keyUsage, "keyUsage is required");
                this.applicationPolicies = builder.applicationPolicies;
            }

            @Override
            public final java.lang.Object getKeyUsage() {
                return this.keyUsage;
            }

            @Override
            public final java.lang.Object getApplicationPolicies() {
                return this.applicationPolicies;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("keyUsage", om.valueToTree(this.getKeyUsage()));
                if (this.getApplicationPolicies() != null) {
                    data.set("applicationPolicies", om.valueToTree(this.getApplicationPolicies()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.ExtensionsV4Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExtensionsV4Property.Jsii$Proxy that = (ExtensionsV4Property.Jsii$Proxy) o;

                if (!keyUsage.equals(that.keyUsage)) return false;
                return this.applicationPolicies != null ? this.applicationPolicies.equals(that.applicationPolicies) : that.applicationPolicies == null;
            }

            @Override
            public final int hashCode() {
                int result = this.keyUsage.hashCode();
                result = 31 * result + (this.applicationPolicies != null ? this.applicationPolicies.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * General flags for v2 template schema that defines if the template is for a machine or a user and if the template can be issued using autoenrollment.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pcaconnectorad.*;
     * GeneralFlagsV2Property generalFlagsV2Property = GeneralFlagsV2Property.builder()
     *         .autoEnrollment(false)
     *         .machineType(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-generalflagsv2.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-generalflagsv2.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.GeneralFlagsV2Property")
    @software.amazon.jsii.Jsii.Proxy(GeneralFlagsV2Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GeneralFlagsV2Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * Allows certificate issuance using autoenrollment.
         * <p>
         * Set to TRUE to allow autoenrollment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-generalflagsv2.html#cfn-pcaconnectorad-template-generalflagsv2-autoenrollment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-generalflagsv2.html#cfn-pcaconnectorad-template-generalflagsv2-autoenrollment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutoEnrollment() {
            return null;
        }

        /**
         * Defines if the template is for machines or users.
         * <p>
         * Set to TRUE if the template is for machines. Set to FALSE if the template is for users.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-generalflagsv2.html#cfn-pcaconnectorad-template-generalflagsv2-machinetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-generalflagsv2.html#cfn-pcaconnectorad-template-generalflagsv2-machinetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMachineType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GeneralFlagsV2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GeneralFlagsV2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GeneralFlagsV2Property> {
            java.lang.Object autoEnrollment;
            java.lang.Object machineType;

            /**
             * Sets the value of {@link GeneralFlagsV2Property#getAutoEnrollment}
             * @param autoEnrollment Allows certificate issuance using autoenrollment.
             *                       Set to TRUE to allow autoenrollment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoEnrollment(java.lang.Boolean autoEnrollment) {
                this.autoEnrollment = autoEnrollment;
                return this;
            }

            /**
             * Sets the value of {@link GeneralFlagsV2Property#getAutoEnrollment}
             * @param autoEnrollment Allows certificate issuance using autoenrollment.
             *                       Set to TRUE to allow autoenrollment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoEnrollment(software.amazon.awscdk.IResolvable autoEnrollment) {
                this.autoEnrollment = autoEnrollment;
                return this;
            }

            /**
             * Sets the value of {@link GeneralFlagsV2Property#getMachineType}
             * @param machineType Defines if the template is for machines or users.
             *                    Set to TRUE if the template is for machines. Set to FALSE if the template is for users.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder machineType(java.lang.Boolean machineType) {
                this.machineType = machineType;
                return this;
            }

            /**
             * Sets the value of {@link GeneralFlagsV2Property#getMachineType}
             * @param machineType Defines if the template is for machines or users.
             *                    Set to TRUE if the template is for machines. Set to FALSE if the template is for users.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder machineType(software.amazon.awscdk.IResolvable machineType) {
                this.machineType = machineType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GeneralFlagsV2Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GeneralFlagsV2Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GeneralFlagsV2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GeneralFlagsV2Property {
            private final java.lang.Object autoEnrollment;
            private final java.lang.Object machineType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.autoEnrollment = software.amazon.jsii.Kernel.get(this, "autoEnrollment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.machineType = software.amazon.jsii.Kernel.get(this, "machineType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.autoEnrollment = builder.autoEnrollment;
                this.machineType = builder.machineType;
            }

            @Override
            public final java.lang.Object getAutoEnrollment() {
                return this.autoEnrollment;
            }

            @Override
            public final java.lang.Object getMachineType() {
                return this.machineType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutoEnrollment() != null) {
                    data.set("autoEnrollment", om.valueToTree(this.getAutoEnrollment()));
                }
                if (this.getMachineType() != null) {
                    data.set("machineType", om.valueToTree(this.getMachineType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.GeneralFlagsV2Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GeneralFlagsV2Property.Jsii$Proxy that = (GeneralFlagsV2Property.Jsii$Proxy) o;

                if (this.autoEnrollment != null ? !this.autoEnrollment.equals(that.autoEnrollment) : that.autoEnrollment != null) return false;
                return this.machineType != null ? this.machineType.equals(that.machineType) : that.machineType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.autoEnrollment != null ? this.autoEnrollment.hashCode() : 0;
                result = 31 * result + (this.machineType != null ? this.machineType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * General flags for v3 template schema that defines if the template is for a machine or a user and if the template can be issued using autoenrollment.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pcaconnectorad.*;
     * GeneralFlagsV3Property generalFlagsV3Property = GeneralFlagsV3Property.builder()
     *         .autoEnrollment(false)
     *         .machineType(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-generalflagsv3.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-generalflagsv3.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.GeneralFlagsV3Property")
    @software.amazon.jsii.Jsii.Proxy(GeneralFlagsV3Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GeneralFlagsV3Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * Allows certificate issuance using autoenrollment.
         * <p>
         * Set to TRUE to allow autoenrollment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-generalflagsv3.html#cfn-pcaconnectorad-template-generalflagsv3-autoenrollment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-generalflagsv3.html#cfn-pcaconnectorad-template-generalflagsv3-autoenrollment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutoEnrollment() {
            return null;
        }

        /**
         * Defines if the template is for machines or users.
         * <p>
         * Set to TRUE if the template is for machines. Set to FALSE if the template is for users
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-generalflagsv3.html#cfn-pcaconnectorad-template-generalflagsv3-machinetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-generalflagsv3.html#cfn-pcaconnectorad-template-generalflagsv3-machinetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMachineType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GeneralFlagsV3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GeneralFlagsV3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GeneralFlagsV3Property> {
            java.lang.Object autoEnrollment;
            java.lang.Object machineType;

            /**
             * Sets the value of {@link GeneralFlagsV3Property#getAutoEnrollment}
             * @param autoEnrollment Allows certificate issuance using autoenrollment.
             *                       Set to TRUE to allow autoenrollment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoEnrollment(java.lang.Boolean autoEnrollment) {
                this.autoEnrollment = autoEnrollment;
                return this;
            }

            /**
             * Sets the value of {@link GeneralFlagsV3Property#getAutoEnrollment}
             * @param autoEnrollment Allows certificate issuance using autoenrollment.
             *                       Set to TRUE to allow autoenrollment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoEnrollment(software.amazon.awscdk.IResolvable autoEnrollment) {
                this.autoEnrollment = autoEnrollment;
                return this;
            }

            /**
             * Sets the value of {@link GeneralFlagsV3Property#getMachineType}
             * @param machineType Defines if the template is for machines or users.
             *                    Set to TRUE if the template is for machines. Set to FALSE if the template is for users
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder machineType(java.lang.Boolean machineType) {
                this.machineType = machineType;
                return this;
            }

            /**
             * Sets the value of {@link GeneralFlagsV3Property#getMachineType}
             * @param machineType Defines if the template is for machines or users.
             *                    Set to TRUE if the template is for machines. Set to FALSE if the template is for users
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder machineType(software.amazon.awscdk.IResolvable machineType) {
                this.machineType = machineType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GeneralFlagsV3Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GeneralFlagsV3Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GeneralFlagsV3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GeneralFlagsV3Property {
            private final java.lang.Object autoEnrollment;
            private final java.lang.Object machineType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.autoEnrollment = software.amazon.jsii.Kernel.get(this, "autoEnrollment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.machineType = software.amazon.jsii.Kernel.get(this, "machineType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.autoEnrollment = builder.autoEnrollment;
                this.machineType = builder.machineType;
            }

            @Override
            public final java.lang.Object getAutoEnrollment() {
                return this.autoEnrollment;
            }

            @Override
            public final java.lang.Object getMachineType() {
                return this.machineType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutoEnrollment() != null) {
                    data.set("autoEnrollment", om.valueToTree(this.getAutoEnrollment()));
                }
                if (this.getMachineType() != null) {
                    data.set("machineType", om.valueToTree(this.getMachineType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.GeneralFlagsV3Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GeneralFlagsV3Property.Jsii$Proxy that = (GeneralFlagsV3Property.Jsii$Proxy) o;

                if (this.autoEnrollment != null ? !this.autoEnrollment.equals(that.autoEnrollment) : that.autoEnrollment != null) return false;
                return this.machineType != null ? this.machineType.equals(that.machineType) : that.machineType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.autoEnrollment != null ? this.autoEnrollment.hashCode() : 0;
                result = 31 * result + (this.machineType != null ? this.machineType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * General flags for v4 template schema that defines if the template is for a machine or a user and if the template can be issued using autoenrollment.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pcaconnectorad.*;
     * GeneralFlagsV4Property generalFlagsV4Property = GeneralFlagsV4Property.builder()
     *         .autoEnrollment(false)
     *         .machineType(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-generalflagsv4.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-generalflagsv4.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.GeneralFlagsV4Property")
    @software.amazon.jsii.Jsii.Proxy(GeneralFlagsV4Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GeneralFlagsV4Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * Allows certificate issuance using autoenrollment.
         * <p>
         * Set to TRUE to allow autoenrollment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-generalflagsv4.html#cfn-pcaconnectorad-template-generalflagsv4-autoenrollment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-generalflagsv4.html#cfn-pcaconnectorad-template-generalflagsv4-autoenrollment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutoEnrollment() {
            return null;
        }

        /**
         * Defines if the template is for machines or users.
         * <p>
         * Set to TRUE if the template is for machines. Set to FALSE if the template is for users
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-generalflagsv4.html#cfn-pcaconnectorad-template-generalflagsv4-machinetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-generalflagsv4.html#cfn-pcaconnectorad-template-generalflagsv4-machinetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMachineType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GeneralFlagsV4Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GeneralFlagsV4Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GeneralFlagsV4Property> {
            java.lang.Object autoEnrollment;
            java.lang.Object machineType;

            /**
             * Sets the value of {@link GeneralFlagsV4Property#getAutoEnrollment}
             * @param autoEnrollment Allows certificate issuance using autoenrollment.
             *                       Set to TRUE to allow autoenrollment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoEnrollment(java.lang.Boolean autoEnrollment) {
                this.autoEnrollment = autoEnrollment;
                return this;
            }

            /**
             * Sets the value of {@link GeneralFlagsV4Property#getAutoEnrollment}
             * @param autoEnrollment Allows certificate issuance using autoenrollment.
             *                       Set to TRUE to allow autoenrollment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoEnrollment(software.amazon.awscdk.IResolvable autoEnrollment) {
                this.autoEnrollment = autoEnrollment;
                return this;
            }

            /**
             * Sets the value of {@link GeneralFlagsV4Property#getMachineType}
             * @param machineType Defines if the template is for machines or users.
             *                    Set to TRUE if the template is for machines. Set to FALSE if the template is for users
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder machineType(java.lang.Boolean machineType) {
                this.machineType = machineType;
                return this;
            }

            /**
             * Sets the value of {@link GeneralFlagsV4Property#getMachineType}
             * @param machineType Defines if the template is for machines or users.
             *                    Set to TRUE if the template is for machines. Set to FALSE if the template is for users
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder machineType(software.amazon.awscdk.IResolvable machineType) {
                this.machineType = machineType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GeneralFlagsV4Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GeneralFlagsV4Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GeneralFlagsV4Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GeneralFlagsV4Property {
            private final java.lang.Object autoEnrollment;
            private final java.lang.Object machineType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.autoEnrollment = software.amazon.jsii.Kernel.get(this, "autoEnrollment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.machineType = software.amazon.jsii.Kernel.get(this, "machineType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.autoEnrollment = builder.autoEnrollment;
                this.machineType = builder.machineType;
            }

            @Override
            public final java.lang.Object getAutoEnrollment() {
                return this.autoEnrollment;
            }

            @Override
            public final java.lang.Object getMachineType() {
                return this.machineType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutoEnrollment() != null) {
                    data.set("autoEnrollment", om.valueToTree(this.getAutoEnrollment()));
                }
                if (this.getMachineType() != null) {
                    data.set("machineType", om.valueToTree(this.getMachineType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.GeneralFlagsV4Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GeneralFlagsV4Property.Jsii$Proxy that = (GeneralFlagsV4Property.Jsii$Proxy) o;

                if (this.autoEnrollment != null ? !this.autoEnrollment.equals(that.autoEnrollment) : that.autoEnrollment != null) return false;
                return this.machineType != null ? this.machineType.equals(that.machineType) : that.machineType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.autoEnrollment != null ? this.autoEnrollment.hashCode() : 0;
                result = 31 * result + (this.machineType != null ? this.machineType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The key usage flags represent the purpose (e.g., encipherment, signature) of the key contained in the certificate.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pcaconnectorad.*;
     * KeyUsageFlagsProperty keyUsageFlagsProperty = KeyUsageFlagsProperty.builder()
     *         .dataEncipherment(false)
     *         .digitalSignature(false)
     *         .keyAgreement(false)
     *         .keyEncipherment(false)
     *         .nonRepudiation(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-keyusageflags.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-keyusageflags.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.KeyUsageFlagsProperty")
    @software.amazon.jsii.Jsii.Proxy(KeyUsageFlagsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KeyUsageFlagsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * DataEncipherment is asserted when the subject public key is used for directly enciphering raw user data without the use of an intermediate symmetric cipher.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-keyusageflags.html#cfn-pcaconnectorad-template-keyusageflags-dataencipherment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-keyusageflags.html#cfn-pcaconnectorad-template-keyusageflags-dataencipherment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataEncipherment() {
            return null;
        }

        /**
         * The digitalSignature is asserted when the subject public key is used for verifying digital signatures.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-keyusageflags.html#cfn-pcaconnectorad-template-keyusageflags-digitalsignature">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-keyusageflags.html#cfn-pcaconnectorad-template-keyusageflags-digitalsignature</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDigitalSignature() {
            return null;
        }

        /**
         * KeyAgreement is asserted when the subject public key is used for key agreement.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-keyusageflags.html#cfn-pcaconnectorad-template-keyusageflags-keyagreement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-keyusageflags.html#cfn-pcaconnectorad-template-keyusageflags-keyagreement</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKeyAgreement() {
            return null;
        }

        /**
         * KeyEncipherment is asserted when the subject public key is used for enciphering private or secret keys, i.e., for key transport.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-keyusageflags.html#cfn-pcaconnectorad-template-keyusageflags-keyencipherment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-keyusageflags.html#cfn-pcaconnectorad-template-keyusageflags-keyencipherment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKeyEncipherment() {
            return null;
        }

        /**
         * NonRepudiation is asserted when the subject public key is used to verify digital signatures.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-keyusageflags.html#cfn-pcaconnectorad-template-keyusageflags-nonrepudiation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-keyusageflags.html#cfn-pcaconnectorad-template-keyusageflags-nonrepudiation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNonRepudiation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KeyUsageFlagsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KeyUsageFlagsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KeyUsageFlagsProperty> {
            java.lang.Object dataEncipherment;
            java.lang.Object digitalSignature;
            java.lang.Object keyAgreement;
            java.lang.Object keyEncipherment;
            java.lang.Object nonRepudiation;

            /**
             * Sets the value of {@link KeyUsageFlagsProperty#getDataEncipherment}
             * @param dataEncipherment DataEncipherment is asserted when the subject public key is used for directly enciphering raw user data without the use of an intermediate symmetric cipher.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataEncipherment(java.lang.Boolean dataEncipherment) {
                this.dataEncipherment = dataEncipherment;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageFlagsProperty#getDataEncipherment}
             * @param dataEncipherment DataEncipherment is asserted when the subject public key is used for directly enciphering raw user data without the use of an intermediate symmetric cipher.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataEncipherment(software.amazon.awscdk.IResolvable dataEncipherment) {
                this.dataEncipherment = dataEncipherment;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageFlagsProperty#getDigitalSignature}
             * @param digitalSignature The digitalSignature is asserted when the subject public key is used for verifying digital signatures.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder digitalSignature(java.lang.Boolean digitalSignature) {
                this.digitalSignature = digitalSignature;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageFlagsProperty#getDigitalSignature}
             * @param digitalSignature The digitalSignature is asserted when the subject public key is used for verifying digital signatures.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder digitalSignature(software.amazon.awscdk.IResolvable digitalSignature) {
                this.digitalSignature = digitalSignature;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageFlagsProperty#getKeyAgreement}
             * @param keyAgreement KeyAgreement is asserted when the subject public key is used for key agreement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyAgreement(java.lang.Boolean keyAgreement) {
                this.keyAgreement = keyAgreement;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageFlagsProperty#getKeyAgreement}
             * @param keyAgreement KeyAgreement is asserted when the subject public key is used for key agreement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyAgreement(software.amazon.awscdk.IResolvable keyAgreement) {
                this.keyAgreement = keyAgreement;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageFlagsProperty#getKeyEncipherment}
             * @param keyEncipherment KeyEncipherment is asserted when the subject public key is used for enciphering private or secret keys, i.e., for key transport.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyEncipherment(java.lang.Boolean keyEncipherment) {
                this.keyEncipherment = keyEncipherment;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageFlagsProperty#getKeyEncipherment}
             * @param keyEncipherment KeyEncipherment is asserted when the subject public key is used for enciphering private or secret keys, i.e., for key transport.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyEncipherment(software.amazon.awscdk.IResolvable keyEncipherment) {
                this.keyEncipherment = keyEncipherment;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageFlagsProperty#getNonRepudiation}
             * @param nonRepudiation NonRepudiation is asserted when the subject public key is used to verify digital signatures.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nonRepudiation(java.lang.Boolean nonRepudiation) {
                this.nonRepudiation = nonRepudiation;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageFlagsProperty#getNonRepudiation}
             * @param nonRepudiation NonRepudiation is asserted when the subject public key is used to verify digital signatures.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nonRepudiation(software.amazon.awscdk.IResolvable nonRepudiation) {
                this.nonRepudiation = nonRepudiation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KeyUsageFlagsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KeyUsageFlagsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KeyUsageFlagsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KeyUsageFlagsProperty {
            private final java.lang.Object dataEncipherment;
            private final java.lang.Object digitalSignature;
            private final java.lang.Object keyAgreement;
            private final java.lang.Object keyEncipherment;
            private final java.lang.Object nonRepudiation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataEncipherment = software.amazon.jsii.Kernel.get(this, "dataEncipherment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.digitalSignature = software.amazon.jsii.Kernel.get(this, "digitalSignature", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.keyAgreement = software.amazon.jsii.Kernel.get(this, "keyAgreement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.keyEncipherment = software.amazon.jsii.Kernel.get(this, "keyEncipherment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.nonRepudiation = software.amazon.jsii.Kernel.get(this, "nonRepudiation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataEncipherment = builder.dataEncipherment;
                this.digitalSignature = builder.digitalSignature;
                this.keyAgreement = builder.keyAgreement;
                this.keyEncipherment = builder.keyEncipherment;
                this.nonRepudiation = builder.nonRepudiation;
            }

            @Override
            public final java.lang.Object getDataEncipherment() {
                return this.dataEncipherment;
            }

            @Override
            public final java.lang.Object getDigitalSignature() {
                return this.digitalSignature;
            }

            @Override
            public final java.lang.Object getKeyAgreement() {
                return this.keyAgreement;
            }

            @Override
            public final java.lang.Object getKeyEncipherment() {
                return this.keyEncipherment;
            }

            @Override
            public final java.lang.Object getNonRepudiation() {
                return this.nonRepudiation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDataEncipherment() != null) {
                    data.set("dataEncipherment", om.valueToTree(this.getDataEncipherment()));
                }
                if (this.getDigitalSignature() != null) {
                    data.set("digitalSignature", om.valueToTree(this.getDigitalSignature()));
                }
                if (this.getKeyAgreement() != null) {
                    data.set("keyAgreement", om.valueToTree(this.getKeyAgreement()));
                }
                if (this.getKeyEncipherment() != null) {
                    data.set("keyEncipherment", om.valueToTree(this.getKeyEncipherment()));
                }
                if (this.getNonRepudiation() != null) {
                    data.set("nonRepudiation", om.valueToTree(this.getNonRepudiation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.KeyUsageFlagsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KeyUsageFlagsProperty.Jsii$Proxy that = (KeyUsageFlagsProperty.Jsii$Proxy) o;

                if (this.dataEncipherment != null ? !this.dataEncipherment.equals(that.dataEncipherment) : that.dataEncipherment != null) return false;
                if (this.digitalSignature != null ? !this.digitalSignature.equals(that.digitalSignature) : that.digitalSignature != null) return false;
                if (this.keyAgreement != null ? !this.keyAgreement.equals(that.keyAgreement) : that.keyAgreement != null) return false;
                if (this.keyEncipherment != null ? !this.keyEncipherment.equals(that.keyEncipherment) : that.keyEncipherment != null) return false;
                return this.nonRepudiation != null ? this.nonRepudiation.equals(that.nonRepudiation) : that.nonRepudiation == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataEncipherment != null ? this.dataEncipherment.hashCode() : 0;
                result = 31 * result + (this.digitalSignature != null ? this.digitalSignature.hashCode() : 0);
                result = 31 * result + (this.keyAgreement != null ? this.keyAgreement.hashCode() : 0);
                result = 31 * result + (this.keyEncipherment != null ? this.keyEncipherment.hashCode() : 0);
                result = 31 * result + (this.nonRepudiation != null ? this.nonRepudiation.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The key usage extension defines the purpose (e.g., encipherment, signature) of the key contained in the certificate.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pcaconnectorad.*;
     * KeyUsageProperty keyUsageProperty = KeyUsageProperty.builder()
     *         .usageFlags(KeyUsageFlagsProperty.builder()
     *                 .dataEncipherment(false)
     *                 .digitalSignature(false)
     *                 .keyAgreement(false)
     *                 .keyEncipherment(false)
     *                 .nonRepudiation(false)
     *                 .build())
     *         // the properties below are optional
     *         .critical(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-keyusage.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-keyusage.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.KeyUsageProperty")
    @software.amazon.jsii.Jsii.Proxy(KeyUsageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KeyUsageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The key usage flags represent the purpose (e.g., encipherment, signature) of the key contained in the certificate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-keyusage.html#cfn-pcaconnectorad-template-keyusage-usageflags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-keyusage.html#cfn-pcaconnectorad-template-keyusage-usageflags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getUsageFlags();

        /**
         * Sets the key usage extension to critical.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-keyusage.html#cfn-pcaconnectorad-template-keyusage-critical">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-keyusage.html#cfn-pcaconnectorad-template-keyusage-critical</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCritical() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KeyUsageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KeyUsageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KeyUsageProperty> {
            java.lang.Object usageFlags;
            java.lang.Object critical;

            /**
             * Sets the value of {@link KeyUsageProperty#getUsageFlags}
             * @param usageFlags The key usage flags represent the purpose (e.g., encipherment, signature) of the key contained in the certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder usageFlags(software.amazon.awscdk.IResolvable usageFlags) {
                this.usageFlags = usageFlags;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getUsageFlags}
             * @param usageFlags The key usage flags represent the purpose (e.g., encipherment, signature) of the key contained in the certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder usageFlags(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.KeyUsageFlagsProperty usageFlags) {
                this.usageFlags = usageFlags;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getCritical}
             * @param critical Sets the key usage extension to critical.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder critical(java.lang.Boolean critical) {
                this.critical = critical;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getCritical}
             * @param critical Sets the key usage extension to critical.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder critical(software.amazon.awscdk.IResolvable critical) {
                this.critical = critical;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KeyUsageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KeyUsageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KeyUsageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KeyUsageProperty {
            private final java.lang.Object usageFlags;
            private final java.lang.Object critical;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.usageFlags = software.amazon.jsii.Kernel.get(this, "usageFlags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.critical = software.amazon.jsii.Kernel.get(this, "critical", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.usageFlags = java.util.Objects.requireNonNull(builder.usageFlags, "usageFlags is required");
                this.critical = builder.critical;
            }

            @Override
            public final java.lang.Object getUsageFlags() {
                return this.usageFlags;
            }

            @Override
            public final java.lang.Object getCritical() {
                return this.critical;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("usageFlags", om.valueToTree(this.getUsageFlags()));
                if (this.getCritical() != null) {
                    data.set("critical", om.valueToTree(this.getCritical()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.KeyUsageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KeyUsageProperty.Jsii$Proxy that = (KeyUsageProperty.Jsii$Proxy) o;

                if (!usageFlags.equals(that.usageFlags)) return false;
                return this.critical != null ? this.critical.equals(that.critical) : that.critical == null;
            }

            @Override
            public final int hashCode() {
                int result = this.usageFlags.hashCode();
                result = 31 * result + (this.critical != null ? this.critical.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies key usage.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pcaconnectorad.*;
     * KeyUsagePropertyFlagsProperty keyUsagePropertyFlagsProperty = KeyUsagePropertyFlagsProperty.builder()
     *         .decrypt(false)
     *         .keyAgreement(false)
     *         .sign(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-keyusagepropertyflags.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-keyusagepropertyflags.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.KeyUsagePropertyFlagsProperty")
    @software.amazon.jsii.Jsii.Proxy(KeyUsagePropertyFlagsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KeyUsagePropertyFlagsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Allows key for encryption and decryption.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-keyusagepropertyflags.html#cfn-pcaconnectorad-template-keyusagepropertyflags-decrypt">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-keyusagepropertyflags.html#cfn-pcaconnectorad-template-keyusagepropertyflags-decrypt</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDecrypt() {
            return null;
        }

        /**
         * Allows key exchange without encryption.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-keyusagepropertyflags.html#cfn-pcaconnectorad-template-keyusagepropertyflags-keyagreement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-keyusagepropertyflags.html#cfn-pcaconnectorad-template-keyusagepropertyflags-keyagreement</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKeyAgreement() {
            return null;
        }

        /**
         * Allow key use for digital signature.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-keyusagepropertyflags.html#cfn-pcaconnectorad-template-keyusagepropertyflags-sign">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-keyusagepropertyflags.html#cfn-pcaconnectorad-template-keyusagepropertyflags-sign</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSign() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KeyUsagePropertyFlagsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KeyUsagePropertyFlagsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KeyUsagePropertyFlagsProperty> {
            java.lang.Object decrypt;
            java.lang.Object keyAgreement;
            java.lang.Object sign;

            /**
             * Sets the value of {@link KeyUsagePropertyFlagsProperty#getDecrypt}
             * @param decrypt Allows key for encryption and decryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder decrypt(java.lang.Boolean decrypt) {
                this.decrypt = decrypt;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsagePropertyFlagsProperty#getDecrypt}
             * @param decrypt Allows key for encryption and decryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder decrypt(software.amazon.awscdk.IResolvable decrypt) {
                this.decrypt = decrypt;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsagePropertyFlagsProperty#getKeyAgreement}
             * @param keyAgreement Allows key exchange without encryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyAgreement(java.lang.Boolean keyAgreement) {
                this.keyAgreement = keyAgreement;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsagePropertyFlagsProperty#getKeyAgreement}
             * @param keyAgreement Allows key exchange without encryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyAgreement(software.amazon.awscdk.IResolvable keyAgreement) {
                this.keyAgreement = keyAgreement;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsagePropertyFlagsProperty#getSign}
             * @param sign Allow key use for digital signature.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sign(java.lang.Boolean sign) {
                this.sign = sign;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsagePropertyFlagsProperty#getSign}
             * @param sign Allow key use for digital signature.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sign(software.amazon.awscdk.IResolvable sign) {
                this.sign = sign;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KeyUsagePropertyFlagsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KeyUsagePropertyFlagsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KeyUsagePropertyFlagsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KeyUsagePropertyFlagsProperty {
            private final java.lang.Object decrypt;
            private final java.lang.Object keyAgreement;
            private final java.lang.Object sign;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.decrypt = software.amazon.jsii.Kernel.get(this, "decrypt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.keyAgreement = software.amazon.jsii.Kernel.get(this, "keyAgreement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sign = software.amazon.jsii.Kernel.get(this, "sign", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.decrypt = builder.decrypt;
                this.keyAgreement = builder.keyAgreement;
                this.sign = builder.sign;
            }

            @Override
            public final java.lang.Object getDecrypt() {
                return this.decrypt;
            }

            @Override
            public final java.lang.Object getKeyAgreement() {
                return this.keyAgreement;
            }

            @Override
            public final java.lang.Object getSign() {
                return this.sign;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDecrypt() != null) {
                    data.set("decrypt", om.valueToTree(this.getDecrypt()));
                }
                if (this.getKeyAgreement() != null) {
                    data.set("keyAgreement", om.valueToTree(this.getKeyAgreement()));
                }
                if (this.getSign() != null) {
                    data.set("sign", om.valueToTree(this.getSign()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.KeyUsagePropertyFlagsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KeyUsagePropertyFlagsProperty.Jsii$Proxy that = (KeyUsagePropertyFlagsProperty.Jsii$Proxy) o;

                if (this.decrypt != null ? !this.decrypt.equals(that.decrypt) : that.decrypt != null) return false;
                if (this.keyAgreement != null ? !this.keyAgreement.equals(that.keyAgreement) : that.keyAgreement != null) return false;
                return this.sign != null ? this.sign.equals(that.sign) : that.sign == null;
            }

            @Override
            public final int hashCode() {
                int result = this.decrypt != null ? this.decrypt.hashCode() : 0;
                result = 31 * result + (this.keyAgreement != null ? this.keyAgreement.hashCode() : 0);
                result = 31 * result + (this.sign != null ? this.sign.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The key usage property defines the purpose of the private key contained in the certificate.
     * <p>
     * You can specify specific purposes using property flags or all by using property type ALL.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pcaconnectorad.*;
     * KeyUsagePropertyProperty keyUsagePropertyProperty = KeyUsagePropertyProperty.builder()
     *         .propertyFlags(KeyUsagePropertyFlagsProperty.builder()
     *                 .decrypt(false)
     *                 .keyAgreement(false)
     *                 .sign(false)
     *                 .build())
     *         .propertyType("propertyType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-keyusageproperty.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-keyusageproperty.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.KeyUsagePropertyProperty")
    @software.amazon.jsii.Jsii.Proxy(KeyUsagePropertyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KeyUsagePropertyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * You can specify key usage for encryption, key agreement, and signature.
         * <p>
         * You can use property flags or property type but not both.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-keyusageproperty.html#cfn-pcaconnectorad-template-keyusageproperty-propertyflags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-keyusageproperty.html#cfn-pcaconnectorad-template-keyusageproperty-propertyflags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPropertyFlags() {
            return null;
        }

        /**
         * You can specify all key usages using property type ALL.
         * <p>
         * You can use property type or property flags but not both.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-keyusageproperty.html#cfn-pcaconnectorad-template-keyusageproperty-propertytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-keyusageproperty.html#cfn-pcaconnectorad-template-keyusageproperty-propertytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPropertyType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KeyUsagePropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KeyUsagePropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KeyUsagePropertyProperty> {
            java.lang.Object propertyFlags;
            java.lang.String propertyType;

            /**
             * Sets the value of {@link KeyUsagePropertyProperty#getPropertyFlags}
             * @param propertyFlags You can specify key usage for encryption, key agreement, and signature.
             *                      You can use property flags or property type but not both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyFlags(software.amazon.awscdk.IResolvable propertyFlags) {
                this.propertyFlags = propertyFlags;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsagePropertyProperty#getPropertyFlags}
             * @param propertyFlags You can specify key usage for encryption, key agreement, and signature.
             *                      You can use property flags or property type but not both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyFlags(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.KeyUsagePropertyFlagsProperty propertyFlags) {
                this.propertyFlags = propertyFlags;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsagePropertyProperty#getPropertyType}
             * @param propertyType You can specify all key usages using property type ALL.
             *                     You can use property type or property flags but not both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyType(java.lang.String propertyType) {
                this.propertyType = propertyType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KeyUsagePropertyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KeyUsagePropertyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KeyUsagePropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KeyUsagePropertyProperty {
            private final java.lang.Object propertyFlags;
            private final java.lang.String propertyType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.propertyFlags = software.amazon.jsii.Kernel.get(this, "propertyFlags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.propertyType = software.amazon.jsii.Kernel.get(this, "propertyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.propertyFlags = builder.propertyFlags;
                this.propertyType = builder.propertyType;
            }

            @Override
            public final java.lang.Object getPropertyFlags() {
                return this.propertyFlags;
            }

            @Override
            public final java.lang.String getPropertyType() {
                return this.propertyType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPropertyFlags() != null) {
                    data.set("propertyFlags", om.valueToTree(this.getPropertyFlags()));
                }
                if (this.getPropertyType() != null) {
                    data.set("propertyType", om.valueToTree(this.getPropertyType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.KeyUsagePropertyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KeyUsagePropertyProperty.Jsii$Proxy that = (KeyUsagePropertyProperty.Jsii$Proxy) o;

                if (this.propertyFlags != null ? !this.propertyFlags.equals(that.propertyFlags) : that.propertyFlags != null) return false;
                return this.propertyType != null ? this.propertyType.equals(that.propertyType) : that.propertyType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.propertyFlags != null ? this.propertyFlags.hashCode() : 0;
                result = 31 * result + (this.propertyType != null ? this.propertyType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines the attributes of the private key.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pcaconnectorad.*;
     * PrivateKeyAttributesV2Property privateKeyAttributesV2Property = PrivateKeyAttributesV2Property.builder()
     *         .keySpec("keySpec")
     *         .minimalKeyLength(123)
     *         // the properties below are optional
     *         .cryptoProviders(List.of("cryptoProviders"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyattributesv2.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyattributesv2.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.PrivateKeyAttributesV2Property")
    @software.amazon.jsii.Jsii.Proxy(PrivateKeyAttributesV2Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PrivateKeyAttributesV2Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines the purpose of the private key.
         * <p>
         * Set it to "KEY_EXCHANGE" or "SIGNATURE" value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyattributesv2.html#cfn-pcaconnectorad-template-privatekeyattributesv2-keyspec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyattributesv2.html#cfn-pcaconnectorad-template-privatekeyattributesv2-keyspec</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKeySpec();

        /**
         * Set the minimum key length of the private key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyattributesv2.html#cfn-pcaconnectorad-template-privatekeyattributesv2-minimalkeylength">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyattributesv2.html#cfn-pcaconnectorad-template-privatekeyattributesv2-minimalkeylength</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinimalKeyLength();

        /**
         * Defines the cryptographic providers used to generate the private key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyattributesv2.html#cfn-pcaconnectorad-template-privatekeyattributesv2-cryptoproviders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyattributesv2.html#cfn-pcaconnectorad-template-privatekeyattributesv2-cryptoproviders</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCryptoProviders() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PrivateKeyAttributesV2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PrivateKeyAttributesV2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PrivateKeyAttributesV2Property> {
            java.lang.String keySpec;
            java.lang.Number minimalKeyLength;
            java.util.List<java.lang.String> cryptoProviders;

            /**
             * Sets the value of {@link PrivateKeyAttributesV2Property#getKeySpec}
             * @param keySpec Defines the purpose of the private key. This parameter is required.
             *                Set it to "KEY_EXCHANGE" or "SIGNATURE" value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keySpec(java.lang.String keySpec) {
                this.keySpec = keySpec;
                return this;
            }

            /**
             * Sets the value of {@link PrivateKeyAttributesV2Property#getMinimalKeyLength}
             * @param minimalKeyLength Set the minimum key length of the private key. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimalKeyLength(java.lang.Number minimalKeyLength) {
                this.minimalKeyLength = minimalKeyLength;
                return this;
            }

            /**
             * Sets the value of {@link PrivateKeyAttributesV2Property#getCryptoProviders}
             * @param cryptoProviders Defines the cryptographic providers used to generate the private key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cryptoProviders(java.util.List<java.lang.String> cryptoProviders) {
                this.cryptoProviders = cryptoProviders;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrivateKeyAttributesV2Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PrivateKeyAttributesV2Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PrivateKeyAttributesV2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrivateKeyAttributesV2Property {
            private final java.lang.String keySpec;
            private final java.lang.Number minimalKeyLength;
            private final java.util.List<java.lang.String> cryptoProviders;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.keySpec = software.amazon.jsii.Kernel.get(this, "keySpec", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.minimalKeyLength = software.amazon.jsii.Kernel.get(this, "minimalKeyLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.cryptoProviders = software.amazon.jsii.Kernel.get(this, "cryptoProviders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.keySpec = java.util.Objects.requireNonNull(builder.keySpec, "keySpec is required");
                this.minimalKeyLength = java.util.Objects.requireNonNull(builder.minimalKeyLength, "minimalKeyLength is required");
                this.cryptoProviders = builder.cryptoProviders;
            }

            @Override
            public final java.lang.String getKeySpec() {
                return this.keySpec;
            }

            @Override
            public final java.lang.Number getMinimalKeyLength() {
                return this.minimalKeyLength;
            }

            @Override
            public final java.util.List<java.lang.String> getCryptoProviders() {
                return this.cryptoProviders;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("keySpec", om.valueToTree(this.getKeySpec()));
                data.set("minimalKeyLength", om.valueToTree(this.getMinimalKeyLength()));
                if (this.getCryptoProviders() != null) {
                    data.set("cryptoProviders", om.valueToTree(this.getCryptoProviders()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.PrivateKeyAttributesV2Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PrivateKeyAttributesV2Property.Jsii$Proxy that = (PrivateKeyAttributesV2Property.Jsii$Proxy) o;

                if (!keySpec.equals(that.keySpec)) return false;
                if (!minimalKeyLength.equals(that.minimalKeyLength)) return false;
                return this.cryptoProviders != null ? this.cryptoProviders.equals(that.cryptoProviders) : that.cryptoProviders == null;
            }

            @Override
            public final int hashCode() {
                int result = this.keySpec.hashCode();
                result = 31 * result + (this.minimalKeyLength.hashCode());
                result = 31 * result + (this.cryptoProviders != null ? this.cryptoProviders.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines the attributes of the private key.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pcaconnectorad.*;
     * PrivateKeyAttributesV3Property privateKeyAttributesV3Property = PrivateKeyAttributesV3Property.builder()
     *         .algorithm("algorithm")
     *         .keySpec("keySpec")
     *         .keyUsageProperty(KeyUsagePropertyProperty.builder()
     *                 .propertyFlags(KeyUsagePropertyFlagsProperty.builder()
     *                         .decrypt(false)
     *                         .keyAgreement(false)
     *                         .sign(false)
     *                         .build())
     *                 .propertyType("propertyType")
     *                 .build())
     *         .minimalKeyLength(123)
     *         // the properties below are optional
     *         .cryptoProviders(List.of("cryptoProviders"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyattributesv3.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyattributesv3.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.PrivateKeyAttributesV3Property")
    @software.amazon.jsii.Jsii.Proxy(PrivateKeyAttributesV3Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PrivateKeyAttributesV3Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines the algorithm used to generate the private key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyattributesv3.html#cfn-pcaconnectorad-template-privatekeyattributesv3-algorithm">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyattributesv3.html#cfn-pcaconnectorad-template-privatekeyattributesv3-algorithm</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAlgorithm();

        /**
         * Defines the purpose of the private key.
         * <p>
         * Set it to "KEY_EXCHANGE" or "SIGNATURE" value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyattributesv3.html#cfn-pcaconnectorad-template-privatekeyattributesv3-keyspec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyattributesv3.html#cfn-pcaconnectorad-template-privatekeyattributesv3-keyspec</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKeySpec();

        /**
         * The key usage property defines the purpose of the private key contained in the certificate.
         * <p>
         * You can specify specific purposes using property flags or all by using property type ALL.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyattributesv3.html#cfn-pcaconnectorad-template-privatekeyattributesv3-keyusageproperty">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyattributesv3.html#cfn-pcaconnectorad-template-privatekeyattributesv3-keyusageproperty</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getKeyUsageProperty();

        /**
         * Set the minimum key length of the private key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyattributesv3.html#cfn-pcaconnectorad-template-privatekeyattributesv3-minimalkeylength">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyattributesv3.html#cfn-pcaconnectorad-template-privatekeyattributesv3-minimalkeylength</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinimalKeyLength();

        /**
         * Defines the cryptographic providers used to generate the private key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyattributesv3.html#cfn-pcaconnectorad-template-privatekeyattributesv3-cryptoproviders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyattributesv3.html#cfn-pcaconnectorad-template-privatekeyattributesv3-cryptoproviders</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCryptoProviders() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PrivateKeyAttributesV3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PrivateKeyAttributesV3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PrivateKeyAttributesV3Property> {
            java.lang.String algorithm;
            java.lang.String keySpec;
            java.lang.Object keyUsageProperty;
            java.lang.Number minimalKeyLength;
            java.util.List<java.lang.String> cryptoProviders;

            /**
             * Sets the value of {@link PrivateKeyAttributesV3Property#getAlgorithm}
             * @param algorithm Defines the algorithm used to generate the private key. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder algorithm(java.lang.String algorithm) {
                this.algorithm = algorithm;
                return this;
            }

            /**
             * Sets the value of {@link PrivateKeyAttributesV3Property#getKeySpec}
             * @param keySpec Defines the purpose of the private key. This parameter is required.
             *                Set it to "KEY_EXCHANGE" or "SIGNATURE" value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keySpec(java.lang.String keySpec) {
                this.keySpec = keySpec;
                return this;
            }

            /**
             * Sets the value of {@link PrivateKeyAttributesV3Property#getKeyUsageProperty}
             * @param keyUsageProperty The key usage property defines the purpose of the private key contained in the certificate. This parameter is required.
             *                         You can specify specific purposes using property flags or all by using property type ALL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyUsageProperty(software.amazon.awscdk.IResolvable keyUsageProperty) {
                this.keyUsageProperty = keyUsageProperty;
                return this;
            }

            /**
             * Sets the value of {@link PrivateKeyAttributesV3Property#getKeyUsageProperty}
             * @param keyUsageProperty The key usage property defines the purpose of the private key contained in the certificate. This parameter is required.
             *                         You can specify specific purposes using property flags or all by using property type ALL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyUsageProperty(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.KeyUsagePropertyProperty keyUsageProperty) {
                this.keyUsageProperty = keyUsageProperty;
                return this;
            }

            /**
             * Sets the value of {@link PrivateKeyAttributesV3Property#getMinimalKeyLength}
             * @param minimalKeyLength Set the minimum key length of the private key. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimalKeyLength(java.lang.Number minimalKeyLength) {
                this.minimalKeyLength = minimalKeyLength;
                return this;
            }

            /**
             * Sets the value of {@link PrivateKeyAttributesV3Property#getCryptoProviders}
             * @param cryptoProviders Defines the cryptographic providers used to generate the private key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cryptoProviders(java.util.List<java.lang.String> cryptoProviders) {
                this.cryptoProviders = cryptoProviders;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrivateKeyAttributesV3Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PrivateKeyAttributesV3Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PrivateKeyAttributesV3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrivateKeyAttributesV3Property {
            private final java.lang.String algorithm;
            private final java.lang.String keySpec;
            private final java.lang.Object keyUsageProperty;
            private final java.lang.Number minimalKeyLength;
            private final java.util.List<java.lang.String> cryptoProviders;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.algorithm = software.amazon.jsii.Kernel.get(this, "algorithm", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keySpec = software.amazon.jsii.Kernel.get(this, "keySpec", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keyUsageProperty = software.amazon.jsii.Kernel.get(this, "keyUsageProperty", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.minimalKeyLength = software.amazon.jsii.Kernel.get(this, "minimalKeyLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.cryptoProviders = software.amazon.jsii.Kernel.get(this, "cryptoProviders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.algorithm = java.util.Objects.requireNonNull(builder.algorithm, "algorithm is required");
                this.keySpec = java.util.Objects.requireNonNull(builder.keySpec, "keySpec is required");
                this.keyUsageProperty = java.util.Objects.requireNonNull(builder.keyUsageProperty, "keyUsageProperty is required");
                this.minimalKeyLength = java.util.Objects.requireNonNull(builder.minimalKeyLength, "minimalKeyLength is required");
                this.cryptoProviders = builder.cryptoProviders;
            }

            @Override
            public final java.lang.String getAlgorithm() {
                return this.algorithm;
            }

            @Override
            public final java.lang.String getKeySpec() {
                return this.keySpec;
            }

            @Override
            public final java.lang.Object getKeyUsageProperty() {
                return this.keyUsageProperty;
            }

            @Override
            public final java.lang.Number getMinimalKeyLength() {
                return this.minimalKeyLength;
            }

            @Override
            public final java.util.List<java.lang.String> getCryptoProviders() {
                return this.cryptoProviders;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("algorithm", om.valueToTree(this.getAlgorithm()));
                data.set("keySpec", om.valueToTree(this.getKeySpec()));
                data.set("keyUsageProperty", om.valueToTree(this.getKeyUsageProperty()));
                data.set("minimalKeyLength", om.valueToTree(this.getMinimalKeyLength()));
                if (this.getCryptoProviders() != null) {
                    data.set("cryptoProviders", om.valueToTree(this.getCryptoProviders()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.PrivateKeyAttributesV3Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PrivateKeyAttributesV3Property.Jsii$Proxy that = (PrivateKeyAttributesV3Property.Jsii$Proxy) o;

                if (!algorithm.equals(that.algorithm)) return false;
                if (!keySpec.equals(that.keySpec)) return false;
                if (!keyUsageProperty.equals(that.keyUsageProperty)) return false;
                if (!minimalKeyLength.equals(that.minimalKeyLength)) return false;
                return this.cryptoProviders != null ? this.cryptoProviders.equals(that.cryptoProviders) : that.cryptoProviders == null;
            }

            @Override
            public final int hashCode() {
                int result = this.algorithm.hashCode();
                result = 31 * result + (this.keySpec.hashCode());
                result = 31 * result + (this.keyUsageProperty.hashCode());
                result = 31 * result + (this.minimalKeyLength.hashCode());
                result = 31 * result + (this.cryptoProviders != null ? this.cryptoProviders.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines the attributes of the private key.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pcaconnectorad.*;
     * PrivateKeyAttributesV4Property privateKeyAttributesV4Property = PrivateKeyAttributesV4Property.builder()
     *         .keySpec("keySpec")
     *         .minimalKeyLength(123)
     *         // the properties below are optional
     *         .algorithm("algorithm")
     *         .cryptoProviders(List.of("cryptoProviders"))
     *         .keyUsageProperty(KeyUsagePropertyProperty.builder()
     *                 .propertyFlags(KeyUsagePropertyFlagsProperty.builder()
     *                         .decrypt(false)
     *                         .keyAgreement(false)
     *                         .sign(false)
     *                         .build())
     *                 .propertyType("propertyType")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyattributesv4.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyattributesv4.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.PrivateKeyAttributesV4Property")
    @software.amazon.jsii.Jsii.Proxy(PrivateKeyAttributesV4Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PrivateKeyAttributesV4Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines the purpose of the private key.
         * <p>
         * Set it to "KEY_EXCHANGE" or "SIGNATURE" value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyattributesv4.html#cfn-pcaconnectorad-template-privatekeyattributesv4-keyspec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyattributesv4.html#cfn-pcaconnectorad-template-privatekeyattributesv4-keyspec</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKeySpec();

        /**
         * Set the minimum key length of the private key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyattributesv4.html#cfn-pcaconnectorad-template-privatekeyattributesv4-minimalkeylength">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyattributesv4.html#cfn-pcaconnectorad-template-privatekeyattributesv4-minimalkeylength</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinimalKeyLength();

        /**
         * Defines the algorithm used to generate the private key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyattributesv4.html#cfn-pcaconnectorad-template-privatekeyattributesv4-algorithm">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyattributesv4.html#cfn-pcaconnectorad-template-privatekeyattributesv4-algorithm</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAlgorithm() {
            return null;
        }

        /**
         * Defines the cryptographic providers used to generate the private key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyattributesv4.html#cfn-pcaconnectorad-template-privatekeyattributesv4-cryptoproviders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyattributesv4.html#cfn-pcaconnectorad-template-privatekeyattributesv4-cryptoproviders</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCryptoProviders() {
            return null;
        }

        /**
         * The key usage property defines the purpose of the private key contained in the certificate.
         * <p>
         * You can specify specific purposes using property flags or all by using property type ALL.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyattributesv4.html#cfn-pcaconnectorad-template-privatekeyattributesv4-keyusageproperty">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyattributesv4.html#cfn-pcaconnectorad-template-privatekeyattributesv4-keyusageproperty</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKeyUsageProperty() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PrivateKeyAttributesV4Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PrivateKeyAttributesV4Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PrivateKeyAttributesV4Property> {
            java.lang.String keySpec;
            java.lang.Number minimalKeyLength;
            java.lang.String algorithm;
            java.util.List<java.lang.String> cryptoProviders;
            java.lang.Object keyUsageProperty;

            /**
             * Sets the value of {@link PrivateKeyAttributesV4Property#getKeySpec}
             * @param keySpec Defines the purpose of the private key. This parameter is required.
             *                Set it to "KEY_EXCHANGE" or "SIGNATURE" value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keySpec(java.lang.String keySpec) {
                this.keySpec = keySpec;
                return this;
            }

            /**
             * Sets the value of {@link PrivateKeyAttributesV4Property#getMinimalKeyLength}
             * @param minimalKeyLength Set the minimum key length of the private key. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimalKeyLength(java.lang.Number minimalKeyLength) {
                this.minimalKeyLength = minimalKeyLength;
                return this;
            }

            /**
             * Sets the value of {@link PrivateKeyAttributesV4Property#getAlgorithm}
             * @param algorithm Defines the algorithm used to generate the private key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder algorithm(java.lang.String algorithm) {
                this.algorithm = algorithm;
                return this;
            }

            /**
             * Sets the value of {@link PrivateKeyAttributesV4Property#getCryptoProviders}
             * @param cryptoProviders Defines the cryptographic providers used to generate the private key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cryptoProviders(java.util.List<java.lang.String> cryptoProviders) {
                this.cryptoProviders = cryptoProviders;
                return this;
            }

            /**
             * Sets the value of {@link PrivateKeyAttributesV4Property#getKeyUsageProperty}
             * @param keyUsageProperty The key usage property defines the purpose of the private key contained in the certificate.
             *                         You can specify specific purposes using property flags or all by using property type ALL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyUsageProperty(software.amazon.awscdk.IResolvable keyUsageProperty) {
                this.keyUsageProperty = keyUsageProperty;
                return this;
            }

            /**
             * Sets the value of {@link PrivateKeyAttributesV4Property#getKeyUsageProperty}
             * @param keyUsageProperty The key usage property defines the purpose of the private key contained in the certificate.
             *                         You can specify specific purposes using property flags or all by using property type ALL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyUsageProperty(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.KeyUsagePropertyProperty keyUsageProperty) {
                this.keyUsageProperty = keyUsageProperty;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrivateKeyAttributesV4Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PrivateKeyAttributesV4Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PrivateKeyAttributesV4Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrivateKeyAttributesV4Property {
            private final java.lang.String keySpec;
            private final java.lang.Number minimalKeyLength;
            private final java.lang.String algorithm;
            private final java.util.List<java.lang.String> cryptoProviders;
            private final java.lang.Object keyUsageProperty;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.keySpec = software.amazon.jsii.Kernel.get(this, "keySpec", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.minimalKeyLength = software.amazon.jsii.Kernel.get(this, "minimalKeyLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.algorithm = software.amazon.jsii.Kernel.get(this, "algorithm", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cryptoProviders = software.amazon.jsii.Kernel.get(this, "cryptoProviders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.keyUsageProperty = software.amazon.jsii.Kernel.get(this, "keyUsageProperty", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.keySpec = java.util.Objects.requireNonNull(builder.keySpec, "keySpec is required");
                this.minimalKeyLength = java.util.Objects.requireNonNull(builder.minimalKeyLength, "minimalKeyLength is required");
                this.algorithm = builder.algorithm;
                this.cryptoProviders = builder.cryptoProviders;
                this.keyUsageProperty = builder.keyUsageProperty;
            }

            @Override
            public final java.lang.String getKeySpec() {
                return this.keySpec;
            }

            @Override
            public final java.lang.Number getMinimalKeyLength() {
                return this.minimalKeyLength;
            }

            @Override
            public final java.lang.String getAlgorithm() {
                return this.algorithm;
            }

            @Override
            public final java.util.List<java.lang.String> getCryptoProviders() {
                return this.cryptoProviders;
            }

            @Override
            public final java.lang.Object getKeyUsageProperty() {
                return this.keyUsageProperty;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("keySpec", om.valueToTree(this.getKeySpec()));
                data.set("minimalKeyLength", om.valueToTree(this.getMinimalKeyLength()));
                if (this.getAlgorithm() != null) {
                    data.set("algorithm", om.valueToTree(this.getAlgorithm()));
                }
                if (this.getCryptoProviders() != null) {
                    data.set("cryptoProviders", om.valueToTree(this.getCryptoProviders()));
                }
                if (this.getKeyUsageProperty() != null) {
                    data.set("keyUsageProperty", om.valueToTree(this.getKeyUsageProperty()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.PrivateKeyAttributesV4Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PrivateKeyAttributesV4Property.Jsii$Proxy that = (PrivateKeyAttributesV4Property.Jsii$Proxy) o;

                if (!keySpec.equals(that.keySpec)) return false;
                if (!minimalKeyLength.equals(that.minimalKeyLength)) return false;
                if (this.algorithm != null ? !this.algorithm.equals(that.algorithm) : that.algorithm != null) return false;
                if (this.cryptoProviders != null ? !this.cryptoProviders.equals(that.cryptoProviders) : that.cryptoProviders != null) return false;
                return this.keyUsageProperty != null ? this.keyUsageProperty.equals(that.keyUsageProperty) : that.keyUsageProperty == null;
            }

            @Override
            public final int hashCode() {
                int result = this.keySpec.hashCode();
                result = 31 * result + (this.minimalKeyLength.hashCode());
                result = 31 * result + (this.algorithm != null ? this.algorithm.hashCode() : 0);
                result = 31 * result + (this.cryptoProviders != null ? this.cryptoProviders.hashCode() : 0);
                result = 31 * result + (this.keyUsageProperty != null ? this.keyUsageProperty.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Private key flags for v2 templates specify the client compatibility, if the private key can be exported, and if user input is required when using a private key.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pcaconnectorad.*;
     * PrivateKeyFlagsV2Property privateKeyFlagsV2Property = PrivateKeyFlagsV2Property.builder()
     *         .clientVersion("clientVersion")
     *         // the properties below are optional
     *         .exportableKey(false)
     *         .strongKeyProtectionRequired(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyflagsv2.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyflagsv2.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.PrivateKeyFlagsV2Property")
    @software.amazon.jsii.Jsii.Proxy(PrivateKeyFlagsV2Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PrivateKeyFlagsV2Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines the minimum client compatibility.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyflagsv2.html#cfn-pcaconnectorad-template-privatekeyflagsv2-clientversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyflagsv2.html#cfn-pcaconnectorad-template-privatekeyflagsv2-clientversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClientVersion();

        /**
         * Allows the private key to be exported.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyflagsv2.html#cfn-pcaconnectorad-template-privatekeyflagsv2-exportablekey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyflagsv2.html#cfn-pcaconnectorad-template-privatekeyflagsv2-exportablekey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExportableKey() {
            return null;
        }

        /**
         * Require user input when using the private key for enrollment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyflagsv2.html#cfn-pcaconnectorad-template-privatekeyflagsv2-strongkeyprotectionrequired">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyflagsv2.html#cfn-pcaconnectorad-template-privatekeyflagsv2-strongkeyprotectionrequired</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStrongKeyProtectionRequired() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PrivateKeyFlagsV2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PrivateKeyFlagsV2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PrivateKeyFlagsV2Property> {
            java.lang.String clientVersion;
            java.lang.Object exportableKey;
            java.lang.Object strongKeyProtectionRequired;

            /**
             * Sets the value of {@link PrivateKeyFlagsV2Property#getClientVersion}
             * @param clientVersion Defines the minimum client compatibility. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientVersion(java.lang.String clientVersion) {
                this.clientVersion = clientVersion;
                return this;
            }

            /**
             * Sets the value of {@link PrivateKeyFlagsV2Property#getExportableKey}
             * @param exportableKey Allows the private key to be exported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exportableKey(java.lang.Boolean exportableKey) {
                this.exportableKey = exportableKey;
                return this;
            }

            /**
             * Sets the value of {@link PrivateKeyFlagsV2Property#getExportableKey}
             * @param exportableKey Allows the private key to be exported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exportableKey(software.amazon.awscdk.IResolvable exportableKey) {
                this.exportableKey = exportableKey;
                return this;
            }

            /**
             * Sets the value of {@link PrivateKeyFlagsV2Property#getStrongKeyProtectionRequired}
             * @param strongKeyProtectionRequired Require user input when using the private key for enrollment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder strongKeyProtectionRequired(java.lang.Boolean strongKeyProtectionRequired) {
                this.strongKeyProtectionRequired = strongKeyProtectionRequired;
                return this;
            }

            /**
             * Sets the value of {@link PrivateKeyFlagsV2Property#getStrongKeyProtectionRequired}
             * @param strongKeyProtectionRequired Require user input when using the private key for enrollment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder strongKeyProtectionRequired(software.amazon.awscdk.IResolvable strongKeyProtectionRequired) {
                this.strongKeyProtectionRequired = strongKeyProtectionRequired;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrivateKeyFlagsV2Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PrivateKeyFlagsV2Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PrivateKeyFlagsV2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrivateKeyFlagsV2Property {
            private final java.lang.String clientVersion;
            private final java.lang.Object exportableKey;
            private final java.lang.Object strongKeyProtectionRequired;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientVersion = software.amazon.jsii.Kernel.get(this, "clientVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.exportableKey = software.amazon.jsii.Kernel.get(this, "exportableKey", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.strongKeyProtectionRequired = software.amazon.jsii.Kernel.get(this, "strongKeyProtectionRequired", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientVersion = java.util.Objects.requireNonNull(builder.clientVersion, "clientVersion is required");
                this.exportableKey = builder.exportableKey;
                this.strongKeyProtectionRequired = builder.strongKeyProtectionRequired;
            }

            @Override
            public final java.lang.String getClientVersion() {
                return this.clientVersion;
            }

            @Override
            public final java.lang.Object getExportableKey() {
                return this.exportableKey;
            }

            @Override
            public final java.lang.Object getStrongKeyProtectionRequired() {
                return this.strongKeyProtectionRequired;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clientVersion", om.valueToTree(this.getClientVersion()));
                if (this.getExportableKey() != null) {
                    data.set("exportableKey", om.valueToTree(this.getExportableKey()));
                }
                if (this.getStrongKeyProtectionRequired() != null) {
                    data.set("strongKeyProtectionRequired", om.valueToTree(this.getStrongKeyProtectionRequired()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.PrivateKeyFlagsV2Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PrivateKeyFlagsV2Property.Jsii$Proxy that = (PrivateKeyFlagsV2Property.Jsii$Proxy) o;

                if (!clientVersion.equals(that.clientVersion)) return false;
                if (this.exportableKey != null ? !this.exportableKey.equals(that.exportableKey) : that.exportableKey != null) return false;
                return this.strongKeyProtectionRequired != null ? this.strongKeyProtectionRequired.equals(that.strongKeyProtectionRequired) : that.strongKeyProtectionRequired == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clientVersion.hashCode();
                result = 31 * result + (this.exportableKey != null ? this.exportableKey.hashCode() : 0);
                result = 31 * result + (this.strongKeyProtectionRequired != null ? this.strongKeyProtectionRequired.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Private key flags for v3 templates specify the client compatibility, if the private key can be exported, if user input is required when using a private key, and if an alternate signature algorithm should be used.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pcaconnectorad.*;
     * PrivateKeyFlagsV3Property privateKeyFlagsV3Property = PrivateKeyFlagsV3Property.builder()
     *         .clientVersion("clientVersion")
     *         // the properties below are optional
     *         .exportableKey(false)
     *         .requireAlternateSignatureAlgorithm(false)
     *         .strongKeyProtectionRequired(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyflagsv3.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyflagsv3.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.PrivateKeyFlagsV3Property")
    @software.amazon.jsii.Jsii.Proxy(PrivateKeyFlagsV3Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PrivateKeyFlagsV3Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines the minimum client compatibility.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyflagsv3.html#cfn-pcaconnectorad-template-privatekeyflagsv3-clientversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyflagsv3.html#cfn-pcaconnectorad-template-privatekeyflagsv3-clientversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClientVersion();

        /**
         * Allows the private key to be exported.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyflagsv3.html#cfn-pcaconnectorad-template-privatekeyflagsv3-exportablekey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyflagsv3.html#cfn-pcaconnectorad-template-privatekeyflagsv3-exportablekey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExportableKey() {
            return null;
        }

        /**
         * Reguires the PKCS #1 v2.1 signature format for certificates. You should verify that your CA, objects, and applications can accept this signature format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyflagsv3.html#cfn-pcaconnectorad-template-privatekeyflagsv3-requirealternatesignaturealgorithm">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyflagsv3.html#cfn-pcaconnectorad-template-privatekeyflagsv3-requirealternatesignaturealgorithm</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequireAlternateSignatureAlgorithm() {
            return null;
        }

        /**
         * Requirer user input when using the private key for enrollment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyflagsv3.html#cfn-pcaconnectorad-template-privatekeyflagsv3-strongkeyprotectionrequired">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyflagsv3.html#cfn-pcaconnectorad-template-privatekeyflagsv3-strongkeyprotectionrequired</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStrongKeyProtectionRequired() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PrivateKeyFlagsV3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PrivateKeyFlagsV3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PrivateKeyFlagsV3Property> {
            java.lang.String clientVersion;
            java.lang.Object exportableKey;
            java.lang.Object requireAlternateSignatureAlgorithm;
            java.lang.Object strongKeyProtectionRequired;

            /**
             * Sets the value of {@link PrivateKeyFlagsV3Property#getClientVersion}
             * @param clientVersion Defines the minimum client compatibility. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientVersion(java.lang.String clientVersion) {
                this.clientVersion = clientVersion;
                return this;
            }

            /**
             * Sets the value of {@link PrivateKeyFlagsV3Property#getExportableKey}
             * @param exportableKey Allows the private key to be exported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exportableKey(java.lang.Boolean exportableKey) {
                this.exportableKey = exportableKey;
                return this;
            }

            /**
             * Sets the value of {@link PrivateKeyFlagsV3Property#getExportableKey}
             * @param exportableKey Allows the private key to be exported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exportableKey(software.amazon.awscdk.IResolvable exportableKey) {
                this.exportableKey = exportableKey;
                return this;
            }

            /**
             * Sets the value of {@link PrivateKeyFlagsV3Property#getRequireAlternateSignatureAlgorithm}
             * @param requireAlternateSignatureAlgorithm Reguires the PKCS #1 v2.1 signature format for certificates. You should verify that your CA, objects, and applications can accept this signature format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireAlternateSignatureAlgorithm(java.lang.Boolean requireAlternateSignatureAlgorithm) {
                this.requireAlternateSignatureAlgorithm = requireAlternateSignatureAlgorithm;
                return this;
            }

            /**
             * Sets the value of {@link PrivateKeyFlagsV3Property#getRequireAlternateSignatureAlgorithm}
             * @param requireAlternateSignatureAlgorithm Reguires the PKCS #1 v2.1 signature format for certificates. You should verify that your CA, objects, and applications can accept this signature format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireAlternateSignatureAlgorithm(software.amazon.awscdk.IResolvable requireAlternateSignatureAlgorithm) {
                this.requireAlternateSignatureAlgorithm = requireAlternateSignatureAlgorithm;
                return this;
            }

            /**
             * Sets the value of {@link PrivateKeyFlagsV3Property#getStrongKeyProtectionRequired}
             * @param strongKeyProtectionRequired Requirer user input when using the private key for enrollment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder strongKeyProtectionRequired(java.lang.Boolean strongKeyProtectionRequired) {
                this.strongKeyProtectionRequired = strongKeyProtectionRequired;
                return this;
            }

            /**
             * Sets the value of {@link PrivateKeyFlagsV3Property#getStrongKeyProtectionRequired}
             * @param strongKeyProtectionRequired Requirer user input when using the private key for enrollment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder strongKeyProtectionRequired(software.amazon.awscdk.IResolvable strongKeyProtectionRequired) {
                this.strongKeyProtectionRequired = strongKeyProtectionRequired;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrivateKeyFlagsV3Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PrivateKeyFlagsV3Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PrivateKeyFlagsV3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrivateKeyFlagsV3Property {
            private final java.lang.String clientVersion;
            private final java.lang.Object exportableKey;
            private final java.lang.Object requireAlternateSignatureAlgorithm;
            private final java.lang.Object strongKeyProtectionRequired;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientVersion = software.amazon.jsii.Kernel.get(this, "clientVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.exportableKey = software.amazon.jsii.Kernel.get(this, "exportableKey", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.requireAlternateSignatureAlgorithm = software.amazon.jsii.Kernel.get(this, "requireAlternateSignatureAlgorithm", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.strongKeyProtectionRequired = software.amazon.jsii.Kernel.get(this, "strongKeyProtectionRequired", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientVersion = java.util.Objects.requireNonNull(builder.clientVersion, "clientVersion is required");
                this.exportableKey = builder.exportableKey;
                this.requireAlternateSignatureAlgorithm = builder.requireAlternateSignatureAlgorithm;
                this.strongKeyProtectionRequired = builder.strongKeyProtectionRequired;
            }

            @Override
            public final java.lang.String getClientVersion() {
                return this.clientVersion;
            }

            @Override
            public final java.lang.Object getExportableKey() {
                return this.exportableKey;
            }

            @Override
            public final java.lang.Object getRequireAlternateSignatureAlgorithm() {
                return this.requireAlternateSignatureAlgorithm;
            }

            @Override
            public final java.lang.Object getStrongKeyProtectionRequired() {
                return this.strongKeyProtectionRequired;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clientVersion", om.valueToTree(this.getClientVersion()));
                if (this.getExportableKey() != null) {
                    data.set("exportableKey", om.valueToTree(this.getExportableKey()));
                }
                if (this.getRequireAlternateSignatureAlgorithm() != null) {
                    data.set("requireAlternateSignatureAlgorithm", om.valueToTree(this.getRequireAlternateSignatureAlgorithm()));
                }
                if (this.getStrongKeyProtectionRequired() != null) {
                    data.set("strongKeyProtectionRequired", om.valueToTree(this.getStrongKeyProtectionRequired()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.PrivateKeyFlagsV3Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PrivateKeyFlagsV3Property.Jsii$Proxy that = (PrivateKeyFlagsV3Property.Jsii$Proxy) o;

                if (!clientVersion.equals(that.clientVersion)) return false;
                if (this.exportableKey != null ? !this.exportableKey.equals(that.exportableKey) : that.exportableKey != null) return false;
                if (this.requireAlternateSignatureAlgorithm != null ? !this.requireAlternateSignatureAlgorithm.equals(that.requireAlternateSignatureAlgorithm) : that.requireAlternateSignatureAlgorithm != null) return false;
                return this.strongKeyProtectionRequired != null ? this.strongKeyProtectionRequired.equals(that.strongKeyProtectionRequired) : that.strongKeyProtectionRequired == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clientVersion.hashCode();
                result = 31 * result + (this.exportableKey != null ? this.exportableKey.hashCode() : 0);
                result = 31 * result + (this.requireAlternateSignatureAlgorithm != null ? this.requireAlternateSignatureAlgorithm.hashCode() : 0);
                result = 31 * result + (this.strongKeyProtectionRequired != null ? this.strongKeyProtectionRequired.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Private key flags for v4 templates specify the client compatibility, if the private key can be exported, if user input is required when using a private key, if an alternate signature algorithm should be used, and if certificates are renewed using the same private key.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pcaconnectorad.*;
     * PrivateKeyFlagsV4Property privateKeyFlagsV4Property = PrivateKeyFlagsV4Property.builder()
     *         .clientVersion("clientVersion")
     *         // the properties below are optional
     *         .exportableKey(false)
     *         .requireAlternateSignatureAlgorithm(false)
     *         .requireSameKeyRenewal(false)
     *         .strongKeyProtectionRequired(false)
     *         .useLegacyProvider(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyflagsv4.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyflagsv4.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.PrivateKeyFlagsV4Property")
    @software.amazon.jsii.Jsii.Proxy(PrivateKeyFlagsV4Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PrivateKeyFlagsV4Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines the minimum client compatibility.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyflagsv4.html#cfn-pcaconnectorad-template-privatekeyflagsv4-clientversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyflagsv4.html#cfn-pcaconnectorad-template-privatekeyflagsv4-clientversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClientVersion();

        /**
         * Allows the private key to be exported.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyflagsv4.html#cfn-pcaconnectorad-template-privatekeyflagsv4-exportablekey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyflagsv4.html#cfn-pcaconnectorad-template-privatekeyflagsv4-exportablekey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExportableKey() {
            return null;
        }

        /**
         * Requires the PKCS #1 v2.1 signature format for certificates. You should verify that your CA, objects, and applications can accept this signature format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyflagsv4.html#cfn-pcaconnectorad-template-privatekeyflagsv4-requirealternatesignaturealgorithm">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyflagsv4.html#cfn-pcaconnectorad-template-privatekeyflagsv4-requirealternatesignaturealgorithm</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequireAlternateSignatureAlgorithm() {
            return null;
        }

        /**
         * Renew certificate using the same private key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyflagsv4.html#cfn-pcaconnectorad-template-privatekeyflagsv4-requiresamekeyrenewal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyflagsv4.html#cfn-pcaconnectorad-template-privatekeyflagsv4-requiresamekeyrenewal</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequireSameKeyRenewal() {
            return null;
        }

        /**
         * Require user input when using the private key for enrollment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyflagsv4.html#cfn-pcaconnectorad-template-privatekeyflagsv4-strongkeyprotectionrequired">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyflagsv4.html#cfn-pcaconnectorad-template-privatekeyflagsv4-strongkeyprotectionrequired</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStrongKeyProtectionRequired() {
            return null;
        }

        /**
         * Specifies the cryptographic service provider category used to generate private keys.
         * <p>
         * Set to TRUE to use Legacy Cryptographic Service Providers and FALSE to use Key Storage Providers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyflagsv4.html#cfn-pcaconnectorad-template-privatekeyflagsv4-uselegacyprovider">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-privatekeyflagsv4.html#cfn-pcaconnectorad-template-privatekeyflagsv4-uselegacyprovider</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseLegacyProvider() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PrivateKeyFlagsV4Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PrivateKeyFlagsV4Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PrivateKeyFlagsV4Property> {
            java.lang.String clientVersion;
            java.lang.Object exportableKey;
            java.lang.Object requireAlternateSignatureAlgorithm;
            java.lang.Object requireSameKeyRenewal;
            java.lang.Object strongKeyProtectionRequired;
            java.lang.Object useLegacyProvider;

            /**
             * Sets the value of {@link PrivateKeyFlagsV4Property#getClientVersion}
             * @param clientVersion Defines the minimum client compatibility. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientVersion(java.lang.String clientVersion) {
                this.clientVersion = clientVersion;
                return this;
            }

            /**
             * Sets the value of {@link PrivateKeyFlagsV4Property#getExportableKey}
             * @param exportableKey Allows the private key to be exported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exportableKey(java.lang.Boolean exportableKey) {
                this.exportableKey = exportableKey;
                return this;
            }

            /**
             * Sets the value of {@link PrivateKeyFlagsV4Property#getExportableKey}
             * @param exportableKey Allows the private key to be exported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exportableKey(software.amazon.awscdk.IResolvable exportableKey) {
                this.exportableKey = exportableKey;
                return this;
            }

            /**
             * Sets the value of {@link PrivateKeyFlagsV4Property#getRequireAlternateSignatureAlgorithm}
             * @param requireAlternateSignatureAlgorithm Requires the PKCS #1 v2.1 signature format for certificates. You should verify that your CA, objects, and applications can accept this signature format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireAlternateSignatureAlgorithm(java.lang.Boolean requireAlternateSignatureAlgorithm) {
                this.requireAlternateSignatureAlgorithm = requireAlternateSignatureAlgorithm;
                return this;
            }

            /**
             * Sets the value of {@link PrivateKeyFlagsV4Property#getRequireAlternateSignatureAlgorithm}
             * @param requireAlternateSignatureAlgorithm Requires the PKCS #1 v2.1 signature format for certificates. You should verify that your CA, objects, and applications can accept this signature format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireAlternateSignatureAlgorithm(software.amazon.awscdk.IResolvable requireAlternateSignatureAlgorithm) {
                this.requireAlternateSignatureAlgorithm = requireAlternateSignatureAlgorithm;
                return this;
            }

            /**
             * Sets the value of {@link PrivateKeyFlagsV4Property#getRequireSameKeyRenewal}
             * @param requireSameKeyRenewal Renew certificate using the same private key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireSameKeyRenewal(java.lang.Boolean requireSameKeyRenewal) {
                this.requireSameKeyRenewal = requireSameKeyRenewal;
                return this;
            }

            /**
             * Sets the value of {@link PrivateKeyFlagsV4Property#getRequireSameKeyRenewal}
             * @param requireSameKeyRenewal Renew certificate using the same private key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireSameKeyRenewal(software.amazon.awscdk.IResolvable requireSameKeyRenewal) {
                this.requireSameKeyRenewal = requireSameKeyRenewal;
                return this;
            }

            /**
             * Sets the value of {@link PrivateKeyFlagsV4Property#getStrongKeyProtectionRequired}
             * @param strongKeyProtectionRequired Require user input when using the private key for enrollment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder strongKeyProtectionRequired(java.lang.Boolean strongKeyProtectionRequired) {
                this.strongKeyProtectionRequired = strongKeyProtectionRequired;
                return this;
            }

            /**
             * Sets the value of {@link PrivateKeyFlagsV4Property#getStrongKeyProtectionRequired}
             * @param strongKeyProtectionRequired Require user input when using the private key for enrollment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder strongKeyProtectionRequired(software.amazon.awscdk.IResolvable strongKeyProtectionRequired) {
                this.strongKeyProtectionRequired = strongKeyProtectionRequired;
                return this;
            }

            /**
             * Sets the value of {@link PrivateKeyFlagsV4Property#getUseLegacyProvider}
             * @param useLegacyProvider Specifies the cryptographic service provider category used to generate private keys.
             *                          Set to TRUE to use Legacy Cryptographic Service Providers and FALSE to use Key Storage Providers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useLegacyProvider(java.lang.Boolean useLegacyProvider) {
                this.useLegacyProvider = useLegacyProvider;
                return this;
            }

            /**
             * Sets the value of {@link PrivateKeyFlagsV4Property#getUseLegacyProvider}
             * @param useLegacyProvider Specifies the cryptographic service provider category used to generate private keys.
             *                          Set to TRUE to use Legacy Cryptographic Service Providers and FALSE to use Key Storage Providers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useLegacyProvider(software.amazon.awscdk.IResolvable useLegacyProvider) {
                this.useLegacyProvider = useLegacyProvider;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrivateKeyFlagsV4Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PrivateKeyFlagsV4Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PrivateKeyFlagsV4Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrivateKeyFlagsV4Property {
            private final java.lang.String clientVersion;
            private final java.lang.Object exportableKey;
            private final java.lang.Object requireAlternateSignatureAlgorithm;
            private final java.lang.Object requireSameKeyRenewal;
            private final java.lang.Object strongKeyProtectionRequired;
            private final java.lang.Object useLegacyProvider;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientVersion = software.amazon.jsii.Kernel.get(this, "clientVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.exportableKey = software.amazon.jsii.Kernel.get(this, "exportableKey", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.requireAlternateSignatureAlgorithm = software.amazon.jsii.Kernel.get(this, "requireAlternateSignatureAlgorithm", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.requireSameKeyRenewal = software.amazon.jsii.Kernel.get(this, "requireSameKeyRenewal", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.strongKeyProtectionRequired = software.amazon.jsii.Kernel.get(this, "strongKeyProtectionRequired", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.useLegacyProvider = software.amazon.jsii.Kernel.get(this, "useLegacyProvider", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientVersion = java.util.Objects.requireNonNull(builder.clientVersion, "clientVersion is required");
                this.exportableKey = builder.exportableKey;
                this.requireAlternateSignatureAlgorithm = builder.requireAlternateSignatureAlgorithm;
                this.requireSameKeyRenewal = builder.requireSameKeyRenewal;
                this.strongKeyProtectionRequired = builder.strongKeyProtectionRequired;
                this.useLegacyProvider = builder.useLegacyProvider;
            }

            @Override
            public final java.lang.String getClientVersion() {
                return this.clientVersion;
            }

            @Override
            public final java.lang.Object getExportableKey() {
                return this.exportableKey;
            }

            @Override
            public final java.lang.Object getRequireAlternateSignatureAlgorithm() {
                return this.requireAlternateSignatureAlgorithm;
            }

            @Override
            public final java.lang.Object getRequireSameKeyRenewal() {
                return this.requireSameKeyRenewal;
            }

            @Override
            public final java.lang.Object getStrongKeyProtectionRequired() {
                return this.strongKeyProtectionRequired;
            }

            @Override
            public final java.lang.Object getUseLegacyProvider() {
                return this.useLegacyProvider;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clientVersion", om.valueToTree(this.getClientVersion()));
                if (this.getExportableKey() != null) {
                    data.set("exportableKey", om.valueToTree(this.getExportableKey()));
                }
                if (this.getRequireAlternateSignatureAlgorithm() != null) {
                    data.set("requireAlternateSignatureAlgorithm", om.valueToTree(this.getRequireAlternateSignatureAlgorithm()));
                }
                if (this.getRequireSameKeyRenewal() != null) {
                    data.set("requireSameKeyRenewal", om.valueToTree(this.getRequireSameKeyRenewal()));
                }
                if (this.getStrongKeyProtectionRequired() != null) {
                    data.set("strongKeyProtectionRequired", om.valueToTree(this.getStrongKeyProtectionRequired()));
                }
                if (this.getUseLegacyProvider() != null) {
                    data.set("useLegacyProvider", om.valueToTree(this.getUseLegacyProvider()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.PrivateKeyFlagsV4Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PrivateKeyFlagsV4Property.Jsii$Proxy that = (PrivateKeyFlagsV4Property.Jsii$Proxy) o;

                if (!clientVersion.equals(that.clientVersion)) return false;
                if (this.exportableKey != null ? !this.exportableKey.equals(that.exportableKey) : that.exportableKey != null) return false;
                if (this.requireAlternateSignatureAlgorithm != null ? !this.requireAlternateSignatureAlgorithm.equals(that.requireAlternateSignatureAlgorithm) : that.requireAlternateSignatureAlgorithm != null) return false;
                if (this.requireSameKeyRenewal != null ? !this.requireSameKeyRenewal.equals(that.requireSameKeyRenewal) : that.requireSameKeyRenewal != null) return false;
                if (this.strongKeyProtectionRequired != null ? !this.strongKeyProtectionRequired.equals(that.strongKeyProtectionRequired) : that.strongKeyProtectionRequired != null) return false;
                return this.useLegacyProvider != null ? this.useLegacyProvider.equals(that.useLegacyProvider) : that.useLegacyProvider == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clientVersion.hashCode();
                result = 31 * result + (this.exportableKey != null ? this.exportableKey.hashCode() : 0);
                result = 31 * result + (this.requireAlternateSignatureAlgorithm != null ? this.requireAlternateSignatureAlgorithm.hashCode() : 0);
                result = 31 * result + (this.requireSameKeyRenewal != null ? this.requireSameKeyRenewal.hashCode() : 0);
                result = 31 * result + (this.strongKeyProtectionRequired != null ? this.strongKeyProtectionRequired.hashCode() : 0);
                result = 31 * result + (this.useLegacyProvider != null ? this.useLegacyProvider.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information to include in the subject name and alternate subject name of the certificate.
     * <p>
     * The subject name can be common name, directory path, DNS as common name, or left blank. You can optionally include email to the subject name for user templates. If you leave the subject name blank then you must set a subject alternate name. The subject alternate name (SAN) can include globally unique identifier (GUID), DNS, domain DNS, email, service principal name (SPN), and user principal name (UPN). You can leave the SAN blank. If you leave the SAN blank, then you must set a subject name.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pcaconnectorad.*;
     * SubjectNameFlagsV2Property subjectNameFlagsV2Property = SubjectNameFlagsV2Property.builder()
     *         .requireCommonName(false)
     *         .requireDirectoryPath(false)
     *         .requireDnsAsCn(false)
     *         .requireEmail(false)
     *         .sanRequireDirectoryGuid(false)
     *         .sanRequireDns(false)
     *         .sanRequireDomainDns(false)
     *         .sanRequireEmail(false)
     *         .sanRequireSpn(false)
     *         .sanRequireUpn(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv2.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv2.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.SubjectNameFlagsV2Property")
    @software.amazon.jsii.Jsii.Proxy(SubjectNameFlagsV2Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SubjectNameFlagsV2Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * Include the common name in the subject name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv2.html#cfn-pcaconnectorad-template-subjectnameflagsv2-requirecommonname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv2.html#cfn-pcaconnectorad-template-subjectnameflagsv2-requirecommonname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequireCommonName() {
            return null;
        }

        /**
         * Include the directory path in the subject name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv2.html#cfn-pcaconnectorad-template-subjectnameflagsv2-requiredirectorypath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv2.html#cfn-pcaconnectorad-template-subjectnameflagsv2-requiredirectorypath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequireDirectoryPath() {
            return null;
        }

        /**
         * Include the DNS as common name in the subject name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv2.html#cfn-pcaconnectorad-template-subjectnameflagsv2-requirednsascn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv2.html#cfn-pcaconnectorad-template-subjectnameflagsv2-requirednsascn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequireDnsAsCn() {
            return null;
        }

        /**
         * Include the subject's email in the subject name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv2.html#cfn-pcaconnectorad-template-subjectnameflagsv2-requireemail">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv2.html#cfn-pcaconnectorad-template-subjectnameflagsv2-requireemail</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequireEmail() {
            return null;
        }

        /**
         * Include the globally unique identifier (GUID) in the subject alternate name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv2.html#cfn-pcaconnectorad-template-subjectnameflagsv2-sanrequiredirectoryguid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv2.html#cfn-pcaconnectorad-template-subjectnameflagsv2-sanrequiredirectoryguid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSanRequireDirectoryGuid() {
            return null;
        }

        /**
         * Include the DNS in the subject alternate name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv2.html#cfn-pcaconnectorad-template-subjectnameflagsv2-sanrequiredns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv2.html#cfn-pcaconnectorad-template-subjectnameflagsv2-sanrequiredns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSanRequireDns() {
            return null;
        }

        /**
         * Include the domain DNS in the subject alternate name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv2.html#cfn-pcaconnectorad-template-subjectnameflagsv2-sanrequiredomaindns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv2.html#cfn-pcaconnectorad-template-subjectnameflagsv2-sanrequiredomaindns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSanRequireDomainDns() {
            return null;
        }

        /**
         * Include the subject's email in the subject alternate name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv2.html#cfn-pcaconnectorad-template-subjectnameflagsv2-sanrequireemail">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv2.html#cfn-pcaconnectorad-template-subjectnameflagsv2-sanrequireemail</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSanRequireEmail() {
            return null;
        }

        /**
         * Include the service principal name (SPN) in the subject alternate name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv2.html#cfn-pcaconnectorad-template-subjectnameflagsv2-sanrequirespn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv2.html#cfn-pcaconnectorad-template-subjectnameflagsv2-sanrequirespn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSanRequireSpn() {
            return null;
        }

        /**
         * Include the user principal name (UPN) in the subject alternate name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv2.html#cfn-pcaconnectorad-template-subjectnameflagsv2-sanrequireupn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv2.html#cfn-pcaconnectorad-template-subjectnameflagsv2-sanrequireupn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSanRequireUpn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SubjectNameFlagsV2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SubjectNameFlagsV2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SubjectNameFlagsV2Property> {
            java.lang.Object requireCommonName;
            java.lang.Object requireDirectoryPath;
            java.lang.Object requireDnsAsCn;
            java.lang.Object requireEmail;
            java.lang.Object sanRequireDirectoryGuid;
            java.lang.Object sanRequireDns;
            java.lang.Object sanRequireDomainDns;
            java.lang.Object sanRequireEmail;
            java.lang.Object sanRequireSpn;
            java.lang.Object sanRequireUpn;

            /**
             * Sets the value of {@link SubjectNameFlagsV2Property#getRequireCommonName}
             * @param requireCommonName Include the common name in the subject name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireCommonName(java.lang.Boolean requireCommonName) {
                this.requireCommonName = requireCommonName;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV2Property#getRequireCommonName}
             * @param requireCommonName Include the common name in the subject name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireCommonName(software.amazon.awscdk.IResolvable requireCommonName) {
                this.requireCommonName = requireCommonName;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV2Property#getRequireDirectoryPath}
             * @param requireDirectoryPath Include the directory path in the subject name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireDirectoryPath(java.lang.Boolean requireDirectoryPath) {
                this.requireDirectoryPath = requireDirectoryPath;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV2Property#getRequireDirectoryPath}
             * @param requireDirectoryPath Include the directory path in the subject name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireDirectoryPath(software.amazon.awscdk.IResolvable requireDirectoryPath) {
                this.requireDirectoryPath = requireDirectoryPath;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV2Property#getRequireDnsAsCn}
             * @param requireDnsAsCn Include the DNS as common name in the subject name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireDnsAsCn(java.lang.Boolean requireDnsAsCn) {
                this.requireDnsAsCn = requireDnsAsCn;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV2Property#getRequireDnsAsCn}
             * @param requireDnsAsCn Include the DNS as common name in the subject name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireDnsAsCn(software.amazon.awscdk.IResolvable requireDnsAsCn) {
                this.requireDnsAsCn = requireDnsAsCn;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV2Property#getRequireEmail}
             * @param requireEmail Include the subject's email in the subject name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireEmail(java.lang.Boolean requireEmail) {
                this.requireEmail = requireEmail;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV2Property#getRequireEmail}
             * @param requireEmail Include the subject's email in the subject name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireEmail(software.amazon.awscdk.IResolvable requireEmail) {
                this.requireEmail = requireEmail;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV2Property#getSanRequireDirectoryGuid}
             * @param sanRequireDirectoryGuid Include the globally unique identifier (GUID) in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireDirectoryGuid(java.lang.Boolean sanRequireDirectoryGuid) {
                this.sanRequireDirectoryGuid = sanRequireDirectoryGuid;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV2Property#getSanRequireDirectoryGuid}
             * @param sanRequireDirectoryGuid Include the globally unique identifier (GUID) in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireDirectoryGuid(software.amazon.awscdk.IResolvable sanRequireDirectoryGuid) {
                this.sanRequireDirectoryGuid = sanRequireDirectoryGuid;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV2Property#getSanRequireDns}
             * @param sanRequireDns Include the DNS in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireDns(java.lang.Boolean sanRequireDns) {
                this.sanRequireDns = sanRequireDns;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV2Property#getSanRequireDns}
             * @param sanRequireDns Include the DNS in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireDns(software.amazon.awscdk.IResolvable sanRequireDns) {
                this.sanRequireDns = sanRequireDns;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV2Property#getSanRequireDomainDns}
             * @param sanRequireDomainDns Include the domain DNS in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireDomainDns(java.lang.Boolean sanRequireDomainDns) {
                this.sanRequireDomainDns = sanRequireDomainDns;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV2Property#getSanRequireDomainDns}
             * @param sanRequireDomainDns Include the domain DNS in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireDomainDns(software.amazon.awscdk.IResolvable sanRequireDomainDns) {
                this.sanRequireDomainDns = sanRequireDomainDns;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV2Property#getSanRequireEmail}
             * @param sanRequireEmail Include the subject's email in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireEmail(java.lang.Boolean sanRequireEmail) {
                this.sanRequireEmail = sanRequireEmail;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV2Property#getSanRequireEmail}
             * @param sanRequireEmail Include the subject's email in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireEmail(software.amazon.awscdk.IResolvable sanRequireEmail) {
                this.sanRequireEmail = sanRequireEmail;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV2Property#getSanRequireSpn}
             * @param sanRequireSpn Include the service principal name (SPN) in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireSpn(java.lang.Boolean sanRequireSpn) {
                this.sanRequireSpn = sanRequireSpn;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV2Property#getSanRequireSpn}
             * @param sanRequireSpn Include the service principal name (SPN) in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireSpn(software.amazon.awscdk.IResolvable sanRequireSpn) {
                this.sanRequireSpn = sanRequireSpn;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV2Property#getSanRequireUpn}
             * @param sanRequireUpn Include the user principal name (UPN) in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireUpn(java.lang.Boolean sanRequireUpn) {
                this.sanRequireUpn = sanRequireUpn;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV2Property#getSanRequireUpn}
             * @param sanRequireUpn Include the user principal name (UPN) in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireUpn(software.amazon.awscdk.IResolvable sanRequireUpn) {
                this.sanRequireUpn = sanRequireUpn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SubjectNameFlagsV2Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SubjectNameFlagsV2Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SubjectNameFlagsV2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubjectNameFlagsV2Property {
            private final java.lang.Object requireCommonName;
            private final java.lang.Object requireDirectoryPath;
            private final java.lang.Object requireDnsAsCn;
            private final java.lang.Object requireEmail;
            private final java.lang.Object sanRequireDirectoryGuid;
            private final java.lang.Object sanRequireDns;
            private final java.lang.Object sanRequireDomainDns;
            private final java.lang.Object sanRequireEmail;
            private final java.lang.Object sanRequireSpn;
            private final java.lang.Object sanRequireUpn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.requireCommonName = software.amazon.jsii.Kernel.get(this, "requireCommonName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.requireDirectoryPath = software.amazon.jsii.Kernel.get(this, "requireDirectoryPath", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.requireDnsAsCn = software.amazon.jsii.Kernel.get(this, "requireDnsAsCn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.requireEmail = software.amazon.jsii.Kernel.get(this, "requireEmail", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sanRequireDirectoryGuid = software.amazon.jsii.Kernel.get(this, "sanRequireDirectoryGuid", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sanRequireDns = software.amazon.jsii.Kernel.get(this, "sanRequireDns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sanRequireDomainDns = software.amazon.jsii.Kernel.get(this, "sanRequireDomainDns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sanRequireEmail = software.amazon.jsii.Kernel.get(this, "sanRequireEmail", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sanRequireSpn = software.amazon.jsii.Kernel.get(this, "sanRequireSpn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sanRequireUpn = software.amazon.jsii.Kernel.get(this, "sanRequireUpn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.requireCommonName = builder.requireCommonName;
                this.requireDirectoryPath = builder.requireDirectoryPath;
                this.requireDnsAsCn = builder.requireDnsAsCn;
                this.requireEmail = builder.requireEmail;
                this.sanRequireDirectoryGuid = builder.sanRequireDirectoryGuid;
                this.sanRequireDns = builder.sanRequireDns;
                this.sanRequireDomainDns = builder.sanRequireDomainDns;
                this.sanRequireEmail = builder.sanRequireEmail;
                this.sanRequireSpn = builder.sanRequireSpn;
                this.sanRequireUpn = builder.sanRequireUpn;
            }

            @Override
            public final java.lang.Object getRequireCommonName() {
                return this.requireCommonName;
            }

            @Override
            public final java.lang.Object getRequireDirectoryPath() {
                return this.requireDirectoryPath;
            }

            @Override
            public final java.lang.Object getRequireDnsAsCn() {
                return this.requireDnsAsCn;
            }

            @Override
            public final java.lang.Object getRequireEmail() {
                return this.requireEmail;
            }

            @Override
            public final java.lang.Object getSanRequireDirectoryGuid() {
                return this.sanRequireDirectoryGuid;
            }

            @Override
            public final java.lang.Object getSanRequireDns() {
                return this.sanRequireDns;
            }

            @Override
            public final java.lang.Object getSanRequireDomainDns() {
                return this.sanRequireDomainDns;
            }

            @Override
            public final java.lang.Object getSanRequireEmail() {
                return this.sanRequireEmail;
            }

            @Override
            public final java.lang.Object getSanRequireSpn() {
                return this.sanRequireSpn;
            }

            @Override
            public final java.lang.Object getSanRequireUpn() {
                return this.sanRequireUpn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRequireCommonName() != null) {
                    data.set("requireCommonName", om.valueToTree(this.getRequireCommonName()));
                }
                if (this.getRequireDirectoryPath() != null) {
                    data.set("requireDirectoryPath", om.valueToTree(this.getRequireDirectoryPath()));
                }
                if (this.getRequireDnsAsCn() != null) {
                    data.set("requireDnsAsCn", om.valueToTree(this.getRequireDnsAsCn()));
                }
                if (this.getRequireEmail() != null) {
                    data.set("requireEmail", om.valueToTree(this.getRequireEmail()));
                }
                if (this.getSanRequireDirectoryGuid() != null) {
                    data.set("sanRequireDirectoryGuid", om.valueToTree(this.getSanRequireDirectoryGuid()));
                }
                if (this.getSanRequireDns() != null) {
                    data.set("sanRequireDns", om.valueToTree(this.getSanRequireDns()));
                }
                if (this.getSanRequireDomainDns() != null) {
                    data.set("sanRequireDomainDns", om.valueToTree(this.getSanRequireDomainDns()));
                }
                if (this.getSanRequireEmail() != null) {
                    data.set("sanRequireEmail", om.valueToTree(this.getSanRequireEmail()));
                }
                if (this.getSanRequireSpn() != null) {
                    data.set("sanRequireSpn", om.valueToTree(this.getSanRequireSpn()));
                }
                if (this.getSanRequireUpn() != null) {
                    data.set("sanRequireUpn", om.valueToTree(this.getSanRequireUpn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.SubjectNameFlagsV2Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SubjectNameFlagsV2Property.Jsii$Proxy that = (SubjectNameFlagsV2Property.Jsii$Proxy) o;

                if (this.requireCommonName != null ? !this.requireCommonName.equals(that.requireCommonName) : that.requireCommonName != null) return false;
                if (this.requireDirectoryPath != null ? !this.requireDirectoryPath.equals(that.requireDirectoryPath) : that.requireDirectoryPath != null) return false;
                if (this.requireDnsAsCn != null ? !this.requireDnsAsCn.equals(that.requireDnsAsCn) : that.requireDnsAsCn != null) return false;
                if (this.requireEmail != null ? !this.requireEmail.equals(that.requireEmail) : that.requireEmail != null) return false;
                if (this.sanRequireDirectoryGuid != null ? !this.sanRequireDirectoryGuid.equals(that.sanRequireDirectoryGuid) : that.sanRequireDirectoryGuid != null) return false;
                if (this.sanRequireDns != null ? !this.sanRequireDns.equals(that.sanRequireDns) : that.sanRequireDns != null) return false;
                if (this.sanRequireDomainDns != null ? !this.sanRequireDomainDns.equals(that.sanRequireDomainDns) : that.sanRequireDomainDns != null) return false;
                if (this.sanRequireEmail != null ? !this.sanRequireEmail.equals(that.sanRequireEmail) : that.sanRequireEmail != null) return false;
                if (this.sanRequireSpn != null ? !this.sanRequireSpn.equals(that.sanRequireSpn) : that.sanRequireSpn != null) return false;
                return this.sanRequireUpn != null ? this.sanRequireUpn.equals(that.sanRequireUpn) : that.sanRequireUpn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.requireCommonName != null ? this.requireCommonName.hashCode() : 0;
                result = 31 * result + (this.requireDirectoryPath != null ? this.requireDirectoryPath.hashCode() : 0);
                result = 31 * result + (this.requireDnsAsCn != null ? this.requireDnsAsCn.hashCode() : 0);
                result = 31 * result + (this.requireEmail != null ? this.requireEmail.hashCode() : 0);
                result = 31 * result + (this.sanRequireDirectoryGuid != null ? this.sanRequireDirectoryGuid.hashCode() : 0);
                result = 31 * result + (this.sanRequireDns != null ? this.sanRequireDns.hashCode() : 0);
                result = 31 * result + (this.sanRequireDomainDns != null ? this.sanRequireDomainDns.hashCode() : 0);
                result = 31 * result + (this.sanRequireEmail != null ? this.sanRequireEmail.hashCode() : 0);
                result = 31 * result + (this.sanRequireSpn != null ? this.sanRequireSpn.hashCode() : 0);
                result = 31 * result + (this.sanRequireUpn != null ? this.sanRequireUpn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information to include in the subject name and alternate subject name of the certificate.
     * <p>
     * The subject name can be common name, directory path, DNS as common name, or left blank. You can optionally include email to the subject name for user templates. If you leave the subject name blank then you must set a subject alternate name. The subject alternate name (SAN) can include globally unique identifier (GUID), DNS, domain DNS, email, service principal name (SPN), and user principal name (UPN). You can leave the SAN blank. If you leave the SAN blank, then you must set a subject name.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pcaconnectorad.*;
     * SubjectNameFlagsV3Property subjectNameFlagsV3Property = SubjectNameFlagsV3Property.builder()
     *         .requireCommonName(false)
     *         .requireDirectoryPath(false)
     *         .requireDnsAsCn(false)
     *         .requireEmail(false)
     *         .sanRequireDirectoryGuid(false)
     *         .sanRequireDns(false)
     *         .sanRequireDomainDns(false)
     *         .sanRequireEmail(false)
     *         .sanRequireSpn(false)
     *         .sanRequireUpn(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv3.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv3.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.SubjectNameFlagsV3Property")
    @software.amazon.jsii.Jsii.Proxy(SubjectNameFlagsV3Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SubjectNameFlagsV3Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * Include the common name in the subject name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv3.html#cfn-pcaconnectorad-template-subjectnameflagsv3-requirecommonname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv3.html#cfn-pcaconnectorad-template-subjectnameflagsv3-requirecommonname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequireCommonName() {
            return null;
        }

        /**
         * Include the directory path in the subject name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv3.html#cfn-pcaconnectorad-template-subjectnameflagsv3-requiredirectorypath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv3.html#cfn-pcaconnectorad-template-subjectnameflagsv3-requiredirectorypath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequireDirectoryPath() {
            return null;
        }

        /**
         * Include the DNS as common name in the subject name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv3.html#cfn-pcaconnectorad-template-subjectnameflagsv3-requirednsascn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv3.html#cfn-pcaconnectorad-template-subjectnameflagsv3-requirednsascn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequireDnsAsCn() {
            return null;
        }

        /**
         * Include the subject's email in the subject name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv3.html#cfn-pcaconnectorad-template-subjectnameflagsv3-requireemail">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv3.html#cfn-pcaconnectorad-template-subjectnameflagsv3-requireemail</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequireEmail() {
            return null;
        }

        /**
         * Include the globally unique identifier (GUID) in the subject alternate name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv3.html#cfn-pcaconnectorad-template-subjectnameflagsv3-sanrequiredirectoryguid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv3.html#cfn-pcaconnectorad-template-subjectnameflagsv3-sanrequiredirectoryguid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSanRequireDirectoryGuid() {
            return null;
        }

        /**
         * Include the DNS in the subject alternate name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv3.html#cfn-pcaconnectorad-template-subjectnameflagsv3-sanrequiredns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv3.html#cfn-pcaconnectorad-template-subjectnameflagsv3-sanrequiredns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSanRequireDns() {
            return null;
        }

        /**
         * Include the domain DNS in the subject alternate name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv3.html#cfn-pcaconnectorad-template-subjectnameflagsv3-sanrequiredomaindns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv3.html#cfn-pcaconnectorad-template-subjectnameflagsv3-sanrequiredomaindns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSanRequireDomainDns() {
            return null;
        }

        /**
         * Include the subject's email in the subject alternate name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv3.html#cfn-pcaconnectorad-template-subjectnameflagsv3-sanrequireemail">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv3.html#cfn-pcaconnectorad-template-subjectnameflagsv3-sanrequireemail</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSanRequireEmail() {
            return null;
        }

        /**
         * Include the service principal name (SPN) in the subject alternate name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv3.html#cfn-pcaconnectorad-template-subjectnameflagsv3-sanrequirespn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv3.html#cfn-pcaconnectorad-template-subjectnameflagsv3-sanrequirespn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSanRequireSpn() {
            return null;
        }

        /**
         * Include the user principal name (UPN) in the subject alternate name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv3.html#cfn-pcaconnectorad-template-subjectnameflagsv3-sanrequireupn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv3.html#cfn-pcaconnectorad-template-subjectnameflagsv3-sanrequireupn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSanRequireUpn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SubjectNameFlagsV3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SubjectNameFlagsV3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SubjectNameFlagsV3Property> {
            java.lang.Object requireCommonName;
            java.lang.Object requireDirectoryPath;
            java.lang.Object requireDnsAsCn;
            java.lang.Object requireEmail;
            java.lang.Object sanRequireDirectoryGuid;
            java.lang.Object sanRequireDns;
            java.lang.Object sanRequireDomainDns;
            java.lang.Object sanRequireEmail;
            java.lang.Object sanRequireSpn;
            java.lang.Object sanRequireUpn;

            /**
             * Sets the value of {@link SubjectNameFlagsV3Property#getRequireCommonName}
             * @param requireCommonName Include the common name in the subject name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireCommonName(java.lang.Boolean requireCommonName) {
                this.requireCommonName = requireCommonName;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV3Property#getRequireCommonName}
             * @param requireCommonName Include the common name in the subject name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireCommonName(software.amazon.awscdk.IResolvable requireCommonName) {
                this.requireCommonName = requireCommonName;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV3Property#getRequireDirectoryPath}
             * @param requireDirectoryPath Include the directory path in the subject name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireDirectoryPath(java.lang.Boolean requireDirectoryPath) {
                this.requireDirectoryPath = requireDirectoryPath;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV3Property#getRequireDirectoryPath}
             * @param requireDirectoryPath Include the directory path in the subject name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireDirectoryPath(software.amazon.awscdk.IResolvable requireDirectoryPath) {
                this.requireDirectoryPath = requireDirectoryPath;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV3Property#getRequireDnsAsCn}
             * @param requireDnsAsCn Include the DNS as common name in the subject name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireDnsAsCn(java.lang.Boolean requireDnsAsCn) {
                this.requireDnsAsCn = requireDnsAsCn;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV3Property#getRequireDnsAsCn}
             * @param requireDnsAsCn Include the DNS as common name in the subject name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireDnsAsCn(software.amazon.awscdk.IResolvable requireDnsAsCn) {
                this.requireDnsAsCn = requireDnsAsCn;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV3Property#getRequireEmail}
             * @param requireEmail Include the subject's email in the subject name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireEmail(java.lang.Boolean requireEmail) {
                this.requireEmail = requireEmail;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV3Property#getRequireEmail}
             * @param requireEmail Include the subject's email in the subject name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireEmail(software.amazon.awscdk.IResolvable requireEmail) {
                this.requireEmail = requireEmail;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV3Property#getSanRequireDirectoryGuid}
             * @param sanRequireDirectoryGuid Include the globally unique identifier (GUID) in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireDirectoryGuid(java.lang.Boolean sanRequireDirectoryGuid) {
                this.sanRequireDirectoryGuid = sanRequireDirectoryGuid;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV3Property#getSanRequireDirectoryGuid}
             * @param sanRequireDirectoryGuid Include the globally unique identifier (GUID) in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireDirectoryGuid(software.amazon.awscdk.IResolvable sanRequireDirectoryGuid) {
                this.sanRequireDirectoryGuid = sanRequireDirectoryGuid;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV3Property#getSanRequireDns}
             * @param sanRequireDns Include the DNS in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireDns(java.lang.Boolean sanRequireDns) {
                this.sanRequireDns = sanRequireDns;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV3Property#getSanRequireDns}
             * @param sanRequireDns Include the DNS in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireDns(software.amazon.awscdk.IResolvable sanRequireDns) {
                this.sanRequireDns = sanRequireDns;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV3Property#getSanRequireDomainDns}
             * @param sanRequireDomainDns Include the domain DNS in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireDomainDns(java.lang.Boolean sanRequireDomainDns) {
                this.sanRequireDomainDns = sanRequireDomainDns;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV3Property#getSanRequireDomainDns}
             * @param sanRequireDomainDns Include the domain DNS in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireDomainDns(software.amazon.awscdk.IResolvable sanRequireDomainDns) {
                this.sanRequireDomainDns = sanRequireDomainDns;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV3Property#getSanRequireEmail}
             * @param sanRequireEmail Include the subject's email in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireEmail(java.lang.Boolean sanRequireEmail) {
                this.sanRequireEmail = sanRequireEmail;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV3Property#getSanRequireEmail}
             * @param sanRequireEmail Include the subject's email in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireEmail(software.amazon.awscdk.IResolvable sanRequireEmail) {
                this.sanRequireEmail = sanRequireEmail;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV3Property#getSanRequireSpn}
             * @param sanRequireSpn Include the service principal name (SPN) in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireSpn(java.lang.Boolean sanRequireSpn) {
                this.sanRequireSpn = sanRequireSpn;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV3Property#getSanRequireSpn}
             * @param sanRequireSpn Include the service principal name (SPN) in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireSpn(software.amazon.awscdk.IResolvable sanRequireSpn) {
                this.sanRequireSpn = sanRequireSpn;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV3Property#getSanRequireUpn}
             * @param sanRequireUpn Include the user principal name (UPN) in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireUpn(java.lang.Boolean sanRequireUpn) {
                this.sanRequireUpn = sanRequireUpn;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV3Property#getSanRequireUpn}
             * @param sanRequireUpn Include the user principal name (UPN) in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireUpn(software.amazon.awscdk.IResolvable sanRequireUpn) {
                this.sanRequireUpn = sanRequireUpn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SubjectNameFlagsV3Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SubjectNameFlagsV3Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SubjectNameFlagsV3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubjectNameFlagsV3Property {
            private final java.lang.Object requireCommonName;
            private final java.lang.Object requireDirectoryPath;
            private final java.lang.Object requireDnsAsCn;
            private final java.lang.Object requireEmail;
            private final java.lang.Object sanRequireDirectoryGuid;
            private final java.lang.Object sanRequireDns;
            private final java.lang.Object sanRequireDomainDns;
            private final java.lang.Object sanRequireEmail;
            private final java.lang.Object sanRequireSpn;
            private final java.lang.Object sanRequireUpn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.requireCommonName = software.amazon.jsii.Kernel.get(this, "requireCommonName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.requireDirectoryPath = software.amazon.jsii.Kernel.get(this, "requireDirectoryPath", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.requireDnsAsCn = software.amazon.jsii.Kernel.get(this, "requireDnsAsCn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.requireEmail = software.amazon.jsii.Kernel.get(this, "requireEmail", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sanRequireDirectoryGuid = software.amazon.jsii.Kernel.get(this, "sanRequireDirectoryGuid", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sanRequireDns = software.amazon.jsii.Kernel.get(this, "sanRequireDns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sanRequireDomainDns = software.amazon.jsii.Kernel.get(this, "sanRequireDomainDns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sanRequireEmail = software.amazon.jsii.Kernel.get(this, "sanRequireEmail", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sanRequireSpn = software.amazon.jsii.Kernel.get(this, "sanRequireSpn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sanRequireUpn = software.amazon.jsii.Kernel.get(this, "sanRequireUpn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.requireCommonName = builder.requireCommonName;
                this.requireDirectoryPath = builder.requireDirectoryPath;
                this.requireDnsAsCn = builder.requireDnsAsCn;
                this.requireEmail = builder.requireEmail;
                this.sanRequireDirectoryGuid = builder.sanRequireDirectoryGuid;
                this.sanRequireDns = builder.sanRequireDns;
                this.sanRequireDomainDns = builder.sanRequireDomainDns;
                this.sanRequireEmail = builder.sanRequireEmail;
                this.sanRequireSpn = builder.sanRequireSpn;
                this.sanRequireUpn = builder.sanRequireUpn;
            }

            @Override
            public final java.lang.Object getRequireCommonName() {
                return this.requireCommonName;
            }

            @Override
            public final java.lang.Object getRequireDirectoryPath() {
                return this.requireDirectoryPath;
            }

            @Override
            public final java.lang.Object getRequireDnsAsCn() {
                return this.requireDnsAsCn;
            }

            @Override
            public final java.lang.Object getRequireEmail() {
                return this.requireEmail;
            }

            @Override
            public final java.lang.Object getSanRequireDirectoryGuid() {
                return this.sanRequireDirectoryGuid;
            }

            @Override
            public final java.lang.Object getSanRequireDns() {
                return this.sanRequireDns;
            }

            @Override
            public final java.lang.Object getSanRequireDomainDns() {
                return this.sanRequireDomainDns;
            }

            @Override
            public final java.lang.Object getSanRequireEmail() {
                return this.sanRequireEmail;
            }

            @Override
            public final java.lang.Object getSanRequireSpn() {
                return this.sanRequireSpn;
            }

            @Override
            public final java.lang.Object getSanRequireUpn() {
                return this.sanRequireUpn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRequireCommonName() != null) {
                    data.set("requireCommonName", om.valueToTree(this.getRequireCommonName()));
                }
                if (this.getRequireDirectoryPath() != null) {
                    data.set("requireDirectoryPath", om.valueToTree(this.getRequireDirectoryPath()));
                }
                if (this.getRequireDnsAsCn() != null) {
                    data.set("requireDnsAsCn", om.valueToTree(this.getRequireDnsAsCn()));
                }
                if (this.getRequireEmail() != null) {
                    data.set("requireEmail", om.valueToTree(this.getRequireEmail()));
                }
                if (this.getSanRequireDirectoryGuid() != null) {
                    data.set("sanRequireDirectoryGuid", om.valueToTree(this.getSanRequireDirectoryGuid()));
                }
                if (this.getSanRequireDns() != null) {
                    data.set("sanRequireDns", om.valueToTree(this.getSanRequireDns()));
                }
                if (this.getSanRequireDomainDns() != null) {
                    data.set("sanRequireDomainDns", om.valueToTree(this.getSanRequireDomainDns()));
                }
                if (this.getSanRequireEmail() != null) {
                    data.set("sanRequireEmail", om.valueToTree(this.getSanRequireEmail()));
                }
                if (this.getSanRequireSpn() != null) {
                    data.set("sanRequireSpn", om.valueToTree(this.getSanRequireSpn()));
                }
                if (this.getSanRequireUpn() != null) {
                    data.set("sanRequireUpn", om.valueToTree(this.getSanRequireUpn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.SubjectNameFlagsV3Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SubjectNameFlagsV3Property.Jsii$Proxy that = (SubjectNameFlagsV3Property.Jsii$Proxy) o;

                if (this.requireCommonName != null ? !this.requireCommonName.equals(that.requireCommonName) : that.requireCommonName != null) return false;
                if (this.requireDirectoryPath != null ? !this.requireDirectoryPath.equals(that.requireDirectoryPath) : that.requireDirectoryPath != null) return false;
                if (this.requireDnsAsCn != null ? !this.requireDnsAsCn.equals(that.requireDnsAsCn) : that.requireDnsAsCn != null) return false;
                if (this.requireEmail != null ? !this.requireEmail.equals(that.requireEmail) : that.requireEmail != null) return false;
                if (this.sanRequireDirectoryGuid != null ? !this.sanRequireDirectoryGuid.equals(that.sanRequireDirectoryGuid) : that.sanRequireDirectoryGuid != null) return false;
                if (this.sanRequireDns != null ? !this.sanRequireDns.equals(that.sanRequireDns) : that.sanRequireDns != null) return false;
                if (this.sanRequireDomainDns != null ? !this.sanRequireDomainDns.equals(that.sanRequireDomainDns) : that.sanRequireDomainDns != null) return false;
                if (this.sanRequireEmail != null ? !this.sanRequireEmail.equals(that.sanRequireEmail) : that.sanRequireEmail != null) return false;
                if (this.sanRequireSpn != null ? !this.sanRequireSpn.equals(that.sanRequireSpn) : that.sanRequireSpn != null) return false;
                return this.sanRequireUpn != null ? this.sanRequireUpn.equals(that.sanRequireUpn) : that.sanRequireUpn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.requireCommonName != null ? this.requireCommonName.hashCode() : 0;
                result = 31 * result + (this.requireDirectoryPath != null ? this.requireDirectoryPath.hashCode() : 0);
                result = 31 * result + (this.requireDnsAsCn != null ? this.requireDnsAsCn.hashCode() : 0);
                result = 31 * result + (this.requireEmail != null ? this.requireEmail.hashCode() : 0);
                result = 31 * result + (this.sanRequireDirectoryGuid != null ? this.sanRequireDirectoryGuid.hashCode() : 0);
                result = 31 * result + (this.sanRequireDns != null ? this.sanRequireDns.hashCode() : 0);
                result = 31 * result + (this.sanRequireDomainDns != null ? this.sanRequireDomainDns.hashCode() : 0);
                result = 31 * result + (this.sanRequireEmail != null ? this.sanRequireEmail.hashCode() : 0);
                result = 31 * result + (this.sanRequireSpn != null ? this.sanRequireSpn.hashCode() : 0);
                result = 31 * result + (this.sanRequireUpn != null ? this.sanRequireUpn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information to include in the subject name and alternate subject name of the certificate.
     * <p>
     * The subject name can be common name, directory path, DNS as common name, or left blank. You can optionally include email to the subject name for user templates. If you leave the subject name blank then you must set a subject alternate name. The subject alternate name (SAN) can include globally unique identifier (GUID), DNS, domain DNS, email, service principal name (SPN), and user principal name (UPN). You can leave the SAN blank. If you leave the SAN blank, then you must set a subject name.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pcaconnectorad.*;
     * SubjectNameFlagsV4Property subjectNameFlagsV4Property = SubjectNameFlagsV4Property.builder()
     *         .requireCommonName(false)
     *         .requireDirectoryPath(false)
     *         .requireDnsAsCn(false)
     *         .requireEmail(false)
     *         .sanRequireDirectoryGuid(false)
     *         .sanRequireDns(false)
     *         .sanRequireDomainDns(false)
     *         .sanRequireEmail(false)
     *         .sanRequireSpn(false)
     *         .sanRequireUpn(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv4.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv4.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.SubjectNameFlagsV4Property")
    @software.amazon.jsii.Jsii.Proxy(SubjectNameFlagsV4Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SubjectNameFlagsV4Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * Include the common name in the subject name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv4.html#cfn-pcaconnectorad-template-subjectnameflagsv4-requirecommonname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv4.html#cfn-pcaconnectorad-template-subjectnameflagsv4-requirecommonname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequireCommonName() {
            return null;
        }

        /**
         * Include the directory path in the subject name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv4.html#cfn-pcaconnectorad-template-subjectnameflagsv4-requiredirectorypath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv4.html#cfn-pcaconnectorad-template-subjectnameflagsv4-requiredirectorypath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequireDirectoryPath() {
            return null;
        }

        /**
         * Include the DNS as common name in the subject name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv4.html#cfn-pcaconnectorad-template-subjectnameflagsv4-requirednsascn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv4.html#cfn-pcaconnectorad-template-subjectnameflagsv4-requirednsascn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequireDnsAsCn() {
            return null;
        }

        /**
         * Include the subject's email in the subject name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv4.html#cfn-pcaconnectorad-template-subjectnameflagsv4-requireemail">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv4.html#cfn-pcaconnectorad-template-subjectnameflagsv4-requireemail</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequireEmail() {
            return null;
        }

        /**
         * Include the globally unique identifier (GUID) in the subject alternate name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv4.html#cfn-pcaconnectorad-template-subjectnameflagsv4-sanrequiredirectoryguid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv4.html#cfn-pcaconnectorad-template-subjectnameflagsv4-sanrequiredirectoryguid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSanRequireDirectoryGuid() {
            return null;
        }

        /**
         * Include the DNS in the subject alternate name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv4.html#cfn-pcaconnectorad-template-subjectnameflagsv4-sanrequiredns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv4.html#cfn-pcaconnectorad-template-subjectnameflagsv4-sanrequiredns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSanRequireDns() {
            return null;
        }

        /**
         * Include the domain DNS in the subject alternate name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv4.html#cfn-pcaconnectorad-template-subjectnameflagsv4-sanrequiredomaindns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv4.html#cfn-pcaconnectorad-template-subjectnameflagsv4-sanrequiredomaindns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSanRequireDomainDns() {
            return null;
        }

        /**
         * Include the subject's email in the subject alternate name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv4.html#cfn-pcaconnectorad-template-subjectnameflagsv4-sanrequireemail">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv4.html#cfn-pcaconnectorad-template-subjectnameflagsv4-sanrequireemail</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSanRequireEmail() {
            return null;
        }

        /**
         * Include the service principal name (SPN) in the subject alternate name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv4.html#cfn-pcaconnectorad-template-subjectnameflagsv4-sanrequirespn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv4.html#cfn-pcaconnectorad-template-subjectnameflagsv4-sanrequirespn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSanRequireSpn() {
            return null;
        }

        /**
         * Include the user principal name (UPN) in the subject alternate name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv4.html#cfn-pcaconnectorad-template-subjectnameflagsv4-sanrequireupn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-subjectnameflagsv4.html#cfn-pcaconnectorad-template-subjectnameflagsv4-sanrequireupn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSanRequireUpn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SubjectNameFlagsV4Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SubjectNameFlagsV4Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SubjectNameFlagsV4Property> {
            java.lang.Object requireCommonName;
            java.lang.Object requireDirectoryPath;
            java.lang.Object requireDnsAsCn;
            java.lang.Object requireEmail;
            java.lang.Object sanRequireDirectoryGuid;
            java.lang.Object sanRequireDns;
            java.lang.Object sanRequireDomainDns;
            java.lang.Object sanRequireEmail;
            java.lang.Object sanRequireSpn;
            java.lang.Object sanRequireUpn;

            /**
             * Sets the value of {@link SubjectNameFlagsV4Property#getRequireCommonName}
             * @param requireCommonName Include the common name in the subject name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireCommonName(java.lang.Boolean requireCommonName) {
                this.requireCommonName = requireCommonName;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV4Property#getRequireCommonName}
             * @param requireCommonName Include the common name in the subject name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireCommonName(software.amazon.awscdk.IResolvable requireCommonName) {
                this.requireCommonName = requireCommonName;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV4Property#getRequireDirectoryPath}
             * @param requireDirectoryPath Include the directory path in the subject name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireDirectoryPath(java.lang.Boolean requireDirectoryPath) {
                this.requireDirectoryPath = requireDirectoryPath;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV4Property#getRequireDirectoryPath}
             * @param requireDirectoryPath Include the directory path in the subject name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireDirectoryPath(software.amazon.awscdk.IResolvable requireDirectoryPath) {
                this.requireDirectoryPath = requireDirectoryPath;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV4Property#getRequireDnsAsCn}
             * @param requireDnsAsCn Include the DNS as common name in the subject name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireDnsAsCn(java.lang.Boolean requireDnsAsCn) {
                this.requireDnsAsCn = requireDnsAsCn;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV4Property#getRequireDnsAsCn}
             * @param requireDnsAsCn Include the DNS as common name in the subject name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireDnsAsCn(software.amazon.awscdk.IResolvable requireDnsAsCn) {
                this.requireDnsAsCn = requireDnsAsCn;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV4Property#getRequireEmail}
             * @param requireEmail Include the subject's email in the subject name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireEmail(java.lang.Boolean requireEmail) {
                this.requireEmail = requireEmail;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV4Property#getRequireEmail}
             * @param requireEmail Include the subject's email in the subject name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireEmail(software.amazon.awscdk.IResolvable requireEmail) {
                this.requireEmail = requireEmail;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV4Property#getSanRequireDirectoryGuid}
             * @param sanRequireDirectoryGuid Include the globally unique identifier (GUID) in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireDirectoryGuid(java.lang.Boolean sanRequireDirectoryGuid) {
                this.sanRequireDirectoryGuid = sanRequireDirectoryGuid;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV4Property#getSanRequireDirectoryGuid}
             * @param sanRequireDirectoryGuid Include the globally unique identifier (GUID) in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireDirectoryGuid(software.amazon.awscdk.IResolvable sanRequireDirectoryGuid) {
                this.sanRequireDirectoryGuid = sanRequireDirectoryGuid;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV4Property#getSanRequireDns}
             * @param sanRequireDns Include the DNS in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireDns(java.lang.Boolean sanRequireDns) {
                this.sanRequireDns = sanRequireDns;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV4Property#getSanRequireDns}
             * @param sanRequireDns Include the DNS in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireDns(software.amazon.awscdk.IResolvable sanRequireDns) {
                this.sanRequireDns = sanRequireDns;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV4Property#getSanRequireDomainDns}
             * @param sanRequireDomainDns Include the domain DNS in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireDomainDns(java.lang.Boolean sanRequireDomainDns) {
                this.sanRequireDomainDns = sanRequireDomainDns;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV4Property#getSanRequireDomainDns}
             * @param sanRequireDomainDns Include the domain DNS in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireDomainDns(software.amazon.awscdk.IResolvable sanRequireDomainDns) {
                this.sanRequireDomainDns = sanRequireDomainDns;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV4Property#getSanRequireEmail}
             * @param sanRequireEmail Include the subject's email in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireEmail(java.lang.Boolean sanRequireEmail) {
                this.sanRequireEmail = sanRequireEmail;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV4Property#getSanRequireEmail}
             * @param sanRequireEmail Include the subject's email in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireEmail(software.amazon.awscdk.IResolvable sanRequireEmail) {
                this.sanRequireEmail = sanRequireEmail;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV4Property#getSanRequireSpn}
             * @param sanRequireSpn Include the service principal name (SPN) in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireSpn(java.lang.Boolean sanRequireSpn) {
                this.sanRequireSpn = sanRequireSpn;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV4Property#getSanRequireSpn}
             * @param sanRequireSpn Include the service principal name (SPN) in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireSpn(software.amazon.awscdk.IResolvable sanRequireSpn) {
                this.sanRequireSpn = sanRequireSpn;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV4Property#getSanRequireUpn}
             * @param sanRequireUpn Include the user principal name (UPN) in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireUpn(java.lang.Boolean sanRequireUpn) {
                this.sanRequireUpn = sanRequireUpn;
                return this;
            }

            /**
             * Sets the value of {@link SubjectNameFlagsV4Property#getSanRequireUpn}
             * @param sanRequireUpn Include the user principal name (UPN) in the subject alternate name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sanRequireUpn(software.amazon.awscdk.IResolvable sanRequireUpn) {
                this.sanRequireUpn = sanRequireUpn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SubjectNameFlagsV4Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SubjectNameFlagsV4Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SubjectNameFlagsV4Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubjectNameFlagsV4Property {
            private final java.lang.Object requireCommonName;
            private final java.lang.Object requireDirectoryPath;
            private final java.lang.Object requireDnsAsCn;
            private final java.lang.Object requireEmail;
            private final java.lang.Object sanRequireDirectoryGuid;
            private final java.lang.Object sanRequireDns;
            private final java.lang.Object sanRequireDomainDns;
            private final java.lang.Object sanRequireEmail;
            private final java.lang.Object sanRequireSpn;
            private final java.lang.Object sanRequireUpn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.requireCommonName = software.amazon.jsii.Kernel.get(this, "requireCommonName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.requireDirectoryPath = software.amazon.jsii.Kernel.get(this, "requireDirectoryPath", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.requireDnsAsCn = software.amazon.jsii.Kernel.get(this, "requireDnsAsCn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.requireEmail = software.amazon.jsii.Kernel.get(this, "requireEmail", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sanRequireDirectoryGuid = software.amazon.jsii.Kernel.get(this, "sanRequireDirectoryGuid", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sanRequireDns = software.amazon.jsii.Kernel.get(this, "sanRequireDns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sanRequireDomainDns = software.amazon.jsii.Kernel.get(this, "sanRequireDomainDns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sanRequireEmail = software.amazon.jsii.Kernel.get(this, "sanRequireEmail", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sanRequireSpn = software.amazon.jsii.Kernel.get(this, "sanRequireSpn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sanRequireUpn = software.amazon.jsii.Kernel.get(this, "sanRequireUpn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.requireCommonName = builder.requireCommonName;
                this.requireDirectoryPath = builder.requireDirectoryPath;
                this.requireDnsAsCn = builder.requireDnsAsCn;
                this.requireEmail = builder.requireEmail;
                this.sanRequireDirectoryGuid = builder.sanRequireDirectoryGuid;
                this.sanRequireDns = builder.sanRequireDns;
                this.sanRequireDomainDns = builder.sanRequireDomainDns;
                this.sanRequireEmail = builder.sanRequireEmail;
                this.sanRequireSpn = builder.sanRequireSpn;
                this.sanRequireUpn = builder.sanRequireUpn;
            }

            @Override
            public final java.lang.Object getRequireCommonName() {
                return this.requireCommonName;
            }

            @Override
            public final java.lang.Object getRequireDirectoryPath() {
                return this.requireDirectoryPath;
            }

            @Override
            public final java.lang.Object getRequireDnsAsCn() {
                return this.requireDnsAsCn;
            }

            @Override
            public final java.lang.Object getRequireEmail() {
                return this.requireEmail;
            }

            @Override
            public final java.lang.Object getSanRequireDirectoryGuid() {
                return this.sanRequireDirectoryGuid;
            }

            @Override
            public final java.lang.Object getSanRequireDns() {
                return this.sanRequireDns;
            }

            @Override
            public final java.lang.Object getSanRequireDomainDns() {
                return this.sanRequireDomainDns;
            }

            @Override
            public final java.lang.Object getSanRequireEmail() {
                return this.sanRequireEmail;
            }

            @Override
            public final java.lang.Object getSanRequireSpn() {
                return this.sanRequireSpn;
            }

            @Override
            public final java.lang.Object getSanRequireUpn() {
                return this.sanRequireUpn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRequireCommonName() != null) {
                    data.set("requireCommonName", om.valueToTree(this.getRequireCommonName()));
                }
                if (this.getRequireDirectoryPath() != null) {
                    data.set("requireDirectoryPath", om.valueToTree(this.getRequireDirectoryPath()));
                }
                if (this.getRequireDnsAsCn() != null) {
                    data.set("requireDnsAsCn", om.valueToTree(this.getRequireDnsAsCn()));
                }
                if (this.getRequireEmail() != null) {
                    data.set("requireEmail", om.valueToTree(this.getRequireEmail()));
                }
                if (this.getSanRequireDirectoryGuid() != null) {
                    data.set("sanRequireDirectoryGuid", om.valueToTree(this.getSanRequireDirectoryGuid()));
                }
                if (this.getSanRequireDns() != null) {
                    data.set("sanRequireDns", om.valueToTree(this.getSanRequireDns()));
                }
                if (this.getSanRequireDomainDns() != null) {
                    data.set("sanRequireDomainDns", om.valueToTree(this.getSanRequireDomainDns()));
                }
                if (this.getSanRequireEmail() != null) {
                    data.set("sanRequireEmail", om.valueToTree(this.getSanRequireEmail()));
                }
                if (this.getSanRequireSpn() != null) {
                    data.set("sanRequireSpn", om.valueToTree(this.getSanRequireSpn()));
                }
                if (this.getSanRequireUpn() != null) {
                    data.set("sanRequireUpn", om.valueToTree(this.getSanRequireUpn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.SubjectNameFlagsV4Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SubjectNameFlagsV4Property.Jsii$Proxy that = (SubjectNameFlagsV4Property.Jsii$Proxy) o;

                if (this.requireCommonName != null ? !this.requireCommonName.equals(that.requireCommonName) : that.requireCommonName != null) return false;
                if (this.requireDirectoryPath != null ? !this.requireDirectoryPath.equals(that.requireDirectoryPath) : that.requireDirectoryPath != null) return false;
                if (this.requireDnsAsCn != null ? !this.requireDnsAsCn.equals(that.requireDnsAsCn) : that.requireDnsAsCn != null) return false;
                if (this.requireEmail != null ? !this.requireEmail.equals(that.requireEmail) : that.requireEmail != null) return false;
                if (this.sanRequireDirectoryGuid != null ? !this.sanRequireDirectoryGuid.equals(that.sanRequireDirectoryGuid) : that.sanRequireDirectoryGuid != null) return false;
                if (this.sanRequireDns != null ? !this.sanRequireDns.equals(that.sanRequireDns) : that.sanRequireDns != null) return false;
                if (this.sanRequireDomainDns != null ? !this.sanRequireDomainDns.equals(that.sanRequireDomainDns) : that.sanRequireDomainDns != null) return false;
                if (this.sanRequireEmail != null ? !this.sanRequireEmail.equals(that.sanRequireEmail) : that.sanRequireEmail != null) return false;
                if (this.sanRequireSpn != null ? !this.sanRequireSpn.equals(that.sanRequireSpn) : that.sanRequireSpn != null) return false;
                return this.sanRequireUpn != null ? this.sanRequireUpn.equals(that.sanRequireUpn) : that.sanRequireUpn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.requireCommonName != null ? this.requireCommonName.hashCode() : 0;
                result = 31 * result + (this.requireDirectoryPath != null ? this.requireDirectoryPath.hashCode() : 0);
                result = 31 * result + (this.requireDnsAsCn != null ? this.requireDnsAsCn.hashCode() : 0);
                result = 31 * result + (this.requireEmail != null ? this.requireEmail.hashCode() : 0);
                result = 31 * result + (this.sanRequireDirectoryGuid != null ? this.sanRequireDirectoryGuid.hashCode() : 0);
                result = 31 * result + (this.sanRequireDns != null ? this.sanRequireDns.hashCode() : 0);
                result = 31 * result + (this.sanRequireDomainDns != null ? this.sanRequireDomainDns.hashCode() : 0);
                result = 31 * result + (this.sanRequireEmail != null ? this.sanRequireEmail.hashCode() : 0);
                result = 31 * result + (this.sanRequireSpn != null ? this.sanRequireSpn.hashCode() : 0);
                result = 31 * result + (this.sanRequireUpn != null ? this.sanRequireUpn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Template configuration to define the information included in certificates.
     * <p>
     * Define certificate validity and renewal periods, certificate request handling and enrollment options, key usage extensions, application policies, and cryptography settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pcaconnectorad.*;
     * TemplateDefinitionProperty templateDefinitionProperty = TemplateDefinitionProperty.builder()
     *         .templateV2(TemplateV2Property.builder()
     *                 .certificateValidity(CertificateValidityProperty.builder()
     *                         .renewalPeriod(ValidityPeriodProperty.builder()
     *                                 .period(123)
     *                                 .periodType("periodType")
     *                                 .build())
     *                         .validityPeriod(ValidityPeriodProperty.builder()
     *                                 .period(123)
     *                                 .periodType("periodType")
     *                                 .build())
     *                         .build())
     *                 .enrollmentFlags(EnrollmentFlagsV2Property.builder()
     *                         .enableKeyReuseOnNtTokenKeysetStorageFull(false)
     *                         .includeSymmetricAlgorithms(false)
     *                         .noSecurityExtension(false)
     *                         .removeInvalidCertificateFromPersonalStore(false)
     *                         .userInteractionRequired(false)
     *                         .build())
     *                 .extensions(ExtensionsV2Property.builder()
     *                         .keyUsage(KeyUsageProperty.builder()
     *                                 .usageFlags(KeyUsageFlagsProperty.builder()
     *                                         .dataEncipherment(false)
     *                                         .digitalSignature(false)
     *                                         .keyAgreement(false)
     *                                         .keyEncipherment(false)
     *                                         .nonRepudiation(false)
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .critical(false)
     *                                 .build())
     *                         // the properties below are optional
     *                         .applicationPolicies(ApplicationPoliciesProperty.builder()
     *                                 .policies(List.of(ApplicationPolicyProperty.builder()
     *                                         .policyObjectIdentifier("policyObjectIdentifier")
     *                                         .policyType("policyType")
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .critical(false)
     *                                 .build())
     *                         .build())
     *                 .generalFlags(GeneralFlagsV2Property.builder()
     *                         .autoEnrollment(false)
     *                         .machineType(false)
     *                         .build())
     *                 .privateKeyAttributes(PrivateKeyAttributesV2Property.builder()
     *                         .keySpec("keySpec")
     *                         .minimalKeyLength(123)
     *                         // the properties below are optional
     *                         .cryptoProviders(List.of("cryptoProviders"))
     *                         .build())
     *                 .privateKeyFlags(PrivateKeyFlagsV2Property.builder()
     *                         .clientVersion("clientVersion")
     *                         // the properties below are optional
     *                         .exportableKey(false)
     *                         .strongKeyProtectionRequired(false)
     *                         .build())
     *                 .subjectNameFlags(SubjectNameFlagsV2Property.builder()
     *                         .requireCommonName(false)
     *                         .requireDirectoryPath(false)
     *                         .requireDnsAsCn(false)
     *                         .requireEmail(false)
     *                         .sanRequireDirectoryGuid(false)
     *                         .sanRequireDns(false)
     *                         .sanRequireDomainDns(false)
     *                         .sanRequireEmail(false)
     *                         .sanRequireSpn(false)
     *                         .sanRequireUpn(false)
     *                         .build())
     *                 // the properties below are optional
     *                 .supersededTemplates(List.of("supersededTemplates"))
     *                 .build())
     *         .templateV3(TemplateV3Property.builder()
     *                 .certificateValidity(CertificateValidityProperty.builder()
     *                         .renewalPeriod(ValidityPeriodProperty.builder()
     *                                 .period(123)
     *                                 .periodType("periodType")
     *                                 .build())
     *                         .validityPeriod(ValidityPeriodProperty.builder()
     *                                 .period(123)
     *                                 .periodType("periodType")
     *                                 .build())
     *                         .build())
     *                 .enrollmentFlags(EnrollmentFlagsV3Property.builder()
     *                         .enableKeyReuseOnNtTokenKeysetStorageFull(false)
     *                         .includeSymmetricAlgorithms(false)
     *                         .noSecurityExtension(false)
     *                         .removeInvalidCertificateFromPersonalStore(false)
     *                         .userInteractionRequired(false)
     *                         .build())
     *                 .extensions(ExtensionsV3Property.builder()
     *                         .keyUsage(KeyUsageProperty.builder()
     *                                 .usageFlags(KeyUsageFlagsProperty.builder()
     *                                         .dataEncipherment(false)
     *                                         .digitalSignature(false)
     *                                         .keyAgreement(false)
     *                                         .keyEncipherment(false)
     *                                         .nonRepudiation(false)
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .critical(false)
     *                                 .build())
     *                         // the properties below are optional
     *                         .applicationPolicies(ApplicationPoliciesProperty.builder()
     *                                 .policies(List.of(ApplicationPolicyProperty.builder()
     *                                         .policyObjectIdentifier("policyObjectIdentifier")
     *                                         .policyType("policyType")
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .critical(false)
     *                                 .build())
     *                         .build())
     *                 .generalFlags(GeneralFlagsV3Property.builder()
     *                         .autoEnrollment(false)
     *                         .machineType(false)
     *                         .build())
     *                 .hashAlgorithm("hashAlgorithm")
     *                 .privateKeyAttributes(PrivateKeyAttributesV3Property.builder()
     *                         .algorithm("algorithm")
     *                         .keySpec("keySpec")
     *                         .keyUsageProperty(KeyUsagePropertyProperty.builder()
     *                                 .propertyFlags(KeyUsagePropertyFlagsProperty.builder()
     *                                         .decrypt(false)
     *                                         .keyAgreement(false)
     *                                         .sign(false)
     *                                         .build())
     *                                 .propertyType("propertyType")
     *                                 .build())
     *                         .minimalKeyLength(123)
     *                         // the properties below are optional
     *                         .cryptoProviders(List.of("cryptoProviders"))
     *                         .build())
     *                 .privateKeyFlags(PrivateKeyFlagsV3Property.builder()
     *                         .clientVersion("clientVersion")
     *                         // the properties below are optional
     *                         .exportableKey(false)
     *                         .requireAlternateSignatureAlgorithm(false)
     *                         .strongKeyProtectionRequired(false)
     *                         .build())
     *                 .subjectNameFlags(SubjectNameFlagsV3Property.builder()
     *                         .requireCommonName(false)
     *                         .requireDirectoryPath(false)
     *                         .requireDnsAsCn(false)
     *                         .requireEmail(false)
     *                         .sanRequireDirectoryGuid(false)
     *                         .sanRequireDns(false)
     *                         .sanRequireDomainDns(false)
     *                         .sanRequireEmail(false)
     *                         .sanRequireSpn(false)
     *                         .sanRequireUpn(false)
     *                         .build())
     *                 // the properties below are optional
     *                 .supersededTemplates(List.of("supersededTemplates"))
     *                 .build())
     *         .templateV4(TemplateV4Property.builder()
     *                 .certificateValidity(CertificateValidityProperty.builder()
     *                         .renewalPeriod(ValidityPeriodProperty.builder()
     *                                 .period(123)
     *                                 .periodType("periodType")
     *                                 .build())
     *                         .validityPeriod(ValidityPeriodProperty.builder()
     *                                 .period(123)
     *                                 .periodType("periodType")
     *                                 .build())
     *                         .build())
     *                 .enrollmentFlags(EnrollmentFlagsV4Property.builder()
     *                         .enableKeyReuseOnNtTokenKeysetStorageFull(false)
     *                         .includeSymmetricAlgorithms(false)
     *                         .noSecurityExtension(false)
     *                         .removeInvalidCertificateFromPersonalStore(false)
     *                         .userInteractionRequired(false)
     *                         .build())
     *                 .extensions(ExtensionsV4Property.builder()
     *                         .keyUsage(KeyUsageProperty.builder()
     *                                 .usageFlags(KeyUsageFlagsProperty.builder()
     *                                         .dataEncipherment(false)
     *                                         .digitalSignature(false)
     *                                         .keyAgreement(false)
     *                                         .keyEncipherment(false)
     *                                         .nonRepudiation(false)
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .critical(false)
     *                                 .build())
     *                         // the properties below are optional
     *                         .applicationPolicies(ApplicationPoliciesProperty.builder()
     *                                 .policies(List.of(ApplicationPolicyProperty.builder()
     *                                         .policyObjectIdentifier("policyObjectIdentifier")
     *                                         .policyType("policyType")
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .critical(false)
     *                                 .build())
     *                         .build())
     *                 .generalFlags(GeneralFlagsV4Property.builder()
     *                         .autoEnrollment(false)
     *                         .machineType(false)
     *                         .build())
     *                 .privateKeyAttributes(PrivateKeyAttributesV4Property.builder()
     *                         .keySpec("keySpec")
     *                         .minimalKeyLength(123)
     *                         // the properties below are optional
     *                         .algorithm("algorithm")
     *                         .cryptoProviders(List.of("cryptoProviders"))
     *                         .keyUsageProperty(KeyUsagePropertyProperty.builder()
     *                                 .propertyFlags(KeyUsagePropertyFlagsProperty.builder()
     *                                         .decrypt(false)
     *                                         .keyAgreement(false)
     *                                         .sign(false)
     *                                         .build())
     *                                 .propertyType("propertyType")
     *                                 .build())
     *                         .build())
     *                 .privateKeyFlags(PrivateKeyFlagsV4Property.builder()
     *                         .clientVersion("clientVersion")
     *                         // the properties below are optional
     *                         .exportableKey(false)
     *                         .requireAlternateSignatureAlgorithm(false)
     *                         .requireSameKeyRenewal(false)
     *                         .strongKeyProtectionRequired(false)
     *                         .useLegacyProvider(false)
     *                         .build())
     *                 .subjectNameFlags(SubjectNameFlagsV4Property.builder()
     *                         .requireCommonName(false)
     *                         .requireDirectoryPath(false)
     *                         .requireDnsAsCn(false)
     *                         .requireEmail(false)
     *                         .sanRequireDirectoryGuid(false)
     *                         .sanRequireDns(false)
     *                         .sanRequireDomainDns(false)
     *                         .sanRequireEmail(false)
     *                         .sanRequireSpn(false)
     *                         .sanRequireUpn(false)
     *                         .build())
     *                 // the properties below are optional
     *                 .hashAlgorithm("hashAlgorithm")
     *                 .supersededTemplates(List.of("supersededTemplates"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatedefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatedefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.TemplateDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(TemplateDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TemplateDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Template configuration to define the information included in certificates.
         * <p>
         * Define certificate validity and renewal periods, certificate request handling and enrollment options, key usage extensions, application policies, and cryptography settings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatedefinition.html#cfn-pcaconnectorad-template-templatedefinition-templatev2">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatedefinition.html#cfn-pcaconnectorad-template-templatedefinition-templatev2</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTemplateV2() {
            return null;
        }

        /**
         * Template configuration to define the information included in certificates.
         * <p>
         * Define certificate validity and renewal periods, certificate request handling and enrollment options, key usage extensions, application policies, and cryptography settings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatedefinition.html#cfn-pcaconnectorad-template-templatedefinition-templatev3">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatedefinition.html#cfn-pcaconnectorad-template-templatedefinition-templatev3</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTemplateV3() {
            return null;
        }

        /**
         * Template configuration to define the information included in certificates.
         * <p>
         * Define certificate validity and renewal periods, certificate request handling and enrollment options, key usage extensions, application policies, and cryptography settings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatedefinition.html#cfn-pcaconnectorad-template-templatedefinition-templatev4">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatedefinition.html#cfn-pcaconnectorad-template-templatedefinition-templatev4</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTemplateV4() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TemplateDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TemplateDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TemplateDefinitionProperty> {
            java.lang.Object templateV2;
            java.lang.Object templateV3;
            java.lang.Object templateV4;

            /**
             * Sets the value of {@link TemplateDefinitionProperty#getTemplateV2}
             * @param templateV2 Template configuration to define the information included in certificates.
             *                   Define certificate validity and renewal periods, certificate request handling and enrollment options, key usage extensions, application policies, and cryptography settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder templateV2(software.amazon.awscdk.IResolvable templateV2) {
                this.templateV2 = templateV2;
                return this;
            }

            /**
             * Sets the value of {@link TemplateDefinitionProperty#getTemplateV2}
             * @param templateV2 Template configuration to define the information included in certificates.
             *                   Define certificate validity and renewal periods, certificate request handling and enrollment options, key usage extensions, application policies, and cryptography settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder templateV2(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.TemplateV2Property templateV2) {
                this.templateV2 = templateV2;
                return this;
            }

            /**
             * Sets the value of {@link TemplateDefinitionProperty#getTemplateV3}
             * @param templateV3 Template configuration to define the information included in certificates.
             *                   Define certificate validity and renewal periods, certificate request handling and enrollment options, key usage extensions, application policies, and cryptography settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder templateV3(software.amazon.awscdk.IResolvable templateV3) {
                this.templateV3 = templateV3;
                return this;
            }

            /**
             * Sets the value of {@link TemplateDefinitionProperty#getTemplateV3}
             * @param templateV3 Template configuration to define the information included in certificates.
             *                   Define certificate validity and renewal periods, certificate request handling and enrollment options, key usage extensions, application policies, and cryptography settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder templateV3(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.TemplateV3Property templateV3) {
                this.templateV3 = templateV3;
                return this;
            }

            /**
             * Sets the value of {@link TemplateDefinitionProperty#getTemplateV4}
             * @param templateV4 Template configuration to define the information included in certificates.
             *                   Define certificate validity and renewal periods, certificate request handling and enrollment options, key usage extensions, application policies, and cryptography settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder templateV4(software.amazon.awscdk.IResolvable templateV4) {
                this.templateV4 = templateV4;
                return this;
            }

            /**
             * Sets the value of {@link TemplateDefinitionProperty#getTemplateV4}
             * @param templateV4 Template configuration to define the information included in certificates.
             *                   Define certificate validity and renewal periods, certificate request handling and enrollment options, key usage extensions, application policies, and cryptography settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder templateV4(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.TemplateV4Property templateV4) {
                this.templateV4 = templateV4;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TemplateDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TemplateDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TemplateDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TemplateDefinitionProperty {
            private final java.lang.Object templateV2;
            private final java.lang.Object templateV3;
            private final java.lang.Object templateV4;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.templateV2 = software.amazon.jsii.Kernel.get(this, "templateV2", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.templateV3 = software.amazon.jsii.Kernel.get(this, "templateV3", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.templateV4 = software.amazon.jsii.Kernel.get(this, "templateV4", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.templateV2 = builder.templateV2;
                this.templateV3 = builder.templateV3;
                this.templateV4 = builder.templateV4;
            }

            @Override
            public final java.lang.Object getTemplateV2() {
                return this.templateV2;
            }

            @Override
            public final java.lang.Object getTemplateV3() {
                return this.templateV3;
            }

            @Override
            public final java.lang.Object getTemplateV4() {
                return this.templateV4;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTemplateV2() != null) {
                    data.set("templateV2", om.valueToTree(this.getTemplateV2()));
                }
                if (this.getTemplateV3() != null) {
                    data.set("templateV3", om.valueToTree(this.getTemplateV3()));
                }
                if (this.getTemplateV4() != null) {
                    data.set("templateV4", om.valueToTree(this.getTemplateV4()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.TemplateDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TemplateDefinitionProperty.Jsii$Proxy that = (TemplateDefinitionProperty.Jsii$Proxy) o;

                if (this.templateV2 != null ? !this.templateV2.equals(that.templateV2) : that.templateV2 != null) return false;
                if (this.templateV3 != null ? !this.templateV3.equals(that.templateV3) : that.templateV3 != null) return false;
                return this.templateV4 != null ? this.templateV4.equals(that.templateV4) : that.templateV4 == null;
            }

            @Override
            public final int hashCode() {
                int result = this.templateV2 != null ? this.templateV2.hashCode() : 0;
                result = 31 * result + (this.templateV3 != null ? this.templateV3.hashCode() : 0);
                result = 31 * result + (this.templateV4 != null ? this.templateV4.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * v2 template schema that uses Legacy Cryptographic Providers.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pcaconnectorad.*;
     * TemplateV2Property templateV2Property = TemplateV2Property.builder()
     *         .certificateValidity(CertificateValidityProperty.builder()
     *                 .renewalPeriod(ValidityPeriodProperty.builder()
     *                         .period(123)
     *                         .periodType("periodType")
     *                         .build())
     *                 .validityPeriod(ValidityPeriodProperty.builder()
     *                         .period(123)
     *                         .periodType("periodType")
     *                         .build())
     *                 .build())
     *         .enrollmentFlags(EnrollmentFlagsV2Property.builder()
     *                 .enableKeyReuseOnNtTokenKeysetStorageFull(false)
     *                 .includeSymmetricAlgorithms(false)
     *                 .noSecurityExtension(false)
     *                 .removeInvalidCertificateFromPersonalStore(false)
     *                 .userInteractionRequired(false)
     *                 .build())
     *         .extensions(ExtensionsV2Property.builder()
     *                 .keyUsage(KeyUsageProperty.builder()
     *                         .usageFlags(KeyUsageFlagsProperty.builder()
     *                                 .dataEncipherment(false)
     *                                 .digitalSignature(false)
     *                                 .keyAgreement(false)
     *                                 .keyEncipherment(false)
     *                                 .nonRepudiation(false)
     *                                 .build())
     *                         // the properties below are optional
     *                         .critical(false)
     *                         .build())
     *                 // the properties below are optional
     *                 .applicationPolicies(ApplicationPoliciesProperty.builder()
     *                         .policies(List.of(ApplicationPolicyProperty.builder()
     *                                 .policyObjectIdentifier("policyObjectIdentifier")
     *                                 .policyType("policyType")
     *                                 .build()))
     *                         // the properties below are optional
     *                         .critical(false)
     *                         .build())
     *                 .build())
     *         .generalFlags(GeneralFlagsV2Property.builder()
     *                 .autoEnrollment(false)
     *                 .machineType(false)
     *                 .build())
     *         .privateKeyAttributes(PrivateKeyAttributesV2Property.builder()
     *                 .keySpec("keySpec")
     *                 .minimalKeyLength(123)
     *                 // the properties below are optional
     *                 .cryptoProviders(List.of("cryptoProviders"))
     *                 .build())
     *         .privateKeyFlags(PrivateKeyFlagsV2Property.builder()
     *                 .clientVersion("clientVersion")
     *                 // the properties below are optional
     *                 .exportableKey(false)
     *                 .strongKeyProtectionRequired(false)
     *                 .build())
     *         .subjectNameFlags(SubjectNameFlagsV2Property.builder()
     *                 .requireCommonName(false)
     *                 .requireDirectoryPath(false)
     *                 .requireDnsAsCn(false)
     *                 .requireEmail(false)
     *                 .sanRequireDirectoryGuid(false)
     *                 .sanRequireDns(false)
     *                 .sanRequireDomainDns(false)
     *                 .sanRequireEmail(false)
     *                 .sanRequireSpn(false)
     *                 .sanRequireUpn(false)
     *                 .build())
     *         // the properties below are optional
     *         .supersededTemplates(List.of("supersededTemplates"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev2.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev2.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.TemplateV2Property")
    @software.amazon.jsii.Jsii.Proxy(TemplateV2Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TemplateV2Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * Certificate validity describes the validity and renewal periods of a certificate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev2.html#cfn-pcaconnectorad-template-templatev2-certificatevalidity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev2.html#cfn-pcaconnectorad-template-templatev2-certificatevalidity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCertificateValidity();

        /**
         * Enrollment flags describe the enrollment settings for certificates such as using the existing private key and deleting expired or revoked certificates.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev2.html#cfn-pcaconnectorad-template-templatev2-enrollmentflags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev2.html#cfn-pcaconnectorad-template-templatev2-enrollmentflags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnrollmentFlags();

        /**
         * Extensions describe the key usage extensions and application policies for a template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev2.html#cfn-pcaconnectorad-template-templatev2-extensions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev2.html#cfn-pcaconnectorad-template-templatev2-extensions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getExtensions();

        /**
         * General flags describe whether the template is used for computers or users and if the template can be used with autoenrollment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev2.html#cfn-pcaconnectorad-template-templatev2-generalflags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev2.html#cfn-pcaconnectorad-template-templatev2-generalflags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getGeneralFlags();

        /**
         * Private key attributes allow you to specify the minimal key length, key spec, and cryptographic providers for the private key of a certificate for v2 templates.
         * <p>
         * V2 templates allow you to use Legacy Cryptographic Service Providers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev2.html#cfn-pcaconnectorad-template-templatev2-privatekeyattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev2.html#cfn-pcaconnectorad-template-templatev2-privatekeyattributes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPrivateKeyAttributes();

        /**
         * Private key flags for v2 templates specify the client compatibility, if the private key can be exported, and if user input is required when using a private key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev2.html#cfn-pcaconnectorad-template-templatev2-privatekeyflags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev2.html#cfn-pcaconnectorad-template-templatev2-privatekeyflags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPrivateKeyFlags();

        /**
         * Subject name flags describe the subject name and subject alternate name that is included in a certificate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev2.html#cfn-pcaconnectorad-template-templatev2-subjectnameflags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev2.html#cfn-pcaconnectorad-template-templatev2-subjectnameflags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSubjectNameFlags();

        /**
         * List of templates in Active Directory that are superseded by this template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev2.html#cfn-pcaconnectorad-template-templatev2-supersededtemplates">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev2.html#cfn-pcaconnectorad-template-templatev2-supersededtemplates</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSupersededTemplates() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TemplateV2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TemplateV2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TemplateV2Property> {
            java.lang.Object certificateValidity;
            java.lang.Object enrollmentFlags;
            java.lang.Object extensions;
            java.lang.Object generalFlags;
            java.lang.Object privateKeyAttributes;
            java.lang.Object privateKeyFlags;
            java.lang.Object subjectNameFlags;
            java.util.List<java.lang.String> supersededTemplates;

            /**
             * Sets the value of {@link TemplateV2Property#getCertificateValidity}
             * @param certificateValidity Certificate validity describes the validity and renewal periods of a certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateValidity(software.amazon.awscdk.IResolvable certificateValidity) {
                this.certificateValidity = certificateValidity;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV2Property#getCertificateValidity}
             * @param certificateValidity Certificate validity describes the validity and renewal periods of a certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateValidity(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.CertificateValidityProperty certificateValidity) {
                this.certificateValidity = certificateValidity;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV2Property#getEnrollmentFlags}
             * @param enrollmentFlags Enrollment flags describe the enrollment settings for certificates such as using the existing private key and deleting expired or revoked certificates. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enrollmentFlags(software.amazon.awscdk.IResolvable enrollmentFlags) {
                this.enrollmentFlags = enrollmentFlags;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV2Property#getEnrollmentFlags}
             * @param enrollmentFlags Enrollment flags describe the enrollment settings for certificates such as using the existing private key and deleting expired or revoked certificates. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enrollmentFlags(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.EnrollmentFlagsV2Property enrollmentFlags) {
                this.enrollmentFlags = enrollmentFlags;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV2Property#getExtensions}
             * @param extensions Extensions describe the key usage extensions and application policies for a template. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extensions(software.amazon.awscdk.IResolvable extensions) {
                this.extensions = extensions;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV2Property#getExtensions}
             * @param extensions Extensions describe the key usage extensions and application policies for a template. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extensions(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.ExtensionsV2Property extensions) {
                this.extensions = extensions;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV2Property#getGeneralFlags}
             * @param generalFlags General flags describe whether the template is used for computers or users and if the template can be used with autoenrollment. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder generalFlags(software.amazon.awscdk.IResolvable generalFlags) {
                this.generalFlags = generalFlags;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV2Property#getGeneralFlags}
             * @param generalFlags General flags describe whether the template is used for computers or users and if the template can be used with autoenrollment. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder generalFlags(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.GeneralFlagsV2Property generalFlags) {
                this.generalFlags = generalFlags;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV2Property#getPrivateKeyAttributes}
             * @param privateKeyAttributes Private key attributes allow you to specify the minimal key length, key spec, and cryptographic providers for the private key of a certificate for v2 templates. This parameter is required.
             *                             V2 templates allow you to use Legacy Cryptographic Service Providers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateKeyAttributes(software.amazon.awscdk.IResolvable privateKeyAttributes) {
                this.privateKeyAttributes = privateKeyAttributes;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV2Property#getPrivateKeyAttributes}
             * @param privateKeyAttributes Private key attributes allow you to specify the minimal key length, key spec, and cryptographic providers for the private key of a certificate for v2 templates. This parameter is required.
             *                             V2 templates allow you to use Legacy Cryptographic Service Providers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateKeyAttributes(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.PrivateKeyAttributesV2Property privateKeyAttributes) {
                this.privateKeyAttributes = privateKeyAttributes;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV2Property#getPrivateKeyFlags}
             * @param privateKeyFlags Private key flags for v2 templates specify the client compatibility, if the private key can be exported, and if user input is required when using a private key. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateKeyFlags(software.amazon.awscdk.IResolvable privateKeyFlags) {
                this.privateKeyFlags = privateKeyFlags;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV2Property#getPrivateKeyFlags}
             * @param privateKeyFlags Private key flags for v2 templates specify the client compatibility, if the private key can be exported, and if user input is required when using a private key. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateKeyFlags(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.PrivateKeyFlagsV2Property privateKeyFlags) {
                this.privateKeyFlags = privateKeyFlags;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV2Property#getSubjectNameFlags}
             * @param subjectNameFlags Subject name flags describe the subject name and subject alternate name that is included in a certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subjectNameFlags(software.amazon.awscdk.IResolvable subjectNameFlags) {
                this.subjectNameFlags = subjectNameFlags;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV2Property#getSubjectNameFlags}
             * @param subjectNameFlags Subject name flags describe the subject name and subject alternate name that is included in a certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subjectNameFlags(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.SubjectNameFlagsV2Property subjectNameFlags) {
                this.subjectNameFlags = subjectNameFlags;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV2Property#getSupersededTemplates}
             * @param supersededTemplates List of templates in Active Directory that are superseded by this template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder supersededTemplates(java.util.List<java.lang.String> supersededTemplates) {
                this.supersededTemplates = supersededTemplates;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TemplateV2Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TemplateV2Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TemplateV2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TemplateV2Property {
            private final java.lang.Object certificateValidity;
            private final java.lang.Object enrollmentFlags;
            private final java.lang.Object extensions;
            private final java.lang.Object generalFlags;
            private final java.lang.Object privateKeyAttributes;
            private final java.lang.Object privateKeyFlags;
            private final java.lang.Object subjectNameFlags;
            private final java.util.List<java.lang.String> supersededTemplates;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.certificateValidity = software.amazon.jsii.Kernel.get(this, "certificateValidity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enrollmentFlags = software.amazon.jsii.Kernel.get(this, "enrollmentFlags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.extensions = software.amazon.jsii.Kernel.get(this, "extensions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.generalFlags = software.amazon.jsii.Kernel.get(this, "generalFlags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.privateKeyAttributes = software.amazon.jsii.Kernel.get(this, "privateKeyAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.privateKeyFlags = software.amazon.jsii.Kernel.get(this, "privateKeyFlags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.subjectNameFlags = software.amazon.jsii.Kernel.get(this, "subjectNameFlags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.supersededTemplates = software.amazon.jsii.Kernel.get(this, "supersededTemplates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.certificateValidity = java.util.Objects.requireNonNull(builder.certificateValidity, "certificateValidity is required");
                this.enrollmentFlags = java.util.Objects.requireNonNull(builder.enrollmentFlags, "enrollmentFlags is required");
                this.extensions = java.util.Objects.requireNonNull(builder.extensions, "extensions is required");
                this.generalFlags = java.util.Objects.requireNonNull(builder.generalFlags, "generalFlags is required");
                this.privateKeyAttributes = java.util.Objects.requireNonNull(builder.privateKeyAttributes, "privateKeyAttributes is required");
                this.privateKeyFlags = java.util.Objects.requireNonNull(builder.privateKeyFlags, "privateKeyFlags is required");
                this.subjectNameFlags = java.util.Objects.requireNonNull(builder.subjectNameFlags, "subjectNameFlags is required");
                this.supersededTemplates = builder.supersededTemplates;
            }

            @Override
            public final java.lang.Object getCertificateValidity() {
                return this.certificateValidity;
            }

            @Override
            public final java.lang.Object getEnrollmentFlags() {
                return this.enrollmentFlags;
            }

            @Override
            public final java.lang.Object getExtensions() {
                return this.extensions;
            }

            @Override
            public final java.lang.Object getGeneralFlags() {
                return this.generalFlags;
            }

            @Override
            public final java.lang.Object getPrivateKeyAttributes() {
                return this.privateKeyAttributes;
            }

            @Override
            public final java.lang.Object getPrivateKeyFlags() {
                return this.privateKeyFlags;
            }

            @Override
            public final java.lang.Object getSubjectNameFlags() {
                return this.subjectNameFlags;
            }

            @Override
            public final java.util.List<java.lang.String> getSupersededTemplates() {
                return this.supersededTemplates;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("certificateValidity", om.valueToTree(this.getCertificateValidity()));
                data.set("enrollmentFlags", om.valueToTree(this.getEnrollmentFlags()));
                data.set("extensions", om.valueToTree(this.getExtensions()));
                data.set("generalFlags", om.valueToTree(this.getGeneralFlags()));
                data.set("privateKeyAttributes", om.valueToTree(this.getPrivateKeyAttributes()));
                data.set("privateKeyFlags", om.valueToTree(this.getPrivateKeyFlags()));
                data.set("subjectNameFlags", om.valueToTree(this.getSubjectNameFlags()));
                if (this.getSupersededTemplates() != null) {
                    data.set("supersededTemplates", om.valueToTree(this.getSupersededTemplates()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.TemplateV2Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TemplateV2Property.Jsii$Proxy that = (TemplateV2Property.Jsii$Proxy) o;

                if (!certificateValidity.equals(that.certificateValidity)) return false;
                if (!enrollmentFlags.equals(that.enrollmentFlags)) return false;
                if (!extensions.equals(that.extensions)) return false;
                if (!generalFlags.equals(that.generalFlags)) return false;
                if (!privateKeyAttributes.equals(that.privateKeyAttributes)) return false;
                if (!privateKeyFlags.equals(that.privateKeyFlags)) return false;
                if (!subjectNameFlags.equals(that.subjectNameFlags)) return false;
                return this.supersededTemplates != null ? this.supersededTemplates.equals(that.supersededTemplates) : that.supersededTemplates == null;
            }

            @Override
            public final int hashCode() {
                int result = this.certificateValidity.hashCode();
                result = 31 * result + (this.enrollmentFlags.hashCode());
                result = 31 * result + (this.extensions.hashCode());
                result = 31 * result + (this.generalFlags.hashCode());
                result = 31 * result + (this.privateKeyAttributes.hashCode());
                result = 31 * result + (this.privateKeyFlags.hashCode());
                result = 31 * result + (this.subjectNameFlags.hashCode());
                result = 31 * result + (this.supersededTemplates != null ? this.supersededTemplates.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * v3 template schema that uses Key Storage Providers.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pcaconnectorad.*;
     * TemplateV3Property templateV3Property = TemplateV3Property.builder()
     *         .certificateValidity(CertificateValidityProperty.builder()
     *                 .renewalPeriod(ValidityPeriodProperty.builder()
     *                         .period(123)
     *                         .periodType("periodType")
     *                         .build())
     *                 .validityPeriod(ValidityPeriodProperty.builder()
     *                         .period(123)
     *                         .periodType("periodType")
     *                         .build())
     *                 .build())
     *         .enrollmentFlags(EnrollmentFlagsV3Property.builder()
     *                 .enableKeyReuseOnNtTokenKeysetStorageFull(false)
     *                 .includeSymmetricAlgorithms(false)
     *                 .noSecurityExtension(false)
     *                 .removeInvalidCertificateFromPersonalStore(false)
     *                 .userInteractionRequired(false)
     *                 .build())
     *         .extensions(ExtensionsV3Property.builder()
     *                 .keyUsage(KeyUsageProperty.builder()
     *                         .usageFlags(KeyUsageFlagsProperty.builder()
     *                                 .dataEncipherment(false)
     *                                 .digitalSignature(false)
     *                                 .keyAgreement(false)
     *                                 .keyEncipherment(false)
     *                                 .nonRepudiation(false)
     *                                 .build())
     *                         // the properties below are optional
     *                         .critical(false)
     *                         .build())
     *                 // the properties below are optional
     *                 .applicationPolicies(ApplicationPoliciesProperty.builder()
     *                         .policies(List.of(ApplicationPolicyProperty.builder()
     *                                 .policyObjectIdentifier("policyObjectIdentifier")
     *                                 .policyType("policyType")
     *                                 .build()))
     *                         // the properties below are optional
     *                         .critical(false)
     *                         .build())
     *                 .build())
     *         .generalFlags(GeneralFlagsV3Property.builder()
     *                 .autoEnrollment(false)
     *                 .machineType(false)
     *                 .build())
     *         .hashAlgorithm("hashAlgorithm")
     *         .privateKeyAttributes(PrivateKeyAttributesV3Property.builder()
     *                 .algorithm("algorithm")
     *                 .keySpec("keySpec")
     *                 .keyUsageProperty(KeyUsagePropertyProperty.builder()
     *                         .propertyFlags(KeyUsagePropertyFlagsProperty.builder()
     *                                 .decrypt(false)
     *                                 .keyAgreement(false)
     *                                 .sign(false)
     *                                 .build())
     *                         .propertyType("propertyType")
     *                         .build())
     *                 .minimalKeyLength(123)
     *                 // the properties below are optional
     *                 .cryptoProviders(List.of("cryptoProviders"))
     *                 .build())
     *         .privateKeyFlags(PrivateKeyFlagsV3Property.builder()
     *                 .clientVersion("clientVersion")
     *                 // the properties below are optional
     *                 .exportableKey(false)
     *                 .requireAlternateSignatureAlgorithm(false)
     *                 .strongKeyProtectionRequired(false)
     *                 .build())
     *         .subjectNameFlags(SubjectNameFlagsV3Property.builder()
     *                 .requireCommonName(false)
     *                 .requireDirectoryPath(false)
     *                 .requireDnsAsCn(false)
     *                 .requireEmail(false)
     *                 .sanRequireDirectoryGuid(false)
     *                 .sanRequireDns(false)
     *                 .sanRequireDomainDns(false)
     *                 .sanRequireEmail(false)
     *                 .sanRequireSpn(false)
     *                 .sanRequireUpn(false)
     *                 .build())
     *         // the properties below are optional
     *         .supersededTemplates(List.of("supersededTemplates"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev3.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev3.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.TemplateV3Property")
    @software.amazon.jsii.Jsii.Proxy(TemplateV3Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TemplateV3Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * Certificate validity describes the validity and renewal periods of a certificate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev3.html#cfn-pcaconnectorad-template-templatev3-certificatevalidity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev3.html#cfn-pcaconnectorad-template-templatev3-certificatevalidity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCertificateValidity();

        /**
         * Enrollment flags describe the enrollment settings for certificates such as using the existing private key and deleting expired or revoked certificates.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev3.html#cfn-pcaconnectorad-template-templatev3-enrollmentflags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev3.html#cfn-pcaconnectorad-template-templatev3-enrollmentflags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnrollmentFlags();

        /**
         * Extensions describe the key usage extensions and application policies for a template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev3.html#cfn-pcaconnectorad-template-templatev3-extensions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev3.html#cfn-pcaconnectorad-template-templatev3-extensions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getExtensions();

        /**
         * General flags describe whether the template is used for computers or users and if the template can be used with autoenrollment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev3.html#cfn-pcaconnectorad-template-templatev3-generalflags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev3.html#cfn-pcaconnectorad-template-templatev3-generalflags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getGeneralFlags();

        /**
         * Specifies the hash algorithm used to hash the private key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev3.html#cfn-pcaconnectorad-template-templatev3-hashalgorithm">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev3.html#cfn-pcaconnectorad-template-templatev3-hashalgorithm</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHashAlgorithm();

        /**
         * Private key attributes allow you to specify the algorithm, minimal key length, key spec, key usage, and cryptographic providers for the private key of a certificate for v3 templates.
         * <p>
         * V3 templates allow you to use Key Storage Providers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev3.html#cfn-pcaconnectorad-template-templatev3-privatekeyattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev3.html#cfn-pcaconnectorad-template-templatev3-privatekeyattributes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPrivateKeyAttributes();

        /**
         * Private key flags for v3 templates specify the client compatibility, if the private key can be exported, if user input is required when using a private key, and if an alternate signature algorithm should be used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev3.html#cfn-pcaconnectorad-template-templatev3-privatekeyflags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev3.html#cfn-pcaconnectorad-template-templatev3-privatekeyflags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPrivateKeyFlags();

        /**
         * Subject name flags describe the subject name and subject alternate name that is included in a certificate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev3.html#cfn-pcaconnectorad-template-templatev3-subjectnameflags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev3.html#cfn-pcaconnectorad-template-templatev3-subjectnameflags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSubjectNameFlags();

        /**
         * List of templates in Active Directory that are superseded by this template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev3.html#cfn-pcaconnectorad-template-templatev3-supersededtemplates">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev3.html#cfn-pcaconnectorad-template-templatev3-supersededtemplates</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSupersededTemplates() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TemplateV3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TemplateV3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TemplateV3Property> {
            java.lang.Object certificateValidity;
            java.lang.Object enrollmentFlags;
            java.lang.Object extensions;
            java.lang.Object generalFlags;
            java.lang.String hashAlgorithm;
            java.lang.Object privateKeyAttributes;
            java.lang.Object privateKeyFlags;
            java.lang.Object subjectNameFlags;
            java.util.List<java.lang.String> supersededTemplates;

            /**
             * Sets the value of {@link TemplateV3Property#getCertificateValidity}
             * @param certificateValidity Certificate validity describes the validity and renewal periods of a certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateValidity(software.amazon.awscdk.IResolvable certificateValidity) {
                this.certificateValidity = certificateValidity;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV3Property#getCertificateValidity}
             * @param certificateValidity Certificate validity describes the validity and renewal periods of a certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateValidity(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.CertificateValidityProperty certificateValidity) {
                this.certificateValidity = certificateValidity;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV3Property#getEnrollmentFlags}
             * @param enrollmentFlags Enrollment flags describe the enrollment settings for certificates such as using the existing private key and deleting expired or revoked certificates. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enrollmentFlags(software.amazon.awscdk.IResolvable enrollmentFlags) {
                this.enrollmentFlags = enrollmentFlags;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV3Property#getEnrollmentFlags}
             * @param enrollmentFlags Enrollment flags describe the enrollment settings for certificates such as using the existing private key and deleting expired or revoked certificates. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enrollmentFlags(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.EnrollmentFlagsV3Property enrollmentFlags) {
                this.enrollmentFlags = enrollmentFlags;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV3Property#getExtensions}
             * @param extensions Extensions describe the key usage extensions and application policies for a template. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extensions(software.amazon.awscdk.IResolvable extensions) {
                this.extensions = extensions;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV3Property#getExtensions}
             * @param extensions Extensions describe the key usage extensions and application policies for a template. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extensions(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.ExtensionsV3Property extensions) {
                this.extensions = extensions;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV3Property#getGeneralFlags}
             * @param generalFlags General flags describe whether the template is used for computers or users and if the template can be used with autoenrollment. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder generalFlags(software.amazon.awscdk.IResolvable generalFlags) {
                this.generalFlags = generalFlags;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV3Property#getGeneralFlags}
             * @param generalFlags General flags describe whether the template is used for computers or users and if the template can be used with autoenrollment. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder generalFlags(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.GeneralFlagsV3Property generalFlags) {
                this.generalFlags = generalFlags;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV3Property#getHashAlgorithm}
             * @param hashAlgorithm Specifies the hash algorithm used to hash the private key. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hashAlgorithm(java.lang.String hashAlgorithm) {
                this.hashAlgorithm = hashAlgorithm;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV3Property#getPrivateKeyAttributes}
             * @param privateKeyAttributes Private key attributes allow you to specify the algorithm, minimal key length, key spec, key usage, and cryptographic providers for the private key of a certificate for v3 templates. This parameter is required.
             *                             V3 templates allow you to use Key Storage Providers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateKeyAttributes(software.amazon.awscdk.IResolvable privateKeyAttributes) {
                this.privateKeyAttributes = privateKeyAttributes;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV3Property#getPrivateKeyAttributes}
             * @param privateKeyAttributes Private key attributes allow you to specify the algorithm, minimal key length, key spec, key usage, and cryptographic providers for the private key of a certificate for v3 templates. This parameter is required.
             *                             V3 templates allow you to use Key Storage Providers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateKeyAttributes(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.PrivateKeyAttributesV3Property privateKeyAttributes) {
                this.privateKeyAttributes = privateKeyAttributes;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV3Property#getPrivateKeyFlags}
             * @param privateKeyFlags Private key flags for v3 templates specify the client compatibility, if the private key can be exported, if user input is required when using a private key, and if an alternate signature algorithm should be used. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateKeyFlags(software.amazon.awscdk.IResolvable privateKeyFlags) {
                this.privateKeyFlags = privateKeyFlags;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV3Property#getPrivateKeyFlags}
             * @param privateKeyFlags Private key flags for v3 templates specify the client compatibility, if the private key can be exported, if user input is required when using a private key, and if an alternate signature algorithm should be used. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateKeyFlags(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.PrivateKeyFlagsV3Property privateKeyFlags) {
                this.privateKeyFlags = privateKeyFlags;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV3Property#getSubjectNameFlags}
             * @param subjectNameFlags Subject name flags describe the subject name and subject alternate name that is included in a certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subjectNameFlags(software.amazon.awscdk.IResolvable subjectNameFlags) {
                this.subjectNameFlags = subjectNameFlags;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV3Property#getSubjectNameFlags}
             * @param subjectNameFlags Subject name flags describe the subject name and subject alternate name that is included in a certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subjectNameFlags(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.SubjectNameFlagsV3Property subjectNameFlags) {
                this.subjectNameFlags = subjectNameFlags;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV3Property#getSupersededTemplates}
             * @param supersededTemplates List of templates in Active Directory that are superseded by this template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder supersededTemplates(java.util.List<java.lang.String> supersededTemplates) {
                this.supersededTemplates = supersededTemplates;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TemplateV3Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TemplateV3Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TemplateV3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TemplateV3Property {
            private final java.lang.Object certificateValidity;
            private final java.lang.Object enrollmentFlags;
            private final java.lang.Object extensions;
            private final java.lang.Object generalFlags;
            private final java.lang.String hashAlgorithm;
            private final java.lang.Object privateKeyAttributes;
            private final java.lang.Object privateKeyFlags;
            private final java.lang.Object subjectNameFlags;
            private final java.util.List<java.lang.String> supersededTemplates;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.certificateValidity = software.amazon.jsii.Kernel.get(this, "certificateValidity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enrollmentFlags = software.amazon.jsii.Kernel.get(this, "enrollmentFlags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.extensions = software.amazon.jsii.Kernel.get(this, "extensions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.generalFlags = software.amazon.jsii.Kernel.get(this, "generalFlags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.hashAlgorithm = software.amazon.jsii.Kernel.get(this, "hashAlgorithm", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.privateKeyAttributes = software.amazon.jsii.Kernel.get(this, "privateKeyAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.privateKeyFlags = software.amazon.jsii.Kernel.get(this, "privateKeyFlags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.subjectNameFlags = software.amazon.jsii.Kernel.get(this, "subjectNameFlags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.supersededTemplates = software.amazon.jsii.Kernel.get(this, "supersededTemplates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.certificateValidity = java.util.Objects.requireNonNull(builder.certificateValidity, "certificateValidity is required");
                this.enrollmentFlags = java.util.Objects.requireNonNull(builder.enrollmentFlags, "enrollmentFlags is required");
                this.extensions = java.util.Objects.requireNonNull(builder.extensions, "extensions is required");
                this.generalFlags = java.util.Objects.requireNonNull(builder.generalFlags, "generalFlags is required");
                this.hashAlgorithm = java.util.Objects.requireNonNull(builder.hashAlgorithm, "hashAlgorithm is required");
                this.privateKeyAttributes = java.util.Objects.requireNonNull(builder.privateKeyAttributes, "privateKeyAttributes is required");
                this.privateKeyFlags = java.util.Objects.requireNonNull(builder.privateKeyFlags, "privateKeyFlags is required");
                this.subjectNameFlags = java.util.Objects.requireNonNull(builder.subjectNameFlags, "subjectNameFlags is required");
                this.supersededTemplates = builder.supersededTemplates;
            }

            @Override
            public final java.lang.Object getCertificateValidity() {
                return this.certificateValidity;
            }

            @Override
            public final java.lang.Object getEnrollmentFlags() {
                return this.enrollmentFlags;
            }

            @Override
            public final java.lang.Object getExtensions() {
                return this.extensions;
            }

            @Override
            public final java.lang.Object getGeneralFlags() {
                return this.generalFlags;
            }

            @Override
            public final java.lang.String getHashAlgorithm() {
                return this.hashAlgorithm;
            }

            @Override
            public final java.lang.Object getPrivateKeyAttributes() {
                return this.privateKeyAttributes;
            }

            @Override
            public final java.lang.Object getPrivateKeyFlags() {
                return this.privateKeyFlags;
            }

            @Override
            public final java.lang.Object getSubjectNameFlags() {
                return this.subjectNameFlags;
            }

            @Override
            public final java.util.List<java.lang.String> getSupersededTemplates() {
                return this.supersededTemplates;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("certificateValidity", om.valueToTree(this.getCertificateValidity()));
                data.set("enrollmentFlags", om.valueToTree(this.getEnrollmentFlags()));
                data.set("extensions", om.valueToTree(this.getExtensions()));
                data.set("generalFlags", om.valueToTree(this.getGeneralFlags()));
                data.set("hashAlgorithm", om.valueToTree(this.getHashAlgorithm()));
                data.set("privateKeyAttributes", om.valueToTree(this.getPrivateKeyAttributes()));
                data.set("privateKeyFlags", om.valueToTree(this.getPrivateKeyFlags()));
                data.set("subjectNameFlags", om.valueToTree(this.getSubjectNameFlags()));
                if (this.getSupersededTemplates() != null) {
                    data.set("supersededTemplates", om.valueToTree(this.getSupersededTemplates()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.TemplateV3Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TemplateV3Property.Jsii$Proxy that = (TemplateV3Property.Jsii$Proxy) o;

                if (!certificateValidity.equals(that.certificateValidity)) return false;
                if (!enrollmentFlags.equals(that.enrollmentFlags)) return false;
                if (!extensions.equals(that.extensions)) return false;
                if (!generalFlags.equals(that.generalFlags)) return false;
                if (!hashAlgorithm.equals(that.hashAlgorithm)) return false;
                if (!privateKeyAttributes.equals(that.privateKeyAttributes)) return false;
                if (!privateKeyFlags.equals(that.privateKeyFlags)) return false;
                if (!subjectNameFlags.equals(that.subjectNameFlags)) return false;
                return this.supersededTemplates != null ? this.supersededTemplates.equals(that.supersededTemplates) : that.supersededTemplates == null;
            }

            @Override
            public final int hashCode() {
                int result = this.certificateValidity.hashCode();
                result = 31 * result + (this.enrollmentFlags.hashCode());
                result = 31 * result + (this.extensions.hashCode());
                result = 31 * result + (this.generalFlags.hashCode());
                result = 31 * result + (this.hashAlgorithm.hashCode());
                result = 31 * result + (this.privateKeyAttributes.hashCode());
                result = 31 * result + (this.privateKeyFlags.hashCode());
                result = 31 * result + (this.subjectNameFlags.hashCode());
                result = 31 * result + (this.supersededTemplates != null ? this.supersededTemplates.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * v4 template schema that can use either Legacy Cryptographic Providers or Key Storage Providers.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pcaconnectorad.*;
     * TemplateV4Property templateV4Property = TemplateV4Property.builder()
     *         .certificateValidity(CertificateValidityProperty.builder()
     *                 .renewalPeriod(ValidityPeriodProperty.builder()
     *                         .period(123)
     *                         .periodType("periodType")
     *                         .build())
     *                 .validityPeriod(ValidityPeriodProperty.builder()
     *                         .period(123)
     *                         .periodType("periodType")
     *                         .build())
     *                 .build())
     *         .enrollmentFlags(EnrollmentFlagsV4Property.builder()
     *                 .enableKeyReuseOnNtTokenKeysetStorageFull(false)
     *                 .includeSymmetricAlgorithms(false)
     *                 .noSecurityExtension(false)
     *                 .removeInvalidCertificateFromPersonalStore(false)
     *                 .userInteractionRequired(false)
     *                 .build())
     *         .extensions(ExtensionsV4Property.builder()
     *                 .keyUsage(KeyUsageProperty.builder()
     *                         .usageFlags(KeyUsageFlagsProperty.builder()
     *                                 .dataEncipherment(false)
     *                                 .digitalSignature(false)
     *                                 .keyAgreement(false)
     *                                 .keyEncipherment(false)
     *                                 .nonRepudiation(false)
     *                                 .build())
     *                         // the properties below are optional
     *                         .critical(false)
     *                         .build())
     *                 // the properties below are optional
     *                 .applicationPolicies(ApplicationPoliciesProperty.builder()
     *                         .policies(List.of(ApplicationPolicyProperty.builder()
     *                                 .policyObjectIdentifier("policyObjectIdentifier")
     *                                 .policyType("policyType")
     *                                 .build()))
     *                         // the properties below are optional
     *                         .critical(false)
     *                         .build())
     *                 .build())
     *         .generalFlags(GeneralFlagsV4Property.builder()
     *                 .autoEnrollment(false)
     *                 .machineType(false)
     *                 .build())
     *         .privateKeyAttributes(PrivateKeyAttributesV4Property.builder()
     *                 .keySpec("keySpec")
     *                 .minimalKeyLength(123)
     *                 // the properties below are optional
     *                 .algorithm("algorithm")
     *                 .cryptoProviders(List.of("cryptoProviders"))
     *                 .keyUsageProperty(KeyUsagePropertyProperty.builder()
     *                         .propertyFlags(KeyUsagePropertyFlagsProperty.builder()
     *                                 .decrypt(false)
     *                                 .keyAgreement(false)
     *                                 .sign(false)
     *                                 .build())
     *                         .propertyType("propertyType")
     *                         .build())
     *                 .build())
     *         .privateKeyFlags(PrivateKeyFlagsV4Property.builder()
     *                 .clientVersion("clientVersion")
     *                 // the properties below are optional
     *                 .exportableKey(false)
     *                 .requireAlternateSignatureAlgorithm(false)
     *                 .requireSameKeyRenewal(false)
     *                 .strongKeyProtectionRequired(false)
     *                 .useLegacyProvider(false)
     *                 .build())
     *         .subjectNameFlags(SubjectNameFlagsV4Property.builder()
     *                 .requireCommonName(false)
     *                 .requireDirectoryPath(false)
     *                 .requireDnsAsCn(false)
     *                 .requireEmail(false)
     *                 .sanRequireDirectoryGuid(false)
     *                 .sanRequireDns(false)
     *                 .sanRequireDomainDns(false)
     *                 .sanRequireEmail(false)
     *                 .sanRequireSpn(false)
     *                 .sanRequireUpn(false)
     *                 .build())
     *         // the properties below are optional
     *         .hashAlgorithm("hashAlgorithm")
     *         .supersededTemplates(List.of("supersededTemplates"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev4.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev4.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.TemplateV4Property")
    @software.amazon.jsii.Jsii.Proxy(TemplateV4Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TemplateV4Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * Certificate validity describes the validity and renewal periods of a certificate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev4.html#cfn-pcaconnectorad-template-templatev4-certificatevalidity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev4.html#cfn-pcaconnectorad-template-templatev4-certificatevalidity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCertificateValidity();

        /**
         * Enrollment flags describe the enrollment settings for certificates using the existing private key and deleting expired or revoked certificates.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev4.html#cfn-pcaconnectorad-template-templatev4-enrollmentflags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev4.html#cfn-pcaconnectorad-template-templatev4-enrollmentflags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnrollmentFlags();

        /**
         * Extensions describe the key usage extensions and application policies for a template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev4.html#cfn-pcaconnectorad-template-templatev4-extensions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev4.html#cfn-pcaconnectorad-template-templatev4-extensions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getExtensions();

        /**
         * General flags describe whether the template is used for computers or users and if the template can be used with autoenrollment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev4.html#cfn-pcaconnectorad-template-templatev4-generalflags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev4.html#cfn-pcaconnectorad-template-templatev4-generalflags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getGeneralFlags();

        /**
         * Private key attributes allow you to specify the minimal key length, key spec, key usage, and cryptographic providers for the private key of a certificate for v4 templates.
         * <p>
         * V4 templates allow you to use either Key Storage Providers or Legacy Cryptographic Service Providers. You specify the cryptography provider category in private key flags.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev4.html#cfn-pcaconnectorad-template-templatev4-privatekeyattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev4.html#cfn-pcaconnectorad-template-templatev4-privatekeyattributes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPrivateKeyAttributes();

        /**
         * Private key flags for v4 templates specify the client compatibility, if the private key can be exported, if user input is required when using a private key, if an alternate signature algorithm should be used, and if certificates are renewed using the same private key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev4.html#cfn-pcaconnectorad-template-templatev4-privatekeyflags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev4.html#cfn-pcaconnectorad-template-templatev4-privatekeyflags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPrivateKeyFlags();

        /**
         * Subject name flags describe the subject name and subject alternate name that is included in a certificate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev4.html#cfn-pcaconnectorad-template-templatev4-subjectnameflags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev4.html#cfn-pcaconnectorad-template-templatev4-subjectnameflags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSubjectNameFlags();

        /**
         * Specifies the hash algorithm used to hash the private key.
         * <p>
         * Hash algorithm can only be specified when using Key Storage Providers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev4.html#cfn-pcaconnectorad-template-templatev4-hashalgorithm">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev4.html#cfn-pcaconnectorad-template-templatev4-hashalgorithm</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHashAlgorithm() {
            return null;
        }

        /**
         * List of templates in Active Directory that are superseded by this template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev4.html#cfn-pcaconnectorad-template-templatev4-supersededtemplates">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-templatev4.html#cfn-pcaconnectorad-template-templatev4-supersededtemplates</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSupersededTemplates() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TemplateV4Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TemplateV4Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TemplateV4Property> {
            java.lang.Object certificateValidity;
            java.lang.Object enrollmentFlags;
            java.lang.Object extensions;
            java.lang.Object generalFlags;
            java.lang.Object privateKeyAttributes;
            java.lang.Object privateKeyFlags;
            java.lang.Object subjectNameFlags;
            java.lang.String hashAlgorithm;
            java.util.List<java.lang.String> supersededTemplates;

            /**
             * Sets the value of {@link TemplateV4Property#getCertificateValidity}
             * @param certificateValidity Certificate validity describes the validity and renewal periods of a certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateValidity(software.amazon.awscdk.IResolvable certificateValidity) {
                this.certificateValidity = certificateValidity;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV4Property#getCertificateValidity}
             * @param certificateValidity Certificate validity describes the validity and renewal periods of a certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateValidity(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.CertificateValidityProperty certificateValidity) {
                this.certificateValidity = certificateValidity;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV4Property#getEnrollmentFlags}
             * @param enrollmentFlags Enrollment flags describe the enrollment settings for certificates using the existing private key and deleting expired or revoked certificates. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enrollmentFlags(software.amazon.awscdk.IResolvable enrollmentFlags) {
                this.enrollmentFlags = enrollmentFlags;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV4Property#getEnrollmentFlags}
             * @param enrollmentFlags Enrollment flags describe the enrollment settings for certificates using the existing private key and deleting expired or revoked certificates. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enrollmentFlags(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.EnrollmentFlagsV4Property enrollmentFlags) {
                this.enrollmentFlags = enrollmentFlags;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV4Property#getExtensions}
             * @param extensions Extensions describe the key usage extensions and application policies for a template. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extensions(software.amazon.awscdk.IResolvable extensions) {
                this.extensions = extensions;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV4Property#getExtensions}
             * @param extensions Extensions describe the key usage extensions and application policies for a template. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extensions(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.ExtensionsV4Property extensions) {
                this.extensions = extensions;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV4Property#getGeneralFlags}
             * @param generalFlags General flags describe whether the template is used for computers or users and if the template can be used with autoenrollment. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder generalFlags(software.amazon.awscdk.IResolvable generalFlags) {
                this.generalFlags = generalFlags;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV4Property#getGeneralFlags}
             * @param generalFlags General flags describe whether the template is used for computers or users and if the template can be used with autoenrollment. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder generalFlags(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.GeneralFlagsV4Property generalFlags) {
                this.generalFlags = generalFlags;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV4Property#getPrivateKeyAttributes}
             * @param privateKeyAttributes Private key attributes allow you to specify the minimal key length, key spec, key usage, and cryptographic providers for the private key of a certificate for v4 templates. This parameter is required.
             *                             V4 templates allow you to use either Key Storage Providers or Legacy Cryptographic Service Providers. You specify the cryptography provider category in private key flags.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateKeyAttributes(software.amazon.awscdk.IResolvable privateKeyAttributes) {
                this.privateKeyAttributes = privateKeyAttributes;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV4Property#getPrivateKeyAttributes}
             * @param privateKeyAttributes Private key attributes allow you to specify the minimal key length, key spec, key usage, and cryptographic providers for the private key of a certificate for v4 templates. This parameter is required.
             *                             V4 templates allow you to use either Key Storage Providers or Legacy Cryptographic Service Providers. You specify the cryptography provider category in private key flags.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateKeyAttributes(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.PrivateKeyAttributesV4Property privateKeyAttributes) {
                this.privateKeyAttributes = privateKeyAttributes;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV4Property#getPrivateKeyFlags}
             * @param privateKeyFlags Private key flags for v4 templates specify the client compatibility, if the private key can be exported, if user input is required when using a private key, if an alternate signature algorithm should be used, and if certificates are renewed using the same private key. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateKeyFlags(software.amazon.awscdk.IResolvable privateKeyFlags) {
                this.privateKeyFlags = privateKeyFlags;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV4Property#getPrivateKeyFlags}
             * @param privateKeyFlags Private key flags for v4 templates specify the client compatibility, if the private key can be exported, if user input is required when using a private key, if an alternate signature algorithm should be used, and if certificates are renewed using the same private key. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateKeyFlags(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.PrivateKeyFlagsV4Property privateKeyFlags) {
                this.privateKeyFlags = privateKeyFlags;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV4Property#getSubjectNameFlags}
             * @param subjectNameFlags Subject name flags describe the subject name and subject alternate name that is included in a certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subjectNameFlags(software.amazon.awscdk.IResolvable subjectNameFlags) {
                this.subjectNameFlags = subjectNameFlags;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV4Property#getSubjectNameFlags}
             * @param subjectNameFlags Subject name flags describe the subject name and subject alternate name that is included in a certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subjectNameFlags(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.SubjectNameFlagsV4Property subjectNameFlags) {
                this.subjectNameFlags = subjectNameFlags;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV4Property#getHashAlgorithm}
             * @param hashAlgorithm Specifies the hash algorithm used to hash the private key.
             *                      Hash algorithm can only be specified when using Key Storage Providers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hashAlgorithm(java.lang.String hashAlgorithm) {
                this.hashAlgorithm = hashAlgorithm;
                return this;
            }

            /**
             * Sets the value of {@link TemplateV4Property#getSupersededTemplates}
             * @param supersededTemplates List of templates in Active Directory that are superseded by this template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder supersededTemplates(java.util.List<java.lang.String> supersededTemplates) {
                this.supersededTemplates = supersededTemplates;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TemplateV4Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TemplateV4Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TemplateV4Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TemplateV4Property {
            private final java.lang.Object certificateValidity;
            private final java.lang.Object enrollmentFlags;
            private final java.lang.Object extensions;
            private final java.lang.Object generalFlags;
            private final java.lang.Object privateKeyAttributes;
            private final java.lang.Object privateKeyFlags;
            private final java.lang.Object subjectNameFlags;
            private final java.lang.String hashAlgorithm;
            private final java.util.List<java.lang.String> supersededTemplates;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.certificateValidity = software.amazon.jsii.Kernel.get(this, "certificateValidity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enrollmentFlags = software.amazon.jsii.Kernel.get(this, "enrollmentFlags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.extensions = software.amazon.jsii.Kernel.get(this, "extensions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.generalFlags = software.amazon.jsii.Kernel.get(this, "generalFlags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.privateKeyAttributes = software.amazon.jsii.Kernel.get(this, "privateKeyAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.privateKeyFlags = software.amazon.jsii.Kernel.get(this, "privateKeyFlags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.subjectNameFlags = software.amazon.jsii.Kernel.get(this, "subjectNameFlags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.hashAlgorithm = software.amazon.jsii.Kernel.get(this, "hashAlgorithm", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.supersededTemplates = software.amazon.jsii.Kernel.get(this, "supersededTemplates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.certificateValidity = java.util.Objects.requireNonNull(builder.certificateValidity, "certificateValidity is required");
                this.enrollmentFlags = java.util.Objects.requireNonNull(builder.enrollmentFlags, "enrollmentFlags is required");
                this.extensions = java.util.Objects.requireNonNull(builder.extensions, "extensions is required");
                this.generalFlags = java.util.Objects.requireNonNull(builder.generalFlags, "generalFlags is required");
                this.privateKeyAttributes = java.util.Objects.requireNonNull(builder.privateKeyAttributes, "privateKeyAttributes is required");
                this.privateKeyFlags = java.util.Objects.requireNonNull(builder.privateKeyFlags, "privateKeyFlags is required");
                this.subjectNameFlags = java.util.Objects.requireNonNull(builder.subjectNameFlags, "subjectNameFlags is required");
                this.hashAlgorithm = builder.hashAlgorithm;
                this.supersededTemplates = builder.supersededTemplates;
            }

            @Override
            public final java.lang.Object getCertificateValidity() {
                return this.certificateValidity;
            }

            @Override
            public final java.lang.Object getEnrollmentFlags() {
                return this.enrollmentFlags;
            }

            @Override
            public final java.lang.Object getExtensions() {
                return this.extensions;
            }

            @Override
            public final java.lang.Object getGeneralFlags() {
                return this.generalFlags;
            }

            @Override
            public final java.lang.Object getPrivateKeyAttributes() {
                return this.privateKeyAttributes;
            }

            @Override
            public final java.lang.Object getPrivateKeyFlags() {
                return this.privateKeyFlags;
            }

            @Override
            public final java.lang.Object getSubjectNameFlags() {
                return this.subjectNameFlags;
            }

            @Override
            public final java.lang.String getHashAlgorithm() {
                return this.hashAlgorithm;
            }

            @Override
            public final java.util.List<java.lang.String> getSupersededTemplates() {
                return this.supersededTemplates;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("certificateValidity", om.valueToTree(this.getCertificateValidity()));
                data.set("enrollmentFlags", om.valueToTree(this.getEnrollmentFlags()));
                data.set("extensions", om.valueToTree(this.getExtensions()));
                data.set("generalFlags", om.valueToTree(this.getGeneralFlags()));
                data.set("privateKeyAttributes", om.valueToTree(this.getPrivateKeyAttributes()));
                data.set("privateKeyFlags", om.valueToTree(this.getPrivateKeyFlags()));
                data.set("subjectNameFlags", om.valueToTree(this.getSubjectNameFlags()));
                if (this.getHashAlgorithm() != null) {
                    data.set("hashAlgorithm", om.valueToTree(this.getHashAlgorithm()));
                }
                if (this.getSupersededTemplates() != null) {
                    data.set("supersededTemplates", om.valueToTree(this.getSupersededTemplates()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.TemplateV4Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TemplateV4Property.Jsii$Proxy that = (TemplateV4Property.Jsii$Proxy) o;

                if (!certificateValidity.equals(that.certificateValidity)) return false;
                if (!enrollmentFlags.equals(that.enrollmentFlags)) return false;
                if (!extensions.equals(that.extensions)) return false;
                if (!generalFlags.equals(that.generalFlags)) return false;
                if (!privateKeyAttributes.equals(that.privateKeyAttributes)) return false;
                if (!privateKeyFlags.equals(that.privateKeyFlags)) return false;
                if (!subjectNameFlags.equals(that.subjectNameFlags)) return false;
                if (this.hashAlgorithm != null ? !this.hashAlgorithm.equals(that.hashAlgorithm) : that.hashAlgorithm != null) return false;
                return this.supersededTemplates != null ? this.supersededTemplates.equals(that.supersededTemplates) : that.supersededTemplates == null;
            }

            @Override
            public final int hashCode() {
                int result = this.certificateValidity.hashCode();
                result = 31 * result + (this.enrollmentFlags.hashCode());
                result = 31 * result + (this.extensions.hashCode());
                result = 31 * result + (this.generalFlags.hashCode());
                result = 31 * result + (this.privateKeyAttributes.hashCode());
                result = 31 * result + (this.privateKeyFlags.hashCode());
                result = 31 * result + (this.subjectNameFlags.hashCode());
                result = 31 * result + (this.hashAlgorithm != null ? this.hashAlgorithm.hashCode() : 0);
                result = 31 * result + (this.supersededTemplates != null ? this.supersededTemplates.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information describing the end of the validity period of the certificate.
     * <p>
     * This parameter sets the “Not After” date for the certificate. Certificate validity is the period of time during which a certificate is valid. Validity can be expressed as an explicit date and time when the certificate expires, or as a span of time after issuance, stated in hours, days, months, or years. For more information, see Validity in RFC 5280. This value is unaffected when ValidityNotBefore is also specified. For example, if Validity is set to 20 days in the future, the certificate will expire 20 days from issuance time regardless of the ValidityNotBefore value.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pcaconnectorad.*;
     * ValidityPeriodProperty validityPeriodProperty = ValidityPeriodProperty.builder()
     *         .period(123)
     *         .periodType("periodType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-validityperiod.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-validityperiod.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.ValidityPeriodProperty")
    @software.amazon.jsii.Jsii.Proxy(ValidityPeriodProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ValidityPeriodProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The numeric value for the validity period.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-validityperiod.html#cfn-pcaconnectorad-template-validityperiod-period">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-validityperiod.html#cfn-pcaconnectorad-template-validityperiod-period</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPeriod();

        /**
         * The unit of time.
         * <p>
         * You can select hours, days, weeks, months, and years.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-validityperiod.html#cfn-pcaconnectorad-template-validityperiod-periodtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-template-validityperiod.html#cfn-pcaconnectorad-template-validityperiod-periodtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPeriodType();

        /**
         * @return a {@link Builder} of {@link ValidityPeriodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ValidityPeriodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ValidityPeriodProperty> {
            java.lang.Number period;
            java.lang.String periodType;

            /**
             * Sets the value of {@link ValidityPeriodProperty#getPeriod}
             * @param period The numeric value for the validity period. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder period(java.lang.Number period) {
                this.period = period;
                return this;
            }

            /**
             * Sets the value of {@link ValidityPeriodProperty#getPeriodType}
             * @param periodType The unit of time. This parameter is required.
             *                   You can select hours, days, weeks, months, and years.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder periodType(java.lang.String periodType) {
                this.periodType = periodType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ValidityPeriodProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ValidityPeriodProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ValidityPeriodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ValidityPeriodProperty {
            private final java.lang.Number period;
            private final java.lang.String periodType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.period = software.amazon.jsii.Kernel.get(this, "period", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.periodType = software.amazon.jsii.Kernel.get(this, "periodType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.period = java.util.Objects.requireNonNull(builder.period, "period is required");
                this.periodType = java.util.Objects.requireNonNull(builder.periodType, "periodType is required");
            }

            @Override
            public final java.lang.Number getPeriod() {
                return this.period;
            }

            @Override
            public final java.lang.String getPeriodType() {
                return this.periodType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("period", om.valueToTree(this.getPeriod()));
                data.set("periodType", om.valueToTree(this.getPeriodType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.ValidityPeriodProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ValidityPeriodProperty.Jsii$Proxy that = (ValidityPeriodProperty.Jsii$Proxy) o;

                if (!period.equals(that.period)) return false;
                return this.periodType.equals(that.periodType);
            }

            @Override
            public final int hashCode() {
                int result = this.period.hashCode();
                result = 31 * result + (this.periodType.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.pcaconnectorad.CfnTemplate}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.pcaconnectorad.CfnTemplate> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.pcaconnectorad.CfnTemplateProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.pcaconnectorad.CfnTemplateProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html">CreateConnector</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-template.html#cfn-pcaconnectorad-template-connectorarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-template.html#cfn-pcaconnectorad-template-connectorarn</a>
         * @param connectorArn The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html">CreateConnector</a> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorArn(final java.lang.String connectorArn) {
            this.props.connectorArn(connectorArn);
            return this;
        }

        /**
         * Template configuration to define the information included in certificates.
         * <p>
         * Define certificate validity and renewal periods, certificate request handling and enrollment options, key usage extensions, application policies, and cryptography settings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-template.html#cfn-pcaconnectorad-template-definition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-template.html#cfn-pcaconnectorad-template-definition</a>
         * @param definition Template configuration to define the information included in certificates. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definition(final software.amazon.awscdk.IResolvable definition) {
            this.props.definition(definition);
            return this;
        }
        /**
         * Template configuration to define the information included in certificates.
         * <p>
         * Define certificate validity and renewal periods, certificate request handling and enrollment options, key usage extensions, application policies, and cryptography settings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-template.html#cfn-pcaconnectorad-template-definition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-template.html#cfn-pcaconnectorad-template-definition</a>
         * @param definition Template configuration to define the information included in certificates. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definition(final software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.TemplateDefinitionProperty definition) {
            this.props.definition(definition);
            return this;
        }

        /**
         * Name of the templates.
         * <p>
         * Template names must be unique.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-template.html#cfn-pcaconnectorad-template-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-template.html#cfn-pcaconnectorad-template-name</a>
         * @param name Name of the templates. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * This setting allows the major version of a template to be increased automatically.
         * <p>
         * All members of Active Directory groups that are allowed to enroll with a template will receive a new certificate issued using that template.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-template.html#cfn-pcaconnectorad-template-reenrollallcertificateholders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-template.html#cfn-pcaconnectorad-template-reenrollallcertificateholders</a>
         * @param reenrollAllCertificateHolders This setting allows the major version of a template to be increased automatically. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reenrollAllCertificateHolders(final java.lang.Boolean reenrollAllCertificateHolders) {
            this.props.reenrollAllCertificateHolders(reenrollAllCertificateHolders);
            return this;
        }
        /**
         * This setting allows the major version of a template to be increased automatically.
         * <p>
         * All members of Active Directory groups that are allowed to enroll with a template will receive a new certificate issued using that template.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-template.html#cfn-pcaconnectorad-template-reenrollallcertificateholders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-template.html#cfn-pcaconnectorad-template-reenrollallcertificateholders</a>
         * @param reenrollAllCertificateHolders This setting allows the major version of a template to be increased automatically. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reenrollAllCertificateHolders(final software.amazon.awscdk.IResolvable reenrollAllCertificateHolders) {
            this.props.reenrollAllCertificateHolders(reenrollAllCertificateHolders);
            return this;
        }

        /**
         * Metadata assigned to a template consisting of a key-value pair.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-template.html#cfn-pcaconnectorad-template-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-template.html#cfn-pcaconnectorad-template-tags</a>
         * @param tags Metadata assigned to a template consisting of a key-value pair. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.pcaconnectorad.CfnTemplate}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.pcaconnectorad.CfnTemplate build() {
            return new software.amazon.awscdk.services.pcaconnectorad.CfnTemplate(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
