package software.amazon.awscdk.services.redshiftserverless;

/**
 * A collection of database objects and users.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.redshiftserverless.*;
 * Object namespaceResourcePolicy;
 * CfnNamespace cfnNamespace = CfnNamespace.Builder.create(this, "MyCfnNamespace")
 *         .namespaceName("namespaceName")
 *         // the properties below are optional
 *         .adminPasswordSecretKmsKeyId("adminPasswordSecretKmsKeyId")
 *         .adminUsername("adminUsername")
 *         .adminUserPassword("adminUserPassword")
 *         .dbName("dbName")
 *         .defaultIamRoleArn("defaultIamRoleArn")
 *         .finalSnapshotName("finalSnapshotName")
 *         .finalSnapshotRetentionPeriod(123)
 *         .iamRoles(List.of("iamRoles"))
 *         .kmsKeyId("kmsKeyId")
 *         .logExports(List.of("logExports"))
 *         .manageAdminPassword(false)
 *         .namespaceResourcePolicy(namespaceResourcePolicy)
 *         .redshiftIdcApplicationArn("redshiftIdcApplicationArn")
 *         .snapshotCopyConfigurations(List.of(SnapshotCopyConfigurationProperty.builder()
 *                 .destinationRegion("destinationRegion")
 *                 // the properties below are optional
 *                 .destinationKmsKeyId("destinationKmsKeyId")
 *                 .snapshotRetentionPeriod(123)
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:15.015Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_redshiftserverless.CfnNamespace")
public class CfnNamespace extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnNamespace(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnNamespace(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.redshiftserverless.CfnNamespace.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnNamespace(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.redshiftserverless.CfnNamespaceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrNamespace() {
        return software.amazon.jsii.Kernel.get(this, "attrNamespace", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The username of the administrator for the first database created in the namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrNamespaceAdminUsername() {
        return software.amazon.jsii.Kernel.get(this, "attrNamespaceAdminUsername", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The date of when the namespace was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrNamespaceCreationDate() {
        return software.amazon.jsii.Kernel.get(this, "attrNamespaceCreationDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the first database created in the namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrNamespaceDbName() {
        return software.amazon.jsii.Kernel.get(this, "attrNamespaceDbName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrNamespaceDefaultIamRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "attrNamespaceDefaultIamRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A list of IAM roles to associate with the namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrNamespaceIamRoles() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrNamespaceIamRoles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The ID of the AWS Key Management Service key used to encrypt your data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrNamespaceKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "attrNamespaceKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The types of logs the namespace can export.
     * <p>
     * Available export types are <code>User log</code> , <code>Connection log</code> , and <code>User activity log</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrNamespaceLogExports() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrNamespaceLogExports", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The Amazon Resource Name (ARN) associated with a namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrNamespaceNamespaceArn() {
        return software.amazon.jsii.Kernel.get(this, "attrNamespaceNamespaceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of a namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrNamespaceNamespaceId() {
        return software.amazon.jsii.Kernel.get(this, "attrNamespaceNamespaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the namespace.
     * <p>
     * Must be between 3-64 alphanumeric characters in lowercase, and it cannot be a reserved word. A list of reserved words can be found in <a href="https://docs.aws.amazon.com//redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrNamespaceNamespaceName() {
        return software.amazon.jsii.Kernel.get(this, "attrNamespaceNamespaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrNamespaceStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrNamespaceStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name of the namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getNamespaceName() {
        return software.amazon.jsii.Kernel.get(this, "namespaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNamespaceName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "namespaceName", java.util.Objects.requireNonNull(value, "namespaceName is required"));
    }

    /**
     * The ID of the AWS Key Management Service (KMS) key used to encrypt and store the namespace's admin credentials secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAdminPasswordSecretKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "adminPasswordSecretKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the AWS Key Management Service (KMS) key used to encrypt and store the namespace's admin credentials secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdminPasswordSecretKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "adminPasswordSecretKmsKeyId", value);
    }

    /**
     * The username of the administrator for the primary database created in the namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAdminUsername() {
        return software.amazon.jsii.Kernel.get(this, "adminUsername", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The username of the administrator for the primary database created in the namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdminUsername(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "adminUsername", value);
    }

    /**
     * The password of the administrator for the primary database created in the namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAdminUserPassword() {
        return software.amazon.jsii.Kernel.get(this, "adminUserPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The password of the administrator for the primary database created in the namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdminUserPassword(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "adminUserPassword", value);
    }

    /**
     * The name of the primary database created in the namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDbName() {
        return software.amazon.jsii.Kernel.get(this, "dbName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the primary database created in the namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbName", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDefaultIamRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "defaultIamRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultIamRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "defaultIamRoleArn", value);
    }

    /**
     * The name of the snapshot to be created before the namespace is deleted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getFinalSnapshotName() {
        return software.amazon.jsii.Kernel.get(this, "finalSnapshotName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the snapshot to be created before the namespace is deleted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFinalSnapshotName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "finalSnapshotName", value);
    }

    /**
     * How long to retain the final snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getFinalSnapshotRetentionPeriod() {
        return software.amazon.jsii.Kernel.get(this, "finalSnapshotRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * How long to retain the final snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFinalSnapshotRetentionPeriod(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "finalSnapshotRetentionPeriod", value);
    }

    /**
     * A list of IAM roles to associate with the namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIamRoles() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "iamRoles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of IAM roles to associate with the namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIamRoles(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "iamRoles", value);
    }

    /**
     * The ID of the AWS Key Management Service key used to encrypt your data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the AWS Key Management Service key used to encrypt your data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyId", value);
    }

    /**
     * The types of logs the namespace can export.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLogExports() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "logExports", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The types of logs the namespace can export.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogExports(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "logExports", value);
    }

    /**
     * If true, Amazon Redshift uses AWS Secrets Manager to manage the namespace's admin credentials.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getManageAdminPassword() {
        return software.amazon.jsii.Kernel.get(this, "manageAdminPassword", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * If true, Amazon Redshift uses AWS Secrets Manager to manage the namespace's admin credentials.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setManageAdminPassword(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "manageAdminPassword", value);
    }

    /**
     * If true, Amazon Redshift uses AWS Secrets Manager to manage the namespace's admin credentials.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setManageAdminPassword(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "manageAdminPassword", value);
    }

    /**
     * The resource policy that will be attached to the namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNamespaceResourcePolicy() {
        return software.amazon.jsii.Kernel.get(this, "namespaceResourcePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The resource policy that will be attached to the namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNamespaceResourcePolicy(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "namespaceResourcePolicy", value);
    }

    /**
     * The ARN for the Redshift application that integrates with IAM Identity Center.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRedshiftIdcApplicationArn() {
        return software.amazon.jsii.Kernel.get(this, "redshiftIdcApplicationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN for the Redshift application that integrates with IAM Identity Center.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRedshiftIdcApplicationArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "redshiftIdcApplicationArn", value);
    }

    /**
     * The snapshot copy configurations for the namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSnapshotCopyConfigurations() {
        return software.amazon.jsii.Kernel.get(this, "snapshotCopyConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The snapshot copy configurations for the namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotCopyConfigurations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "snapshotCopyConfigurations", value);
    }

    /**
     * The snapshot copy configurations for the namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotCopyConfigurations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.redshiftserverless.CfnNamespace.SnapshotCopyConfigurationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.redshiftserverless.CfnNamespace.SnapshotCopyConfigurationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "snapshotCopyConfigurations", value);
    }

    /**
     * The map of the key-value pairs used to tag the namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The map of the key-value pairs used to tag the namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * A collection of database objects and users.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.redshiftserverless.*;
     * NamespaceProperty namespaceProperty = NamespaceProperty.builder()
     *         .adminPasswordSecretArn("adminPasswordSecretArn")
     *         .adminPasswordSecretKmsKeyId("adminPasswordSecretKmsKeyId")
     *         .adminUsername("adminUsername")
     *         .creationDate("creationDate")
     *         .dbName("dbName")
     *         .defaultIamRoleArn("defaultIamRoleArn")
     *         .iamRoles(List.of("iamRoles"))
     *         .kmsKeyId("kmsKeyId")
     *         .logExports(List.of("logExports"))
     *         .namespaceArn("namespaceArn")
     *         .namespaceId("namespaceId")
     *         .namespaceName("namespaceName")
     *         .status("status")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-namespace.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-namespace.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_redshiftserverless.CfnNamespace.NamespaceProperty")
    @software.amazon.jsii.Jsii.Proxy(NamespaceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NamespaceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) for the namespace's admin user credentials secret.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-namespace.html#cfn-redshiftserverless-namespace-namespace-adminpasswordsecretarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-namespace.html#cfn-redshiftserverless-namespace-namespace-adminpasswordsecretarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAdminPasswordSecretArn() {
            return null;
        }

        /**
         * The ID of the AWS Key Management Service (KMS) key used to encrypt and store the namespace's admin credentials secret.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-namespace.html#cfn-redshiftserverless-namespace-namespace-adminpasswordsecretkmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-namespace.html#cfn-redshiftserverless-namespace-namespace-adminpasswordsecretkmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAdminPasswordSecretKmsKeyId() {
            return null;
        }

        /**
         * The username of the administrator for the first database created in the namespace.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-namespace.html#cfn-redshiftserverless-namespace-namespace-adminusername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-namespace.html#cfn-redshiftserverless-namespace-namespace-adminusername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAdminUsername() {
            return null;
        }

        /**
         * The date of when the namespace was created.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-namespace.html#cfn-redshiftserverless-namespace-namespace-creationdate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-namespace.html#cfn-redshiftserverless-namespace-namespace-creationdate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCreationDate() {
            return null;
        }

        /**
         * The name of the first database created in the namespace.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-namespace.html#cfn-redshiftserverless-namespace-namespace-dbname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-namespace.html#cfn-redshiftserverless-namespace-namespace-dbname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDbName() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-namespace.html#cfn-redshiftserverless-namespace-namespace-defaultiamrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-namespace.html#cfn-redshiftserverless-namespace-namespace-defaultiamrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultIamRoleArn() {
            return null;
        }

        /**
         * A list of IAM roles to associate with the namespace.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-namespace.html#cfn-redshiftserverless-namespace-namespace-iamroles">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-namespace.html#cfn-redshiftserverless-namespace-namespace-iamroles</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIamRoles() {
            return null;
        }

        /**
         * The ID of the AWS Key Management Service key used to encrypt your data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-namespace.html#cfn-redshiftserverless-namespace-namespace-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-namespace.html#cfn-redshiftserverless-namespace-namespace-kmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * The types of logs the namespace can export.
         * <p>
         * Available export types are User log, Connection log, and User activity log.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-namespace.html#cfn-redshiftserverless-namespace-namespace-logexports">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-namespace.html#cfn-redshiftserverless-namespace-namespace-logexports</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLogExports() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) associated with a namespace.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-namespace.html#cfn-redshiftserverless-namespace-namespace-namespacearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-namespace.html#cfn-redshiftserverless-namespace-namespace-namespacearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNamespaceArn() {
            return null;
        }

        /**
         * The unique identifier of a namespace.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-namespace.html#cfn-redshiftserverless-namespace-namespace-namespaceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-namespace.html#cfn-redshiftserverless-namespace-namespace-namespaceid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNamespaceId() {
            return null;
        }

        /**
         * The name of the namespace.
         * <p>
         * Must be between 3-64 alphanumeric characters in lowercase, and it cannot be a reserved word. A list of reserved words can be found in <a href="https://docs.aws.amazon.com//redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-namespace.html#cfn-redshiftserverless-namespace-namespace-namespacename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-namespace.html#cfn-redshiftserverless-namespace-namespace-namespacename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNamespaceName() {
            return null;
        }

        /**
         * The status of the namespace.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-namespace.html#cfn-redshiftserverless-namespace-namespace-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-namespace.html#cfn-redshiftserverless-namespace-namespace-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NamespaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NamespaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NamespaceProperty> {
            java.lang.String adminPasswordSecretArn;
            java.lang.String adminPasswordSecretKmsKeyId;
            java.lang.String adminUsername;
            java.lang.String creationDate;
            java.lang.String dbName;
            java.lang.String defaultIamRoleArn;
            java.util.List<java.lang.String> iamRoles;
            java.lang.String kmsKeyId;
            java.util.List<java.lang.String> logExports;
            java.lang.String namespaceArn;
            java.lang.String namespaceId;
            java.lang.String namespaceName;
            java.lang.String status;

            /**
             * Sets the value of {@link NamespaceProperty#getAdminPasswordSecretArn}
             * @param adminPasswordSecretArn The Amazon Resource Name (ARN) for the namespace's admin user credentials secret.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder adminPasswordSecretArn(java.lang.String adminPasswordSecretArn) {
                this.adminPasswordSecretArn = adminPasswordSecretArn;
                return this;
            }

            /**
             * Sets the value of {@link NamespaceProperty#getAdminPasswordSecretKmsKeyId}
             * @param adminPasswordSecretKmsKeyId The ID of the AWS Key Management Service (KMS) key used to encrypt and store the namespace's admin credentials secret.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder adminPasswordSecretKmsKeyId(java.lang.String adminPasswordSecretKmsKeyId) {
                this.adminPasswordSecretKmsKeyId = adminPasswordSecretKmsKeyId;
                return this;
            }

            /**
             * Sets the value of {@link NamespaceProperty#getAdminUsername}
             * @param adminUsername The username of the administrator for the first database created in the namespace.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder adminUsername(java.lang.String adminUsername) {
                this.adminUsername = adminUsername;
                return this;
            }

            /**
             * Sets the value of {@link NamespaceProperty#getCreationDate}
             * @param creationDate The date of when the namespace was created.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder creationDate(java.lang.String creationDate) {
                this.creationDate = creationDate;
                return this;
            }

            /**
             * Sets the value of {@link NamespaceProperty#getDbName}
             * @param dbName The name of the first database created in the namespace.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dbName(java.lang.String dbName) {
                this.dbName = dbName;
                return this;
            }

            /**
             * Sets the value of {@link NamespaceProperty#getDefaultIamRoleArn}
             * @param defaultIamRoleArn The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultIamRoleArn(java.lang.String defaultIamRoleArn) {
                this.defaultIamRoleArn = defaultIamRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link NamespaceProperty#getIamRoles}
             * @param iamRoles A list of IAM roles to associate with the namespace.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamRoles(java.util.List<java.lang.String> iamRoles) {
                this.iamRoles = iamRoles;
                return this;
            }

            /**
             * Sets the value of {@link NamespaceProperty#getKmsKeyId}
             * @param kmsKeyId The ID of the AWS Key Management Service key used to encrypt your data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Sets the value of {@link NamespaceProperty#getLogExports}
             * @param logExports The types of logs the namespace can export.
             *                   Available export types are User log, Connection log, and User activity log.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logExports(java.util.List<java.lang.String> logExports) {
                this.logExports = logExports;
                return this;
            }

            /**
             * Sets the value of {@link NamespaceProperty#getNamespaceArn}
             * @param namespaceArn The Amazon Resource Name (ARN) associated with a namespace.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespaceArn(java.lang.String namespaceArn) {
                this.namespaceArn = namespaceArn;
                return this;
            }

            /**
             * Sets the value of {@link NamespaceProperty#getNamespaceId}
             * @param namespaceId The unique identifier of a namespace.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespaceId(java.lang.String namespaceId) {
                this.namespaceId = namespaceId;
                return this;
            }

            /**
             * Sets the value of {@link NamespaceProperty#getNamespaceName}
             * @param namespaceName The name of the namespace.
             *                      Must be between 3-64 alphanumeric characters in lowercase, and it cannot be a reserved word. A list of reserved words can be found in <a href="https://docs.aws.amazon.com//redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespaceName(java.lang.String namespaceName) {
                this.namespaceName = namespaceName;
                return this;
            }

            /**
             * Sets the value of {@link NamespaceProperty#getStatus}
             * @param status The status of the namespace.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NamespaceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NamespaceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NamespaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NamespaceProperty {
            private final java.lang.String adminPasswordSecretArn;
            private final java.lang.String adminPasswordSecretKmsKeyId;
            private final java.lang.String adminUsername;
            private final java.lang.String creationDate;
            private final java.lang.String dbName;
            private final java.lang.String defaultIamRoleArn;
            private final java.util.List<java.lang.String> iamRoles;
            private final java.lang.String kmsKeyId;
            private final java.util.List<java.lang.String> logExports;
            private final java.lang.String namespaceArn;
            private final java.lang.String namespaceId;
            private final java.lang.String namespaceName;
            private final java.lang.String status;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.adminPasswordSecretArn = software.amazon.jsii.Kernel.get(this, "adminPasswordSecretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.adminPasswordSecretKmsKeyId = software.amazon.jsii.Kernel.get(this, "adminPasswordSecretKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.adminUsername = software.amazon.jsii.Kernel.get(this, "adminUsername", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.creationDate = software.amazon.jsii.Kernel.get(this, "creationDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dbName = software.amazon.jsii.Kernel.get(this, "dbName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.defaultIamRoleArn = software.amazon.jsii.Kernel.get(this, "defaultIamRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.iamRoles = software.amazon.jsii.Kernel.get(this, "iamRoles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logExports = software.amazon.jsii.Kernel.get(this, "logExports", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.namespaceArn = software.amazon.jsii.Kernel.get(this, "namespaceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.namespaceId = software.amazon.jsii.Kernel.get(this, "namespaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.namespaceName = software.amazon.jsii.Kernel.get(this, "namespaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.adminPasswordSecretArn = builder.adminPasswordSecretArn;
                this.adminPasswordSecretKmsKeyId = builder.adminPasswordSecretKmsKeyId;
                this.adminUsername = builder.adminUsername;
                this.creationDate = builder.creationDate;
                this.dbName = builder.dbName;
                this.defaultIamRoleArn = builder.defaultIamRoleArn;
                this.iamRoles = builder.iamRoles;
                this.kmsKeyId = builder.kmsKeyId;
                this.logExports = builder.logExports;
                this.namespaceArn = builder.namespaceArn;
                this.namespaceId = builder.namespaceId;
                this.namespaceName = builder.namespaceName;
                this.status = builder.status;
            }

            @Override
            public final java.lang.String getAdminPasswordSecretArn() {
                return this.adminPasswordSecretArn;
            }

            @Override
            public final java.lang.String getAdminPasswordSecretKmsKeyId() {
                return this.adminPasswordSecretKmsKeyId;
            }

            @Override
            public final java.lang.String getAdminUsername() {
                return this.adminUsername;
            }

            @Override
            public final java.lang.String getCreationDate() {
                return this.creationDate;
            }

            @Override
            public final java.lang.String getDbName() {
                return this.dbName;
            }

            @Override
            public final java.lang.String getDefaultIamRoleArn() {
                return this.defaultIamRoleArn;
            }

            @Override
            public final java.util.List<java.lang.String> getIamRoles() {
                return this.iamRoles;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            public final java.util.List<java.lang.String> getLogExports() {
                return this.logExports;
            }

            @Override
            public final java.lang.String getNamespaceArn() {
                return this.namespaceArn;
            }

            @Override
            public final java.lang.String getNamespaceId() {
                return this.namespaceId;
            }

            @Override
            public final java.lang.String getNamespaceName() {
                return this.namespaceName;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAdminPasswordSecretArn() != null) {
                    data.set("adminPasswordSecretArn", om.valueToTree(this.getAdminPasswordSecretArn()));
                }
                if (this.getAdminPasswordSecretKmsKeyId() != null) {
                    data.set("adminPasswordSecretKmsKeyId", om.valueToTree(this.getAdminPasswordSecretKmsKeyId()));
                }
                if (this.getAdminUsername() != null) {
                    data.set("adminUsername", om.valueToTree(this.getAdminUsername()));
                }
                if (this.getCreationDate() != null) {
                    data.set("creationDate", om.valueToTree(this.getCreationDate()));
                }
                if (this.getDbName() != null) {
                    data.set("dbName", om.valueToTree(this.getDbName()));
                }
                if (this.getDefaultIamRoleArn() != null) {
                    data.set("defaultIamRoleArn", om.valueToTree(this.getDefaultIamRoleArn()));
                }
                if (this.getIamRoles() != null) {
                    data.set("iamRoles", om.valueToTree(this.getIamRoles()));
                }
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }
                if (this.getLogExports() != null) {
                    data.set("logExports", om.valueToTree(this.getLogExports()));
                }
                if (this.getNamespaceArn() != null) {
                    data.set("namespaceArn", om.valueToTree(this.getNamespaceArn()));
                }
                if (this.getNamespaceId() != null) {
                    data.set("namespaceId", om.valueToTree(this.getNamespaceId()));
                }
                if (this.getNamespaceName() != null) {
                    data.set("namespaceName", om.valueToTree(this.getNamespaceName()));
                }
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_redshiftserverless.CfnNamespace.NamespaceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NamespaceProperty.Jsii$Proxy that = (NamespaceProperty.Jsii$Proxy) o;

                if (this.adminPasswordSecretArn != null ? !this.adminPasswordSecretArn.equals(that.adminPasswordSecretArn) : that.adminPasswordSecretArn != null) return false;
                if (this.adminPasswordSecretKmsKeyId != null ? !this.adminPasswordSecretKmsKeyId.equals(that.adminPasswordSecretKmsKeyId) : that.adminPasswordSecretKmsKeyId != null) return false;
                if (this.adminUsername != null ? !this.adminUsername.equals(that.adminUsername) : that.adminUsername != null) return false;
                if (this.creationDate != null ? !this.creationDate.equals(that.creationDate) : that.creationDate != null) return false;
                if (this.dbName != null ? !this.dbName.equals(that.dbName) : that.dbName != null) return false;
                if (this.defaultIamRoleArn != null ? !this.defaultIamRoleArn.equals(that.defaultIamRoleArn) : that.defaultIamRoleArn != null) return false;
                if (this.iamRoles != null ? !this.iamRoles.equals(that.iamRoles) : that.iamRoles != null) return false;
                if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
                if (this.logExports != null ? !this.logExports.equals(that.logExports) : that.logExports != null) return false;
                if (this.namespaceArn != null ? !this.namespaceArn.equals(that.namespaceArn) : that.namespaceArn != null) return false;
                if (this.namespaceId != null ? !this.namespaceId.equals(that.namespaceId) : that.namespaceId != null) return false;
                if (this.namespaceName != null ? !this.namespaceName.equals(that.namespaceName) : that.namespaceName != null) return false;
                return this.status != null ? this.status.equals(that.status) : that.status == null;
            }

            @Override
            public final int hashCode() {
                int result = this.adminPasswordSecretArn != null ? this.adminPasswordSecretArn.hashCode() : 0;
                result = 31 * result + (this.adminPasswordSecretKmsKeyId != null ? this.adminPasswordSecretKmsKeyId.hashCode() : 0);
                result = 31 * result + (this.adminUsername != null ? this.adminUsername.hashCode() : 0);
                result = 31 * result + (this.creationDate != null ? this.creationDate.hashCode() : 0);
                result = 31 * result + (this.dbName != null ? this.dbName.hashCode() : 0);
                result = 31 * result + (this.defaultIamRoleArn != null ? this.defaultIamRoleArn.hashCode() : 0);
                result = 31 * result + (this.iamRoles != null ? this.iamRoles.hashCode() : 0);
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                result = 31 * result + (this.logExports != null ? this.logExports.hashCode() : 0);
                result = 31 * result + (this.namespaceArn != null ? this.namespaceArn.hashCode() : 0);
                result = 31 * result + (this.namespaceId != null ? this.namespaceId.hashCode() : 0);
                result = 31 * result + (this.namespaceName != null ? this.namespaceName.hashCode() : 0);
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The object that you configure to copy snapshots from one namespace to a namespace in another AWS Region .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.redshiftserverless.*;
     * SnapshotCopyConfigurationProperty snapshotCopyConfigurationProperty = SnapshotCopyConfigurationProperty.builder()
     *         .destinationRegion("destinationRegion")
     *         // the properties below are optional
     *         .destinationKmsKeyId("destinationKmsKeyId")
     *         .snapshotRetentionPeriod(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-snapshotcopyconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-snapshotcopyconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_redshiftserverless.CfnNamespace.SnapshotCopyConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SnapshotCopyConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SnapshotCopyConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The destination AWS Region to copy snapshots to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-snapshotcopyconfiguration.html#cfn-redshiftserverless-namespace-snapshotcopyconfiguration-destinationregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-snapshotcopyconfiguration.html#cfn-redshiftserverless-namespace-snapshotcopyconfiguration-destinationregion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDestinationRegion();

        /**
         * The ID of the KMS key to use to encrypt your snapshots in the destination AWS Region .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-snapshotcopyconfiguration.html#cfn-redshiftserverless-namespace-snapshotcopyconfiguration-destinationkmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-snapshotcopyconfiguration.html#cfn-redshiftserverless-namespace-snapshotcopyconfiguration-destinationkmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDestinationKmsKeyId() {
            return null;
        }

        /**
         * The retention period of snapshots that are copied to the destination AWS Region .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-snapshotcopyconfiguration.html#cfn-redshiftserverless-namespace-snapshotcopyconfiguration-snapshotretentionperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-namespace-snapshotcopyconfiguration.html#cfn-redshiftserverless-namespace-snapshotcopyconfiguration-snapshotretentionperiod</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSnapshotRetentionPeriod() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SnapshotCopyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SnapshotCopyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SnapshotCopyConfigurationProperty> {
            java.lang.String destinationRegion;
            java.lang.String destinationKmsKeyId;
            java.lang.Number snapshotRetentionPeriod;

            /**
             * Sets the value of {@link SnapshotCopyConfigurationProperty#getDestinationRegion}
             * @param destinationRegion The destination AWS Region to copy snapshots to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationRegion(java.lang.String destinationRegion) {
                this.destinationRegion = destinationRegion;
                return this;
            }

            /**
             * Sets the value of {@link SnapshotCopyConfigurationProperty#getDestinationKmsKeyId}
             * @param destinationKmsKeyId The ID of the KMS key to use to encrypt your snapshots in the destination AWS Region .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationKmsKeyId(java.lang.String destinationKmsKeyId) {
                this.destinationKmsKeyId = destinationKmsKeyId;
                return this;
            }

            /**
             * Sets the value of {@link SnapshotCopyConfigurationProperty#getSnapshotRetentionPeriod}
             * @param snapshotRetentionPeriod The retention period of snapshots that are copied to the destination AWS Region .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snapshotRetentionPeriod(java.lang.Number snapshotRetentionPeriod) {
                this.snapshotRetentionPeriod = snapshotRetentionPeriod;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SnapshotCopyConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SnapshotCopyConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SnapshotCopyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SnapshotCopyConfigurationProperty {
            private final java.lang.String destinationRegion;
            private final java.lang.String destinationKmsKeyId;
            private final java.lang.Number snapshotRetentionPeriod;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationRegion = software.amazon.jsii.Kernel.get(this, "destinationRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.destinationKmsKeyId = software.amazon.jsii.Kernel.get(this, "destinationKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.snapshotRetentionPeriod = software.amazon.jsii.Kernel.get(this, "snapshotRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationRegion = java.util.Objects.requireNonNull(builder.destinationRegion, "destinationRegion is required");
                this.destinationKmsKeyId = builder.destinationKmsKeyId;
                this.snapshotRetentionPeriod = builder.snapshotRetentionPeriod;
            }

            @Override
            public final java.lang.String getDestinationRegion() {
                return this.destinationRegion;
            }

            @Override
            public final java.lang.String getDestinationKmsKeyId() {
                return this.destinationKmsKeyId;
            }

            @Override
            public final java.lang.Number getSnapshotRetentionPeriod() {
                return this.snapshotRetentionPeriod;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destinationRegion", om.valueToTree(this.getDestinationRegion()));
                if (this.getDestinationKmsKeyId() != null) {
                    data.set("destinationKmsKeyId", om.valueToTree(this.getDestinationKmsKeyId()));
                }
                if (this.getSnapshotRetentionPeriod() != null) {
                    data.set("snapshotRetentionPeriod", om.valueToTree(this.getSnapshotRetentionPeriod()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_redshiftserverless.CfnNamespace.SnapshotCopyConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SnapshotCopyConfigurationProperty.Jsii$Proxy that = (SnapshotCopyConfigurationProperty.Jsii$Proxy) o;

                if (!destinationRegion.equals(that.destinationRegion)) return false;
                if (this.destinationKmsKeyId != null ? !this.destinationKmsKeyId.equals(that.destinationKmsKeyId) : that.destinationKmsKeyId != null) return false;
                return this.snapshotRetentionPeriod != null ? this.snapshotRetentionPeriod.equals(that.snapshotRetentionPeriod) : that.snapshotRetentionPeriod == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destinationRegion.hashCode();
                result = 31 * result + (this.destinationKmsKeyId != null ? this.destinationKmsKeyId.hashCode() : 0);
                result = 31 * result + (this.snapshotRetentionPeriod != null ? this.snapshotRetentionPeriod.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.redshiftserverless.CfnNamespace}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.redshiftserverless.CfnNamespace> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.redshiftserverless.CfnNamespaceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.redshiftserverless.CfnNamespaceProps.Builder();
        }

        /**
         * The name of the namespace.
         * <p>
         * Must be between 3-64 alphanumeric characters in lowercase, and it cannot be a reserved word. A list of reserved words can be found in <a href="https://docs.aws.amazon.com//redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-namespacename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-namespacename</a>
         * @param namespaceName The name of the namespace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespaceName(final java.lang.String namespaceName) {
            this.props.namespaceName(namespaceName);
            return this;
        }

        /**
         * The ID of the AWS Key Management Service (KMS) key used to encrypt and store the namespace's admin credentials secret.
         * <p>
         * You can only use this parameter if <code>ManageAdminPassword</code> is <code>true</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-adminpasswordsecretkmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-adminpasswordsecretkmskeyid</a>
         * @param adminPasswordSecretKmsKeyId The ID of the AWS Key Management Service (KMS) key used to encrypt and store the namespace's admin credentials secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adminPasswordSecretKmsKeyId(final java.lang.String adminPasswordSecretKmsKeyId) {
            this.props.adminPasswordSecretKmsKeyId(adminPasswordSecretKmsKeyId);
            return this;
        }

        /**
         * The username of the administrator for the primary database created in the namespace.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-adminusername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-adminusername</a>
         * @param adminUsername The username of the administrator for the primary database created in the namespace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adminUsername(final java.lang.String adminUsername) {
            this.props.adminUsername(adminUsername);
            return this;
        }

        /**
         * The password of the administrator for the primary database created in the namespace.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-adminuserpassword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-adminuserpassword</a>
         * @param adminUserPassword The password of the administrator for the primary database created in the namespace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adminUserPassword(final java.lang.String adminUserPassword) {
            this.props.adminUserPassword(adminUserPassword);
            return this;
        }

        /**
         * The name of the primary database created in the namespace.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-dbname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-dbname</a>
         * @param dbName The name of the primary database created in the namespace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbName(final java.lang.String dbName) {
            this.props.dbName(dbName);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-defaultiamrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-defaultiamrolearn</a>
         * @param defaultIamRoleArn The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultIamRoleArn(final java.lang.String defaultIamRoleArn) {
            this.props.defaultIamRoleArn(defaultIamRoleArn);
            return this;
        }

        /**
         * The name of the snapshot to be created before the namespace is deleted.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-finalsnapshotname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-finalsnapshotname</a>
         * @param finalSnapshotName The name of the snapshot to be created before the namespace is deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder finalSnapshotName(final java.lang.String finalSnapshotName) {
            this.props.finalSnapshotName(finalSnapshotName);
            return this;
        }

        /**
         * How long to retain the final snapshot.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-finalsnapshotretentionperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-finalsnapshotretentionperiod</a>
         * @param finalSnapshotRetentionPeriod How long to retain the final snapshot. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder finalSnapshotRetentionPeriod(final java.lang.Number finalSnapshotRetentionPeriod) {
            this.props.finalSnapshotRetentionPeriod(finalSnapshotRetentionPeriod);
            return this;
        }

        /**
         * A list of IAM roles to associate with the namespace.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-iamroles">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-iamroles</a>
         * @param iamRoles A list of IAM roles to associate with the namespace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamRoles(final java.util.List<java.lang.String> iamRoles) {
            this.props.iamRoles(iamRoles);
            return this;
        }

        /**
         * The ID of the AWS Key Management Service key used to encrypt your data.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-kmskeyid</a>
         * @param kmsKeyId The ID of the AWS Key Management Service key used to encrypt your data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(final java.lang.String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        /**
         * The types of logs the namespace can export.
         * <p>
         * Available export types are <code>userlog</code> , <code>connectionlog</code> , and <code>useractivitylog</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-logexports">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-logexports</a>
         * @param logExports The types of logs the namespace can export. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logExports(final java.util.List<java.lang.String> logExports) {
            this.props.logExports(logExports);
            return this;
        }

        /**
         * If true, Amazon Redshift uses AWS Secrets Manager to manage the namespace's admin credentials.
         * <p>
         * You can't use <code>AdminUserPassword</code> if <code>ManageAdminPassword</code> is true. If <code>ManageAdminPassword</code> is <code>false</code> or not set, Amazon Redshift uses <code>AdminUserPassword</code> for the admin user account's password.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-manageadminpassword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-manageadminpassword</a>
         * @param manageAdminPassword If true, Amazon Redshift uses AWS Secrets Manager to manage the namespace's admin credentials. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder manageAdminPassword(final java.lang.Boolean manageAdminPassword) {
            this.props.manageAdminPassword(manageAdminPassword);
            return this;
        }
        /**
         * If true, Amazon Redshift uses AWS Secrets Manager to manage the namespace's admin credentials.
         * <p>
         * You can't use <code>AdminUserPassword</code> if <code>ManageAdminPassword</code> is true. If <code>ManageAdminPassword</code> is <code>false</code> or not set, Amazon Redshift uses <code>AdminUserPassword</code> for the admin user account's password.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-manageadminpassword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-manageadminpassword</a>
         * @param manageAdminPassword If true, Amazon Redshift uses AWS Secrets Manager to manage the namespace's admin credentials. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder manageAdminPassword(final software.amazon.awscdk.IResolvable manageAdminPassword) {
            this.props.manageAdminPassword(manageAdminPassword);
            return this;
        }

        /**
         * The resource policy that will be attached to the namespace.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-namespaceresourcepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-namespaceresourcepolicy</a>
         * @param namespaceResourcePolicy The resource policy that will be attached to the namespace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespaceResourcePolicy(final java.lang.Object namespaceResourcePolicy) {
            this.props.namespaceResourcePolicy(namespaceResourcePolicy);
            return this;
        }

        /**
         * The ARN for the Redshift application that integrates with IAM Identity Center.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-redshiftidcapplicationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-redshiftidcapplicationarn</a>
         * @param redshiftIdcApplicationArn The ARN for the Redshift application that integrates with IAM Identity Center. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redshiftIdcApplicationArn(final java.lang.String redshiftIdcApplicationArn) {
            this.props.redshiftIdcApplicationArn(redshiftIdcApplicationArn);
            return this;
        }

        /**
         * The snapshot copy configurations for the namespace.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-snapshotcopyconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-snapshotcopyconfigurations</a>
         * @param snapshotCopyConfigurations The snapshot copy configurations for the namespace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotCopyConfigurations(final software.amazon.awscdk.IResolvable snapshotCopyConfigurations) {
            this.props.snapshotCopyConfigurations(snapshotCopyConfigurations);
            return this;
        }
        /**
         * The snapshot copy configurations for the namespace.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-snapshotcopyconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-snapshotcopyconfigurations</a>
         * @param snapshotCopyConfigurations The snapshot copy configurations for the namespace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotCopyConfigurations(final java.util.List<? extends java.lang.Object> snapshotCopyConfigurations) {
            this.props.snapshotCopyConfigurations(snapshotCopyConfigurations);
            return this;
        }

        /**
         * The map of the key-value pairs used to tag the namespace.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-namespace.html#cfn-redshiftserverless-namespace-tags</a>
         * @param tags The map of the key-value pairs used to tag the namespace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.redshiftserverless.CfnNamespace}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.redshiftserverless.CfnNamespace build() {
            return new software.amazon.awscdk.services.redshiftserverless.CfnNamespace(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
