package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a <code>CfnFeatureGroup</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * Object offlineStoreConfig;
 * Object onlineStoreConfig;
 * CfnFeatureGroupProps cfnFeatureGroupProps = CfnFeatureGroupProps.builder()
 *         .eventTimeFeatureName("eventTimeFeatureName")
 *         .featureDefinitions(List.of(FeatureDefinitionProperty.builder()
 *                 .featureName("featureName")
 *                 .featureType("featureType")
 *                 .build()))
 *         .featureGroupName("featureGroupName")
 *         .recordIdentifierFeatureName("recordIdentifierFeatureName")
 *         // the properties below are optional
 *         .description("description")
 *         .offlineStoreConfig(offlineStoreConfig)
 *         .onlineStoreConfig(onlineStoreConfig)
 *         .roleArn("roleArn")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .throughputConfig(ThroughputConfigProperty.builder()
 *                 .throughputMode("throughputMode")
 *                 // the properties below are optional
 *                 .provisionedReadCapacityUnits(123)
 *                 .provisionedWriteCapacityUnits(123)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:15.652Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnFeatureGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnFeatureGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFeatureGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the feature that stores the <code>EventTime</code> of a Record in a <code>FeatureGroup</code> .
     * <p>
     * A <code>EventTime</code> is point in time when a new event occurs that corresponds to the creation or update of a <code>Record</code> in <code>FeatureGroup</code> . All <code>Records</code> in the <code>FeatureGroup</code> must have a corresponding <code>EventTime</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-eventtimefeaturename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-eventtimefeaturename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEventTimeFeatureName();

    /**
     * A list of <code>Feature</code> s. Each <code>Feature</code> must include a <code>FeatureName</code> and a <code>FeatureType</code> .
     * <p>
     * Valid <code>FeatureType</code> s are <code>Integral</code> , <code>Fractional</code> and <code>String</code> .
     * <p>
     * <code>FeatureName</code> s cannot be any of the following: <code>is_deleted</code> , <code>write_time</code> , <code>api_invocation_time</code> .
     * <p>
     * You can create up to 2,500 <code>FeatureDefinition</code> s per <code>FeatureGroup</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-featuredefinitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-featuredefinitions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getFeatureDefinitions();

    /**
     * The name of the <code>FeatureGroup</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-featuregroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-featuregroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFeatureGroupName();

    /**
     * The name of the <code>Feature</code> whose value uniquely identifies a <code>Record</code> defined in the <code>FeatureGroup</code> <code>FeatureDefinitions</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-recordidentifierfeaturename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-recordidentifierfeaturename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRecordIdentifierFeatureName();

    /**
     * A free form description of a <code>FeatureGroup</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The configuration of an <code>OfflineStore</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-offlinestoreconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-offlinestoreconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOfflineStoreConfig() {
        return null;
    }

    /**
     * The configuration of an <code>OnlineStore</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-onlinestoreconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-onlinestoreconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOnlineStoreConfig() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM execution role used to create the feature group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
        return null;
    }

    /**
     * Tags used to define a <code>FeatureGroup</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * Used to set feature group throughput configuration.
     * <p>
     * There are two modes: <code>ON_DEMAND</code> and <code>PROVISIONED</code> . With on-demand mode, you are charged for data reads and writes that your application performs on your feature group. You do not need to specify read and write throughput because Feature Store accommodates your workloads as they ramp up and down. You can switch a feature group to on-demand only once in a 24 hour period. With provisioned throughput mode, you specify the read and write capacity per second that you expect your application to require, and you are billed based on those limits. Exceeding provisioned throughput will result in your requests being throttled.
     * <p>
     * Note: <code>PROVISIONED</code> throughput mode is supported only for feature groups that are offline-only, or use the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OnlineStoreConfig.html#sagemaker-Type-OnlineStoreConfig-StorageType"><code>Standard</code></a> tier online store.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-throughputconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-throughputconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getThroughputConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFeatureGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFeatureGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFeatureGroupProps> {
        java.lang.String eventTimeFeatureName;
        java.lang.Object featureDefinitions;
        java.lang.String featureGroupName;
        java.lang.String recordIdentifierFeatureName;
        java.lang.String description;
        java.lang.Object offlineStoreConfig;
        java.lang.Object onlineStoreConfig;
        java.lang.String roleArn;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object throughputConfig;

        /**
         * Sets the value of {@link CfnFeatureGroupProps#getEventTimeFeatureName}
         * @param eventTimeFeatureName The name of the feature that stores the <code>EventTime</code> of a Record in a <code>FeatureGroup</code> . This parameter is required.
         *                             A <code>EventTime</code> is point in time when a new event occurs that corresponds to the creation or update of a <code>Record</code> in <code>FeatureGroup</code> . All <code>Records</code> in the <code>FeatureGroup</code> must have a corresponding <code>EventTime</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventTimeFeatureName(java.lang.String eventTimeFeatureName) {
            this.eventTimeFeatureName = eventTimeFeatureName;
            return this;
        }

        /**
         * Sets the value of {@link CfnFeatureGroupProps#getFeatureDefinitions}
         * @param featureDefinitions A list of <code>Feature</code> s. Each <code>Feature</code> must include a <code>FeatureName</code> and a <code>FeatureType</code> . This parameter is required.
         *                           Valid <code>FeatureType</code> s are <code>Integral</code> , <code>Fractional</code> and <code>String</code> .
         *                           <p>
         *                           <code>FeatureName</code> s cannot be any of the following: <code>is_deleted</code> , <code>write_time</code> , <code>api_invocation_time</code> .
         *                           <p>
         *                           You can create up to 2,500 <code>FeatureDefinition</code> s per <code>FeatureGroup</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder featureDefinitions(software.amazon.awscdk.IResolvable featureDefinitions) {
            this.featureDefinitions = featureDefinitions;
            return this;
        }

        /**
         * Sets the value of {@link CfnFeatureGroupProps#getFeatureDefinitions}
         * @param featureDefinitions A list of <code>Feature</code> s. Each <code>Feature</code> must include a <code>FeatureName</code> and a <code>FeatureType</code> . This parameter is required.
         *                           Valid <code>FeatureType</code> s are <code>Integral</code> , <code>Fractional</code> and <code>String</code> .
         *                           <p>
         *                           <code>FeatureName</code> s cannot be any of the following: <code>is_deleted</code> , <code>write_time</code> , <code>api_invocation_time</code> .
         *                           <p>
         *                           You can create up to 2,500 <code>FeatureDefinition</code> s per <code>FeatureGroup</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder featureDefinitions(java.util.List<? extends java.lang.Object> featureDefinitions) {
            this.featureDefinitions = featureDefinitions;
            return this;
        }

        /**
         * Sets the value of {@link CfnFeatureGroupProps#getFeatureGroupName}
         * @param featureGroupName The name of the <code>FeatureGroup</code> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder featureGroupName(java.lang.String featureGroupName) {
            this.featureGroupName = featureGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnFeatureGroupProps#getRecordIdentifierFeatureName}
         * @param recordIdentifierFeatureName The name of the <code>Feature</code> whose value uniquely identifies a <code>Record</code> defined in the <code>FeatureGroup</code> <code>FeatureDefinitions</code> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordIdentifierFeatureName(java.lang.String recordIdentifierFeatureName) {
            this.recordIdentifierFeatureName = recordIdentifierFeatureName;
            return this;
        }

        /**
         * Sets the value of {@link CfnFeatureGroupProps#getDescription}
         * @param description A free form description of a <code>FeatureGroup</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnFeatureGroupProps#getOfflineStoreConfig}
         * @param offlineStoreConfig The configuration of an <code>OfflineStore</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder offlineStoreConfig(java.lang.Object offlineStoreConfig) {
            this.offlineStoreConfig = offlineStoreConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFeatureGroupProps#getOnlineStoreConfig}
         * @param onlineStoreConfig The configuration of an <code>OnlineStore</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onlineStoreConfig(java.lang.Object onlineStoreConfig) {
            this.onlineStoreConfig = onlineStoreConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFeatureGroupProps#getRoleArn}
         * @param roleArn The Amazon Resource Name (ARN) of the IAM execution role used to create the feature group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnFeatureGroupProps#getTags}
         * @param tags Tags used to define a <code>FeatureGroup</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnFeatureGroupProps#getThroughputConfig}
         * @param throughputConfig Used to set feature group throughput configuration.
         *                         There are two modes: <code>ON_DEMAND</code> and <code>PROVISIONED</code> . With on-demand mode, you are charged for data reads and writes that your application performs on your feature group. You do not need to specify read and write throughput because Feature Store accommodates your workloads as they ramp up and down. You can switch a feature group to on-demand only once in a 24 hour period. With provisioned throughput mode, you specify the read and write capacity per second that you expect your application to require, and you are billed based on those limits. Exceeding provisioned throughput will result in your requests being throttled.
         *                         <p>
         *                         Note: <code>PROVISIONED</code> throughput mode is supported only for feature groups that are offline-only, or use the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OnlineStoreConfig.html#sagemaker-Type-OnlineStoreConfig-StorageType"><code>Standard</code></a> tier online store.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throughputConfig(software.amazon.awscdk.IResolvable throughputConfig) {
            this.throughputConfig = throughputConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFeatureGroupProps#getThroughputConfig}
         * @param throughputConfig Used to set feature group throughput configuration.
         *                         There are two modes: <code>ON_DEMAND</code> and <code>PROVISIONED</code> . With on-demand mode, you are charged for data reads and writes that your application performs on your feature group. You do not need to specify read and write throughput because Feature Store accommodates your workloads as they ramp up and down. You can switch a feature group to on-demand only once in a 24 hour period. With provisioned throughput mode, you specify the read and write capacity per second that you expect your application to require, and you are billed based on those limits. Exceeding provisioned throughput will result in your requests being throttled.
         *                         <p>
         *                         Note: <code>PROVISIONED</code> throughput mode is supported only for feature groups that are offline-only, or use the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OnlineStoreConfig.html#sagemaker-Type-OnlineStoreConfig-StorageType"><code>Standard</code></a> tier online store.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throughputConfig(software.amazon.awscdk.services.sagemaker.CfnFeatureGroup.ThroughputConfigProperty throughputConfig) {
            this.throughputConfig = throughputConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFeatureGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFeatureGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnFeatureGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFeatureGroupProps {
        private final java.lang.String eventTimeFeatureName;
        private final java.lang.Object featureDefinitions;
        private final java.lang.String featureGroupName;
        private final java.lang.String recordIdentifierFeatureName;
        private final java.lang.String description;
        private final java.lang.Object offlineStoreConfig;
        private final java.lang.Object onlineStoreConfig;
        private final java.lang.String roleArn;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object throughputConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.eventTimeFeatureName = software.amazon.jsii.Kernel.get(this, "eventTimeFeatureName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.featureDefinitions = software.amazon.jsii.Kernel.get(this, "featureDefinitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.featureGroupName = software.amazon.jsii.Kernel.get(this, "featureGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.recordIdentifierFeatureName = software.amazon.jsii.Kernel.get(this, "recordIdentifierFeatureName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.offlineStoreConfig = software.amazon.jsii.Kernel.get(this, "offlineStoreConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.onlineStoreConfig = software.amazon.jsii.Kernel.get(this, "onlineStoreConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.throughputConfig = software.amazon.jsii.Kernel.get(this, "throughputConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.eventTimeFeatureName = java.util.Objects.requireNonNull(builder.eventTimeFeatureName, "eventTimeFeatureName is required");
            this.featureDefinitions = java.util.Objects.requireNonNull(builder.featureDefinitions, "featureDefinitions is required");
            this.featureGroupName = java.util.Objects.requireNonNull(builder.featureGroupName, "featureGroupName is required");
            this.recordIdentifierFeatureName = java.util.Objects.requireNonNull(builder.recordIdentifierFeatureName, "recordIdentifierFeatureName is required");
            this.description = builder.description;
            this.offlineStoreConfig = builder.offlineStoreConfig;
            this.onlineStoreConfig = builder.onlineStoreConfig;
            this.roleArn = builder.roleArn;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.throughputConfig = builder.throughputConfig;
        }

        @Override
        public final java.lang.String getEventTimeFeatureName() {
            return this.eventTimeFeatureName;
        }

        @Override
        public final java.lang.Object getFeatureDefinitions() {
            return this.featureDefinitions;
        }

        @Override
        public final java.lang.String getFeatureGroupName() {
            return this.featureGroupName;
        }

        @Override
        public final java.lang.String getRecordIdentifierFeatureName() {
            return this.recordIdentifierFeatureName;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getOfflineStoreConfig() {
            return this.offlineStoreConfig;
        }

        @Override
        public final java.lang.Object getOnlineStoreConfig() {
            return this.onlineStoreConfig;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getThroughputConfig() {
            return this.throughputConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("eventTimeFeatureName", om.valueToTree(this.getEventTimeFeatureName()));
            data.set("featureDefinitions", om.valueToTree(this.getFeatureDefinitions()));
            data.set("featureGroupName", om.valueToTree(this.getFeatureGroupName()));
            data.set("recordIdentifierFeatureName", om.valueToTree(this.getRecordIdentifierFeatureName()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getOfflineStoreConfig() != null) {
                data.set("offlineStoreConfig", om.valueToTree(this.getOfflineStoreConfig()));
            }
            if (this.getOnlineStoreConfig() != null) {
                data.set("onlineStoreConfig", om.valueToTree(this.getOnlineStoreConfig()));
            }
            if (this.getRoleArn() != null) {
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getThroughputConfig() != null) {
                data.set("throughputConfig", om.valueToTree(this.getThroughputConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnFeatureGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFeatureGroupProps.Jsii$Proxy that = (CfnFeatureGroupProps.Jsii$Proxy) o;

            if (!eventTimeFeatureName.equals(that.eventTimeFeatureName)) return false;
            if (!featureDefinitions.equals(that.featureDefinitions)) return false;
            if (!featureGroupName.equals(that.featureGroupName)) return false;
            if (!recordIdentifierFeatureName.equals(that.recordIdentifierFeatureName)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.offlineStoreConfig != null ? !this.offlineStoreConfig.equals(that.offlineStoreConfig) : that.offlineStoreConfig != null) return false;
            if (this.onlineStoreConfig != null ? !this.onlineStoreConfig.equals(that.onlineStoreConfig) : that.onlineStoreConfig != null) return false;
            if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.throughputConfig != null ? this.throughputConfig.equals(that.throughputConfig) : that.throughputConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.eventTimeFeatureName.hashCode();
            result = 31 * result + (this.featureDefinitions.hashCode());
            result = 31 * result + (this.featureGroupName.hashCode());
            result = 31 * result + (this.recordIdentifierFeatureName.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.offlineStoreConfig != null ? this.offlineStoreConfig.hashCode() : 0);
            result = 31 * result + (this.onlineStoreConfig != null ? this.onlineStoreConfig.hashCode() : 0);
            result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.throughputConfig != null ? this.throughputConfig.hashCode() : 0);
            return result;
        }
    }
}
