package software.amazon.awscdk.services.sns;

/**
 * Properties for defining a <code>CfnSubscription</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sns.*;
 * Object deliveryPolicy;
 * Object filterPolicy;
 * Object redrivePolicy;
 * Object replayPolicy;
 * CfnSubscriptionProps cfnSubscriptionProps = CfnSubscriptionProps.builder()
 *         .protocol("protocol")
 *         .topicArn("topicArn")
 *         // the properties below are optional
 *         .deliveryPolicy(deliveryPolicy)
 *         .endpoint("endpoint")
 *         .filterPolicy(filterPolicy)
 *         .filterPolicyScope("filterPolicyScope")
 *         .rawMessageDelivery(false)
 *         .redrivePolicy(redrivePolicy)
 *         .region("region")
 *         .replayPolicy(replayPolicy)
 *         .subscriptionRoleArn("subscriptionRoleArn")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:16.431Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sns.CfnSubscriptionProps")
@software.amazon.jsii.Jsii.Proxy(CfnSubscriptionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSubscriptionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The subscription's protocol.
     * <p>
     * For more information, see the <code>Protocol</code> parameter of the <code>[Subscribe](https://docs.aws.amazon.com/sns/latest/api/API_Subscribe.html)</code> action in the <em>Amazon SNS API Reference</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html#cfn-sns-subscription-protocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html#cfn-sns-subscription-protocol</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProtocol();

    /**
     * The ARN of the topic to subscribe to.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html#cfn-sns-subscription-topicarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html#cfn-sns-subscription-topicarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTopicArn();

    /**
     * The delivery policy JSON assigned to the subscription.
     * <p>
     * Enables the subscriber to define the message delivery retry strategy in the case of an HTTP/S endpoint subscribed to the topic. For more information, see <code>[GetSubscriptionAttributes](https://docs.aws.amazon.com/sns/latest/api/API_GetSubscriptionAttributes.html)</code> in the <em>Amazon SNS API Reference</em> and <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-message-delivery-retries.html">Message delivery retries</a> in the <em>Amazon SNS Developer Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html#cfn-sns-subscription-deliverypolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html#cfn-sns-subscription-deliverypolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeliveryPolicy() {
        return null;
    }

    /**
     * The subscription's endpoint.
     * <p>
     * The endpoint value depends on the protocol that you specify. For more information, see the <code>Endpoint</code> parameter of the <code>[Subscribe](https://docs.aws.amazon.com/sns/latest/api/API_Subscribe.html)</code> action in the <em>Amazon SNS API Reference</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html#cfn-sns-subscription-endpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html#cfn-sns-subscription-endpoint</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEndpoint() {
        return null;
    }

    /**
     * The filter policy JSON assigned to the subscription.
     * <p>
     * Enables the subscriber to filter out unwanted messages. For more information, see <code>[GetSubscriptionAttributes](https://docs.aws.amazon.com/sns/latest/api/API_GetSubscriptionAttributes.html)</code> in the <em>Amazon SNS API Reference</em> and <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-message-filtering.html">Message filtering</a> in the <em>Amazon SNS Developer Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html#cfn-sns-subscription-filterpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html#cfn-sns-subscription-filterpolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFilterPolicy() {
        return null;
    }

    /**
     * This attribute lets you choose the filtering scope by using one of the following string value types:.
     * <p>
     * <ul>
     * <li><code>MessageAttributes</code> (default) - The filter is applied on the message attributes.</li>
     * <li><code>MessageBody</code> - The filter is applied on the message body.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html#cfn-sns-subscription-filterpolicyscope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html#cfn-sns-subscription-filterpolicyscope</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFilterPolicyScope() {
        return null;
    }

    /**
     * When set to <code>true</code> , enables raw message delivery.
     * <p>
     * Raw messages don't contain any JSON formatting and can be sent to Amazon SQS and HTTP/S endpoints. For more information, see <code>[GetSubscriptionAttributes](https://docs.aws.amazon.com/sns/latest/api/API_GetSubscriptionAttributes.html)</code> in the <em>Amazon SNS API Reference</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html#cfn-sns-subscription-rawmessagedelivery">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html#cfn-sns-subscription-rawmessagedelivery</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRawMessageDelivery() {
        return null;
    }

    /**
     * When specified, sends undeliverable messages to the specified Amazon SQS dead-letter queue.
     * <p>
     * Messages that can't be delivered due to client errors (for example, when the subscribed endpoint is unreachable) or server errors (for example, when the service that powers the subscribed endpoint becomes unavailable) are held in the dead-letter queue for further analysis or reprocessing.
     * <p>
     * For more information about the redrive policy and dead-letter queues, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html">Amazon SQS dead-letter queues</a> in the <em>Amazon SQS Developer Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html#cfn-sns-subscription-redrivepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html#cfn-sns-subscription-redrivepolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRedrivePolicy() {
        return null;
    }

    /**
     * For cross-region subscriptions, the region in which the topic resides.
     * <p>
     * If no region is specified, AWS CloudFormation uses the region of the caller as the default.
     * <p>
     * If you perform an update operation that only updates the <code>Region</code> property of a <code>AWS::SNS::Subscription</code> resource, that operation will fail unless you are either:
     * <p>
     * <ul>
     * <li>Updating the <code>Region</code> from <code>NULL</code> to the caller region.</li>
     * <li>Updating the <code>Region</code> from the caller region to <code>NULL</code> .</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html#cfn-sns-subscription-region">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html#cfn-sns-subscription-region</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return null;
    }

    /**
     * Specifies whether Amazon SNS resends the notification to the subscription when a message's attribute changes.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html#cfn-sns-subscription-replaypolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html#cfn-sns-subscription-replaypolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getReplayPolicy() {
        return null;
    }

    /**
     * This property applies only to Amazon Data Firehose delivery stream subscriptions.
     * <p>
     * Specify the ARN of the IAM role that has the following:
     * <p>
     * <ul>
     * <li>Permission to write to the Amazon Data Firehose delivery stream</li>
     * <li>Amazon SNS listed as a trusted entity</li>
     * </ul>
     * <p>
     * Specifying a valid ARN for this attribute is required for Firehose delivery stream subscriptions. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html">Fanout to Amazon Data Firehose delivery streams</a> in the <em>Amazon SNS Developer Guide.</em>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html#cfn-sns-subscription-subscriptionrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html#cfn-sns-subscription-subscriptionrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubscriptionRoleArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSubscriptionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSubscriptionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSubscriptionProps> {
        java.lang.String protocol;
        java.lang.String topicArn;
        java.lang.Object deliveryPolicy;
        java.lang.String endpoint;
        java.lang.Object filterPolicy;
        java.lang.String filterPolicyScope;
        java.lang.Object rawMessageDelivery;
        java.lang.Object redrivePolicy;
        java.lang.String region;
        java.lang.Object replayPolicy;
        java.lang.String subscriptionRoleArn;

        /**
         * Sets the value of {@link CfnSubscriptionProps#getProtocol}
         * @param protocol The subscription's protocol. This parameter is required.
         *                 For more information, see the <code>Protocol</code> parameter of the <code>[Subscribe](https://docs.aws.amazon.com/sns/latest/api/API_Subscribe.html)</code> action in the <em>Amazon SNS API Reference</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(java.lang.String protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionProps#getTopicArn}
         * @param topicArn The ARN of the topic to subscribe to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topicArn(java.lang.String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionProps#getDeliveryPolicy}
         * @param deliveryPolicy The delivery policy JSON assigned to the subscription.
         *                       Enables the subscriber to define the message delivery retry strategy in the case of an HTTP/S endpoint subscribed to the topic. For more information, see <code>[GetSubscriptionAttributes](https://docs.aws.amazon.com/sns/latest/api/API_GetSubscriptionAttributes.html)</code> in the <em>Amazon SNS API Reference</em> and <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-message-delivery-retries.html">Message delivery retries</a> in the <em>Amazon SNS Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryPolicy(java.lang.Object deliveryPolicy) {
            this.deliveryPolicy = deliveryPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionProps#getEndpoint}
         * @param endpoint The subscription's endpoint.
         *                 The endpoint value depends on the protocol that you specify. For more information, see the <code>Endpoint</code> parameter of the <code>[Subscribe](https://docs.aws.amazon.com/sns/latest/api/API_Subscribe.html)</code> action in the <em>Amazon SNS API Reference</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpoint(java.lang.String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionProps#getFilterPolicy}
         * @param filterPolicy The filter policy JSON assigned to the subscription.
         *                     Enables the subscriber to filter out unwanted messages. For more information, see <code>[GetSubscriptionAttributes](https://docs.aws.amazon.com/sns/latest/api/API_GetSubscriptionAttributes.html)</code> in the <em>Amazon SNS API Reference</em> and <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-message-filtering.html">Message filtering</a> in the <em>Amazon SNS Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterPolicy(java.lang.Object filterPolicy) {
            this.filterPolicy = filterPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionProps#getFilterPolicyScope}
         * @param filterPolicyScope This attribute lets you choose the filtering scope by using one of the following string value types:.
         *                          <ul>
         *                          <li><code>MessageAttributes</code> (default) - The filter is applied on the message attributes.</li>
         *                          <li><code>MessageBody</code> - The filter is applied on the message body.</li>
         *                          </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterPolicyScope(java.lang.String filterPolicyScope) {
            this.filterPolicyScope = filterPolicyScope;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionProps#getRawMessageDelivery}
         * @param rawMessageDelivery When set to <code>true</code> , enables raw message delivery.
         *                           Raw messages don't contain any JSON formatting and can be sent to Amazon SQS and HTTP/S endpoints. For more information, see <code>[GetSubscriptionAttributes](https://docs.aws.amazon.com/sns/latest/api/API_GetSubscriptionAttributes.html)</code> in the <em>Amazon SNS API Reference</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rawMessageDelivery(java.lang.Boolean rawMessageDelivery) {
            this.rawMessageDelivery = rawMessageDelivery;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionProps#getRawMessageDelivery}
         * @param rawMessageDelivery When set to <code>true</code> , enables raw message delivery.
         *                           Raw messages don't contain any JSON formatting and can be sent to Amazon SQS and HTTP/S endpoints. For more information, see <code>[GetSubscriptionAttributes](https://docs.aws.amazon.com/sns/latest/api/API_GetSubscriptionAttributes.html)</code> in the <em>Amazon SNS API Reference</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rawMessageDelivery(software.amazon.awscdk.IResolvable rawMessageDelivery) {
            this.rawMessageDelivery = rawMessageDelivery;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionProps#getRedrivePolicy}
         * @param redrivePolicy When specified, sends undeliverable messages to the specified Amazon SQS dead-letter queue.
         *                      Messages that can't be delivered due to client errors (for example, when the subscribed endpoint is unreachable) or server errors (for example, when the service that powers the subscribed endpoint becomes unavailable) are held in the dead-letter queue for further analysis or reprocessing.
         *                      <p>
         *                      For more information about the redrive policy and dead-letter queues, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html">Amazon SQS dead-letter queues</a> in the <em>Amazon SQS Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redrivePolicy(java.lang.Object redrivePolicy) {
            this.redrivePolicy = redrivePolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionProps#getRegion}
         * @param region For cross-region subscriptions, the region in which the topic resides.
         *               If no region is specified, AWS CloudFormation uses the region of the caller as the default.
         *               <p>
         *               If you perform an update operation that only updates the <code>Region</code> property of a <code>AWS::SNS::Subscription</code> resource, that operation will fail unless you are either:
         *               <p>
         *               <ul>
         *               <li>Updating the <code>Region</code> from <code>NULL</code> to the caller region.</li>
         *               <li>Updating the <code>Region</code> from the caller region to <code>NULL</code> .</li>
         *               </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionProps#getReplayPolicy}
         * @param replayPolicy Specifies whether Amazon SNS resends the notification to the subscription when a message's attribute changes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replayPolicy(java.lang.Object replayPolicy) {
            this.replayPolicy = replayPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionProps#getSubscriptionRoleArn}
         * @param subscriptionRoleArn This property applies only to Amazon Data Firehose delivery stream subscriptions.
         *                            Specify the ARN of the IAM role that has the following:
         *                            <p>
         *                            <ul>
         *                            <li>Permission to write to the Amazon Data Firehose delivery stream</li>
         *                            <li>Amazon SNS listed as a trusted entity</li>
         *                            </ul>
         *                            <p>
         *                            Specifying a valid ARN for this attribute is required for Firehose delivery stream subscriptions. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html">Fanout to Amazon Data Firehose delivery streams</a> in the <em>Amazon SNS Developer Guide.</em>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscriptionRoleArn(java.lang.String subscriptionRoleArn) {
            this.subscriptionRoleArn = subscriptionRoleArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSubscriptionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSubscriptionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSubscriptionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSubscriptionProps {
        private final java.lang.String protocol;
        private final java.lang.String topicArn;
        private final java.lang.Object deliveryPolicy;
        private final java.lang.String endpoint;
        private final java.lang.Object filterPolicy;
        private final java.lang.String filterPolicyScope;
        private final java.lang.Object rawMessageDelivery;
        private final java.lang.Object redrivePolicy;
        private final java.lang.String region;
        private final java.lang.Object replayPolicy;
        private final java.lang.String subscriptionRoleArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.topicArn = software.amazon.jsii.Kernel.get(this, "topicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deliveryPolicy = software.amazon.jsii.Kernel.get(this, "deliveryPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.endpoint = software.amazon.jsii.Kernel.get(this, "endpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.filterPolicy = software.amazon.jsii.Kernel.get(this, "filterPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.filterPolicyScope = software.amazon.jsii.Kernel.get(this, "filterPolicyScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.rawMessageDelivery = software.amazon.jsii.Kernel.get(this, "rawMessageDelivery", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.redrivePolicy = software.amazon.jsii.Kernel.get(this, "redrivePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.replayPolicy = software.amazon.jsii.Kernel.get(this, "replayPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.subscriptionRoleArn = software.amazon.jsii.Kernel.get(this, "subscriptionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.protocol = java.util.Objects.requireNonNull(builder.protocol, "protocol is required");
            this.topicArn = java.util.Objects.requireNonNull(builder.topicArn, "topicArn is required");
            this.deliveryPolicy = builder.deliveryPolicy;
            this.endpoint = builder.endpoint;
            this.filterPolicy = builder.filterPolicy;
            this.filterPolicyScope = builder.filterPolicyScope;
            this.rawMessageDelivery = builder.rawMessageDelivery;
            this.redrivePolicy = builder.redrivePolicy;
            this.region = builder.region;
            this.replayPolicy = builder.replayPolicy;
            this.subscriptionRoleArn = builder.subscriptionRoleArn;
        }

        @Override
        public final java.lang.String getProtocol() {
            return this.protocol;
        }

        @Override
        public final java.lang.String getTopicArn() {
            return this.topicArn;
        }

        @Override
        public final java.lang.Object getDeliveryPolicy() {
            return this.deliveryPolicy;
        }

        @Override
        public final java.lang.String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final java.lang.Object getFilterPolicy() {
            return this.filterPolicy;
        }

        @Override
        public final java.lang.String getFilterPolicyScope() {
            return this.filterPolicyScope;
        }

        @Override
        public final java.lang.Object getRawMessageDelivery() {
            return this.rawMessageDelivery;
        }

        @Override
        public final java.lang.Object getRedrivePolicy() {
            return this.redrivePolicy;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final java.lang.Object getReplayPolicy() {
            return this.replayPolicy;
        }

        @Override
        public final java.lang.String getSubscriptionRoleArn() {
            return this.subscriptionRoleArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("protocol", om.valueToTree(this.getProtocol()));
            data.set("topicArn", om.valueToTree(this.getTopicArn()));
            if (this.getDeliveryPolicy() != null) {
                data.set("deliveryPolicy", om.valueToTree(this.getDeliveryPolicy()));
            }
            if (this.getEndpoint() != null) {
                data.set("endpoint", om.valueToTree(this.getEndpoint()));
            }
            if (this.getFilterPolicy() != null) {
                data.set("filterPolicy", om.valueToTree(this.getFilterPolicy()));
            }
            if (this.getFilterPolicyScope() != null) {
                data.set("filterPolicyScope", om.valueToTree(this.getFilterPolicyScope()));
            }
            if (this.getRawMessageDelivery() != null) {
                data.set("rawMessageDelivery", om.valueToTree(this.getRawMessageDelivery()));
            }
            if (this.getRedrivePolicy() != null) {
                data.set("redrivePolicy", om.valueToTree(this.getRedrivePolicy()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getReplayPolicy() != null) {
                data.set("replayPolicy", om.valueToTree(this.getReplayPolicy()));
            }
            if (this.getSubscriptionRoleArn() != null) {
                data.set("subscriptionRoleArn", om.valueToTree(this.getSubscriptionRoleArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sns.CfnSubscriptionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSubscriptionProps.Jsii$Proxy that = (CfnSubscriptionProps.Jsii$Proxy) o;

            if (!protocol.equals(that.protocol)) return false;
            if (!topicArn.equals(that.topicArn)) return false;
            if (this.deliveryPolicy != null ? !this.deliveryPolicy.equals(that.deliveryPolicy) : that.deliveryPolicy != null) return false;
            if (this.endpoint != null ? !this.endpoint.equals(that.endpoint) : that.endpoint != null) return false;
            if (this.filterPolicy != null ? !this.filterPolicy.equals(that.filterPolicy) : that.filterPolicy != null) return false;
            if (this.filterPolicyScope != null ? !this.filterPolicyScope.equals(that.filterPolicyScope) : that.filterPolicyScope != null) return false;
            if (this.rawMessageDelivery != null ? !this.rawMessageDelivery.equals(that.rawMessageDelivery) : that.rawMessageDelivery != null) return false;
            if (this.redrivePolicy != null ? !this.redrivePolicy.equals(that.redrivePolicy) : that.redrivePolicy != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (this.replayPolicy != null ? !this.replayPolicy.equals(that.replayPolicy) : that.replayPolicy != null) return false;
            return this.subscriptionRoleArn != null ? this.subscriptionRoleArn.equals(that.subscriptionRoleArn) : that.subscriptionRoleArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.protocol.hashCode();
            result = 31 * result + (this.topicArn.hashCode());
            result = 31 * result + (this.deliveryPolicy != null ? this.deliveryPolicy.hashCode() : 0);
            result = 31 * result + (this.endpoint != null ? this.endpoint.hashCode() : 0);
            result = 31 * result + (this.filterPolicy != null ? this.filterPolicy.hashCode() : 0);
            result = 31 * result + (this.filterPolicyScope != null ? this.filterPolicyScope.hashCode() : 0);
            result = 31 * result + (this.rawMessageDelivery != null ? this.rawMessageDelivery.hashCode() : 0);
            result = 31 * result + (this.redrivePolicy != null ? this.redrivePolicy.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.replayPolicy != null ? this.replayPolicy.hashCode() : 0);
            result = 31 * result + (this.subscriptionRoleArn != null ? this.subscriptionRoleArn.hashCode() : 0);
            return result;
        }
    }
}
