package software.amazon.awscdk.services.stepfunctions;

/**
 * Properties shared by all states.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.*;
 * Object parameters;
 * Object resultSelector;
 * StateProps stateProps = StateProps.builder()
 *         .comment("comment")
 *         .inputPath("inputPath")
 *         .outputPath("outputPath")
 *         .parameters(Map.of(
 *                 "parametersKey", parameters))
 *         .resultPath("resultPath")
 *         .resultSelector(Map.of(
 *                 "resultSelectorKey", resultSelector))
 *         .stateName("stateName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:16.747Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.StateProps")
@software.amazon.jsii.Jsii.Proxy(StateProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StateProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A comment describing this state.
     * <p>
     * Default: No comment
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getComment() {
        return null;
    }

    /**
     * JSONPath expression to select part of the state to be the input to this state.
     * <p>
     * May also be the special value JsonPath.DISCARD, which will cause the effective
     * input to be the empty object {}.
     * <p>
     * Default: $
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInputPath() {
        return null;
    }

    /**
     * JSONPath expression to select part of the state to be the output to this state.
     * <p>
     * May also be the special value JsonPath.DISCARD, which will cause the effective
     * output to be the empty object {}.
     * <p>
     * Default: $
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOutputPath() {
        return null;
    }

    /**
     * Parameters pass a collection of key-value pairs, either static values or JSONPath expressions that select from the input.
     * <p>
     * Default: No parameters
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-parameters">https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-parameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getParameters() {
        return null;
    }

    /**
     * JSONPath expression to indicate where to inject the state's output.
     * <p>
     * May also be the special value JsonPath.DISCARD, which will cause the state's
     * input to become its output.
     * <p>
     * Default: $
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResultPath() {
        return null;
    }

    /**
     * The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.
     * <p>
     * You can use ResultSelector to create a payload with values that are static
     * or selected from the state's raw result.
     * <p>
     * Default: - None
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector">https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getResultSelector() {
        return null;
    }

    /**
     * Optional name for this state.
     * <p>
     * Default: - The construct ID will be used as state name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStateName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StateProps> {
        java.lang.String comment;
        java.lang.String inputPath;
        java.lang.String outputPath;
        java.util.Map<java.lang.String, java.lang.Object> parameters;
        java.lang.String resultPath;
        java.util.Map<java.lang.String, java.lang.Object> resultSelector;
        java.lang.String stateName;

        /**
         * Sets the value of {@link StateProps#getComment}
         * @param comment A comment describing this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link StateProps#getInputPath}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state.
         *                  May also be the special value JsonPath.DISCARD, which will cause the effective
         *                  input to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPath(java.lang.String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        /**
         * Sets the value of {@link StateProps#getOutputPath}
         * @param outputPath JSONPath expression to select part of the state to be the output to this state.
         *                   May also be the special value JsonPath.DISCARD, which will cause the effective
         *                   output to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(java.lang.String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        /**
         * Sets the value of {@link StateProps#getParameters}
         * @param parameters Parameters pass a collection of key-value pairs, either static values or JSONPath expressions that select from the input.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder parameters(java.util.Map<java.lang.String, ? extends java.lang.Object> parameters) {
            this.parameters = (java.util.Map<java.lang.String, java.lang.Object>)parameters;
            return this;
        }

        /**
         * Sets the value of {@link StateProps#getResultPath}
         * @param resultPath JSONPath expression to indicate where to inject the state's output.
         *                   May also be the special value JsonPath.DISCARD, which will cause the state's
         *                   input to become its output.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultPath(java.lang.String resultPath) {
            this.resultPath = resultPath;
            return this;
        }

        /**
         * Sets the value of {@link StateProps#getResultSelector}
         * @param resultSelector The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.
         *                       You can use ResultSelector to create a payload with values that are static
         *                       or selected from the state's raw result.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder resultSelector(java.util.Map<java.lang.String, ? extends java.lang.Object> resultSelector) {
            this.resultSelector = (java.util.Map<java.lang.String, java.lang.Object>)resultSelector;
            return this;
        }

        /**
         * Sets the value of {@link StateProps#getStateName}
         * @param stateName Optional name for this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateName(java.lang.String stateName) {
            this.stateName = stateName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StateProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StateProps {
        private final java.lang.String comment;
        private final java.lang.String inputPath;
        private final java.lang.String outputPath;
        private final java.util.Map<java.lang.String, java.lang.Object> parameters;
        private final java.lang.String resultPath;
        private final java.util.Map<java.lang.String, java.lang.Object> resultSelector;
        private final java.lang.String stateName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.inputPath = software.amazon.jsii.Kernel.get(this, "inputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outputPath = software.amazon.jsii.Kernel.get(this, "outputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.resultPath = software.amazon.jsii.Kernel.get(this, "resultPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resultSelector = software.amazon.jsii.Kernel.get(this, "resultSelector", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.stateName = software.amazon.jsii.Kernel.get(this, "stateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.comment = builder.comment;
            this.inputPath = builder.inputPath;
            this.outputPath = builder.outputPath;
            this.parameters = (java.util.Map<java.lang.String, java.lang.Object>)builder.parameters;
            this.resultPath = builder.resultPath;
            this.resultSelector = (java.util.Map<java.lang.String, java.lang.Object>)builder.resultSelector;
            this.stateName = builder.stateName;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final java.lang.String getInputPath() {
            return this.inputPath;
        }

        @Override
        public final java.lang.String getOutputPath() {
            return this.outputPath;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getParameters() {
            return this.parameters;
        }

        @Override
        public final java.lang.String getResultPath() {
            return this.resultPath;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getResultSelector() {
            return this.resultSelector;
        }

        @Override
        public final java.lang.String getStateName() {
            return this.stateName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getInputPath() != null) {
                data.set("inputPath", om.valueToTree(this.getInputPath()));
            }
            if (this.getOutputPath() != null) {
                data.set("outputPath", om.valueToTree(this.getOutputPath()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getResultPath() != null) {
                data.set("resultPath", om.valueToTree(this.getResultPath()));
            }
            if (this.getResultSelector() != null) {
                data.set("resultSelector", om.valueToTree(this.getResultSelector()));
            }
            if (this.getStateName() != null) {
                data.set("stateName", om.valueToTree(this.getStateName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.StateProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StateProps.Jsii$Proxy that = (StateProps.Jsii$Proxy) o;

            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.inputPath != null ? !this.inputPath.equals(that.inputPath) : that.inputPath != null) return false;
            if (this.outputPath != null ? !this.outputPath.equals(that.outputPath) : that.outputPath != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (this.resultPath != null ? !this.resultPath.equals(that.resultPath) : that.resultPath != null) return false;
            if (this.resultSelector != null ? !this.resultSelector.equals(that.resultSelector) : that.resultSelector != null) return false;
            return this.stateName != null ? this.stateName.equals(that.stateName) : that.stateName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.comment != null ? this.comment.hashCode() : 0;
            result = 31 * result + (this.inputPath != null ? this.inputPath.hashCode() : 0);
            result = 31 * result + (this.outputPath != null ? this.outputPath.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.resultPath != null ? this.resultPath.hashCode() : 0);
            result = 31 * result + (this.resultSelector != null ? this.resultSelector.hashCode() : 0);
            result = 31 * result + (this.stateName != null ? this.stateName.hashCode() : 0);
            return result;
        }
    }
}
