package software.amazon.awscdk.services.stepfunctions;

/**
 * Represents the Wait state which delays a state machine from continuing for a specified time.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EvaluateExpression convertToSeconds = EvaluateExpression.Builder.create(this, "Convert to seconds")
 *         .expression("$.waitMilliseconds / 1000")
 *         .resultPath("$.waitSeconds")
 *         .build();
 * EvaluateExpression createMessage = EvaluateExpression.Builder.create(this, "Create message")
 *         // Note: this is a string inside a string.
 *         .expression("`Now waiting ${$.waitSeconds} seconds...`")
 *         .runtime(Runtime.NODEJS_LATEST)
 *         .resultPath("$.message")
 *         .build();
 * SnsPublish publishMessage = SnsPublish.Builder.create(this, "Publish message")
 *         .topic(new Topic(this, "cool-topic"))
 *         .message(TaskInput.fromJsonPathAt("$.message"))
 *         .resultPath("$.sns")
 *         .build();
 * Wait wait = Wait.Builder.create(this, "Wait")
 *         .time(WaitTime.secondsPath("$.waitSeconds"))
 *         .build();
 * StateMachine.Builder.create(this, "StateMachine")
 *         .definition(convertToSeconds.next(createMessage).next(publishMessage).next(wait))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-wait-state.html">https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-wait-state.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:16.754Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.WaitTime")
public class WaitTime extends software.amazon.jsii.JsiiObject {

    protected WaitTime(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected WaitTime(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Wait a fixed amount of time.
     * <p>
     * @param duration This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.WaitTime duration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration duration) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.WaitTime.class, "duration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.WaitTime.class), new Object[] { java.util.Objects.requireNonNull(duration, "duration is required") });
    }

    /**
     * Wait for a number of seconds stored in the state object.
     * <p>
     * Example value: <code>$.waitSeconds</code>
     * <p>
     * @param path This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.WaitTime secondsPath(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.WaitTime.class, "secondsPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.WaitTime.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Wait until the given ISO8601 timestamp.
     * <p>
     * Example value: <code>2016-03-14T01:59:00Z</code>
     * <p>
     * @param timestamp This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.WaitTime timestamp(final @org.jetbrains.annotations.NotNull java.lang.String timestamp) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.WaitTime.class, "timestamp", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.WaitTime.class), new Object[] { java.util.Objects.requireNonNull(timestamp, "timestamp is required") });
    }

    /**
     * Wait until a timestamp found in the state object.
     * <p>
     * Example value: <code>$.waitTimestamp</code>
     * <p>
     * @param path This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.WaitTime timestampPath(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.WaitTime.class, "timestampPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.WaitTime.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }
}
