package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * The action to take when the cluster step fails.
 * <p>
 * Default: CONTINUE
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EmrAddStep.Builder.create(this, "Task")
 *         .clusterId("ClusterId")
 *         .name("StepName")
 *         .jar("Jar")
 *         .actionOnFailure(ActionOnFailure.CONTINUE)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/emr/latest/APIReference/API_StepConfig.html
 * Here, they are named as TERMINATE_JOB_FLOW, TERMINATE_CLUSTER, CANCEL_AND_WAIT, and CONTINUE respectively.">https://docs.aws.amazon.com/emr/latest/APIReference/API_StepConfig.html
 * Here, they are named as TERMINATE_JOB_FLOW, TERMINATE_CLUSTER, CANCEL_AND_WAIT, and CONTINUE respectively.</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:16.780Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.ActionOnFailure")
public enum ActionOnFailure {
    /**
     * Terminate the Cluster on Step Failure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TERMINATE_CLUSTER,
    /**
     * Cancel Step execution and enter WAITING state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CANCEL_AND_WAIT,
    /**
     * Continue to the next Step.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CONTINUE,
}
