package software.amazon.awscdk.services.wafv2;

/**
 * Defines an association between logging destinations and a web ACL resource, for logging from AWS WAF .
 * <p>
 * As part of the association, you can specify parts of the standard logging fields to keep out of the logs and you can specify filters so that you log only a subset of the logging records.
 * <p>
 * <blockquote>
 * <p>
 * You can define one logging destination per web ACL.
 * <p>
 * </blockquote>
 * <p>
 * You can access information about the traffic that AWS WAF inspects using the following steps:
 * <p>
 * <ul>
 * <li>Create your logging destination. You can use an Amazon CloudWatch Logs log group, an Amazon Simple Storage Service (Amazon S3) bucket, or an Amazon Kinesis Data Firehose.</li>
 * </ul>
 * <p>
 * The name that you give the destination must start with <code>aws-waf-logs-</code> . Depending on the type of destination, you might need to configure additional settings or permissions.
 * <p>
 * For configuration requirements and pricing information for each destination type, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging web ACL traffic</a> in the <em>AWS WAF Developer Guide</em> .
 * <p>
 * <ul>
 * <li>Associate your logging destination to your web ACL using a <code>PutLoggingConfiguration</code> request.</li>
 * </ul>
 * <p>
 * When you successfully enable logging using a <code>PutLoggingConfiguration</code> request, AWS WAF creates an additional role or policy that is required to write logs to the logging destination. For an Amazon CloudWatch Logs log group, AWS WAF creates a resource policy on the log group. For an Amazon S3 bucket, AWS WAF creates a bucket policy. For an Amazon Kinesis Data Firehose, AWS WAF creates a service-linked role.
 * <p>
 * For additional information about web ACL logging, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging web ACL traffic information</a> in the <em>AWS WAF Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.wafv2.*;
 * Object jsonBody;
 * Object loggingFilter;
 * Object method;
 * Object queryString;
 * Object singleHeader;
 * Object uriPath;
 * CfnLoggingConfiguration cfnLoggingConfiguration = CfnLoggingConfiguration.Builder.create(this, "MyCfnLoggingConfiguration")
 *         .logDestinationConfigs(List.of("logDestinationConfigs"))
 *         .resourceArn("resourceArn")
 *         // the properties below are optional
 *         .loggingFilter(loggingFilter)
 *         .redactedFields(List.of(FieldToMatchProperty.builder()
 *                 .jsonBody(jsonBody)
 *                 .method(method)
 *                 .queryString(queryString)
 *                 .singleHeader(singleHeader)
 *                 .uriPath(uriPath)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:17.278Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration")
public class CfnLoggingConfiguration extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnLoggingConfiguration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLoggingConfiguration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.wafv2.CfnLoggingConfiguration.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnLoggingConfiguration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.wafv2.CfnLoggingConfigurationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Indicates whether the logging configuration was created by AWS Firewall Manager , as part of an AWS WAF policy configuration.
     * <p>
     * If true, only Firewall Manager can modify or delete the configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrManagedByFirewallManager() {
        return software.amazon.jsii.Kernel.get(this, "attrManagedByFirewallManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The logging destination configuration that you want to associate with the web ACL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getLogDestinationConfigs() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "logDestinationConfigs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The logging destination configuration that you want to associate with the web ACL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogDestinationConfigs(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "logDestinationConfigs", java.util.Objects.requireNonNull(value, "logDestinationConfigs is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the web ACL that you want to associate with <code>LogDestinationConfigs</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResourceArn() {
        return software.amazon.jsii.Kernel.get(this, "resourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the web ACL that you want to associate with <code>LogDestinationConfigs</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "resourceArn", java.util.Objects.requireNonNull(value, "resourceArn is required"));
    }

    /**
     * Filtering that specifies which web requests are kept in the logs and which are dropped.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLoggingFilter() {
        return software.amazon.jsii.Kernel.get(this, "loggingFilter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Filtering that specifies which web requests are kept in the logs and which are dropped.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoggingFilter(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "loggingFilter", value);
    }

    /**
     * The parts of the request that you want to keep out of the logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRedactedFields() {
        return software.amazon.jsii.Kernel.get(this, "redactedFields", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The parts of the request that you want to keep out of the logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRedactedFields(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "redactedFields", value);
    }

    /**
     * The parts of the request that you want to keep out of the logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRedactedFields(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.wafv2.CfnLoggingConfiguration.FieldToMatchProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.wafv2.CfnLoggingConfiguration.FieldToMatchProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "redactedFields", value);
    }
    /**
     * A single action condition for a condition in a logging filter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * ActionConditionProperty actionConditionProperty = ActionConditionProperty.builder()
     *         .action("action")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-actioncondition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-actioncondition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.ActionConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(ActionConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ActionConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action setting that a log record must contain in order to meet the condition.
         * <p>
         * This is the action that AWS WAF applied to the web request.
         * <p>
         * For rule groups, this is either the configured rule action setting, or if you've applied a rule action override to the rule, it's the override action. The value <code>EXCLUDED_AS_COUNT</code> matches on excluded rules and also on rules that have a rule action override of Count.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-actioncondition.html#cfn-wafv2-loggingconfiguration-actioncondition-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-actioncondition.html#cfn-wafv2-loggingconfiguration-actioncondition-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAction();

        /**
         * @return a {@link Builder} of {@link ActionConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ActionConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ActionConditionProperty> {
            java.lang.String action;

            /**
             * Sets the value of {@link ActionConditionProperty#getAction}
             * @param action The action setting that a log record must contain in order to meet the condition. This parameter is required.
             *               This is the action that AWS WAF applied to the web request.
             *               <p>
             *               For rule groups, this is either the configured rule action setting, or if you've applied a rule action override to the rule, it's the override action. The value <code>EXCLUDED_AS_COUNT</code> matches on excluded rules and also on rules that have a rule action override of Count.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(java.lang.String action) {
                this.action = action;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActionConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ActionConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ActionConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionConditionProperty {
            private final java.lang.String action;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
            }

            @Override
            public final java.lang.String getAction() {
                return this.action;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("action", om.valueToTree(this.getAction()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.ActionConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ActionConditionProperty.Jsii$Proxy that = (ActionConditionProperty.Jsii$Proxy) o;

                return this.action.equals(that.action);
            }

            @Override
            public final int hashCode() {
                int result = this.action.hashCode();
                return result;
            }
        }
    }
    /**
     * A single match condition for a log filter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * ConditionProperty conditionProperty = ConditionProperty.builder()
     *         .actionCondition(ActionConditionProperty.builder()
     *                 .action("action")
     *                 .build())
     *         .labelNameCondition(LabelNameConditionProperty.builder()
     *                 .labelName("labelName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-condition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-condition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.ConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(ConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A single action condition.
         * <p>
         * This is the action setting that a log record must contain in order to meet the condition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-condition.html#cfn-wafv2-loggingconfiguration-condition-actioncondition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-condition.html#cfn-wafv2-loggingconfiguration-condition-actioncondition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getActionCondition() {
            return null;
        }

        /**
         * A single label name condition.
         * <p>
         * This is the fully qualified label name that a log record must contain in order to meet the condition. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-condition.html#cfn-wafv2-loggingconfiguration-condition-labelnamecondition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-condition.html#cfn-wafv2-loggingconfiguration-condition-labelnamecondition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLabelNameCondition() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConditionProperty> {
            java.lang.Object actionCondition;
            java.lang.Object labelNameCondition;

            /**
             * Sets the value of {@link ConditionProperty#getActionCondition}
             * @param actionCondition A single action condition.
             *                        This is the action setting that a log record must contain in order to meet the condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actionCondition(software.amazon.awscdk.IResolvable actionCondition) {
                this.actionCondition = actionCondition;
                return this;
            }

            /**
             * Sets the value of {@link ConditionProperty#getActionCondition}
             * @param actionCondition A single action condition.
             *                        This is the action setting that a log record must contain in order to meet the condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actionCondition(software.amazon.awscdk.services.wafv2.CfnLoggingConfiguration.ActionConditionProperty actionCondition) {
                this.actionCondition = actionCondition;
                return this;
            }

            /**
             * Sets the value of {@link ConditionProperty#getLabelNameCondition}
             * @param labelNameCondition A single label name condition.
             *                           This is the fully qualified label name that a log record must contain in order to meet the condition. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder labelNameCondition(software.amazon.awscdk.IResolvable labelNameCondition) {
                this.labelNameCondition = labelNameCondition;
                return this;
            }

            /**
             * Sets the value of {@link ConditionProperty#getLabelNameCondition}
             * @param labelNameCondition A single label name condition.
             *                           This is the fully qualified label name that a log record must contain in order to meet the condition. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder labelNameCondition(software.amazon.awscdk.services.wafv2.CfnLoggingConfiguration.LabelNameConditionProperty labelNameCondition) {
                this.labelNameCondition = labelNameCondition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConditionProperty {
            private final java.lang.Object actionCondition;
            private final java.lang.Object labelNameCondition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actionCondition = software.amazon.jsii.Kernel.get(this, "actionCondition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.labelNameCondition = software.amazon.jsii.Kernel.get(this, "labelNameCondition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actionCondition = builder.actionCondition;
                this.labelNameCondition = builder.labelNameCondition;
            }

            @Override
            public final java.lang.Object getActionCondition() {
                return this.actionCondition;
            }

            @Override
            public final java.lang.Object getLabelNameCondition() {
                return this.labelNameCondition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getActionCondition() != null) {
                    data.set("actionCondition", om.valueToTree(this.getActionCondition()));
                }
                if (this.getLabelNameCondition() != null) {
                    data.set("labelNameCondition", om.valueToTree(this.getLabelNameCondition()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.ConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConditionProperty.Jsii$Proxy that = (ConditionProperty.Jsii$Proxy) o;

                if (this.actionCondition != null ? !this.actionCondition.equals(that.actionCondition) : that.actionCondition != null) return false;
                return this.labelNameCondition != null ? this.labelNameCondition.equals(that.labelNameCondition) : that.labelNameCondition == null;
            }

            @Override
            public final int hashCode() {
                int result = this.actionCondition != null ? this.actionCondition.hashCode() : 0;
                result = 31 * result + (this.labelNameCondition != null ? this.labelNameCondition.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The parts of the request that you want to keep out of the logs.
     * <p>
     * This is used in the logging configuration <code>RedactedFields</code> specification.
     * <p>
     * Example JSON for a <code>QueryString</code> field to match:
     * <p>
     * <code>"FieldToMatch": { "QueryString": {} }</code>
     * <p>
     * Example JSON for a <code>Method</code> field to match specification:
     * <p>
     * <code>"FieldToMatch": { "Method": { "Name": "DELETE" } }</code>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object jsonBody;
     * Object method;
     * Object queryString;
     * Object singleHeader;
     * Object uriPath;
     * FieldToMatchProperty fieldToMatchProperty = FieldToMatchProperty.builder()
     *         .jsonBody(jsonBody)
     *         .method(method)
     *         .queryString(queryString)
     *         .singleHeader(singleHeader)
     *         .uriPath(uriPath)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-fieldtomatch.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-fieldtomatch.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.FieldToMatchProperty")
    @software.amazon.jsii.Jsii.Proxy(FieldToMatchProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FieldToMatchProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-fieldtomatch.html#cfn-wafv2-loggingconfiguration-fieldtomatch-jsonbody">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-fieldtomatch.html#cfn-wafv2-loggingconfiguration-fieldtomatch-jsonbody</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJsonBody() {
            return null;
        }

        /**
         * Redact the indicated HTTP method.
         * <p>
         * The method indicates the type of operation that the request is asking the origin to perform.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-fieldtomatch.html#cfn-wafv2-loggingconfiguration-fieldtomatch-method">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-fieldtomatch.html#cfn-wafv2-loggingconfiguration-fieldtomatch-method</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMethod() {
            return null;
        }

        /**
         * Redact the query string.
         * <p>
         * This is the part of a URL that appears after a <code>?</code> character, if any.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-fieldtomatch.html#cfn-wafv2-loggingconfiguration-fieldtomatch-querystring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-fieldtomatch.html#cfn-wafv2-loggingconfiguration-fieldtomatch-querystring</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getQueryString() {
            return null;
        }

        /**
         * Redact a single header.
         * <p>
         * Provide the name of the header to inspect, for example, <code>User-Agent</code> or <code>Referer</code> . This setting isn't case sensitive.
         * <p>
         * Example JSON: <code>"SingleHeader": { "Name": "haystack" }</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-fieldtomatch.html#cfn-wafv2-loggingconfiguration-fieldtomatch-singleheader">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-fieldtomatch.html#cfn-wafv2-loggingconfiguration-fieldtomatch-singleheader</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSingleHeader() {
            return null;
        }

        /**
         * Redact the request URI path.
         * <p>
         * This is the part of the web request that identifies a resource, for example, <code>/images/daily-ad.jpg</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-fieldtomatch.html#cfn-wafv2-loggingconfiguration-fieldtomatch-uripath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-fieldtomatch.html#cfn-wafv2-loggingconfiguration-fieldtomatch-uripath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUriPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FieldToMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FieldToMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FieldToMatchProperty> {
            java.lang.Object jsonBody;
            java.lang.Object method;
            java.lang.Object queryString;
            java.lang.Object singleHeader;
            java.lang.Object uriPath;

            /**
             * Sets the value of {@link FieldToMatchProperty#getJsonBody}
             * @param jsonBody the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jsonBody(java.lang.Object jsonBody) {
                this.jsonBody = jsonBody;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getMethod}
             * @param method Redact the indicated HTTP method.
             *               The method indicates the type of operation that the request is asking the origin to perform.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder method(java.lang.Object method) {
                this.method = method;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getQueryString}
             * @param queryString Redact the query string.
             *                    This is the part of a URL that appears after a <code>?</code> character, if any.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryString(java.lang.Object queryString) {
                this.queryString = queryString;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getSingleHeader}
             * @param singleHeader Redact a single header.
             *                     Provide the name of the header to inspect, for example, <code>User-Agent</code> or <code>Referer</code> . This setting isn't case sensitive.
             *                     <p>
             *                     Example JSON: <code>"SingleHeader": { "Name": "haystack" }</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleHeader(java.lang.Object singleHeader) {
                this.singleHeader = singleHeader;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getUriPath}
             * @param uriPath Redact the request URI path.
             *                This is the part of the web request that identifies a resource, for example, <code>/images/daily-ad.jpg</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uriPath(java.lang.Object uriPath) {
                this.uriPath = uriPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FieldToMatchProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FieldToMatchProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FieldToMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FieldToMatchProperty {
            private final java.lang.Object jsonBody;
            private final java.lang.Object method;
            private final java.lang.Object queryString;
            private final java.lang.Object singleHeader;
            private final java.lang.Object uriPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.jsonBody = software.amazon.jsii.Kernel.get(this, "jsonBody", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.method = software.amazon.jsii.Kernel.get(this, "method", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.queryString = software.amazon.jsii.Kernel.get(this, "queryString", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.singleHeader = software.amazon.jsii.Kernel.get(this, "singleHeader", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.uriPath = software.amazon.jsii.Kernel.get(this, "uriPath", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.jsonBody = builder.jsonBody;
                this.method = builder.method;
                this.queryString = builder.queryString;
                this.singleHeader = builder.singleHeader;
                this.uriPath = builder.uriPath;
            }

            @Override
            public final java.lang.Object getJsonBody() {
                return this.jsonBody;
            }

            @Override
            public final java.lang.Object getMethod() {
                return this.method;
            }

            @Override
            public final java.lang.Object getQueryString() {
                return this.queryString;
            }

            @Override
            public final java.lang.Object getSingleHeader() {
                return this.singleHeader;
            }

            @Override
            public final java.lang.Object getUriPath() {
                return this.uriPath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getJsonBody() != null) {
                    data.set("jsonBody", om.valueToTree(this.getJsonBody()));
                }
                if (this.getMethod() != null) {
                    data.set("method", om.valueToTree(this.getMethod()));
                }
                if (this.getQueryString() != null) {
                    data.set("queryString", om.valueToTree(this.getQueryString()));
                }
                if (this.getSingleHeader() != null) {
                    data.set("singleHeader", om.valueToTree(this.getSingleHeader()));
                }
                if (this.getUriPath() != null) {
                    data.set("uriPath", om.valueToTree(this.getUriPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.FieldToMatchProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FieldToMatchProperty.Jsii$Proxy that = (FieldToMatchProperty.Jsii$Proxy) o;

                if (this.jsonBody != null ? !this.jsonBody.equals(that.jsonBody) : that.jsonBody != null) return false;
                if (this.method != null ? !this.method.equals(that.method) : that.method != null) return false;
                if (this.queryString != null ? !this.queryString.equals(that.queryString) : that.queryString != null) return false;
                if (this.singleHeader != null ? !this.singleHeader.equals(that.singleHeader) : that.singleHeader != null) return false;
                return this.uriPath != null ? this.uriPath.equals(that.uriPath) : that.uriPath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.jsonBody != null ? this.jsonBody.hashCode() : 0;
                result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
                result = 31 * result + (this.queryString != null ? this.queryString.hashCode() : 0);
                result = 31 * result + (this.singleHeader != null ? this.singleHeader.hashCode() : 0);
                result = 31 * result + (this.uriPath != null ? this.uriPath.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A single logging filter, used in <code>LoggingFilter</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * FilterProperty filterProperty = FilterProperty.builder()
     *         .behavior("behavior")
     *         .conditions(List.of(ConditionProperty.builder()
     *                 .actionCondition(ActionConditionProperty.builder()
     *                         .action("action")
     *                         .build())
     *                 .labelNameCondition(LabelNameConditionProperty.builder()
     *                         .labelName("labelName")
     *                         .build())
     *                 .build()))
     *         .requirement("requirement")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-filter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-filter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.FilterProperty")
    @software.amazon.jsii.Jsii.Proxy(FilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * How to handle logs that satisfy the filter's conditions and requirement.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-filter.html#cfn-wafv2-loggingconfiguration-filter-behavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-filter.html#cfn-wafv2-loggingconfiguration-filter-behavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBehavior();

        /**
         * Match conditions for the filter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-filter.html#cfn-wafv2-loggingconfiguration-filter-conditions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-filter.html#cfn-wafv2-loggingconfiguration-filter-conditions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getConditions();

        /**
         * Logic to apply to the filtering conditions.
         * <p>
         * You can specify that, in order to satisfy the filter, a log must match all conditions or must match at least one condition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-filter.html#cfn-wafv2-loggingconfiguration-filter-requirement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-filter.html#cfn-wafv2-loggingconfiguration-filter-requirement</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRequirement();

        /**
         * @return a {@link Builder} of {@link FilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FilterProperty> {
            java.lang.String behavior;
            java.lang.Object conditions;
            java.lang.String requirement;

            /**
             * Sets the value of {@link FilterProperty#getBehavior}
             * @param behavior How to handle logs that satisfy the filter's conditions and requirement. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder behavior(java.lang.String behavior) {
                this.behavior = behavior;
                return this;
            }

            /**
             * Sets the value of {@link FilterProperty#getConditions}
             * @param conditions Match conditions for the filter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditions(software.amazon.awscdk.IResolvable conditions) {
                this.conditions = conditions;
                return this;
            }

            /**
             * Sets the value of {@link FilterProperty#getConditions}
             * @param conditions Match conditions for the filter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditions(java.util.List<? extends java.lang.Object> conditions) {
                this.conditions = conditions;
                return this;
            }

            /**
             * Sets the value of {@link FilterProperty#getRequirement}
             * @param requirement Logic to apply to the filtering conditions. This parameter is required.
             *                    You can specify that, in order to satisfy the filter, a log must match all conditions or must match at least one condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requirement(java.lang.String requirement) {
                this.requirement = requirement;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FilterProperty {
            private final java.lang.String behavior;
            private final java.lang.Object conditions;
            private final java.lang.String requirement;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.behavior = software.amazon.jsii.Kernel.get(this, "behavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.conditions = software.amazon.jsii.Kernel.get(this, "conditions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.requirement = software.amazon.jsii.Kernel.get(this, "requirement", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.behavior = java.util.Objects.requireNonNull(builder.behavior, "behavior is required");
                this.conditions = java.util.Objects.requireNonNull(builder.conditions, "conditions is required");
                this.requirement = java.util.Objects.requireNonNull(builder.requirement, "requirement is required");
            }

            @Override
            public final java.lang.String getBehavior() {
                return this.behavior;
            }

            @Override
            public final java.lang.Object getConditions() {
                return this.conditions;
            }

            @Override
            public final java.lang.String getRequirement() {
                return this.requirement;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("behavior", om.valueToTree(this.getBehavior()));
                data.set("conditions", om.valueToTree(this.getConditions()));
                data.set("requirement", om.valueToTree(this.getRequirement()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.FilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FilterProperty.Jsii$Proxy that = (FilterProperty.Jsii$Proxy) o;

                if (!behavior.equals(that.behavior)) return false;
                if (!conditions.equals(that.conditions)) return false;
                return this.requirement.equals(that.requirement);
            }

            @Override
            public final int hashCode() {
                int result = this.behavior.hashCode();
                result = 31 * result + (this.conditions.hashCode());
                result = 31 * result + (this.requirement.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object all;
     * JsonBodyProperty jsonBodyProperty = JsonBodyProperty.builder()
     *         .matchPattern(MatchPatternProperty.builder()
     *                 .all(all)
     *                 .includedPaths(List.of("includedPaths"))
     *                 .build())
     *         .matchScope("matchScope")
     *         // the properties below are optional
     *         .invalidFallbackBehavior("invalidFallbackBehavior")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-jsonbody.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-jsonbody.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.JsonBodyProperty")
    @software.amazon.jsii.Jsii.Proxy(JsonBodyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JsonBodyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-jsonbody.html#cfn-wafv2-loggingconfiguration-jsonbody-matchpattern">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-jsonbody.html#cfn-wafv2-loggingconfiguration-jsonbody-matchpattern</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMatchPattern();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-jsonbody.html#cfn-wafv2-loggingconfiguration-jsonbody-matchscope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-jsonbody.html#cfn-wafv2-loggingconfiguration-jsonbody-matchscope</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMatchScope();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-jsonbody.html#cfn-wafv2-loggingconfiguration-jsonbody-invalidfallbackbehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-jsonbody.html#cfn-wafv2-loggingconfiguration-jsonbody-invalidfallbackbehavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInvalidFallbackBehavior() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JsonBodyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JsonBodyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JsonBodyProperty> {
            java.lang.Object matchPattern;
            java.lang.String matchScope;
            java.lang.String invalidFallbackBehavior;

            /**
             * Sets the value of {@link JsonBodyProperty#getMatchPattern}
             * @param matchPattern the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchPattern(software.amazon.awscdk.IResolvable matchPattern) {
                this.matchPattern = matchPattern;
                return this;
            }

            /**
             * Sets the value of {@link JsonBodyProperty#getMatchPattern}
             * @param matchPattern the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchPattern(software.amazon.awscdk.services.wafv2.CfnLoggingConfiguration.MatchPatternProperty matchPattern) {
                this.matchPattern = matchPattern;
                return this;
            }

            /**
             * Sets the value of {@link JsonBodyProperty#getMatchScope}
             * @param matchScope the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchScope(java.lang.String matchScope) {
                this.matchScope = matchScope;
                return this;
            }

            /**
             * Sets the value of {@link JsonBodyProperty#getInvalidFallbackBehavior}
             * @param invalidFallbackBehavior the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder invalidFallbackBehavior(java.lang.String invalidFallbackBehavior) {
                this.invalidFallbackBehavior = invalidFallbackBehavior;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JsonBodyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JsonBodyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JsonBodyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JsonBodyProperty {
            private final java.lang.Object matchPattern;
            private final java.lang.String matchScope;
            private final java.lang.String invalidFallbackBehavior;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.matchPattern = software.amazon.jsii.Kernel.get(this, "matchPattern", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.matchScope = software.amazon.jsii.Kernel.get(this, "matchScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.invalidFallbackBehavior = software.amazon.jsii.Kernel.get(this, "invalidFallbackBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.matchPattern = java.util.Objects.requireNonNull(builder.matchPattern, "matchPattern is required");
                this.matchScope = java.util.Objects.requireNonNull(builder.matchScope, "matchScope is required");
                this.invalidFallbackBehavior = builder.invalidFallbackBehavior;
            }

            @Override
            public final java.lang.Object getMatchPattern() {
                return this.matchPattern;
            }

            @Override
            public final java.lang.String getMatchScope() {
                return this.matchScope;
            }

            @Override
            public final java.lang.String getInvalidFallbackBehavior() {
                return this.invalidFallbackBehavior;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("matchPattern", om.valueToTree(this.getMatchPattern()));
                data.set("matchScope", om.valueToTree(this.getMatchScope()));
                if (this.getInvalidFallbackBehavior() != null) {
                    data.set("invalidFallbackBehavior", om.valueToTree(this.getInvalidFallbackBehavior()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.JsonBodyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JsonBodyProperty.Jsii$Proxy that = (JsonBodyProperty.Jsii$Proxy) o;

                if (!matchPattern.equals(that.matchPattern)) return false;
                if (!matchScope.equals(that.matchScope)) return false;
                return this.invalidFallbackBehavior != null ? this.invalidFallbackBehavior.equals(that.invalidFallbackBehavior) : that.invalidFallbackBehavior == null;
            }

            @Override
            public final int hashCode() {
                int result = this.matchPattern.hashCode();
                result = 31 * result + (this.matchScope.hashCode());
                result = 31 * result + (this.invalidFallbackBehavior != null ? this.invalidFallbackBehavior.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A single label name condition for a condition in a logging filter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * LabelNameConditionProperty labelNameConditionProperty = LabelNameConditionProperty.builder()
     *         .labelName("labelName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-labelnamecondition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-labelnamecondition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.LabelNameConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(LabelNameConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LabelNameConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The label name that a log record must contain in order to meet the condition.
         * <p>
         * This must be a fully qualified label name. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-labelnamecondition.html#cfn-wafv2-loggingconfiguration-labelnamecondition-labelname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-labelnamecondition.html#cfn-wafv2-loggingconfiguration-labelnamecondition-labelname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLabelName();

        /**
         * @return a {@link Builder} of {@link LabelNameConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LabelNameConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LabelNameConditionProperty> {
            java.lang.String labelName;

            /**
             * Sets the value of {@link LabelNameConditionProperty#getLabelName}
             * @param labelName The label name that a log record must contain in order to meet the condition. This parameter is required.
             *                  This must be a fully qualified label name. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder labelName(java.lang.String labelName) {
                this.labelName = labelName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LabelNameConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LabelNameConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LabelNameConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LabelNameConditionProperty {
            private final java.lang.String labelName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.labelName = software.amazon.jsii.Kernel.get(this, "labelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.labelName = java.util.Objects.requireNonNull(builder.labelName, "labelName is required");
            }

            @Override
            public final java.lang.String getLabelName() {
                return this.labelName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("labelName", om.valueToTree(this.getLabelName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.LabelNameConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LabelNameConditionProperty.Jsii$Proxy that = (LabelNameConditionProperty.Jsii$Proxy) o;

                return this.labelName.equals(that.labelName);
            }

            @Override
            public final int hashCode() {
                int result = this.labelName.hashCode();
                return result;
            }
        }
    }
    /**
     * Filtering that specifies which web requests are kept in the logs and which are dropped, defined for a web ACL's <code>LoggingConfiguration</code> .
     * <p>
     * You can filter on the rule action and on the web request labels that were applied by matching rules during web ACL evaluation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * LoggingFilterProperty loggingFilterProperty = LoggingFilterProperty.builder()
     *         .defaultBehavior("defaultBehavior")
     *         .filters(List.of(FilterProperty.builder()
     *                 .behavior("behavior")
     *                 .conditions(List.of(ConditionProperty.builder()
     *                         .actionCondition(ActionConditionProperty.builder()
     *                                 .action("action")
     *                                 .build())
     *                         .labelNameCondition(LabelNameConditionProperty.builder()
     *                                 .labelName("labelName")
     *                                 .build())
     *                         .build()))
     *                 .requirement("requirement")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-loggingfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-loggingfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.LoggingFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(LoggingFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoggingFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Default handling for logs that don't match any of the specified filtering conditions.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-loggingfilter.html#cfn-wafv2-loggingconfiguration-loggingfilter-defaultbehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-loggingfilter.html#cfn-wafv2-loggingconfiguration-loggingfilter-defaultbehavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDefaultBehavior();

        /**
         * The filters that you want to apply to the logs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-loggingfilter.html#cfn-wafv2-loggingconfiguration-loggingfilter-filters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-loggingfilter.html#cfn-wafv2-loggingconfiguration-loggingfilter-filters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFilters();

        /**
         * @return a {@link Builder} of {@link LoggingFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoggingFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoggingFilterProperty> {
            java.lang.String defaultBehavior;
            java.lang.Object filters;

            /**
             * Sets the value of {@link LoggingFilterProperty#getDefaultBehavior}
             * @param defaultBehavior Default handling for logs that don't match any of the specified filtering conditions. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultBehavior(java.lang.String defaultBehavior) {
                this.defaultBehavior = defaultBehavior;
                return this;
            }

            /**
             * Sets the value of {@link LoggingFilterProperty#getFilters}
             * @param filters The filters that you want to apply to the logs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filters(software.amazon.awscdk.IResolvable filters) {
                this.filters = filters;
                return this;
            }

            /**
             * Sets the value of {@link LoggingFilterProperty#getFilters}
             * @param filters The filters that you want to apply to the logs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filters(java.util.List<? extends java.lang.Object> filters) {
                this.filters = filters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggingFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoggingFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoggingFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggingFilterProperty {
            private final java.lang.String defaultBehavior;
            private final java.lang.Object filters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultBehavior = software.amazon.jsii.Kernel.get(this, "defaultBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.filters = software.amazon.jsii.Kernel.get(this, "filters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultBehavior = java.util.Objects.requireNonNull(builder.defaultBehavior, "defaultBehavior is required");
                this.filters = java.util.Objects.requireNonNull(builder.filters, "filters is required");
            }

            @Override
            public final java.lang.String getDefaultBehavior() {
                return this.defaultBehavior;
            }

            @Override
            public final java.lang.Object getFilters() {
                return this.filters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("defaultBehavior", om.valueToTree(this.getDefaultBehavior()));
                data.set("filters", om.valueToTree(this.getFilters()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.LoggingFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoggingFilterProperty.Jsii$Proxy that = (LoggingFilterProperty.Jsii$Proxy) o;

                if (!defaultBehavior.equals(that.defaultBehavior)) return false;
                return this.filters.equals(that.filters);
            }

            @Override
            public final int hashCode() {
                int result = this.defaultBehavior.hashCode();
                result = 31 * result + (this.filters.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object all;
     * MatchPatternProperty matchPatternProperty = MatchPatternProperty.builder()
     *         .all(all)
     *         .includedPaths(List.of("includedPaths"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-matchpattern.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-matchpattern.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.MatchPatternProperty")
    @software.amazon.jsii.Jsii.Proxy(MatchPatternProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MatchPatternProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-matchpattern.html#cfn-wafv2-loggingconfiguration-matchpattern-all">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-matchpattern.html#cfn-wafv2-loggingconfiguration-matchpattern-all</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAll() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-matchpattern.html#cfn-wafv2-loggingconfiguration-matchpattern-includedpaths">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-matchpattern.html#cfn-wafv2-loggingconfiguration-matchpattern-includedpaths</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIncludedPaths() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MatchPatternProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MatchPatternProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MatchPatternProperty> {
            java.lang.Object all;
            java.util.List<java.lang.String> includedPaths;

            /**
             * Sets the value of {@link MatchPatternProperty#getAll}
             * @param all the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder all(java.lang.Object all) {
                this.all = all;
                return this;
            }

            /**
             * Sets the value of {@link MatchPatternProperty#getIncludedPaths}
             * @param includedPaths the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includedPaths(java.util.List<java.lang.String> includedPaths) {
                this.includedPaths = includedPaths;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MatchPatternProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MatchPatternProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MatchPatternProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MatchPatternProperty {
            private final java.lang.Object all;
            private final java.util.List<java.lang.String> includedPaths;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.all = software.amazon.jsii.Kernel.get(this, "all", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includedPaths = software.amazon.jsii.Kernel.get(this, "includedPaths", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.all = builder.all;
                this.includedPaths = builder.includedPaths;
            }

            @Override
            public final java.lang.Object getAll() {
                return this.all;
            }

            @Override
            public final java.util.List<java.lang.String> getIncludedPaths() {
                return this.includedPaths;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAll() != null) {
                    data.set("all", om.valueToTree(this.getAll()));
                }
                if (this.getIncludedPaths() != null) {
                    data.set("includedPaths", om.valueToTree(this.getIncludedPaths()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.MatchPatternProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MatchPatternProperty.Jsii$Proxy that = (MatchPatternProperty.Jsii$Proxy) o;

                if (this.all != null ? !this.all.equals(that.all) : that.all != null) return false;
                return this.includedPaths != null ? this.includedPaths.equals(that.includedPaths) : that.includedPaths == null;
            }

            @Override
            public final int hashCode() {
                int result = this.all != null ? this.all.hashCode() : 0;
                result = 31 * result + (this.includedPaths != null ? this.includedPaths.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Inspect one of the headers in the web request, identified by name, for example, <code>User-Agent</code> or <code>Referer</code> .
     * <p>
     * The name isn't case sensitive.
     * <p>
     * You can filter and inspect all headers with the <code>FieldToMatch</code> setting <code>Headers</code> .
     * <p>
     * This is used to indicate the web request component to inspect, in the <code>FieldToMatch</code> specification.
     * <p>
     * Example JSON: <code>"SingleHeader": { "Name": "haystack" }</code>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * SingleHeaderProperty singleHeaderProperty = SingleHeaderProperty.builder()
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-singleheader.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-singleheader.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.SingleHeaderProperty")
    @software.amazon.jsii.Jsii.Proxy(SingleHeaderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SingleHeaderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the query header to inspect.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-singleheader.html#cfn-wafv2-loggingconfiguration-singleheader-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-singleheader.html#cfn-wafv2-loggingconfiguration-singleheader-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link SingleHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SingleHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SingleHeaderProperty> {
            java.lang.String name;

            /**
             * Sets the value of {@link SingleHeaderProperty#getName}
             * @param name The name of the query header to inspect. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SingleHeaderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SingleHeaderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SingleHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SingleHeaderProperty {
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.SingleHeaderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SingleHeaderProperty.Jsii$Proxy that = (SingleHeaderProperty.Jsii$Proxy) o;

                return this.name.equals(that.name);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.wafv2.CfnLoggingConfiguration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.wafv2.CfnLoggingConfiguration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.wafv2.CfnLoggingConfigurationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.wafv2.CfnLoggingConfigurationProps.Builder();
        }

        /**
         * The logging destination configuration that you want to associate with the web ACL.
         * <p>
         * <blockquote>
         * <p>
         * You can associate one logging destination to a web ACL.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-logdestinationconfigs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-logdestinationconfigs</a>
         * @param logDestinationConfigs The logging destination configuration that you want to associate with the web ACL. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDestinationConfigs(final java.util.List<java.lang.String> logDestinationConfigs) {
            this.props.logDestinationConfigs(logDestinationConfigs);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the web ACL that you want to associate with <code>LogDestinationConfigs</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-resourcearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-resourcearn</a>
         * @param resourceArn The Amazon Resource Name (ARN) of the web ACL that you want to associate with <code>LogDestinationConfigs</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceArn(final java.lang.String resourceArn) {
            this.props.resourceArn(resourceArn);
            return this;
        }

        /**
         * Filtering that specifies which web requests are kept in the logs and which are dropped.
         * <p>
         * You can filter on the rule action and on the web request labels that were applied by matching rules during web ACL evaluation.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-loggingfilter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-loggingfilter</a>
         * @param loggingFilter Filtering that specifies which web requests are kept in the logs and which are dropped. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingFilter(final java.lang.Object loggingFilter) {
            this.props.loggingFilter(loggingFilter);
            return this;
        }

        /**
         * The parts of the request that you want to keep out of the logs.
         * <p>
         * For example, if you redact the <code>SingleHeader</code> field, the <code>HEADER</code> field in the logs will be <code>REDACTED</code> for all rules that use the <code>SingleHeader</code> <code>FieldToMatch</code> setting.
         * <p>
         * Redaction applies only to the component that's specified in the rule's <code>FieldToMatch</code> setting, so the <code>SingleHeader</code> redaction doesn't apply to rules that use the <code>Headers</code> <code>FieldToMatch</code> .
         * <p>
         * <blockquote>
         * <p>
         * You can specify only the following fields for redaction: <code>UriPath</code> , <code>QueryString</code> , <code>SingleHeader</code> , and <code>Method</code> . &gt; This setting has no impact on request sampling. With request sampling, the only way to exclude fields is by disabling sampling in the web ACL visibility configuration.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-redactedfields">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-redactedfields</a>
         * @param redactedFields The parts of the request that you want to keep out of the logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redactedFields(final software.amazon.awscdk.IResolvable redactedFields) {
            this.props.redactedFields(redactedFields);
            return this;
        }
        /**
         * The parts of the request that you want to keep out of the logs.
         * <p>
         * For example, if you redact the <code>SingleHeader</code> field, the <code>HEADER</code> field in the logs will be <code>REDACTED</code> for all rules that use the <code>SingleHeader</code> <code>FieldToMatch</code> setting.
         * <p>
         * Redaction applies only to the component that's specified in the rule's <code>FieldToMatch</code> setting, so the <code>SingleHeader</code> redaction doesn't apply to rules that use the <code>Headers</code> <code>FieldToMatch</code> .
         * <p>
         * <blockquote>
         * <p>
         * You can specify only the following fields for redaction: <code>UriPath</code> , <code>QueryString</code> , <code>SingleHeader</code> , and <code>Method</code> . &gt; This setting has no impact on request sampling. With request sampling, the only way to exclude fields is by disabling sampling in the web ACL visibility configuration.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-redactedfields">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-redactedfields</a>
         * @param redactedFields The parts of the request that you want to keep out of the logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redactedFields(final java.util.List<? extends java.lang.Object> redactedFields) {
            this.props.redactedFields(redactedFields);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.wafv2.CfnLoggingConfiguration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.wafv2.CfnLoggingConfiguration build() {
            return new software.amazon.awscdk.services.wafv2.CfnLoggingConfiguration(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
