package software.amazon.awscdk;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * Object props;
 * GetContextKeyOptions getContextKeyOptions = GetContextKeyOptions.builder()
 *         .provider("provider")
 *         // the properties below are optional
 *         .includeEnvironment(false)
 *         .props(Map.of(
 *                 "propsKey", props))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:52.107Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.GetContextKeyOptions")
@software.amazon.jsii.Jsii.Proxy(GetContextKeyOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GetContextKeyOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The context provider to query.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProvider();

    /**
     * Whether to include the stack's account and region automatically.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIncludeEnvironment() {
        return null;
    }

    /**
     * Provider-specific properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getProps() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GetContextKeyOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GetContextKeyOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GetContextKeyOptions> {
        java.lang.String provider;
        java.lang.Boolean includeEnvironment;
        java.util.Map<java.lang.String, java.lang.Object> props;

        /**
         * Sets the value of {@link GetContextKeyOptions#getProvider}
         * @param provider The context provider to query. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provider(java.lang.String provider) {
            this.provider = provider;
            return this;
        }

        /**
         * Sets the value of {@link GetContextKeyOptions#getIncludeEnvironment}
         * @param includeEnvironment Whether to include the stack's account and region automatically.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeEnvironment(java.lang.Boolean includeEnvironment) {
            this.includeEnvironment = includeEnvironment;
            return this;
        }

        /**
         * Sets the value of {@link GetContextKeyOptions#getProps}
         * @param props Provider-specific properties.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder props(java.util.Map<java.lang.String, ? extends java.lang.Object> props) {
            this.props = (java.util.Map<java.lang.String, java.lang.Object>)props;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GetContextKeyOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GetContextKeyOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GetContextKeyOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GetContextKeyOptions {
        private final java.lang.String provider;
        private final java.lang.Boolean includeEnvironment;
        private final java.util.Map<java.lang.String, java.lang.Object> props;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.provider = software.amazon.jsii.Kernel.get(this, "provider", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.includeEnvironment = software.amazon.jsii.Kernel.get(this, "includeEnvironment", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.props = software.amazon.jsii.Kernel.get(this, "props", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.provider = java.util.Objects.requireNonNull(builder.provider, "provider is required");
            this.includeEnvironment = builder.includeEnvironment;
            this.props = (java.util.Map<java.lang.String, java.lang.Object>)builder.props;
        }

        @Override
        public final java.lang.String getProvider() {
            return this.provider;
        }

        @Override
        public final java.lang.Boolean getIncludeEnvironment() {
            return this.includeEnvironment;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getProps() {
            return this.props;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("provider", om.valueToTree(this.getProvider()));
            if (this.getIncludeEnvironment() != null) {
                data.set("includeEnvironment", om.valueToTree(this.getIncludeEnvironment()));
            }
            if (this.getProps() != null) {
                data.set("props", om.valueToTree(this.getProps()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.GetContextKeyOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GetContextKeyOptions.Jsii$Proxy that = (GetContextKeyOptions.Jsii$Proxy) o;

            if (!provider.equals(that.provider)) return false;
            if (this.includeEnvironment != null ? !this.includeEnvironment.equals(that.includeEnvironment) : that.includeEnvironment != null) return false;
            return this.props != null ? this.props.equals(that.props) : that.props == null;
        }

        @Override
        public final int hashCode() {
            int result = this.provider.hashCode();
            result = 31 * result + (this.includeEnvironment != null ? this.includeEnvironment.hashCode() : 0);
            result = 31 * result + (this.props != null ? this.props.hashCode() : 0);
            return result;
        }
    }
}
