package software.amazon.awscdk.pipelines;

/**
 * Options for GitHub sources.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CodePipelineSource.gitHub("org/repo", "branch", GitHubSourceOptions.builder()
 *         // This is optional
 *         .authentication(SecretValue.secretsManager("my-token"))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:58.870Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.GitHubSourceOptions")
@software.amazon.jsii.Jsii.Proxy(GitHubSourceOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GitHubSourceOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * A GitHub OAuth token to use for authentication.
     * <p>
     * It is recommended to use a Secrets Manager <code>Secret</code> to obtain the token:
     * <p>
     * <blockquote><pre>
     * SecretValue oauth = SecretValue.secretsManager("my-github-token");
     * </pre></blockquote>
     * <p>
     * The GitHub Personal Access Token should have these scopes:
     * <p>
     * <ul>
     * <li><strong>repo</strong> - to read the repository</li>
     * <li><strong>admin:repo_hook</strong> - if you plan to use webhooks (true by default)</li>
     * </ul>
     * <p>
     * Default: - SecretValue.secretsManager('github-token')
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/GitHub-create-personal-token-CLI.html">https://docs.aws.amazon.com/codepipeline/latest/userguide/GitHub-create-personal-token-CLI.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.SecretValue getAuthentication() {
        return null;
    }

    /**
     * How AWS CodePipeline should be triggered.
     * <p>
     * With the default value "WEBHOOK", a webhook is created in GitHub that triggers the action.
     * With "POLL", CodePipeline periodically checks the source for changes.
     * With "None", the action is not triggered through changes in the source.
     * <p>
     * To use <code>WEBHOOK</code>, your GitHub Personal Access Token should have
     * <strong>admin:repo_hook</strong> scope (in addition to the regular <strong>repo</strong> scope).
     * <p>
     * Default: GitHubTrigger.WEBHOOK
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.actions.GitHubTrigger getTrigger() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GitHubSourceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GitHubSourceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GitHubSourceOptions> {
        software.amazon.awscdk.SecretValue authentication;
        software.amazon.awscdk.services.codepipeline.actions.GitHubTrigger trigger;

        /**
         * Sets the value of {@link GitHubSourceOptions#getAuthentication}
         * @param authentication A GitHub OAuth token to use for authentication.
         *                       It is recommended to use a Secrets Manager <code>Secret</code> to obtain the token:
         *                       <p>
         *                       <blockquote><pre>
         *                       SecretValue oauth = SecretValue.secretsManager("my-github-token");
         *                       </pre></blockquote>
         *                       <p>
         *                       The GitHub Personal Access Token should have these scopes:
         *                       <p>
         *                       <ul>
         *                       <li><strong>repo</strong> - to read the repository</li>
         *                       <li><strong>admin:repo_hook</strong> - if you plan to use webhooks (true by default)</li>
         *                       </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authentication(software.amazon.awscdk.SecretValue authentication) {
            this.authentication = authentication;
            return this;
        }

        /**
         * Sets the value of {@link GitHubSourceOptions#getTrigger}
         * @param trigger How AWS CodePipeline should be triggered.
         *                With the default value "WEBHOOK", a webhook is created in GitHub that triggers the action.
         *                With "POLL", CodePipeline periodically checks the source for changes.
         *                With "None", the action is not triggered through changes in the source.
         *                <p>
         *                To use <code>WEBHOOK</code>, your GitHub Personal Access Token should have
         *                <strong>admin:repo_hook</strong> scope (in addition to the regular <strong>repo</strong> scope).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trigger(software.amazon.awscdk.services.codepipeline.actions.GitHubTrigger trigger) {
            this.trigger = trigger;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GitHubSourceOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GitHubSourceOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GitHubSourceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GitHubSourceOptions {
        private final software.amazon.awscdk.SecretValue authentication;
        private final software.amazon.awscdk.services.codepipeline.actions.GitHubTrigger trigger;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authentication = software.amazon.jsii.Kernel.get(this, "authentication", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class));
            this.trigger = software.amazon.jsii.Kernel.get(this, "trigger", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.GitHubTrigger.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authentication = builder.authentication;
            this.trigger = builder.trigger;
        }

        @Override
        public final software.amazon.awscdk.SecretValue getAuthentication() {
            return this.authentication;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.actions.GitHubTrigger getTrigger() {
            return this.trigger;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAuthentication() != null) {
                data.set("authentication", om.valueToTree(this.getAuthentication()));
            }
            if (this.getTrigger() != null) {
                data.set("trigger", om.valueToTree(this.getTrigger()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.pipelines.GitHubSourceOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GitHubSourceOptions.Jsii$Proxy that = (GitHubSourceOptions.Jsii$Proxy) o;

            if (this.authentication != null ? !this.authentication.equals(that.authentication) : that.authentication != null) return false;
            return this.trigger != null ? this.trigger.equals(that.trigger) : that.trigger == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authentication != null ? this.authentication.hashCode() : 0;
            result = 31 * result + (this.trigger != null ? this.trigger.hashCode() : 0);
            return result;
        }
    }
}
