package software.amazon.awscdk.services.apigateway;

/**
 * The minimum version of the SSL protocol that you want API Gateway to use for HTTPS connections.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Object acmCertificateForExampleCom;
 * DomainName.Builder.create(this, "custom-domain")
 *         .domainName("example.com")
 *         .certificate(acmCertificateForExampleCom)
 *         .endpointType(EndpointType.EDGE) // default is REGIONAL
 *         .securityPolicy(SecurityPolicy.TLS_1_2)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:52.401Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.SecurityPolicy")
public enum SecurityPolicy {
    /**
     * Cipher suite TLS 1.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TLS_1_0,
    /**
     * Cipher suite TLS 1.2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TLS_1_2,
}
