package software.amazon.awscdk.services.apigatewayv2;

/**
 * Properties for defining a `CfnDomainName`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * Object tags;
 * CfnDomainNameProps cfnDomainNameProps = CfnDomainNameProps.builder()
 *         .domainName("domainName")
 *         // the properties below are optional
 *         .domainNameConfigurations(List.of(DomainNameConfigurationProperty.builder()
 *                 .certificateArn("certificateArn")
 *                 .certificateName("certificateName")
 *                 .endpointType("endpointType")
 *                 .ownershipVerificationCertificateArn("ownershipVerificationCertificateArn")
 *                 .securityPolicy("securityPolicy")
 *                 .build()))
 *         .mutualTlsAuthentication(MutualTlsAuthenticationProperty.builder()
 *                 .truststoreUri("truststoreUri")
 *                 .truststoreVersion("truststoreVersion")
 *                 .build())
 *         .tags(tags)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:52.439Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.CfnDomainNameProps")
@software.amazon.jsii.Jsii.Proxy(CfnDomainNameProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDomainNameProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The custom domain name for your API in Amazon API Gateway.
     * <p>
     * Uppercase letters are not supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

    /**
     * The domain name configurations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDomainNameConfigurations() {
        return null;
    }

    /**
     * The mutual TLS authentication configuration for a custom domain name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMutualTlsAuthentication() {
        return null;
    }

    /**
     * The collection of tags associated with a domain name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDomainNameProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDomainNameProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDomainNameProps> {
        java.lang.String domainName;
        java.lang.Object domainNameConfigurations;
        java.lang.Object mutualTlsAuthentication;
        java.lang.Object tags;

        /**
         * Sets the value of {@link CfnDomainNameProps#getDomainName}
         * @param domainName The custom domain name for your API in Amazon API Gateway. This parameter is required.
         *                   Uppercase letters are not supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainNameProps#getDomainNameConfigurations}
         * @param domainNameConfigurations The domain name configurations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainNameConfigurations(software.amazon.awscdk.IResolvable domainNameConfigurations) {
            this.domainNameConfigurations = domainNameConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainNameProps#getDomainNameConfigurations}
         * @param domainNameConfigurations The domain name configurations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainNameConfigurations(java.util.List<? extends java.lang.Object> domainNameConfigurations) {
            this.domainNameConfigurations = domainNameConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainNameProps#getMutualTlsAuthentication}
         * @param mutualTlsAuthentication The mutual TLS authentication configuration for a custom domain name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mutualTlsAuthentication(software.amazon.awscdk.services.apigatewayv2.CfnDomainName.MutualTlsAuthenticationProperty mutualTlsAuthentication) {
            this.mutualTlsAuthentication = mutualTlsAuthentication;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainNameProps#getMutualTlsAuthentication}
         * @param mutualTlsAuthentication The mutual TLS authentication configuration for a custom domain name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mutualTlsAuthentication(software.amazon.awscdk.IResolvable mutualTlsAuthentication) {
            this.mutualTlsAuthentication = mutualTlsAuthentication;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainNameProps#getTags}
         * @param tags The collection of tags associated with a domain name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.lang.Object tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDomainNameProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDomainNameProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDomainNameProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDomainNameProps {
        private final java.lang.String domainName;
        private final java.lang.Object domainNameConfigurations;
        private final java.lang.Object mutualTlsAuthentication;
        private final java.lang.Object tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainNameConfigurations = software.amazon.jsii.Kernel.get(this, "domainNameConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.mutualTlsAuthentication = software.amazon.jsii.Kernel.get(this, "mutualTlsAuthentication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
            this.domainNameConfigurations = builder.domainNameConfigurations;
            this.mutualTlsAuthentication = builder.mutualTlsAuthentication;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final java.lang.Object getDomainNameConfigurations() {
            return this.domainNameConfigurations;
        }

        @Override
        public final java.lang.Object getMutualTlsAuthentication() {
            return this.mutualTlsAuthentication;
        }

        @Override
        public final java.lang.Object getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domainName", om.valueToTree(this.getDomainName()));
            if (this.getDomainNameConfigurations() != null) {
                data.set("domainNameConfigurations", om.valueToTree(this.getDomainNameConfigurations()));
            }
            if (this.getMutualTlsAuthentication() != null) {
                data.set("mutualTlsAuthentication", om.valueToTree(this.getMutualTlsAuthentication()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.CfnDomainNameProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDomainNameProps.Jsii$Proxy that = (CfnDomainNameProps.Jsii$Proxy) o;

            if (!domainName.equals(that.domainName)) return false;
            if (this.domainNameConfigurations != null ? !this.domainNameConfigurations.equals(that.domainNameConfigurations) : that.domainNameConfigurations != null) return false;
            if (this.mutualTlsAuthentication != null ? !this.mutualTlsAuthentication.equals(that.mutualTlsAuthentication) : that.mutualTlsAuthentication != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.domainName.hashCode();
            result = 31 * result + (this.domainNameConfigurations != null ? this.domainNameConfigurations.hashCode() : 0);
            result = 31 * result + (this.mutualTlsAuthentication != null ? this.mutualTlsAuthentication.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
