package software.amazon.awscdk.services.appmesh;

/**
 * Provides the Service Discovery method a VirtualNode uses.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * Mesh mesh;
 * Vpc vpc = new Vpc(this, "vpc");
 * PrivateDnsNamespace namespace = PrivateDnsNamespace.Builder.create(this, "test-namespace")
 *         .vpc(vpc)
 *         .name("domain.local")
 *         .build();
 * Service service = namespace.createService("Svc");
 * VirtualNode node = mesh.addVirtualNode("virtual-node", VirtualNodeBaseProps.builder()
 *         .serviceDiscovery(ServiceDiscovery.cloudMap(service))
 *         .listeners(List.of(VirtualNodeListener.http(HttpVirtualNodeListenerOptions.builder()
 *                 .port(8081)
 *                 .healthCheck(HealthCheck.http(HttpHealthCheckOptions.builder()
 *                         .healthyThreshold(3)
 *                         .interval(Duration.seconds(5)) // minimum
 *                         .path("/health-check-path")
 *                         .timeout(Duration.seconds(2)) // minimum
 *                         .unhealthyThreshold(2)
 *                         .build()))
 *                 .build())))
 *         .accessLog(AccessLog.fromFilePath("/dev/stdout"))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:52.747Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.ServiceDiscovery")
public abstract class ServiceDiscovery extends software.amazon.jsii.JsiiObject {

    protected ServiceDiscovery(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ServiceDiscovery(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected ServiceDiscovery() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Returns Cloud Map based service discovery.
     * <p>
     * @param service The AWS Cloud Map Service to use for service discovery. This parameter is required.
     * @param instanceAttributes A string map that contains attributes with values that you can use to filter instances by any custom attribute that you specified when you registered the instance.
     * @param ipPreference No IP preference is applied to the Virtual Node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.ServiceDiscovery cloudMap(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.IService service, final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> instanceAttributes, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.IpPreference ipPreference) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.ServiceDiscovery.class, "cloudMap", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.ServiceDiscovery.class), new Object[] { java.util.Objects.requireNonNull(service, "service is required"), instanceAttributes, ipPreference });
    }

    /**
     * Returns Cloud Map based service discovery.
     * <p>
     * @param service The AWS Cloud Map Service to use for service discovery. This parameter is required.
     * @param instanceAttributes A string map that contains attributes with values that you can use to filter instances by any custom attribute that you specified when you registered the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.ServiceDiscovery cloudMap(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.IService service, final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> instanceAttributes) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.ServiceDiscovery.class, "cloudMap", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.ServiceDiscovery.class), new Object[] { java.util.Objects.requireNonNull(service, "service is required"), instanceAttributes });
    }

    /**
     * Returns Cloud Map based service discovery.
     * <p>
     * @param service The AWS Cloud Map Service to use for service discovery. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.ServiceDiscovery cloudMap(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.IService service) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.ServiceDiscovery.class, "cloudMap", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.ServiceDiscovery.class), new Object[] { java.util.Objects.requireNonNull(service, "service is required") });
    }

    /**
     * Returns DNS based service discovery.
     * <p>
     * @param hostname This parameter is required.
     * @param responseType Specifies the DNS response type for the virtual node.
     * @param ipPreference No IP preference is applied to the Virtual Node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.ServiceDiscovery dns(final @org.jetbrains.annotations.NotNull java.lang.String hostname, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.DnsResponseType responseType, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.IpPreference ipPreference) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.ServiceDiscovery.class, "dns", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.ServiceDiscovery.class), new Object[] { java.util.Objects.requireNonNull(hostname, "hostname is required"), responseType, ipPreference });
    }

    /**
     * Returns DNS based service discovery.
     * <p>
     * @param hostname This parameter is required.
     * @param responseType Specifies the DNS response type for the virtual node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.ServiceDiscovery dns(final @org.jetbrains.annotations.NotNull java.lang.String hostname, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.DnsResponseType responseType) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.ServiceDiscovery.class, "dns", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.ServiceDiscovery.class), new Object[] { java.util.Objects.requireNonNull(hostname, "hostname is required"), responseType });
    }

    /**
     * Returns DNS based service discovery.
     * <p>
     * @param hostname This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.ServiceDiscovery dns(final @org.jetbrains.annotations.NotNull java.lang.String hostname) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.ServiceDiscovery.class, "dns", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.ServiceDiscovery.class), new Object[] { java.util.Objects.requireNonNull(hostname, "hostname is required") });
    }

    /**
     * Binds the current object when adding Service Discovery to a VirtualNode.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.ServiceDiscoveryConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.appmesh.ServiceDiscovery {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Binds the current object when adding Service Discovery to a VirtualNode.
         * <p>
         * @param scope This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.ServiceDiscoveryConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.ServiceDiscoveryConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
        }
    }
}
