package software.amazon.awscdk.services.appsync;

/**
 * A CloudFormation `AWS::AppSync::ApiCache`.
 * <p>
 * The <code>AWS::AppSync::ApiCache</code> resource represents the input of a <code>CreateApiCache</code> operation.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appsync.*;
 * CfnApiCache cfnApiCache = CfnApiCache.Builder.create(this, "MyCfnApiCache")
 *         .apiCachingBehavior("apiCachingBehavior")
 *         .apiId("apiId")
 *         .ttl(123)
 *         .type("type")
 *         // the properties below are optional
 *         .atRestEncryptionEnabled(false)
 *         .transitEncryptionEnabled(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:52.825Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnApiCache")
public class CfnApiCache extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnApiCache(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApiCache(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.appsync.CfnApiCache.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::AppSync::ApiCache`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnApiCache(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.CfnApiCacheProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Caching behavior.
     * <p>
     * <ul>
     * <li><em>FULL_REQUEST_CACHING</em> : All requests are fully cached.</li>
     * <li><em>PER_RESOLVER_CACHING</em> : Individual resolvers that you specify are cached.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getApiCachingBehavior() {
        return software.amazon.jsii.Kernel.get(this, "apiCachingBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Caching behavior.
     * <p>
     * <ul>
     * <li><em>FULL_REQUEST_CACHING</em> : All requests are fully cached.</li>
     * <li><em>PER_RESOLVER_CACHING</em> : Individual resolvers that you specify are cached.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApiCachingBehavior(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "apiCachingBehavior", java.util.Objects.requireNonNull(value, "apiCachingBehavior is required"));
    }

    /**
     * The GraphQL API ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getApiId() {
        return software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The GraphQL API ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApiId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "apiId", java.util.Objects.requireNonNull(value, "apiId is required"));
    }

    /**
     * TTL in seconds for cache entries.
     * <p>
     * Valid values are 1–3,600 seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getTtl() {
        return software.amazon.jsii.Kernel.get(this, "ttl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * TTL in seconds for cache entries.
     * <p>
     * Valid values are 1–3,600 seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTtl(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "ttl", java.util.Objects.requireNonNull(value, "ttl is required"));
    }

    /**
     * The cache instance type. Valid values are.
     * <p>
     * <ul>
     * <li><code>SMALL</code></li>
     * <li><code>MEDIUM</code></li>
     * <li><code>LARGE</code></li>
     * <li><code>XLARGE</code></li>
     * <li><code>LARGE_2X</code></li>
     * <li><code>LARGE_4X</code></li>
     * <li><code>LARGE_8X</code> (not available in all regions)</li>
     * <li><code>LARGE_12X</code></li>
     * </ul>
     * <p>
     * Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.
     * <p>
     * The following legacy instance types are available, but their use is discouraged:
     * <p>
     * <ul>
     * <li><em>T2_SMALL</em> : A t2.small instance type.</li>
     * <li><em>T2_MEDIUM</em> : A t2.medium instance type.</li>
     * <li><em>R4_LARGE</em> : A r4.large instance type.</li>
     * <li><em>R4_XLARGE</em> : A r4.xlarge instance type.</li>
     * <li><em>R4_2XLARGE</em> : A r4.2xlarge instance type.</li>
     * <li><em>R4_4XLARGE</em> : A r4.4xlarge instance type.</li>
     * <li><em>R4_8XLARGE</em> : A r4.8xlarge instance type.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The cache instance type. Valid values are.
     * <p>
     * <ul>
     * <li><code>SMALL</code></li>
     * <li><code>MEDIUM</code></li>
     * <li><code>LARGE</code></li>
     * <li><code>XLARGE</code></li>
     * <li><code>LARGE_2X</code></li>
     * <li><code>LARGE_4X</code></li>
     * <li><code>LARGE_8X</code> (not available in all regions)</li>
     * <li><code>LARGE_12X</code></li>
     * </ul>
     * <p>
     * Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.
     * <p>
     * The following legacy instance types are available, but their use is discouraged:
     * <p>
     * <ul>
     * <li><em>T2_SMALL</em> : A t2.small instance type.</li>
     * <li><em>T2_MEDIUM</em> : A t2.medium instance type.</li>
     * <li><em>R4_LARGE</em> : A r4.large instance type.</li>
     * <li><em>R4_XLARGE</em> : A r4.xlarge instance type.</li>
     * <li><em>R4_2XLARGE</em> : A r4.2xlarge instance type.</li>
     * <li><em>R4_4XLARGE</em> : A r4.4xlarge instance type.</li>
     * <li><em>R4_8XLARGE</em> : A r4.8xlarge instance type.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * At-rest encryption flag for cache.
     * <p>
     * You cannot update this setting after creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAtRestEncryptionEnabled() {
        return software.amazon.jsii.Kernel.get(this, "atRestEncryptionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * At-rest encryption flag for cache.
     * <p>
     * You cannot update this setting after creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAtRestEncryptionEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "atRestEncryptionEnabled", value);
    }

    /**
     * At-rest encryption flag for cache.
     * <p>
     * You cannot update this setting after creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAtRestEncryptionEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "atRestEncryptionEnabled", value);
    }

    /**
     * Transit encryption flag when connecting to cache.
     * <p>
     * You cannot update this setting after creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTransitEncryptionEnabled() {
        return software.amazon.jsii.Kernel.get(this, "transitEncryptionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Transit encryption flag when connecting to cache.
     * <p>
     * You cannot update this setting after creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTransitEncryptionEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "transitEncryptionEnabled", value);
    }

    /**
     * Transit encryption flag when connecting to cache.
     * <p>
     * You cannot update this setting after creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTransitEncryptionEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "transitEncryptionEnabled", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appsync.CfnApiCache}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appsync.CfnApiCache> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appsync.CfnApiCacheProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appsync.CfnApiCacheProps.Builder();
        }

        /**
         * Caching behavior.
         * <p>
         * <ul>
         * <li><em>FULL_REQUEST_CACHING</em> : All requests are fully cached.</li>
         * <li><em>PER_RESOLVER_CACHING</em> : Individual resolvers that you specify are cached.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param apiCachingBehavior Caching behavior. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiCachingBehavior(final java.lang.String apiCachingBehavior) {
            this.props.apiCachingBehavior(apiCachingBehavior);
            return this;
        }

        /**
         * The GraphQL API ID.
         * <p>
         * @return {@code this}
         * @param apiId The GraphQL API ID. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiId(final java.lang.String apiId) {
            this.props.apiId(apiId);
            return this;
        }

        /**
         * TTL in seconds for cache entries.
         * <p>
         * Valid values are 1–3,600 seconds.
         * <p>
         * @return {@code this}
         * @param ttl TTL in seconds for cache entries. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ttl(final java.lang.Number ttl) {
            this.props.ttl(ttl);
            return this;
        }

        /**
         * The cache instance type. Valid values are.
         * <p>
         * <ul>
         * <li><code>SMALL</code></li>
         * <li><code>MEDIUM</code></li>
         * <li><code>LARGE</code></li>
         * <li><code>XLARGE</code></li>
         * <li><code>LARGE_2X</code></li>
         * <li><code>LARGE_4X</code></li>
         * <li><code>LARGE_8X</code> (not available in all regions)</li>
         * <li><code>LARGE_12X</code></li>
         * </ul>
         * <p>
         * Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.
         * <p>
         * The following legacy instance types are available, but their use is discouraged:
         * <p>
         * <ul>
         * <li><em>T2_SMALL</em> : A t2.small instance type.</li>
         * <li><em>T2_MEDIUM</em> : A t2.medium instance type.</li>
         * <li><em>R4_LARGE</em> : A r4.large instance type.</li>
         * <li><em>R4_XLARGE</em> : A r4.xlarge instance type.</li>
         * <li><em>R4_2XLARGE</em> : A r4.2xlarge instance type.</li>
         * <li><em>R4_4XLARGE</em> : A r4.4xlarge instance type.</li>
         * <li><em>R4_8XLARGE</em> : A r4.8xlarge instance type.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param type The cache instance type. Valid values are. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * At-rest encryption flag for cache.
         * <p>
         * You cannot update this setting after creation.
         * <p>
         * @return {@code this}
         * @param atRestEncryptionEnabled At-rest encryption flag for cache. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder atRestEncryptionEnabled(final java.lang.Boolean atRestEncryptionEnabled) {
            this.props.atRestEncryptionEnabled(atRestEncryptionEnabled);
            return this;
        }
        /**
         * At-rest encryption flag for cache.
         * <p>
         * You cannot update this setting after creation.
         * <p>
         * @return {@code this}
         * @param atRestEncryptionEnabled At-rest encryption flag for cache. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder atRestEncryptionEnabled(final software.amazon.awscdk.IResolvable atRestEncryptionEnabled) {
            this.props.atRestEncryptionEnabled(atRestEncryptionEnabled);
            return this;
        }

        /**
         * Transit encryption flag when connecting to cache.
         * <p>
         * You cannot update this setting after creation.
         * <p>
         * @return {@code this}
         * @param transitEncryptionEnabled Transit encryption flag when connecting to cache. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitEncryptionEnabled(final java.lang.Boolean transitEncryptionEnabled) {
            this.props.transitEncryptionEnabled(transitEncryptionEnabled);
            return this;
        }
        /**
         * Transit encryption flag when connecting to cache.
         * <p>
         * You cannot update this setting after creation.
         * <p>
         * @return {@code this}
         * @param transitEncryptionEnabled Transit encryption flag when connecting to cache. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitEncryptionEnabled(final software.amazon.awscdk.IResolvable transitEncryptionEnabled) {
            this.props.transitEncryptionEnabled(transitEncryptionEnabled);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.appsync.CfnApiCache}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appsync.CfnApiCache build() {
            return new software.amazon.awscdk.services.appsync.CfnApiCache(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
