package software.amazon.awscdk.services.backup;

/**
 * A CloudFormation `AWS::Backup::Framework`.
 * <p>
 * Creates a framework with one or more controls. A framework is a collection of controls that you can use to evaluate your backup practices. By using pre-built customizable controls to define your policies, you can evaluate whether your backup practices comply with your policies and which resources are not yet in compliance.
 * <p>
 * For a sample AWS CloudFormation template, see the <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/bam-cfn-integration.html#bam-cfn-frameworks-template">AWS Backup Developer Guide</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.backup.*;
 * Object controlScope;
 * CfnFramework cfnFramework = CfnFramework.Builder.create(this, "MyCfnFramework")
 *         .frameworkControls(List.of(FrameworkControlProperty.builder()
 *                 .controlName("controlName")
 *                 // the properties below are optional
 *                 .controlInputParameters(List.of(ControlInputParameterProperty.builder()
 *                         .parameterName("parameterName")
 *                         .parameterValue("parameterValue")
 *                         .build()))
 *                 .controlScope(controlScope)
 *                 .build()))
 *         // the properties below are optional
 *         .frameworkDescription("frameworkDescription")
 *         .frameworkName("frameworkName")
 *         .frameworkTags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:53.029Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.CfnFramework")
public class CfnFramework extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnFramework(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFramework(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.backup.CfnFramework.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Backup::Framework`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFramework(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.CfnFrameworkProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The UTC time when you created your framework.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * Depolyment status refers to whether your framework has completed deployment.
     * <p>
     * This status is usually <code>Completed</code> , but might also be <code>Create in progress</code> or another status. For a list of statuses, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/viewing-frameworks.html">Framework compliance status</a> in the <em>Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDeploymentStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrDeploymentStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of your framework.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrFrameworkArn() {
        return software.amazon.jsii.Kernel.get(this, "attrFrameworkArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Framework status refers to whether you have turned on resource tracking for all of your resources.
     * <p>
     * This status is <code>Active</code> when you turn on all resources the framework evaluates. For other statuses and steps to correct them, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/viewing-frameworks.html">Framework compliance status</a> in the <em>Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrFrameworkStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrFrameworkStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Contains detailed information about all of the controls of a framework.
     * <p>
     * Each framework must contain at least one control.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getFrameworkControls() {
        return software.amazon.jsii.Kernel.get(this, "frameworkControls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains detailed information about all of the controls of a framework.
     * <p>
     * Each framework must contain at least one control.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFrameworkControls(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "frameworkControls", java.util.Objects.requireNonNull(value, "frameworkControls is required"));
    }

    /**
     * Contains detailed information about all of the controls of a framework.
     * <p>
     * Each framework must contain at least one control.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFrameworkControls(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.backup.CfnFramework.FrameworkControlProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.backup.CfnFramework.FrameworkControlProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "frameworkControls", java.util.Objects.requireNonNull(value, "frameworkControls is required"));
    }

    /**
     * An optional description of the framework with a maximum 1,024 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getFrameworkDescription() {
        return software.amazon.jsii.Kernel.get(this, "frameworkDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An optional description of the framework with a maximum 1,024 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFrameworkDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "frameworkDescription", value);
    }

    /**
     * The unique name of a framework.
     * <p>
     * This name is between 1 and 256 characters, starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getFrameworkName() {
        return software.amazon.jsii.Kernel.get(this, "frameworkName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique name of a framework.
     * <p>
     * This name is between 1 and 256 characters, starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFrameworkName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "frameworkName", value);
    }

    /**
     * A list of tags with which to tag your framework.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFrameworkTags() {
        return software.amazon.jsii.Kernel.get(this, "frameworkTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of tags with which to tag your framework.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFrameworkTags(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "frameworkTags", value);
    }

    /**
     * A list of tags with which to tag your framework.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFrameworkTags(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.CfnTag)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.CfnTag; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "frameworkTags", value);
    }
    /**
     * A list of parameters for a control.
     * <p>
     * A control can have zero, one, or more than one parameter. An example of a control with two parameters is: "backup plan frequency is at least <code>daily</code> and the retention period is at least <code>1 year</code> ". The first parameter is <code>daily</code> . The second parameter is <code>1 year</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.backup.*;
     * ControlInputParameterProperty controlInputParameterProperty = ControlInputParameterProperty.builder()
     *         .parameterName("parameterName")
     *         .parameterValue("parameterValue")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.CfnFramework.ControlInputParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(ControlInputParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ControlInputParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of a parameter, for example, `BackupPlanFrequency` .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getParameterName();

        /**
         * The value of parameter, for example, `hourly` .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getParameterValue();

        /**
         * @return a {@link Builder} of {@link ControlInputParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ControlInputParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ControlInputParameterProperty> {
            java.lang.String parameterName;
            java.lang.String parameterValue;

            /**
             * Sets the value of {@link ControlInputParameterProperty#getParameterName}
             * @param parameterName The name of a parameter, for example, `BackupPlanFrequency` . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameterName(java.lang.String parameterName) {
                this.parameterName = parameterName;
                return this;
            }

            /**
             * Sets the value of {@link ControlInputParameterProperty#getParameterValue}
             * @param parameterValue The value of parameter, for example, `hourly` . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameterValue(java.lang.String parameterValue) {
                this.parameterValue = parameterValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ControlInputParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ControlInputParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ControlInputParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ControlInputParameterProperty {
            private final java.lang.String parameterName;
            private final java.lang.String parameterValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.parameterName = software.amazon.jsii.Kernel.get(this, "parameterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parameterValue = software.amazon.jsii.Kernel.get(this, "parameterValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.parameterName = java.util.Objects.requireNonNull(builder.parameterName, "parameterName is required");
                this.parameterValue = java.util.Objects.requireNonNull(builder.parameterValue, "parameterValue is required");
            }

            @Override
            public final java.lang.String getParameterName() {
                return this.parameterName;
            }

            @Override
            public final java.lang.String getParameterValue() {
                return this.parameterValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("parameterName", om.valueToTree(this.getParameterName()));
                data.set("parameterValue", om.valueToTree(this.getParameterValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_backup.CfnFramework.ControlInputParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ControlInputParameterProperty.Jsii$Proxy that = (ControlInputParameterProperty.Jsii$Proxy) o;

                if (!parameterName.equals(that.parameterName)) return false;
                return this.parameterValue.equals(that.parameterValue);
            }

            @Override
            public final int hashCode() {
                int result = this.parameterName.hashCode();
                result = 31 * result + (this.parameterValue.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains detailed information about all of the controls of a framework.
     * <p>
     * Each framework must contain at least one control.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.backup.*;
     * Object controlScope;
     * FrameworkControlProperty frameworkControlProperty = FrameworkControlProperty.builder()
     *         .controlName("controlName")
     *         // the properties below are optional
     *         .controlInputParameters(List.of(ControlInputParameterProperty.builder()
     *                 .parameterName("parameterName")
     *                 .parameterValue("parameterValue")
     *                 .build()))
     *         .controlScope(controlScope)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.CfnFramework.FrameworkControlProperty")
    @software.amazon.jsii.Jsii.Proxy(FrameworkControlProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FrameworkControlProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of a control.
         * <p>
         * This name is between 1 and 256 characters.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getControlName();

        /**
         * A list of `ParameterName` and `ParameterValue` pairs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getControlInputParameters() {
            return null;
        }

        /**
         * The scope of a control.
         * <p>
         * The control scope defines what the control will evaluate. Three examples of control scopes are: a specific backup plan, all backup plans with a specific tag, or all backup plans. For more information, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ControlScope.html"><code>ControlScope</code> .</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getControlScope() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FrameworkControlProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FrameworkControlProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FrameworkControlProperty> {
            java.lang.String controlName;
            java.lang.Object controlInputParameters;
            java.lang.Object controlScope;

            /**
             * Sets the value of {@link FrameworkControlProperty#getControlName}
             * @param controlName The name of a control. This parameter is required.
             *                    This name is between 1 and 256 characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder controlName(java.lang.String controlName) {
                this.controlName = controlName;
                return this;
            }

            /**
             * Sets the value of {@link FrameworkControlProperty#getControlInputParameters}
             * @param controlInputParameters A list of `ParameterName` and `ParameterValue` pairs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder controlInputParameters(software.amazon.awscdk.IResolvable controlInputParameters) {
                this.controlInputParameters = controlInputParameters;
                return this;
            }

            /**
             * Sets the value of {@link FrameworkControlProperty#getControlInputParameters}
             * @param controlInputParameters A list of `ParameterName` and `ParameterValue` pairs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder controlInputParameters(java.util.List<? extends java.lang.Object> controlInputParameters) {
                this.controlInputParameters = controlInputParameters;
                return this;
            }

            /**
             * Sets the value of {@link FrameworkControlProperty#getControlScope}
             * @param controlScope The scope of a control.
             *                     The control scope defines what the control will evaluate. Three examples of control scopes are: a specific backup plan, all backup plans with a specific tag, or all backup plans. For more information, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ControlScope.html"><code>ControlScope</code> .</a>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder controlScope(java.lang.Object controlScope) {
                this.controlScope = controlScope;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FrameworkControlProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FrameworkControlProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FrameworkControlProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FrameworkControlProperty {
            private final java.lang.String controlName;
            private final java.lang.Object controlInputParameters;
            private final java.lang.Object controlScope;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.controlName = software.amazon.jsii.Kernel.get(this, "controlName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.controlInputParameters = software.amazon.jsii.Kernel.get(this, "controlInputParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.controlScope = software.amazon.jsii.Kernel.get(this, "controlScope", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.controlName = java.util.Objects.requireNonNull(builder.controlName, "controlName is required");
                this.controlInputParameters = builder.controlInputParameters;
                this.controlScope = builder.controlScope;
            }

            @Override
            public final java.lang.String getControlName() {
                return this.controlName;
            }

            @Override
            public final java.lang.Object getControlInputParameters() {
                return this.controlInputParameters;
            }

            @Override
            public final java.lang.Object getControlScope() {
                return this.controlScope;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("controlName", om.valueToTree(this.getControlName()));
                if (this.getControlInputParameters() != null) {
                    data.set("controlInputParameters", om.valueToTree(this.getControlInputParameters()));
                }
                if (this.getControlScope() != null) {
                    data.set("controlScope", om.valueToTree(this.getControlScope()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_backup.CfnFramework.FrameworkControlProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FrameworkControlProperty.Jsii$Proxy that = (FrameworkControlProperty.Jsii$Proxy) o;

                if (!controlName.equals(that.controlName)) return false;
                if (this.controlInputParameters != null ? !this.controlInputParameters.equals(that.controlInputParameters) : that.controlInputParameters != null) return false;
                return this.controlScope != null ? this.controlScope.equals(that.controlScope) : that.controlScope == null;
            }

            @Override
            public final int hashCode() {
                int result = this.controlName.hashCode();
                result = 31 * result + (this.controlInputParameters != null ? this.controlInputParameters.hashCode() : 0);
                result = 31 * result + (this.controlScope != null ? this.controlScope.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.backup.CfnFramework}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.backup.CfnFramework> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.backup.CfnFrameworkProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.backup.CfnFrameworkProps.Builder();
        }

        /**
         * Contains detailed information about all of the controls of a framework.
         * <p>
         * Each framework must contain at least one control.
         * <p>
         * @return {@code this}
         * @param frameworkControls Contains detailed information about all of the controls of a framework. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder frameworkControls(final software.amazon.awscdk.IResolvable frameworkControls) {
            this.props.frameworkControls(frameworkControls);
            return this;
        }
        /**
         * Contains detailed information about all of the controls of a framework.
         * <p>
         * Each framework must contain at least one control.
         * <p>
         * @return {@code this}
         * @param frameworkControls Contains detailed information about all of the controls of a framework. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder frameworkControls(final java.util.List<? extends java.lang.Object> frameworkControls) {
            this.props.frameworkControls(frameworkControls);
            return this;
        }

        /**
         * An optional description of the framework with a maximum 1,024 characters.
         * <p>
         * @return {@code this}
         * @param frameworkDescription An optional description of the framework with a maximum 1,024 characters. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder frameworkDescription(final java.lang.String frameworkDescription) {
            this.props.frameworkDescription(frameworkDescription);
            return this;
        }

        /**
         * The unique name of a framework.
         * <p>
         * This name is between 1 and 256 characters, starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
         * <p>
         * @return {@code this}
         * @param frameworkName The unique name of a framework. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder frameworkName(final java.lang.String frameworkName) {
            this.props.frameworkName(frameworkName);
            return this;
        }

        /**
         * A list of tags with which to tag your framework.
         * <p>
         * @return {@code this}
         * @param frameworkTags A list of tags with which to tag your framework. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder frameworkTags(final software.amazon.awscdk.IResolvable frameworkTags) {
            this.props.frameworkTags(frameworkTags);
            return this;
        }
        /**
         * A list of tags with which to tag your framework.
         * <p>
         * @return {@code this}
         * @param frameworkTags A list of tags with which to tag your framework. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder frameworkTags(final java.util.List<? extends java.lang.Object> frameworkTags) {
            this.props.frameworkTags(frameworkTags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.backup.CfnFramework}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.backup.CfnFramework build() {
            return new software.amazon.awscdk.services.backup.CfnFramework(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
