package software.amazon.awscdk.services.cloudfront.origins;

/**
 * Properties for an Origin backed by an S3 website-configured bucket, load balancer, or custom HTTP server.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.cloudfront.*;
 * import software.amazon.awscdk.services.cloudfront.origins.*;
 * HttpOriginProps httpOriginProps = HttpOriginProps.builder()
 *         .connectionAttempts(123)
 *         .connectionTimeout(Duration.minutes(30))
 *         .customHeaders(Map.of(
 *                 "customHeadersKey", "customHeaders"))
 *         .httpPort(123)
 *         .httpsPort(123)
 *         .keepaliveTimeout(Duration.minutes(30))
 *         .originPath("originPath")
 *         .originShieldRegion("originShieldRegion")
 *         .originSslProtocols(List.of(OriginSslPolicy.SSL_V3))
 *         .protocolPolicy(OriginProtocolPolicy.HTTP_ONLY)
 *         .readTimeout(Duration.minutes(30))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:53.328Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront_origins.HttpOriginProps")
@software.amazon.jsii.Jsii.Proxy(HttpOriginProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HttpOriginProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.cloudfront.OriginProps {

    /**
     * The HTTP port that CloudFront uses to connect to the origin.
     * <p>
     * Default: 80
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getHttpPort() {
        return null;
    }

    /**
     * The HTTPS port that CloudFront uses to connect to the origin.
     * <p>
     * Default: 443
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getHttpsPort() {
        return null;
    }

    /**
     * Specifies how long, in seconds, CloudFront persists its connection to the origin.
     * <p>
     * The valid range is from 1 to 180 seconds, inclusive.
     * <p>
     * Note that values over 60 seconds are possible only after a limit increase request for the origin response timeout quota
     * has been approved in the target account; otherwise, values over 60 seconds will produce an error at deploy time.
     * <p>
     * Default: Duration.seconds(5)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getKeepaliveTimeout() {
        return null;
    }

    /**
     * The SSL versions to use when interacting with the origin.
     * <p>
     * Default: OriginSslPolicy.TLS_V1_2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cloudfront.OriginSslPolicy> getOriginSslProtocols() {
        return null;
    }

    /**
     * Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin.
     * <p>
     * Default: OriginProtocolPolicy.HTTPS_ONLY
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.OriginProtocolPolicy getProtocolPolicy() {
        return null;
    }

    /**
     * Specifies how long, in seconds, CloudFront waits for a response from the origin, also known as the origin response timeout.
     * <p>
     * The valid range is from 1 to 180 seconds, inclusive.
     * <p>
     * Note that values over 60 seconds are possible only after a limit increase request for the origin response timeout quota
     * has been approved in the target account; otherwise, values over 60 seconds will produce an error at deploy time.
     * <p>
     * Default: Duration.seconds(30)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getReadTimeout() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HttpOriginProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HttpOriginProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HttpOriginProps> {
        java.lang.Number httpPort;
        java.lang.Number httpsPort;
        software.amazon.awscdk.Duration keepaliveTimeout;
        java.util.List<software.amazon.awscdk.services.cloudfront.OriginSslPolicy> originSslProtocols;
        software.amazon.awscdk.services.cloudfront.OriginProtocolPolicy protocolPolicy;
        software.amazon.awscdk.Duration readTimeout;
        java.lang.String originPath;
        java.lang.Number connectionAttempts;
        software.amazon.awscdk.Duration connectionTimeout;
        java.util.Map<java.lang.String, java.lang.String> customHeaders;
        java.lang.String originShieldRegion;

        /**
         * Sets the value of {@link HttpOriginProps#getHttpPort}
         * @param httpPort The HTTP port that CloudFront uses to connect to the origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpPort(java.lang.Number httpPort) {
            this.httpPort = httpPort;
            return this;
        }

        /**
         * Sets the value of {@link HttpOriginProps#getHttpsPort}
         * @param httpsPort The HTTPS port that CloudFront uses to connect to the origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpsPort(java.lang.Number httpsPort) {
            this.httpsPort = httpsPort;
            return this;
        }

        /**
         * Sets the value of {@link HttpOriginProps#getKeepaliveTimeout}
         * @param keepaliveTimeout Specifies how long, in seconds, CloudFront persists its connection to the origin.
         *                         The valid range is from 1 to 180 seconds, inclusive.
         *                         <p>
         *                         Note that values over 60 seconds are possible only after a limit increase request for the origin response timeout quota
         *                         has been approved in the target account; otherwise, values over 60 seconds will produce an error at deploy time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keepaliveTimeout(software.amazon.awscdk.Duration keepaliveTimeout) {
            this.keepaliveTimeout = keepaliveTimeout;
            return this;
        }

        /**
         * Sets the value of {@link HttpOriginProps#getOriginSslProtocols}
         * @param originSslProtocols The SSL versions to use when interacting with the origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder originSslProtocols(java.util.List<? extends software.amazon.awscdk.services.cloudfront.OriginSslPolicy> originSslProtocols) {
            this.originSslProtocols = (java.util.List<software.amazon.awscdk.services.cloudfront.OriginSslPolicy>)originSslProtocols;
            return this;
        }

        /**
         * Sets the value of {@link HttpOriginProps#getProtocolPolicy}
         * @param protocolPolicy Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocolPolicy(software.amazon.awscdk.services.cloudfront.OriginProtocolPolicy protocolPolicy) {
            this.protocolPolicy = protocolPolicy;
            return this;
        }

        /**
         * Sets the value of {@link HttpOriginProps#getReadTimeout}
         * @param readTimeout Specifies how long, in seconds, CloudFront waits for a response from the origin, also known as the origin response timeout.
         *                    The valid range is from 1 to 180 seconds, inclusive.
         *                    <p>
         *                    Note that values over 60 seconds are possible only after a limit increase request for the origin response timeout quota
         *                    has been approved in the target account; otherwise, values over 60 seconds will produce an error at deploy time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readTimeout(software.amazon.awscdk.Duration readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        /**
         * Sets the value of {@link HttpOriginProps#getOriginPath}
         * @param originPath An optional path that CloudFront appends to the origin domain name when CloudFront requests content from the origin.
         *                   Must begin, but not end, with '/' (e.g., '/production/images').
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originPath(java.lang.String originPath) {
            this.originPath = originPath;
            return this;
        }

        /**
         * Sets the value of {@link HttpOriginProps#getConnectionAttempts}
         * @param connectionAttempts The number of times that CloudFront attempts to connect to the origin;.
         *                           valid values are 1, 2, or 3 attempts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionAttempts(java.lang.Number connectionAttempts) {
            this.connectionAttempts = connectionAttempts;
            return this;
        }

        /**
         * Sets the value of {@link HttpOriginProps#getConnectionTimeout}
         * @param connectionTimeout The number of seconds that CloudFront waits when trying to establish a connection to the origin.
         *                          Valid values are 1-10 seconds, inclusive.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionTimeout(software.amazon.awscdk.Duration connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        /**
         * Sets the value of {@link HttpOriginProps#getCustomHeaders}
         * @param customHeaders A list of HTTP header names and values that CloudFront adds to requests it sends to the origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customHeaders(java.util.Map<java.lang.String, java.lang.String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        /**
         * Sets the value of {@link HttpOriginProps#getOriginShieldRegion}
         * @param originShieldRegion When you enable Origin Shield in the AWS Region that has the lowest latency to your origin, you can get better network performance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originShieldRegion(java.lang.String originShieldRegion) {
            this.originShieldRegion = originShieldRegion;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HttpOriginProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HttpOriginProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HttpOriginProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpOriginProps {
        private final java.lang.Number httpPort;
        private final java.lang.Number httpsPort;
        private final software.amazon.awscdk.Duration keepaliveTimeout;
        private final java.util.List<software.amazon.awscdk.services.cloudfront.OriginSslPolicy> originSslProtocols;
        private final software.amazon.awscdk.services.cloudfront.OriginProtocolPolicy protocolPolicy;
        private final software.amazon.awscdk.Duration readTimeout;
        private final java.lang.String originPath;
        private final java.lang.Number connectionAttempts;
        private final software.amazon.awscdk.Duration connectionTimeout;
        private final java.util.Map<java.lang.String, java.lang.String> customHeaders;
        private final java.lang.String originShieldRegion;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.httpPort = software.amazon.jsii.Kernel.get(this, "httpPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.httpsPort = software.amazon.jsii.Kernel.get(this, "httpsPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.keepaliveTimeout = software.amazon.jsii.Kernel.get(this, "keepaliveTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.originSslProtocols = software.amazon.jsii.Kernel.get(this, "originSslProtocols", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.OriginSslPolicy.class)));
            this.protocolPolicy = software.amazon.jsii.Kernel.get(this, "protocolPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.OriginProtocolPolicy.class));
            this.readTimeout = software.amazon.jsii.Kernel.get(this, "readTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.originPath = software.amazon.jsii.Kernel.get(this, "originPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connectionAttempts = software.amazon.jsii.Kernel.get(this, "connectionAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.connectionTimeout = software.amazon.jsii.Kernel.get(this, "connectionTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.customHeaders = software.amazon.jsii.Kernel.get(this, "customHeaders", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.originShieldRegion = software.amazon.jsii.Kernel.get(this, "originShieldRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.httpPort = builder.httpPort;
            this.httpsPort = builder.httpsPort;
            this.keepaliveTimeout = builder.keepaliveTimeout;
            this.originSslProtocols = (java.util.List<software.amazon.awscdk.services.cloudfront.OriginSslPolicy>)builder.originSslProtocols;
            this.protocolPolicy = builder.protocolPolicy;
            this.readTimeout = builder.readTimeout;
            this.originPath = builder.originPath;
            this.connectionAttempts = builder.connectionAttempts;
            this.connectionTimeout = builder.connectionTimeout;
            this.customHeaders = builder.customHeaders;
            this.originShieldRegion = builder.originShieldRegion;
        }

        @Override
        public final java.lang.Number getHttpPort() {
            return this.httpPort;
        }

        @Override
        public final java.lang.Number getHttpsPort() {
            return this.httpsPort;
        }

        @Override
        public final software.amazon.awscdk.Duration getKeepaliveTimeout() {
            return this.keepaliveTimeout;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudfront.OriginSslPolicy> getOriginSslProtocols() {
            return this.originSslProtocols;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.OriginProtocolPolicy getProtocolPolicy() {
            return this.protocolPolicy;
        }

        @Override
        public final software.amazon.awscdk.Duration getReadTimeout() {
            return this.readTimeout;
        }

        @Override
        public final java.lang.String getOriginPath() {
            return this.originPath;
        }

        @Override
        public final java.lang.Number getConnectionAttempts() {
            return this.connectionAttempts;
        }

        @Override
        public final software.amazon.awscdk.Duration getConnectionTimeout() {
            return this.connectionTimeout;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getCustomHeaders() {
            return this.customHeaders;
        }

        @Override
        public final java.lang.String getOriginShieldRegion() {
            return this.originShieldRegion;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getHttpPort() != null) {
                data.set("httpPort", om.valueToTree(this.getHttpPort()));
            }
            if (this.getHttpsPort() != null) {
                data.set("httpsPort", om.valueToTree(this.getHttpsPort()));
            }
            if (this.getKeepaliveTimeout() != null) {
                data.set("keepaliveTimeout", om.valueToTree(this.getKeepaliveTimeout()));
            }
            if (this.getOriginSslProtocols() != null) {
                data.set("originSslProtocols", om.valueToTree(this.getOriginSslProtocols()));
            }
            if (this.getProtocolPolicy() != null) {
                data.set("protocolPolicy", om.valueToTree(this.getProtocolPolicy()));
            }
            if (this.getReadTimeout() != null) {
                data.set("readTimeout", om.valueToTree(this.getReadTimeout()));
            }
            if (this.getOriginPath() != null) {
                data.set("originPath", om.valueToTree(this.getOriginPath()));
            }
            if (this.getConnectionAttempts() != null) {
                data.set("connectionAttempts", om.valueToTree(this.getConnectionAttempts()));
            }
            if (this.getConnectionTimeout() != null) {
                data.set("connectionTimeout", om.valueToTree(this.getConnectionTimeout()));
            }
            if (this.getCustomHeaders() != null) {
                data.set("customHeaders", om.valueToTree(this.getCustomHeaders()));
            }
            if (this.getOriginShieldRegion() != null) {
                data.set("originShieldRegion", om.valueToTree(this.getOriginShieldRegion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront_origins.HttpOriginProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HttpOriginProps.Jsii$Proxy that = (HttpOriginProps.Jsii$Proxy) o;

            if (this.httpPort != null ? !this.httpPort.equals(that.httpPort) : that.httpPort != null) return false;
            if (this.httpsPort != null ? !this.httpsPort.equals(that.httpsPort) : that.httpsPort != null) return false;
            if (this.keepaliveTimeout != null ? !this.keepaliveTimeout.equals(that.keepaliveTimeout) : that.keepaliveTimeout != null) return false;
            if (this.originSslProtocols != null ? !this.originSslProtocols.equals(that.originSslProtocols) : that.originSslProtocols != null) return false;
            if (this.protocolPolicy != null ? !this.protocolPolicy.equals(that.protocolPolicy) : that.protocolPolicy != null) return false;
            if (this.readTimeout != null ? !this.readTimeout.equals(that.readTimeout) : that.readTimeout != null) return false;
            if (this.originPath != null ? !this.originPath.equals(that.originPath) : that.originPath != null) return false;
            if (this.connectionAttempts != null ? !this.connectionAttempts.equals(that.connectionAttempts) : that.connectionAttempts != null) return false;
            if (this.connectionTimeout != null ? !this.connectionTimeout.equals(that.connectionTimeout) : that.connectionTimeout != null) return false;
            if (this.customHeaders != null ? !this.customHeaders.equals(that.customHeaders) : that.customHeaders != null) return false;
            return this.originShieldRegion != null ? this.originShieldRegion.equals(that.originShieldRegion) : that.originShieldRegion == null;
        }

        @Override
        public final int hashCode() {
            int result = this.httpPort != null ? this.httpPort.hashCode() : 0;
            result = 31 * result + (this.httpsPort != null ? this.httpsPort.hashCode() : 0);
            result = 31 * result + (this.keepaliveTimeout != null ? this.keepaliveTimeout.hashCode() : 0);
            result = 31 * result + (this.originSslProtocols != null ? this.originSslProtocols.hashCode() : 0);
            result = 31 * result + (this.protocolPolicy != null ? this.protocolPolicy.hashCode() : 0);
            result = 31 * result + (this.readTimeout != null ? this.readTimeout.hashCode() : 0);
            result = 31 * result + (this.originPath != null ? this.originPath.hashCode() : 0);
            result = 31 * result + (this.connectionAttempts != null ? this.connectionAttempts.hashCode() : 0);
            result = 31 * result + (this.connectionTimeout != null ? this.connectionTimeout.hashCode() : 0);
            result = 31 * result + (this.customHeaders != null ? this.customHeaders.hashCode() : 0);
            result = 31 * result + (this.originShieldRegion != null ? this.originShieldRegion.hashCode() : 0);
            return result;
        }
    }
}
