package software.amazon.awscdk.services.cloudfront.origins;

/**
 * An Origin for an API Gateway REST API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * RestApi api;
 * Distribution.Builder.create(this, "Distribution")
 *         .defaultBehavior(BehaviorOptions.builder().origin(new RestApiOrigin(api)).build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:53.331Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront_origins.RestApiOrigin")
public class RestApiOrigin extends software.amazon.awscdk.services.cloudfront.OriginBase {

    protected RestApiOrigin(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RestApiOrigin(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param restApi This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public RestApiOrigin(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.RestApi restApi, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.origins.RestApiOriginProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(restApi, "restApi is required"), props });
    }

    /**
     * @param restApi This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public RestApiOrigin(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.RestApi restApi) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(restApi, "restApi is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.CfnDistribution.CustomOriginConfigProperty renderCustomOriginConfig() {
        return software.amazon.jsii.Kernel.call(this, "renderCustomOriginConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CfnDistribution.CustomOriginConfigProperty.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudfront.origins.RestApiOrigin}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.origins.RestApiOrigin> {
        /**
         * @return a new instance of {@link Builder}.
         * @param restApi This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.apigateway.RestApi restApi) {
            return new Builder(restApi);
        }

        private final software.amazon.awscdk.services.apigateway.RestApi restApi;
        private software.amazon.awscdk.services.cloudfront.origins.RestApiOriginProps.Builder props;

        private Builder(final software.amazon.awscdk.services.apigateway.RestApi restApi) {
            this.restApi = restApi;
        }

        /**
         * The number of times that CloudFront attempts to connect to the origin;
         * <p>
         * valid values are 1, 2, or 3 attempts.
         * <p>
         * Default: 3
         * <p>
         * @return {@code this}
         * @param connectionAttempts The number of times that CloudFront attempts to connect to the origin;. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionAttempts(final java.lang.Number connectionAttempts) {
            this.props().connectionAttempts(connectionAttempts);
            return this;
        }

        /**
         * The number of seconds that CloudFront waits when trying to establish a connection to the origin.
         * <p>
         * Valid values are 1-10 seconds, inclusive.
         * <p>
         * Default: Duration.seconds(10)
         * <p>
         * @return {@code this}
         * @param connectionTimeout The number of seconds that CloudFront waits when trying to establish a connection to the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionTimeout(final software.amazon.awscdk.Duration connectionTimeout) {
            this.props().connectionTimeout(connectionTimeout);
            return this;
        }

        /**
         * A list of HTTP header names and values that CloudFront adds to requests it sends to the origin.
         * <p>
         * Default: {}
         * <p>
         * @return {@code this}
         * @param customHeaders A list of HTTP header names and values that CloudFront adds to requests it sends to the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customHeaders(final java.util.Map<java.lang.String, java.lang.String> customHeaders) {
            this.props().customHeaders(customHeaders);
            return this;
        }

        /**
         * When you enable Origin Shield in the AWS Region that has the lowest latency to your origin, you can get better network performance.
         * <p>
         * Default: - origin shield not enabled
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html">https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html</a>
         * @param originShieldRegion When you enable Origin Shield in the AWS Region that has the lowest latency to your origin, you can get better network performance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originShieldRegion(final java.lang.String originShieldRegion) {
            this.props().originShieldRegion(originShieldRegion);
            return this;
        }

        /**
         * Specifies how long, in seconds, CloudFront persists its connection to the origin.
         * <p>
         * The valid range is from 1 to 180 seconds, inclusive.
         * <p>
         * Note that values over 60 seconds are possible only after a limit increase request for the origin response timeout quota
         * has been approved in the target account; otherwise, values over 60 seconds will produce an error at deploy time.
         * <p>
         * Default: Duration.seconds(5)
         * <p>
         * @return {@code this}
         * @param keepaliveTimeout Specifies how long, in seconds, CloudFront persists its connection to the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keepaliveTimeout(final software.amazon.awscdk.Duration keepaliveTimeout) {
            this.props().keepaliveTimeout(keepaliveTimeout);
            return this;
        }

        /**
         * Specifies how long, in seconds, CloudFront waits for a response from the origin, also known as the origin response timeout.
         * <p>
         * The valid range is from 1 to 180 seconds, inclusive.
         * <p>
         * Note that values over 60 seconds are possible only after a limit increase request for the origin response timeout quota
         * has been approved in the target account; otherwise, values over 60 seconds will produce an error at deploy time.
         * <p>
         * Default: Duration.seconds(30)
         * <p>
         * @return {@code this}
         * @param readTimeout Specifies how long, in seconds, CloudFront waits for a response from the origin, also known as the origin response timeout. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readTimeout(final software.amazon.awscdk.Duration readTimeout) {
            this.props().readTimeout(readTimeout);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cloudfront.origins.RestApiOrigin}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudfront.origins.RestApiOrigin build() {
            return new software.amazon.awscdk.services.cloudfront.origins.RestApiOrigin(
                this.restApi,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.cloudfront.origins.RestApiOriginProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.cloudfront.origins.RestApiOriginProps.Builder();
            }
            return this.props;
        }
    }
}
