package software.amazon.awscdk.services.cloudtrail;

/**
 * A CloudFormation `AWS::CloudTrail::Trail`.
 * <p>
 * Creates a trail that specifies the settings for delivery of log data to an Amazon S3 bucket.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudtrail.*;
 * CfnTrail cfnTrail = CfnTrail.Builder.create(this, "MyCfnTrail")
 *         .isLogging(false)
 *         .s3BucketName("s3BucketName")
 *         // the properties below are optional
 *         .cloudWatchLogsLogGroupArn("cloudWatchLogsLogGroupArn")
 *         .cloudWatchLogsRoleArn("cloudWatchLogsRoleArn")
 *         .enableLogFileValidation(false)
 *         .eventSelectors(List.of(EventSelectorProperty.builder()
 *                 .dataResources(List.of(DataResourceProperty.builder()
 *                         .type("type")
 *                         // the properties below are optional
 *                         .values(List.of("values"))
 *                         .build()))
 *                 .excludeManagementEventSources(List.of("excludeManagementEventSources"))
 *                 .includeManagementEvents(false)
 *                 .readWriteType("readWriteType")
 *                 .build()))
 *         .includeGlobalServiceEvents(false)
 *         .insightSelectors(List.of(InsightSelectorProperty.builder()
 *                 .insightType("insightType")
 *                 .build()))
 *         .isMultiRegionTrail(false)
 *         .isOrganizationTrail(false)
 *         .kmsKeyId("kmsKeyId")
 *         .s3KeyPrefix("s3KeyPrefix")
 *         .snsTopicName("snsTopicName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .trailName("trailName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:53.337Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudtrail.CfnTrail")
public class CfnTrail extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnTrail(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTrail(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudtrail.CfnTrail.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::CloudTrail::Trail`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTrail(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudtrail.CfnTrailProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * `Ref` returns the ARN of the CloudTrail trail, such as `arn:aws:cloudtrail:us-east-2:123456789012:trail/myCloudTrail` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `Ref` returns the ARN of the Amazon SNS topic that's associated with the CloudTrail trail, such as `arn:aws:sns:us-east-2:123456789012:mySNSTopic` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSnsTopicArn() {
        return software.amazon.jsii.Kernel.get(this, "attrSnsTopicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A custom set of tags (key-value pairs) for this trail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Whether the CloudTrail trail is currently logging AWS API calls.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getIsLogging() {
        return software.amazon.jsii.Kernel.get(this, "isLogging", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Whether the CloudTrail trail is currently logging AWS API calls.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIsLogging(final @org.jetbrains.annotations.NotNull java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "isLogging", java.util.Objects.requireNonNull(value, "isLogging is required"));
    }

    /**
     * Whether the CloudTrail trail is currently logging AWS API calls.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIsLogging(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "isLogging", java.util.Objects.requireNonNull(value, "isLogging is required"));
    }

    /**
     * Specifies the name of the Amazon S3 bucket designated for publishing log files.
     * <p>
     * See <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getS3BucketName() {
        return software.amazon.jsii.Kernel.get(this, "s3BucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the name of the Amazon S3 bucket designated for publishing log files.
     * <p>
     * See <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3BucketName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "s3BucketName", java.util.Objects.requireNonNull(value, "s3BucketName is required"));
    }

    /**
     * Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs are delivered.
     * <p>
     * Not required unless you specify <code>CloudWatchLogsRoleArn</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCloudWatchLogsLogGroupArn() {
        return software.amazon.jsii.Kernel.get(this, "cloudWatchLogsLogGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs are delivered.
     * <p>
     * Not required unless you specify <code>CloudWatchLogsRoleArn</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCloudWatchLogsLogGroupArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "cloudWatchLogsLogGroupArn", value);
    }

    /**
     * Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCloudWatchLogsRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "cloudWatchLogsRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCloudWatchLogsRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "cloudWatchLogsRoleArn", value);
    }

    /**
     * Specifies whether log file validation is enabled. The default is false.
     * <p>
     * <blockquote>
     * <p>
     * When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail does not create digest files for log files that were delivered during a period in which log file integrity validation was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnableLogFileValidation() {
        return software.amazon.jsii.Kernel.get(this, "enableLogFileValidation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether log file validation is enabled. The default is false.
     * <p>
     * <blockquote>
     * <p>
     * When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail does not create digest files for log files that were delivered during a period in which log file integrity validation was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableLogFileValidation(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enableLogFileValidation", value);
    }

    /**
     * Specifies whether log file validation is enabled. The default is false.
     * <p>
     * <blockquote>
     * <p>
     * When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail does not create digest files for log files that were delivered during a period in which log file integrity validation was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableLogFileValidation(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enableLogFileValidation", value);
    }

    /**
     * Use event selectors to further specify the management and data event settings for your trail.
     * <p>
     * By default, trails created without specific event selectors will be configured to log all read and write management events, and no data events. When an event occurs in your account, CloudTrail evaluates the event selector for all trails. For each trail, if the event matches any event selector, the trail processes and logs the event. If the event doesn't match any event selector, the trail doesn't log the event.
     * <p>
     * You can configure up to five event selectors for a trail.
     * <p>
     * You cannot apply both event selectors and advanced event selectors to a trail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEventSelectors() {
        return software.amazon.jsii.Kernel.get(this, "eventSelectors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Use event selectors to further specify the management and data event settings for your trail.
     * <p>
     * By default, trails created without specific event selectors will be configured to log all read and write management events, and no data events. When an event occurs in your account, CloudTrail evaluates the event selector for all trails. For each trail, if the event matches any event selector, the trail processes and logs the event. If the event doesn't match any event selector, the trail doesn't log the event.
     * <p>
     * You can configure up to five event selectors for a trail.
     * <p>
     * You cannot apply both event selectors and advanced event selectors to a trail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventSelectors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "eventSelectors", value);
    }

    /**
     * Use event selectors to further specify the management and data event settings for your trail.
     * <p>
     * By default, trails created without specific event selectors will be configured to log all read and write management events, and no data events. When an event occurs in your account, CloudTrail evaluates the event selector for all trails. For each trail, if the event matches any event selector, the trail processes and logs the event. If the event doesn't match any event selector, the trail doesn't log the event.
     * <p>
     * You can configure up to five event selectors for a trail.
     * <p>
     * You cannot apply both event selectors and advanced event selectors to a trail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventSelectors(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.cloudtrail.CfnTrail.EventSelectorProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.cloudtrail.CfnTrail.EventSelectorProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "eventSelectors", value);
    }

    /**
     * Specifies whether the trail is publishing events from global services such as IAM to the log files.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIncludeGlobalServiceEvents() {
        return software.amazon.jsii.Kernel.get(this, "includeGlobalServiceEvents", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether the trail is publishing events from global services such as IAM to the log files.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIncludeGlobalServiceEvents(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "includeGlobalServiceEvents", value);
    }

    /**
     * Specifies whether the trail is publishing events from global services such as IAM to the log files.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIncludeGlobalServiceEvents(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "includeGlobalServiceEvents", value);
    }

    /**
     * `AWS::CloudTrail::Trail.InsightSelectors`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInsightSelectors() {
        return software.amazon.jsii.Kernel.get(this, "insightSelectors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::CloudTrail::Trail.InsightSelectors`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInsightSelectors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "insightSelectors", value);
    }

    /**
     * `AWS::CloudTrail::Trail.InsightSelectors`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInsightSelectors(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.cloudtrail.CfnTrail.InsightSelectorProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.cloudtrail.CfnTrail.InsightSelectorProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "insightSelectors", value);
    }

    /**
     * Specifies whether the trail applies only to the current region or to all regions.
     * <p>
     * The default is false. If the trail exists only in the current region and this value is set to true, shadow trails (replications of the trail) will be created in the other regions. If the trail exists in all regions and this value is set to false, the trail will remain in the region where it was created, and its shadow trails in other regions will be deleted. As a best practice, consider using trails that log events in all regions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIsMultiRegionTrail() {
        return software.amazon.jsii.Kernel.get(this, "isMultiRegionTrail", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether the trail applies only to the current region or to all regions.
     * <p>
     * The default is false. If the trail exists only in the current region and this value is set to true, shadow trails (replications of the trail) will be created in the other regions. If the trail exists in all regions and this value is set to false, the trail will remain in the region where it was created, and its shadow trails in other regions will be deleted. As a best practice, consider using trails that log events in all regions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIsMultiRegionTrail(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "isMultiRegionTrail", value);
    }

    /**
     * Specifies whether the trail applies only to the current region or to all regions.
     * <p>
     * The default is false. If the trail exists only in the current region and this value is set to true, shadow trails (replications of the trail) will be created in the other regions. If the trail exists in all regions and this value is set to false, the trail will remain in the region where it was created, and its shadow trails in other regions will be deleted. As a best practice, consider using trails that log events in all regions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIsMultiRegionTrail(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "isMultiRegionTrail", value);
    }

    /**
     * Specifies whether the trail is applied to all accounts in an organization in AWS Organizations , or only for the current AWS account .
     * <p>
     * The default is false, and cannot be true unless the call is made on behalf of an AWS account that is the management account for an organization in AWS Organizations . If the trail is not an organization trail and this is set to <code>true</code> , the trail will be created in all AWS accounts that belong to the organization. If the trail is an organization trail and this is set to <code>false</code> , the trail will remain in the current AWS account but be deleted from all member accounts in the organization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIsOrganizationTrail() {
        return software.amazon.jsii.Kernel.get(this, "isOrganizationTrail", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether the trail is applied to all accounts in an organization in AWS Organizations , or only for the current AWS account .
     * <p>
     * The default is false, and cannot be true unless the call is made on behalf of an AWS account that is the management account for an organization in AWS Organizations . If the trail is not an organization trail and this is set to <code>true</code> , the trail will be created in all AWS accounts that belong to the organization. If the trail is an organization trail and this is set to <code>false</code> , the trail will remain in the current AWS account but be deleted from all member accounts in the organization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIsOrganizationTrail(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "isOrganizationTrail", value);
    }

    /**
     * Specifies whether the trail is applied to all accounts in an organization in AWS Organizations , or only for the current AWS account .
     * <p>
     * The default is false, and cannot be true unless the call is made on behalf of an AWS account that is the management account for an organization in AWS Organizations . If the trail is not an organization trail and this is set to <code>true</code> , the trail will be created in all AWS accounts that belong to the organization. If the trail is an organization trail and this is set to <code>false</code> , the trail will remain in the current AWS account but be deleted from all member accounts in the organization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIsOrganizationTrail(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "isOrganizationTrail", value);
    }

    /**
     * Specifies the AWS KMS key ID to use to encrypt the logs delivered by CloudTrail.
     * <p>
     * The value can be an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.
     * <p>
     * CloudTrail also supports AWS KMS multi-Region keys. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * Examples:
     * <p>
     * <ul>
     * <li>alias/MyAliasName</li>
     * <li>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</li>
     * <li>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</li>
     * <li>12345678-1234-1234-1234-123456789012</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the AWS KMS key ID to use to encrypt the logs delivered by CloudTrail.
     * <p>
     * The value can be an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.
     * <p>
     * CloudTrail also supports AWS KMS multi-Region keys. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * Examples:
     * <p>
     * <ul>
     * <li>alias/MyAliasName</li>
     * <li>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</li>
     * <li>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</li>
     * <li>12345678-1234-1234-1234-123456789012</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyId", value);
    }

    /**
     * Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a> . The maximum length is 200 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getS3KeyPrefix() {
        return software.amazon.jsii.Kernel.get(this, "s3KeyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a> . The maximum length is 200 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3KeyPrefix(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "s3KeyPrefix", value);
    }

    /**
     * Specifies the name of the Amazon SNS topic defined for notification of log file delivery.
     * <p>
     * The maximum length is 256 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSnsTopicName() {
        return software.amazon.jsii.Kernel.get(this, "snsTopicName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the name of the Amazon SNS topic defined for notification of log file delivery.
     * <p>
     * The maximum length is 256 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnsTopicName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "snsTopicName", value);
    }

    /**
     * Specifies the name of the trail. The name must meet the following requirements:.
     * <p>
     * <ul>
     * <li>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</li>
     * <li>Start with a letter or number, and end with a letter or number</li>
     * <li>Be between 3 and 128 characters</li>
     * <li>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</li>
     * <li>Not be in IP address format (for example, 192.168.5.4)</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTrailName() {
        return software.amazon.jsii.Kernel.get(this, "trailName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the name of the trail. The name must meet the following requirements:.
     * <p>
     * <ul>
     * <li>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</li>
     * <li>Start with a letter or number, and end with a letter or number</li>
     * <li>Be between 3 and 128 characters</li>
     * <li>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</li>
     * <li>Not be in IP address format (for example, 192.168.5.4)</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTrailName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "trailName", value);
    }
    /**
     * The Amazon S3 buckets, AWS Lambda functions, or Amazon DynamoDB tables that you specify in event selectors in your AWS CloudFormation template for your trail to log data events.
     * <p>
     * Data events provide information about the resource operations performed on or within a resource itself. These are also known as data plane operations. You can specify up to 250 data resources for a trail. Currently, advanced event selectors for data events are not supported in AWS CloudFormation templates.
     * <p>
     * <blockquote>
     * <p>
     * The total number of allowed data resources is 250. This number can be distributed between 1 and 5 event selectors, but the total cannot exceed 250 across all selectors.
     * <p>
     * If you are using advanced event selectors, the maximum total number of values for all conditions, across all advanced event selectors for the trail, is 500.
     * <p>
     * </blockquote>
     * <p>
     * The following example demonstrates how logging works when you configure logging of all data events for an S3 bucket named <code>bucket-1</code> . In this example, the CloudTrail user specified an empty prefix, and the option to log both <code>Read</code> and <code>Write</code> data events.
     * <p>
     * <ul>
     * <li>A user uploads an image file to <code>bucket-1</code> .</li>
     * <li>The <code>PutObject</code> API operation is an Amazon S3 object-level API. It is recorded as a data event in CloudTrail. Because the CloudTrail user specified an S3 bucket with an empty prefix, events that occur on any object in that bucket are logged. The trail processes and logs the event.</li>
     * <li>A user uploads an object to an Amazon S3 bucket named <code>arn:aws:s3:::bucket-2</code> .</li>
     * <li>The <code>PutObject</code> API operation occurred for an object in an S3 bucket that the CloudTrail user didn't specify for the trail. The trail doesn’t log the event.</li>
     * </ul>
     * <p>
     * The following example demonstrates how logging works when you configure logging of AWS Lambda data events for a Lambda function named <em>MyLambdaFunction</em> , but not for all Lambda functions.
     * <p>
     * <ul>
     * <li>A user runs a script that includes a call to the <em>MyLambdaFunction</em> function and the <em>MyOtherLambdaFunction</em> function.</li>
     * <li>The <code>Invoke</code> API operation on <em>MyLambdaFunction</em> is an Lambda API. It is recorded as a data event in CloudTrail. Because the CloudTrail user specified logging data events for <em>MyLambdaFunction</em> , any invocations of that function are logged. The trail processes and logs the event.</li>
     * <li>The <code>Invoke</code> API operation on <em>MyOtherLambdaFunction</em> is an Lambda API. Because the CloudTrail user did not specify logging data events for all Lambda functions, the <code>Invoke</code> operation for <em>MyOtherLambdaFunction</em> does not match the function specified for the trail. The trail doesn’t log the event.</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudtrail.*;
     * DataResourceProperty dataResourceProperty = DataResourceProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudtrail.CfnTrail.DataResourceProperty")
    @software.amazon.jsii.Jsii.Proxy(DataResourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataResourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The resource type in which you want to log data events.
         * <p>
         * You can specify the following <em>basic</em> event selector resource types:
         * <p>
         * <ul>
         * <li><code>AWS::S3::Object</code></li>
         * <li><code>AWS::Lambda::Function</code></li>
         * <li><code>AWS::DynamoDB::Table</code></li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * An array of Amazon Resource Name (ARN) strings or partial ARN strings for the specified objects.
         * <p>
         * <ul>
         * <li>To log data events for all objects in all S3 buckets in your AWS account , specify the prefix as <code>arn:aws:s3</code> .</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * This also enables logging of data event activity performed by any user or role in your AWS account , even if that activity is performed on a bucket that belongs to another AWS account .
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li>To log data events for all objects in an S3 bucket, specify the bucket and an empty object prefix such as <code>arn:aws:s3:::bucket-1/</code> . The trail logs data events for all objects in this S3 bucket.</li>
         * <li>To log data events for specific objects, specify the S3 bucket and object prefix such as <code>arn:aws:s3:::bucket-1/example-images</code> . The trail logs data events for objects in this S3 bucket that match the prefix.</li>
         * <li>To log data events for all Lambda functions in your AWS account , specify the prefix as <code>arn:aws:lambda</code> .</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * This also enables logging of <code>Invoke</code> activity performed by any user or role in your AWS account , even if that activity is performed on a function that belongs to another AWS account .
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li>To log data events for a specific Lambda function, specify the function ARN.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * Lambda function ARNs are exact. For example, if you specify a function ARN <em>arn:aws:lambda:us-west-2:111111111111:function:helloworld</em> , data events will only be logged for <em>arn:aws:lambda:us-west-2:111111111111:function:helloworld</em> . They will not be logged for <em>arn:aws:lambda:us-west-2:111111111111:function:helloworld2</em> .
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li>To log data events for all DynamoDB tables in your AWS account , specify the prefix as <code>arn:aws:dynamodb</code> .</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataResourceProperty> {
            java.lang.String type;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link DataResourceProperty#getType}
             * @param type The resource type in which you want to log data events. This parameter is required.
             *             You can specify the following <em>basic</em> event selector resource types:
             *             <p>
             *             <ul>
             *             <li><code>AWS::S3::Object</code></li>
             *             <li><code>AWS::Lambda::Function</code></li>
             *             <li><code>AWS::DynamoDB::Table</code></li>
             *             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link DataResourceProperty#getValues}
             * @param values An array of Amazon Resource Name (ARN) strings or partial ARN strings for the specified objects.
             *               <ul>
             *               <li>To log data events for all objects in all S3 buckets in your AWS account , specify the prefix as <code>arn:aws:s3</code> .</li>
             *               </ul>
             *               <p>
             *               <blockquote>
             *               <p>
             *               This also enables logging of data event activity performed by any user or role in your AWS account , even if that activity is performed on a bucket that belongs to another AWS account .
             *               <p>
             *               </blockquote>
             *               <p>
             *               <ul>
             *               <li>To log data events for all objects in an S3 bucket, specify the bucket and an empty object prefix such as <code>arn:aws:s3:::bucket-1/</code> . The trail logs data events for all objects in this S3 bucket.</li>
             *               <li>To log data events for specific objects, specify the S3 bucket and object prefix such as <code>arn:aws:s3:::bucket-1/example-images</code> . The trail logs data events for objects in this S3 bucket that match the prefix.</li>
             *               <li>To log data events for all Lambda functions in your AWS account , specify the prefix as <code>arn:aws:lambda</code> .</li>
             *               </ul>
             *               <p>
             *               <blockquote>
             *               <p>
             *               This also enables logging of <code>Invoke</code> activity performed by any user or role in your AWS account , even if that activity is performed on a function that belongs to another AWS account .
             *               <p>
             *               </blockquote>
             *               <p>
             *               <ul>
             *               <li>To log data events for a specific Lambda function, specify the function ARN.</li>
             *               </ul>
             *               <p>
             *               <blockquote>
             *               <p>
             *               Lambda function ARNs are exact. For example, if you specify a function ARN <em>arn:aws:lambda:us-west-2:111111111111:function:helloworld</em> , data events will only be logged for <em>arn:aws:lambda:us-west-2:111111111111:function:helloworld</em> . They will not be logged for <em>arn:aws:lambda:us-west-2:111111111111:function:helloworld2</em> .
             *               <p>
             *               </blockquote>
             *               <p>
             *               <ul>
             *               <li>To log data events for all DynamoDB tables in your AWS account , specify the prefix as <code>arn:aws:dynamodb</code> .</li>
             *               </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataResourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataResourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataResourceProperty {
            private final java.lang.String type;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.values = builder.values;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getValues() != null) {
                    data.set("values", om.valueToTree(this.getValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudtrail.CfnTrail.DataResourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataResourceProperty.Jsii$Proxy that = (DataResourceProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.values != null ? this.values.equals(that.values) : that.values == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Use event selectors to further specify the management and data event settings for your trail.
     * <p>
     * By default, trails created without specific event selectors will be configured to log all read and write management events, and no data events. When an event occurs in your account, CloudTrail evaluates the event selector for all trails. For each trail, if the event matches any event selector, the trail processes and logs the event. If the event doesn't match any event selector, the trail doesn't log the event.
     * <p>
     * You can configure up to five event selectors for a trail.
     * <p>
     * You cannot apply both event selectors and advanced event selectors to a trail.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudtrail.*;
     * EventSelectorProperty eventSelectorProperty = EventSelectorProperty.builder()
     *         .dataResources(List.of(DataResourceProperty.builder()
     *                 .type("type")
     *                 // the properties below are optional
     *                 .values(List.of("values"))
     *                 .build()))
     *         .excludeManagementEventSources(List.of("excludeManagementEventSources"))
     *         .includeManagementEvents(false)
     *         .readWriteType("readWriteType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudtrail.CfnTrail.EventSelectorProperty")
    @software.amazon.jsii.Jsii.Proxy(EventSelectorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventSelectorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * In AWS CloudFormation , CloudTrail supports data event logging for Amazon S3 objects, Amazon DynamoDB tables, and AWS Lambda functions.
         * <p>
         * Currently, advanced event selectors for data events are not supported in AWS CloudFormation templates. You can specify up to 250 resources for an individual event selector, but the total number of data resources cannot exceed 250 across all event selectors in a trail. This limit does not apply if you configure resource logging for all data events.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html#logging-data-events">Data Events</a> and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html">Limits in AWS CloudTrail</a> in the <em>AWS CloudTrail User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataResources() {
            return null;
        }

        /**
         * An optional list of service event sources from which you do not want management events to be logged on your trail.
         * <p>
         * In this release, the list can be empty (disables the filter), or it can filter out AWS Key Management Service or Amazon RDS Data API events by containing <code>kms.amazonaws.com</code> or <code>rdsdata.amazonaws.com</code> . By default, <code>ExcludeManagementEventSources</code> is empty, and AWS KMS and Amazon RDS Data API events are logged to your trail. You can exclude management event sources only in regions that support the event source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludeManagementEventSources() {
            return null;
        }

        /**
         * Specify if you want your event selector to include management events for your trail.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html#logging-management-events">Management Events</a> in the <em>AWS CloudTrail User Guide</em> .
         * <p>
         * By default, the value is <code>true</code> .
         * <p>
         * The first copy of management events is free. You are charged for additional copies of management events that you are logging on any subsequent trail in the same region. For more information about CloudTrail pricing, see <a href="https://docs.aws.amazon.com/cloudtrail/pricing/">AWS CloudTrail Pricing</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeManagementEvents() {
            return null;
        }

        /**
         * Specify if you want your trail to log read-only events, write-only events, or all.
         * <p>
         * For example, the EC2 <code>GetConsoleOutput</code> is a read-only API operation and <code>RunInstances</code> is a write-only API operation.
         * <p>
         * By default, the value is <code>All</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReadWriteType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EventSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventSelectorProperty> {
            java.lang.Object dataResources;
            java.util.List<java.lang.String> excludeManagementEventSources;
            java.lang.Object includeManagementEvents;
            java.lang.String readWriteType;

            /**
             * Sets the value of {@link EventSelectorProperty#getDataResources}
             * @param dataResources In AWS CloudFormation , CloudTrail supports data event logging for Amazon S3 objects, Amazon DynamoDB tables, and AWS Lambda functions.
             *                      Currently, advanced event selectors for data events are not supported in AWS CloudFormation templates. You can specify up to 250 resources for an individual event selector, but the total number of data resources cannot exceed 250 across all event selectors in a trail. This limit does not apply if you configure resource logging for all data events.
             *                      <p>
             *                      For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html#logging-data-events">Data Events</a> and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html">Limits in AWS CloudTrail</a> in the <em>AWS CloudTrail User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataResources(software.amazon.awscdk.IResolvable dataResources) {
                this.dataResources = dataResources;
                return this;
            }

            /**
             * Sets the value of {@link EventSelectorProperty#getDataResources}
             * @param dataResources In AWS CloudFormation , CloudTrail supports data event logging for Amazon S3 objects, Amazon DynamoDB tables, and AWS Lambda functions.
             *                      Currently, advanced event selectors for data events are not supported in AWS CloudFormation templates. You can specify up to 250 resources for an individual event selector, but the total number of data resources cannot exceed 250 across all event selectors in a trail. This limit does not apply if you configure resource logging for all data events.
             *                      <p>
             *                      For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html#logging-data-events">Data Events</a> and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html">Limits in AWS CloudTrail</a> in the <em>AWS CloudTrail User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataResources(java.util.List<? extends java.lang.Object> dataResources) {
                this.dataResources = dataResources;
                return this;
            }

            /**
             * Sets the value of {@link EventSelectorProperty#getExcludeManagementEventSources}
             * @param excludeManagementEventSources An optional list of service event sources from which you do not want management events to be logged on your trail.
             *                                      In this release, the list can be empty (disables the filter), or it can filter out AWS Key Management Service or Amazon RDS Data API events by containing <code>kms.amazonaws.com</code> or <code>rdsdata.amazonaws.com</code> . By default, <code>ExcludeManagementEventSources</code> is empty, and AWS KMS and Amazon RDS Data API events are logged to your trail. You can exclude management event sources only in regions that support the event source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeManagementEventSources(java.util.List<java.lang.String> excludeManagementEventSources) {
                this.excludeManagementEventSources = excludeManagementEventSources;
                return this;
            }

            /**
             * Sets the value of {@link EventSelectorProperty#getIncludeManagementEvents}
             * @param includeManagementEvents Specify if you want your event selector to include management events for your trail.
             *                                For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html#logging-management-events">Management Events</a> in the <em>AWS CloudTrail User Guide</em> .
             *                                <p>
             *                                By default, the value is <code>true</code> .
             *                                <p>
             *                                The first copy of management events is free. You are charged for additional copies of management events that you are logging on any subsequent trail in the same region. For more information about CloudTrail pricing, see <a href="https://docs.aws.amazon.com/cloudtrail/pricing/">AWS CloudTrail Pricing</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeManagementEvents(java.lang.Boolean includeManagementEvents) {
                this.includeManagementEvents = includeManagementEvents;
                return this;
            }

            /**
             * Sets the value of {@link EventSelectorProperty#getIncludeManagementEvents}
             * @param includeManagementEvents Specify if you want your event selector to include management events for your trail.
             *                                For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html#logging-management-events">Management Events</a> in the <em>AWS CloudTrail User Guide</em> .
             *                                <p>
             *                                By default, the value is <code>true</code> .
             *                                <p>
             *                                The first copy of management events is free. You are charged for additional copies of management events that you are logging on any subsequent trail in the same region. For more information about CloudTrail pricing, see <a href="https://docs.aws.amazon.com/cloudtrail/pricing/">AWS CloudTrail Pricing</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeManagementEvents(software.amazon.awscdk.IResolvable includeManagementEvents) {
                this.includeManagementEvents = includeManagementEvents;
                return this;
            }

            /**
             * Sets the value of {@link EventSelectorProperty#getReadWriteType}
             * @param readWriteType Specify if you want your trail to log read-only events, write-only events, or all.
             *                      For example, the EC2 <code>GetConsoleOutput</code> is a read-only API operation and <code>RunInstances</code> is a write-only API operation.
             *                      <p>
             *                      By default, the value is <code>All</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readWriteType(java.lang.String readWriteType) {
                this.readWriteType = readWriteType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventSelectorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventSelectorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventSelectorProperty {
            private final java.lang.Object dataResources;
            private final java.util.List<java.lang.String> excludeManagementEventSources;
            private final java.lang.Object includeManagementEvents;
            private final java.lang.String readWriteType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataResources = software.amazon.jsii.Kernel.get(this, "dataResources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.excludeManagementEventSources = software.amazon.jsii.Kernel.get(this, "excludeManagementEventSources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.includeManagementEvents = software.amazon.jsii.Kernel.get(this, "includeManagementEvents", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.readWriteType = software.amazon.jsii.Kernel.get(this, "readWriteType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataResources = builder.dataResources;
                this.excludeManagementEventSources = builder.excludeManagementEventSources;
                this.includeManagementEvents = builder.includeManagementEvents;
                this.readWriteType = builder.readWriteType;
            }

            @Override
            public final java.lang.Object getDataResources() {
                return this.dataResources;
            }

            @Override
            public final java.util.List<java.lang.String> getExcludeManagementEventSources() {
                return this.excludeManagementEventSources;
            }

            @Override
            public final java.lang.Object getIncludeManagementEvents() {
                return this.includeManagementEvents;
            }

            @Override
            public final java.lang.String getReadWriteType() {
                return this.readWriteType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDataResources() != null) {
                    data.set("dataResources", om.valueToTree(this.getDataResources()));
                }
                if (this.getExcludeManagementEventSources() != null) {
                    data.set("excludeManagementEventSources", om.valueToTree(this.getExcludeManagementEventSources()));
                }
                if (this.getIncludeManagementEvents() != null) {
                    data.set("includeManagementEvents", om.valueToTree(this.getIncludeManagementEvents()));
                }
                if (this.getReadWriteType() != null) {
                    data.set("readWriteType", om.valueToTree(this.getReadWriteType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudtrail.CfnTrail.EventSelectorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventSelectorProperty.Jsii$Proxy that = (EventSelectorProperty.Jsii$Proxy) o;

                if (this.dataResources != null ? !this.dataResources.equals(that.dataResources) : that.dataResources != null) return false;
                if (this.excludeManagementEventSources != null ? !this.excludeManagementEventSources.equals(that.excludeManagementEventSources) : that.excludeManagementEventSources != null) return false;
                if (this.includeManagementEvents != null ? !this.includeManagementEvents.equals(that.includeManagementEvents) : that.includeManagementEvents != null) return false;
                return this.readWriteType != null ? this.readWriteType.equals(that.readWriteType) : that.readWriteType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataResources != null ? this.dataResources.hashCode() : 0;
                result = 31 * result + (this.excludeManagementEventSources != null ? this.excludeManagementEventSources.hashCode() : 0);
                result = 31 * result + (this.includeManagementEvents != null ? this.includeManagementEvents.hashCode() : 0);
                result = 31 * result + (this.readWriteType != null ? this.readWriteType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A JSON string that contains a list of insight types that are logged on a trail.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudtrail.*;
     * InsightSelectorProperty insightSelectorProperty = InsightSelectorProperty.builder()
     *         .insightType("insightType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudtrail.CfnTrail.InsightSelectorProperty")
    @software.amazon.jsii.Jsii.Proxy(InsightSelectorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InsightSelectorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of insights to log on a trail.
         * <p>
         * <code>ApiCallRateInsight</code> and <code>ApiErrorRateInsight</code> are valid insight types.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInsightType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InsightSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InsightSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InsightSelectorProperty> {
            java.lang.String insightType;

            /**
             * Sets the value of {@link InsightSelectorProperty#getInsightType}
             * @param insightType The type of insights to log on a trail.
             *                    <code>ApiCallRateInsight</code> and <code>ApiErrorRateInsight</code> are valid insight types.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder insightType(java.lang.String insightType) {
                this.insightType = insightType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InsightSelectorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InsightSelectorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InsightSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InsightSelectorProperty {
            private final java.lang.String insightType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.insightType = software.amazon.jsii.Kernel.get(this, "insightType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.insightType = builder.insightType;
            }

            @Override
            public final java.lang.String getInsightType() {
                return this.insightType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInsightType() != null) {
                    data.set("insightType", om.valueToTree(this.getInsightType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudtrail.CfnTrail.InsightSelectorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InsightSelectorProperty.Jsii$Proxy that = (InsightSelectorProperty.Jsii$Proxy) o;

                return this.insightType != null ? this.insightType.equals(that.insightType) : that.insightType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.insightType != null ? this.insightType.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudtrail.CfnTrail}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudtrail.CfnTrail> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cloudtrail.CfnTrailProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cloudtrail.CfnTrailProps.Builder();
        }

        /**
         * Whether the CloudTrail trail is currently logging AWS API calls.
         * <p>
         * @return {@code this}
         * @param isLogging Whether the CloudTrail trail is currently logging AWS API calls. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isLogging(final java.lang.Boolean isLogging) {
            this.props.isLogging(isLogging);
            return this;
        }
        /**
         * Whether the CloudTrail trail is currently logging AWS API calls.
         * <p>
         * @return {@code this}
         * @param isLogging Whether the CloudTrail trail is currently logging AWS API calls. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isLogging(final software.amazon.awscdk.IResolvable isLogging) {
            this.props.isLogging(isLogging);
            return this;
        }

        /**
         * Specifies the name of the Amazon S3 bucket designated for publishing log files.
         * <p>
         * See <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a> .
         * <p>
         * @return {@code this}
         * @param s3BucketName Specifies the name of the Amazon S3 bucket designated for publishing log files. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3BucketName(final java.lang.String s3BucketName) {
            this.props.s3BucketName(s3BucketName);
            return this;
        }

        /**
         * Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs are delivered.
         * <p>
         * Not required unless you specify <code>CloudWatchLogsRoleArn</code> .
         * <p>
         * @return {@code this}
         * @param cloudWatchLogsLogGroupArn Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs are delivered. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchLogsLogGroupArn(final java.lang.String cloudWatchLogsLogGroupArn) {
            this.props.cloudWatchLogsLogGroupArn(cloudWatchLogsLogGroupArn);
            return this;
        }

        /**
         * Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.
         * <p>
         * @return {@code this}
         * @param cloudWatchLogsRoleArn Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchLogsRoleArn(final java.lang.String cloudWatchLogsRoleArn) {
            this.props.cloudWatchLogsRoleArn(cloudWatchLogsRoleArn);
            return this;
        }

        /**
         * Specifies whether log file validation is enabled. The default is false.
         * <p>
         * <blockquote>
         * <p>
         * When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail does not create digest files for log files that were delivered during a period in which log file integrity validation was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param enableLogFileValidation Specifies whether log file validation is enabled. The default is false. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableLogFileValidation(final java.lang.Boolean enableLogFileValidation) {
            this.props.enableLogFileValidation(enableLogFileValidation);
            return this;
        }
        /**
         * Specifies whether log file validation is enabled. The default is false.
         * <p>
         * <blockquote>
         * <p>
         * When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail does not create digest files for log files that were delivered during a period in which log file integrity validation was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param enableLogFileValidation Specifies whether log file validation is enabled. The default is false. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableLogFileValidation(final software.amazon.awscdk.IResolvable enableLogFileValidation) {
            this.props.enableLogFileValidation(enableLogFileValidation);
            return this;
        }

        /**
         * Use event selectors to further specify the management and data event settings for your trail.
         * <p>
         * By default, trails created without specific event selectors will be configured to log all read and write management events, and no data events. When an event occurs in your account, CloudTrail evaluates the event selector for all trails. For each trail, if the event matches any event selector, the trail processes and logs the event. If the event doesn't match any event selector, the trail doesn't log the event.
         * <p>
         * You can configure up to five event selectors for a trail.
         * <p>
         * You cannot apply both event selectors and advanced event selectors to a trail.
         * <p>
         * @return {@code this}
         * @param eventSelectors Use event selectors to further specify the management and data event settings for your trail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventSelectors(final software.amazon.awscdk.IResolvable eventSelectors) {
            this.props.eventSelectors(eventSelectors);
            return this;
        }
        /**
         * Use event selectors to further specify the management and data event settings for your trail.
         * <p>
         * By default, trails created without specific event selectors will be configured to log all read and write management events, and no data events. When an event occurs in your account, CloudTrail evaluates the event selector for all trails. For each trail, if the event matches any event selector, the trail processes and logs the event. If the event doesn't match any event selector, the trail doesn't log the event.
         * <p>
         * You can configure up to five event selectors for a trail.
         * <p>
         * You cannot apply both event selectors and advanced event selectors to a trail.
         * <p>
         * @return {@code this}
         * @param eventSelectors Use event selectors to further specify the management and data event settings for your trail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventSelectors(final java.util.List<? extends java.lang.Object> eventSelectors) {
            this.props.eventSelectors(eventSelectors);
            return this;
        }

        /**
         * Specifies whether the trail is publishing events from global services such as IAM to the log files.
         * <p>
         * @return {@code this}
         * @param includeGlobalServiceEvents Specifies whether the trail is publishing events from global services such as IAM to the log files. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeGlobalServiceEvents(final java.lang.Boolean includeGlobalServiceEvents) {
            this.props.includeGlobalServiceEvents(includeGlobalServiceEvents);
            return this;
        }
        /**
         * Specifies whether the trail is publishing events from global services such as IAM to the log files.
         * <p>
         * @return {@code this}
         * @param includeGlobalServiceEvents Specifies whether the trail is publishing events from global services such as IAM to the log files. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeGlobalServiceEvents(final software.amazon.awscdk.IResolvable includeGlobalServiceEvents) {
            this.props.includeGlobalServiceEvents(includeGlobalServiceEvents);
            return this;
        }

        /**
         * `AWS::CloudTrail::Trail.InsightSelectors`.
         * <p>
         * @return {@code this}
         * @param insightSelectors `AWS::CloudTrail::Trail.InsightSelectors`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insightSelectors(final software.amazon.awscdk.IResolvable insightSelectors) {
            this.props.insightSelectors(insightSelectors);
            return this;
        }
        /**
         * `AWS::CloudTrail::Trail.InsightSelectors`.
         * <p>
         * @return {@code this}
         * @param insightSelectors `AWS::CloudTrail::Trail.InsightSelectors`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insightSelectors(final java.util.List<? extends java.lang.Object> insightSelectors) {
            this.props.insightSelectors(insightSelectors);
            return this;
        }

        /**
         * Specifies whether the trail applies only to the current region or to all regions.
         * <p>
         * The default is false. If the trail exists only in the current region and this value is set to true, shadow trails (replications of the trail) will be created in the other regions. If the trail exists in all regions and this value is set to false, the trail will remain in the region where it was created, and its shadow trails in other regions will be deleted. As a best practice, consider using trails that log events in all regions.
         * <p>
         * @return {@code this}
         * @param isMultiRegionTrail Specifies whether the trail applies only to the current region or to all regions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isMultiRegionTrail(final java.lang.Boolean isMultiRegionTrail) {
            this.props.isMultiRegionTrail(isMultiRegionTrail);
            return this;
        }
        /**
         * Specifies whether the trail applies only to the current region or to all regions.
         * <p>
         * The default is false. If the trail exists only in the current region and this value is set to true, shadow trails (replications of the trail) will be created in the other regions. If the trail exists in all regions and this value is set to false, the trail will remain in the region where it was created, and its shadow trails in other regions will be deleted. As a best practice, consider using trails that log events in all regions.
         * <p>
         * @return {@code this}
         * @param isMultiRegionTrail Specifies whether the trail applies only to the current region or to all regions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isMultiRegionTrail(final software.amazon.awscdk.IResolvable isMultiRegionTrail) {
            this.props.isMultiRegionTrail(isMultiRegionTrail);
            return this;
        }

        /**
         * Specifies whether the trail is applied to all accounts in an organization in AWS Organizations , or only for the current AWS account .
         * <p>
         * The default is false, and cannot be true unless the call is made on behalf of an AWS account that is the management account for an organization in AWS Organizations . If the trail is not an organization trail and this is set to <code>true</code> , the trail will be created in all AWS accounts that belong to the organization. If the trail is an organization trail and this is set to <code>false</code> , the trail will remain in the current AWS account but be deleted from all member accounts in the organization.
         * <p>
         * @return {@code this}
         * @param isOrganizationTrail Specifies whether the trail is applied to all accounts in an organization in AWS Organizations , or only for the current AWS account . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isOrganizationTrail(final java.lang.Boolean isOrganizationTrail) {
            this.props.isOrganizationTrail(isOrganizationTrail);
            return this;
        }
        /**
         * Specifies whether the trail is applied to all accounts in an organization in AWS Organizations , or only for the current AWS account .
         * <p>
         * The default is false, and cannot be true unless the call is made on behalf of an AWS account that is the management account for an organization in AWS Organizations . If the trail is not an organization trail and this is set to <code>true</code> , the trail will be created in all AWS accounts that belong to the organization. If the trail is an organization trail and this is set to <code>false</code> , the trail will remain in the current AWS account but be deleted from all member accounts in the organization.
         * <p>
         * @return {@code this}
         * @param isOrganizationTrail Specifies whether the trail is applied to all accounts in an organization in AWS Organizations , or only for the current AWS account . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isOrganizationTrail(final software.amazon.awscdk.IResolvable isOrganizationTrail) {
            this.props.isOrganizationTrail(isOrganizationTrail);
            return this;
        }

        /**
         * Specifies the AWS KMS key ID to use to encrypt the logs delivered by CloudTrail.
         * <p>
         * The value can be an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.
         * <p>
         * CloudTrail also supports AWS KMS multi-Region keys. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * Examples:
         * <p>
         * <ul>
         * <li>alias/MyAliasName</li>
         * <li>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</li>
         * <li>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</li>
         * <li>12345678-1234-1234-1234-123456789012</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param kmsKeyId Specifies the AWS KMS key ID to use to encrypt the logs delivered by CloudTrail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(final java.lang.String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        /**
         * Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a> . The maximum length is 200 characters.
         * <p>
         * @return {@code this}
         * @param s3KeyPrefix Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3KeyPrefix(final java.lang.String s3KeyPrefix) {
            this.props.s3KeyPrefix(s3KeyPrefix);
            return this;
        }

        /**
         * Specifies the name of the Amazon SNS topic defined for notification of log file delivery.
         * <p>
         * The maximum length is 256 characters.
         * <p>
         * @return {@code this}
         * @param snsTopicName Specifies the name of the Amazon SNS topic defined for notification of log file delivery. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snsTopicName(final java.lang.String snsTopicName) {
            this.props.snsTopicName(snsTopicName);
            return this;
        }

        /**
         * A custom set of tags (key-value pairs) for this trail.
         * <p>
         * @return {@code this}
         * @param tags A custom set of tags (key-value pairs) for this trail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * Specifies the name of the trail. The name must meet the following requirements:.
         * <p>
         * <ul>
         * <li>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</li>
         * <li>Start with a letter or number, and end with a letter or number</li>
         * <li>Be between 3 and 128 characters</li>
         * <li>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</li>
         * <li>Not be in IP address format (for example, 192.168.5.4)</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param trailName Specifies the name of the trail. The name must meet the following requirements:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trailName(final java.lang.String trailName) {
            this.props.trailName(trailName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cloudtrail.CfnTrail}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudtrail.CfnTrail build() {
            return new software.amazon.awscdk.services.cloudtrail.CfnTrail(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
