package software.amazon.awscdk.services.cloudwatch;

/**
 * A CloudFormation `AWS::CloudWatch::AnomalyDetector`.
 * <p>
 * The <code>AWS::CloudWatch::AnomalyDetector</code> type specifies an anomaly detection band for a certain metric and statistic. The band represents the expected "normal" range for the metric values. Anomaly detection bands can be used for visualization of a metric's expected values, and for alarms.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudwatch.*;
 * CfnAnomalyDetector cfnAnomalyDetector = CfnAnomalyDetector.Builder.create(this, "MyCfnAnomalyDetector")
 *         .configuration(ConfigurationProperty.builder()
 *                 .excludedTimeRanges(List.of(RangeProperty.builder()
 *                         .endTime("endTime")
 *                         .startTime("startTime")
 *                         .build()))
 *                 .metricTimeZone("metricTimeZone")
 *                 .build())
 *         .dimensions(List.of(DimensionProperty.builder()
 *                 .name("name")
 *                 .value("value")
 *                 .build()))
 *         .metricMathAnomalyDetector(MetricMathAnomalyDetectorProperty.builder()
 *                 .metricDataQueries(List.of(MetricDataQueryProperty.builder()
 *                         .id("id")
 *                         // the properties below are optional
 *                         .accountId("accountId")
 *                         .expression("expression")
 *                         .label("label")
 *                         .metricStat(MetricStatProperty.builder()
 *                                 .metric(MetricProperty.builder()
 *                                         .metricName("metricName")
 *                                         .namespace("namespace")
 *                                         // the properties below are optional
 *                                         .dimensions(List.of(DimensionProperty.builder()
 *                                                 .name("name")
 *                                                 .value("value")
 *                                                 .build()))
 *                                         .build())
 *                                 .period(123)
 *                                 .stat("stat")
 *                                 // the properties below are optional
 *                                 .unit("unit")
 *                                 .build())
 *                         .period(123)
 *                         .returnData(false)
 *                         .build()))
 *                 .build())
 *         .metricName("metricName")
 *         .namespace("namespace")
 *         .singleMetricAnomalyDetector(SingleMetricAnomalyDetectorProperty.builder()
 *                 .dimensions(List.of(DimensionProperty.builder()
 *                         .name("name")
 *                         .value("value")
 *                         .build()))
 *                 .metricName("metricName")
 *                 .namespace("namespace")
 *                 .stat("stat")
 *                 .build())
 *         .stat("stat")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:53.370Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.CfnAnomalyDetector")
public class CfnAnomalyDetector extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnAnomalyDetector(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAnomalyDetector(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudwatch.CfnAnomalyDetector.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::CloudWatch::AnomalyDetector`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnAnomalyDetector(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.CfnAnomalyDetectorProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::CloudWatch::AnomalyDetector`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnAnomalyDetector(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Specifies details about how the anomaly detection model is to be trained, including time ranges to exclude when training and updating the model.
     * <p>
     * The configuration can also include the time zone to use for the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies details about how the anomaly detection model is to be trained, including time ranges to exclude when training and updating the model.
     * <p>
     * The configuration can also include the time zone to use for the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.CfnAnomalyDetector.ConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "configuration", value);
    }

    /**
     * Specifies details about how the anomaly detection model is to be trained, including time ranges to exclude when training and updating the model.
     * <p>
     * The configuration can also include the time zone to use for the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "configuration", value);
    }

    /**
     * The dimensions of the metric associated with the anomaly detection band.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDimensions() {
        return software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The dimensions of the metric associated with the anomaly detection band.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDimensions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dimensions", value);
    }

    /**
     * The dimensions of the metric associated with the anomaly detection band.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDimensions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.cloudwatch.CfnAnomalyDetector.DimensionProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.cloudwatch.CfnAnomalyDetector.DimensionProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "dimensions", value);
    }

    /**
     * The CloudWatch metric math expression for this anomaly detector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMetricMathAnomalyDetector() {
        return software.amazon.jsii.Kernel.get(this, "metricMathAnomalyDetector", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The CloudWatch metric math expression for this anomaly detector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetricMathAnomalyDetector(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.CfnAnomalyDetector.MetricMathAnomalyDetectorProperty value) {
        software.amazon.jsii.Kernel.set(this, "metricMathAnomalyDetector", value);
    }

    /**
     * The CloudWatch metric math expression for this anomaly detector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetricMathAnomalyDetector(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "metricMathAnomalyDetector", value);
    }

    /**
     * The name of the metric associated with the anomaly detection band.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMetricName() {
        return software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the metric associated with the anomaly detection band.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetricName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "metricName", value);
    }

    /**
     * The namespace of the metric associated with the anomaly detection band.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getNamespace() {
        return software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The namespace of the metric associated with the anomaly detection band.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNamespace(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "namespace", value);
    }

    /**
     * The CloudWatch metric and statistic for this anomaly detector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSingleMetricAnomalyDetector() {
        return software.amazon.jsii.Kernel.get(this, "singleMetricAnomalyDetector", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The CloudWatch metric and statistic for this anomaly detector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSingleMetricAnomalyDetector(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.CfnAnomalyDetector.SingleMetricAnomalyDetectorProperty value) {
        software.amazon.jsii.Kernel.set(this, "singleMetricAnomalyDetector", value);
    }

    /**
     * The CloudWatch metric and statistic for this anomaly detector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSingleMetricAnomalyDetector(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "singleMetricAnomalyDetector", value);
    }

    /**
     * The statistic of the metric associated with the anomaly detection band.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStat() {
        return software.amazon.jsii.Kernel.get(this, "stat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The statistic of the metric associated with the anomaly detection band.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStat(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "stat", value);
    }
    /**
     * Specifies details about how the anomaly detection model is to be trained, including time ranges to exclude when training and updating the model.
     * <p>
     * The configuration can also include the time zone to use for the metric.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudwatch.*;
     * ConfigurationProperty configurationProperty = ConfigurationProperty.builder()
     *         .excludedTimeRanges(List.of(RangeProperty.builder()
     *                 .endTime("endTime")
     *                 .startTime("startTime")
     *                 .build()))
     *         .metricTimeZone("metricTimeZone")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.CfnAnomalyDetector.ConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies an array of time ranges to exclude from use when the anomaly detection model is trained and updated.
         * <p>
         * Use this to make sure that events that could cause unusual values for the metric, such as deployments, aren't used when CloudWatch creates or updates the model.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExcludedTimeRanges() {
            return null;
        }

        /**
         * The time zone to use for the metric.
         * <p>
         * This is useful to enable the model to automatically account for daylight savings time changes if the metric is sensitive to such time changes.
         * <p>
         * To specify a time zone, use the name of the time zone as specified in the standard tz database. For more information, see <a href="https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Tz_database">tz database</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMetricTimeZone() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfigurationProperty> {
            java.lang.Object excludedTimeRanges;
            java.lang.String metricTimeZone;

            /**
             * Sets the value of {@link ConfigurationProperty#getExcludedTimeRanges}
             * @param excludedTimeRanges Specifies an array of time ranges to exclude from use when the anomaly detection model is trained and updated.
             *                           Use this to make sure that events that could cause unusual values for the metric, such as deployments, aren't used when CloudWatch creates or updates the model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludedTimeRanges(software.amazon.awscdk.IResolvable excludedTimeRanges) {
                this.excludedTimeRanges = excludedTimeRanges;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationProperty#getExcludedTimeRanges}
             * @param excludedTimeRanges Specifies an array of time ranges to exclude from use when the anomaly detection model is trained and updated.
             *                           Use this to make sure that events that could cause unusual values for the metric, such as deployments, aren't used when CloudWatch creates or updates the model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludedTimeRanges(java.util.List<? extends java.lang.Object> excludedTimeRanges) {
                this.excludedTimeRanges = excludedTimeRanges;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationProperty#getMetricTimeZone}
             * @param metricTimeZone The time zone to use for the metric.
             *                       This is useful to enable the model to automatically account for daylight savings time changes if the metric is sensitive to such time changes.
             *                       <p>
             *                       To specify a time zone, use the name of the time zone as specified in the standard tz database. For more information, see <a href="https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Tz_database">tz database</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricTimeZone(java.lang.String metricTimeZone) {
                this.metricTimeZone = metricTimeZone;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfigurationProperty {
            private final java.lang.Object excludedTimeRanges;
            private final java.lang.String metricTimeZone;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.excludedTimeRanges = software.amazon.jsii.Kernel.get(this, "excludedTimeRanges", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.metricTimeZone = software.amazon.jsii.Kernel.get(this, "metricTimeZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.excludedTimeRanges = builder.excludedTimeRanges;
                this.metricTimeZone = builder.metricTimeZone;
            }

            @Override
            public final java.lang.Object getExcludedTimeRanges() {
                return this.excludedTimeRanges;
            }

            @Override
            public final java.lang.String getMetricTimeZone() {
                return this.metricTimeZone;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExcludedTimeRanges() != null) {
                    data.set("excludedTimeRanges", om.valueToTree(this.getExcludedTimeRanges()));
                }
                if (this.getMetricTimeZone() != null) {
                    data.set("metricTimeZone", om.valueToTree(this.getMetricTimeZone()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.CfnAnomalyDetector.ConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfigurationProperty.Jsii$Proxy that = (ConfigurationProperty.Jsii$Proxy) o;

                if (this.excludedTimeRanges != null ? !this.excludedTimeRanges.equals(that.excludedTimeRanges) : that.excludedTimeRanges != null) return false;
                return this.metricTimeZone != null ? this.metricTimeZone.equals(that.metricTimeZone) : that.metricTimeZone == null;
            }

            @Override
            public final int hashCode() {
                int result = this.excludedTimeRanges != null ? this.excludedTimeRanges.hashCode() : 0;
                result = 31 * result + (this.metricTimeZone != null ? this.metricTimeZone.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A dimension is a name/value pair that is part of the identity of a metric.
     * <p>
     * Because dimensions are part of the unique identifier for a metric, whenever you add a unique name/value pair to one of your metrics, you are creating a new variation of that metric. For example, many Amazon EC2 metrics publish <code>InstanceId</code> as a dimension name, and the actual instance ID as the value for that dimension.
     * <p>
     * You can assign up to 10 dimensions to a metric.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudwatch.*;
     * DimensionProperty dimensionProperty = DimensionProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.CfnAnomalyDetector.DimensionProperty")
    @software.amazon.jsii.Jsii.Proxy(DimensionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DimensionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the dimension.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The value of the dimension.
         * <p>
         * Dimension values must contain only ASCII characters and must include at least one non-whitespace character.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link DimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DimensionProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link DimensionProperty#getName}
             * @param name The name of the dimension. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link DimensionProperty#getValue}
             * @param value The value of the dimension. This parameter is required.
             *              Dimension values must contain only ASCII characters and must include at least one non-whitespace character.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DimensionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DimensionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DimensionProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.CfnAnomalyDetector.DimensionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DimensionProperty.Jsii$Proxy that = (DimensionProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * This structure is used in both `GetMetricData` and `PutMetricAlarm` .
     * <p>
     * The supported use of this structure is different for those two operations.
     * <p>
     * When used in <code>GetMetricData</code> , it indicates the metric data to return, and whether this call is just retrieving a batch set of data for one metric, or is performing a Metrics Insights query or a math expression. A single <code>GetMetricData</code> call can include up to 500 <code>MetricDataQuery</code> structures.
     * <p>
     * When used in <code>PutMetricAlarm</code> , it enables you to create an alarm based on a metric math expression. Each <code>MetricDataQuery</code> in the array specifies either a metric to retrieve, or a math expression to be performed on retrieved metrics. A single <code>PutMetricAlarm</code> call can include up to 20 <code>MetricDataQuery</code> structures in the array. The 20 structures can include as many as 10 structures that contain a <code>MetricStat</code> parameter to retrieve a metric, and as many as 10 structures that contain the <code>Expression</code> parameter to perform a math expression. Of those <code>Expression</code> structures, one must have <code>True</code> as the value for <code>ReturnData</code> . The result of this expression is the value the alarm watches.
     * <p>
     * Any expression used in a <code>PutMetricAlarm</code> operation must return a single time series. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax">Metric Math Syntax and Functions</a> in the <em>Amazon CloudWatch User Guide</em> .
     * <p>
     * Some of the parameters of this structure also have different uses whether you are using this structure in a <code>GetMetricData</code> operation or a <code>PutMetricAlarm</code> operation. These differences are explained in the following parameter list.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudwatch.*;
     * MetricDataQueryProperty metricDataQueryProperty = MetricDataQueryProperty.builder()
     *         .id("id")
     *         // the properties below are optional
     *         .accountId("accountId")
     *         .expression("expression")
     *         .label("label")
     *         .metricStat(MetricStatProperty.builder()
     *                 .metric(MetricProperty.builder()
     *                         .metricName("metricName")
     *                         .namespace("namespace")
     *                         // the properties below are optional
     *                         .dimensions(List.of(DimensionProperty.builder()
     *                                 .name("name")
     *                                 .value("value")
     *                                 .build()))
     *                         .build())
     *                 .period(123)
     *                 .stat("stat")
     *                 // the properties below are optional
     *                 .unit("unit")
     *                 .build())
     *         .period(123)
     *         .returnData(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.CfnAnomalyDetector.MetricDataQueryProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricDataQueryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricDataQueryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A short name used to tie this object to the results in the response.
         * <p>
         * This name must be unique within a single call to <code>GetMetricData</code> . If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the mathematical expression. The valid characters are letters, numbers, and underscore. The first character must be a lowercase letter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * The ID of the account where the metrics are located, if this is a cross-account alarm.
         * <p>
         * Use this field only for <code>PutMetricAlarm</code> operations. It is not used in <code>GetMetricData</code> operations.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccountId() {
            return null;
        }

        /**
         * This field can contain either a Metrics Insights query, or a metric math expression to be performed on the returned data.
         * <p>
         * For more information about Metrics Insights queries, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch-metrics-insights-querylanguage">Metrics Insights query components and syntax</a> in the <em>Amazon CloudWatch User Guide</em> .
         * <p>
         * A math expression can use the <code>Id</code> of the other metrics or queries to refer to those metrics, and can also use the <code>Id</code> of other expressions to use the result of those expressions. For more information about metric math expressions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax">Metric Math Syntax and Functions</a> in the <em>Amazon CloudWatch User Guide</em> .
         * <p>
         * Within each MetricDataQuery object, you must specify either <code>Expression</code> or <code>MetricStat</code> but not both.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExpression() {
            return null;
        }

        /**
         * A human-readable label for this metric or expression.
         * <p>
         * This is especially useful if this is an expression, so that you know what the value represents. If the metric or expression is shown in a CloudWatch dashboard widget, the label is shown. If Label is omitted, CloudWatch generates a default.
         * <p>
         * You can put dynamic expressions into a label, so that it is more descriptive. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html">Using Dynamic Labels</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLabel() {
            return null;
        }

        /**
         * The metric to be returned, along with statistics, period, and units.
         * <p>
         * Use this parameter only if this object is retrieving a metric and not performing a math expression on returned data.
         * <p>
         * Within one MetricDataQuery object, you must specify either <code>Expression</code> or <code>MetricStat</code> but not both.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetricStat() {
            return null;
        }

        /**
         * The granularity, in seconds, of the returned data points.
         * <p>
         * For metrics with regular resolution, a period can be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution metrics are those metrics stored by a <code>PutMetricData</code> operation that includes a <code>StorageResolution of 1 second</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPeriod() {
            return null;
        }

        /**
         * When used in `GetMetricData` , this option indicates whether to return the timestamps and raw data values of this metric.
         * <p>
         * If you are performing this call just to do math expressions and do not also need the raw data returned, you can specify <code>False</code> . If you omit this, the default of <code>True</code> is used.
         * <p>
         * When used in <code>PutMetricAlarm</code> , specify <code>True</code> for the one expression result to use as the alarm. For all other metrics and expressions in the same <code>PutMetricAlarm</code> operation, specify <code>ReturnData</code> as False.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReturnData() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetricDataQueryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricDataQueryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricDataQueryProperty> {
            java.lang.String id;
            java.lang.String accountId;
            java.lang.String expression;
            java.lang.String label;
            java.lang.Object metricStat;
            java.lang.Number period;
            java.lang.Object returnData;

            /**
             * Sets the value of {@link MetricDataQueryProperty#getId}
             * @param id A short name used to tie this object to the results in the response. This parameter is required.
             *           This name must be unique within a single call to <code>GetMetricData</code> . If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the mathematical expression. The valid characters are letters, numbers, and underscore. The first character must be a lowercase letter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link MetricDataQueryProperty#getAccountId}
             * @param accountId The ID of the account where the metrics are located, if this is a cross-account alarm.
             *                  Use this field only for <code>PutMetricAlarm</code> operations. It is not used in <code>GetMetricData</code> operations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accountId(java.lang.String accountId) {
                this.accountId = accountId;
                return this;
            }

            /**
             * Sets the value of {@link MetricDataQueryProperty#getExpression}
             * @param expression This field can contain either a Metrics Insights query, or a metric math expression to be performed on the returned data.
             *                   For more information about Metrics Insights queries, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch-metrics-insights-querylanguage">Metrics Insights query components and syntax</a> in the <em>Amazon CloudWatch User Guide</em> .
             *                   <p>
             *                   A math expression can use the <code>Id</code> of the other metrics or queries to refer to those metrics, and can also use the <code>Id</code> of other expressions to use the result of those expressions. For more information about metric math expressions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax">Metric Math Syntax and Functions</a> in the <em>Amazon CloudWatch User Guide</em> .
             *                   <p>
             *                   Within each MetricDataQuery object, you must specify either <code>Expression</code> or <code>MetricStat</code> but not both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(java.lang.String expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Sets the value of {@link MetricDataQueryProperty#getLabel}
             * @param label A human-readable label for this metric or expression.
             *              This is especially useful if this is an expression, so that you know what the value represents. If the metric or expression is shown in a CloudWatch dashboard widget, the label is shown. If Label is omitted, CloudWatch generates a default.
             *              <p>
             *              You can put dynamic expressions into a label, so that it is more descriptive. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html">Using Dynamic Labels</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder label(java.lang.String label) {
                this.label = label;
                return this;
            }

            /**
             * Sets the value of {@link MetricDataQueryProperty#getMetricStat}
             * @param metricStat The metric to be returned, along with statistics, period, and units.
             *                   Use this parameter only if this object is retrieving a metric and not performing a math expression on returned data.
             *                   <p>
             *                   Within one MetricDataQuery object, you must specify either <code>Expression</code> or <code>MetricStat</code> but not both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricStat(software.amazon.awscdk.services.cloudwatch.CfnAnomalyDetector.MetricStatProperty metricStat) {
                this.metricStat = metricStat;
                return this;
            }

            /**
             * Sets the value of {@link MetricDataQueryProperty#getMetricStat}
             * @param metricStat The metric to be returned, along with statistics, period, and units.
             *                   Use this parameter only if this object is retrieving a metric and not performing a math expression on returned data.
             *                   <p>
             *                   Within one MetricDataQuery object, you must specify either <code>Expression</code> or <code>MetricStat</code> but not both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricStat(software.amazon.awscdk.IResolvable metricStat) {
                this.metricStat = metricStat;
                return this;
            }

            /**
             * Sets the value of {@link MetricDataQueryProperty#getPeriod}
             * @param period The granularity, in seconds, of the returned data points.
             *               For metrics with regular resolution, a period can be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution metrics are those metrics stored by a <code>PutMetricData</code> operation that includes a <code>StorageResolution of 1 second</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder period(java.lang.Number period) {
                this.period = period;
                return this;
            }

            /**
             * Sets the value of {@link MetricDataQueryProperty#getReturnData}
             * @param returnData When used in `GetMetricData` , this option indicates whether to return the timestamps and raw data values of this metric.
             *                   If you are performing this call just to do math expressions and do not also need the raw data returned, you can specify <code>False</code> . If you omit this, the default of <code>True</code> is used.
             *                   <p>
             *                   When used in <code>PutMetricAlarm</code> , specify <code>True</code> for the one expression result to use as the alarm. For all other metrics and expressions in the same <code>PutMetricAlarm</code> operation, specify <code>ReturnData</code> as False.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder returnData(java.lang.Boolean returnData) {
                this.returnData = returnData;
                return this;
            }

            /**
             * Sets the value of {@link MetricDataQueryProperty#getReturnData}
             * @param returnData When used in `GetMetricData` , this option indicates whether to return the timestamps and raw data values of this metric.
             *                   If you are performing this call just to do math expressions and do not also need the raw data returned, you can specify <code>False</code> . If you omit this, the default of <code>True</code> is used.
             *                   <p>
             *                   When used in <code>PutMetricAlarm</code> , specify <code>True</code> for the one expression result to use as the alarm. For all other metrics and expressions in the same <code>PutMetricAlarm</code> operation, specify <code>ReturnData</code> as False.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder returnData(software.amazon.awscdk.IResolvable returnData) {
                this.returnData = returnData;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricDataQueryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricDataQueryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricDataQueryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricDataQueryProperty {
            private final java.lang.String id;
            private final java.lang.String accountId;
            private final java.lang.String expression;
            private final java.lang.String label;
            private final java.lang.Object metricStat;
            private final java.lang.Number period;
            private final java.lang.Object returnData;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.accountId = software.amazon.jsii.Kernel.get(this, "accountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.label = software.amazon.jsii.Kernel.get(this, "label", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metricStat = software.amazon.jsii.Kernel.get(this, "metricStat", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.period = software.amazon.jsii.Kernel.get(this, "period", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.returnData = software.amazon.jsii.Kernel.get(this, "returnData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
                this.accountId = builder.accountId;
                this.expression = builder.expression;
                this.label = builder.label;
                this.metricStat = builder.metricStat;
                this.period = builder.period;
                this.returnData = builder.returnData;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getAccountId() {
                return this.accountId;
            }

            @Override
            public final java.lang.String getExpression() {
                return this.expression;
            }

            @Override
            public final java.lang.String getLabel() {
                return this.label;
            }

            @Override
            public final java.lang.Object getMetricStat() {
                return this.metricStat;
            }

            @Override
            public final java.lang.Number getPeriod() {
                return this.period;
            }

            @Override
            public final java.lang.Object getReturnData() {
                return this.returnData;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("id", om.valueToTree(this.getId()));
                if (this.getAccountId() != null) {
                    data.set("accountId", om.valueToTree(this.getAccountId()));
                }
                if (this.getExpression() != null) {
                    data.set("expression", om.valueToTree(this.getExpression()));
                }
                if (this.getLabel() != null) {
                    data.set("label", om.valueToTree(this.getLabel()));
                }
                if (this.getMetricStat() != null) {
                    data.set("metricStat", om.valueToTree(this.getMetricStat()));
                }
                if (this.getPeriod() != null) {
                    data.set("period", om.valueToTree(this.getPeriod()));
                }
                if (this.getReturnData() != null) {
                    data.set("returnData", om.valueToTree(this.getReturnData()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.CfnAnomalyDetector.MetricDataQueryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricDataQueryProperty.Jsii$Proxy that = (MetricDataQueryProperty.Jsii$Proxy) o;

                if (!id.equals(that.id)) return false;
                if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) return false;
                if (this.expression != null ? !this.expression.equals(that.expression) : that.expression != null) return false;
                if (this.label != null ? !this.label.equals(that.label) : that.label != null) return false;
                if (this.metricStat != null ? !this.metricStat.equals(that.metricStat) : that.metricStat != null) return false;
                if (this.period != null ? !this.period.equals(that.period) : that.period != null) return false;
                return this.returnData != null ? this.returnData.equals(that.returnData) : that.returnData == null;
            }

            @Override
            public final int hashCode() {
                int result = this.id.hashCode();
                result = 31 * result + (this.accountId != null ? this.accountId.hashCode() : 0);
                result = 31 * result + (this.expression != null ? this.expression.hashCode() : 0);
                result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
                result = 31 * result + (this.metricStat != null ? this.metricStat.hashCode() : 0);
                result = 31 * result + (this.period != null ? this.period.hashCode() : 0);
                result = 31 * result + (this.returnData != null ? this.returnData.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Indicates the CloudWatch math expression that provides the time series the anomaly detector uses as input.
     * <p>
     * The designated math expression must return a single time series.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudwatch.*;
     * MetricMathAnomalyDetectorProperty metricMathAnomalyDetectorProperty = MetricMathAnomalyDetectorProperty.builder()
     *         .metricDataQueries(List.of(MetricDataQueryProperty.builder()
     *                 .id("id")
     *                 // the properties below are optional
     *                 .accountId("accountId")
     *                 .expression("expression")
     *                 .label("label")
     *                 .metricStat(MetricStatProperty.builder()
     *                         .metric(MetricProperty.builder()
     *                                 .metricName("metricName")
     *                                 .namespace("namespace")
     *                                 // the properties below are optional
     *                                 .dimensions(List.of(DimensionProperty.builder()
     *                                         .name("name")
     *                                         .value("value")
     *                                         .build()))
     *                                 .build())
     *                         .period(123)
     *                         .stat("stat")
     *                         // the properties below are optional
     *                         .unit("unit")
     *                         .build())
     *                 .period(123)
     *                 .returnData(false)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.CfnAnomalyDetector.MetricMathAnomalyDetectorProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricMathAnomalyDetectorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricMathAnomalyDetectorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of metric data query structures that enables you to create an anomaly detector based on the result of a metric math expression.
         * <p>
         * Each item in <code>MetricDataQueries</code> gets a metric or performs a math expression. One item in <code>MetricDataQueries</code> is the expression that provides the time series that the anomaly detector uses as input. Designate the expression by setting <code>ReturnData</code> to <code>True</code> for this object in the array. For all other expressions and metrics, set <code>ReturnData</code> to <code>False</code> . The designated expression must return a single time series.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetricDataQueries() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetricMathAnomalyDetectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricMathAnomalyDetectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricMathAnomalyDetectorProperty> {
            java.lang.Object metricDataQueries;

            /**
             * Sets the value of {@link MetricMathAnomalyDetectorProperty#getMetricDataQueries}
             * @param metricDataQueries An array of metric data query structures that enables you to create an anomaly detector based on the result of a metric math expression.
             *                          Each item in <code>MetricDataQueries</code> gets a metric or performs a math expression. One item in <code>MetricDataQueries</code> is the expression that provides the time series that the anomaly detector uses as input. Designate the expression by setting <code>ReturnData</code> to <code>True</code> for this object in the array. For all other expressions and metrics, set <code>ReturnData</code> to <code>False</code> . The designated expression must return a single time series.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricDataQueries(software.amazon.awscdk.IResolvable metricDataQueries) {
                this.metricDataQueries = metricDataQueries;
                return this;
            }

            /**
             * Sets the value of {@link MetricMathAnomalyDetectorProperty#getMetricDataQueries}
             * @param metricDataQueries An array of metric data query structures that enables you to create an anomaly detector based on the result of a metric math expression.
             *                          Each item in <code>MetricDataQueries</code> gets a metric or performs a math expression. One item in <code>MetricDataQueries</code> is the expression that provides the time series that the anomaly detector uses as input. Designate the expression by setting <code>ReturnData</code> to <code>True</code> for this object in the array. For all other expressions and metrics, set <code>ReturnData</code> to <code>False</code> . The designated expression must return a single time series.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricDataQueries(java.util.List<? extends java.lang.Object> metricDataQueries) {
                this.metricDataQueries = metricDataQueries;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricMathAnomalyDetectorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricMathAnomalyDetectorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricMathAnomalyDetectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricMathAnomalyDetectorProperty {
            private final java.lang.Object metricDataQueries;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metricDataQueries = software.amazon.jsii.Kernel.get(this, "metricDataQueries", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metricDataQueries = builder.metricDataQueries;
            }

            @Override
            public final java.lang.Object getMetricDataQueries() {
                return this.metricDataQueries;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMetricDataQueries() != null) {
                    data.set("metricDataQueries", om.valueToTree(this.getMetricDataQueries()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.CfnAnomalyDetector.MetricMathAnomalyDetectorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricMathAnomalyDetectorProperty.Jsii$Proxy that = (MetricMathAnomalyDetectorProperty.Jsii$Proxy) o;

                return this.metricDataQueries != null ? this.metricDataQueries.equals(that.metricDataQueries) : that.metricDataQueries == null;
            }

            @Override
            public final int hashCode() {
                int result = this.metricDataQueries != null ? this.metricDataQueries.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Represents a specific metric.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudwatch.*;
     * MetricProperty metricProperty = MetricProperty.builder()
     *         .metricName("metricName")
     *         .namespace("namespace")
     *         // the properties below are optional
     *         .dimensions(List.of(DimensionProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.CfnAnomalyDetector.MetricProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the metric.
         * <p>
         * This is a required field.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMetricName();

        /**
         * The namespace of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNamespace();

        /**
         * The dimensions for the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDimensions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricProperty> {
            java.lang.String metricName;
            java.lang.String namespace;
            java.lang.Object dimensions;

            /**
             * Sets the value of {@link MetricProperty#getMetricName}
             * @param metricName The name of the metric. This parameter is required.
             *                   This is a required field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricName(java.lang.String metricName) {
                this.metricName = metricName;
                return this;
            }

            /**
             * Sets the value of {@link MetricProperty#getNamespace}
             * @param namespace The namespace of the metric. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Sets the value of {@link MetricProperty#getDimensions}
             * @param dimensions The dimensions for the metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(software.amazon.awscdk.IResolvable dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link MetricProperty#getDimensions}
             * @param dimensions The dimensions for the metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(java.util.List<? extends java.lang.Object> dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricProperty {
            private final java.lang.String metricName;
            private final java.lang.String namespace;
            private final java.lang.Object dimensions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dimensions = software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metricName = java.util.Objects.requireNonNull(builder.metricName, "metricName is required");
                this.namespace = java.util.Objects.requireNonNull(builder.namespace, "namespace is required");
                this.dimensions = builder.dimensions;
            }

            @Override
            public final java.lang.String getMetricName() {
                return this.metricName;
            }

            @Override
            public final java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            public final java.lang.Object getDimensions() {
                return this.dimensions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("metricName", om.valueToTree(this.getMetricName()));
                data.set("namespace", om.valueToTree(this.getNamespace()));
                if (this.getDimensions() != null) {
                    data.set("dimensions", om.valueToTree(this.getDimensions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.CfnAnomalyDetector.MetricProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricProperty.Jsii$Proxy that = (MetricProperty.Jsii$Proxy) o;

                if (!metricName.equals(that.metricName)) return false;
                if (!namespace.equals(that.namespace)) return false;
                return this.dimensions != null ? this.dimensions.equals(that.dimensions) : that.dimensions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.metricName.hashCode();
                result = 31 * result + (this.namespace.hashCode());
                result = 31 * result + (this.dimensions != null ? this.dimensions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This structure defines the metric to be returned, along with the statistics, period, and units.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudwatch.*;
     * MetricStatProperty metricStatProperty = MetricStatProperty.builder()
     *         .metric(MetricProperty.builder()
     *                 .metricName("metricName")
     *                 .namespace("namespace")
     *                 // the properties below are optional
     *                 .dimensions(List.of(DimensionProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .build())
     *         .period(123)
     *         .stat("stat")
     *         // the properties below are optional
     *         .unit("unit")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.CfnAnomalyDetector.MetricStatProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricStatProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricStatProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The metric to return, including the metric name, namespace, and dimensions.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMetric();

        /**
         * The granularity, in seconds, of the returned data points.
         * <p>
         * For metrics with regular resolution, a period can be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution metrics are those metrics stored by a <code>PutMetricData</code> call that includes a <code>StorageResolution</code> of 1 second.
         * <p>
         * If the <code>StartTime</code> parameter specifies a time stamp that is greater than 3 hours ago, you must specify the period as follows or no data points in that time range is returned:
         * <p>
         * <ul>
         * <li>Start time between 3 hours and 15 days ago - Use a multiple of 60 seconds (1 minute).</li>
         * <li>Start time between 15 and 63 days ago - Use a multiple of 300 seconds (5 minutes).</li>
         * <li>Start time greater than 63 days ago - Use a multiple of 3600 seconds (1 hour).</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPeriod();

        /**
         * The statistic to return.
         * <p>
         * It can include any CloudWatch statistic or extended statistic.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStat();

        /**
         * When you are using a `Put` operation, this defines what unit you want to use when storing the metric.
         * <p>
         * In a <code>Get</code> operation, if you omit <code>Unit</code> then all data that was collected with any unit is returned, along with the corresponding units that were specified when the data was reported to CloudWatch. If you specify a unit, the operation returns only data that was collected with that unit specified. If you specify a unit that does not match the data collected, the results of the operation are null. CloudWatch does not perform unit conversions.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUnit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetricStatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricStatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricStatProperty> {
            java.lang.Object metric;
            java.lang.Number period;
            java.lang.String stat;
            java.lang.String unit;

            /**
             * Sets the value of {@link MetricStatProperty#getMetric}
             * @param metric The metric to return, including the metric name, namespace, and dimensions. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metric(software.amazon.awscdk.services.cloudwatch.CfnAnomalyDetector.MetricProperty metric) {
                this.metric = metric;
                return this;
            }

            /**
             * Sets the value of {@link MetricStatProperty#getMetric}
             * @param metric The metric to return, including the metric name, namespace, and dimensions. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metric(software.amazon.awscdk.IResolvable metric) {
                this.metric = metric;
                return this;
            }

            /**
             * Sets the value of {@link MetricStatProperty#getPeriod}
             * @param period The granularity, in seconds, of the returned data points. This parameter is required.
             *               For metrics with regular resolution, a period can be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution metrics are those metrics stored by a <code>PutMetricData</code> call that includes a <code>StorageResolution</code> of 1 second.
             *               <p>
             *               If the <code>StartTime</code> parameter specifies a time stamp that is greater than 3 hours ago, you must specify the period as follows or no data points in that time range is returned:
             *               <p>
             *               <ul>
             *               <li>Start time between 3 hours and 15 days ago - Use a multiple of 60 seconds (1 minute).</li>
             *               <li>Start time between 15 and 63 days ago - Use a multiple of 300 seconds (5 minutes).</li>
             *               <li>Start time greater than 63 days ago - Use a multiple of 3600 seconds (1 hour).</li>
             *               </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder period(java.lang.Number period) {
                this.period = period;
                return this;
            }

            /**
             * Sets the value of {@link MetricStatProperty#getStat}
             * @param stat The statistic to return. This parameter is required.
             *             It can include any CloudWatch statistic or extended statistic.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stat(java.lang.String stat) {
                this.stat = stat;
                return this;
            }

            /**
             * Sets the value of {@link MetricStatProperty#getUnit}
             * @param unit When you are using a `Put` operation, this defines what unit you want to use when storing the metric.
             *             In a <code>Get</code> operation, if you omit <code>Unit</code> then all data that was collected with any unit is returned, along with the corresponding units that were specified when the data was reported to CloudWatch. If you specify a unit, the operation returns only data that was collected with that unit specified. If you specify a unit that does not match the data collected, the results of the operation are null. CloudWatch does not perform unit conversions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricStatProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricStatProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricStatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricStatProperty {
            private final java.lang.Object metric;
            private final java.lang.Number period;
            private final java.lang.String stat;
            private final java.lang.String unit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metric = software.amazon.jsii.Kernel.get(this, "metric", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.period = software.amazon.jsii.Kernel.get(this, "period", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.stat = software.amazon.jsii.Kernel.get(this, "stat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metric = java.util.Objects.requireNonNull(builder.metric, "metric is required");
                this.period = java.util.Objects.requireNonNull(builder.period, "period is required");
                this.stat = java.util.Objects.requireNonNull(builder.stat, "stat is required");
                this.unit = builder.unit;
            }

            @Override
            public final java.lang.Object getMetric() {
                return this.metric;
            }

            @Override
            public final java.lang.Number getPeriod() {
                return this.period;
            }

            @Override
            public final java.lang.String getStat() {
                return this.stat;
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("metric", om.valueToTree(this.getMetric()));
                data.set("period", om.valueToTree(this.getPeriod()));
                data.set("stat", om.valueToTree(this.getStat()));
                if (this.getUnit() != null) {
                    data.set("unit", om.valueToTree(this.getUnit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.CfnAnomalyDetector.MetricStatProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricStatProperty.Jsii$Proxy that = (MetricStatProperty.Jsii$Proxy) o;

                if (!metric.equals(that.metric)) return false;
                if (!period.equals(that.period)) return false;
                if (!stat.equals(that.stat)) return false;
                return this.unit != null ? this.unit.equals(that.unit) : that.unit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.metric.hashCode();
                result = 31 * result + (this.period.hashCode());
                result = 31 * result + (this.stat.hashCode());
                result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Each `Range` specifies one range of days or times to exclude from use for training or updating an anomaly detection model.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudwatch.*;
     * RangeProperty rangeProperty = RangeProperty.builder()
     *         .endTime("endTime")
     *         .startTime("startTime")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.CfnAnomalyDetector.RangeProperty")
    @software.amazon.jsii.Jsii.Proxy(RangeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RangeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The end time of the range to exclude.
         * <p>
         * The format is <code>yyyy-MM-dd'T'HH:mm:ss</code> . For example, <code>2019-07-01T23:59:59</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEndTime();

        /**
         * The start time of the range to exclude.
         * <p>
         * The format is <code>yyyy-MM-dd'T'HH:mm:ss</code> . For example, <code>2019-07-01T23:59:59</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStartTime();

        /**
         * @return a {@link Builder} of {@link RangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RangeProperty> {
            java.lang.String endTime;
            java.lang.String startTime;

            /**
             * Sets the value of {@link RangeProperty#getEndTime}
             * @param endTime The end time of the range to exclude. This parameter is required.
             *                The format is <code>yyyy-MM-dd'T'HH:mm:ss</code> . For example, <code>2019-07-01T23:59:59</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endTime(java.lang.String endTime) {
                this.endTime = endTime;
                return this;
            }

            /**
             * Sets the value of {@link RangeProperty#getStartTime}
             * @param startTime The start time of the range to exclude. This parameter is required.
             *                  The format is <code>yyyy-MM-dd'T'HH:mm:ss</code> . For example, <code>2019-07-01T23:59:59</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startTime(java.lang.String startTime) {
                this.startTime = startTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RangeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RangeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RangeProperty {
            private final java.lang.String endTime;
            private final java.lang.String startTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.endTime = software.amazon.jsii.Kernel.get(this, "endTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.startTime = software.amazon.jsii.Kernel.get(this, "startTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.endTime = java.util.Objects.requireNonNull(builder.endTime, "endTime is required");
                this.startTime = java.util.Objects.requireNonNull(builder.startTime, "startTime is required");
            }

            @Override
            public final java.lang.String getEndTime() {
                return this.endTime;
            }

            @Override
            public final java.lang.String getStartTime() {
                return this.startTime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("endTime", om.valueToTree(this.getEndTime()));
                data.set("startTime", om.valueToTree(this.getStartTime()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.CfnAnomalyDetector.RangeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RangeProperty.Jsii$Proxy that = (RangeProperty.Jsii$Proxy) o;

                if (!endTime.equals(that.endTime)) return false;
                return this.startTime.equals(that.startTime);
            }

            @Override
            public final int hashCode() {
                int result = this.endTime.hashCode();
                result = 31 * result + (this.startTime.hashCode());
                return result;
            }
        }
    }
    /**
     * Designates the CloudWatch metric and statistic that provides the time series the anomaly detector uses as input.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudwatch.*;
     * SingleMetricAnomalyDetectorProperty singleMetricAnomalyDetectorProperty = SingleMetricAnomalyDetectorProperty.builder()
     *         .dimensions(List.of(DimensionProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .metricName("metricName")
     *         .namespace("namespace")
     *         .stat("stat")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.CfnAnomalyDetector.SingleMetricAnomalyDetectorProperty")
    @software.amazon.jsii.Jsii.Proxy(SingleMetricAnomalyDetectorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SingleMetricAnomalyDetectorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The metric dimensions to create the anomaly detection model for.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDimensions() {
            return null;
        }

        /**
         * The name of the metric to create the anomaly detection model for.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMetricName() {
            return null;
        }

        /**
         * The namespace of the metric to create the anomaly detection model for.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNamespace() {
            return null;
        }

        /**
         * The statistic to use for the metric and anomaly detection model.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStat() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SingleMetricAnomalyDetectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SingleMetricAnomalyDetectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SingleMetricAnomalyDetectorProperty> {
            java.lang.Object dimensions;
            java.lang.String metricName;
            java.lang.String namespace;
            java.lang.String stat;

            /**
             * Sets the value of {@link SingleMetricAnomalyDetectorProperty#getDimensions}
             * @param dimensions The metric dimensions to create the anomaly detection model for.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(software.amazon.awscdk.IResolvable dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link SingleMetricAnomalyDetectorProperty#getDimensions}
             * @param dimensions The metric dimensions to create the anomaly detection model for.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(java.util.List<? extends java.lang.Object> dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link SingleMetricAnomalyDetectorProperty#getMetricName}
             * @param metricName The name of the metric to create the anomaly detection model for.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricName(java.lang.String metricName) {
                this.metricName = metricName;
                return this;
            }

            /**
             * Sets the value of {@link SingleMetricAnomalyDetectorProperty#getNamespace}
             * @param namespace The namespace of the metric to create the anomaly detection model for.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Sets the value of {@link SingleMetricAnomalyDetectorProperty#getStat}
             * @param stat The statistic to use for the metric and anomaly detection model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stat(java.lang.String stat) {
                this.stat = stat;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SingleMetricAnomalyDetectorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SingleMetricAnomalyDetectorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SingleMetricAnomalyDetectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SingleMetricAnomalyDetectorProperty {
            private final java.lang.Object dimensions;
            private final java.lang.String metricName;
            private final java.lang.String namespace;
            private final java.lang.String stat;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dimensions = software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.stat = software.amazon.jsii.Kernel.get(this, "stat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dimensions = builder.dimensions;
                this.metricName = builder.metricName;
                this.namespace = builder.namespace;
                this.stat = builder.stat;
            }

            @Override
            public final java.lang.Object getDimensions() {
                return this.dimensions;
            }

            @Override
            public final java.lang.String getMetricName() {
                return this.metricName;
            }

            @Override
            public final java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            public final java.lang.String getStat() {
                return this.stat;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDimensions() != null) {
                    data.set("dimensions", om.valueToTree(this.getDimensions()));
                }
                if (this.getMetricName() != null) {
                    data.set("metricName", om.valueToTree(this.getMetricName()));
                }
                if (this.getNamespace() != null) {
                    data.set("namespace", om.valueToTree(this.getNamespace()));
                }
                if (this.getStat() != null) {
                    data.set("stat", om.valueToTree(this.getStat()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.CfnAnomalyDetector.SingleMetricAnomalyDetectorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SingleMetricAnomalyDetectorProperty.Jsii$Proxy that = (SingleMetricAnomalyDetectorProperty.Jsii$Proxy) o;

                if (this.dimensions != null ? !this.dimensions.equals(that.dimensions) : that.dimensions != null) return false;
                if (this.metricName != null ? !this.metricName.equals(that.metricName) : that.metricName != null) return false;
                if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) return false;
                return this.stat != null ? this.stat.equals(that.stat) : that.stat == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dimensions != null ? this.dimensions.hashCode() : 0;
                result = 31 * result + (this.metricName != null ? this.metricName.hashCode() : 0);
                result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
                result = 31 * result + (this.stat != null ? this.stat.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudwatch.CfnAnomalyDetector}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudwatch.CfnAnomalyDetector> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.cloudwatch.CfnAnomalyDetectorProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Specifies details about how the anomaly detection model is to be trained, including time ranges to exclude when training and updating the model.
         * <p>
         * The configuration can also include the time zone to use for the metric.
         * <p>
         * @return {@code this}
         * @param configuration Specifies details about how the anomaly detection model is to be trained, including time ranges to exclude when training and updating the model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final software.amazon.awscdk.services.cloudwatch.CfnAnomalyDetector.ConfigurationProperty configuration) {
            this.props().configuration(configuration);
            return this;
        }
        /**
         * Specifies details about how the anomaly detection model is to be trained, including time ranges to exclude when training and updating the model.
         * <p>
         * The configuration can also include the time zone to use for the metric.
         * <p>
         * @return {@code this}
         * @param configuration Specifies details about how the anomaly detection model is to be trained, including time ranges to exclude when training and updating the model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final software.amazon.awscdk.IResolvable configuration) {
            this.props().configuration(configuration);
            return this;
        }

        /**
         * The dimensions of the metric associated with the anomaly detection band.
         * <p>
         * @return {@code this}
         * @param dimensions The dimensions of the metric associated with the anomaly detection band. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dimensions(final software.amazon.awscdk.IResolvable dimensions) {
            this.props().dimensions(dimensions);
            return this;
        }
        /**
         * The dimensions of the metric associated with the anomaly detection band.
         * <p>
         * @return {@code this}
         * @param dimensions The dimensions of the metric associated with the anomaly detection band. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dimensions(final java.util.List<? extends java.lang.Object> dimensions) {
            this.props().dimensions(dimensions);
            return this;
        }

        /**
         * The CloudWatch metric math expression for this anomaly detector.
         * <p>
         * @return {@code this}
         * @param metricMathAnomalyDetector The CloudWatch metric math expression for this anomaly detector. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricMathAnomalyDetector(final software.amazon.awscdk.services.cloudwatch.CfnAnomalyDetector.MetricMathAnomalyDetectorProperty metricMathAnomalyDetector) {
            this.props().metricMathAnomalyDetector(metricMathAnomalyDetector);
            return this;
        }
        /**
         * The CloudWatch metric math expression for this anomaly detector.
         * <p>
         * @return {@code this}
         * @param metricMathAnomalyDetector The CloudWatch metric math expression for this anomaly detector. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricMathAnomalyDetector(final software.amazon.awscdk.IResolvable metricMathAnomalyDetector) {
            this.props().metricMathAnomalyDetector(metricMathAnomalyDetector);
            return this;
        }

        /**
         * The name of the metric associated with the anomaly detection band.
         * <p>
         * @return {@code this}
         * @param metricName The name of the metric associated with the anomaly detection band. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricName(final java.lang.String metricName) {
            this.props().metricName(metricName);
            return this;
        }

        /**
         * The namespace of the metric associated with the anomaly detection band.
         * <p>
         * @return {@code this}
         * @param namespace The namespace of the metric associated with the anomaly detection band. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespace(final java.lang.String namespace) {
            this.props().namespace(namespace);
            return this;
        }

        /**
         * The CloudWatch metric and statistic for this anomaly detector.
         * <p>
         * @return {@code this}
         * @param singleMetricAnomalyDetector The CloudWatch metric and statistic for this anomaly detector. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder singleMetricAnomalyDetector(final software.amazon.awscdk.services.cloudwatch.CfnAnomalyDetector.SingleMetricAnomalyDetectorProperty singleMetricAnomalyDetector) {
            this.props().singleMetricAnomalyDetector(singleMetricAnomalyDetector);
            return this;
        }
        /**
         * The CloudWatch metric and statistic for this anomaly detector.
         * <p>
         * @return {@code this}
         * @param singleMetricAnomalyDetector The CloudWatch metric and statistic for this anomaly detector. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder singleMetricAnomalyDetector(final software.amazon.awscdk.IResolvable singleMetricAnomalyDetector) {
            this.props().singleMetricAnomalyDetector(singleMetricAnomalyDetector);
            return this;
        }

        /**
         * The statistic of the metric associated with the anomaly detection band.
         * <p>
         * @return {@code this}
         * @param stat The statistic of the metric associated with the anomaly detection band. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stat(final java.lang.String stat) {
            this.props().stat(stat);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cloudwatch.CfnAnomalyDetector}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudwatch.CfnAnomalyDetector build() {
            return new software.amazon.awscdk.services.cloudwatch.CfnAnomalyDetector(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.cloudwatch.CfnAnomalyDetectorProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.cloudwatch.CfnAnomalyDetectorProps.Builder();
            }
            return this.props;
        }
    }
}
