package software.amazon.awscdk.services.codebuild;

/**
 * Environment type for Windows Docker images.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Repository ecrRepository;
 * Project.Builder.create(this, "Project")
 *         .environment(BuildEnvironment.builder()
 *                 .buildImage(WindowsBuildImage.fromEcrRepository(ecrRepository, "v1.0", WindowsImageType.SERVER_2019))
 *                 // optional certificate to include in the build image
 *                 .certificate(BuildEnvironmentCertificate.builder()
 *                         .bucket(Bucket.fromBucketName(this, "Bucket", "my-bucket"))
 *                         .objectKey("path/to/cert.pem")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:53.511Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.WindowsImageType")
public enum WindowsImageType {
    /**
     * The standard environment type, WINDOWS_CONTAINER.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD,
    /**
     * The WINDOWS_SERVER_2019_CONTAINER environment type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SERVER_2019,
}
