package software.amazon.awscdk.services.cognito;

/**
 * A CloudFormation `AWS::Cognito::UserPoolClient`.
 * <p>
 * The <code>AWS::Cognito::UserPoolClient</code> resource specifies an Amazon Cognito user pool client.
 * <p>
 * <blockquote>
 * <p>
 * If you don't specify a value for a parameter, Amazon Cognito sets it to a default value.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * CfnUserPoolClient cfnUserPoolClient = CfnUserPoolClient.Builder.create(this, "MyCfnUserPoolClient")
 *         .userPoolId("userPoolId")
 *         // the properties below are optional
 *         .accessTokenValidity(123)
 *         .allowedOAuthFlows(List.of("allowedOAuthFlows"))
 *         .allowedOAuthFlowsUserPoolClient(false)
 *         .allowedOAuthScopes(List.of("allowedOAuthScopes"))
 *         .analyticsConfiguration(AnalyticsConfigurationProperty.builder()
 *                 .applicationArn("applicationArn")
 *                 .applicationId("applicationId")
 *                 .externalId("externalId")
 *                 .roleArn("roleArn")
 *                 .userDataShared(false)
 *                 .build())
 *         .callbackUrLs(List.of("callbackUrLs"))
 *         .clientName("clientName")
 *         .defaultRedirectUri("defaultRedirectUri")
 *         .enablePropagateAdditionalUserContextData(false)
 *         .enableTokenRevocation(false)
 *         .explicitAuthFlows(List.of("explicitAuthFlows"))
 *         .generateSecret(false)
 *         .idTokenValidity(123)
 *         .logoutUrLs(List.of("logoutUrLs"))
 *         .preventUserExistenceErrors("preventUserExistenceErrors")
 *         .readAttributes(List.of("readAttributes"))
 *         .refreshTokenValidity(123)
 *         .supportedIdentityProviders(List.of("supportedIdentityProviders"))
 *         .tokenValidityUnits(TokenValidityUnitsProperty.builder()
 *                 .accessToken("accessToken")
 *                 .idToken("idToken")
 *                 .refreshToken("refreshToken")
 *                 .build())
 *         .writeAttributes(List.of("writeAttributes"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:53.753Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnUserPoolClient")
public class CfnUserPoolClient extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnUserPoolClient(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnUserPoolClient(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.CfnUserPoolClient.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Cognito::UserPoolClient`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnUserPoolClient(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.CfnUserPoolClientProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrClientSecret() {
        return software.amazon.jsii.Kernel.get(this, "attrClientSecret", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrName() {
        return software.amazon.jsii.Kernel.get(this, "attrName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The user pool ID for the user pool where you want to create a user pool client.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getUserPoolId() {
        return software.amazon.jsii.Kernel.get(this, "userPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The user pool ID for the user pool where you want to create a user pool client.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserPoolId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "userPoolId", java.util.Objects.requireNonNull(value, "userPoolId is required"));
    }

    /**
     * The access token time limit.
     * <p>
     * After this limit expires, your user can't use their access token. To specify the time unit for <code>AccessTokenValidity</code> as <code>seconds</code> , <code>minutes</code> , <code>hours</code> , or <code>days</code> , set a <code>TokenValidityUnits</code> value in your API request.
     * <p>
     * For example, when you set <code>AccessTokenValidity</code> to <code>10</code> and <code>TokenValidityUnits</code> to <code>hours</code> , your user can authorize access with their access token for 10 hours.
     * <p>
     * The default time unit for <code>AccessTokenValidity</code> in an API request is hours.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getAccessTokenValidity() {
        return software.amazon.jsii.Kernel.get(this, "accessTokenValidity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The access token time limit.
     * <p>
     * After this limit expires, your user can't use their access token. To specify the time unit for <code>AccessTokenValidity</code> as <code>seconds</code> , <code>minutes</code> , <code>hours</code> , or <code>days</code> , set a <code>TokenValidityUnits</code> value in your API request.
     * <p>
     * For example, when you set <code>AccessTokenValidity</code> to <code>10</code> and <code>TokenValidityUnits</code> to <code>hours</code> , your user can authorize access with their access token for 10 hours.
     * <p>
     * The default time unit for <code>AccessTokenValidity</code> in an API request is hours.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessTokenValidity(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "accessTokenValidity", value);
    }

    /**
     * The allowed OAuth flows.
     * <p>
     * <ul>
     * <li><strong>code</strong> - Use a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the <code>/oauth2/token</code> endpoint.</li>
     * <li><strong>implicit</strong> - Issue the access token (and, optionally, ID token, based on scopes) directly to your user.</li>
     * <li><strong>client_credentials</strong> - Issue the access token from the <code>/oauth2/token</code> endpoint directly to a non-person user using a combination of the client ID and client secret.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedOAuthFlows() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "allowedOAuthFlows", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The allowed OAuth flows.
     * <p>
     * <ul>
     * <li><strong>code</strong> - Use a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the <code>/oauth2/token</code> endpoint.</li>
     * <li><strong>implicit</strong> - Issue the access token (and, optionally, ID token, based on scopes) directly to your user.</li>
     * <li><strong>client_credentials</strong> - Issue the access token from the <code>/oauth2/token</code> endpoint directly to a non-person user using a combination of the client ID and client secret.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowedOAuthFlows(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "allowedOAuthFlows", value);
    }

    /**
     * Set to true if the client is allowed to follow the OAuth protocol when interacting with Amazon Cognito user pools.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAllowedOAuthFlowsUserPoolClient() {
        return software.amazon.jsii.Kernel.get(this, "allowedOAuthFlowsUserPoolClient", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Set to true if the client is allowed to follow the OAuth protocol when interacting with Amazon Cognito user pools.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowedOAuthFlowsUserPoolClient(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "allowedOAuthFlowsUserPoolClient", value);
    }

    /**
     * Set to true if the client is allowed to follow the OAuth protocol when interacting with Amazon Cognito user pools.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowedOAuthFlowsUserPoolClient(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "allowedOAuthFlowsUserPoolClient", value);
    }

    /**
     * The allowed OAuth scopes.
     * <p>
     * Possible values provided by OAuth are <code>phone</code> , <code>email</code> , <code>openid</code> , and <code>profile</code> . Possible values provided by AWS are <code>aws.cognito.signin.user.admin</code> . Custom scopes created in Resource Servers are also supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedOAuthScopes() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "allowedOAuthScopes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The allowed OAuth scopes.
     * <p>
     * Possible values provided by OAuth are <code>phone</code> , <code>email</code> , <code>openid</code> , and <code>profile</code> . Possible values provided by AWS are <code>aws.cognito.signin.user.admin</code> . Custom scopes created in Resource Servers are also supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowedOAuthScopes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "allowedOAuthScopes", value);
    }

    /**
     * The user pool analytics configuration for collecting metrics and sending them to your Amazon Pinpoint campaign.
     * <p>
     * <blockquote>
     * <p>
     * In AWS Regions where Amazon Pinpoint isn't available, user pools only support sending events to Amazon Pinpoint projects in AWS Region us-east-1. In Regions where Amazon Pinpoint is available, user pools support sending events to Amazon Pinpoint projects within that same Region.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAnalyticsConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "analyticsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The user pool analytics configuration for collecting metrics and sending them to your Amazon Pinpoint campaign.
     * <p>
     * <blockquote>
     * <p>
     * In AWS Regions where Amazon Pinpoint isn't available, user pools only support sending events to Amazon Pinpoint projects in AWS Region us-east-1. In Regions where Amazon Pinpoint is available, user pools support sending events to Amazon Pinpoint projects within that same Region.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAnalyticsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.CfnUserPoolClient.AnalyticsConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "analyticsConfiguration", value);
    }

    /**
     * The user pool analytics configuration for collecting metrics and sending them to your Amazon Pinpoint campaign.
     * <p>
     * <blockquote>
     * <p>
     * In AWS Regions where Amazon Pinpoint isn't available, user pools only support sending events to Amazon Pinpoint projects in AWS Region us-east-1. In Regions where Amazon Pinpoint is available, user pools support sending events to Amazon Pinpoint projects within that same Region.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAnalyticsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "analyticsConfiguration", value);
    }

    /**
     * A list of allowed redirect (callback) URLs for the IdPs.
     * <p>
     * A redirect URI must:
     * <p>
     * <ul>
     * <li>Be an absolute URI.</li>
     * <li>Be registered with the authorization server.</li>
     * <li>Not include a fragment component.</li>
     * </ul>
     * <p>
     * See <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a> .
     * <p>
     * Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
     * <p>
     * App callback URLs such as myapp://example are also supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCallbackUrLs() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "callbackUrLs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of allowed redirect (callback) URLs for the IdPs.
     * <p>
     * A redirect URI must:
     * <p>
     * <ul>
     * <li>Be an absolute URI.</li>
     * <li>Be registered with the authorization server.</li>
     * <li>Not include a fragment component.</li>
     * </ul>
     * <p>
     * See <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a> .
     * <p>
     * Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
     * <p>
     * App callback URLs such as myapp://example are also supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCallbackUrLs(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "callbackUrLs", value);
    }

    /**
     * The client name for the user pool client you would like to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getClientName() {
        return software.amazon.jsii.Kernel.get(this, "clientName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The client name for the user pool client you would like to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClientName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "clientName", value);
    }

    /**
     * The default redirect URI. Must be in the `CallbackURLs` list.
     * <p>
     * A redirect URI must:
     * <p>
     * <ul>
     * <li>Be an absolute URI.</li>
     * <li>Be registered with the authorization server.</li>
     * <li>Not include a fragment component.</li>
     * </ul>
     * <p>
     * See <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a> .
     * <p>
     * Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
     * <p>
     * App callback URLs such as myapp://example are also supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDefaultRedirectUri() {
        return software.amazon.jsii.Kernel.get(this, "defaultRedirectUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The default redirect URI. Must be in the `CallbackURLs` list.
     * <p>
     * A redirect URI must:
     * <p>
     * <ul>
     * <li>Be an absolute URI.</li>
     * <li>Be registered with the authorization server.</li>
     * <li>Not include a fragment component.</li>
     * </ul>
     * <p>
     * See <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a> .
     * <p>
     * Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
     * <p>
     * App callback URLs such as myapp://example are also supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultRedirectUri(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "defaultRedirectUri", value);
    }

    /**
     * `AWS::Cognito::UserPoolClient.EnablePropagateAdditionalUserContextData`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnablePropagateAdditionalUserContextData() {
        return software.amazon.jsii.Kernel.get(this, "enablePropagateAdditionalUserContextData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Cognito::UserPoolClient.EnablePropagateAdditionalUserContextData`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnablePropagateAdditionalUserContextData(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enablePropagateAdditionalUserContextData", value);
    }

    /**
     * `AWS::Cognito::UserPoolClient.EnablePropagateAdditionalUserContextData`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnablePropagateAdditionalUserContextData(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enablePropagateAdditionalUserContextData", value);
    }

    /**
     * Activates or deactivates token revocation. For more information about revoking tokens, see [RevokeToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html) .
     * <p>
     * If you don't include this parameter, token revocation is automatically activated for the new user pool client.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnableTokenRevocation() {
        return software.amazon.jsii.Kernel.get(this, "enableTokenRevocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Activates or deactivates token revocation. For more information about revoking tokens, see [RevokeToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html) .
     * <p>
     * If you don't include this parameter, token revocation is automatically activated for the new user pool client.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableTokenRevocation(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enableTokenRevocation", value);
    }

    /**
     * Activates or deactivates token revocation. For more information about revoking tokens, see [RevokeToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html) .
     * <p>
     * If you don't include this parameter, token revocation is automatically activated for the new user pool client.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableTokenRevocation(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enableTokenRevocation", value);
    }

    /**
     * The authentication flows that are supported by the user pool clients.
     * <p>
     * Flow names without the <code>ALLOW_</code> prefix are no longer supported, in favor of new names with the <code>ALLOW_</code> prefix.
     * <p>
     * <blockquote>
     * <p>
     * Values with <code>ALLOW_</code> prefix must be used only along with the <code>ALLOW_</code> prefix.
     * <p>
     * </blockquote>
     * <p>
     * Valid values include:
     * <p>
     * <ul>
     * <li><code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code> : Enable admin based user password authentication flow <code>ADMIN_USER_PASSWORD_AUTH</code> . This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With this authentication flow, Amazon Cognito receives the password in the request instead of using the Secure Remote Password (SRP) protocol to verify passwords.</li>
     * <li><code>ALLOW_CUSTOM_AUTH</code> : Enable AWS Lambda trigger based authentication.</li>
     * <li><code>ALLOW_USER_PASSWORD_AUTH</code> : Enable user password-based authentication. In this flow, Amazon Cognito receives the password in the request instead of using the SRP protocol to verify passwords.</li>
     * <li><code>ALLOW_USER_SRP_AUTH</code> : Enable SRP-based authentication.</li>
     * <li><code>ALLOW_REFRESH_TOKEN_AUTH</code> : Enable authflow to refresh tokens.</li>
     * </ul>
     * <p>
     * If you don't specify a value for <code>ExplicitAuthFlows</code> , your app client activates the <code>ALLOW_USER_SRP_AUTH</code> and <code>ALLOW_CUSTOM_AUTH</code> authentication flows.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExplicitAuthFlows() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "explicitAuthFlows", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The authentication flows that are supported by the user pool clients.
     * <p>
     * Flow names without the <code>ALLOW_</code> prefix are no longer supported, in favor of new names with the <code>ALLOW_</code> prefix.
     * <p>
     * <blockquote>
     * <p>
     * Values with <code>ALLOW_</code> prefix must be used only along with the <code>ALLOW_</code> prefix.
     * <p>
     * </blockquote>
     * <p>
     * Valid values include:
     * <p>
     * <ul>
     * <li><code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code> : Enable admin based user password authentication flow <code>ADMIN_USER_PASSWORD_AUTH</code> . This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With this authentication flow, Amazon Cognito receives the password in the request instead of using the Secure Remote Password (SRP) protocol to verify passwords.</li>
     * <li><code>ALLOW_CUSTOM_AUTH</code> : Enable AWS Lambda trigger based authentication.</li>
     * <li><code>ALLOW_USER_PASSWORD_AUTH</code> : Enable user password-based authentication. In this flow, Amazon Cognito receives the password in the request instead of using the SRP protocol to verify passwords.</li>
     * <li><code>ALLOW_USER_SRP_AUTH</code> : Enable SRP-based authentication.</li>
     * <li><code>ALLOW_REFRESH_TOKEN_AUTH</code> : Enable authflow to refresh tokens.</li>
     * </ul>
     * <p>
     * If you don't specify a value for <code>ExplicitAuthFlows</code> , your app client activates the <code>ALLOW_USER_SRP_AUTH</code> and <code>ALLOW_CUSTOM_AUTH</code> authentication flows.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExplicitAuthFlows(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "explicitAuthFlows", value);
    }

    /**
     * Boolean to specify whether you want to generate a secret for the user pool client being created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getGenerateSecret() {
        return software.amazon.jsii.Kernel.get(this, "generateSecret", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Boolean to specify whether you want to generate a secret for the user pool client being created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGenerateSecret(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "generateSecret", value);
    }

    /**
     * Boolean to specify whether you want to generate a secret for the user pool client being created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGenerateSecret(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "generateSecret", value);
    }

    /**
     * The ID token time limit.
     * <p>
     * After this limit expires, your user can't use their ID token. To specify the time unit for <code>IdTokenValidity</code> as <code>seconds</code> , <code>minutes</code> , <code>hours</code> , or <code>days</code> , set a <code>TokenValidityUnits</code> value in your API request.
     * <p>
     * For example, when you set <code>IdTokenValidity</code> as <code>10</code> and <code>TokenValidityUnits</code> as <code>hours</code> , your user can authenticate their session with their ID token for 10 hours.
     * <p>
     * The default time unit for <code>AccessTokenValidity</code> in an API request is hours.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getIdTokenValidity() {
        return software.amazon.jsii.Kernel.get(this, "idTokenValidity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The ID token time limit.
     * <p>
     * After this limit expires, your user can't use their ID token. To specify the time unit for <code>IdTokenValidity</code> as <code>seconds</code> , <code>minutes</code> , <code>hours</code> , or <code>days</code> , set a <code>TokenValidityUnits</code> value in your API request.
     * <p>
     * For example, when you set <code>IdTokenValidity</code> as <code>10</code> and <code>TokenValidityUnits</code> as <code>hours</code> , your user can authenticate their session with their ID token for 10 hours.
     * <p>
     * The default time unit for <code>AccessTokenValidity</code> in an API request is hours.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdTokenValidity(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "idTokenValidity", value);
    }

    /**
     * A list of allowed logout URLs for the IdPs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLogoutUrLs() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "logoutUrLs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of allowed logout URLs for the IdPs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogoutUrLs(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "logoutUrLs", value);
    }

    /**
     * Use this setting to choose which errors and responses are returned by Cognito APIs during authentication, account confirmation, and password recovery when the user does not exist in the user pool.
     * <p>
     * When set to <code>ENABLED</code> and the user does not exist, authentication returns an error indicating either the username or password was incorrect, and account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to <code>LEGACY</code> , those APIs will return a <code>UserNotFoundException</code> exception if the user does not exist in the user pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPreventUserExistenceErrors() {
        return software.amazon.jsii.Kernel.get(this, "preventUserExistenceErrors", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Use this setting to choose which errors and responses are returned by Cognito APIs during authentication, account confirmation, and password recovery when the user does not exist in the user pool.
     * <p>
     * When set to <code>ENABLED</code> and the user does not exist, authentication returns an error indicating either the username or password was incorrect, and account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to <code>LEGACY</code> , those APIs will return a <code>UserNotFoundException</code> exception if the user does not exist in the user pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreventUserExistenceErrors(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "preventUserExistenceErrors", value);
    }

    /**
     * The read attributes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getReadAttributes() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "readAttributes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The read attributes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReadAttributes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "readAttributes", value);
    }

    /**
     * The refresh token time limit.
     * <p>
     * After this limit expires, your user can't use their refresh token. To specify the time unit for <code>RefreshTokenValidity</code> as <code>seconds</code> , <code>minutes</code> , <code>hours</code> , or <code>days</code> , set a <code>TokenValidityUnits</code> value in your API request.
     * <p>
     * For example, when you set <code>RefreshTokenValidity</code> as <code>10</code> and <code>TokenValidityUnits</code> as <code>days</code> , your user can refresh their session and retrieve new access and ID tokens for 10 days.
     * <p>
     * The default time unit for <code>RefreshTokenValidity</code> in an API request is days. You can't set <code>RefreshTokenValidity</code> to 0. If you do, Amazon Cognito overrides the value with the default value of 30 days.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getRefreshTokenValidity() {
        return software.amazon.jsii.Kernel.get(this, "refreshTokenValidity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The refresh token time limit.
     * <p>
     * After this limit expires, your user can't use their refresh token. To specify the time unit for <code>RefreshTokenValidity</code> as <code>seconds</code> , <code>minutes</code> , <code>hours</code> , or <code>days</code> , set a <code>TokenValidityUnits</code> value in your API request.
     * <p>
     * For example, when you set <code>RefreshTokenValidity</code> as <code>10</code> and <code>TokenValidityUnits</code> as <code>days</code> , your user can refresh their session and retrieve new access and ID tokens for 10 days.
     * <p>
     * The default time unit for <code>RefreshTokenValidity</code> in an API request is days. You can't set <code>RefreshTokenValidity</code> to 0. If you do, Amazon Cognito overrides the value with the default value of 30 days.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRefreshTokenValidity(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "refreshTokenValidity", value);
    }

    /**
     * A list of provider names for the IdPs that this client supports.
     * <p>
     * The following are supported: <code>COGNITO</code> , <code>Facebook</code> , <code>Google</code> <code>LoginWithAmazon</code> , and the names of your own SAML and OIDC providers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSupportedIdentityProviders() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "supportedIdentityProviders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of provider names for the IdPs that this client supports.
     * <p>
     * The following are supported: <code>COGNITO</code> , <code>Facebook</code> , <code>Google</code> <code>LoginWithAmazon</code> , and the names of your own SAML and OIDC providers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSupportedIdentityProviders(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "supportedIdentityProviders", value);
    }

    /**
     * The units in which the validity times are represented.
     * <p>
     * The default unit for RefreshToken is days, and default for ID and access tokens are hours.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTokenValidityUnits() {
        return software.amazon.jsii.Kernel.get(this, "tokenValidityUnits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The units in which the validity times are represented.
     * <p>
     * The default unit for RefreshToken is days, and default for ID and access tokens are hours.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTokenValidityUnits(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.CfnUserPoolClient.TokenValidityUnitsProperty value) {
        software.amazon.jsii.Kernel.set(this, "tokenValidityUnits", value);
    }

    /**
     * The units in which the validity times are represented.
     * <p>
     * The default unit for RefreshToken is days, and default for ID and access tokens are hours.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTokenValidityUnits(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "tokenValidityUnits", value);
    }

    /**
     * The user pool attributes that the app client can write to.
     * <p>
     * If your app client allows users to sign in through an IdP, this array must include all attributes that you have mapped to IdP attributes. Amazon Cognito updates mapped attributes when users sign in to your application through an IdP. If your app client does not have write access to a mapped attribute, Amazon Cognito throws an error when it tries to update the attribute. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html">Specifying IdP Attribute Mappings for Your user pool</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getWriteAttributes() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "writeAttributes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The user pool attributes that the app client can write to.
     * <p>
     * If your app client allows users to sign in through an IdP, this array must include all attributes that you have mapped to IdP attributes. Amazon Cognito updates mapped attributes when users sign in to your application through an IdP. If your app client does not have write access to a mapped attribute, Amazon Cognito throws an error when it tries to update the attribute. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html">Specifying IdP Attribute Mappings for Your user pool</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWriteAttributes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "writeAttributes", value);
    }
    /**
     * The Amazon Pinpoint analytics configuration necessary to collect metrics for a user pool.
     * <p>
     * <blockquote>
     * <p>
     * In Regions where Amazon Pinpointisn't available, user pools only support sending events to Amazon Pinpoint projects in us-east-1. In Regions where Amazon Pinpoint is available, user pools support sending events to Amazon Pinpoint projects within that same Region.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * AnalyticsConfigurationProperty analyticsConfigurationProperty = AnalyticsConfigurationProperty.builder()
     *         .applicationArn("applicationArn")
     *         .applicationId("applicationId")
     *         .externalId("externalId")
     *         .roleArn("roleArn")
     *         .userDataShared(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnUserPoolClient.AnalyticsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AnalyticsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnalyticsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of an Amazon Pinpoint project.
         * <p>
         * You can use the Amazon Pinpoint project for integration with the chosen user pool client. Amazon Cognito publishes events to the Amazon Pinpoint project that the app ARN declares.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getApplicationArn() {
            return null;
        }

        /**
         * The application ID for an Amazon Pinpoint application.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getApplicationId() {
            return null;
        }

        /**
         * The external ID.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExternalId() {
            return null;
        }

        /**
         * The ARN of an AWS Identity and Access Management role that authorizes Amazon Cognito to publish events to Amazon Pinpoint analytics.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
            return null;
        }

        /**
         * If `UserDataShared` is `true` , Amazon Cognito includes user data in the events that it publishes to Amazon Pinpoint analytics.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUserDataShared() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AnalyticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnalyticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnalyticsConfigurationProperty> {
            java.lang.String applicationArn;
            java.lang.String applicationId;
            java.lang.String externalId;
            java.lang.String roleArn;
            java.lang.Object userDataShared;

            /**
             * Sets the value of {@link AnalyticsConfigurationProperty#getApplicationArn}
             * @param applicationArn The Amazon Resource Name (ARN) of an Amazon Pinpoint project.
             *                       You can use the Amazon Pinpoint project for integration with the chosen user pool client. Amazon Cognito publishes events to the Amazon Pinpoint project that the app ARN declares.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationArn(java.lang.String applicationArn) {
                this.applicationArn = applicationArn;
                return this;
            }

            /**
             * Sets the value of {@link AnalyticsConfigurationProperty#getApplicationId}
             * @param applicationId The application ID for an Amazon Pinpoint application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationId(java.lang.String applicationId) {
                this.applicationId = applicationId;
                return this;
            }

            /**
             * Sets the value of {@link AnalyticsConfigurationProperty#getExternalId}
             * @param externalId The external ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder externalId(java.lang.String externalId) {
                this.externalId = externalId;
                return this;
            }

            /**
             * Sets the value of {@link AnalyticsConfigurationProperty#getRoleArn}
             * @param roleArn The ARN of an AWS Identity and Access Management role that authorizes Amazon Cognito to publish events to Amazon Pinpoint analytics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link AnalyticsConfigurationProperty#getUserDataShared}
             * @param userDataShared If `UserDataShared` is `true` , Amazon Cognito includes user data in the events that it publishes to Amazon Pinpoint analytics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userDataShared(java.lang.Boolean userDataShared) {
                this.userDataShared = userDataShared;
                return this;
            }

            /**
             * Sets the value of {@link AnalyticsConfigurationProperty#getUserDataShared}
             * @param userDataShared If `UserDataShared` is `true` , Amazon Cognito includes user data in the events that it publishes to Amazon Pinpoint analytics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userDataShared(software.amazon.awscdk.IResolvable userDataShared) {
                this.userDataShared = userDataShared;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnalyticsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnalyticsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AnalyticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnalyticsConfigurationProperty {
            private final java.lang.String applicationArn;
            private final java.lang.String applicationId;
            private final java.lang.String externalId;
            private final java.lang.String roleArn;
            private final java.lang.Object userDataShared;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.applicationArn = software.amazon.jsii.Kernel.get(this, "applicationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.applicationId = software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.externalId = software.amazon.jsii.Kernel.get(this, "externalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userDataShared = software.amazon.jsii.Kernel.get(this, "userDataShared", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.applicationArn = builder.applicationArn;
                this.applicationId = builder.applicationId;
                this.externalId = builder.externalId;
                this.roleArn = builder.roleArn;
                this.userDataShared = builder.userDataShared;
            }

            @Override
            public final java.lang.String getApplicationArn() {
                return this.applicationArn;
            }

            @Override
            public final java.lang.String getApplicationId() {
                return this.applicationId;
            }

            @Override
            public final java.lang.String getExternalId() {
                return this.externalId;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.Object getUserDataShared() {
                return this.userDataShared;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getApplicationArn() != null) {
                    data.set("applicationArn", om.valueToTree(this.getApplicationArn()));
                }
                if (this.getApplicationId() != null) {
                    data.set("applicationId", om.valueToTree(this.getApplicationId()));
                }
                if (this.getExternalId() != null) {
                    data.set("externalId", om.valueToTree(this.getExternalId()));
                }
                if (this.getRoleArn() != null) {
                    data.set("roleArn", om.valueToTree(this.getRoleArn()));
                }
                if (this.getUserDataShared() != null) {
                    data.set("userDataShared", om.valueToTree(this.getUserDataShared()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CfnUserPoolClient.AnalyticsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnalyticsConfigurationProperty.Jsii$Proxy that = (AnalyticsConfigurationProperty.Jsii$Proxy) o;

                if (this.applicationArn != null ? !this.applicationArn.equals(that.applicationArn) : that.applicationArn != null) return false;
                if (this.applicationId != null ? !this.applicationId.equals(that.applicationId) : that.applicationId != null) return false;
                if (this.externalId != null ? !this.externalId.equals(that.externalId) : that.externalId != null) return false;
                if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
                return this.userDataShared != null ? this.userDataShared.equals(that.userDataShared) : that.userDataShared == null;
            }

            @Override
            public final int hashCode() {
                int result = this.applicationArn != null ? this.applicationArn.hashCode() : 0;
                result = 31 * result + (this.applicationId != null ? this.applicationId.hashCode() : 0);
                result = 31 * result + (this.externalId != null ? this.externalId.hashCode() : 0);
                result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
                result = 31 * result + (this.userDataShared != null ? this.userDataShared.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The units in which the validity times are represented.
     * <p>
     * The default unit for RefreshToken is days, and the default for ID and access tokens is hours.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * TokenValidityUnitsProperty tokenValidityUnitsProperty = TokenValidityUnitsProperty.builder()
     *         .accessToken("accessToken")
     *         .idToken("idToken")
     *         .refreshToken("refreshToken")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnUserPoolClient.TokenValidityUnitsProperty")
    @software.amazon.jsii.Jsii.Proxy(TokenValidityUnitsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TokenValidityUnitsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A time unit in “seconds”, “minutes”, “hours”, or “days” for the value in AccessTokenValidity, defaulting to hours.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessToken() {
            return null;
        }

        /**
         * A time unit in “seconds”, “minutes”, “hours”, or “days” for the value in IdTokenValidity, defaulting to hours.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIdToken() {
            return null;
        }

        /**
         * A time unit in “seconds”, “minutes”, “hours”, or “days” for the value in RefreshTokenValidity, defaulting to days.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRefreshToken() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TokenValidityUnitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TokenValidityUnitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TokenValidityUnitsProperty> {
            java.lang.String accessToken;
            java.lang.String idToken;
            java.lang.String refreshToken;

            /**
             * Sets the value of {@link TokenValidityUnitsProperty#getAccessToken}
             * @param accessToken A time unit in “seconds”, “minutes”, “hours”, or “days” for the value in AccessTokenValidity, defaulting to hours.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessToken(java.lang.String accessToken) {
                this.accessToken = accessToken;
                return this;
            }

            /**
             * Sets the value of {@link TokenValidityUnitsProperty#getIdToken}
             * @param idToken A time unit in “seconds”, “minutes”, “hours”, or “days” for the value in IdTokenValidity, defaulting to hours.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idToken(java.lang.String idToken) {
                this.idToken = idToken;
                return this;
            }

            /**
             * Sets the value of {@link TokenValidityUnitsProperty#getRefreshToken}
             * @param refreshToken A time unit in “seconds”, “minutes”, “hours”, or “days” for the value in RefreshTokenValidity, defaulting to days.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder refreshToken(java.lang.String refreshToken) {
                this.refreshToken = refreshToken;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TokenValidityUnitsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TokenValidityUnitsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TokenValidityUnitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TokenValidityUnitsProperty {
            private final java.lang.String accessToken;
            private final java.lang.String idToken;
            private final java.lang.String refreshToken;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessToken = software.amazon.jsii.Kernel.get(this, "accessToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.idToken = software.amazon.jsii.Kernel.get(this, "idToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.refreshToken = software.amazon.jsii.Kernel.get(this, "refreshToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessToken = builder.accessToken;
                this.idToken = builder.idToken;
                this.refreshToken = builder.refreshToken;
            }

            @Override
            public final java.lang.String getAccessToken() {
                return this.accessToken;
            }

            @Override
            public final java.lang.String getIdToken() {
                return this.idToken;
            }

            @Override
            public final java.lang.String getRefreshToken() {
                return this.refreshToken;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccessToken() != null) {
                    data.set("accessToken", om.valueToTree(this.getAccessToken()));
                }
                if (this.getIdToken() != null) {
                    data.set("idToken", om.valueToTree(this.getIdToken()));
                }
                if (this.getRefreshToken() != null) {
                    data.set("refreshToken", om.valueToTree(this.getRefreshToken()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CfnUserPoolClient.TokenValidityUnitsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TokenValidityUnitsProperty.Jsii$Proxy that = (TokenValidityUnitsProperty.Jsii$Proxy) o;

                if (this.accessToken != null ? !this.accessToken.equals(that.accessToken) : that.accessToken != null) return false;
                if (this.idToken != null ? !this.idToken.equals(that.idToken) : that.idToken != null) return false;
                return this.refreshToken != null ? this.refreshToken.equals(that.refreshToken) : that.refreshToken == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accessToken != null ? this.accessToken.hashCode() : 0;
                result = 31 * result + (this.idToken != null ? this.idToken.hashCode() : 0);
                result = 31 * result + (this.refreshToken != null ? this.refreshToken.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cognito.CfnUserPoolClient}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cognito.CfnUserPoolClient> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cognito.CfnUserPoolClientProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cognito.CfnUserPoolClientProps.Builder();
        }

        /**
         * The user pool ID for the user pool where you want to create a user pool client.
         * <p>
         * @return {@code this}
         * @param userPoolId The user pool ID for the user pool where you want to create a user pool client. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolId(final java.lang.String userPoolId) {
            this.props.userPoolId(userPoolId);
            return this;
        }

        /**
         * The access token time limit.
         * <p>
         * After this limit expires, your user can't use their access token. To specify the time unit for <code>AccessTokenValidity</code> as <code>seconds</code> , <code>minutes</code> , <code>hours</code> , or <code>days</code> , set a <code>TokenValidityUnits</code> value in your API request.
         * <p>
         * For example, when you set <code>AccessTokenValidity</code> to <code>10</code> and <code>TokenValidityUnits</code> to <code>hours</code> , your user can authorize access with their access token for 10 hours.
         * <p>
         * The default time unit for <code>AccessTokenValidity</code> in an API request is hours.
         * <p>
         * @return {@code this}
         * @param accessTokenValidity The access token time limit. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessTokenValidity(final java.lang.Number accessTokenValidity) {
            this.props.accessTokenValidity(accessTokenValidity);
            return this;
        }

        /**
         * The allowed OAuth flows.
         * <p>
         * <ul>
         * <li><strong>code</strong> - Use a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the <code>/oauth2/token</code> endpoint.</li>
         * <li><strong>implicit</strong> - Issue the access token (and, optionally, ID token, based on scopes) directly to your user.</li>
         * <li><strong>client_credentials</strong> - Issue the access token from the <code>/oauth2/token</code> endpoint directly to a non-person user using a combination of the client ID and client secret.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param allowedOAuthFlows The allowed OAuth flows. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedOAuthFlows(final java.util.List<java.lang.String> allowedOAuthFlows) {
            this.props.allowedOAuthFlows(allowedOAuthFlows);
            return this;
        }

        /**
         * Set to true if the client is allowed to follow the OAuth protocol when interacting with Amazon Cognito user pools.
         * <p>
         * @return {@code this}
         * @param allowedOAuthFlowsUserPoolClient Set to true if the client is allowed to follow the OAuth protocol when interacting with Amazon Cognito user pools. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedOAuthFlowsUserPoolClient(final java.lang.Boolean allowedOAuthFlowsUserPoolClient) {
            this.props.allowedOAuthFlowsUserPoolClient(allowedOAuthFlowsUserPoolClient);
            return this;
        }
        /**
         * Set to true if the client is allowed to follow the OAuth protocol when interacting with Amazon Cognito user pools.
         * <p>
         * @return {@code this}
         * @param allowedOAuthFlowsUserPoolClient Set to true if the client is allowed to follow the OAuth protocol when interacting with Amazon Cognito user pools. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedOAuthFlowsUserPoolClient(final software.amazon.awscdk.IResolvable allowedOAuthFlowsUserPoolClient) {
            this.props.allowedOAuthFlowsUserPoolClient(allowedOAuthFlowsUserPoolClient);
            return this;
        }

        /**
         * The allowed OAuth scopes.
         * <p>
         * Possible values provided by OAuth are <code>phone</code> , <code>email</code> , <code>openid</code> , and <code>profile</code> . Possible values provided by AWS are <code>aws.cognito.signin.user.admin</code> . Custom scopes created in Resource Servers are also supported.
         * <p>
         * @return {@code this}
         * @param allowedOAuthScopes The allowed OAuth scopes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedOAuthScopes(final java.util.List<java.lang.String> allowedOAuthScopes) {
            this.props.allowedOAuthScopes(allowedOAuthScopes);
            return this;
        }

        /**
         * The user pool analytics configuration for collecting metrics and sending them to your Amazon Pinpoint campaign.
         * <p>
         * <blockquote>
         * <p>
         * In AWS Regions where Amazon Pinpoint isn't available, user pools only support sending events to Amazon Pinpoint projects in AWS Region us-east-1. In Regions where Amazon Pinpoint is available, user pools support sending events to Amazon Pinpoint projects within that same Region.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param analyticsConfiguration The user pool analytics configuration for collecting metrics and sending them to your Amazon Pinpoint campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analyticsConfiguration(final software.amazon.awscdk.services.cognito.CfnUserPoolClient.AnalyticsConfigurationProperty analyticsConfiguration) {
            this.props.analyticsConfiguration(analyticsConfiguration);
            return this;
        }
        /**
         * The user pool analytics configuration for collecting metrics and sending them to your Amazon Pinpoint campaign.
         * <p>
         * <blockquote>
         * <p>
         * In AWS Regions where Amazon Pinpoint isn't available, user pools only support sending events to Amazon Pinpoint projects in AWS Region us-east-1. In Regions where Amazon Pinpoint is available, user pools support sending events to Amazon Pinpoint projects within that same Region.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param analyticsConfiguration The user pool analytics configuration for collecting metrics and sending them to your Amazon Pinpoint campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analyticsConfiguration(final software.amazon.awscdk.IResolvable analyticsConfiguration) {
            this.props.analyticsConfiguration(analyticsConfiguration);
            return this;
        }

        /**
         * A list of allowed redirect (callback) URLs for the IdPs.
         * <p>
         * A redirect URI must:
         * <p>
         * <ul>
         * <li>Be an absolute URI.</li>
         * <li>Be registered with the authorization server.</li>
         * <li>Not include a fragment component.</li>
         * </ul>
         * <p>
         * See <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a> .
         * <p>
         * Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
         * <p>
         * App callback URLs such as myapp://example are also supported.
         * <p>
         * @return {@code this}
         * @param callbackUrLs A list of allowed redirect (callback) URLs for the IdPs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder callbackUrLs(final java.util.List<java.lang.String> callbackUrLs) {
            this.props.callbackUrLs(callbackUrLs);
            return this;
        }

        /**
         * The client name for the user pool client you would like to create.
         * <p>
         * @return {@code this}
         * @param clientName The client name for the user pool client you would like to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientName(final java.lang.String clientName) {
            this.props.clientName(clientName);
            return this;
        }

        /**
         * The default redirect URI. Must be in the `CallbackURLs` list.
         * <p>
         * A redirect URI must:
         * <p>
         * <ul>
         * <li>Be an absolute URI.</li>
         * <li>Be registered with the authorization server.</li>
         * <li>Not include a fragment component.</li>
         * </ul>
         * <p>
         * See <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a> .
         * <p>
         * Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
         * <p>
         * App callback URLs such as myapp://example are also supported.
         * <p>
         * @return {@code this}
         * @param defaultRedirectUri The default redirect URI. Must be in the `CallbackURLs` list. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultRedirectUri(final java.lang.String defaultRedirectUri) {
            this.props.defaultRedirectUri(defaultRedirectUri);
            return this;
        }

        /**
         * `AWS::Cognito::UserPoolClient.EnablePropagateAdditionalUserContextData`.
         * <p>
         * @return {@code this}
         * @param enablePropagateAdditionalUserContextData `AWS::Cognito::UserPoolClient.EnablePropagateAdditionalUserContextData`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enablePropagateAdditionalUserContextData(final java.lang.Boolean enablePropagateAdditionalUserContextData) {
            this.props.enablePropagateAdditionalUserContextData(enablePropagateAdditionalUserContextData);
            return this;
        }
        /**
         * `AWS::Cognito::UserPoolClient.EnablePropagateAdditionalUserContextData`.
         * <p>
         * @return {@code this}
         * @param enablePropagateAdditionalUserContextData `AWS::Cognito::UserPoolClient.EnablePropagateAdditionalUserContextData`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enablePropagateAdditionalUserContextData(final software.amazon.awscdk.IResolvable enablePropagateAdditionalUserContextData) {
            this.props.enablePropagateAdditionalUserContextData(enablePropagateAdditionalUserContextData);
            return this;
        }

        /**
         * Activates or deactivates token revocation. For more information about revoking tokens, see [RevokeToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html) .
         * <p>
         * If you don't include this parameter, token revocation is automatically activated for the new user pool client.
         * <p>
         * @return {@code this}
         * @param enableTokenRevocation Activates or deactivates token revocation. For more information about revoking tokens, see [RevokeToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html) . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableTokenRevocation(final java.lang.Boolean enableTokenRevocation) {
            this.props.enableTokenRevocation(enableTokenRevocation);
            return this;
        }
        /**
         * Activates or deactivates token revocation. For more information about revoking tokens, see [RevokeToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html) .
         * <p>
         * If you don't include this parameter, token revocation is automatically activated for the new user pool client.
         * <p>
         * @return {@code this}
         * @param enableTokenRevocation Activates or deactivates token revocation. For more information about revoking tokens, see [RevokeToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html) . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableTokenRevocation(final software.amazon.awscdk.IResolvable enableTokenRevocation) {
            this.props.enableTokenRevocation(enableTokenRevocation);
            return this;
        }

        /**
         * The authentication flows that are supported by the user pool clients.
         * <p>
         * Flow names without the <code>ALLOW_</code> prefix are no longer supported, in favor of new names with the <code>ALLOW_</code> prefix.
         * <p>
         * <blockquote>
         * <p>
         * Values with <code>ALLOW_</code> prefix must be used only along with the <code>ALLOW_</code> prefix.
         * <p>
         * </blockquote>
         * <p>
         * Valid values include:
         * <p>
         * <ul>
         * <li><code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code> : Enable admin based user password authentication flow <code>ADMIN_USER_PASSWORD_AUTH</code> . This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With this authentication flow, Amazon Cognito receives the password in the request instead of using the Secure Remote Password (SRP) protocol to verify passwords.</li>
         * <li><code>ALLOW_CUSTOM_AUTH</code> : Enable AWS Lambda trigger based authentication.</li>
         * <li><code>ALLOW_USER_PASSWORD_AUTH</code> : Enable user password-based authentication. In this flow, Amazon Cognito receives the password in the request instead of using the SRP protocol to verify passwords.</li>
         * <li><code>ALLOW_USER_SRP_AUTH</code> : Enable SRP-based authentication.</li>
         * <li><code>ALLOW_REFRESH_TOKEN_AUTH</code> : Enable authflow to refresh tokens.</li>
         * </ul>
         * <p>
         * If you don't specify a value for <code>ExplicitAuthFlows</code> , your app client activates the <code>ALLOW_USER_SRP_AUTH</code> and <code>ALLOW_CUSTOM_AUTH</code> authentication flows.
         * <p>
         * @return {@code this}
         * @param explicitAuthFlows The authentication flows that are supported by the user pool clients. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder explicitAuthFlows(final java.util.List<java.lang.String> explicitAuthFlows) {
            this.props.explicitAuthFlows(explicitAuthFlows);
            return this;
        }

        /**
         * Boolean to specify whether you want to generate a secret for the user pool client being created.
         * <p>
         * @return {@code this}
         * @param generateSecret Boolean to specify whether you want to generate a secret for the user pool client being created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder generateSecret(final java.lang.Boolean generateSecret) {
            this.props.generateSecret(generateSecret);
            return this;
        }
        /**
         * Boolean to specify whether you want to generate a secret for the user pool client being created.
         * <p>
         * @return {@code this}
         * @param generateSecret Boolean to specify whether you want to generate a secret for the user pool client being created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder generateSecret(final software.amazon.awscdk.IResolvable generateSecret) {
            this.props.generateSecret(generateSecret);
            return this;
        }

        /**
         * The ID token time limit.
         * <p>
         * After this limit expires, your user can't use their ID token. To specify the time unit for <code>IdTokenValidity</code> as <code>seconds</code> , <code>minutes</code> , <code>hours</code> , or <code>days</code> , set a <code>TokenValidityUnits</code> value in your API request.
         * <p>
         * For example, when you set <code>IdTokenValidity</code> as <code>10</code> and <code>TokenValidityUnits</code> as <code>hours</code> , your user can authenticate their session with their ID token for 10 hours.
         * <p>
         * The default time unit for <code>AccessTokenValidity</code> in an API request is hours.
         * <p>
         * @return {@code this}
         * @param idTokenValidity The ID token time limit. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idTokenValidity(final java.lang.Number idTokenValidity) {
            this.props.idTokenValidity(idTokenValidity);
            return this;
        }

        /**
         * A list of allowed logout URLs for the IdPs.
         * <p>
         * @return {@code this}
         * @param logoutUrLs A list of allowed logout URLs for the IdPs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logoutUrLs(final java.util.List<java.lang.String> logoutUrLs) {
            this.props.logoutUrLs(logoutUrLs);
            return this;
        }

        /**
         * Use this setting to choose which errors and responses are returned by Cognito APIs during authentication, account confirmation, and password recovery when the user does not exist in the user pool.
         * <p>
         * When set to <code>ENABLED</code> and the user does not exist, authentication returns an error indicating either the username or password was incorrect, and account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to <code>LEGACY</code> , those APIs will return a <code>UserNotFoundException</code> exception if the user does not exist in the user pool.
         * <p>
         * @return {@code this}
         * @param preventUserExistenceErrors Use this setting to choose which errors and responses are returned by Cognito APIs during authentication, account confirmation, and password recovery when the user does not exist in the user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preventUserExistenceErrors(final java.lang.String preventUserExistenceErrors) {
            this.props.preventUserExistenceErrors(preventUserExistenceErrors);
            return this;
        }

        /**
         * The read attributes.
         * <p>
         * @return {@code this}
         * @param readAttributes The read attributes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readAttributes(final java.util.List<java.lang.String> readAttributes) {
            this.props.readAttributes(readAttributes);
            return this;
        }

        /**
         * The refresh token time limit.
         * <p>
         * After this limit expires, your user can't use their refresh token. To specify the time unit for <code>RefreshTokenValidity</code> as <code>seconds</code> , <code>minutes</code> , <code>hours</code> , or <code>days</code> , set a <code>TokenValidityUnits</code> value in your API request.
         * <p>
         * For example, when you set <code>RefreshTokenValidity</code> as <code>10</code> and <code>TokenValidityUnits</code> as <code>days</code> , your user can refresh their session and retrieve new access and ID tokens for 10 days.
         * <p>
         * The default time unit for <code>RefreshTokenValidity</code> in an API request is days. You can't set <code>RefreshTokenValidity</code> to 0. If you do, Amazon Cognito overrides the value with the default value of 30 days.
         * <p>
         * @return {@code this}
         * @param refreshTokenValidity The refresh token time limit. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder refreshTokenValidity(final java.lang.Number refreshTokenValidity) {
            this.props.refreshTokenValidity(refreshTokenValidity);
            return this;
        }

        /**
         * A list of provider names for the IdPs that this client supports.
         * <p>
         * The following are supported: <code>COGNITO</code> , <code>Facebook</code> , <code>Google</code> <code>LoginWithAmazon</code> , and the names of your own SAML and OIDC providers.
         * <p>
         * @return {@code this}
         * @param supportedIdentityProviders A list of provider names for the IdPs that this client supports. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder supportedIdentityProviders(final java.util.List<java.lang.String> supportedIdentityProviders) {
            this.props.supportedIdentityProviders(supportedIdentityProviders);
            return this;
        }

        /**
         * The units in which the validity times are represented.
         * <p>
         * The default unit for RefreshToken is days, and default for ID and access tokens are hours.
         * <p>
         * @return {@code this}
         * @param tokenValidityUnits The units in which the validity times are represented. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tokenValidityUnits(final software.amazon.awscdk.services.cognito.CfnUserPoolClient.TokenValidityUnitsProperty tokenValidityUnits) {
            this.props.tokenValidityUnits(tokenValidityUnits);
            return this;
        }
        /**
         * The units in which the validity times are represented.
         * <p>
         * The default unit for RefreshToken is days, and default for ID and access tokens are hours.
         * <p>
         * @return {@code this}
         * @param tokenValidityUnits The units in which the validity times are represented. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tokenValidityUnits(final software.amazon.awscdk.IResolvable tokenValidityUnits) {
            this.props.tokenValidityUnits(tokenValidityUnits);
            return this;
        }

        /**
         * The user pool attributes that the app client can write to.
         * <p>
         * If your app client allows users to sign in through an IdP, this array must include all attributes that you have mapped to IdP attributes. Amazon Cognito updates mapped attributes when users sign in to your application through an IdP. If your app client does not have write access to a mapped attribute, Amazon Cognito throws an error when it tries to update the attribute. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html">Specifying IdP Attribute Mappings for Your user pool</a> .
         * <p>
         * @return {@code this}
         * @param writeAttributes The user pool attributes that the app client can write to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder writeAttributes(final java.util.List<java.lang.String> writeAttributes) {
            this.props.writeAttributes(writeAttributes);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cognito.CfnUserPoolClient}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cognito.CfnUserPoolClient build() {
            return new software.amazon.awscdk.services.cognito.CfnUserPoolClient(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
