package software.amazon.awscdk.services.dlm;

/**
 * A CloudFormation `AWS::DLM::LifecyclePolicy`.
 * <p>
 * Specifies a lifecycle policy, which is used to automate operations on Amazon EBS resources.
 * <p>
 * The properties are required when you add a lifecycle policy and optional when you update a lifecycle policy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.dlm.*;
 * CfnLifecyclePolicy cfnLifecyclePolicy = CfnLifecyclePolicy.Builder.create(this, "MyCfnLifecyclePolicy")
 *         .description("description")
 *         .executionRoleArn("executionRoleArn")
 *         .policyDetails(PolicyDetailsProperty.builder()
 *                 .actions(List.of(ActionProperty.builder()
 *                         .crossRegionCopy(List.of(CrossRegionCopyActionProperty.builder()
 *                                 .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                                         .encrypted(false)
 *                                         // the properties below are optional
 *                                         .cmkArn("cmkArn")
 *                                         .build())
 *                                 .target("target")
 *                                 // the properties below are optional
 *                                 .retainRule(CrossRegionCopyRetainRuleProperty.builder()
 *                                         .interval(123)
 *                                         .intervalUnit("intervalUnit")
 *                                         .build())
 *                                 .build()))
 *                         .name("name")
 *                         .build()))
 *                 .eventSource(EventSourceProperty.builder()
 *                         .type("type")
 *                         // the properties below are optional
 *                         .parameters(EventParametersProperty.builder()
 *                                 .eventType("eventType")
 *                                 .snapshotOwner(List.of("snapshotOwner"))
 *                                 // the properties below are optional
 *                                 .descriptionRegex("descriptionRegex")
 *                                 .build())
 *                         .build())
 *                 .parameters(ParametersProperty.builder()
 *                         .excludeBootVolume(false)
 *                         .excludeDataVolumeTags(List.of(CfnTag.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 .build()))
 *                         .noReboot(false)
 *                         .build())
 *                 .policyType("policyType")
 *                 .resourceLocations(List.of("resourceLocations"))
 *                 .resourceTypes(List.of("resourceTypes"))
 *                 .schedules(List.of(ScheduleProperty.builder()
 *                         .copyTags(false)
 *                         .createRule(CreateRuleProperty.builder()
 *                                 .cronExpression("cronExpression")
 *                                 .interval(123)
 *                                 .intervalUnit("intervalUnit")
 *                                 .location("location")
 *                                 .times(List.of("times"))
 *                                 .build())
 *                         .crossRegionCopyRules(List.of(CrossRegionCopyRuleProperty.builder()
 *                                 .encrypted(false)
 *                                 // the properties below are optional
 *                                 .cmkArn("cmkArn")
 *                                 .copyTags(false)
 *                                 .deprecateRule(CrossRegionCopyDeprecateRuleProperty.builder()
 *                                         .interval(123)
 *                                         .intervalUnit("intervalUnit")
 *                                         .build())
 *                                 .retainRule(CrossRegionCopyRetainRuleProperty.builder()
 *                                         .interval(123)
 *                                         .intervalUnit("intervalUnit")
 *                                         .build())
 *                                 .target("target")
 *                                 .targetRegion("targetRegion")
 *                                 .build()))
 *                         .deprecateRule(DeprecateRuleProperty.builder()
 *                                 .count(123)
 *                                 .interval(123)
 *                                 .intervalUnit("intervalUnit")
 *                                 .build())
 *                         .fastRestoreRule(FastRestoreRuleProperty.builder()
 *                                 .availabilityZones(List.of("availabilityZones"))
 *                                 .count(123)
 *                                 .interval(123)
 *                                 .intervalUnit("intervalUnit")
 *                                 .build())
 *                         .name("name")
 *                         .retainRule(RetainRuleProperty.builder()
 *                                 .count(123)
 *                                 .interval(123)
 *                                 .intervalUnit("intervalUnit")
 *                                 .build())
 *                         .shareRules(List.of(ShareRuleProperty.builder()
 *                                 .targetAccounts(List.of("targetAccounts"))
 *                                 .unshareInterval(123)
 *                                 .unshareIntervalUnit("unshareIntervalUnit")
 *                                 .build()))
 *                         .tagsToAdd(List.of(CfnTag.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 .build()))
 *                         .variableTags(List.of(CfnTag.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 .build()))
 *                         .build()))
 *                 .targetTags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build())
 *         .state("state")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:54.041Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy")
public class CfnLifecyclePolicy extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnLifecyclePolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLifecyclePolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::DLM::LifecyclePolicy`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnLifecyclePolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dlm.CfnLifecyclePolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::DLM::LifecyclePolicy`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnLifecyclePolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the lifecycle policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags to apply to the lifecycle policy during creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * A description of the lifecycle policy.
     * <p>
     * The characters ^[0-9A-Za-z _-]+$ are supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the lifecycle policy.
     * <p>
     * The characters ^[0-9A-Za-z _-]+$ are supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getExecutionRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "executionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExecutionRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "executionRoleArn", value);
    }

    /**
     * The configuration details of the lifecycle policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPolicyDetails() {
        return software.amazon.jsii.Kernel.get(this, "policyDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration details of the lifecycle policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicyDetails(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.PolicyDetailsProperty value) {
        software.amazon.jsii.Kernel.set(this, "policyDetails", value);
    }

    /**
     * The configuration details of the lifecycle policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicyDetails(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "policyDetails", value);
    }

    /**
     * The activation state of the lifecycle policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getState() {
        return software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The activation state of the lifecycle policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setState(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "state", value);
    }
    /**
     * Specifies an action for an event-based policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * ActionProperty actionProperty = ActionProperty.builder()
     *         .crossRegionCopy(List.of(CrossRegionCopyActionProperty.builder()
     *                 .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                         .encrypted(false)
     *                         // the properties below are optional
     *                         .cmkArn("cmkArn")
     *                         .build())
     *                 .target("target")
     *                 // the properties below are optional
     *                 .retainRule(CrossRegionCopyRetainRuleProperty.builder()
     *                         .interval(123)
     *                         .intervalUnit("intervalUnit")
     *                         .build())
     *                 .build()))
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.ActionProperty")
    @software.amazon.jsii.Jsii.Proxy(ActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The rule for copying shared snapshots across Regions.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCrossRegionCopy();

        /**
         * A descriptive name for the action.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ActionProperty> {
            java.lang.Object crossRegionCopy;
            java.lang.String name;

            /**
             * Sets the value of {@link ActionProperty#getCrossRegionCopy}
             * @param crossRegionCopy The rule for copying shared snapshots across Regions. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crossRegionCopy(software.amazon.awscdk.IResolvable crossRegionCopy) {
                this.crossRegionCopy = crossRegionCopy;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getCrossRegionCopy}
             * @param crossRegionCopy The rule for copying shared snapshots across Regions. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crossRegionCopy(java.util.List<? extends java.lang.Object> crossRegionCopy) {
                this.crossRegionCopy = crossRegionCopy;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getName}
             * @param name A descriptive name for the action. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionProperty {
            private final java.lang.Object crossRegionCopy;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.crossRegionCopy = software.amazon.jsii.Kernel.get(this, "crossRegionCopy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.crossRegionCopy = java.util.Objects.requireNonNull(builder.crossRegionCopy, "crossRegionCopy is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            }

            @Override
            public final java.lang.Object getCrossRegionCopy() {
                return this.crossRegionCopy;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("crossRegionCopy", om.valueToTree(this.getCrossRegionCopy()));
                data.set("name", om.valueToTree(this.getName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.ActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ActionProperty.Jsii$Proxy that = (ActionProperty.Jsii$Proxy) o;

                if (!crossRegionCopy.equals(that.crossRegionCopy)) return false;
                return this.name.equals(that.name);
            }

            @Override
            public final int hashCode() {
                int result = this.crossRegionCopy.hashCode();
                result = 31 * result + (this.name.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies when to create snapshots of EBS volumes.
     * <p>
     * You must specify either a Cron expression or an interval, interval unit, and start time. You cannot specify both.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * CreateRuleProperty createRuleProperty = CreateRuleProperty.builder()
     *         .cronExpression("cronExpression")
     *         .interval(123)
     *         .intervalUnit("intervalUnit")
     *         .location("location")
     *         .times(List.of("times"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.CreateRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(CreateRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CreateRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The schedule, as a Cron expression.
         * <p>
         * The schedule interval must be between 1 hour and 1 year. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron expressions</a> in the <em>Amazon CloudWatch User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCronExpression() {
            return null;
        }

        /**
         * The interval between snapshots.
         * <p>
         * The supported values are 1, 2, 3, 4, 6, 8, 12, and 24.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInterval() {
            return null;
        }

        /**
         * The interval unit.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIntervalUnit() {
            return null;
        }

        /**
         * Specifies the destination for snapshots created by the policy.
         * <p>
         * To create snapshots in the same Region as the source resource, specify <code>CLOUD</code> . To create snapshots on the same Outpost as the source resource, specify <code>OUTPOST_LOCAL</code> . If you omit this parameter, <code>CLOUD</code> is used by default.
         * <p>
         * If the policy targets resources in an AWS Region , then you must create snapshots in the same Region as the source resource.
         * <p>
         * If the policy targets resources on an Outpost, then you can create snapshots on the same Outpost as the source resource, or in the Region of that Outpost.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocation() {
            return null;
        }

        /**
         * The time, in UTC, to start the operation. The supported format is hh:mm.
         * <p>
         * The operation occurs within a one-hour window following the specified time. If you do not specify a time, Amazon DLM selects a time within the next 24 hours.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTimes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CreateRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CreateRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CreateRuleProperty> {
            java.lang.String cronExpression;
            java.lang.Number interval;
            java.lang.String intervalUnit;
            java.lang.String location;
            java.util.List<java.lang.String> times;

            /**
             * Sets the value of {@link CreateRuleProperty#getCronExpression}
             * @param cronExpression The schedule, as a Cron expression.
             *                       The schedule interval must be between 1 hour and 1 year. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron expressions</a> in the <em>Amazon CloudWatch User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cronExpression(java.lang.String cronExpression) {
                this.cronExpression = cronExpression;
                return this;
            }

            /**
             * Sets the value of {@link CreateRuleProperty#getInterval}
             * @param interval The interval between snapshots.
             *                 The supported values are 1, 2, 3, 4, 6, 8, 12, and 24.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interval(java.lang.Number interval) {
                this.interval = interval;
                return this;
            }

            /**
             * Sets the value of {@link CreateRuleProperty#getIntervalUnit}
             * @param intervalUnit The interval unit.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intervalUnit(java.lang.String intervalUnit) {
                this.intervalUnit = intervalUnit;
                return this;
            }

            /**
             * Sets the value of {@link CreateRuleProperty#getLocation}
             * @param location Specifies the destination for snapshots created by the policy.
             *                 To create snapshots in the same Region as the source resource, specify <code>CLOUD</code> . To create snapshots on the same Outpost as the source resource, specify <code>OUTPOST_LOCAL</code> . If you omit this parameter, <code>CLOUD</code> is used by default.
             *                 <p>
             *                 If the policy targets resources in an AWS Region , then you must create snapshots in the same Region as the source resource.
             *                 <p>
             *                 If the policy targets resources on an Outpost, then you can create snapshots on the same Outpost as the source resource, or in the Region of that Outpost.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder location(java.lang.String location) {
                this.location = location;
                return this;
            }

            /**
             * Sets the value of {@link CreateRuleProperty#getTimes}
             * @param times The time, in UTC, to start the operation. The supported format is hh:mm.
             *              The operation occurs within a one-hour window following the specified time. If you do not specify a time, Amazon DLM selects a time within the next 24 hours.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder times(java.util.List<java.lang.String> times) {
                this.times = times;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CreateRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CreateRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CreateRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CreateRuleProperty {
            private final java.lang.String cronExpression;
            private final java.lang.Number interval;
            private final java.lang.String intervalUnit;
            private final java.lang.String location;
            private final java.util.List<java.lang.String> times;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cronExpression = software.amazon.jsii.Kernel.get(this, "cronExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.interval = software.amazon.jsii.Kernel.get(this, "interval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.intervalUnit = software.amazon.jsii.Kernel.get(this, "intervalUnit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.location = software.amazon.jsii.Kernel.get(this, "location", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.times = software.amazon.jsii.Kernel.get(this, "times", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cronExpression = builder.cronExpression;
                this.interval = builder.interval;
                this.intervalUnit = builder.intervalUnit;
                this.location = builder.location;
                this.times = builder.times;
            }

            @Override
            public final java.lang.String getCronExpression() {
                return this.cronExpression;
            }

            @Override
            public final java.lang.Number getInterval() {
                return this.interval;
            }

            @Override
            public final java.lang.String getIntervalUnit() {
                return this.intervalUnit;
            }

            @Override
            public final java.lang.String getLocation() {
                return this.location;
            }

            @Override
            public final java.util.List<java.lang.String> getTimes() {
                return this.times;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCronExpression() != null) {
                    data.set("cronExpression", om.valueToTree(this.getCronExpression()));
                }
                if (this.getInterval() != null) {
                    data.set("interval", om.valueToTree(this.getInterval()));
                }
                if (this.getIntervalUnit() != null) {
                    data.set("intervalUnit", om.valueToTree(this.getIntervalUnit()));
                }
                if (this.getLocation() != null) {
                    data.set("location", om.valueToTree(this.getLocation()));
                }
                if (this.getTimes() != null) {
                    data.set("times", om.valueToTree(this.getTimes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.CreateRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CreateRuleProperty.Jsii$Proxy that = (CreateRuleProperty.Jsii$Proxy) o;

                if (this.cronExpression != null ? !this.cronExpression.equals(that.cronExpression) : that.cronExpression != null) return false;
                if (this.interval != null ? !this.interval.equals(that.interval) : that.interval != null) return false;
                if (this.intervalUnit != null ? !this.intervalUnit.equals(that.intervalUnit) : that.intervalUnit != null) return false;
                if (this.location != null ? !this.location.equals(that.location) : that.location != null) return false;
                return this.times != null ? this.times.equals(that.times) : that.times == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cronExpression != null ? this.cronExpression.hashCode() : 0;
                result = 31 * result + (this.interval != null ? this.interval.hashCode() : 0);
                result = 31 * result + (this.intervalUnit != null ? this.intervalUnit.hashCode() : 0);
                result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
                result = 31 * result + (this.times != null ? this.times.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a rule for copying shared snapshots across Regions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * CrossRegionCopyActionProperty crossRegionCopyActionProperty = CrossRegionCopyActionProperty.builder()
     *         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                 .encrypted(false)
     *                 // the properties below are optional
     *                 .cmkArn("cmkArn")
     *                 .build())
     *         .target("target")
     *         // the properties below are optional
     *         .retainRule(CrossRegionCopyRetainRuleProperty.builder()
     *                 .interval(123)
     *                 .intervalUnit("intervalUnit")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.CrossRegionCopyActionProperty")
    @software.amazon.jsii.Jsii.Proxy(CrossRegionCopyActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CrossRegionCopyActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The encryption settings for the copied snapshot.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEncryptionConfiguration();

        /**
         * The target Region.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTarget();

        /**
         * Specifies the retention rule for cross-Region snapshot copies.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetainRule() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CrossRegionCopyActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CrossRegionCopyActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CrossRegionCopyActionProperty> {
            java.lang.Object encryptionConfiguration;
            java.lang.String target;
            java.lang.Object retainRule;

            /**
             * Sets the value of {@link CrossRegionCopyActionProperty#getEncryptionConfiguration}
             * @param encryptionConfiguration The encryption settings for the copied snapshot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfiguration(software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.EncryptionConfigurationProperty encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link CrossRegionCopyActionProperty#getEncryptionConfiguration}
             * @param encryptionConfiguration The encryption settings for the copied snapshot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfiguration(software.amazon.awscdk.IResolvable encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link CrossRegionCopyActionProperty#getTarget}
             * @param target The target Region. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder target(java.lang.String target) {
                this.target = target;
                return this;
            }

            /**
             * Sets the value of {@link CrossRegionCopyActionProperty#getRetainRule}
             * @param retainRule Specifies the retention rule for cross-Region snapshot copies.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retainRule(software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.CrossRegionCopyRetainRuleProperty retainRule) {
                this.retainRule = retainRule;
                return this;
            }

            /**
             * Sets the value of {@link CrossRegionCopyActionProperty#getRetainRule}
             * @param retainRule Specifies the retention rule for cross-Region snapshot copies.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retainRule(software.amazon.awscdk.IResolvable retainRule) {
                this.retainRule = retainRule;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CrossRegionCopyActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CrossRegionCopyActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CrossRegionCopyActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CrossRegionCopyActionProperty {
            private final java.lang.Object encryptionConfiguration;
            private final java.lang.String target;
            private final java.lang.Object retainRule;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encryptionConfiguration = software.amazon.jsii.Kernel.get(this, "encryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.retainRule = software.amazon.jsii.Kernel.get(this, "retainRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encryptionConfiguration = java.util.Objects.requireNonNull(builder.encryptionConfiguration, "encryptionConfiguration is required");
                this.target = java.util.Objects.requireNonNull(builder.target, "target is required");
                this.retainRule = builder.retainRule;
            }

            @Override
            public final java.lang.Object getEncryptionConfiguration() {
                return this.encryptionConfiguration;
            }

            @Override
            public final java.lang.String getTarget() {
                return this.target;
            }

            @Override
            public final java.lang.Object getRetainRule() {
                return this.retainRule;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("encryptionConfiguration", om.valueToTree(this.getEncryptionConfiguration()));
                data.set("target", om.valueToTree(this.getTarget()));
                if (this.getRetainRule() != null) {
                    data.set("retainRule", om.valueToTree(this.getRetainRule()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.CrossRegionCopyActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CrossRegionCopyActionProperty.Jsii$Proxy that = (CrossRegionCopyActionProperty.Jsii$Proxy) o;

                if (!encryptionConfiguration.equals(that.encryptionConfiguration)) return false;
                if (!target.equals(that.target)) return false;
                return this.retainRule != null ? this.retainRule.equals(that.retainRule) : that.retainRule == null;
            }

            @Override
            public final int hashCode() {
                int result = this.encryptionConfiguration.hashCode();
                result = 31 * result + (this.target.hashCode());
                result = 31 * result + (this.retainRule != null ? this.retainRule.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies an AMI deprecation rule for cross-Region AMI copies created by a cross-Region copy rule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * CrossRegionCopyDeprecateRuleProperty crossRegionCopyDeprecateRuleProperty = CrossRegionCopyDeprecateRuleProperty.builder()
     *         .interval(123)
     *         .intervalUnit("intervalUnit")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.CrossRegionCopyDeprecateRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(CrossRegionCopyDeprecateRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CrossRegionCopyDeprecateRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The period after which to deprecate the cross-Region AMI copies.
         * <p>
         * The period must be less than or equal to the cross-Region AMI copy retention period, and it can't be greater than 10 years. This is equivalent to 120 months, 520 weeks, or 3650 days.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getInterval();

        /**
         * The unit of time in which to measure the *Interval* .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIntervalUnit();

        /**
         * @return a {@link Builder} of {@link CrossRegionCopyDeprecateRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CrossRegionCopyDeprecateRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CrossRegionCopyDeprecateRuleProperty> {
            java.lang.Number interval;
            java.lang.String intervalUnit;

            /**
             * Sets the value of {@link CrossRegionCopyDeprecateRuleProperty#getInterval}
             * @param interval The period after which to deprecate the cross-Region AMI copies. This parameter is required.
             *                 The period must be less than or equal to the cross-Region AMI copy retention period, and it can't be greater than 10 years. This is equivalent to 120 months, 520 weeks, or 3650 days.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interval(java.lang.Number interval) {
                this.interval = interval;
                return this;
            }

            /**
             * Sets the value of {@link CrossRegionCopyDeprecateRuleProperty#getIntervalUnit}
             * @param intervalUnit The unit of time in which to measure the *Interval* . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intervalUnit(java.lang.String intervalUnit) {
                this.intervalUnit = intervalUnit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CrossRegionCopyDeprecateRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CrossRegionCopyDeprecateRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CrossRegionCopyDeprecateRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CrossRegionCopyDeprecateRuleProperty {
            private final java.lang.Number interval;
            private final java.lang.String intervalUnit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.interval = software.amazon.jsii.Kernel.get(this, "interval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.intervalUnit = software.amazon.jsii.Kernel.get(this, "intervalUnit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.interval = java.util.Objects.requireNonNull(builder.interval, "interval is required");
                this.intervalUnit = java.util.Objects.requireNonNull(builder.intervalUnit, "intervalUnit is required");
            }

            @Override
            public final java.lang.Number getInterval() {
                return this.interval;
            }

            @Override
            public final java.lang.String getIntervalUnit() {
                return this.intervalUnit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("interval", om.valueToTree(this.getInterval()));
                data.set("intervalUnit", om.valueToTree(this.getIntervalUnit()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.CrossRegionCopyDeprecateRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CrossRegionCopyDeprecateRuleProperty.Jsii$Proxy that = (CrossRegionCopyDeprecateRuleProperty.Jsii$Proxy) o;

                if (!interval.equals(that.interval)) return false;
                return this.intervalUnit.equals(that.intervalUnit);
            }

            @Override
            public final int hashCode() {
                int result = this.interval.hashCode();
                result = 31 * result + (this.intervalUnit.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies the retention rule for cross-Region snapshot copies.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * CrossRegionCopyRetainRuleProperty crossRegionCopyRetainRuleProperty = CrossRegionCopyRetainRuleProperty.builder()
     *         .interval(123)
     *         .intervalUnit("intervalUnit")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.CrossRegionCopyRetainRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(CrossRegionCopyRetainRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CrossRegionCopyRetainRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The amount of time to retain each snapshot.
         * <p>
         * The maximum is 100 years. This is equivalent to 1200 months, 5200 weeks, or 36500 days.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getInterval();

        /**
         * The unit of time for time-based retention.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIntervalUnit();

        /**
         * @return a {@link Builder} of {@link CrossRegionCopyRetainRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CrossRegionCopyRetainRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CrossRegionCopyRetainRuleProperty> {
            java.lang.Number interval;
            java.lang.String intervalUnit;

            /**
             * Sets the value of {@link CrossRegionCopyRetainRuleProperty#getInterval}
             * @param interval The amount of time to retain each snapshot. This parameter is required.
             *                 The maximum is 100 years. This is equivalent to 1200 months, 5200 weeks, or 36500 days.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interval(java.lang.Number interval) {
                this.interval = interval;
                return this;
            }

            /**
             * Sets the value of {@link CrossRegionCopyRetainRuleProperty#getIntervalUnit}
             * @param intervalUnit The unit of time for time-based retention. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intervalUnit(java.lang.String intervalUnit) {
                this.intervalUnit = intervalUnit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CrossRegionCopyRetainRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CrossRegionCopyRetainRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CrossRegionCopyRetainRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CrossRegionCopyRetainRuleProperty {
            private final java.lang.Number interval;
            private final java.lang.String intervalUnit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.interval = software.amazon.jsii.Kernel.get(this, "interval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.intervalUnit = software.amazon.jsii.Kernel.get(this, "intervalUnit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.interval = java.util.Objects.requireNonNull(builder.interval, "interval is required");
                this.intervalUnit = java.util.Objects.requireNonNull(builder.intervalUnit, "intervalUnit is required");
            }

            @Override
            public final java.lang.Number getInterval() {
                return this.interval;
            }

            @Override
            public final java.lang.String getIntervalUnit() {
                return this.intervalUnit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("interval", om.valueToTree(this.getInterval()));
                data.set("intervalUnit", om.valueToTree(this.getIntervalUnit()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.CrossRegionCopyRetainRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CrossRegionCopyRetainRuleProperty.Jsii$Proxy that = (CrossRegionCopyRetainRuleProperty.Jsii$Proxy) o;

                if (!interval.equals(that.interval)) return false;
                return this.intervalUnit.equals(that.intervalUnit);
            }

            @Override
            public final int hashCode() {
                int result = this.interval.hashCode();
                result = 31 * result + (this.intervalUnit.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies a rule for cross-Region snapshot copies.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * CrossRegionCopyRuleProperty crossRegionCopyRuleProperty = CrossRegionCopyRuleProperty.builder()
     *         .encrypted(false)
     *         // the properties below are optional
     *         .cmkArn("cmkArn")
     *         .copyTags(false)
     *         .deprecateRule(CrossRegionCopyDeprecateRuleProperty.builder()
     *                 .interval(123)
     *                 .intervalUnit("intervalUnit")
     *                 .build())
     *         .retainRule(CrossRegionCopyRetainRuleProperty.builder()
     *                 .interval(123)
     *                 .intervalUnit("intervalUnit")
     *                 .build())
     *         .target("target")
     *         .targetRegion("targetRegion")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.CrossRegionCopyRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(CrossRegionCopyRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CrossRegionCopyRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled, enable encryption using this parameter.
         * <p>
         * Copies of encrypted snapshots are encrypted, even if this parameter is false or if encryption by default is not enabled.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEncrypted();

        /**
         * The Amazon Resource Name (ARN) of the AWS KMS key to use for EBS encryption.
         * <p>
         * If this parameter is not specified, the default KMS key for the account is used.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCmkArn() {
            return null;
        }

        /**
         * Indicates whether to copy all user-defined tags from the source snapshot to the cross-Region snapshot copy.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCopyTags() {
            return null;
        }

        /**
         * The AMI deprecation rule for cross-Region AMI copies created by the rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeprecateRule() {
            return null;
        }

        /**
         * The retention rule that indicates how long snapshot copies are to be retained in the destination Region.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetainRule() {
            return null;
        }

        /**
         * The target Region or the Amazon Resource Name (ARN) of the target Outpost for the snapshot copies.
         * <p>
         * Use this parameter instead of <em>TargetRegion</em> . Do not specify both.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTarget() {
            return null;
        }

        /**
         * Avoid using this parameter when creating new policies.
         * <p>
         * Instead, use <em>Target</em> to specify a target Region or a target Outpost for snapshot copies.
         * <p>
         * For policies created before the <em>Target</em> parameter was introduced, this parameter indicates the target Region for snapshot copies.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetRegion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CrossRegionCopyRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CrossRegionCopyRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CrossRegionCopyRuleProperty> {
            java.lang.Object encrypted;
            java.lang.String cmkArn;
            java.lang.Object copyTags;
            java.lang.Object deprecateRule;
            java.lang.Object retainRule;
            java.lang.String target;
            java.lang.String targetRegion;

            /**
             * Sets the value of {@link CrossRegionCopyRuleProperty#getEncrypted}
             * @param encrypted To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled, enable encryption using this parameter. This parameter is required.
             *                  Copies of encrypted snapshots are encrypted, even if this parameter is false or if encryption by default is not enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encrypted(java.lang.Boolean encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            /**
             * Sets the value of {@link CrossRegionCopyRuleProperty#getEncrypted}
             * @param encrypted To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled, enable encryption using this parameter. This parameter is required.
             *                  Copies of encrypted snapshots are encrypted, even if this parameter is false or if encryption by default is not enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encrypted(software.amazon.awscdk.IResolvable encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            /**
             * Sets the value of {@link CrossRegionCopyRuleProperty#getCmkArn}
             * @param cmkArn The Amazon Resource Name (ARN) of the AWS KMS key to use for EBS encryption.
             *               If this parameter is not specified, the default KMS key for the account is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cmkArn(java.lang.String cmkArn) {
                this.cmkArn = cmkArn;
                return this;
            }

            /**
             * Sets the value of {@link CrossRegionCopyRuleProperty#getCopyTags}
             * @param copyTags Indicates whether to copy all user-defined tags from the source snapshot to the cross-Region snapshot copy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyTags(java.lang.Boolean copyTags) {
                this.copyTags = copyTags;
                return this;
            }

            /**
             * Sets the value of {@link CrossRegionCopyRuleProperty#getCopyTags}
             * @param copyTags Indicates whether to copy all user-defined tags from the source snapshot to the cross-Region snapshot copy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyTags(software.amazon.awscdk.IResolvable copyTags) {
                this.copyTags = copyTags;
                return this;
            }

            /**
             * Sets the value of {@link CrossRegionCopyRuleProperty#getDeprecateRule}
             * @param deprecateRule The AMI deprecation rule for cross-Region AMI copies created by the rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deprecateRule(software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.CrossRegionCopyDeprecateRuleProperty deprecateRule) {
                this.deprecateRule = deprecateRule;
                return this;
            }

            /**
             * Sets the value of {@link CrossRegionCopyRuleProperty#getDeprecateRule}
             * @param deprecateRule The AMI deprecation rule for cross-Region AMI copies created by the rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deprecateRule(software.amazon.awscdk.IResolvable deprecateRule) {
                this.deprecateRule = deprecateRule;
                return this;
            }

            /**
             * Sets the value of {@link CrossRegionCopyRuleProperty#getRetainRule}
             * @param retainRule The retention rule that indicates how long snapshot copies are to be retained in the destination Region.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retainRule(software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.CrossRegionCopyRetainRuleProperty retainRule) {
                this.retainRule = retainRule;
                return this;
            }

            /**
             * Sets the value of {@link CrossRegionCopyRuleProperty#getRetainRule}
             * @param retainRule The retention rule that indicates how long snapshot copies are to be retained in the destination Region.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retainRule(software.amazon.awscdk.IResolvable retainRule) {
                this.retainRule = retainRule;
                return this;
            }

            /**
             * Sets the value of {@link CrossRegionCopyRuleProperty#getTarget}
             * @param target The target Region or the Amazon Resource Name (ARN) of the target Outpost for the snapshot copies.
             *               Use this parameter instead of <em>TargetRegion</em> . Do not specify both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder target(java.lang.String target) {
                this.target = target;
                return this;
            }

            /**
             * Sets the value of {@link CrossRegionCopyRuleProperty#getTargetRegion}
             * @param targetRegion Avoid using this parameter when creating new policies.
             *                     Instead, use <em>Target</em> to specify a target Region or a target Outpost for snapshot copies.
             *                     <p>
             *                     For policies created before the <em>Target</em> parameter was introduced, this parameter indicates the target Region for snapshot copies.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetRegion(java.lang.String targetRegion) {
                this.targetRegion = targetRegion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CrossRegionCopyRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CrossRegionCopyRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CrossRegionCopyRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CrossRegionCopyRuleProperty {
            private final java.lang.Object encrypted;
            private final java.lang.String cmkArn;
            private final java.lang.Object copyTags;
            private final java.lang.Object deprecateRule;
            private final java.lang.Object retainRule;
            private final java.lang.String target;
            private final java.lang.String targetRegion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encrypted = software.amazon.jsii.Kernel.get(this, "encrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cmkArn = software.amazon.jsii.Kernel.get(this, "cmkArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.copyTags = software.amazon.jsii.Kernel.get(this, "copyTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.deprecateRule = software.amazon.jsii.Kernel.get(this, "deprecateRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.retainRule = software.amazon.jsii.Kernel.get(this, "retainRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetRegion = software.amazon.jsii.Kernel.get(this, "targetRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encrypted = java.util.Objects.requireNonNull(builder.encrypted, "encrypted is required");
                this.cmkArn = builder.cmkArn;
                this.copyTags = builder.copyTags;
                this.deprecateRule = builder.deprecateRule;
                this.retainRule = builder.retainRule;
                this.target = builder.target;
                this.targetRegion = builder.targetRegion;
            }

            @Override
            public final java.lang.Object getEncrypted() {
                return this.encrypted;
            }

            @Override
            public final java.lang.String getCmkArn() {
                return this.cmkArn;
            }

            @Override
            public final java.lang.Object getCopyTags() {
                return this.copyTags;
            }

            @Override
            public final java.lang.Object getDeprecateRule() {
                return this.deprecateRule;
            }

            @Override
            public final java.lang.Object getRetainRule() {
                return this.retainRule;
            }

            @Override
            public final java.lang.String getTarget() {
                return this.target;
            }

            @Override
            public final java.lang.String getTargetRegion() {
                return this.targetRegion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("encrypted", om.valueToTree(this.getEncrypted()));
                if (this.getCmkArn() != null) {
                    data.set("cmkArn", om.valueToTree(this.getCmkArn()));
                }
                if (this.getCopyTags() != null) {
                    data.set("copyTags", om.valueToTree(this.getCopyTags()));
                }
                if (this.getDeprecateRule() != null) {
                    data.set("deprecateRule", om.valueToTree(this.getDeprecateRule()));
                }
                if (this.getRetainRule() != null) {
                    data.set("retainRule", om.valueToTree(this.getRetainRule()));
                }
                if (this.getTarget() != null) {
                    data.set("target", om.valueToTree(this.getTarget()));
                }
                if (this.getTargetRegion() != null) {
                    data.set("targetRegion", om.valueToTree(this.getTargetRegion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.CrossRegionCopyRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CrossRegionCopyRuleProperty.Jsii$Proxy that = (CrossRegionCopyRuleProperty.Jsii$Proxy) o;

                if (!encrypted.equals(that.encrypted)) return false;
                if (this.cmkArn != null ? !this.cmkArn.equals(that.cmkArn) : that.cmkArn != null) return false;
                if (this.copyTags != null ? !this.copyTags.equals(that.copyTags) : that.copyTags != null) return false;
                if (this.deprecateRule != null ? !this.deprecateRule.equals(that.deprecateRule) : that.deprecateRule != null) return false;
                if (this.retainRule != null ? !this.retainRule.equals(that.retainRule) : that.retainRule != null) return false;
                if (this.target != null ? !this.target.equals(that.target) : that.target != null) return false;
                return this.targetRegion != null ? this.targetRegion.equals(that.targetRegion) : that.targetRegion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.encrypted.hashCode();
                result = 31 * result + (this.cmkArn != null ? this.cmkArn.hashCode() : 0);
                result = 31 * result + (this.copyTags != null ? this.copyTags.hashCode() : 0);
                result = 31 * result + (this.deprecateRule != null ? this.deprecateRule.hashCode() : 0);
                result = 31 * result + (this.retainRule != null ? this.retainRule.hashCode() : 0);
                result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
                result = 31 * result + (this.targetRegion != null ? this.targetRegion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies an AMI deprecation rule for a schedule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * DeprecateRuleProperty deprecateRuleProperty = DeprecateRuleProperty.builder()
     *         .count(123)
     *         .interval(123)
     *         .intervalUnit("intervalUnit")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.DeprecateRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(DeprecateRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeprecateRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If the schedule has a count-based retention rule, this parameter specifies the number of oldest AMIs to deprecate.
         * <p>
         * The count must be less than or equal to the schedule's retention count, and it can't be greater than 1000.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCount() {
            return null;
        }

        /**
         * If the schedule has an age-based retention rule, this parameter specifies the period after which to deprecate AMIs created by the schedule.
         * <p>
         * The period must be less than or equal to the schedule's retention period, and it can't be greater than 10 years. This is equivalent to 120 months, 520 weeks, or 3650 days.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInterval() {
            return null;
        }

        /**
         * The unit of time in which to measure the *Interval* .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIntervalUnit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeprecateRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeprecateRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeprecateRuleProperty> {
            java.lang.Number count;
            java.lang.Number interval;
            java.lang.String intervalUnit;

            /**
             * Sets the value of {@link DeprecateRuleProperty#getCount}
             * @param count If the schedule has a count-based retention rule, this parameter specifies the number of oldest AMIs to deprecate.
             *              The count must be less than or equal to the schedule's retention count, and it can't be greater than 1000.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder count(java.lang.Number count) {
                this.count = count;
                return this;
            }

            /**
             * Sets the value of {@link DeprecateRuleProperty#getInterval}
             * @param interval If the schedule has an age-based retention rule, this parameter specifies the period after which to deprecate AMIs created by the schedule.
             *                 The period must be less than or equal to the schedule's retention period, and it can't be greater than 10 years. This is equivalent to 120 months, 520 weeks, or 3650 days.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interval(java.lang.Number interval) {
                this.interval = interval;
                return this;
            }

            /**
             * Sets the value of {@link DeprecateRuleProperty#getIntervalUnit}
             * @param intervalUnit The unit of time in which to measure the *Interval* .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intervalUnit(java.lang.String intervalUnit) {
                this.intervalUnit = intervalUnit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeprecateRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeprecateRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeprecateRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeprecateRuleProperty {
            private final java.lang.Number count;
            private final java.lang.Number interval;
            private final java.lang.String intervalUnit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.count = software.amazon.jsii.Kernel.get(this, "count", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.interval = software.amazon.jsii.Kernel.get(this, "interval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.intervalUnit = software.amazon.jsii.Kernel.get(this, "intervalUnit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.count = builder.count;
                this.interval = builder.interval;
                this.intervalUnit = builder.intervalUnit;
            }

            @Override
            public final java.lang.Number getCount() {
                return this.count;
            }

            @Override
            public final java.lang.Number getInterval() {
                return this.interval;
            }

            @Override
            public final java.lang.String getIntervalUnit() {
                return this.intervalUnit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCount() != null) {
                    data.set("count", om.valueToTree(this.getCount()));
                }
                if (this.getInterval() != null) {
                    data.set("interval", om.valueToTree(this.getInterval()));
                }
                if (this.getIntervalUnit() != null) {
                    data.set("intervalUnit", om.valueToTree(this.getIntervalUnit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.DeprecateRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeprecateRuleProperty.Jsii$Proxy that = (DeprecateRuleProperty.Jsii$Proxy) o;

                if (this.count != null ? !this.count.equals(that.count) : that.count != null) return false;
                if (this.interval != null ? !this.interval.equals(that.interval) : that.interval != null) return false;
                return this.intervalUnit != null ? this.intervalUnit.equals(that.intervalUnit) : that.intervalUnit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.count != null ? this.count.hashCode() : 0;
                result = 31 * result + (this.interval != null ? this.interval.hashCode() : 0);
                result = 31 * result + (this.intervalUnit != null ? this.intervalUnit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the encryption settings for shared snapshots that are copied across Regions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * EncryptionConfigurationProperty encryptionConfigurationProperty = EncryptionConfigurationProperty.builder()
     *         .encrypted(false)
     *         // the properties below are optional
     *         .cmkArn("cmkArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.EncryptionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * To encrypt a copy of an unencrypted snapshot when encryption by default is not enabled, enable encryption using this parameter.
         * <p>
         * Copies of encrypted snapshots are encrypted, even if this parameter is false or when encryption by default is not enabled.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEncrypted();

        /**
         * The Amazon Resource Name (ARN) of the AWS KMS key to use for EBS encryption.
         * <p>
         * If this parameter is not specified, the default KMS key for the account is used.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCmkArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionConfigurationProperty> {
            java.lang.Object encrypted;
            java.lang.String cmkArn;

            /**
             * Sets the value of {@link EncryptionConfigurationProperty#getEncrypted}
             * @param encrypted To encrypt a copy of an unencrypted snapshot when encryption by default is not enabled, enable encryption using this parameter. This parameter is required.
             *                  Copies of encrypted snapshots are encrypted, even if this parameter is false or when encryption by default is not enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encrypted(java.lang.Boolean encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionConfigurationProperty#getEncrypted}
             * @param encrypted To encrypt a copy of an unencrypted snapshot when encryption by default is not enabled, enable encryption using this parameter. This parameter is required.
             *                  Copies of encrypted snapshots are encrypted, even if this parameter is false or when encryption by default is not enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encrypted(software.amazon.awscdk.IResolvable encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionConfigurationProperty#getCmkArn}
             * @param cmkArn The Amazon Resource Name (ARN) of the AWS KMS key to use for EBS encryption.
             *               If this parameter is not specified, the default KMS key for the account is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cmkArn(java.lang.String cmkArn) {
                this.cmkArn = cmkArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionConfigurationProperty {
            private final java.lang.Object encrypted;
            private final java.lang.String cmkArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encrypted = software.amazon.jsii.Kernel.get(this, "encrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cmkArn = software.amazon.jsii.Kernel.get(this, "cmkArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encrypted = java.util.Objects.requireNonNull(builder.encrypted, "encrypted is required");
                this.cmkArn = builder.cmkArn;
            }

            @Override
            public final java.lang.Object getEncrypted() {
                return this.encrypted;
            }

            @Override
            public final java.lang.String getCmkArn() {
                return this.cmkArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("encrypted", om.valueToTree(this.getEncrypted()));
                if (this.getCmkArn() != null) {
                    data.set("cmkArn", om.valueToTree(this.getCmkArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.EncryptionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionConfigurationProperty.Jsii$Proxy that = (EncryptionConfigurationProperty.Jsii$Proxy) o;

                if (!encrypted.equals(that.encrypted)) return false;
                return this.cmkArn != null ? this.cmkArn.equals(that.cmkArn) : that.cmkArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.encrypted.hashCode();
                result = 31 * result + (this.cmkArn != null ? this.cmkArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies an event that triggers an event-based policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * EventParametersProperty eventParametersProperty = EventParametersProperty.builder()
     *         .eventType("eventType")
     *         .snapshotOwner(List.of("snapshotOwner"))
     *         // the properties below are optional
     *         .descriptionRegex("descriptionRegex")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.EventParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(EventParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of event.
         * <p>
         * Currently, only snapshot sharing events are supported.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEventType();

        /**
         * The IDs of the AWS accounts that can trigger policy by sharing snapshots with your account.
         * <p>
         * The policy only runs if one of the specified AWS accounts shares a snapshot with your account.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSnapshotOwner();

        /**
         * The snapshot description that can trigger the policy.
         * <p>
         * The description pattern is specified using a regular expression. The policy runs only if a snapshot with a description that matches the specified pattern is shared with your account.
         * <p>
         * For example, specifying <code>^.*Created for policy: policy-1234567890abcdef0.*$</code> configures the policy to run only if snapshots created by policy <code>policy-1234567890abcdef0</code> are shared with your account.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescriptionRegex() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EventParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventParametersProperty> {
            java.lang.String eventType;
            java.util.List<java.lang.String> snapshotOwner;
            java.lang.String descriptionRegex;

            /**
             * Sets the value of {@link EventParametersProperty#getEventType}
             * @param eventType The type of event. This parameter is required.
             *                  Currently, only snapshot sharing events are supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventType(java.lang.String eventType) {
                this.eventType = eventType;
                return this;
            }

            /**
             * Sets the value of {@link EventParametersProperty#getSnapshotOwner}
             * @param snapshotOwner The IDs of the AWS accounts that can trigger policy by sharing snapshots with your account. This parameter is required.
             *                      The policy only runs if one of the specified AWS accounts shares a snapshot with your account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snapshotOwner(java.util.List<java.lang.String> snapshotOwner) {
                this.snapshotOwner = snapshotOwner;
                return this;
            }

            /**
             * Sets the value of {@link EventParametersProperty#getDescriptionRegex}
             * @param descriptionRegex The snapshot description that can trigger the policy.
             *                         The description pattern is specified using a regular expression. The policy runs only if a snapshot with a description that matches the specified pattern is shared with your account.
             *                         <p>
             *                         For example, specifying <code>^.*Created for policy: policy-1234567890abcdef0.*$</code> configures the policy to run only if snapshots created by policy <code>policy-1234567890abcdef0</code> are shared with your account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder descriptionRegex(java.lang.String descriptionRegex) {
                this.descriptionRegex = descriptionRegex;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventParametersProperty {
            private final java.lang.String eventType;
            private final java.util.List<java.lang.String> snapshotOwner;
            private final java.lang.String descriptionRegex;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.eventType = software.amazon.jsii.Kernel.get(this, "eventType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.snapshotOwner = software.amazon.jsii.Kernel.get(this, "snapshotOwner", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.descriptionRegex = software.amazon.jsii.Kernel.get(this, "descriptionRegex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.eventType = java.util.Objects.requireNonNull(builder.eventType, "eventType is required");
                this.snapshotOwner = java.util.Objects.requireNonNull(builder.snapshotOwner, "snapshotOwner is required");
                this.descriptionRegex = builder.descriptionRegex;
            }

            @Override
            public final java.lang.String getEventType() {
                return this.eventType;
            }

            @Override
            public final java.util.List<java.lang.String> getSnapshotOwner() {
                return this.snapshotOwner;
            }

            @Override
            public final java.lang.String getDescriptionRegex() {
                return this.descriptionRegex;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("eventType", om.valueToTree(this.getEventType()));
                data.set("snapshotOwner", om.valueToTree(this.getSnapshotOwner()));
                if (this.getDescriptionRegex() != null) {
                    data.set("descriptionRegex", om.valueToTree(this.getDescriptionRegex()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.EventParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventParametersProperty.Jsii$Proxy that = (EventParametersProperty.Jsii$Proxy) o;

                if (!eventType.equals(that.eventType)) return false;
                if (!snapshotOwner.equals(that.snapshotOwner)) return false;
                return this.descriptionRegex != null ? this.descriptionRegex.equals(that.descriptionRegex) : that.descriptionRegex == null;
            }

            @Override
            public final int hashCode() {
                int result = this.eventType.hashCode();
                result = 31 * result + (this.snapshotOwner.hashCode());
                result = 31 * result + (this.descriptionRegex != null ? this.descriptionRegex.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies an event that triggers an event-based policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * EventSourceProperty eventSourceProperty = EventSourceProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .parameters(EventParametersProperty.builder()
     *                 .eventType("eventType")
     *                 .snapshotOwner(List.of("snapshotOwner"))
     *                 // the properties below are optional
     *                 .descriptionRegex("descriptionRegex")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.EventSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(EventSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The source of the event.
         * <p>
         * Currently only managed CloudWatch Events rules are supported.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Information about the event.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EventSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventSourceProperty> {
            java.lang.String type;
            java.lang.Object parameters;

            /**
             * Sets the value of {@link EventSourceProperty#getType}
             * @param type The source of the event. This parameter is required.
             *             Currently only managed CloudWatch Events rules are supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getParameters}
             * @param parameters Information about the event.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.EventParametersProperty parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getParameters}
             * @param parameters Information about the event.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(software.amazon.awscdk.IResolvable parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventSourceProperty {
            private final java.lang.String type;
            private final java.lang.Object parameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.parameters = builder.parameters;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getParameters() {
                return this.parameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getParameters() != null) {
                    data.set("parameters", om.valueToTree(this.getParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.EventSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventSourceProperty.Jsii$Proxy that = (EventSourceProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.parameters != null ? this.parameters.equals(that.parameters) : that.parameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a rule for enabling fast snapshot restore.
     * <p>
     * You can enable fast snapshot restore based on either a count or a time interval.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * FastRestoreRuleProperty fastRestoreRuleProperty = FastRestoreRuleProperty.builder()
     *         .availabilityZones(List.of("availabilityZones"))
     *         .count(123)
     *         .interval(123)
     *         .intervalUnit("intervalUnit")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.FastRestoreRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(FastRestoreRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FastRestoreRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Availability Zones in which to enable fast snapshot restore.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAvailabilityZones() {
            return null;
        }

        /**
         * The number of snapshots to be enabled with fast snapshot restore.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCount() {
            return null;
        }

        /**
         * The amount of time to enable fast snapshot restore.
         * <p>
         * The maximum is 100 years. This is equivalent to 1200 months, 5200 weeks, or 36500 days.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInterval() {
            return null;
        }

        /**
         * The unit of time for enabling fast snapshot restore.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIntervalUnit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FastRestoreRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FastRestoreRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FastRestoreRuleProperty> {
            java.util.List<java.lang.String> availabilityZones;
            java.lang.Number count;
            java.lang.Number interval;
            java.lang.String intervalUnit;

            /**
             * Sets the value of {@link FastRestoreRuleProperty#getAvailabilityZones}
             * @param availabilityZones The Availability Zones in which to enable fast snapshot restore.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityZones(java.util.List<java.lang.String> availabilityZones) {
                this.availabilityZones = availabilityZones;
                return this;
            }

            /**
             * Sets the value of {@link FastRestoreRuleProperty#getCount}
             * @param count The number of snapshots to be enabled with fast snapshot restore.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder count(java.lang.Number count) {
                this.count = count;
                return this;
            }

            /**
             * Sets the value of {@link FastRestoreRuleProperty#getInterval}
             * @param interval The amount of time to enable fast snapshot restore.
             *                 The maximum is 100 years. This is equivalent to 1200 months, 5200 weeks, or 36500 days.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interval(java.lang.Number interval) {
                this.interval = interval;
                return this;
            }

            /**
             * Sets the value of {@link FastRestoreRuleProperty#getIntervalUnit}
             * @param intervalUnit The unit of time for enabling fast snapshot restore.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intervalUnit(java.lang.String intervalUnit) {
                this.intervalUnit = intervalUnit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FastRestoreRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FastRestoreRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FastRestoreRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FastRestoreRuleProperty {
            private final java.util.List<java.lang.String> availabilityZones;
            private final java.lang.Number count;
            private final java.lang.Number interval;
            private final java.lang.String intervalUnit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.availabilityZones = software.amazon.jsii.Kernel.get(this, "availabilityZones", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.count = software.amazon.jsii.Kernel.get(this, "count", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.interval = software.amazon.jsii.Kernel.get(this, "interval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.intervalUnit = software.amazon.jsii.Kernel.get(this, "intervalUnit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.availabilityZones = builder.availabilityZones;
                this.count = builder.count;
                this.interval = builder.interval;
                this.intervalUnit = builder.intervalUnit;
            }

            @Override
            public final java.util.List<java.lang.String> getAvailabilityZones() {
                return this.availabilityZones;
            }

            @Override
            public final java.lang.Number getCount() {
                return this.count;
            }

            @Override
            public final java.lang.Number getInterval() {
                return this.interval;
            }

            @Override
            public final java.lang.String getIntervalUnit() {
                return this.intervalUnit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAvailabilityZones() != null) {
                    data.set("availabilityZones", om.valueToTree(this.getAvailabilityZones()));
                }
                if (this.getCount() != null) {
                    data.set("count", om.valueToTree(this.getCount()));
                }
                if (this.getInterval() != null) {
                    data.set("interval", om.valueToTree(this.getInterval()));
                }
                if (this.getIntervalUnit() != null) {
                    data.set("intervalUnit", om.valueToTree(this.getIntervalUnit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.FastRestoreRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FastRestoreRuleProperty.Jsii$Proxy that = (FastRestoreRuleProperty.Jsii$Proxy) o;

                if (this.availabilityZones != null ? !this.availabilityZones.equals(that.availabilityZones) : that.availabilityZones != null) return false;
                if (this.count != null ? !this.count.equals(that.count) : that.count != null) return false;
                if (this.interval != null ? !this.interval.equals(that.interval) : that.interval != null) return false;
                return this.intervalUnit != null ? this.intervalUnit.equals(that.intervalUnit) : that.intervalUnit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.availabilityZones != null ? this.availabilityZones.hashCode() : 0;
                result = 31 * result + (this.count != null ? this.count.hashCode() : 0);
                result = 31 * result + (this.interval != null ? this.interval.hashCode() : 0);
                result = 31 * result + (this.intervalUnit != null ? this.intervalUnit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies optional parameters to add to a policy.
     * <p>
     * The set of valid parameters depends on the combination of policy type and resource type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * ParametersProperty parametersProperty = ParametersProperty.builder()
     *         .excludeBootVolume(false)
     *         .excludeDataVolumeTags(List.of(CfnTag.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .noReboot(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.ParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(ParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * [EBS Snapshot Management – Instance policies only] Indicates whether to exclude the root volume from snapshots created using [CreateSnapshots](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSnapshots.html) . The default is false.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExcludeBootVolume() {
            return null;
        }

        /**
         * `CfnLifecyclePolicy.ParametersProperty.ExcludeDataVolumeTags`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExcludeDataVolumeTags() {
            return null;
        }

        /**
         * Applies to AMI lifecycle policies only.
         * <p>
         * Indicates whether targeted instances are rebooted when the lifecycle policy runs. <code>true</code> indicates that targeted instances are not rebooted when the policy runs. <code>false</code> indicates that target instances are rebooted when the policy runs. The default is <code>true</code> (instances are not rebooted).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNoReboot() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParametersProperty> {
            java.lang.Object excludeBootVolume;
            java.lang.Object excludeDataVolumeTags;
            java.lang.Object noReboot;

            /**
             * Sets the value of {@link ParametersProperty#getExcludeBootVolume}
             * @param excludeBootVolume [EBS Snapshot Management – Instance policies only] Indicates whether to exclude the root volume from snapshots created using [CreateSnapshots](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSnapshots.html) . The default is false.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeBootVolume(java.lang.Boolean excludeBootVolume) {
                this.excludeBootVolume = excludeBootVolume;
                return this;
            }

            /**
             * Sets the value of {@link ParametersProperty#getExcludeBootVolume}
             * @param excludeBootVolume [EBS Snapshot Management – Instance policies only] Indicates whether to exclude the root volume from snapshots created using [CreateSnapshots](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSnapshots.html) . The default is false.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeBootVolume(software.amazon.awscdk.IResolvable excludeBootVolume) {
                this.excludeBootVolume = excludeBootVolume;
                return this;
            }

            /**
             * Sets the value of {@link ParametersProperty#getExcludeDataVolumeTags}
             * @param excludeDataVolumeTags `CfnLifecyclePolicy.ParametersProperty.ExcludeDataVolumeTags`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeDataVolumeTags(software.amazon.awscdk.IResolvable excludeDataVolumeTags) {
                this.excludeDataVolumeTags = excludeDataVolumeTags;
                return this;
            }

            /**
             * Sets the value of {@link ParametersProperty#getExcludeDataVolumeTags}
             * @param excludeDataVolumeTags `CfnLifecyclePolicy.ParametersProperty.ExcludeDataVolumeTags`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeDataVolumeTags(java.util.List<? extends java.lang.Object> excludeDataVolumeTags) {
                this.excludeDataVolumeTags = excludeDataVolumeTags;
                return this;
            }

            /**
             * Sets the value of {@link ParametersProperty#getNoReboot}
             * @param noReboot Applies to AMI lifecycle policies only.
             *                 Indicates whether targeted instances are rebooted when the lifecycle policy runs. <code>true</code> indicates that targeted instances are not rebooted when the policy runs. <code>false</code> indicates that target instances are rebooted when the policy runs. The default is <code>true</code> (instances are not rebooted).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noReboot(java.lang.Boolean noReboot) {
                this.noReboot = noReboot;
                return this;
            }

            /**
             * Sets the value of {@link ParametersProperty#getNoReboot}
             * @param noReboot Applies to AMI lifecycle policies only.
             *                 Indicates whether targeted instances are rebooted when the lifecycle policy runs. <code>true</code> indicates that targeted instances are not rebooted when the policy runs. <code>false</code> indicates that target instances are rebooted when the policy runs. The default is <code>true</code> (instances are not rebooted).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noReboot(software.amazon.awscdk.IResolvable noReboot) {
                this.noReboot = noReboot;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParametersProperty {
            private final java.lang.Object excludeBootVolume;
            private final java.lang.Object excludeDataVolumeTags;
            private final java.lang.Object noReboot;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.excludeBootVolume = software.amazon.jsii.Kernel.get(this, "excludeBootVolume", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.excludeDataVolumeTags = software.amazon.jsii.Kernel.get(this, "excludeDataVolumeTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.noReboot = software.amazon.jsii.Kernel.get(this, "noReboot", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.excludeBootVolume = builder.excludeBootVolume;
                this.excludeDataVolumeTags = builder.excludeDataVolumeTags;
                this.noReboot = builder.noReboot;
            }

            @Override
            public final java.lang.Object getExcludeBootVolume() {
                return this.excludeBootVolume;
            }

            @Override
            public final java.lang.Object getExcludeDataVolumeTags() {
                return this.excludeDataVolumeTags;
            }

            @Override
            public final java.lang.Object getNoReboot() {
                return this.noReboot;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExcludeBootVolume() != null) {
                    data.set("excludeBootVolume", om.valueToTree(this.getExcludeBootVolume()));
                }
                if (this.getExcludeDataVolumeTags() != null) {
                    data.set("excludeDataVolumeTags", om.valueToTree(this.getExcludeDataVolumeTags()));
                }
                if (this.getNoReboot() != null) {
                    data.set("noReboot", om.valueToTree(this.getNoReboot()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.ParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParametersProperty.Jsii$Proxy that = (ParametersProperty.Jsii$Proxy) o;

                if (this.excludeBootVolume != null ? !this.excludeBootVolume.equals(that.excludeBootVolume) : that.excludeBootVolume != null) return false;
                if (this.excludeDataVolumeTags != null ? !this.excludeDataVolumeTags.equals(that.excludeDataVolumeTags) : that.excludeDataVolumeTags != null) return false;
                return this.noReboot != null ? this.noReboot.equals(that.noReboot) : that.noReboot == null;
            }

            @Override
            public final int hashCode() {
                int result = this.excludeBootVolume != null ? this.excludeBootVolume.hashCode() : 0;
                result = 31 * result + (this.excludeDataVolumeTags != null ? this.excludeDataVolumeTags.hashCode() : 0);
                result = 31 * result + (this.noReboot != null ? this.noReboot.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the configuration of a lifecycle policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * PolicyDetailsProperty policyDetailsProperty = PolicyDetailsProperty.builder()
     *         .actions(List.of(ActionProperty.builder()
     *                 .crossRegionCopy(List.of(CrossRegionCopyActionProperty.builder()
     *                         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                                 .encrypted(false)
     *                                 // the properties below are optional
     *                                 .cmkArn("cmkArn")
     *                                 .build())
     *                         .target("target")
     *                         // the properties below are optional
     *                         .retainRule(CrossRegionCopyRetainRuleProperty.builder()
     *                                 .interval(123)
     *                                 .intervalUnit("intervalUnit")
     *                                 .build())
     *                         .build()))
     *                 .name("name")
     *                 .build()))
     *         .eventSource(EventSourceProperty.builder()
     *                 .type("type")
     *                 // the properties below are optional
     *                 .parameters(EventParametersProperty.builder()
     *                         .eventType("eventType")
     *                         .snapshotOwner(List.of("snapshotOwner"))
     *                         // the properties below are optional
     *                         .descriptionRegex("descriptionRegex")
     *                         .build())
     *                 .build())
     *         .parameters(ParametersProperty.builder()
     *                 .excludeBootVolume(false)
     *                 .excludeDataVolumeTags(List.of(CfnTag.builder()
     *                         .key("key")
     *                         .value("value")
     *                         .build()))
     *                 .noReboot(false)
     *                 .build())
     *         .policyType("policyType")
     *         .resourceLocations(List.of("resourceLocations"))
     *         .resourceTypes(List.of("resourceTypes"))
     *         .schedules(List.of(ScheduleProperty.builder()
     *                 .copyTags(false)
     *                 .createRule(CreateRuleProperty.builder()
     *                         .cronExpression("cronExpression")
     *                         .interval(123)
     *                         .intervalUnit("intervalUnit")
     *                         .location("location")
     *                         .times(List.of("times"))
     *                         .build())
     *                 .crossRegionCopyRules(List.of(CrossRegionCopyRuleProperty.builder()
     *                         .encrypted(false)
     *                         // the properties below are optional
     *                         .cmkArn("cmkArn")
     *                         .copyTags(false)
     *                         .deprecateRule(CrossRegionCopyDeprecateRuleProperty.builder()
     *                                 .interval(123)
     *                                 .intervalUnit("intervalUnit")
     *                                 .build())
     *                         .retainRule(CrossRegionCopyRetainRuleProperty.builder()
     *                                 .interval(123)
     *                                 .intervalUnit("intervalUnit")
     *                                 .build())
     *                         .target("target")
     *                         .targetRegion("targetRegion")
     *                         .build()))
     *                 .deprecateRule(DeprecateRuleProperty.builder()
     *                         .count(123)
     *                         .interval(123)
     *                         .intervalUnit("intervalUnit")
     *                         .build())
     *                 .fastRestoreRule(FastRestoreRuleProperty.builder()
     *                         .availabilityZones(List.of("availabilityZones"))
     *                         .count(123)
     *                         .interval(123)
     *                         .intervalUnit("intervalUnit")
     *                         .build())
     *                 .name("name")
     *                 .retainRule(RetainRuleProperty.builder()
     *                         .count(123)
     *                         .interval(123)
     *                         .intervalUnit("intervalUnit")
     *                         .build())
     *                 .shareRules(List.of(ShareRuleProperty.builder()
     *                         .targetAccounts(List.of("targetAccounts"))
     *                         .unshareInterval(123)
     *                         .unshareIntervalUnit("unshareIntervalUnit")
     *                         .build()))
     *                 .tagsToAdd(List.of(CfnTag.builder()
     *                         .key("key")
     *                         .value("value")
     *                         .build()))
     *                 .variableTags(List.of(CfnTag.builder()
     *                         .key("key")
     *                         .value("value")
     *                         .build()))
     *                 .build()))
     *         .targetTags(List.of(CfnTag.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.PolicyDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(PolicyDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PolicyDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The actions to be performed when the event-based policy is triggered. You can specify only one action per policy.
         * <p>
         * This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getActions() {
            return null;
        }

        /**
         * The event that triggers the event-based policy.
         * <p>
         * This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEventSource() {
            return null;
        }

        /**
         * A set of optional parameters for snapshot and AMI lifecycle policies.
         * <p>
         * This parameter is required for snapshot and AMI policies only. If you are creating an event-based policy, omit this parameter.
         * <p>
         * <blockquote>
         * <p>
         * If you are modifying a policy that was created or previously modified using the Amazon Data Lifecycle Manager console, then you must include this parameter and specify either the default values or the new values that you require. You can't omit this parameter or set its values to null.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
            return null;
        }

        /**
         * The valid target resource types and actions a policy can manage.
         * <p>
         * Specify <code>EBS_SNAPSHOT_MANAGEMENT</code> to create a lifecycle policy that manages the lifecycle of Amazon EBS snapshots. Specify <code>IMAGE_MANAGEMENT</code> to create a lifecycle policy that manages the lifecycle of EBS-backed AMIs. Specify <code>EVENT_BASED_POLICY</code> to create an event-based policy that performs specific actions when a defined event occurs in your AWS account .
         * <p>
         * The default is <code>EBS_SNAPSHOT_MANAGEMENT</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPolicyType() {
            return null;
        }

        /**
         * The location of the resources to backup.
         * <p>
         * If the source resources are located in an AWS Region , specify <code>CLOUD</code> . If the source resources are located on an Outpost in your account, specify <code>OUTPOST</code> .
         * <p>
         * If you specify <code>OUTPOST</code> , Amazon Data Lifecycle Manager backs up all resources of the specified type with matching target tags across all of the Outposts in your account.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResourceLocations() {
            return null;
        }

        /**
         * The target resource type for snapshot and AMI lifecycle policies.
         * <p>
         * Use <code>VOLUME</code> to create snapshots of individual volumes or use <code>INSTANCE</code> to create multi-volume snapshots from the volumes for an instance.
         * <p>
         * This parameter is required for snapshot and AMI policies only. If you are creating an event-based policy, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResourceTypes() {
            return null;
        }

        /**
         * The schedules of policy-defined actions for snapshot and AMI lifecycle policies.
         * <p>
         * A policy can have up to four schedules—one mandatory schedule and up to three optional schedules.
         * <p>
         * This parameter is required for snapshot and AMI policies only. If you are creating an event-based policy, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSchedules() {
            return null;
        }

        /**
         * The single tag that identifies targeted resources for this policy.
         * <p>
         * This parameter is required for snapshot and AMI policies only. If you are creating an event-based policy, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTargetTags() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PolicyDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PolicyDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PolicyDetailsProperty> {
            java.lang.Object actions;
            java.lang.Object eventSource;
            java.lang.Object parameters;
            java.lang.String policyType;
            java.util.List<java.lang.String> resourceLocations;
            java.util.List<java.lang.String> resourceTypes;
            java.lang.Object schedules;
            java.lang.Object targetTags;

            /**
             * Sets the value of {@link PolicyDetailsProperty#getActions}
             * @param actions The actions to be performed when the event-based policy is triggered. You can specify only one action per policy.
             *                This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(software.amazon.awscdk.IResolvable actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getActions}
             * @param actions The actions to be performed when the event-based policy is triggered. You can specify only one action per policy.
             *                This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(java.util.List<? extends java.lang.Object> actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getEventSource}
             * @param eventSource The event that triggers the event-based policy.
             *                    This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventSource(software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.EventSourceProperty eventSource) {
                this.eventSource = eventSource;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getEventSource}
             * @param eventSource The event that triggers the event-based policy.
             *                    This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventSource(software.amazon.awscdk.IResolvable eventSource) {
                this.eventSource = eventSource;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getParameters}
             * @param parameters A set of optional parameters for snapshot and AMI lifecycle policies.
             *                   This parameter is required for snapshot and AMI policies only. If you are creating an event-based policy, omit this parameter.
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   If you are modifying a policy that was created or previously modified using the Amazon Data Lifecycle Manager console, then you must include this parameter and specify either the default values or the new values that you require. You can't omit this parameter or set its values to null.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.ParametersProperty parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getParameters}
             * @param parameters A set of optional parameters for snapshot and AMI lifecycle policies.
             *                   This parameter is required for snapshot and AMI policies only. If you are creating an event-based policy, omit this parameter.
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   If you are modifying a policy that was created or previously modified using the Amazon Data Lifecycle Manager console, then you must include this parameter and specify either the default values or the new values that you require. You can't omit this parameter or set its values to null.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(software.amazon.awscdk.IResolvable parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getPolicyType}
             * @param policyType The valid target resource types and actions a policy can manage.
             *                   Specify <code>EBS_SNAPSHOT_MANAGEMENT</code> to create a lifecycle policy that manages the lifecycle of Amazon EBS snapshots. Specify <code>IMAGE_MANAGEMENT</code> to create a lifecycle policy that manages the lifecycle of EBS-backed AMIs. Specify <code>EVENT_BASED_POLICY</code> to create an event-based policy that performs specific actions when a defined event occurs in your AWS account .
             *                   <p>
             *                   The default is <code>EBS_SNAPSHOT_MANAGEMENT</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policyType(java.lang.String policyType) {
                this.policyType = policyType;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getResourceLocations}
             * @param resourceLocations The location of the resources to backup.
             *                          If the source resources are located in an AWS Region , specify <code>CLOUD</code> . If the source resources are located on an Outpost in your account, specify <code>OUTPOST</code> .
             *                          <p>
             *                          If you specify <code>OUTPOST</code> , Amazon Data Lifecycle Manager backs up all resources of the specified type with matching target tags across all of the Outposts in your account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceLocations(java.util.List<java.lang.String> resourceLocations) {
                this.resourceLocations = resourceLocations;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getResourceTypes}
             * @param resourceTypes The target resource type for snapshot and AMI lifecycle policies.
             *                      Use <code>VOLUME</code> to create snapshots of individual volumes or use <code>INSTANCE</code> to create multi-volume snapshots from the volumes for an instance.
             *                      <p>
             *                      This parameter is required for snapshot and AMI policies only. If you are creating an event-based policy, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceTypes(java.util.List<java.lang.String> resourceTypes) {
                this.resourceTypes = resourceTypes;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getSchedules}
             * @param schedules The schedules of policy-defined actions for snapshot and AMI lifecycle policies.
             *                  A policy can have up to four schedules—one mandatory schedule and up to three optional schedules.
             *                  <p>
             *                  This parameter is required for snapshot and AMI policies only. If you are creating an event-based policy, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schedules(software.amazon.awscdk.IResolvable schedules) {
                this.schedules = schedules;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getSchedules}
             * @param schedules The schedules of policy-defined actions for snapshot and AMI lifecycle policies.
             *                  A policy can have up to four schedules—one mandatory schedule and up to three optional schedules.
             *                  <p>
             *                  This parameter is required for snapshot and AMI policies only. If you are creating an event-based policy, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schedules(java.util.List<? extends java.lang.Object> schedules) {
                this.schedules = schedules;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getTargetTags}
             * @param targetTags The single tag that identifies targeted resources for this policy.
             *                   This parameter is required for snapshot and AMI policies only. If you are creating an event-based policy, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetTags(software.amazon.awscdk.IResolvable targetTags) {
                this.targetTags = targetTags;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getTargetTags}
             * @param targetTags The single tag that identifies targeted resources for this policy.
             *                   This parameter is required for snapshot and AMI policies only. If you are creating an event-based policy, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetTags(java.util.List<? extends java.lang.Object> targetTags) {
                this.targetTags = targetTags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PolicyDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PolicyDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PolicyDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PolicyDetailsProperty {
            private final java.lang.Object actions;
            private final java.lang.Object eventSource;
            private final java.lang.Object parameters;
            private final java.lang.String policyType;
            private final java.util.List<java.lang.String> resourceLocations;
            private final java.util.List<java.lang.String> resourceTypes;
            private final java.lang.Object schedules;
            private final java.lang.Object targetTags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.eventSource = software.amazon.jsii.Kernel.get(this, "eventSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.policyType = software.amazon.jsii.Kernel.get(this, "policyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceLocations = software.amazon.jsii.Kernel.get(this, "resourceLocations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.resourceTypes = software.amazon.jsii.Kernel.get(this, "resourceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.schedules = software.amazon.jsii.Kernel.get(this, "schedules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.targetTags = software.amazon.jsii.Kernel.get(this, "targetTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actions = builder.actions;
                this.eventSource = builder.eventSource;
                this.parameters = builder.parameters;
                this.policyType = builder.policyType;
                this.resourceLocations = builder.resourceLocations;
                this.resourceTypes = builder.resourceTypes;
                this.schedules = builder.schedules;
                this.targetTags = builder.targetTags;
            }

            @Override
            public final java.lang.Object getActions() {
                return this.actions;
            }

            @Override
            public final java.lang.Object getEventSource() {
                return this.eventSource;
            }

            @Override
            public final java.lang.Object getParameters() {
                return this.parameters;
            }

            @Override
            public final java.lang.String getPolicyType() {
                return this.policyType;
            }

            @Override
            public final java.util.List<java.lang.String> getResourceLocations() {
                return this.resourceLocations;
            }

            @Override
            public final java.util.List<java.lang.String> getResourceTypes() {
                return this.resourceTypes;
            }

            @Override
            public final java.lang.Object getSchedules() {
                return this.schedules;
            }

            @Override
            public final java.lang.Object getTargetTags() {
                return this.targetTags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getActions() != null) {
                    data.set("actions", om.valueToTree(this.getActions()));
                }
                if (this.getEventSource() != null) {
                    data.set("eventSource", om.valueToTree(this.getEventSource()));
                }
                if (this.getParameters() != null) {
                    data.set("parameters", om.valueToTree(this.getParameters()));
                }
                if (this.getPolicyType() != null) {
                    data.set("policyType", om.valueToTree(this.getPolicyType()));
                }
                if (this.getResourceLocations() != null) {
                    data.set("resourceLocations", om.valueToTree(this.getResourceLocations()));
                }
                if (this.getResourceTypes() != null) {
                    data.set("resourceTypes", om.valueToTree(this.getResourceTypes()));
                }
                if (this.getSchedules() != null) {
                    data.set("schedules", om.valueToTree(this.getSchedules()));
                }
                if (this.getTargetTags() != null) {
                    data.set("targetTags", om.valueToTree(this.getTargetTags()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.PolicyDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PolicyDetailsProperty.Jsii$Proxy that = (PolicyDetailsProperty.Jsii$Proxy) o;

                if (this.actions != null ? !this.actions.equals(that.actions) : that.actions != null) return false;
                if (this.eventSource != null ? !this.eventSource.equals(that.eventSource) : that.eventSource != null) return false;
                if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
                if (this.policyType != null ? !this.policyType.equals(that.policyType) : that.policyType != null) return false;
                if (this.resourceLocations != null ? !this.resourceLocations.equals(that.resourceLocations) : that.resourceLocations != null) return false;
                if (this.resourceTypes != null ? !this.resourceTypes.equals(that.resourceTypes) : that.resourceTypes != null) return false;
                if (this.schedules != null ? !this.schedules.equals(that.schedules) : that.schedules != null) return false;
                return this.targetTags != null ? this.targetTags.equals(that.targetTags) : that.targetTags == null;
            }

            @Override
            public final int hashCode() {
                int result = this.actions != null ? this.actions.hashCode() : 0;
                result = 31 * result + (this.eventSource != null ? this.eventSource.hashCode() : 0);
                result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
                result = 31 * result + (this.policyType != null ? this.policyType.hashCode() : 0);
                result = 31 * result + (this.resourceLocations != null ? this.resourceLocations.hashCode() : 0);
                result = 31 * result + (this.resourceTypes != null ? this.resourceTypes.hashCode() : 0);
                result = 31 * result + (this.schedules != null ? this.schedules.hashCode() : 0);
                result = 31 * result + (this.targetTags != null ? this.targetTags.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the retention rule for a lifecycle policy.
     * <p>
     * You can retain snapshots based on either a count or a time interval.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * RetainRuleProperty retainRuleProperty = RetainRuleProperty.builder()
     *         .count(123)
     *         .interval(123)
     *         .intervalUnit("intervalUnit")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.RetainRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(RetainRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RetainRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of snapshots to retain for each volume, up to a maximum of 1000.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCount() {
            return null;
        }

        /**
         * The amount of time to retain each snapshot.
         * <p>
         * The maximum is 100 years. This is equivalent to 1200 months, 5200 weeks, or 36500 days.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInterval() {
            return null;
        }

        /**
         * The unit of time for time-based retention.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIntervalUnit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RetainRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RetainRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RetainRuleProperty> {
            java.lang.Number count;
            java.lang.Number interval;
            java.lang.String intervalUnit;

            /**
             * Sets the value of {@link RetainRuleProperty#getCount}
             * @param count The number of snapshots to retain for each volume, up to a maximum of 1000.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder count(java.lang.Number count) {
                this.count = count;
                return this;
            }

            /**
             * Sets the value of {@link RetainRuleProperty#getInterval}
             * @param interval The amount of time to retain each snapshot.
             *                 The maximum is 100 years. This is equivalent to 1200 months, 5200 weeks, or 36500 days.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interval(java.lang.Number interval) {
                this.interval = interval;
                return this;
            }

            /**
             * Sets the value of {@link RetainRuleProperty#getIntervalUnit}
             * @param intervalUnit The unit of time for time-based retention.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intervalUnit(java.lang.String intervalUnit) {
                this.intervalUnit = intervalUnit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RetainRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RetainRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RetainRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RetainRuleProperty {
            private final java.lang.Number count;
            private final java.lang.Number interval;
            private final java.lang.String intervalUnit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.count = software.amazon.jsii.Kernel.get(this, "count", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.interval = software.amazon.jsii.Kernel.get(this, "interval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.intervalUnit = software.amazon.jsii.Kernel.get(this, "intervalUnit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.count = builder.count;
                this.interval = builder.interval;
                this.intervalUnit = builder.intervalUnit;
            }

            @Override
            public final java.lang.Number getCount() {
                return this.count;
            }

            @Override
            public final java.lang.Number getInterval() {
                return this.interval;
            }

            @Override
            public final java.lang.String getIntervalUnit() {
                return this.intervalUnit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCount() != null) {
                    data.set("count", om.valueToTree(this.getCount()));
                }
                if (this.getInterval() != null) {
                    data.set("interval", om.valueToTree(this.getInterval()));
                }
                if (this.getIntervalUnit() != null) {
                    data.set("intervalUnit", om.valueToTree(this.getIntervalUnit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.RetainRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RetainRuleProperty.Jsii$Proxy that = (RetainRuleProperty.Jsii$Proxy) o;

                if (this.count != null ? !this.count.equals(that.count) : that.count != null) return false;
                if (this.interval != null ? !this.interval.equals(that.interval) : that.interval != null) return false;
                return this.intervalUnit != null ? this.intervalUnit.equals(that.intervalUnit) : that.intervalUnit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.count != null ? this.count.hashCode() : 0;
                result = 31 * result + (this.interval != null ? this.interval.hashCode() : 0);
                result = 31 * result + (this.intervalUnit != null ? this.intervalUnit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a backup schedule for a snapshot or AMI lifecycle policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * ScheduleProperty scheduleProperty = ScheduleProperty.builder()
     *         .copyTags(false)
     *         .createRule(CreateRuleProperty.builder()
     *                 .cronExpression("cronExpression")
     *                 .interval(123)
     *                 .intervalUnit("intervalUnit")
     *                 .location("location")
     *                 .times(List.of("times"))
     *                 .build())
     *         .crossRegionCopyRules(List.of(CrossRegionCopyRuleProperty.builder()
     *                 .encrypted(false)
     *                 // the properties below are optional
     *                 .cmkArn("cmkArn")
     *                 .copyTags(false)
     *                 .deprecateRule(CrossRegionCopyDeprecateRuleProperty.builder()
     *                         .interval(123)
     *                         .intervalUnit("intervalUnit")
     *                         .build())
     *                 .retainRule(CrossRegionCopyRetainRuleProperty.builder()
     *                         .interval(123)
     *                         .intervalUnit("intervalUnit")
     *                         .build())
     *                 .target("target")
     *                 .targetRegion("targetRegion")
     *                 .build()))
     *         .deprecateRule(DeprecateRuleProperty.builder()
     *                 .count(123)
     *                 .interval(123)
     *                 .intervalUnit("intervalUnit")
     *                 .build())
     *         .fastRestoreRule(FastRestoreRuleProperty.builder()
     *                 .availabilityZones(List.of("availabilityZones"))
     *                 .count(123)
     *                 .interval(123)
     *                 .intervalUnit("intervalUnit")
     *                 .build())
     *         .name("name")
     *         .retainRule(RetainRuleProperty.builder()
     *                 .count(123)
     *                 .interval(123)
     *                 .intervalUnit("intervalUnit")
     *                 .build())
     *         .shareRules(List.of(ShareRuleProperty.builder()
     *                 .targetAccounts(List.of("targetAccounts"))
     *                 .unshareInterval(123)
     *                 .unshareIntervalUnit("unshareIntervalUnit")
     *                 .build()))
     *         .tagsToAdd(List.of(CfnTag.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .variableTags(List.of(CfnTag.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.ScheduleProperty")
    @software.amazon.jsii.Jsii.Proxy(ScheduleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScheduleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Copy all user-defined tags on a source volume to snapshots of the volume created by this policy.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCopyTags() {
            return null;
        }

        /**
         * The creation rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCreateRule() {
            return null;
        }

        /**
         * The rule for cross-Region snapshot copies.
         * <p>
         * You can only specify cross-Region copy rules for policies that create snapshots in a Region. If the policy creates snapshots on an Outpost, then you cannot copy the snapshots to a Region or to an Outpost. If the policy creates snapshots in a Region, then snapshots can be copied to up to three Regions or Outposts.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCrossRegionCopyRules() {
            return null;
        }

        /**
         * The AMI deprecation rule for the schedule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeprecateRule() {
            return null;
        }

        /**
         * The rule for enabling fast snapshot restore.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFastRestoreRule() {
            return null;
        }

        /**
         * The name of the schedule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The retention rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetainRule() {
            return null;
        }

        /**
         * The rule for sharing snapshots with other AWS accounts .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getShareRules() {
            return null;
        }

        /**
         * The tags to apply to policy-created resources.
         * <p>
         * These user-defined tags are in addition to the AWS -added lifecycle tags.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTagsToAdd() {
            return null;
        }

        /**
         * A collection of key/value pairs with values determined dynamically when the policy is executed.
         * <p>
         * Keys may be any valid Amazon EC2 tag key. Values must be in one of the two following formats: <code>$(instance-id)</code> or <code>$(timestamp)</code> . Variable tags are only valid for EBS Snapshot Management – Instance policies.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVariableTags() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScheduleProperty> {
            java.lang.Object copyTags;
            java.lang.Object createRule;
            java.lang.Object crossRegionCopyRules;
            java.lang.Object deprecateRule;
            java.lang.Object fastRestoreRule;
            java.lang.String name;
            java.lang.Object retainRule;
            java.lang.Object shareRules;
            java.lang.Object tagsToAdd;
            java.lang.Object variableTags;

            /**
             * Sets the value of {@link ScheduleProperty#getCopyTags}
             * @param copyTags Copy all user-defined tags on a source volume to snapshots of the volume created by this policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyTags(java.lang.Boolean copyTags) {
                this.copyTags = copyTags;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getCopyTags}
             * @param copyTags Copy all user-defined tags on a source volume to snapshots of the volume created by this policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyTags(software.amazon.awscdk.IResolvable copyTags) {
                this.copyTags = copyTags;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getCreateRule}
             * @param createRule The creation rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createRule(software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.CreateRuleProperty createRule) {
                this.createRule = createRule;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getCreateRule}
             * @param createRule The creation rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createRule(software.amazon.awscdk.IResolvable createRule) {
                this.createRule = createRule;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getCrossRegionCopyRules}
             * @param crossRegionCopyRules The rule for cross-Region snapshot copies.
             *                             You can only specify cross-Region copy rules for policies that create snapshots in a Region. If the policy creates snapshots on an Outpost, then you cannot copy the snapshots to a Region or to an Outpost. If the policy creates snapshots in a Region, then snapshots can be copied to up to three Regions or Outposts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crossRegionCopyRules(software.amazon.awscdk.IResolvable crossRegionCopyRules) {
                this.crossRegionCopyRules = crossRegionCopyRules;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getCrossRegionCopyRules}
             * @param crossRegionCopyRules The rule for cross-Region snapshot copies.
             *                             You can only specify cross-Region copy rules for policies that create snapshots in a Region. If the policy creates snapshots on an Outpost, then you cannot copy the snapshots to a Region or to an Outpost. If the policy creates snapshots in a Region, then snapshots can be copied to up to three Regions or Outposts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crossRegionCopyRules(java.util.List<? extends java.lang.Object> crossRegionCopyRules) {
                this.crossRegionCopyRules = crossRegionCopyRules;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getDeprecateRule}
             * @param deprecateRule The AMI deprecation rule for the schedule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deprecateRule(software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.DeprecateRuleProperty deprecateRule) {
                this.deprecateRule = deprecateRule;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getDeprecateRule}
             * @param deprecateRule The AMI deprecation rule for the schedule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deprecateRule(software.amazon.awscdk.IResolvable deprecateRule) {
                this.deprecateRule = deprecateRule;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getFastRestoreRule}
             * @param fastRestoreRule The rule for enabling fast snapshot restore.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fastRestoreRule(software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.FastRestoreRuleProperty fastRestoreRule) {
                this.fastRestoreRule = fastRestoreRule;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getFastRestoreRule}
             * @param fastRestoreRule The rule for enabling fast snapshot restore.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fastRestoreRule(software.amazon.awscdk.IResolvable fastRestoreRule) {
                this.fastRestoreRule = fastRestoreRule;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getName}
             * @param name The name of the schedule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getRetainRule}
             * @param retainRule The retention rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retainRule(software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.RetainRuleProperty retainRule) {
                this.retainRule = retainRule;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getRetainRule}
             * @param retainRule The retention rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retainRule(software.amazon.awscdk.IResolvable retainRule) {
                this.retainRule = retainRule;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getShareRules}
             * @param shareRules The rule for sharing snapshots with other AWS accounts .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shareRules(software.amazon.awscdk.IResolvable shareRules) {
                this.shareRules = shareRules;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getShareRules}
             * @param shareRules The rule for sharing snapshots with other AWS accounts .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shareRules(java.util.List<? extends java.lang.Object> shareRules) {
                this.shareRules = shareRules;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getTagsToAdd}
             * @param tagsToAdd The tags to apply to policy-created resources.
             *                  These user-defined tags are in addition to the AWS -added lifecycle tags.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagsToAdd(software.amazon.awscdk.IResolvable tagsToAdd) {
                this.tagsToAdd = tagsToAdd;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getTagsToAdd}
             * @param tagsToAdd The tags to apply to policy-created resources.
             *                  These user-defined tags are in addition to the AWS -added lifecycle tags.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagsToAdd(java.util.List<? extends java.lang.Object> tagsToAdd) {
                this.tagsToAdd = tagsToAdd;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getVariableTags}
             * @param variableTags A collection of key/value pairs with values determined dynamically when the policy is executed.
             *                     Keys may be any valid Amazon EC2 tag key. Values must be in one of the two following formats: <code>$(instance-id)</code> or <code>$(timestamp)</code> . Variable tags are only valid for EBS Snapshot Management – Instance policies.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variableTags(software.amazon.awscdk.IResolvable variableTags) {
                this.variableTags = variableTags;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getVariableTags}
             * @param variableTags A collection of key/value pairs with values determined dynamically when the policy is executed.
             *                     Keys may be any valid Amazon EC2 tag key. Values must be in one of the two following formats: <code>$(instance-id)</code> or <code>$(timestamp)</code> . Variable tags are only valid for EBS Snapshot Management – Instance policies.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variableTags(java.util.List<? extends java.lang.Object> variableTags) {
                this.variableTags = variableTags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScheduleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScheduleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduleProperty {
            private final java.lang.Object copyTags;
            private final java.lang.Object createRule;
            private final java.lang.Object crossRegionCopyRules;
            private final java.lang.Object deprecateRule;
            private final java.lang.Object fastRestoreRule;
            private final java.lang.String name;
            private final java.lang.Object retainRule;
            private final java.lang.Object shareRules;
            private final java.lang.Object tagsToAdd;
            private final java.lang.Object variableTags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.copyTags = software.amazon.jsii.Kernel.get(this, "copyTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.createRule = software.amazon.jsii.Kernel.get(this, "createRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.crossRegionCopyRules = software.amazon.jsii.Kernel.get(this, "crossRegionCopyRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.deprecateRule = software.amazon.jsii.Kernel.get(this, "deprecateRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fastRestoreRule = software.amazon.jsii.Kernel.get(this, "fastRestoreRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.retainRule = software.amazon.jsii.Kernel.get(this, "retainRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.shareRules = software.amazon.jsii.Kernel.get(this, "shareRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tagsToAdd = software.amazon.jsii.Kernel.get(this, "tagsToAdd", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.variableTags = software.amazon.jsii.Kernel.get(this, "variableTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.copyTags = builder.copyTags;
                this.createRule = builder.createRule;
                this.crossRegionCopyRules = builder.crossRegionCopyRules;
                this.deprecateRule = builder.deprecateRule;
                this.fastRestoreRule = builder.fastRestoreRule;
                this.name = builder.name;
                this.retainRule = builder.retainRule;
                this.shareRules = builder.shareRules;
                this.tagsToAdd = builder.tagsToAdd;
                this.variableTags = builder.variableTags;
            }

            @Override
            public final java.lang.Object getCopyTags() {
                return this.copyTags;
            }

            @Override
            public final java.lang.Object getCreateRule() {
                return this.createRule;
            }

            @Override
            public final java.lang.Object getCrossRegionCopyRules() {
                return this.crossRegionCopyRules;
            }

            @Override
            public final java.lang.Object getDeprecateRule() {
                return this.deprecateRule;
            }

            @Override
            public final java.lang.Object getFastRestoreRule() {
                return this.fastRestoreRule;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getRetainRule() {
                return this.retainRule;
            }

            @Override
            public final java.lang.Object getShareRules() {
                return this.shareRules;
            }

            @Override
            public final java.lang.Object getTagsToAdd() {
                return this.tagsToAdd;
            }

            @Override
            public final java.lang.Object getVariableTags() {
                return this.variableTags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCopyTags() != null) {
                    data.set("copyTags", om.valueToTree(this.getCopyTags()));
                }
                if (this.getCreateRule() != null) {
                    data.set("createRule", om.valueToTree(this.getCreateRule()));
                }
                if (this.getCrossRegionCopyRules() != null) {
                    data.set("crossRegionCopyRules", om.valueToTree(this.getCrossRegionCopyRules()));
                }
                if (this.getDeprecateRule() != null) {
                    data.set("deprecateRule", om.valueToTree(this.getDeprecateRule()));
                }
                if (this.getFastRestoreRule() != null) {
                    data.set("fastRestoreRule", om.valueToTree(this.getFastRestoreRule()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getRetainRule() != null) {
                    data.set("retainRule", om.valueToTree(this.getRetainRule()));
                }
                if (this.getShareRules() != null) {
                    data.set("shareRules", om.valueToTree(this.getShareRules()));
                }
                if (this.getTagsToAdd() != null) {
                    data.set("tagsToAdd", om.valueToTree(this.getTagsToAdd()));
                }
                if (this.getVariableTags() != null) {
                    data.set("variableTags", om.valueToTree(this.getVariableTags()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.ScheduleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScheduleProperty.Jsii$Proxy that = (ScheduleProperty.Jsii$Proxy) o;

                if (this.copyTags != null ? !this.copyTags.equals(that.copyTags) : that.copyTags != null) return false;
                if (this.createRule != null ? !this.createRule.equals(that.createRule) : that.createRule != null) return false;
                if (this.crossRegionCopyRules != null ? !this.crossRegionCopyRules.equals(that.crossRegionCopyRules) : that.crossRegionCopyRules != null) return false;
                if (this.deprecateRule != null ? !this.deprecateRule.equals(that.deprecateRule) : that.deprecateRule != null) return false;
                if (this.fastRestoreRule != null ? !this.fastRestoreRule.equals(that.fastRestoreRule) : that.fastRestoreRule != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.retainRule != null ? !this.retainRule.equals(that.retainRule) : that.retainRule != null) return false;
                if (this.shareRules != null ? !this.shareRules.equals(that.shareRules) : that.shareRules != null) return false;
                if (this.tagsToAdd != null ? !this.tagsToAdd.equals(that.tagsToAdd) : that.tagsToAdd != null) return false;
                return this.variableTags != null ? this.variableTags.equals(that.variableTags) : that.variableTags == null;
            }

            @Override
            public final int hashCode() {
                int result = this.copyTags != null ? this.copyTags.hashCode() : 0;
                result = 31 * result + (this.createRule != null ? this.createRule.hashCode() : 0);
                result = 31 * result + (this.crossRegionCopyRules != null ? this.crossRegionCopyRules.hashCode() : 0);
                result = 31 * result + (this.deprecateRule != null ? this.deprecateRule.hashCode() : 0);
                result = 31 * result + (this.fastRestoreRule != null ? this.fastRestoreRule.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.retainRule != null ? this.retainRule.hashCode() : 0);
                result = 31 * result + (this.shareRules != null ? this.shareRules.hashCode() : 0);
                result = 31 * result + (this.tagsToAdd != null ? this.tagsToAdd.hashCode() : 0);
                result = 31 * result + (this.variableTags != null ? this.variableTags.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a rule for sharing snapshots across AWS accounts .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * ShareRuleProperty shareRuleProperty = ShareRuleProperty.builder()
     *         .targetAccounts(List.of("targetAccounts"))
     *         .unshareInterval(123)
     *         .unshareIntervalUnit("unshareIntervalUnit")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.ShareRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(ShareRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ShareRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IDs of the AWS accounts with which to share the snapshots.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTargetAccounts() {
            return null;
        }

        /**
         * The period after which snapshots that are shared with other AWS accounts are automatically unshared.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getUnshareInterval() {
            return null;
        }

        /**
         * The unit of time for the automatic unsharing interval.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUnshareIntervalUnit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ShareRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ShareRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ShareRuleProperty> {
            java.util.List<java.lang.String> targetAccounts;
            java.lang.Number unshareInterval;
            java.lang.String unshareIntervalUnit;

            /**
             * Sets the value of {@link ShareRuleProperty#getTargetAccounts}
             * @param targetAccounts The IDs of the AWS accounts with which to share the snapshots.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetAccounts(java.util.List<java.lang.String> targetAccounts) {
                this.targetAccounts = targetAccounts;
                return this;
            }

            /**
             * Sets the value of {@link ShareRuleProperty#getUnshareInterval}
             * @param unshareInterval The period after which snapshots that are shared with other AWS accounts are automatically unshared.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unshareInterval(java.lang.Number unshareInterval) {
                this.unshareInterval = unshareInterval;
                return this;
            }

            /**
             * Sets the value of {@link ShareRuleProperty#getUnshareIntervalUnit}
             * @param unshareIntervalUnit The unit of time for the automatic unsharing interval.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unshareIntervalUnit(java.lang.String unshareIntervalUnit) {
                this.unshareIntervalUnit = unshareIntervalUnit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ShareRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ShareRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ShareRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ShareRuleProperty {
            private final java.util.List<java.lang.String> targetAccounts;
            private final java.lang.Number unshareInterval;
            private final java.lang.String unshareIntervalUnit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetAccounts = software.amazon.jsii.Kernel.get(this, "targetAccounts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.unshareInterval = software.amazon.jsii.Kernel.get(this, "unshareInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.unshareIntervalUnit = software.amazon.jsii.Kernel.get(this, "unshareIntervalUnit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetAccounts = builder.targetAccounts;
                this.unshareInterval = builder.unshareInterval;
                this.unshareIntervalUnit = builder.unshareIntervalUnit;
            }

            @Override
            public final java.util.List<java.lang.String> getTargetAccounts() {
                return this.targetAccounts;
            }

            @Override
            public final java.lang.Number getUnshareInterval() {
                return this.unshareInterval;
            }

            @Override
            public final java.lang.String getUnshareIntervalUnit() {
                return this.unshareIntervalUnit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTargetAccounts() != null) {
                    data.set("targetAccounts", om.valueToTree(this.getTargetAccounts()));
                }
                if (this.getUnshareInterval() != null) {
                    data.set("unshareInterval", om.valueToTree(this.getUnshareInterval()));
                }
                if (this.getUnshareIntervalUnit() != null) {
                    data.set("unshareIntervalUnit", om.valueToTree(this.getUnshareIntervalUnit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.ShareRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ShareRuleProperty.Jsii$Proxy that = (ShareRuleProperty.Jsii$Proxy) o;

                if (this.targetAccounts != null ? !this.targetAccounts.equals(that.targetAccounts) : that.targetAccounts != null) return false;
                if (this.unshareInterval != null ? !this.unshareInterval.equals(that.unshareInterval) : that.unshareInterval != null) return false;
                return this.unshareIntervalUnit != null ? this.unshareIntervalUnit.equals(that.unshareIntervalUnit) : that.unshareIntervalUnit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.targetAccounts != null ? this.targetAccounts.hashCode() : 0;
                result = 31 * result + (this.unshareInterval != null ? this.unshareInterval.hashCode() : 0);
                result = 31 * result + (this.unshareIntervalUnit != null ? this.unshareIntervalUnit.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.dlm.CfnLifecyclePolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.dlm.CfnLifecyclePolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.dlm.CfnLifecyclePolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * A description of the lifecycle policy.
         * <p>
         * The characters ^[0-9A-Za-z _-]+$ are supported.
         * <p>
         * @return {@code this}
         * @param description A description of the lifecycle policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle policy.
         * <p>
         * @return {@code this}
         * @param executionRoleArn The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRoleArn(final java.lang.String executionRoleArn) {
            this.props().executionRoleArn(executionRoleArn);
            return this;
        }

        /**
         * The configuration details of the lifecycle policy.
         * <p>
         * @return {@code this}
         * @param policyDetails The configuration details of the lifecycle policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyDetails(final software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.PolicyDetailsProperty policyDetails) {
            this.props().policyDetails(policyDetails);
            return this;
        }
        /**
         * The configuration details of the lifecycle policy.
         * <p>
         * @return {@code this}
         * @param policyDetails The configuration details of the lifecycle policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyDetails(final software.amazon.awscdk.IResolvable policyDetails) {
            this.props().policyDetails(policyDetails);
            return this;
        }

        /**
         * The activation state of the lifecycle policy.
         * <p>
         * @return {@code this}
         * @param state The activation state of the lifecycle policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder state(final java.lang.String state) {
            this.props().state(state);
            return this;
        }

        /**
         * The tags to apply to the lifecycle policy during creation.
         * <p>
         * @return {@code this}
         * @param tags The tags to apply to the lifecycle policy during creation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.dlm.CfnLifecyclePolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.dlm.CfnLifecyclePolicy build() {
            return new software.amazon.awscdk.services.dlm.CfnLifecyclePolicy(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.dlm.CfnLifecyclePolicyProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.dlm.CfnLifecyclePolicyProps.Builder();
            }
            return this.props;
        }
    }
}
