package software.amazon.awscdk.services.ec2;

/**
 * The traffic that is configured using a Network ACL entry.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * AclTraffic aclTraffic = AclTraffic.allTraffic();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:54.204Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.AclTraffic")
public abstract class AclTraffic extends software.amazon.jsii.JsiiObject {

    protected AclTraffic(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AclTraffic(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected AclTraffic() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Apply the ACL entry to all traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.AclTraffic allTraffic() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.AclTraffic.class, "allTraffic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.AclTraffic.class));
    }

    /**
     * Apply the ACL entry to ICMP traffic of given type and code.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.AclTraffic icmp(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.AclIcmp props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.AclTraffic.class, "icmp", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.AclTraffic.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Apply the ACL entry to ICMPv6 traffic of given type and code.
     * <p>
     * Requires an IPv6 CIDR block.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.AclTraffic icmpv6(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.AclIcmp props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.AclTraffic.class, "icmpv6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.AclTraffic.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Apply the ACL entry to TCP traffic on a given port.
     * <p>
     * @param port This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.AclTraffic tcpPort(final @org.jetbrains.annotations.NotNull java.lang.Number port) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.AclTraffic.class, "tcpPort", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.AclTraffic.class), new Object[] { java.util.Objects.requireNonNull(port, "port is required") });
    }

    /**
     * Apply the ACL entry to TCP traffic on a given port range.
     * <p>
     * @param startPort This parameter is required.
     * @param endPort This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.AclTraffic tcpPortRange(final @org.jetbrains.annotations.NotNull java.lang.Number startPort, final @org.jetbrains.annotations.NotNull java.lang.Number endPort) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.AclTraffic.class, "tcpPortRange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.AclTraffic.class), new Object[] { java.util.Objects.requireNonNull(startPort, "startPort is required"), java.util.Objects.requireNonNull(endPort, "endPort is required") });
    }

    /**
     * Apply the ACL entry to UDP traffic on a given port.
     * <p>
     * @param port This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.AclTraffic udpPort(final @org.jetbrains.annotations.NotNull java.lang.Number port) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.AclTraffic.class, "udpPort", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.AclTraffic.class), new Object[] { java.util.Objects.requireNonNull(port, "port is required") });
    }

    /**
     * Apply the ACL entry to UDP traffic on a given port range.
     * <p>
     * @param startPort This parameter is required.
     * @param endPort This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.AclTraffic udpPortRange(final @org.jetbrains.annotations.NotNull java.lang.Number startPort, final @org.jetbrains.annotations.NotNull java.lang.Number endPort) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.AclTraffic.class, "udpPortRange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.AclTraffic.class), new Object[] { java.util.Objects.requireNonNull(startPort, "startPort is required"), java.util.Objects.requireNonNull(endPort, "endPort is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.AclTrafficConfig toTrafficConfig();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.ec2.AclTraffic {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.AclTrafficConfig toTrafficConfig() {
            return software.amazon.jsii.Kernel.call(this, "toTrafficConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.AclTrafficConfig.class));
        }
    }
}
