package software.amazon.awscdk.services.ec2;

/**
 * Properties of an EC2 Instance.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * Vpc vpc;
 * InstanceType instanceType;
 * IMachineImage machineImage;
 * Instance.Builder.create(this, "Instance")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(machineImage)
 *         // ...
 *         .blockDevices(List.of(BlockDevice.builder()
 *                 .deviceName("/dev/sda1")
 *                 .volume(BlockDeviceVolume.ebs(50))
 *                 .build(), BlockDevice.builder()
 *                 .deviceName("/dev/sdm")
 *                 .volume(BlockDeviceVolume.ebs(100))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:54.536Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.InstanceProps")
@software.amazon.jsii.Jsii.Proxy(InstanceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InstanceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Type of instance to launch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InstanceType getInstanceType();

    /**
     * AMI to launch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage getMachineImage();

    /**
     * VPC to launch the instance in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc();

    /**
     * Whether the instance could initiate connections to anywhere by default.
     * <p>
     * This property is only used when you do not provide a security group.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAllowAllOutbound() {
        return null;
    }

    /**
     * In which AZ to place the instance within the VPC.
     * <p>
     * Default: - Random zone.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return null;
    }

    /**
     * Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes.
     * <p>
     * Each instance that is launched has an associated root device volume,
     * either an Amazon EBS volume or an instance store volume.
     * You can use block device mappings to specify additional EBS volumes or
     * instance store volumes to attach to an instance when it is launched.
     * <p>
     * Default: - Uses the block device mapping of the AMI
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.BlockDevice> getBlockDevices() {
        return null;
    }

    /**
     * Whether "Detailed Monitoring" is enabled for this instance Keep in mind that Detailed Monitoring results in extra charges.
     * <p>
     * Default: - false
     * <p>
     * @see <a href="http://aws.amazon.com/cloudwatch/pricing/">http://aws.amazon.com/cloudwatch/pricing/</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDetailedMonitoring() {
        return null;
    }

    /**
     * Apply the given CloudFormation Init configuration to the instance at startup.
     * <p>
     * Default: - no CloudFormation init
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.CloudFormationInit getInit() {
        return null;
    }

    /**
     * Use the given options for applying CloudFormation Init.
     * <p>
     * Describes the configsets to use and the timeout to wait
     * <p>
     * Default: - default options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ApplyCloudFormationInitOptions getInitOptions() {
        return null;
    }

    /**
     * The name of the instance.
     * <p>
     * Default: - CDK generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceName() {
        return null;
    }

    /**
     * Name of SSH keypair to grant access to instance.
     * <p>
     * Default: - No SSH access will be possible.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKeyName() {
        return null;
    }

    /**
     * Defines a private IP address to associate with an instance.
     * <p>
     * Private IP should be available within the VPC that the instance is build within.
     * <p>
     * Default: - no association
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPrivateIpAddress() {
        return null;
    }

    /**
     * Propagate the EC2 instance tags to the EBS volumes.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPropagateTagsToVolumeOnCreation() {
        return null;
    }

    /**
     * Whether IMDSv2 should be required on this instance.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRequireImdsv2() {
        return null;
    }

    /**
     * The length of time to wait for the resourceSignalCount.
     * <p>
     * The maximum value is 43200 (12 hours).
     * <p>
     * Default: Duration.minutes(5)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getResourceSignalTimeout() {
        return null;
    }

    /**
     * An IAM role to associate with the instance profile assigned to this Auto Scaling Group.
     * <p>
     * The role must be assumable by the service principal <code>ec2.amazonaws.com</code>:
     * <p>
     * Default: - A role will automatically be created, it can be accessed via the `role` property
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // Example automatically generated from non-compiling source. May contain errors.
     * Role role = Role.Builder.create(this, "MyRole")
     *         .assumedBy(new ServicePrincipal("ec2.amazonaws.com"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * Security Group to assign to this instance.
     * <p>
     * Default: - create new security group
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
        return null;
    }

    /**
     * Specifies whether to enable an instance launched in a VPC to perform NAT.
     * <p>
     * This controls whether source/destination checking is enabled on the instance.
     * A value of true means that checking is enabled, and false means that checking is disabled.
     * The value must be false for the instance to perform NAT.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSourceDestCheck() {
        return null;
    }

    /**
     * Specific UserData to use.
     * <p>
     * The UserData may still be mutated after creation.
     * <p>
     * Default: - A UserData object appropriate for the MachineImage's
     * Operating System is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.UserData getUserData() {
        return null;
    }

    /**
     * Changes to the UserData force replacement.
     * <p>
     * Depending the EC2 instance type, changing UserData either
     * restarts the instance or replaces the instance.
     * <p>
     * <ul>
     * <li>Instance store-backed instances are replaced.</li>
     * <li>EBS-backed instances are restarted.</li>
     * </ul>
     * <p>
     * By default, restarting does not execute the new UserData so you
     * will need a different mechanism to ensure the instance is restarted.
     * <p>
     * Setting this to <code>true</code> will make the instance's Logical ID depend on the
     * UserData, which will cause CloudFormation to replace it if the UserData
     * changes.
     * <p>
     * Default: - true iff `initOptions` is specified, false otherwise.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUserDataCausesReplacement() {
        return null;
    }

    /**
     * Where to place the instance within the VPC.
     * <p>
     * Default: - Private subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link InstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<InstanceProps> {
        software.amazon.awscdk.services.ec2.InstanceType instanceType;
        software.amazon.awscdk.services.ec2.IMachineImage machineImage;
        software.amazon.awscdk.services.ec2.IVpc vpc;
        java.lang.Boolean allowAllOutbound;
        java.lang.String availabilityZone;
        java.util.List<software.amazon.awscdk.services.ec2.BlockDevice> blockDevices;
        java.lang.Boolean detailedMonitoring;
        software.amazon.awscdk.services.ec2.CloudFormationInit init;
        software.amazon.awscdk.services.ec2.ApplyCloudFormationInitOptions initOptions;
        java.lang.String instanceName;
        java.lang.String keyName;
        java.lang.String privateIpAddress;
        java.lang.Boolean propagateTagsToVolumeOnCreation;
        java.lang.Boolean requireImdsv2;
        software.amazon.awscdk.Duration resourceSignalTimeout;
        software.amazon.awscdk.services.iam.IRole role;
        software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        java.lang.Boolean sourceDestCheck;
        software.amazon.awscdk.services.ec2.UserData userData;
        java.lang.Boolean userDataCausesReplacement;
        software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Sets the value of {@link InstanceProps#getInstanceType}
         * @param instanceType Type of instance to launch. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getMachineImage}
         * @param machineImage AMI to launch. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder machineImage(software.amazon.awscdk.services.ec2.IMachineImage machineImage) {
            this.machineImage = machineImage;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getVpc}
         * @param vpc VPC to launch the instance in. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getAllowAllOutbound}
         * @param allowAllOutbound Whether the instance could initiate connections to anywhere by default.
         *                         This property is only used when you do not provide a security group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAllOutbound(java.lang.Boolean allowAllOutbound) {
            this.allowAllOutbound = allowAllOutbound;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getAvailabilityZone}
         * @param availabilityZone In which AZ to place the instance within the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getBlockDevices}
         * @param blockDevices Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes.
         *                     Each instance that is launched has an associated root device volume,
         *                     either an Amazon EBS volume or an instance store volume.
         *                     You can use block device mappings to specify additional EBS volumes or
         *                     instance store volumes to attach to an instance when it is launched.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder blockDevices(java.util.List<? extends software.amazon.awscdk.services.ec2.BlockDevice> blockDevices) {
            this.blockDevices = (java.util.List<software.amazon.awscdk.services.ec2.BlockDevice>)blockDevices;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getDetailedMonitoring}
         * @param detailedMonitoring Whether "Detailed Monitoring" is enabled for this instance Keep in mind that Detailed Monitoring results in extra charges.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detailedMonitoring(java.lang.Boolean detailedMonitoring) {
            this.detailedMonitoring = detailedMonitoring;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getInit}
         * @param init Apply the given CloudFormation Init configuration to the instance at startup.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder init(software.amazon.awscdk.services.ec2.CloudFormationInit init) {
            this.init = init;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getInitOptions}
         * @param initOptions Use the given options for applying CloudFormation Init.
         *                    Describes the configsets to use and the timeout to wait
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initOptions(software.amazon.awscdk.services.ec2.ApplyCloudFormationInitOptions initOptions) {
            this.initOptions = initOptions;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getInstanceName}
         * @param instanceName The name of the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceName(java.lang.String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getKeyName}
         * @param keyName Name of SSH keypair to grant access to instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyName(java.lang.String keyName) {
            this.keyName = keyName;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getPrivateIpAddress}
         * @param privateIpAddress Defines a private IP address to associate with an instance.
         *                         Private IP should be available within the VPC that the instance is build within.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateIpAddress(java.lang.String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getPropagateTagsToVolumeOnCreation}
         * @param propagateTagsToVolumeOnCreation Propagate the EC2 instance tags to the EBS volumes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTagsToVolumeOnCreation(java.lang.Boolean propagateTagsToVolumeOnCreation) {
            this.propagateTagsToVolumeOnCreation = propagateTagsToVolumeOnCreation;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getRequireImdsv2}
         * @param requireImdsv2 Whether IMDSv2 should be required on this instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requireImdsv2(java.lang.Boolean requireImdsv2) {
            this.requireImdsv2 = requireImdsv2;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getResourceSignalTimeout}
         * @param resourceSignalTimeout The length of time to wait for the resourceSignalCount.
         *                              The maximum value is 43200 (12 hours).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceSignalTimeout(software.amazon.awscdk.Duration resourceSignalTimeout) {
            this.resourceSignalTimeout = resourceSignalTimeout;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getRole}
         * @param role An IAM role to associate with the instance profile assigned to this Auto Scaling Group.
         *             The role must be assumable by the service principal <code>ec2.amazonaws.com</code>:
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getSecurityGroup}
         * @param securityGroup Security Group to assign to this instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getSourceDestCheck}
         * @param sourceDestCheck Specifies whether to enable an instance launched in a VPC to perform NAT.
         *                        This controls whether source/destination checking is enabled on the instance.
         *                        A value of true means that checking is enabled, and false means that checking is disabled.
         *                        The value must be false for the instance to perform NAT.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDestCheck(java.lang.Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getUserData}
         * @param userData Specific UserData to use.
         *                 The UserData may still be mutated after creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(software.amazon.awscdk.services.ec2.UserData userData) {
            this.userData = userData;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getUserDataCausesReplacement}
         * @param userDataCausesReplacement Changes to the UserData force replacement.
         *                                  Depending the EC2 instance type, changing UserData either
         *                                  restarts the instance or replaces the instance.
         *                                  <p>
         *                                  <ul>
         *                                  <li>Instance store-backed instances are replaced.</li>
         *                                  <li>EBS-backed instances are restarted.</li>
         *                                  </ul>
         *                                  <p>
         *                                  By default, restarting does not execute the new UserData so you
         *                                  will need a different mechanism to ensure the instance is restarted.
         *                                  <p>
         *                                  Setting this to <code>true</code> will make the instance's Logical ID depend on the
         *                                  UserData, which will cause CloudFormation to replace it if the UserData
         *                                  changes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userDataCausesReplacement(java.lang.Boolean userDataCausesReplacement) {
            this.userDataCausesReplacement = userDataCausesReplacement;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getVpcSubnets}
         * @param vpcSubnets Where to place the instance within the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InstanceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public InstanceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link InstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceProps {
        private final software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private final software.amazon.awscdk.services.ec2.IMachineImage machineImage;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final java.lang.Boolean allowAllOutbound;
        private final java.lang.String availabilityZone;
        private final java.util.List<software.amazon.awscdk.services.ec2.BlockDevice> blockDevices;
        private final java.lang.Boolean detailedMonitoring;
        private final software.amazon.awscdk.services.ec2.CloudFormationInit init;
        private final software.amazon.awscdk.services.ec2.ApplyCloudFormationInitOptions initOptions;
        private final java.lang.String instanceName;
        private final java.lang.String keyName;
        private final java.lang.String privateIpAddress;
        private final java.lang.Boolean propagateTagsToVolumeOnCreation;
        private final java.lang.Boolean requireImdsv2;
        private final software.amazon.awscdk.Duration resourceSignalTimeout;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private final java.lang.Boolean sourceDestCheck;
        private final software.amazon.awscdk.services.ec2.UserData userData;
        private final java.lang.Boolean userDataCausesReplacement;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceType.class));
            this.machineImage = software.amazon.jsii.Kernel.get(this, "machineImage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.allowAllOutbound = software.amazon.jsii.Kernel.get(this, "allowAllOutbound", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.blockDevices = software.amazon.jsii.Kernel.get(this, "blockDevices", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.BlockDevice.class)));
            this.detailedMonitoring = software.amazon.jsii.Kernel.get(this, "detailedMonitoring", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.init = software.amazon.jsii.Kernel.get(this, "init", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.CloudFormationInit.class));
            this.initOptions = software.amazon.jsii.Kernel.get(this, "initOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ApplyCloudFormationInitOptions.class));
            this.instanceName = software.amazon.jsii.Kernel.get(this, "instanceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.keyName = software.amazon.jsii.Kernel.get(this, "keyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.privateIpAddress = software.amazon.jsii.Kernel.get(this, "privateIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.propagateTagsToVolumeOnCreation = software.amazon.jsii.Kernel.get(this, "propagateTagsToVolumeOnCreation", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.requireImdsv2 = software.amazon.jsii.Kernel.get(this, "requireImdsv2", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.resourceSignalTimeout = software.amazon.jsii.Kernel.get(this, "resourceSignalTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.securityGroup = software.amazon.jsii.Kernel.get(this, "securityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
            this.sourceDestCheck = software.amazon.jsii.Kernel.get(this, "sourceDestCheck", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.userData = software.amazon.jsii.Kernel.get(this, "userData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.UserData.class));
            this.userDataCausesReplacement = software.amazon.jsii.Kernel.get(this, "userDataCausesReplacement", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
            this.machineImage = java.util.Objects.requireNonNull(builder.machineImage, "machineImage is required");
            this.vpc = java.util.Objects.requireNonNull(builder.vpc, "vpc is required");
            this.allowAllOutbound = builder.allowAllOutbound;
            this.availabilityZone = builder.availabilityZone;
            this.blockDevices = (java.util.List<software.amazon.awscdk.services.ec2.BlockDevice>)builder.blockDevices;
            this.detailedMonitoring = builder.detailedMonitoring;
            this.init = builder.init;
            this.initOptions = builder.initOptions;
            this.instanceName = builder.instanceName;
            this.keyName = builder.keyName;
            this.privateIpAddress = builder.privateIpAddress;
            this.propagateTagsToVolumeOnCreation = builder.propagateTagsToVolumeOnCreation;
            this.requireImdsv2 = builder.requireImdsv2;
            this.resourceSignalTimeout = builder.resourceSignalTimeout;
            this.role = builder.role;
            this.securityGroup = builder.securityGroup;
            this.sourceDestCheck = builder.sourceDestCheck;
            this.userData = builder.userData;
            this.userDataCausesReplacement = builder.userDataCausesReplacement;
            this.vpcSubnets = builder.vpcSubnets;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IMachineImage getMachineImage() {
            return this.machineImage;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final java.lang.Boolean getAllowAllOutbound() {
            return this.allowAllOutbound;
        }

        @Override
        public final java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.BlockDevice> getBlockDevices() {
            return this.blockDevices;
        }

        @Override
        public final java.lang.Boolean getDetailedMonitoring() {
            return this.detailedMonitoring;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.CloudFormationInit getInit() {
            return this.init;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ApplyCloudFormationInitOptions getInitOptions() {
            return this.initOptions;
        }

        @Override
        public final java.lang.String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public final java.lang.String getKeyName() {
            return this.keyName;
        }

        @Override
        public final java.lang.String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public final java.lang.Boolean getPropagateTagsToVolumeOnCreation() {
            return this.propagateTagsToVolumeOnCreation;
        }

        @Override
        public final java.lang.Boolean getRequireImdsv2() {
            return this.requireImdsv2;
        }

        @Override
        public final software.amazon.awscdk.Duration getResourceSignalTimeout() {
            return this.resourceSignalTimeout;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public final java.lang.Boolean getSourceDestCheck() {
            return this.sourceDestCheck;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.UserData getUserData() {
            return this.userData;
        }

        @Override
        public final java.lang.Boolean getUserDataCausesReplacement() {
            return this.userDataCausesReplacement;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceType", om.valueToTree(this.getInstanceType()));
            data.set("machineImage", om.valueToTree(this.getMachineImage()));
            data.set("vpc", om.valueToTree(this.getVpc()));
            if (this.getAllowAllOutbound() != null) {
                data.set("allowAllOutbound", om.valueToTree(this.getAllowAllOutbound()));
            }
            if (this.getAvailabilityZone() != null) {
                data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            }
            if (this.getBlockDevices() != null) {
                data.set("blockDevices", om.valueToTree(this.getBlockDevices()));
            }
            if (this.getDetailedMonitoring() != null) {
                data.set("detailedMonitoring", om.valueToTree(this.getDetailedMonitoring()));
            }
            if (this.getInit() != null) {
                data.set("init", om.valueToTree(this.getInit()));
            }
            if (this.getInitOptions() != null) {
                data.set("initOptions", om.valueToTree(this.getInitOptions()));
            }
            if (this.getInstanceName() != null) {
                data.set("instanceName", om.valueToTree(this.getInstanceName()));
            }
            if (this.getKeyName() != null) {
                data.set("keyName", om.valueToTree(this.getKeyName()));
            }
            if (this.getPrivateIpAddress() != null) {
                data.set("privateIpAddress", om.valueToTree(this.getPrivateIpAddress()));
            }
            if (this.getPropagateTagsToVolumeOnCreation() != null) {
                data.set("propagateTagsToVolumeOnCreation", om.valueToTree(this.getPropagateTagsToVolumeOnCreation()));
            }
            if (this.getRequireImdsv2() != null) {
                data.set("requireImdsv2", om.valueToTree(this.getRequireImdsv2()));
            }
            if (this.getResourceSignalTimeout() != null) {
                data.set("resourceSignalTimeout", om.valueToTree(this.getResourceSignalTimeout()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getSecurityGroup() != null) {
                data.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
            }
            if (this.getSourceDestCheck() != null) {
                data.set("sourceDestCheck", om.valueToTree(this.getSourceDestCheck()));
            }
            if (this.getUserData() != null) {
                data.set("userData", om.valueToTree(this.getUserData()));
            }
            if (this.getUserDataCausesReplacement() != null) {
                data.set("userDataCausesReplacement", om.valueToTree(this.getUserDataCausesReplacement()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.InstanceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InstanceProps.Jsii$Proxy that = (InstanceProps.Jsii$Proxy) o;

            if (!instanceType.equals(that.instanceType)) return false;
            if (!machineImage.equals(that.machineImage)) return false;
            if (!vpc.equals(that.vpc)) return false;
            if (this.allowAllOutbound != null ? !this.allowAllOutbound.equals(that.allowAllOutbound) : that.allowAllOutbound != null) return false;
            if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
            if (this.blockDevices != null ? !this.blockDevices.equals(that.blockDevices) : that.blockDevices != null) return false;
            if (this.detailedMonitoring != null ? !this.detailedMonitoring.equals(that.detailedMonitoring) : that.detailedMonitoring != null) return false;
            if (this.init != null ? !this.init.equals(that.init) : that.init != null) return false;
            if (this.initOptions != null ? !this.initOptions.equals(that.initOptions) : that.initOptions != null) return false;
            if (this.instanceName != null ? !this.instanceName.equals(that.instanceName) : that.instanceName != null) return false;
            if (this.keyName != null ? !this.keyName.equals(that.keyName) : that.keyName != null) return false;
            if (this.privateIpAddress != null ? !this.privateIpAddress.equals(that.privateIpAddress) : that.privateIpAddress != null) return false;
            if (this.propagateTagsToVolumeOnCreation != null ? !this.propagateTagsToVolumeOnCreation.equals(that.propagateTagsToVolumeOnCreation) : that.propagateTagsToVolumeOnCreation != null) return false;
            if (this.requireImdsv2 != null ? !this.requireImdsv2.equals(that.requireImdsv2) : that.requireImdsv2 != null) return false;
            if (this.resourceSignalTimeout != null ? !this.resourceSignalTimeout.equals(that.resourceSignalTimeout) : that.resourceSignalTimeout != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.securityGroup != null ? !this.securityGroup.equals(that.securityGroup) : that.securityGroup != null) return false;
            if (this.sourceDestCheck != null ? !this.sourceDestCheck.equals(that.sourceDestCheck) : that.sourceDestCheck != null) return false;
            if (this.userData != null ? !this.userData.equals(that.userData) : that.userData != null) return false;
            if (this.userDataCausesReplacement != null ? !this.userDataCausesReplacement.equals(that.userDataCausesReplacement) : that.userDataCausesReplacement != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instanceType.hashCode();
            result = 31 * result + (this.machineImage.hashCode());
            result = 31 * result + (this.vpc.hashCode());
            result = 31 * result + (this.allowAllOutbound != null ? this.allowAllOutbound.hashCode() : 0);
            result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
            result = 31 * result + (this.blockDevices != null ? this.blockDevices.hashCode() : 0);
            result = 31 * result + (this.detailedMonitoring != null ? this.detailedMonitoring.hashCode() : 0);
            result = 31 * result + (this.init != null ? this.init.hashCode() : 0);
            result = 31 * result + (this.initOptions != null ? this.initOptions.hashCode() : 0);
            result = 31 * result + (this.instanceName != null ? this.instanceName.hashCode() : 0);
            result = 31 * result + (this.keyName != null ? this.keyName.hashCode() : 0);
            result = 31 * result + (this.privateIpAddress != null ? this.privateIpAddress.hashCode() : 0);
            result = 31 * result + (this.propagateTagsToVolumeOnCreation != null ? this.propagateTagsToVolumeOnCreation.hashCode() : 0);
            result = 31 * result + (this.requireImdsv2 != null ? this.requireImdsv2.hashCode() : 0);
            result = 31 * result + (this.resourceSignalTimeout != null ? this.resourceSignalTimeout.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.securityGroup != null ? this.securityGroup.hashCode() : 0);
            result = 31 * result + (this.sourceDestCheck != null ? this.sourceDestCheck.hashCode() : 0);
            result = 31 * result + (this.userData != null ? this.userData.hashCode() : 0);
            result = 31 * result + (this.userDataCausesReplacement != null ? this.userDataCausesReplacement.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
