package software.amazon.awscdk.services.ecs;

/**
 * A CloudFormation `AWS::ECS::Cluster`.
 * <p>
 * The <code>AWS::ECS::Cluster</code> resource creates an Amazon Elastic Container Service (Amazon ECS) cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * CfnCluster cfnCluster = CfnCluster.Builder.create(this, "MyCfnCluster")
 *         .capacityProviders(List.of("capacityProviders"))
 *         .clusterName("clusterName")
 *         .clusterSettings(List.of(ClusterSettingsProperty.builder()
 *                 .name("name")
 *                 .value("value")
 *                 .build()))
 *         .configuration(ClusterConfigurationProperty.builder()
 *                 .executeCommandConfiguration(ExecuteCommandConfigurationProperty.builder()
 *                         .kmsKeyId("kmsKeyId")
 *                         .logConfiguration(ExecuteCommandLogConfigurationProperty.builder()
 *                                 .cloudWatchEncryptionEnabled(false)
 *                                 .cloudWatchLogGroupName("cloudWatchLogGroupName")
 *                                 .s3BucketName("s3BucketName")
 *                                 .s3EncryptionEnabled(false)
 *                                 .s3KeyPrefix("s3KeyPrefix")
 *                                 .build())
 *                         .logging("logging")
 *                         .build())
 *                 .build())
 *         .defaultCapacityProviderStrategy(List.of(CapacityProviderStrategyItemProperty.builder()
 *                 .base(123)
 *                 .capacityProvider("capacityProvider")
 *                 .weight(123)
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:54.668Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCluster")
public class CfnCluster extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnCluster(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCluster(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecs.CfnCluster.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::ECS::Cluster`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnClusterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::ECS::Cluster`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the Amazon ECS cluster, such as `arn:aws:ecs:us-east-2:123456789012:cluster/MyECSCluster` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The metadata that you apply to the cluster to help you categorize and organize them.
     * <p>
     * Each tag consists of a key and an optional value. You define both.
     * <p>
     * The following basic restrictions apply to tags:
     * <p>
     * <ul>
     * <li>Maximum number of tags per resource - 50</li>
     * <li>For each resource, each tag key must be unique, and each tag key can have only one value.</li>
     * <li>Maximum key length - 128 Unicode characters in UTF-8</li>
     * <li>Maximum value length - 256 Unicode characters in UTF-8</li>
     * <li>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / &#64;.</li>
     * <li>Tag keys and values are case-sensitive.</li>
     * <li>Do not use <code>aws:</code> , <code>AWS:</code> , or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The short name of one or more capacity providers to associate with the cluster.
     * <p>
     * A capacity provider must be associated with a cluster before it can be included as part of the default capacity provider strategy of the cluster or used in a capacity provider strategy.
     * <p>
     * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created and not already associated with another cluster.
     * <p>
     * To use an AWS Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code> capacity providers. The AWS Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCapacityProviders() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "capacityProviders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The short name of one or more capacity providers to associate with the cluster.
     * <p>
     * A capacity provider must be associated with a cluster before it can be included as part of the default capacity provider strategy of the cluster or used in a capacity provider strategy.
     * <p>
     * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created and not already associated with another cluster.
     * <p>
     * To use an AWS Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code> capacity providers. The AWS Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCapacityProviders(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "capacityProviders", value);
    }

    /**
     * A user-generated string that you use to identify your cluster.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID for the name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getClusterName() {
        return software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A user-generated string that you use to identify your cluster.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID for the name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClusterName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "clusterName", value);
    }

    /**
     * The setting to use when creating a cluster.
     * <p>
     * This parameter is used to enable CloudWatch Container Insights for a cluster. If this value is specified, it will override the <code>containerInsights</code> value set with <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSetting.html">PutAccountSetting</a> or <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSettingDefault.html">PutAccountSettingDefault</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getClusterSettings() {
        return software.amazon.jsii.Kernel.get(this, "clusterSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The setting to use when creating a cluster.
     * <p>
     * This parameter is used to enable CloudWatch Container Insights for a cluster. If this value is specified, it will override the <code>containerInsights</code> value set with <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSetting.html">PutAccountSetting</a> or <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSettingDefault.html">PutAccountSettingDefault</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClusterSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "clusterSettings", value);
    }

    /**
     * The setting to use when creating a cluster.
     * <p>
     * This parameter is used to enable CloudWatch Container Insights for a cluster. If this value is specified, it will override the <code>containerInsights</code> value set with <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSetting.html">PutAccountSetting</a> or <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSettingDefault.html">PutAccountSettingDefault</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClusterSettings(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.ecs.CfnCluster.ClusterSettingsProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.ecs.CfnCluster.ClusterSettingsProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "clusterSettings", value);
    }

    /**
     * The execute command configuration for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The execute command configuration for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnCluster.ClusterConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "configuration", value);
    }

    /**
     * The execute command configuration for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "configuration", value);
    }

    /**
     * The default capacity provider strategy for the cluster.
     * <p>
     * When services or tasks are run in the cluster with no launch type or capacity provider strategy specified, the default capacity provider strategy is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDefaultCapacityProviderStrategy() {
        return software.amazon.jsii.Kernel.get(this, "defaultCapacityProviderStrategy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The default capacity provider strategy for the cluster.
     * <p>
     * When services or tasks are run in the cluster with no launch type or capacity provider strategy specified, the default capacity provider strategy is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultCapacityProviderStrategy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "defaultCapacityProviderStrategy", value);
    }

    /**
     * The default capacity provider strategy for the cluster.
     * <p>
     * When services or tasks are run in the cluster with no launch type or capacity provider strategy specified, the default capacity provider strategy is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultCapacityProviderStrategy(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.ecs.CfnCluster.CapacityProviderStrategyItemProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.ecs.CfnCluster.CapacityProviderStrategyItemProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "defaultCapacityProviderStrategy", value);
    }
    /**
     * The `CapacityProviderStrategyItem` property specifies the details of the default capacity provider strategy for the cluster.
     * <p>
     * When services or tasks are run in the cluster with no launch type or capacity provider strategy specified, the default capacity provider strategy is used.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * CapacityProviderStrategyItemProperty capacityProviderStrategyItemProperty = CapacityProviderStrategyItemProperty.builder()
     *         .base(123)
     *         .capacityProvider("capacityProvider")
     *         .weight(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCluster.CapacityProviderStrategyItemProperty")
    @software.amazon.jsii.Jsii.Proxy(CapacityProviderStrategyItemProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CapacityProviderStrategyItemProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The *base* value designates how many tasks, at a minimum, to run on the specified capacity provider.
         * <p>
         * Only one capacity provider in a capacity provider strategy can have a <em>base</em> defined. If no value is specified, the default value of <code>0</code> is used.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBase() {
            return null;
        }

        /**
         * The short name of the capacity provider.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCapacityProvider() {
            return null;
        }

        /**
         * The *weight* value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider.
         * <p>
         * The <code>weight</code> value is taken into consideration after the <code>base</code> value, if defined, is satisfied.
         * <p>
         * If no <code>weight</code> value is specified, the default value of <code>0</code> is used. When multiple capacity providers are specified within a capacity provider strategy, at least one of the capacity providers must have a weight value greater than zero and any capacity providers with a weight of <code>0</code> can't be used to place tasks. If you specify multiple capacity providers in a strategy that all have a weight of <code>0</code> , any <code>RunTask</code> or <code>CreateService</code> actions using the capacity provider strategy will fail.
         * <p>
         * An example scenario for using weights is defining a strategy that contains two capacity providers and both have a weight of <code>1</code> , then when the <code>base</code> is satisfied, the tasks will be split evenly across the two capacity providers. Using that same logic, if you specify a weight of <code>1</code> for <em>capacityProviderA</em> and a weight of <code>4</code> for <em>capacityProviderB</em> , then for every one task that's run using <em>capacityProviderA</em> , four tasks would use <em>capacityProviderB</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWeight() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CapacityProviderStrategyItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CapacityProviderStrategyItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CapacityProviderStrategyItemProperty> {
            java.lang.Number base;
            java.lang.String capacityProvider;
            java.lang.Number weight;

            /**
             * Sets the value of {@link CapacityProviderStrategyItemProperty#getBase}
             * @param base The *base* value designates how many tasks, at a minimum, to run on the specified capacity provider.
             *             Only one capacity provider in a capacity provider strategy can have a <em>base</em> defined. If no value is specified, the default value of <code>0</code> is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder base(java.lang.Number base) {
                this.base = base;
                return this;
            }

            /**
             * Sets the value of {@link CapacityProviderStrategyItemProperty#getCapacityProvider}
             * @param capacityProvider The short name of the capacity provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityProvider(java.lang.String capacityProvider) {
                this.capacityProvider = capacityProvider;
                return this;
            }

            /**
             * Sets the value of {@link CapacityProviderStrategyItemProperty#getWeight}
             * @param weight The *weight* value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider.
             *               The <code>weight</code> value is taken into consideration after the <code>base</code> value, if defined, is satisfied.
             *               <p>
             *               If no <code>weight</code> value is specified, the default value of <code>0</code> is used. When multiple capacity providers are specified within a capacity provider strategy, at least one of the capacity providers must have a weight value greater than zero and any capacity providers with a weight of <code>0</code> can't be used to place tasks. If you specify multiple capacity providers in a strategy that all have a weight of <code>0</code> , any <code>RunTask</code> or <code>CreateService</code> actions using the capacity provider strategy will fail.
             *               <p>
             *               An example scenario for using weights is defining a strategy that contains two capacity providers and both have a weight of <code>1</code> , then when the <code>base</code> is satisfied, the tasks will be split evenly across the two capacity providers. Using that same logic, if you specify a weight of <code>1</code> for <em>capacityProviderA</em> and a weight of <code>4</code> for <em>capacityProviderB</em> , then for every one task that's run using <em>capacityProviderA</em> , four tasks would use <em>capacityProviderB</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weight(java.lang.Number weight) {
                this.weight = weight;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapacityProviderStrategyItemProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CapacityProviderStrategyItemProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CapacityProviderStrategyItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapacityProviderStrategyItemProperty {
            private final java.lang.Number base;
            private final java.lang.String capacityProvider;
            private final java.lang.Number weight;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.base = software.amazon.jsii.Kernel.get(this, "base", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.capacityProvider = software.amazon.jsii.Kernel.get(this, "capacityProvider", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.weight = software.amazon.jsii.Kernel.get(this, "weight", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.base = builder.base;
                this.capacityProvider = builder.capacityProvider;
                this.weight = builder.weight;
            }

            @Override
            public final java.lang.Number getBase() {
                return this.base;
            }

            @Override
            public final java.lang.String getCapacityProvider() {
                return this.capacityProvider;
            }

            @Override
            public final java.lang.Number getWeight() {
                return this.weight;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBase() != null) {
                    data.set("base", om.valueToTree(this.getBase()));
                }
                if (this.getCapacityProvider() != null) {
                    data.set("capacityProvider", om.valueToTree(this.getCapacityProvider()));
                }
                if (this.getWeight() != null) {
                    data.set("weight", om.valueToTree(this.getWeight()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnCluster.CapacityProviderStrategyItemProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CapacityProviderStrategyItemProperty.Jsii$Proxy that = (CapacityProviderStrategyItemProperty.Jsii$Proxy) o;

                if (this.base != null ? !this.base.equals(that.base) : that.base != null) return false;
                if (this.capacityProvider != null ? !this.capacityProvider.equals(that.capacityProvider) : that.capacityProvider != null) return false;
                return this.weight != null ? this.weight.equals(that.weight) : that.weight == null;
            }

            @Override
            public final int hashCode() {
                int result = this.base != null ? this.base.hashCode() : 0;
                result = 31 * result + (this.capacityProvider != null ? this.capacityProvider.hashCode() : 0);
                result = 31 * result + (this.weight != null ? this.weight.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The execute command configuration for the cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ClusterConfigurationProperty clusterConfigurationProperty = ClusterConfigurationProperty.builder()
     *         .executeCommandConfiguration(ExecuteCommandConfigurationProperty.builder()
     *                 .kmsKeyId("kmsKeyId")
     *                 .logConfiguration(ExecuteCommandLogConfigurationProperty.builder()
     *                         .cloudWatchEncryptionEnabled(false)
     *                         .cloudWatchLogGroupName("cloudWatchLogGroupName")
     *                         .s3BucketName("s3BucketName")
     *                         .s3EncryptionEnabled(false)
     *                         .s3KeyPrefix("s3KeyPrefix")
     *                         .build())
     *                 .logging("logging")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCluster.ClusterConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ClusterConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClusterConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The details of the execute command configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExecuteCommandConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClusterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClusterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClusterConfigurationProperty> {
            java.lang.Object executeCommandConfiguration;

            /**
             * Sets the value of {@link ClusterConfigurationProperty#getExecuteCommandConfiguration}
             * @param executeCommandConfiguration The details of the execute command configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executeCommandConfiguration(software.amazon.awscdk.services.ecs.CfnCluster.ExecuteCommandConfigurationProperty executeCommandConfiguration) {
                this.executeCommandConfiguration = executeCommandConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigurationProperty#getExecuteCommandConfiguration}
             * @param executeCommandConfiguration The details of the execute command configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executeCommandConfiguration(software.amazon.awscdk.IResolvable executeCommandConfiguration) {
                this.executeCommandConfiguration = executeCommandConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClusterConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClusterConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClusterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterConfigurationProperty {
            private final java.lang.Object executeCommandConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.executeCommandConfiguration = software.amazon.jsii.Kernel.get(this, "executeCommandConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.executeCommandConfiguration = builder.executeCommandConfiguration;
            }

            @Override
            public final java.lang.Object getExecuteCommandConfiguration() {
                return this.executeCommandConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExecuteCommandConfiguration() != null) {
                    data.set("executeCommandConfiguration", om.valueToTree(this.getExecuteCommandConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnCluster.ClusterConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClusterConfigurationProperty.Jsii$Proxy that = (ClusterConfigurationProperty.Jsii$Proxy) o;

                return this.executeCommandConfiguration != null ? this.executeCommandConfiguration.equals(that.executeCommandConfiguration) : that.executeCommandConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.executeCommandConfiguration != null ? this.executeCommandConfiguration.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The settings to use when creating a cluster.
     * <p>
     * This parameter is used to turn on CloudWatch Container Insights for a cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ClusterSettingsProperty clusterSettingsProperty = ClusterSettingsProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCluster.ClusterSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(ClusterSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClusterSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the cluster setting.
         * <p>
         * The only supported value is <code>containerInsights</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The value to set for the cluster setting.
         * <p>
         * The supported values are <code>enabled</code> and <code>disabled</code> . If <code>enabled</code> is specified, CloudWatch Container Insights will be enabled for the cluster, otherwise it will be disabled unless the <code>containerInsights</code> account setting is enabled. If a cluster value is specified, it will override the <code>containerInsights</code> value set with <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSetting.html">PutAccountSetting</a> or <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSettingDefault.html">PutAccountSettingDefault</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClusterSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClusterSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClusterSettingsProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link ClusterSettingsProperty#getName}
             * @param name The name of the cluster setting.
             *             The only supported value is <code>containerInsights</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ClusterSettingsProperty#getValue}
             * @param value The value to set for the cluster setting.
             *              The supported values are <code>enabled</code> and <code>disabled</code> . If <code>enabled</code> is specified, CloudWatch Container Insights will be enabled for the cluster, otherwise it will be disabled unless the <code>containerInsights</code> account setting is enabled. If a cluster value is specified, it will override the <code>containerInsights</code> value set with <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSetting.html">PutAccountSetting</a> or <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSettingDefault.html">PutAccountSettingDefault</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClusterSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClusterSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClusterSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterSettingsProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnCluster.ClusterSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClusterSettingsProperty.Jsii$Proxy that = (ClusterSettingsProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The details of the execute command configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ExecuteCommandConfigurationProperty executeCommandConfigurationProperty = ExecuteCommandConfigurationProperty.builder()
     *         .kmsKeyId("kmsKeyId")
     *         .logConfiguration(ExecuteCommandLogConfigurationProperty.builder()
     *                 .cloudWatchEncryptionEnabled(false)
     *                 .cloudWatchLogGroupName("cloudWatchLogGroupName")
     *                 .s3BucketName("s3BucketName")
     *                 .s3EncryptionEnabled(false)
     *                 .s3KeyPrefix("s3KeyPrefix")
     *                 .build())
     *         .logging("logging")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCluster.ExecuteCommandConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ExecuteCommandConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExecuteCommandConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specify an AWS Key Management Service key ID to encrypt the data between the local client and the container.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * The log configuration for the results of the execute command actions.
         * <p>
         * The logs can be sent to CloudWatch Logs or an Amazon S3 bucket. When <code>logging=OVERRIDE</code> is specified, a <code>logConfiguration</code> must be provided.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLogConfiguration() {
            return null;
        }

        /**
         * The log setting to use for redirecting logs for your execute command results. The following log settings are available.
         * <p>
         * <ul>
         * <li><code>NONE</code> : The execute command session is not logged.</li>
         * <li><code>DEFAULT</code> : The <code>awslogs</code> configuration in the task definition is used. If no logging parameter is specified, it defaults to this value. If no <code>awslogs</code> log driver is configured in the task definition, the output won't be logged.</li>
         * <li><code>OVERRIDE</code> : Specify the logging details as a part of <code>logConfiguration</code> . If the <code>OVERRIDE</code> logging option is specified, the <code>logConfiguration</code> is required.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogging() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExecuteCommandConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExecuteCommandConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExecuteCommandConfigurationProperty> {
            java.lang.String kmsKeyId;
            java.lang.Object logConfiguration;
            java.lang.String logging;

            /**
             * Sets the value of {@link ExecuteCommandConfigurationProperty#getKmsKeyId}
             * @param kmsKeyId Specify an AWS Key Management Service key ID to encrypt the data between the local client and the container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Sets the value of {@link ExecuteCommandConfigurationProperty#getLogConfiguration}
             * @param logConfiguration The log configuration for the results of the execute command actions.
             *                         The logs can be sent to CloudWatch Logs or an Amazon S3 bucket. When <code>logging=OVERRIDE</code> is specified, a <code>logConfiguration</code> must be provided.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logConfiguration(software.amazon.awscdk.services.ecs.CfnCluster.ExecuteCommandLogConfigurationProperty logConfiguration) {
                this.logConfiguration = logConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ExecuteCommandConfigurationProperty#getLogConfiguration}
             * @param logConfiguration The log configuration for the results of the execute command actions.
             *                         The logs can be sent to CloudWatch Logs or an Amazon S3 bucket. When <code>logging=OVERRIDE</code> is specified, a <code>logConfiguration</code> must be provided.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logConfiguration(software.amazon.awscdk.IResolvable logConfiguration) {
                this.logConfiguration = logConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ExecuteCommandConfigurationProperty#getLogging}
             * @param logging The log setting to use for redirecting logs for your execute command results. The following log settings are available.
             *                <ul>
             *                <li><code>NONE</code> : The execute command session is not logged.</li>
             *                <li><code>DEFAULT</code> : The <code>awslogs</code> configuration in the task definition is used. If no logging parameter is specified, it defaults to this value. If no <code>awslogs</code> log driver is configured in the task definition, the output won't be logged.</li>
             *                <li><code>OVERRIDE</code> : Specify the logging details as a part of <code>logConfiguration</code> . If the <code>OVERRIDE</code> logging option is specified, the <code>logConfiguration</code> is required.</li>
             *                </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logging(java.lang.String logging) {
                this.logging = logging;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExecuteCommandConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExecuteCommandConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExecuteCommandConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExecuteCommandConfigurationProperty {
            private final java.lang.String kmsKeyId;
            private final java.lang.Object logConfiguration;
            private final java.lang.String logging;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logConfiguration = software.amazon.jsii.Kernel.get(this, "logConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.logging = software.amazon.jsii.Kernel.get(this, "logging", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.kmsKeyId = builder.kmsKeyId;
                this.logConfiguration = builder.logConfiguration;
                this.logging = builder.logging;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            public final java.lang.Object getLogConfiguration() {
                return this.logConfiguration;
            }

            @Override
            public final java.lang.String getLogging() {
                return this.logging;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }
                if (this.getLogConfiguration() != null) {
                    data.set("logConfiguration", om.valueToTree(this.getLogConfiguration()));
                }
                if (this.getLogging() != null) {
                    data.set("logging", om.valueToTree(this.getLogging()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnCluster.ExecuteCommandConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExecuteCommandConfigurationProperty.Jsii$Proxy that = (ExecuteCommandConfigurationProperty.Jsii$Proxy) o;

                if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
                if (this.logConfiguration != null ? !this.logConfiguration.equals(that.logConfiguration) : that.logConfiguration != null) return false;
                return this.logging != null ? this.logging.equals(that.logging) : that.logging == null;
            }

            @Override
            public final int hashCode() {
                int result = this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0;
                result = 31 * result + (this.logConfiguration != null ? this.logConfiguration.hashCode() : 0);
                result = 31 * result + (this.logging != null ? this.logging.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The log configuration for the results of the execute command actions.
     * <p>
     * The logs can be sent to CloudWatch Logs or an Amazon S3 bucket.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ExecuteCommandLogConfigurationProperty executeCommandLogConfigurationProperty = ExecuteCommandLogConfigurationProperty.builder()
     *         .cloudWatchEncryptionEnabled(false)
     *         .cloudWatchLogGroupName("cloudWatchLogGroupName")
     *         .s3BucketName("s3BucketName")
     *         .s3EncryptionEnabled(false)
     *         .s3KeyPrefix("s3KeyPrefix")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCluster.ExecuteCommandLogConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ExecuteCommandLogConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExecuteCommandLogConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines whether to use encryption on the CloudWatch logs.
         * <p>
         * If not specified, encryption will be disabled.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchEncryptionEnabled() {
            return null;
        }

        /**
         * The name of the CloudWatch log group to send logs to.
         * <p>
         * <blockquote>
         * <p>
         * The CloudWatch log group must already be created.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCloudWatchLogGroupName() {
            return null;
        }

        /**
         * The name of the S3 bucket to send logs to.
         * <p>
         * <blockquote>
         * <p>
         * The S3 bucket must already be created.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BucketName() {
            return null;
        }

        /**
         * Determines whether to use encryption on the S3 logs.
         * <p>
         * If not specified, encryption is not used.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3EncryptionEnabled() {
            return null;
        }

        /**
         * An optional folder in the S3 bucket to place logs in.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3KeyPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExecuteCommandLogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExecuteCommandLogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExecuteCommandLogConfigurationProperty> {
            java.lang.Object cloudWatchEncryptionEnabled;
            java.lang.String cloudWatchLogGroupName;
            java.lang.String s3BucketName;
            java.lang.Object s3EncryptionEnabled;
            java.lang.String s3KeyPrefix;

            /**
             * Sets the value of {@link ExecuteCommandLogConfigurationProperty#getCloudWatchEncryptionEnabled}
             * @param cloudWatchEncryptionEnabled Determines whether to use encryption on the CloudWatch logs.
             *                                    If not specified, encryption will be disabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchEncryptionEnabled(java.lang.Boolean cloudWatchEncryptionEnabled) {
                this.cloudWatchEncryptionEnabled = cloudWatchEncryptionEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ExecuteCommandLogConfigurationProperty#getCloudWatchEncryptionEnabled}
             * @param cloudWatchEncryptionEnabled Determines whether to use encryption on the CloudWatch logs.
             *                                    If not specified, encryption will be disabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchEncryptionEnabled(software.amazon.awscdk.IResolvable cloudWatchEncryptionEnabled) {
                this.cloudWatchEncryptionEnabled = cloudWatchEncryptionEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ExecuteCommandLogConfigurationProperty#getCloudWatchLogGroupName}
             * @param cloudWatchLogGroupName The name of the CloudWatch log group to send logs to.
             *                               <blockquote>
             *                               <p>
             *                               The CloudWatch log group must already be created.
             *                               <p>
             *                               </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogGroupName(java.lang.String cloudWatchLogGroupName) {
                this.cloudWatchLogGroupName = cloudWatchLogGroupName;
                return this;
            }

            /**
             * Sets the value of {@link ExecuteCommandLogConfigurationProperty#getS3BucketName}
             * @param s3BucketName The name of the S3 bucket to send logs to.
             *                     <blockquote>
             *                     <p>
             *                     The S3 bucket must already be created.
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BucketName(java.lang.String s3BucketName) {
                this.s3BucketName = s3BucketName;
                return this;
            }

            /**
             * Sets the value of {@link ExecuteCommandLogConfigurationProperty#getS3EncryptionEnabled}
             * @param s3EncryptionEnabled Determines whether to use encryption on the S3 logs.
             *                            If not specified, encryption is not used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3EncryptionEnabled(java.lang.Boolean s3EncryptionEnabled) {
                this.s3EncryptionEnabled = s3EncryptionEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ExecuteCommandLogConfigurationProperty#getS3EncryptionEnabled}
             * @param s3EncryptionEnabled Determines whether to use encryption on the S3 logs.
             *                            If not specified, encryption is not used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3EncryptionEnabled(software.amazon.awscdk.IResolvable s3EncryptionEnabled) {
                this.s3EncryptionEnabled = s3EncryptionEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ExecuteCommandLogConfigurationProperty#getS3KeyPrefix}
             * @param s3KeyPrefix An optional folder in the S3 bucket to place logs in.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3KeyPrefix(java.lang.String s3KeyPrefix) {
                this.s3KeyPrefix = s3KeyPrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExecuteCommandLogConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExecuteCommandLogConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExecuteCommandLogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExecuteCommandLogConfigurationProperty {
            private final java.lang.Object cloudWatchEncryptionEnabled;
            private final java.lang.String cloudWatchLogGroupName;
            private final java.lang.String s3BucketName;
            private final java.lang.Object s3EncryptionEnabled;
            private final java.lang.String s3KeyPrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchEncryptionEnabled = software.amazon.jsii.Kernel.get(this, "cloudWatchEncryptionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cloudWatchLogGroupName = software.amazon.jsii.Kernel.get(this, "cloudWatchLogGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3BucketName = software.amazon.jsii.Kernel.get(this, "s3BucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3EncryptionEnabled = software.amazon.jsii.Kernel.get(this, "s3EncryptionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3KeyPrefix = software.amazon.jsii.Kernel.get(this, "s3KeyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchEncryptionEnabled = builder.cloudWatchEncryptionEnabled;
                this.cloudWatchLogGroupName = builder.cloudWatchLogGroupName;
                this.s3BucketName = builder.s3BucketName;
                this.s3EncryptionEnabled = builder.s3EncryptionEnabled;
                this.s3KeyPrefix = builder.s3KeyPrefix;
            }

            @Override
            public final java.lang.Object getCloudWatchEncryptionEnabled() {
                return this.cloudWatchEncryptionEnabled;
            }

            @Override
            public final java.lang.String getCloudWatchLogGroupName() {
                return this.cloudWatchLogGroupName;
            }

            @Override
            public final java.lang.String getS3BucketName() {
                return this.s3BucketName;
            }

            @Override
            public final java.lang.Object getS3EncryptionEnabled() {
                return this.s3EncryptionEnabled;
            }

            @Override
            public final java.lang.String getS3KeyPrefix() {
                return this.s3KeyPrefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCloudWatchEncryptionEnabled() != null) {
                    data.set("cloudWatchEncryptionEnabled", om.valueToTree(this.getCloudWatchEncryptionEnabled()));
                }
                if (this.getCloudWatchLogGroupName() != null) {
                    data.set("cloudWatchLogGroupName", om.valueToTree(this.getCloudWatchLogGroupName()));
                }
                if (this.getS3BucketName() != null) {
                    data.set("s3BucketName", om.valueToTree(this.getS3BucketName()));
                }
                if (this.getS3EncryptionEnabled() != null) {
                    data.set("s3EncryptionEnabled", om.valueToTree(this.getS3EncryptionEnabled()));
                }
                if (this.getS3KeyPrefix() != null) {
                    data.set("s3KeyPrefix", om.valueToTree(this.getS3KeyPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnCluster.ExecuteCommandLogConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExecuteCommandLogConfigurationProperty.Jsii$Proxy that = (ExecuteCommandLogConfigurationProperty.Jsii$Proxy) o;

                if (this.cloudWatchEncryptionEnabled != null ? !this.cloudWatchEncryptionEnabled.equals(that.cloudWatchEncryptionEnabled) : that.cloudWatchEncryptionEnabled != null) return false;
                if (this.cloudWatchLogGroupName != null ? !this.cloudWatchLogGroupName.equals(that.cloudWatchLogGroupName) : that.cloudWatchLogGroupName != null) return false;
                if (this.s3BucketName != null ? !this.s3BucketName.equals(that.s3BucketName) : that.s3BucketName != null) return false;
                if (this.s3EncryptionEnabled != null ? !this.s3EncryptionEnabled.equals(that.s3EncryptionEnabled) : that.s3EncryptionEnabled != null) return false;
                return this.s3KeyPrefix != null ? this.s3KeyPrefix.equals(that.s3KeyPrefix) : that.s3KeyPrefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatchEncryptionEnabled != null ? this.cloudWatchEncryptionEnabled.hashCode() : 0;
                result = 31 * result + (this.cloudWatchLogGroupName != null ? this.cloudWatchLogGroupName.hashCode() : 0);
                result = 31 * result + (this.s3BucketName != null ? this.s3BucketName.hashCode() : 0);
                result = 31 * result + (this.s3EncryptionEnabled != null ? this.s3EncryptionEnabled.hashCode() : 0);
                result = 31 * result + (this.s3KeyPrefix != null ? this.s3KeyPrefix.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.CfnCluster}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.CfnCluster> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ecs.CfnClusterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The short name of one or more capacity providers to associate with the cluster.
         * <p>
         * A capacity provider must be associated with a cluster before it can be included as part of the default capacity provider strategy of the cluster or used in a capacity provider strategy.
         * <p>
         * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created and not already associated with another cluster.
         * <p>
         * To use an AWS Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code> capacity providers. The AWS Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.
         * <p>
         * @return {@code this}
         * @param capacityProviders The short name of one or more capacity providers to associate with the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityProviders(final java.util.List<java.lang.String> capacityProviders) {
            this.props().capacityProviders(capacityProviders);
            return this;
        }

        /**
         * A user-generated string that you use to identify your cluster.
         * <p>
         * If you don't specify a name, AWS CloudFormation generates a unique physical ID for the name.
         * <p>
         * @return {@code this}
         * @param clusterName A user-generated string that you use to identify your cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(final java.lang.String clusterName) {
            this.props().clusterName(clusterName);
            return this;
        }

        /**
         * The setting to use when creating a cluster.
         * <p>
         * This parameter is used to enable CloudWatch Container Insights for a cluster. If this value is specified, it will override the <code>containerInsights</code> value set with <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSetting.html">PutAccountSetting</a> or <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSettingDefault.html">PutAccountSettingDefault</a> .
         * <p>
         * @return {@code this}
         * @param clusterSettings The setting to use when creating a cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterSettings(final software.amazon.awscdk.IResolvable clusterSettings) {
            this.props().clusterSettings(clusterSettings);
            return this;
        }
        /**
         * The setting to use when creating a cluster.
         * <p>
         * This parameter is used to enable CloudWatch Container Insights for a cluster. If this value is specified, it will override the <code>containerInsights</code> value set with <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSetting.html">PutAccountSetting</a> or <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSettingDefault.html">PutAccountSettingDefault</a> .
         * <p>
         * @return {@code this}
         * @param clusterSettings The setting to use when creating a cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterSettings(final java.util.List<? extends java.lang.Object> clusterSettings) {
            this.props().clusterSettings(clusterSettings);
            return this;
        }

        /**
         * The execute command configuration for the cluster.
         * <p>
         * @return {@code this}
         * @param configuration The execute command configuration for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final software.amazon.awscdk.services.ecs.CfnCluster.ClusterConfigurationProperty configuration) {
            this.props().configuration(configuration);
            return this;
        }
        /**
         * The execute command configuration for the cluster.
         * <p>
         * @return {@code this}
         * @param configuration The execute command configuration for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final software.amazon.awscdk.IResolvable configuration) {
            this.props().configuration(configuration);
            return this;
        }

        /**
         * The default capacity provider strategy for the cluster.
         * <p>
         * When services or tasks are run in the cluster with no launch type or capacity provider strategy specified, the default capacity provider strategy is used.
         * <p>
         * @return {@code this}
         * @param defaultCapacityProviderStrategy The default capacity provider strategy for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCapacityProviderStrategy(final software.amazon.awscdk.IResolvable defaultCapacityProviderStrategy) {
            this.props().defaultCapacityProviderStrategy(defaultCapacityProviderStrategy);
            return this;
        }
        /**
         * The default capacity provider strategy for the cluster.
         * <p>
         * When services or tasks are run in the cluster with no launch type or capacity provider strategy specified, the default capacity provider strategy is used.
         * <p>
         * @return {@code this}
         * @param defaultCapacityProviderStrategy The default capacity provider strategy for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCapacityProviderStrategy(final java.util.List<? extends java.lang.Object> defaultCapacityProviderStrategy) {
            this.props().defaultCapacityProviderStrategy(defaultCapacityProviderStrategy);
            return this;
        }

        /**
         * The metadata that you apply to the cluster to help you categorize and organize them.
         * <p>
         * Each tag consists of a key and an optional value. You define both.
         * <p>
         * The following basic restrictions apply to tags:
         * <p>
         * <ul>
         * <li>Maximum number of tags per resource - 50</li>
         * <li>For each resource, each tag key must be unique, and each tag key can have only one value.</li>
         * <li>Maximum key length - 128 Unicode characters in UTF-8</li>
         * <li>Maximum value length - 256 Unicode characters in UTF-8</li>
         * <li>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / &#64;.</li>
         * <li>Tag keys and values are case-sensitive.</li>
         * <li>Do not use <code>aws:</code> , <code>AWS:</code> , or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param tags The metadata that you apply to the cluster to help you categorize and organize them. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ecs.CfnCluster}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.CfnCluster build() {
            return new software.amazon.awscdk.services.ecs.CfnCluster(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ecs.CfnClusterProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ecs.CfnClusterProps.Builder();
            }
            return this.props;
        }
    }
}
